# Generated by default/object.tt
package Paws::ElastiCache::GlobalNodeGroup;
  use Moose;
  has GlobalNodeGroupId => (is => 'ro', isa => 'Str');
  has Slots => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::ElastiCache::GlobalNodeGroup

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ElastiCache::GlobalNodeGroup object:

  $service_obj->Method(Att1 => { GlobalNodeGroupId => $value, ..., Slots => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ElastiCache::GlobalNodeGroup object:

  $result = $service_obj->Method(...);
  $result->Att1->GlobalNodeGroupId

=head1 DESCRIPTION

Indicates the slot configuration and global identifier for a slice
group.

=head1 ATTRIBUTES


=head2 GlobalNodeGroupId => Str

The name of the global node group


=head2 Slots => Str

The keyspace for this node group



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ElastiCache>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

