## no critic qw(RequirePodSections)    # -*- cperl -*-
# This file is auto-generated by the Perl TeX::Hyphen::Pattern Suite hyphen
# pattern catalog generator. This code generator comes with the
# TeX::Hyphen::Pattern module distribution in the tools/ directory
#
# Do not edit this file directly.

package TeX::Hyphen::Pattern::La_x_classic v1.1.7;
use strict;
use warnings;
use 5.014000;
use utf8;

use Moose;

my $pattern_file = q{};
while (<DATA>) {
    $pattern_file .= $_;
}

sub pattern_data {
    return $pattern_file;
}

sub version {
    return $TeX::Hyphen::Pattern::La_x_classic::VERSION;
}

1;
## no critic qw(RequirePodAtEnd RequireASCII ProhibitFlagComments)

=encoding utf8

=for stopwords CTAN Ipenburg La_x_classic

=head1 NAME

TeX::Hyphen::Pattern::La_x_classic - class for hyphenation in locale La_x_classic

=head1 SUBROUTINES/METHODS

=over 4

=item $pattern-E<gt>pattern_data();

Returns the pattern data.

=item $pattern-E<gt>version();

Returns the version of the pattern package.

=back

=head1 COPYRIGHT

=begin text

title: Hyphenation patterns for classical Latin
copyright: Copyright (C) 2019 Keno Wehr
notice: This file is part of the hyph-utf8 package.
    See http://www.hyphenation.org/tex for more information.
    These patterns are also suitable for medieval and modern Latin if German
    or Slavic pronunciation is used.
    See https://github.com/gregorio-project/hyphen-la/tree/master/doc for
    documentation.
source: https://github.com/gregorio-project/hyphen-la/tree/master/patterns/generation
language:
    name: Classical Latin
    tag: la-x-classic
version: 2.0 2019-07-03
authors:
 -
    name: Claudio Beccari
 -
    name: Keno Wehr
    contact: wehr (at) abgol.de
licence:
    name: MIT
    url:  http://opensource.org/licenses/MIT
    text: >
          Permission is hereby granted, free of charge, to any person
          obtaining a copy of this software and associated documentation
          files (the "Software"), to deal in the Software without
          restriction, including without limitation the rights to use,
          copy, modify, merge, publish, distribute, sublicense, and/or
          sell copies of the Software, and to permit persons to whom the
          Software is furnished to do so, subject to the following
          conditions:

          The above copyright notice and this permission notice shall be
          included in all copies or substantial portions of the Software.

          THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
          EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES
          OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
          NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
          HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
          WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
          FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR
          OTHER DEALINGS IN THE SOFTWARE.
hyphenmins:
    generation:
        left: 2
        right: 2
    typesetting:
        left: 2
        right: 2
texlive:
    encoding: ec
    babelname: classiclatin
    legacy_patterns: hyph-la-x-classic.ec.tex
    use_old_patterns_comment: (Not-so-old) pTeX-converted file is now hardcoded
    message: Classical Latin hyphenation patterns, v.2.0 2019-07-03
    package: latin
changes:
 -
    date: 2014-10-06
    version: 1.2
    author: Claudio Beccari
 -
    date: 2019-07-03
    version: 2.0
    author: Keno Wehr
    description: patgen-based pattern generation; improved support of
        compound words; do not hyphenate Roman numerals; support of v and j
        spellings, ae/oe ligatures, accents, macrons, breves, and ties

==========================================

The following patgen parameters have been used:

  1 1 | 1 3 | 2 3 1
  2 2 | 2 4 | 1 5 1
  3 3 | 3 5 | 1 6 1
  4 4 | 4 6 | 1 7 1
  5 5 | 5 11 | 1 8 1
  6 6 | 6 11 | 1 9 1
  7 7 | 7 11 | 1 9 1

=end text

=cut

__DATA__
\patterns{
.ab1
.aba2
.ab3a4u
.aba4v
.ab3áu
.ab3áv
.abe4
.ab3es
.abé2
.ab3és
.abi2
.ab3i4n
.ab3is
.ab3it
.abi4u
.abi4v
.abī2
.abī4n
.abī́4
.abí2
.ab3í4n
.ab3ís
.abí4t
.abo2
.abó2
.ab5us
.ab3ú
.ad3ā
.ad3á
.adǣ́4
.adǽ2
.ade4
.ad3es
.ad3ē2
.adḗ4
.adé2
.ad3ér
.ad3és
.ad3ib
.ad3i4c
.ad3ie
.ad3ié
.adi4m
.ad5i4n
.ad3i4q
.ad3is
.ad5i4t
.adi4u
.ad3i4v
.ad3ī4
.adī́4
.adí4c
.adí4m
.ad3í4n
.ad3í4q
.ad3ís
.adí4t
.ad3í4u
.ad3í4v
.ad6ora.
.ad6orane
.ad6oraq
.ad6oraue.
.ad6orave.
.ad5ṓro
.ad5ṓ6rō
.ad6ó6ra.
.adó4ro
.adú2
.ae2a
.ae2ă3
.ae4st
.ae5te
.ag2n
.aī3b
.aī́3b
.aí2
.aí3b
.am4b3ē
.am4bi.
.am4b5i4n
.am4b5i4q
.am6b5is.
.am6b5isn
.am6b5isq
.am6b5isu
.am6b5isv
.ambi6ue
.amb6iui.
.amb6iuin
.amb6iuiq
.amb6iuiu
.amb6iuín
.amb6iuíq
.amb6iuíu
.ambi6ve
.amb6ivi.
.amb6ivin
.amb6iviq
.amb6iviv
.amb6ivín
.amb6ivíq
.amb6ivív
.ambī4n
.ambī́6n
.am4b5í4n
.am4bí4q
.am4b5ís
.am6bí6ue
.am6bí6ve
.am4b3ú
.an6t5ea.
.ante5i4
.ante5í4
.as4ce
.as4cé
.as4ta
.as4tá
.as4te
.as4té
.as4to
.as4tō
.as4tó
.as6trar
.as6trat
.as4trā
.as6trár
.as6trás
.as4tru
.as4trū
.ate2
.atē2
.a͞e4ă
.a͞e4s5t
.a͡e4ă
.a͡e4s5t
.á͡e4s5
.āg2
.ā́2
.ā́g2
.ā́4l
.ā́4t
.ăbă2
.ăbă4u
.ăbă4v
.ăbĕ4
.ăbĕ́4
.ăbī2
.ăbī4q
.ăbī́4
.ăbĭ2
.ăb3ĭt
.ăbĭ́4
.ăbŏ́4
.ăd3ā
.ăd3á
.ădæ4
.ădǣ4
.ădǣ́4
.ădǽ4
.ăd3ē2
.ădḗ4
.ădĕ4
.ădĕ́4
.ăd3ī4
.ădī́4
.ăd3ĭē
.ăd3ĭĕ
.ăd3ĭī
.ădĭ4m
.ăd3ĭ4t
.ădĭ́4t
.ăd5ṓ6rō
.ăd5ṓrŏ
.ăd3ŭ́
.ăī3b
.ăī́3b
.ăm4b3ē
.ămbī4q
.ămbī́6q
.ăm4b5ŭ́
.ăs4pĭ
.ăs4tă
.ăs4tĭ
.ăs4tō
.ăs4trā
.ăs4trū
.ắ2
.ắb5ă4u
.ắb5ă4v
.ắb3ĕ4
.ắbĭ4
.ắb5ĭt
.ắb3ŏ
.ắ4c
.ắd3ē
.ắd3ĕ4
.ắd3ī
.ắd5ĭē
.ắd5ĭī
.ắd5ĭ4t
.ắ4g
.ắ4ĭ
.ắ4l
.ắ4r
.ắ4s
.ắs4tā
.ắs4tă
.ắs4tĕ
.ắs4tō
.ắ4t
.áb1
.ába2
.áb3a4u
.áb3a4v
.áb3e4
.ábi2
.áb3is
.áb3it
.áb3o
.ád1
.áde2
.ád3es
.ád3ē
.ádi2
.ád3ie
.ád3is
.ád3it
.ád3ī
.áes3
.áes5t
.ág4nit
.ám4bi.
.ám4b5is
.án4ter
.ás4ta
.ás4tā
.ás4te
.ás4to
.ás4tō
.ás4tru
.æs3t
.ǣs3t
.ǣ́2
.ǣ́4q
.ǣ́s3
.ǽs3
.ba3g
.ba6iane.
.ba6iáne.
.ba4ii
.ba4iī
.bā́3
.bá4iī
.bi3
.bĭ1
.bĭ3ĕ
.ca2i
.cá2i
.cen3s
.cēn3s
.ci6sta
.ci6sté
.co3i4
.co3í4
.com5ēs
.com5ḗs
.co4més
.co4n5i4c
.co4ní4c
.cŏ3ĭ
.cŏm5ēs
.cŏm5ḗs
.cŏm3ĕ
.cŏ4n5ĭ4c
.cŏ6n5ĭ́6c
.cŏ́3ĭ
.cŏ́4m3
.cŏ́mĭ4
.cŏ́6n5ĭ6c
.có3i
.có4mit
.cómi6te
.có4n5i4c
.de3d
.de4met
.des2
.de5u4ta
.de5u4tá
.de5utí
.dēs2
.dē3sc
.dē3sú
.dḗ3i
.dḗ5sum
.dĕ1
.dĕ3d
.dĕ3ŏ
.dé3s2
.di3gé
.di4r5e4m
.di4r5é4m
.dis6cendam
.dis6cendas
.dis6cendám
.dis6cendás
.dis6cendi
.dis6cendí
.dis6cendo.
.dis6cendon
.dis6cendoq
.dis6cendou
.dis6cendov
.dis6cendón
.dis6cendóq
.dis6cendóu
.dis6cendóv
.dis6céndam
.dis6céndas
.dis6cénde
.dis6céndi
.dis6céndo.
.di5s6tau
.di5s6tav
.dis4tá
.di5s4tī
.dī1
.dīs4t
.dĭ5s4tă
.dĭ5s4tī
.do3l
.dó3l
.ed2
.ed4i
.ed4o
.ed4u
.ei2
.er2e
.ere5x4
.et3i
.ex3ā
.ex3á
.ex3éq
.ex3i4
.ex3ī4
.exī́4
.ex3í4
.ex5ṓr
.ex3ón
.ex3u4
.exū2
.exū́4
.exú2
.ēs3tĭ
.ḗ2
.ĕd2
.ĕd4ĭ
.ĕt3ĭ
.ĕx3ā
.ĕx3ī4
.ĕxī́4
.ĕx3ĭ2
.ĕxĭ́4
.ĕx5ṓr
.ĕxū2
.ĕxū́4
.ĕx3ŭ
.ĕ́2
.ĕ́4c
.ĕ́4q
.ĕ́4t
.ĕ́t3ĭ
.ĕ́x3ī
.ĕ́x3ĭ4
.ĕ́x3ŭ
.ét3e2
.ét3i
.éx3eq
.éx3i2
.éx3u
.gé1
.hemi3
.hḗ3
.hi6ste
.hi6str
.hĭ6stĕ
.ho4s
.ibe3
.id3eo
.id3eō
.id3í
.id3ue
.ie3su
.ié3su
.ig2
.ig3ne
.ig3ni
.ig3nī
.ig3ní
.in1
.in3a4
.in3ā4
.inā́4
.iná4
.in3e4
.inē2
.inḗ4
.in3é2
.in3i4
.inī4
.inī́4
.in3í4
.in3o4
.inó4
.in3t
.inte6re6ri
.inte6re6rí
.inte6res
.inte6rés
.inte6ri.
.inte6riq
.inte6ris
.inte6rí6n
.inte6rí6q
.inte6rís
.inte6rí6t
.inté6re6ri
.inté6ri6te
.inté6ri6ti
.inté6ri6to.
.inté6ri6tō
.inu4d
.in3ue
.in3ui
.in3uī
.in3uí
.in3us
.inū́4
.inú4d
.io3s4
.io5su
.ió3s2
.is5ta
.is5tā
.is5te
.is5ti
.is5tí
.is3tr
.ī́2
.ī́4b
.ī́4m
.ī́4n
.ī́4q
.ī́4t
.ĭd3ĕō
.ĭg2
.ĭg3nĕ
.ĭg3nī
.ĭn1
.ĭn3ā4
.ĭnā́4
.ĭnḗ4
.ĭnĕ4
.ĭnĕ́4
.ĭnī4
.ĭnī́4
.ĭn3ĭ2
.ĭnĭ́4
.ĭntĕ6rĭt.
.ĭntĕ6rĭ6tĕ
.ĭntĕ6rĭtn
.ĭntĕ6rĭ6tō.
.ĭntĕ6rĭ6tōn
.ĭntĕ6rĭ6tōq
.ĭntĕ6rĭ6tōu
.ĭntĕ6rĭ6tōv
.ĭntĕ6rĭ6tṓn
.ĭntĕ6rĭ6tṓq
.ĭntĕ6rĭ6tṓu
.ĭntĕ6rĭ6tṓv
.ĭntĕ6rĭtq
.ĭntĕ6rĭtu
.ĭntĕ6rĭtv
.ĭntĕ6rĭ́6t
.ĭntĕ́6rĕ6rĭ
.ĭntĕ́6rĭ6tĕ
.ĭntĕ́6rĭ6tō
.ĭnū́4
.ĭn3ŭs
.ĭs5tā
.ĭs5tă
.ĭs5tĕ
.ĭs5tĭ
.ĭ́2
.ĭ́d5ĕō
.ĭ́4n
.ĭ́n3ĕ4
.ĭ́n3ĭ4
.ĭ́n5ŭĕ
.ĭ́n5ŭī
.ĭ́n5ŭō
.íd3eo
.íd3eō
.íd3ue
.ín1
.ín3e2
.ín3i2
.ín3t
.ín3ui
.jo3s4
.jo5su
.jó3s2
.li4g5n
.líg3n
.lí3t
.ma3ge
.magnæ6u
.magnæ6v
.magnǣ6u
.magnǣ6v
.magnǣ́6u
.magnǣ́6v
.magnǽ6u
.magnǽ6v
.mă3gĕ
.măgnæ6u
.măgnæ6v
.măgnǣ6u
.măgnǣ6v
.măgnǣ́6u
.măgnǣ́6v
.măgnǽ6u
.măgnǽ6v
.mĕ3ĭ
.mi6sta
.ne3q
.ne3s
.ne5s4c
.ne5ute
.ne5uté
.ne5u4ti
.ne3xo
.ne3xō
.nḗ3
.nĕ3xō
.né3s2
.né5ute
.no6ste
.nŏ6stĕ
.nu3d
.nū3d
.ob3a2
.obe4r
.ob3es
.ob3é2
.obi2
.ob3iī
.ob3i4n
.ob3iq
.ob3is
.obi4u
.obi4v
.ob3ī4
.obī́4
.obí4
.ob3ín
.ob3íq
.ob3ís
.obo2
.ob3ō
.obó4r
.ob3u
.oc4té
.os3t
.ṓ2
.ṓ4l
.ṓ4s
.ŏb3ī4
.ŏbī́4
.ŏb3ĭī
.ŏb3ō
.ŏc4t3ĕ
.ŏ́2
.ŏ́b3ĕ
.ŏ́b3ĭ
.ŏ́4l
.ŏ́4p
.ób3i
.œ́2
.pa4r5ui
.pa4r5uí
.pā2r3
.pá4rui
.pera4
.pe4r5an
.per5ar
.peras5
.pe4rā
.per5ār
.pe6ráeq
.peræ4q
.perǣ́4
.per5ǣ́q
.pe4rǽ4q
.pere4
.per5em
.pe4r5es
.pe4r5ē4
.perḗ4
.peré4
.pe4r5ém
.pe4r5és
.pe4ri.
.pe6riens
.per6iere.
.per6ierene
.per6iereq
.per6iereu
.per6ierev
.per6ieris
.per6ierís
.per6iēn
.per6iēre
.per6iḗn
.per6iḗre
.per6iére
.pe5rille
.pe5r6illi
.pe5rillí
.pe5rimin
.per6imini
.per6iminí
.per5imu
.pe5r6imur
.peri6mus
.pe5rimúr
.per5i6mús
.peri4n
.per5ine
.pe4r5i4q
.per6i6re.
.peri6rem.
.pe5r6iremi
.peri6remn
.peri6remq
.peri6remue
.pe5r6iremur
.peri6remus
.pe5r6iremúr
.peri6remús
.peri6remv
.per6i6rene
.peri6rent.
.peri6rentn
.peri6rentq
.peri6rentue
.pe5r6irentur
.pe5r6irentú
.peri6rentv
.per6i6req
.pe5r6irer
.peri6res
.peri6ret
.per6iretur
.per6iretú
.per6i6reu
.per6i6rev
.pe5r6irémi
.peri6rémn
.peri6rémq
.peri6rémue
.pe5r6irémur
.peri6rémus
.peri6rémv
.peri6réntn
.peri6réntq
.peri6réntue
.pe5r6iréntur
.peri6réntv
.pe5r6irér
.peri6rés
.peri6rét
.per6irétur
.pe5r6iri
.pe5r6irí
.pe6ris.
.pe6risn
.pe6risq
.pe6r5isse.
.pe6r5issem
.pe6r5issen
.pe6r5isseq
.pe6r5isses
.pe6r5isset
.pe6r5isseue
.pe6r5issev
.pe6r5issém
.pe6r5issén
.pe6r5issés
.pe6r5issét
.pe6r5isti
.pe6r5istí
.pe6risu
.pe6risv
.per5it.
.peri6ta
.peri6tā
.peri6tá
.per6i6tæ
.per6i6tǽ
.per6i6te
.peri6ti.
.peri6tin
.peri6tiq
.peri6tis.
.peri6tisn
.peri6tisq
.peri6tisu
.peri6tisv
.peri6tiue
.peri6tiv
.peri6tín
.peri6tíq
.peri6tísn
.peri6tísq
.peri6tísu
.peri6tísv
.peri6tíu
.peri6tív
.per5itn
.per6i6to.
.per6i6ton
.per6i6toq
.per6itor
.pe5ritor.
.pe5ritorn
.pe5ritorq
.pe5ritorue
.peri6torum
.peri6torú
.pe5ritorv
.per6i6tos
.peri6tot
.per6i6tou
.per6i6tov
.per6i6tón
.per6i6tóq
.per6itór
.pe5ritórn
.pe5ritórq
.pe5ritórue
.peri6tórum
.pe5ritórv
.per6i6tós
.peri6tót
.per6i6tóu
.per6i6tóv
.per5itq
.per6i6tu
.per7itue
.peri6tū
.per6i6tú
.per5itv
.peri4u
.per7iue
.per5i4v
.pe4rī.
.pe6r5ī6mus
.pe6r5ī6mús
.per5ī4n
.pe4r5ī4q
.pe6r6ī6re.
.pe6rī6rem
.pe6r6ī6rene
.pe6rī6rent.
.pe6rī6rentn
.pe6rī6rentq
.pe6rī6rentue
.per6īrentur
.per6īrentú
.pe6rī6rentv
.pe6r6ī6req
.per6īrer
.pe6rī6ret
.pe6r6ī6reu
.pe6r6ī6rev
.per6īrēmi
.per6īrēmur
.pe6rī6rēmus
.per6īrēmúr
.pe6rī6rēmús
.per6īrēr
.pe6rī6rēs
.pe6rī6rēt
.per6īrētu
.per6īrētú
.per6īrḗmi
.per6īrḗmur
.pe6rī6rḗmus
.per6īrḗr
.pe6rī6rḗs
.pe6rī6rḗt
.per6īrḗtu
.pe6rī6rém
.pe6rī6réntn
.pe6rī6réntq
.pe6rī6réntue
.per6īréntur
.pe6rī6réntv
.per6īrér
.pe6rī6rét
.per6īri
.per6īrī
.per6īrí
.pe4r5īs
.pe6rī6te
.pe6r5ī6tis.
.pe6r5ī6tisn
.pe6r5ī6tisq
.pe6r5ī6tisu
.pe6r5ī6tisv
.pe6r5ī6tísn
.pe6r5ī6tísq
.pe6r5ī6tísu
.pe6r5ī6tísv
.pe6rī6tō.
.pe6rī6tōn
.pe6rī6tōq
.pe6r5ī6tōt
.pe6rī6tōu
.pe6rī6tōv
.pe6rī6tṓn
.pe6rī6tṓq
.pe6r5ī6tṓt
.pe6rī6tṓu
.pe6rī6tṓv
.pe6rī6tur
.pe6rī6túr
.pe4r5ī4u
.pe4r5ī4v
.pe6r5ī́6mus
.pe6r5ī́6n
.pe6r5ī́6q
.pe6r6ī́6re.
.pe6rī́6rem
.pe6rī́6ren
.per6ī́rene
.pe6r6ī́6req
.per6ī́rer
.pe6rī́6ret
.pe6r6ī́6reu
.pe6r6ī́6rev
.pe6rī́6rē
.per6ī́ri
.per6ī́rī
.pe6rī́s
.pe6rī́6te
.pe6r5ī́6tis
.pe6rī́6tō.
.pe6rī́6tur
.pe6rī́6u
.pe6rī́6v
.pe4ríe
.pe5ríl
.per6ímin
.pe6r5í6mus
.perí4n
.pe6r5íne
.pe4r5í4q
.pe6r6í6re.
.pe6rí6rem
.pe6rí6ren
.per6írene
.pe6r6í6req
.per6írer
.pe6rí6res
.pe6rí6ret
.pe6r6í6reu
.pe6r6í6rev
.per6íri
.pe6rísn
.pe6rísq
.pe6r5íss
.pe6r5ísti
.pe6rísu
.pe6rísv
.pe6rí6tan
.pe6rí6taq
.pe6rí6tau
.pe6rí6tav
.pe6rí6te
.pe6rí6tis
.pe6r5ítn
.pe6rí6to.
.pe6r5ítq
.pe6r5ítue
.pe6rítur
.pe6r5ítv
.pe4rí4u
.pe4rí4v
.per5os
.per3ō
.pe4rór
.pe4rós
.pē4nī
.pḗ3i
.pĕ4r3ā
.pĕ4r3ă
.pĕrăs5
.pĕ6r5áeq
.pĕræ4
.pĕrǣ4
.pĕrǣ́4
.pĕr5ǣ́q
.pĕrǽ4
.pĕ4r5ǽq
.pĕ4r5ē4
.pĕrḗ4
.pĕ4rĕā
.pĕ4rĕă
.pĕ4r5ĕm
.pĕ4r5ĕō
.pĕ6r5ĕ́m
.pĕ4rī.
.pĕ6r5ī6mŭs
.pĕ6r5ī6mŭ́s
.pĕr5ī4n
.pĕ4r5ī4q
.pĕ6r5ī6rēmŭs
.pĕ6r5ī6rēmŭ́s
.pĕ6r5ī6rēs
.pĕ6rī6rēt
.pĕr5īrētĭ
.pĕ6r5ī6rḗmŭs
.pĕ6r5ī6rḗs
.pĕ6rī6rḗt
.pĕr5īrḗtĭ
.pĕ6rī6rĕ.
.pĕ6r5ī6rĕm
.pĕ6rī6rĕnĕ
.pĕ6r5ī6rĕnt.
.pĕ6r5ī6rĕntn
.pĕ6r5ī6rĕntq
.pĕ6r5ī6rĕntu
.pĕ6r5ī6rĕntv
.pĕ6rī6rĕq
.pĕ6r5ī6rĕt
.pĕ6rī6rĕu
.pĕ6rī6rĕv
.pĕ6r5ī6rĕ́m
.pĕ6r5ī6rĕ́ntn
.pĕ6r5ī6rĕ́ntq
.pĕ6r5ī6rĕ́ntu
.pĕ6r5ī6rĕ́ntv
.pĕ6r5ī6rĕ́t
.pĕ4r5īs
.pĕ6rī6tĕ
.pĕ6r5ī6tĭs.
.pĕ6r5ī6tĭsn
.pĕ6r5ī6tĭsq
.pĕ6r5ī6tĭsu
.pĕ6r5ī6tĭsv
.pĕ6r5ī6tĭ́sn
.pĕ6r5ī6tĭ́sq
.pĕ6r5ī6tĭ́su
.pĕ6r5ī6tĭ́sv
.pĕ6rī6tō.
.pĕ6rī6tōn
.pĕ6rī6tōq
.pĕ6r5ī6tōt
.pĕ6rī6tōu
.pĕ6rī6tōv
.pĕ6rī6tṓn
.pĕ6rī6tṓq
.pĕ6r5ī6tṓt
.pĕ6rī6tṓu
.pĕ6rī6tṓv
.pĕ6rī6tŭr
.pĕ6rī6tŭ́r
.pĕ4r5ī4u
.pĕ4r5ī4v
.pĕ6r5ī́6mŭs
.pĕ6r5ī́6n
.pĕ6r5ī́6q
.pĕ6r5ī́6rē
.pĕ6rī́6rĕ.
.pĕ6r5ī́6rĕm
.pĕ6rī́6rĕn
.pĕr5ī́rĕnt
.pĕ6rī́6rĕq
.pĕ6r5ī́6rĕt
.pĕ6rī́6rĕu
.pĕ6rī́6rĕv
.pĕ6r5ī́s
.pĕ6rī́6tĕ
.pĕ6r5ī́6tĭs
.pĕ6rī́6tō.
.pĕ6rī́6tŭr
.pĕ6r5ī́6u
.pĕ6r5ī́6v
.pĕ6rĭēn
.pĕ6rĭērĕ
.pĕ6r5ĭērŭ
.pĕ6rĭḗn
.pĕ6rĭḗrĕ
.pĕ6r5ĭḗrŭ
.pĕ6r5ĭĕr
.pĕ6r5ĭĕ́r
.pĕ4r5ĭī
.pĕr5ĭmŭ
.pĕrĭ4t
.pĕ6r5ĭt.
.pĕ6r5ĭtā
.pĕ6rĭtĕ
.pĕ6r5ĭtn
.pĕ6r5ĭtq
.pĕ6r5ĭtu
.pĕ6r5ĭtū
.pĕ6r5ĭtv
.pĕ6r5ĭ́ĕ
.pĕ6r5ĭ́t
.pĕr3ō
.pĕ́4r5ĕ
.pĕ́6rĭē
.pĕ́6r5ĭī
.pĕ́6r5ĭ6t
.pé3i
.pé2r
.pér3e
.pér5ii
.pér5iī
.pér5i4t
.pi6str
.po6te6ris
.po6te6rís
.po6tes.
.po6tesn
.po6tesq
.po6tesu
.po6tesv
.po4tés
.pó4tes
.pule5i
.pulé3
.ra3d4
.radi5c
.ra3i
.ra3m
.ra5ra
.ra5rá
.ras5t
.ra6ste
.rā6ste
.rā6stĕ
.rā́6st
.rá3i
.ræ3
.re1
.re5dam.
.re5damq
.re5damu
.re5damv
.re5das
.red3e4
.red3ē
.re4dé
.re4di.
.re4d5ie
.re4d5iē
.re4d5ié
.re4d5ií
.re4d5i4m
.red5i4n
.re4d5i4q
.re6dis.
.re6disn
.re6disq
.red5iss
.red5ist
.re6disu
.re6disv
.re4d5i4t
.re4di6u
.red5iue
.redi6v
.red5ive
.re4dī.
.red5ī4m
.re4d5ī4n
.re4d5ī4q
.red5ī4t
.redī6u
.redī6v
.red5ī́6m
.re6d5ī́6n
.re6d5ī́6q
.red5ī́s
.red5ī́6t
.re6d5ī́6u
.re6d5ī́6v
.re4d5í4m
.re4d5í4n
.re4d5í4q
.re6dísn
.re6dísq
.red5íss
.red5íst
.re6dísu
.re6dísv
.re4d5í4t
.re4d5í4u
.re4d5í4v
.re3ō
.re3ó
.res4tō
.rex2
.re5xi
.rĕ1
.rĕd3ē
.rĕ4dĕ
.rĕ4dī.
.rĕd5ī4m
.rĕ4d5ī4n
.rĕ4d5ī4q
.rĕd5ī4t
.rĕdī6u
.rĕdī6v
.rĕd5ī́6m
.rĕ6d5ī́6n
.rĕ6d5ī́6q
.rĕd5ī́s
.rĕd5ī́6t
.rĕ6d5ī́6u
.rĕ6d5ī́6v
.rĕdĭ4
.rĕ4d5ĭē
.rĕ4d5ĭĕ
.rĕd5ĭm
.rĕ4d5ĭt
.rĕdĭ́4
.rĕd5ĭ́t
.rĕ3ō
.rĕ5s4tō
.rĕ́4d5ĭ4
.rĕ́3q
.rĕ́s6tē
.rĕ́s6tĕm
.rĕ́5s6tō
.ré4d3i4
.rés6tem
.rés6tes
.rés4tē
.ré5s4to
.ré5s4tō
.ré5str
.ris2
.ro3b2
.ro3d4
.ro5di
.rodi5u
.rodi5v
.ro4s3t
.rō3d4
.rō5dī
.rōdī5u
.rōdī5v
.ru3r
.ru4s
.sa3mu
.sá3mu
.se3i
.se6mis.
.se6misn
.se6misq
.se6misue
.se6misv
.se6mísn
.se6mísq
.se6mísu
.se6mísv
.se3ps
.sē3i
.sē3p2
.sḗ3i
.sḗ3p4
.sé3i
.sé4mis
.sé3ps
.sér4ui
.sér4uī
.si4lu
.sil5ui
.sil5uī
.sil5uí
.si6str
.sí4lui
.sí4luī
.supe6ris
.supé6r5is
.te4ia
.te4iá
.te4ie
.te4ii
.te4ií
.te4io
.te4ió
.te4iú
.te3n4u
.te3ra
.te5r4e
.te5rim
.te5rin
.te5r6it
.teri5tur
.te5ri5ue
.te5ri5v
.te5rī
.terī5u
.terī5v
.te3ro
.te3rō
.te5runt
.tē2i
.tĕ5rĕ
.tĕrĕ5r
.tĕ5rī
.tĕrī5u
.tĕrī5v
.tĕ3rŭ
.té3n4u
.té5r4e
.té3rī
.tran5s6ue.
.trān5s6ue.
.trān5s6uĕ.
.trā́n5s6ue.
.trā́n5s6uĕ.
.trán5s6ue.
.tro4ii
.tro4ií
.tro4i5q
.tro6iue
.tro4iv
.tro4í
.troí5u
.troí5v
.ub2
.ubī3q
.ubī́3
.ueni4
.ue4ni.
.ue6niens
.ue6n5ier
.ue6niéns
.ue6n5iér
.ue4nim
.ue4nin
.ue4niq
.ue4nir
.ue4nis
.ue4nit
.ue6niue
.ue4ní4
.uen5íe
.ue6ste
.uē4nit
.uē4nī4
.uēn5īs
.uēnī́4
.uēn5ī́s
.uē4nĭt
.uē6nĭ́t
.uē4nít
.uḗ6nit
.uḗ4n5ī
.uḗ6nĭt
.uĕ6stĕ
.ué4ni.
.ué6niens
.ué4nis
.ué4nit
.uī4cĕ́
.ul3ui
.ul3uī
.ul3uí
.um2e
.un3et
.uol6uere.
.uol6uerene
.uol6uereq
.uol6uereu
.uol6uēre
.uol6uēru
.uol6uērú
.uol6uḗre
.uol6uḗru
.uol6uit.
.uol6uitn
.uol6uitq
.uol6uitue
.uo6ste
.uŏ6stĕ
.uól6ui.
.uól6uit.
.uól6uī.
.ur1
.uu2
.ūn5ắn
.ū́2
.ū́4d
.ū́4n
.ū́4s
.ū́4t
.ŭb2
.ŭ́4n
.ŭ́4t
.úb2
.veni4
.ve4ni.
.ve6niens
.ve6n5ier
.ve6niéns
.ve6n5iér
.ve4nim
.ve4nin
.ve4niq
.ve4nir
.ve4nis
.ve4nit
.ve4niv
.ve4ní4
.ven5íe
.ve6ste
.vē4nit
.vē4nī4
.vēn5īs
.vēnī́4
.vēn5ī́s
.vē4nĭt
.vē6nĭ́t
.vē4nít
.vḗ6nit
.vḗ4n5ī
.vḗ6nĭt
.vĕ6stĕ
.vé4ni.
.vé6niens
.vé4nis
.vé4nit
.vī4cĕ́
.vo6ste
.vŏ6stĕ
a1ā2
a3āt
a3ā́2
a1á2
a3át
2aba
aba3i
ab2a3q
aba6ste
ab3aui
ab3auí
ab3av
2abá
abá3i
abæ3
a2beú
2abé
ab2ia
ab2iá
a2b3i2b
ab3ice
a2bie
ab4ies
ab4iet
a2biē
ab4iēs
ab4iḗs
a2bié
ab4iés
ab4iét
a2bii
a2biī
ab3iī.
ab3iīn
ab3iīq
ab3iīu
ab3iīv
ab5iī́n
ab5iī́q
ab5iī́u
ab5iī́v
a2b3ií
2abil
2abim
ab3iss
ab3ist
2abit
abi4tot
abi4tót
1abī
abī2m
a2b3í2b
a2bíe
ab3íer
a2bíi
ab3ímu
ab3íss
ab3íst
ab3íto
1abj
1a2bl
1abn
2abo
2abó
abó2l
1ab1r
ab3rā
ab3rá
1abs
ab2sq
ab4stem
ab4stēm
ab6stḗm
ab4stén
ab4sti
abs5tin
ab4stó
abs3tr
ab4stru
ab4strū
ab4strú
4abunt
ab3u4s
abu2t
ab1ū2
abū4s
abū́2
2abú
5abúndat
5a4b5úndā
5abúndem
5abúndes
5abúndet
5a4b5úndē
5a4b5úndō
abú2t
a3ca
a3cá
a3cæ
a3cǽ
1acc
2a3ce.
2a3cen
2a3ceq
2a3ceu
2a3cev
2aci
a3ci.
a3ciq
a3cis
a3ciu
a3civ
2a3cī
2ací
a3cl
2a3co
aco3ni
2a3cō
2a3có
2acum
2acus
a2cut
1a2c2ū
2acúm
2acús
a2cút
ad1
ad2ad
ada4ma.
ad6amans
ada6mante.
ada6mantem
ada6manten
ada6manteq
ada6mantes
ada6manteue
ada6mantev
ada6mantēs
ada6mantḗs
ad6amanté
ada6mantém
ada6mantés
ada6manti
ad6amanti.
ad6amantib
ad6amantin
ad6amantiq
ad6amantis
ad6amantiu
ad6amantiú
ad6amantiv
ad6a6mantī
ada6mantí
ad6amantín
ad6amantíq
ad6amantís
ad6amantíu
ad6amantív
ad6amas.
ad6amasn
ad6amasq
ad6amasu
ad6amasv
ad6amāns
ad6amās.
ad6amāsn
ad6amāsq
ad6amāsu
ad6amāsv
ad6amā́ns
ad6amā́sn
ad6amā́sq
ad6amā́su
ad6amā́sv
ad6amáns
ad6amánte
ad6amántē
ad6amánti.
ad6amántib
ad6amántis
ad6amántiu
ad6amántī
ad6amásn
ad6amásq
ad6amásu
ad6amásv
ad2an
a2dap
ada2q
ad2ar
ad3ác
adæ2
adǣ2
1add
ade4d
ade2g
ade2q
ade4s
adē2d
adē2g
adē4s
adḗ4d
adḗ4g
adḗ4s
adé2d
adé2g
adé2s
1adh
ad3iác
adi2c
adi2g
adi4mí
adi2r
adi4tā
adi4tǣ
adi4tī
adi4tū
adī2m
adī2r
adī2t
adī́4m
adī́4r
adī́4t
adí2b
adí2g
adí4mu
adí2r
ad3íss
ad3íst
adí4to
adí4tu
1adj
1adn
a2do2
a3do.
ad4oc
a3don
a3doq
a3dou
a3dov
adō2
ad4ōc
ad5ṓ6rant
ad5ṓ6rat
ad5ṓ4rā
ad5ṓ6rem
ad5ṓ6rent
ad5ṓ6rer
ad5ṓ6ret
ad5ṓ4rē
adṓ6ror
adó6rans
adó6rant
adó4ras
adó4rat
adó4rem
adó6rent
adó4rer
adó4res
adó4ret
adó4ria
adó4ror
1adp
1ads
adu2
a2dul
ad3u4r
ad3us
adū2
adū́2
a2dú2l
adú2r
ae1
2ae.
2aea
aea2b3
a3eamú
a3eant
2aeā
a3eām
a3eā́m
2aeă
aeắ2
2aeá
ae3ác
a3eánt
ae3áp
ae4cue
1ae3d2
aed4o
2aee
ae2eo
ae2eō
ae2eó
ae3es
ae2eu
2aeĕ
aeé2r
ae3és
ae3g2
2aei2
ae3ic
2ae2ī
2aeí
2aen
aení3t
2ae2o
2ae2ō
2aeó
aepo6tés
aepó6tes
ae3q
4aeque.
4aequĕ.
ae3r
aer4i
ae4rn
ae4rq
ae4rv
ae5sci
ae4scu
ae4scú
ae4spō
ae2sq
aes4te
aesti5t4
aestí5t4
aetere6ri
aete6re6rí
aete6res
aete6rés
aete6ri.
aeter5ii
aeter5ií
aeteri6mu
aeteri6mú
aeteri6n
aete6ri6q
aeteri6ti
aeteri6tí
aeteri6to
aeteri6tó
aeteri6tú
aete4r5ī4
aeterī́6
aete6r5í6mu
aete6rí6n
aete6rí6q
aete6rí6t
aeter5íti
aete6rí6u
aete6rí6v
a3e2tē
ae5tĕr
aeté6r5es
aeté6ri.
aeté6r5ii
aeté6rite
aeté6ri6ti
ae2un
ae3ut
2aeŭ
2aeú
aex2
ae2xu
aé2ru
1af
afe4r
afé2
ag2a
a3gae
a3ga͞
a3ga͡
a3gā.
a3gān
a3gāq
a3gāu
a3gāv
a3gáe
a3gál
a3g2æ3
a3g2ǣ
a2geb
a2ger
a2get
1a2gē
a3gē.
a3gēq
a3gēu
a3gēv
a2géb
a2gét
a2gim
agi6ste
agi6str
a2gím
a2gít
a2gn
ag3ne
ag3ni.
ag3nin
ag3niq
ag3nis
ag3niu
ag3niv
ag3nī
ag3nín
ag3níq
ag3nís
ag3níu
ag3nív
ag3no.
ag5norum
ag5norúm
ag5nos.
ag5nosn
ag5nosq
ag5nosu
ag5nosv
ag5noue.
ag5nove.
ag3nō
ag3nón
ag3nóq
ag5nórum
ag5nósn
ag5nósq
ag5nósu
ag5nósv
ag5nóue.
ag5nóve.
ag3nu
ag3nú
a3gri
a3grī
a3grí
a2gun
a2gún
a1h
ai2a
aiad2
ai4an
ai2á
a1ib
a1ie
a1i2i
a1iī
a2i3m
ai4mn
ai4mq
ai4mv
ai2nu
aio2s
a1iō
a1is
a1it
a1iu
a1ī2b
aīn3
aī2nu
a1ī2r
a1īs
aī́2b
aī́2r
aī́2t
a1í2b
a1íi
a2í3me
a1í2r
a1í2t
a3la
alae2
a3lá
alæ2
alǣ2
2a3le
ale2i
alē2i
2a3lé
a3li.
a3lia
a3lib
a3lii
a3lií
a3lin
a3lio
a3liō
a3lió
a3liq
a3lis
a3lit
a3liu
a3liú
a3liv
2a3lī
2a3lí
2alu
a2l3ua
a2luā
a2l3uá
a2l3uæ
a2luǣ
a2l3uǽ
al3ue.
al3uen
al3ueq
al3ueu
al3uin
al6uine.
a4l5uis.
a4l5uisn
a4l5uisq
a4l5uisu
al3uīs
al5uī́s
a4l5uísn
a4l5uísq
a4l5uísu
a3l4um
al3uó
a3l4us
alu6ste
a3l4ut
al3uu
al3uú
alū6ste
2alú
2am.
am2a
4amantē
6amantéa
6amantéæ
6amantée
6amantéi
6amantéo
6amantéu
a4mantō
1a2mā
1amb
am2be
amb3és
am4b5i4mu
am4b5i4mú
am4b5it.
am6b5i6te.
am6b5i6ten
am6b5i6teq
am6b5i6teu
am6b5i6tev
ambi4ti
am4b5i4tí
am4b5itn
am4bi4to
am4b5i4tó
am4b5itq
am6b5itue
am4bitú
am4b5itv
am6bi6ui.
am6bi6vi.
am4bít
am4b3u4r
am4b3us
ambūbā6i
ambūbē6i
am4bū4r
am4b3ū́4
am4b3ú4r
am2e
ame3g
am4es
ame3sæ
ame3sǽ
am2ē
am2é
am4és
amé3sa
am2i
3a2mic
2amin
ami4s3
ami6ste
ami6str
3a2míc
2amm
2amn
3amnæ
3amnǣ
3amnǽ
1amo
a2móe
1amœ
1amp
2amq
2a1mu
am4uel
am2uē
am2ué
a2mui
a2muī
a2m3uí
a3mur
a3mus
2a3mú
2amv
2an2a
an2ā
2aná
2anæ
2anǽ
1anc
an2cu
2and
ande4s3
2ane
a3nē
1anh
1ani
a2nim
2anī
3a2ním
2a3n2o
ano3p
2anō
2a3nó
2ans1
an2sa2
ans3ab3
ansabi4
ansabí4
an4sá4b3
an4s3ci
an4scí
an4sea
an4seá
an4seo
an4seó
an4si4b
an4sig
ansi4mi
an4si4t
ansi4u
an4si4v
an4sí4b
an4síe
an4síg
an4sí4m
an4sí4t
ansí4ui
ansí4vi
an4sn
an2sp
an4sq
ans3t
an4sv
2ant.
ante5re
an4t5ero
an4t5erō
an4t5e4ró
an5tes
antes4t
ante5stāti
ante5stā́ti
ante5stem.
ante5stemn
ante5stemq
ante5stemue
ante5stemv
ante5stes
ante5stēs
ante5stḗs
ante5stémn
ante5stémq
ante5stémue
ante5stémv
ante5stés
anté5ii
antés4t
anté5stem
anté5stes
anté5stē
2antn
2antq
2antu
2antú
2antv
2a1n2u
a2n3ue
an2ū
2anú
ao1n
a2one
ao3ni
ao2ny
ao2ný
a1or
aō2ny
aō2ný
a3ṓ4ny
a3ó2ny
aó1r
1ape1
ape2i
ape3r4e
aper4ē
aper4i
ape3r4ī
aper4í
aperí5tur
aper4u
2aph
a3pi
apis3
api6str
a3pí
a2pn
apo5str
apo4su
1apó
após3
1app
appár4
apule4
aput3
a3pú
a2qua
a2quā
a2quá
a3que.
a2quē
a2quo
a2quō
a2quó
a1r
2ar.
ar2a
arab2
1arā
2arám
ardē2
ar2e
2are.
are2i
2aren
2areq
2arer
3a4resc
2areu
2arev
arē2i
a3rēu
a3rēv
2aré
3a4résc
2ar2i
3arid
ari5do
ari3ni
2arí
3aríd
1arm
2arn
arpē4i
2arq
ar2sp
3a2r3ua
3a2r3uā
3a2r3uá
ar3uæ
ar3uǣ
ar3uǽ
ar3ue.
a4r3uen
a4r3ueq
ar4uer
a4r3ueu
ar4ui.
ar4uin
ar4uiq
ar4uis
ar5uis.
ar5uisn
ar5uisq
ar5uisu
ar4uiu
ar3uī
ar5uísn
ar5uísq
ar5uísu
2a3rum
2a3run
a2r3uo
a2r3uō
a2r3uó
a3rus
aru3sp
a2r3uu
a2r3uú
2a3rú
arú3sp
2arv
3arva
3arvā
3arvá
2as.
2asca
2ascá
as6cendā
as6cende
as6cendī
as6cendō
as2cē
as6céndā
as6céndī
as6céndō
2as3ci
2ascí
2asco
2ascó
a3scr
as4cri
2ascu
2ascú
a3s2e
ase2i
as4er
asē2i
a3sé
a3s2i
a3sí
2asn
1asp
as5per.
as5pera
as5perā
as5perá
as5peræ
as5perǣ
as5perǽ
as5pere
as5perē
as5peré
as5pe5ri
as5pe5r4ī
as5per4í
as5perne.
as5pero
as5perō
as5peró
as5perq
as5peru
as5perú
as5perv
a4s3pē
as5péra
as6pérna
as5pérq
as5péru
as5pérv
a4spi
as3pis
a4s3pī
a4spí
as3pís
as3po
as3pō
as3pó
as3pum
as3púm
2as3q
2ass
as2tā
as5te.
as5teq
as4ter
as5teu
as5tev
as2tē
4a4s3ti.
4a4s3tin
4a4s3tiq
4a4stis
4a4stiu
4a4s3tiv
2as3tí
a4stín
a4stíq
a4stís
3as4tít
a4stíu
a4stív
as3to
2astr
as4tras
as4trau
as5traue.
as4trav
as5trave.
as4trát
as4tráu
as4tráv
as4trid
as4tríd
as5trum
as4trúe
2asu
a3s2ua
a4s3ue
as3uis
as3uís
2asv
2at
at3a4g
ata5str
a2t3á4g
ate4ie
ate4io
ate4ió
ate4iú
ate2ī
ate3r4a
ate3rǣ
ate5re
ate5ré
ate3ri
ateri5u
ateri5v
ate5rī
aterī5u
aterī5v
ate3ro
ate3rō
a3ti
ati4s
atis5t
ati6sta
a3tí
ato2i
ató2i
1att
a3tur
a3tú
a1u
au3a͞
a2u1ǣ2
au3d2
2a3ue
2a3ué
1aug
2aui
2auí
a2ul
a2u1m
a2un
aupe5re
aupe5ri
auperi5n
auperi5q
auperi5ue
auperi5v
aupe5r4ī
auperī5n
auperī5q
auperī5u
auperī5v
a2u1r
a2ut
1auu
a2ux
au2xu
2av
av3a͞
a2v1ǣ
a3ve
a3vé
1avu
ax2
ax4eu
a2xia
a2xiá
a2xiæ
a2xiǽ
a2xié
a2xii
a2xií
a2xio
a2xió
a2xiú
a2xía
a2xíe
ax3ue
ax4us
a2͞
4a͞e.
2a͞ea
2a͞eā
2a͞eă
2a͞eá
2a͞eī
4a͞en
6a͞eque.
6a͞equĕ.
a͞u6ste
a͞u6stĕ
4á͞ea
4á͞eā
4á͞eă
4á͞eī
4á͞en
a2͡
4a͡e.
2a͡ea
2a͡eā
2a͡eă
2a͡eá
2a͡ei
2a͡eī
2a͡eí
4a͡en
6a͡eque.
6a͡equĕ.
a͡ete6res
a͡ete6rés
a͡eté6r5es
a͡u4st
a͡u6ste
a͡u6stĕ
4á͡ea
4á͡eā
4á͡eă
4á͡ei
4á͡eī
4á͡en
6á͡eque.
2āb2
āba2
ābá2
ābī3u
ābī3v
ābo2
āb4un
2ācĕ
ācé2
2ācī
2ācĭ
1ā2cr
1āct
ā2c3ue
āda2
ādá2
ādē2s
ā3do2
ād4or
ādó2
āe1
āe3r
āē2
āēr3
āḗ2
āĕ1
āĕ3r
āĕr4ĕ
āg2a
ā2gā
ā2gă
ā3g2æ3
ā3g2ǣ
ā2ge
āge2r
ā2gĕ
ā2gé2
ā2gn
ā2go2
ā2gŏ
ā2gó
ā1i
ā2ia.
āiad2
ā2iam
ā2ian
ā2iaq
ā2iau
ā2iav
āi2ā
ā4iāque
ā4iāue
ā4iāve
ā6iā́que
ā4iā́ue
ā4iā́ve
ā2iám
ā2id
ā2ien
ā4iḗne
ā6iḗque
ā4iḗue
ā4iḗve
ā2iī.
ā4iīne
ā4iīque
ā4iīue
ā4iīve
ā4iī́ne
ā6iī́que
ā4iī́ue
ā4iī́ve
ā2io
ā2iō.
ā4iōne
ā4iōque
ā4iōru
ā4iōrú
ā4iōs.
ā4iōsne
ā6iōsque
ā4iōsue
ā4iōsve
ā4iōue
ā4iōve
ā4iṓne
ā6iṓque
ā4iṓru
ā6iṓsne
ā6iṓsque
ā6iṓsue
ā6iṓsve
ā4iṓue
ā4iṓve
ā2ió
ā2is
ā2ium
ā2ius
ā2iús
ā1ĭc
ā2íe
2āl
āle2r
ā3li
ālo2
2ā1m2
āme4r3
āmĭ́5c
āmo2
ā3na
ā3n2ā
ā3nă
ā3ná
ā3næ
ā3nǣ
ā3nǽ
ā3ne
āne2r
ā3nē.
ā3nēn
ā3nēq
ā3nēu
ā3nēv
ā3n2ĕ
āné2
āno2
ā3nō
2āns
ān2s3a2
ānsab3
ān2să
ānsá2
ān4s3áb3
ān4scī
ān4s3ea
ān4s3eā
ān4s3eá
ān4s3eo
ān4s3eō
ān4s3eó
ān4s3ĕā
ān4s3ĕă
ān4s3ĕō
ān4s3ĕŏ
ān4s3i4b
ān4sig
ān4s3iī
ān4s3i4t
ān2s3ī2
ānsī́4m
ānsī́4t
ān4s3ĭ4b
āns3ĭē
ān4sĭg
ān4s3ĭī
ān4s3ĭ4t
āns5ĭ́4b
ān4s5ĭ́ĕ
ān4s5ĭ́g
ān4s3í4b
ān4síe
ān4síg
ānsí4t
āns5íta
āns5íte
āns5íti
ān2sp
ān4s3t
ā1nu
ā2n3ue
ā3nus
ā3nŭ
ā3nú
ā1ō
āpē2
ā3pi
ā3pĭ
ā3p2t
2āq
ā1r
2āra
2ārā
2ārá
2ā3r2e
ā3rē
ārē2i
2ārēm
2ārēr
4ārēs.
3ā4rēsc
4ārēsn
4ārēsq
4ārēsu
4ārēsv
2ārēt
2ārḗ
5ā4rḗsc
2ā3r2ĕ
2āré2
2āria
2āriā
2āriá
2āriæ
2āriǣ
2āriǽ
ā2rid
āri5dō
2ārie
2āriē
2āriī
2ārim
2ārin
2āriō
2āris
2ārit
2āriu
2āriú
2ārī
2ārĭ
3ā2rĭd
ārĭ5dō
3ā4rĭ́d
2ārí
3ā2ríd
āro2
2ārō
āró2
ār2s3p
ār2u
ār3ue.
2ārum
2ārun
2ārŭ
ār4ŭn
2ārú
2ās
ās2ca
ās2că
ās3cī
ās2i
āsi2n
āso2
ā2s3q
ās5ter
ās5tĕr
ā2s3ti
ā2s3tī
ā2s3tĭ
ā2s3tí
ā2s3ue
ā2s3uĕ
2āt
āté2
āto2
ātō2i
ātó2
2ā1u2
2āv
āx2
ā2x3u
2ā2́
ā́b2
ā́4crĕ
ā́4crĭ
3ā́ctē
3ā́cti
ā́2f
ā́2go
ā́2gŏ
ā́3ici
ā́3iul
ā́3ĭcĭ
ā́3lu
ā́1m2
ā́n4s5ea
ā́n4s5eā
ā́n4s5eo
ā́n4s5eō
ā́n4s5ĕā
ā́n4s5ĕă
ā́n4s5ĕō
ā́n4s5ĕŏ
ā́n4s5iī
ā́n4s5i4t
ā́n4s5ĭī
ā́n4s5ĭ4t
ā́3p2t
ā́3rĕ
3ā́4rid
3ā́4rĭd
ā́r4uī
ā́5s4trŭ
ă1ā2
ă3āt
ă3ā́2
ăb1
ăb2a
2ăbă
ăb2ăc
ăbă4l
ăb2ăq
ăbă6stĕ
ăb2ắ
ăb3ắl
ăb2á
ăbæ3
ăb2e
2ăbē
ăb2ēs
ă2bi
ăbī2m
ăb4ĭēs
ăb4ĭḗs
ăb3ĭī.
ăb3ĭīn
ăb3ĭīq
ăb3ĭīu
ăb3ĭīv
ăb5ĭī́n
ăb5ĭī́q
ăb5ĭī́u
ăb5ĭī́v
ăbĭ́4g
ă2bl
ăbŏ2
ăbŏ3lŭ
ăbŏ́2
ăb3r
ăb4ră
ăb2sq
ăb4stēm
ăb6stḗm
ăb4stĭ
ăbs3tr
ăb4strū
ăb4strŭ
ăb4stŭ
ăb2su
ăbū2
ăbū́4
ă2bŭ
ă3bŭm
2ăca
2ăcā
2ăcă
2ăcá
2ăcæ
2ăcǣ
2ăcǽ
1ăcc
2ăcē
ă3cĕ.
ă3cĕn
ă3cĕq
ă3cĕu
ă3cĕv
2ă3cī
2ăcĭ
2ă3cō
ă2cu
1ă2c2ū
2ăcŭm
2ăcŭs
ă3cŭ́m
ăd1
ădă2
ăd2ăd
ăd6ămāns
ăd6ămās.
ăd6ămāsn
ăd6ămāsq
ăd6ămāsu
ăd6ămāsv
ăd6ămā́ns
ăd6ămā́sn
ăd6ămā́sq
ăd6ămā́su
ăd6ămā́sv
ădă6măntēs
ădă6măntḗs
ăd6ămăntĕ
ăd6ămăntī
ăd6ămăntĭb
ăd6ămăntĭs
ăd6ămăntĭŭ
ăd6ămăntĭ́s
ăd6ămắntē
ăd6ămắntĕ
ăd6ămắntī
ăd6ămắntĭb
ăd6ămắntĭs
ăd6ămắntĭŭ
ăd2ăn
ădă4q
ădæ2
ădǣ2
ă3d2e
ăde4u
ădē2d
ădē2g
ădē2s
ădḗ4d
ădḗ4g
ădḗ4s
ădĕ2d
ădĕ2q
ădĕ́4d
ă2di
ădī2m
ădī2r
ădī2t
ădī́4m
ădī́4r
ădī́4t
ădĭ2c
ădĭ4ta
ădĭ4tā
ădĭ4tă
ădĭ4tá
ădĭ4tæ
ădĭ4tǣ
ădĭ4tǽ
ădĭ4tī
ădĭ4tū
ădĭ́4c
ădĭ́4tă
ădĭ́4tĭ
ădō2
ăd4ōc
ăd5ṓ4rā
ăd5ṓ6rănt
ăd5ṓ6răt
ăd5ṓ4rē
ăd5ṓ6rĕm
ăd5ṓ6rĕnt
ăd5ṓ6rĕr
ăd5ṓ6rĕt
ădṓ6rŏr
ă2dŏ2
ă2du
ădū2
ădū́2
ădū́4l
ădŭ2
ă1ĕ2
1ăf
1ăg
ă3g2a
ă2găr
ă2găt
ă3g2æ3
ă3g2ǣ
ă2gē
ă3gē.
ă3gēq
ă3gēu
ă3gēv
ă2gĕ
ă3gĭb
ăgĭ6stĕ
ă2gĭt
ă2gn
ă3grī
ă2gŭn
ă1h
2ă1i
ă1ī2b
ă1ī2r
ă1īs
ăī́2b
ăī́2r
ăī́4t
ă1ĭĕ
ă1ĭĭ
ă3ĭ2t
ă3ĭ́ĕ
ă3ĭ́ĭ
ă3ĭ́2t
2ăj
ălae2
ă3lă
ălæ2
ălǣ2
2ălē
2ălĕ
2ă3lī
ă3lĭă
ă3lĭō
ă3lĭŭ
ă3lĭ́
ă2l1u
ălū6stĕ
2ălŭ
2ăm.
ă1ma
1ă2mā
ă1mă
4ămăntē
3ă2măt
1ămb
ăm2bĕ
ăm4b5ĭt.
ăm4b5ĭtn
ăm4b5ĭtq
ăm4b5ĭtu
ăm6b5ĭtŭ́
ăm4b5ĭtv
ăm6b5ĭ́tn
ăm6b5ĭ́tq
ăm6b5ĭ́tu
ăm6b5ĭ́tv
ămbūbā́5i
ămbūbḗ5i
ăm4bū4r
ăm4b3ū́4
ăm4b3ŭs
ăm2e
ăm2ē
ăm2ĕ
3ămīc
ăm3ĭc
ămĭ6stĕ
2ămm
2ămn
3ămna
3ămná
3ămnæ
3ămnǣ
3ămnǽ
1ămo
1ă2mó
1ămœ
1ămp
2ămq
2ămu
2ămv
ăn2ā
2ă3n2ă
1ănc
2ănd
ă3nē
2ă3n2ĕ
1ănh
2ă3nī
1ănĭ
ă2nĭm
2ă3nō
2ă3n2ŏ
2ănt.
ăn4t5ĕ4rō
ăn5tĕs4
ăntĕ5stātĭ
ăntĕ5stā́tĭ
ăntĕ5stēs
ăntĕ5stḗs
ăntĕ5stĕm
ăntĕ5stĕ́m
ăntĕ́s4
ăntĕ́5stē
ăntĕ́5stĕm
2ăntn
2ăntq
2ăntu
2ăntŭ
2ăntv
ăn2ū
2ă3n2ŭ
ăō2ny
ă3ṓ4ny
ă3pe
1ăpĕ
ăpĕ3rĕ
ăpĕ3rī
ăpĕ3rŭ
ă3pé
ă2pn
1ăpŏ
1ăpp
3ă2quā
3ă2quă
3ă2quē
3ă2quō
3ă2quŏ
2ăr.
ă1ra
ă1r2ă
ără3bŭ
ă3răg
ără3gĕ
ă1ræ
ă1rǣ
ărdē2
ă3r2e
ă3rēu
ă3rēv
ă1r2ĕ
ă3rh
ă1rī
ă3r2ĭ
2ărn
ă1ro
ă1rō
ărpē3i
ărpḗ5i
2ărq
ăr2su
2ăr1u
3ăruā
ă1rū
ă1rŭ
2ărv
3ărvā
ă1ry
2ăs.
1ăsc
ăsce2
ăs2cē
ăs2cĕ
ăscé2
ă3s2ĕ
ăs4ĕr
ă3sĭ
2ăsn
ă2sp
ă4s3pē
ăs5pĕr.
ăs5pĕra
ăs5pĕrā
ăs5pĕră
ăs5pĕrá
ăs5pĕræ
ăs5pĕrǣ
ăs5pĕrǽ
ăs5pĕrē
ăs5pĕ5rī
ăs5pĕrnĕ.
ăs5pĕrō
ăs5pĕrq
ăs5pĕru
ăs5pĕrŭ
ăs5pĕrv
ă4s3pī
ă4spĭ
ăs3pĭs
ăs3pō
ăs3pŏ
ăs2pŭ
2ăs3q
2ăst
ăs2tā
ăs4tăn
ăs2tē
ăs2tĕ
ăs3tĕ.
ăs3tĕq
ăs3tĕu
ăs3tĕv
4ăstr
ăs3tră
ăs3trō
ă3strŏ
ăs4trŭ
2ăs3u
2ăsv
ă3ta
ă3tā
ătă5str
ătắ2
ă4t3ắg
ă3tá
ă3tæ
ă3tǣ
ă3tǽ
ă3tē
ătḗ3i
ătĕ2ī
ătĕ3r4a
ătĕ3rǣ
ătĕ3rĕ
ătĕ5rī
ătĕrī5u
ătĕrī5v
ătĕ3rŭ
ă3tī
ă3tĭ
ătĭ4s
ătĭs5t
ă3tr
1ătt
ă2tu
ă1u
ă2u1a
ă2u1á
ă2uæ2
ă2u1ǣ2
ă2uǽ
ă3uĕ
ă3uŏ
ă2v1a
ă2v1á
ă2væ
ă2v1ǣ
ă2vǽ
ă3vĕ
ăx2
ă2xu
ắb5ĭī.
3ắbl
ắb6stĭn
ắb4s5tr
ắ3bŭ
ắdă4
ắd6ămān
ắd6ămās
ắd3ăq
3ắdd
ắd3ĕŏ
ắd3ĕs
3ắdh
ắd3ĭ4c
ắd3ĭĭ
ắd5ĭ4ta
ắd5ĭ4tā
ắd5ĭ4tă
ắd5ĭ4tæ
ắd5ĭ4tǣ
ắd5ĭ4tī
ắd5ĭ4tū
3ắdj
3ắds
ắ1ĕ
1ắf
3ắgg
ắ4gĭĕ
2ắ1i
ắ3ĭēn
ắ3ĭī.
ắ3ĭ2t
2ắj
ắl3u
ắm4b5ĭt
3ắmna
3ắmnæ
3ắmnǣ
3ắmp
3ắmt
ắ4nĭm
ắn2ŏ
ắn6tĕrō
3ắntr
ắ2r
ắ3r2ă
ắră3g
ắ3rēn
ắ3rĕ
ắ3rī
ắ3rĭ
ắ3rŭ
ắ2sp
ắs4tān
ắs4tăt
ắs4tēs
5ắs4tĕm
ắs6tĕnt
5ắs4tĕt
5ắstĭt
2ắ2t
ắ3ta
ắ3tā
ắ3tă
ắ3tæ
ắ3tǣ
ắ3tē
ắ3tĕ
ắ3tī
ắ3tō
ắ3tŏr
ắ3tr
3ắtt
ắ3tū
ắ3tŭ
ắ3uŏ
áa2t
áb2ac
áb2a3q
áb3aui
áb3avi
áb2eq
áb2ia
á2bie
áb4ies
3á2biē
áb4iēs
3á2bii
áb4iis
3á2biī
áb3iī.
áb2iu
1ábī
3á2bl
áb2o
ábs2c
áb5sci
áb2sq
áb5s4te
áb4stin
áb3sto
áb4str
á3bu
2áce
áda2
ád6amans
ád4amas
ád4amān
ád4amās
3ádd
áde2d
ád1ē
3ádh
á2d3i2c
ádi2g
ád2ip
ádi3pi
3ádj
1ádm
á3do
ád4ora
ádo4ri
á3dō
3áds
ád1u
á3eant
á3eat
áe2ă
áe4cue
áe3d2
áe2eo
áe2eō
áe3es
áe3g2
áei2
2áen
2áe3q
3áequa
3áequā
3áequă
5áequem
5áequer
5áeques
5áequet
3áequē
5áequĕm
5áequĕr
5áequĕt
3áequo
3áequō
3áequŏ
áe1r
áer4i
áes4ca
áes4ci
áes4ta
áes4te
áes4tē
áes4tī
áes4tō
áete3
áetĕ3
áetĕ5r
áe3ut
áe2ŭ
áe2x
1áf
ág2a
á3gæ
1áge
á2ger
3ágg
á2giā
á2giæ
á2giǣ
á2giē
á2gim
á2git
á2gn
ág3no
á3gr
á1h
ái2a
á2ia.
á2iae
á2iam
á3iane
á3iaq
á2ias
á3iau
á3iav
á2ia͞
á2ia͡
á2iā
á2iæ
á2iǣ
á3ieq
á3ieu
á3iev
á2iis
á3iit
á1iī
á1i2t
á1iu
1álp
á2l3ua
á2luā
á2l3uæ
á2luǣ
á2l3ue
ál3uē
ál3uin
á4l3uis
ál3uīs
ál3uu
ám1
á1m2a
1ámb
ám4bes
ám2bē
ám4b3ia
ám4biā
ám4b3io
ám4b3i4t
ámb4iui
ámb4iv
ám2e
áme3s
ám2ē
2ám2i
ám2ī
2ámn
3ámnæ
3ámnǣ
á1mo
3ámp
2ámq
3ámt
2ámu
á3m2uē
2ámv
án2cu
á2nim
3ánnu
án2o3
án4s3ea
án4s3eo
án2si2
áns3it
án4t3ea
ánte3i
ánt5ero
ánt5erō
3ántr
á1nu
án2ua
á2nue
án2uī
án2ū
ápe3r
á3pi
á2pn
2áq
á2qui
á1r
2ár2a
ár5cha
2árd
2áre
2ár2i
3árid
2áro
ár2sp
2áru
á2r3ua
á2r3uā
ár3uæ
á2rue
á4ruis
á3rum
á3run
á2ruo
á2r3uō
á2ruu
2ás
ás3c
ás4er
ás2i
áspe3
ás3pī
ás2pu
ás4tān
ás4tēs
á4sti
ás5ti.
ás5tis
3ástit
ás3to
ás3tri
ás5trum
2át
át3a4g
áte3r
á5trix
3átt
á1u
2áue
á2ul
á2u1m
á2un
áupe3
áupe5r
á2u1r
á2ut
á2ux
áu2xu
2áv
áx2a
áx4eu
áx2i
á2xia
á2xiæ
á2xii
á2xio
á2xiu
áx2ī
áx2o
áx2ō
áx4us
æ1
2æa
æa2b1
æa2m
æ2a3n
æ2a3q
æ2a3r
æ2as
2æ2ā
2æă
æ2ăn
æ2ă3q
æ2ău
æ2ăv
æắ2
2æá
æá2c
æ2ám
æ2án
æ2ár
2æ2æ
2æ2ǽ
æb2
æbe3r
æ2c3ue
1æd2
æde2s
ædē2s
æ2di
æ2dĭ
æ3do
æd4or
æ3dŭ
æd4ŭĕ
2æe2
æ2e3n
æ2eo
æ2eō
æ2eó
æ2e3q
æe4ra
æe4ro
æe4rō
æ3es
æ2eu
æ2eú
æ2ev
æex3
2æ2ē
2æĕ2
æ2ĕō
æ2ĕ3q
æĕ4rō
æ2ĕŭ
æĕ́2
2æ2é
æ3é2r
æ3és
æ2g2
æge2
ægé2
æ3gn
2æi2
æ3ic
æ2in
æ2i3q
æ2is
æ2i3ue
æ2i3v
2æ2ī
æĭ2
æĭ́2
2æ2í
æ3í2c
æmo4nu
æmō2
2æn
æn2ā
æ3ne
æne3ī
æ3nē
æ3nĕ1
æ3né
æ2nin
æni3t
æn1ī
æní3t
2æ2o
2æ2ō
æ2ŏ
2æ2ó
æó2nu
æó1r
æpo6te6ri
æpo6te6rí
æpo4tes
æpo4tés
æpŏ4tĕs
æpó4tes
æ2qua
æ2quā
æ2quá
4æ3que.
4æquĕ.
æ4quĕm
æ4quĕr
æ4quĕt
æ4quĕ́
ær2
æ3ră
æres3
æ3rē
ærĕ2s3
æs2c
æs3cu
æs3cŭ
æs3cú
æs2i
æs2p
æspe3
æs3po
æs3pō
æs3pó
æst2
æsti5t4
æstí3t4
æte5ram
æte5ran
æte5rar
æte6re6ri
æte6re6rí
æte6reru
æte4res
æte4rés
æte4r3i4
æte4r3ī4
æterī́4
æte4rí4
æter5ímu
æter5íti
æter5íu
æter5ív
æte3ro
æte3rō
æte5run
ætĕ4r3ī4
ætĕrī́4
ætĕ4rĭē
ætĕ4r5ĭī
ætĕ4rĭt
ætĕr5ĭ6tā
ætĕrĭ6tĕ
ætĕ5rĭtĭ
ætĕrĭ6tō.
ætĕrĭ6tōn
ætĕrĭ6tōq
ætĕrĭ6tōu
ætĕrĭ6tōv
ætĕrĭ6tṓn
ætĕrĭ6tṓq
ætĕrĭ6tṓu
ætĕrĭ6tṓv
ætĕrĭ́4
ætĕ6rĭ́ĕ
ætĕ6rĭ́t
ætĕ3rŭ
ætĕ́6rĕ6rĭ
ætĕ́4rī
ætĕ́6r5ĭī
ætĕ́6r5ĭt.
ætĕ́6r5ĭ6tā
ætĕ́6rĭ6tĕ
ætĕ́6rĭ6tō
æté6re6ri
æté4r5es
æté4ri.
æté4rie
æté4riē
æté4r5ii
æté4r5iī
æté4r5is
æté4rit
ætér5it.
ætér5ita
ætér5i6tā
ætéri6te
ætéri6ti
ætéri6to.
ætéri6tō
æ3tr
æu2
æū2
2æŭ
æ2ŭs
æ2ŭ́
2æ2ú
æx2
æ2x3u
ǣ1
2ǣa
ǣa2b1
ǣa2m
ǣ2a3n
ǣ2a3q
2ǣ2ā
2ǣă
ǣ2ăn
ǣ2ă3q
ǣ2ău
ǣ2ăv
ǣắ2
2ǣá2
ǣ2ám
ǣ3ámb
2ǣ2ǣ
ǣ2c3ue
1ǣd2
ǣda2r
ǣdē2s
ǣ2di
ǣ2dĭ
ǣ3do2
ǣd4or
ǣdó2
ǣ3dŭ
ǣd4ŭĕ
2ǣe2
ǣ2e3n
ǣ2eō
ǣ2e3q
ǣe4ra
ǣe4rō
ǣ3es
ǣ2eu
ǣ2eú
ǣ2ev
2ǣ2ē
2ǣĕ2
ǣ2ĕō
ǣ2ĕ3q
ǣĕ4rō
ǣ2ĕŭ
ǣĕ́2
ǣé2
ǣ3és
ǣ2g2
ǣge2
ǣgé2
ǣ3gn
ǣi2
ǣ3ic
ǣ2is
2ǣ2ī
ǣĭ2
ǣĭ́2
ǣí2
ǣmō2
2ǣn
ǣn2ā
ǣ3ne3
ǣ3nē
ǣ3nĕ1
ǣni3t
ǣn1ī
ǣní3t
ǣ2o
2ǣ2ō
ǣ2ŏ
ǣ2ó2
ǣpote4
ǣpo4t5er
ǣpo4t5es
ǣpoté4
ǣpo4tér
ǣpo4t5és
ǣpŏ4tĕs
ǣpó4t3e
ǣ2quā
4ǣ3que.
4ǣquĕ.
ǣ4quĕm
ǣ4quĕr
ǣ4quĕt
ǣ4quĕ́
ǣr2
ǣra2r
ǣ3ră
ǣrá2
ǣres3
ǣ3rē
ǣrĕ2s3
ǣro2
ǣró2
ǣs2c
ǣs3cu
ǣs3cŭ
ǣs3cú
ǣs2i
ǣs2p
ǣs3pō
ǣst2
ǣsti5t4
ǣstí3
ǣstít4
ǣte5ram
ǣte5ran
ǣte5rar
ǣte6re6ri
ǣte6re6rí
ǣte6reru
ǣte4r5es
ǣte6réri
ǣte4r5és
ǣter5iē
ǣter5iī
ǣte5rim
ǣter5i6tā
ǣteri6te
ǣte5riti
ǣte5rití
ǣte5rito
ǣteri6tō.
ǣteri6tōn
ǣteri6tōq
ǣteri6tōu
ǣteri6tōv
ǣteri6tṓn
ǣteri6tṓq
ǣteri6tṓu
ǣteri6tṓv
ǣte5ritó
ǣte5r6i5tur
ǣte5ritúr
ǣte4r3ī4
ǣterī́4
ǣterí4
ǣte4ríe
ǣte4rít
ǣte3ro
ǣte3rō
ǣte5run
ǣtĕ4r3ī4
ǣtĕrī́4
ǣtĕ4rĭē
ǣtĕ4r5ĭī
ǣtĕ4rĭt
ǣtĕr5ĭ6tā
ǣtĕrĭ6tĕ
ǣtĕ5rĭtĭ
ǣtĕrĭ6tō.
ǣtĕrĭ6tōn
ǣtĕrĭ6tōq
ǣtĕrĭ6tōu
ǣtĕrĭ6tōv
ǣtĕrĭ6tṓn
ǣtĕrĭ6tṓq
ǣtĕrĭ6tṓu
ǣtĕrĭ6tṓv
ǣtĕrĭ́4
ǣtĕ6rĭ́ĕ
ǣtĕ6rĭ́t
ǣtĕ3rŭ
ǣtĕ́6rĕ6rĭ
ǣtĕ́4rī
ǣtĕ́6r5ĭī
ǣtĕ́6r5ĭt.
ǣtĕ́6r5ĭ6tā
ǣtĕ́6rĭ6tĕ
ǣtĕ́6rĭ6tō
ǣté6re6ri
ǣté4r5es
ǣté4riē
ǣté4r5iī
ǣté6r5it.
ǣté6rita
ǣté6r5i6tā
ǣté6ri6te
ǣté6ri6tō
ǣu2
ǣ3ue.
ǣue2r
ǣ3uĕ.
ǣū2
2ǣŭ
ǣ2ŭs
ǣ2ŭ́
2ǣ2ú
ǣ3úmb
ǣ3ve.
ǣ3vĕ.
ǣx2
ǣ2x3u
ǣ2́
ǣ́3da
ǣ́3dă
ǣ́3e2r
ǣ́3es
ǣ́3ĕ2r
ǣ́2g2
ǣ́3gn
ǣ́4gr
ǣ́1i2
ǣ́1ĭ2
ǣ́3l
ǣ́2mu
ǣ́2mŭ
2ǣ́3n
3ǣ́4qua
3ǣ́4quā
3ǣ́4quă
5ǣ́4quem
5ǣ́4quer
5ǣ́4quet
3ǣ́4quē
5ǣ́4quĕm
5ǣ́4quĕr
5ǣ́4quĕt
3ǣ́4quo
3ǣ́4quō
3ǣ́4quŏ
ǣ́s4ca
ǣ́s4ci
ǣ́s4cī
ǣ́s4cĭ
ǣ́s4ta
ǣ́s4tă
ǣ́s4tǣ
ǣ́s4te
ǣ́s4tē
ǣ́s4tĕ
ǣ́s4tī
ǣ́s4tō
ǣ́tĕ3
ǣ́4th
ǽ1
2ǽ2a
2ǽ2ā
ǽ2ă
2ǽæ
ǽc3ue
ǽ3da
ǽ3dă
ǽ2e
ǽ3e2r
ǽ3es
ǽ2ĕ
ǽ3ĕ2r
ǽ3ĕs
ǽg2
2ǽi2
ǽ2is
2ǽ2ī
ǽĭ2
ǽ2mu
ǽ2mŭ
2ǽn
ǽ3ne
ǽ3nĕ
ǽ2o
ǽ2ō
ǽ2ŏ
ǽ2qua
3ǽ2quā
3ǽ2quă
4ǽque.
ǽ4quem
ǽ4quer
ǽ4ques
ǽ4quet
3ǽ2quē
3ǽ4quĕm
3ǽ4quĕr
3ǽ4quĕt
ǽ2quo
3ǽ2quō
3ǽ2quŏ
ǽr2
ǽ3ră
ǽst2
ǽ2stu
ǽte1
ǽtĕ3
ǽu2
ǽ2um
ǽ2ŭ
ǽ3ŭt
ǽ2x
1b
3ba.
bab2o
bab4u
ba2c
ba3ci
ba3cí
b2acu
b2acú
2b1a2d3
3bae
b2aeq
b2aeu
b2aev
ba2g
ba3gē
ba3gu
ba3gú
ba3ian
ba3ián
ba3ion
ba3ió
ba2it
ba3iú
b1a2l
b2ami
b2an
b2ap
b1a2q
ba3que
ba2rā
b2a2ru
5barum
ba4sp
bas5pe
bas3t
bas5te
bas5tr
b3a2tr
ba4uen
ba4ueq
ba4ueu
ba2uī
ba2uo
ba2uō
ba2uó
ba2uu
ba2uú
3bav
ba4ven
ba4veq
ba4vev
b3a2vī
b3a2vo
b3a2vō
ba2vó
b3a2vu
ba2vú
2b1a2x
b1āc
2b1ā2g
bā2ic
bā2ĭ
b2ān
b2ār
b3ā2tr
b3ā́c
2b3ā́2g
b1ăb
3bă2c
bă3cŭ
b1ă2d3
bă2g
bă3gē
bă3gŭ
3bă2l
băm3
b2ăn
b2ăp
b1ă2q
b3ă2rŏ
3bărr
bă4sp
băs5pĕ
băs3t
băs5tĕ
băs5tr
b2ăt
bă4uĕn
bă4uĕq
bă4uĕu
b3ă2uī
b3ă2uō
b3ă2uŭ
bă4vĕn
bă4vĕq
bă4vĕv
b3ă2vī
b3ă2vō
b3ă2vŭ
b1ă2x
3bắc
b3ắ2d3
b2ắn
b3ắ2u
b3ắ2v
b3ắ2x
b2áb
b1ác
2b1á2d3
b2áeu
b2áev
2b1á2g
bá3ian
b2án
bá2ru
b3ásp
b2áu
bá4uen
bá4ueq
bá4ueu
bá4ven
bá4veq
bá4vev
2b1á2x
b1æ2
b2æ3q
b2æu
bæ3ue
bæ3uĕ
b2æ3v
b1ǣ2
b2ǣ3q
b2ǣu
bǣ3ue
bǣ3uĕ
b2ǣ3v
b2ǣ́
b3ǣ́m
b2ǽq
b2ǽu
b2ǽv
2bb2
b3ba
bba3q
b3bā
b3bá
b3bæ3
b3bǣ
b3bǽ
b3be3
b3bē
b3bé
b3bi
b3bī
bbī3u
bbī3v
b3bí
b3bo
b3bō
b3bó
b3bu
b3bŭ
b3bú
2bc
2bd
bde2s
bdē2s
b3do
bd4or
bdū3r
be2a
3beæ
3beǽ
3bec
becī́3
b1ed2
be2dā
be2de
be2dē
be2dé
be2d4i
be2dī
be2dí
be2d4o
be2dō
be2dó
be2du
be2dú
3be2e
3beé
b1e2g
3bei
be3iǣ
be3iē
3beí
b2el
b2em
b2en
be4n3ia
be2o
b1e2q
be3ra
be5ra.
be5raq
be5rau
be5rav
be3r2æ3
be3r2ǣ
ber2e
3berea
3bereá
3bereæ
3bereǽ
be4rec
3beree
3bereé
3berei
3bereí
3bereo
3bereó
3bereú
bere5x4
be3rē
3beréa
be4réc
3berée
b3eréx
ber4i
be3ria
be3riá
be3rib
be3ri5c
3be3rie
3be3rié
be3rii
be3rií
3be3ri3n
be5rite
be3riu
be3riú
be3riv
be3rī
be4ríg
3berín
be4rít
be4rn
be3ro
be3rōr
be3rōs
be4rq
3berúm
be4rún
be4rv
be2s
be4sa
be4si
be4sn
be4so
be4sq
2best
be4su
be4sv
b1e2u
2beun
b1eú
b2ev
b1e2x
b2ēb
2b1ē2d
b1ē2g
bē6iaene
bē6iaeue
bē6iaeve
bē4iam
bē4ian
bē4iāne
bē6iāque
bē4iāru
bē4iārú
bē6iāsne
bē6iāsue
bē6iāsve
bē4iāue
bē4iāve
bē6iā́ne
bē6iā́ru
bē6iā́ue
bē6iā́ve
bē6iáene
bē6iáeue
bē6iáeve
bē4iám
bē4iæne
bē6iæque
bē4iæue
bē4iæve
bē4iǣne
bē6iǣque
bē4iǣue
bē4iǣve
bē6iǣ́ne
bē6iǣ́ue
bē6iǣ́ve
bē4iǽne
bē6iǽque
bē4iǽue
bē4iǽve
bē6iīsne
bē6iīsue
bē6iīsve
b2ēm
b2ēn
bē3ne
bē2s
bē4sa
bēs3tĭ
b2ēu
b2ēv
2b3ḗ2d
bḗ2g
bḗ3l2
b2ḗm
bḗ2s
b3ḗse
b3ḗsĕ
b3ḗsī
b3ḗss
b3ḗst
b2ḗu
b2ḗv
3bĕ.
3bĕa
bĕ2ă
3bĕæ
3bĕǣ
3bĕc
bĕcī́3
b1ĕd2
bĕ3da
bĕ2dā
bĕ4dă
bĕ2dē
bĕ2dĕ
bĕ2dī
bĕ2d4ĭ
bĕ2dō
bĕ2dŏ
bĕ2dŭ
3bĕē
3bĕĕ
3bĕī
3bĕl
b2ĕm
3bĕ2q
bĕ3r2a
bĕ3r2æ
bĕ3r2ǣ
bĕ3rē
bĕ3r4ĕ
bĕ3rī
bĕ3rŏ
b3ĕrŭn
b1ĕs
b2ĕt
3bĕu
2bĕŭn
3bĕv
2b1ĕx
bĕ́4dĭ
bĕ́2q
bĕ́3rĕ
b1éd
bé2di
b1é2g
bé1i
bé3ie
bé3iē
b2él
b2é1m
bé4n3ia
3béra
3bérie
bé4rig
bé4rim
bé4riti
bé2ru
bé2s
bé4sa
b3ése
b3ési
b3éss
b3ést
b1é2x
2bf
b1h
bi2a
3b2ia.
3b2ian
3b2iaq
3b2iau
3b2iav
b2iā
b4iā́n
2biă
3b4iáni
3b4iáno
b2iæ
b2iǣ
b2iǽ
b1i2c
b1ie
3bieg
b1iē
2biĕ
b1ié
3biég
2b1i2g
5bigena
5bigenā
5bigená
5bigenæ
5bigenǣ
5bigenǽ
5bigenen
5bigeneq
5bigeneu
5bigenev
5bigenē
5bigené
5bigeni
5bigenī
5bigení
5bigeno
5bigenō
5bigenó
5bigenu
5bigenú
5bigéna
5b4igéne
bi4g3n
b1ii
3b4iis.
3b4iisn
3b4iisq
3b4iisu
3b4iisv
b2iī
3biīs
3biī́s
2biĭ
3b4iísn
3b4iísq
3b4iísu
3b4iísv
b2il
b1in
b3int
3b2io
bio2s
b2iō
b2ió
2b1i2r
b4i3ter
bi4tio
bi4tiō
4b3i4tud
4bi4tui.
4bi4tuin
4bi4tuiq
4bi4tuiu
4bi4tuiv
4bi4tuī.
4bi4tuīn
4bi4tuīq
4bi4tuīu
4bi4tuīv
6bi6tuī́n
6bi6tuī́q
6bi6tuī́u
6bi6tuī́v
4bi4tuín
4bi4tuíq
4bi4tuíu
4bi4tuív
4b3i4tuú
bi4tūd
bi4tūs
4bi4túd
b1iu
bi3u2b
2bi2ue
2bi2ué
4bi4uim
4bi4uin
4bi4uiq
4bi4uis
4bi4uit
4bi4uiue
bi3uī
2bi2uí
3biuía
b2ium
2biun
b2ius
b2iús
b1iv
bi2ve
2bi2vé
4bi4vim
4bi4vin
4bi4viq
4bi4vis
4bi4vit
4bi4viv
bi3vī
2bi2ví
3bivía
bi2x3
b1ī
2bī2b
3bī3c
bī2mi
bī2mĭ
bī2r
b3ī2to
b3ī2tŏ
b3ī2tó
bī2u
bī2v
bī́2b
3bī́c
bī́2m
bī́2r
bī́4to
bī́4tŏ
bī́4ui
bī́4uī
bī́4uĭ
bī́4vi
bī́4vī
bī́4vĭ
b2ĭb
b1ĭ2c
b1ĭē
b1ĭĕ
3bĭĕg
3bĭĕ́g
2b1ĭ2g
5bĭgĕna
5bĭgĕnā
5bĭgĕnă
5bĭgĕná
5bĭgĕnæ
5bĭgĕnǣ
5bĭgĕnǽ
5bĭgĕnē
5bĭgĕnĕn
5bĭgĕnĕq
5bĭgĕnĕu
5bĭgĕnĕv
5bĭgĕnī
5bĭgĕnō
5bĭgĕnŭ
5bĭgĕ́nă
5bĭgĕ́nĕ
b4ĭīs
b1ĭĭ
b2ĭl
b2ĭm
b1ĭn
b4ĭ3tĕr
bĭ4tĭb
bĭ4tĭō
bĭ4tūd
b3ĭ4tūs
4bĭ4tŭī.
4bĭ4tŭīn
4bĭ4tŭīq
4bĭ4tŭīu
4bĭ4tŭīv
6bĭ6tŭī́n
6bĭ6tŭī́q
6bĭ6tŭī́u
6bĭ6tŭī́v
4b3ĭ4tŭŭ
bĭ́4cĭ
6bĭ́6gĕnĕ
4b5ĭ́4gĕq
4b5ĭ́4gĕr
4b5ĭ́4gĕu
4b5ĭ́4gĕv
4b3ĭ́4gĭ
4b3ĭ́gn
4b3ĭ́4gŭ
bĭ́4tĭb
6bĭ́6tŭī.
4b5ĭ́4tŭŭ
3bía
bí2ba
bí2bo
bí2bu
bí2ci
b1í2g
4bígene
4bígeq
4bíger
4bígeu
4bígev
2bígi
2bí4g3n
2bígu
b1íi
b2íl
2bí2mu
b3ínt
2b1í2r
2bí2to
bí4tui.
5bítuis
5bítuīs
5bítuo
5bítuō
5bítut
4bí4uer
4bí4ui.
4bí4uim
4bí4uit
4bí4ver
4bí4vi.
4bí4vim
4bí4vit
bí2x
2bj
bl2
2blŏ
b3lu
2blŭ
b2ly
2b1m2
2b1n2
bne3g
bne3u2
bnĕ3g
bné1
bnéu2
b3ni
b3nĭ
bno3b2
bnŏ3b2
b3nu
bn4ue
b1o
3bo2a
bo4am
boa3q
bo2á
bo2æ3
bo2ǽ3
bob2ú
bo2e
bo2ē
bo3iá
bo2ii
bo2ií
bo2i3q
bo2iu
bo2iv
bo2ī
boī3u
boī3v
boī́3u
boī́3v
bo2í
bo2l
b3olet
bo3lín
bo3líq
bo3lís
bo3líu
bo3lív
bol4u
bo2m
b2o1n
bo3ni
bo2o
bo2ō
bo2ó
b2ora
b2orá
b2ore
b2oré
bo2ri
bo3ri.
bo3rin
bo3riq
bo3ris
bo3riv
borí3t
bo4rn
b2oro
b2oró
bo4rq
bo2ru
bo4rv
3bo2s
bo4sn
bo4sq
b2o4su
bo4sv
bo3ue
bo3v
b1ō2m
b2ōn
b1ōr
bṓ3i
b3ṓ2m
bŏ2ă
b1ŏd
bŏ2ē
bŏ2ī
bŏī3u
bŏī3v
bŏī́3u
bŏī́3v
bŏ2l
b3ŏlĕt
bŏ2ō
b2ŏ3rĕ
bŏ3rī.
bŏ3rīn
bŏ3rīq
bŏ3rīs
bŏ3rīu
bŏ3rīv
bŏ5rī́n
bŏ5rī́q
bŏ5rī́s
bŏ5rī́u
bŏ5rī́v
bŏ2rĭ
bŏ2s
bŏ4́l
bŏ́4lĕā
bŏ́4lĕă
bŏ́4lĕō
bŏ́4lĕŏ
bŏ́4lŭ
bó3ia
bó3iæ
bó4lea
bó4leā
bó3len
bó4leo
bó4leō
bó3leq
bó3leu
bó3lev
ból2u
b1ó2m
b2óra
b2óre
bó4rie
bó4riē
b2ós
b3ósc
2b1œ2
bœ4da
bœ4dă
bœ̄2
bœ̄4d
bœ̄́2
bœ́2
br2
bra3d4
b2rā
b2rá
b4rác
b2ræ
bræ2ă
b2rǣ
brǣ2ă
b2rǽ
b1re
bre2i
brē2i
2bria
2briá
b2rim
b1rī
b2rĭd
b4rĭē
2brĭĕ
b2rĭm
b1ro
b2rot
b1rŏ
b4rŏt
b1ru
b2rus
b1rŭ
b2rŭs
b4rŭ́s
b2rús
b2ry
b2rý
2b1s
b4s5caen
b6s5ca͞en
b6s5cá͞en
b6s5ca͡en
b6s5cá͡en
b4s5cáen
b4s3cæn
b4s3cǣn
b4s5cǣ́n
b4s3cǽn
b2s3ce
b2s3cē
b2scĕ
b2s3cé
b4scid
bs6cidera
bs6ciderá
bs6cidere.
bs6ciderene
bs6cidereq
bs6cidereu
bs6ciderev
bs6cideri
bs6ciderí
bs6cidero
bs6cideró
bs6cideru
bs6ciderú
bs6cidére
bs6cidérim
bs6cidérit
bs6cidéru
bs6cidi.
bs6cidimus
bs6cidimús
bs6cidin
bs6cidiq
bs6cidis
bs6cidit.
bs6ciditn
bs6ciditq
bs6ciditue
bs6ciditv
bs6cidiu
bs6cidiv
bs6cidín
bs6cidíq
bs6cidíss
bs6cidíst
bs6cidítn
bs6cidítq
bs6cidítu
bs6cidítv
bs6cidíu
bs6cidív
bs4ciss
b2scī
bs2cĭ
b4scíd
bs6cídera
bs6cíderi
bs6cídero
bs6cídimus
bs4císs
b4scísu
bs2e
bs2q
bs2ta
bs2tā
bs2tă
bs2tá
b5s4tem.
b5s4temn
b5s4temq
b5s4temu
b5s4temú
b5s4temv
b4sten
b5s6tent.
b5s6tentn
b5s6tentq
b5s6tentue
b5s6tentv
bs4tern
bs4tes
bs4tet
b5s4tēmu
b5s4tēmŭ
b5s4tēmú
bs4tēs
bs4tēt
b7s6tḗmu
b7s6tḗmŭ
bs4tḗs
bs4tḗt
bs4tĕm
b4stĕn
b5s6tĕnt.
b5s6tĕntn
b5s6tĕntq
b5s6tĕntu
b5s6tĕntv
bs4tĕrn
bs4tĕt
bs4tĕ́m
bs6tĕ́ntn
bs6tĕ́ntq
bs6tĕ́ntu
b6stĕ́ntŭ
bs6tĕ́ntv
bs6tĕ́rn
bs4tĕ́t
b4stémi
bs4témn
bs4témq
bs4tému
bs4témv
b5s6téntn
b5s6téntq
b5s6téntue
b5s6téntv
bs4térn
bs4tés
bs4tét
b5stit
b5stĭt
b5s4tĭ́t
b4stín
bs4tít
b2sto
b3s4to.
b3s4ton
b3s4toq
b3s4tou
b3s4tov
bs2tō
b2stŏ
b5s4tón
b5s4tóq
b5s4tóu
b5s4tóv
bs4trar
bs4tras
bs4trat
bs4trau
bs4trav
bs4trār
bs4trās
bs4trāt
bs4trāu
bs4trāv
bs6trā́r
bs6trā́s
bs6trā́t
bs6trā́u
bs6trā́v
b4stră
bs4trár
bs4trás
bs4trát
bs4tráu
bs4tráv
b2sue
2bt2
btes5t
bte6ste
btē6ste
btē6stĕ
b3tu
btū3s
bu3b2
bu4lue
2bum
4b3undā
b2uni
b2uní
buol5ue
buol5ué
buol5ui
buol5uī
buol5uí
b1ur
bur5ue
3bus
b4us.
busa4t
bu2s3ā2
bu2se
b4usn
bu4so
bu2só
bu2sp
b4usq
bu2su
bu2sú
b4usv
b1ūn
b1ūr
bū3rĭ
bū2su
2b3ū́4s
b2ŭē
b2ŭĕ
b2ŭī
b2ŭĭ
2bŭm
b2ŭ2s
b4ŭs.
b4ŭsn
b4ŭsq
b4ŭsu
b4ŭsv
3b2ŭ́l
b2úl
2búll
6búndans
6b5úndant
4b5úndat
4b5úndem
6b5úndent
4b5úndes
4b5úndet
3bú2s
bú4sa
b2y
b2ȳ
b2ý
1c
c2a
cab2
ca3d2
cad4u
3caena
3caenā
3caenă
3caená
3caene
3caenē
3caenĕ
3caené
3caeno
3caenō
3caenó
3caenu
3caenŭ
3caenú
cae4sp
ca2ie
ca2ii
ca2iō
3cam
ca3ni
ca3ní
3cant
3car
ca3rē
car4uī
caspe3
cas3t
cas5tr
3cat.
cate3i
2catē
catē3i
catḗ5i
caté3i
3catn
3catq
3catu
3catv
ca2u3a
ca2u3á
ca2v3a
ca2vá
ca2x3
5ca͞ena
5ca͞enā
5ca͞enă
5ca͞ená
5ca͞ene
5ca͞enē
5ca͞enĕ
5ca͞enō
5ca͞enu
5ca͞enŭ
5ca͞enú
5cá͞ena
5cá͞enā
5cá͞enă
5cá͞ene
5cá͞enē
5cá͞enĕ
5cá͞enō
5cá͞enu
5cá͞enŭ
5ca͡ena
5ca͡enā
5ca͡enă
5ca͡ená
5ca͡ene
5ca͡enē
5ca͡enĕ
5ca͡ené
5ca͡eno
5ca͡enō
5ca͡enó
5ca͡enu
5ca͡enŭ
5ca͡enú
5cá͡ena
5cá͡enā
5cá͡enă
5cá͡ene
5cá͡enē
5cá͡enĕ
5cá͡eno
5cá͡enō
5cá͡enu
5cá͡enŭ
cā5bun
cā4iae.
cā6iaene
cā6iaeque
cā6iaeue
cā6iaeve
cā6ia͞e.
cā6ia͞ene
cā6ia͞eque
cā6ia͞eue
cā6ia͞eve
cā6iá͞ene
cā6iá͞eque
cā6iá͞eue
cā6iá͞eve
cā6ia͡e.
cā6ia͡ene
cā6ia͡eque
cā6ia͡eue
cā6ia͡eve
cā6iá͡ene
cā6iá͡eque
cā6iá͡eue
cā6iá͡eve
cā2iā
cā6iáene
cā6iáeque
cā6iáeue
cā6iáeve
cā4iæ.
cā4iæne
cā6iæque
cā4iæue
cā4iæve
cā4iǣ.
cā4iǣne
cā6iǣque
cā4iǣue
cā4iǣve
cā6iǣ́ne
cā6iǣ́que
cā6iǣ́ue
cā6iǣ́ve
cā4iǽne
cā6iǽque
cā4iǽue
cā4iǽve
cā4iīs.
cā6iīsne
cā6iīsque
cā6iīsue
cā6iīsve
cā6iī́sne
cā6iī́sque
cā6iī́sue
cā6iī́sve
cā2iu
cā2iú
cā3s4uī
cā́5suī
c2ă
căd2
că2ĭ
3căm
că3nĭ
3cănt
3căr
că3rē
că3rĕ
căs3
căs5tr
3căt.
2cătē
2cătĕ
3cătn
3cătq
3cătu
3cătv
3cắm
cắ5nĭ
3cắr
cắ3rē
cắ3rō
3cáena
3cáenā
3cáenă
3cáene
3cáenē
3cáenĕ
3cáeno
3cáenō
3cáenu
3cáenŭ
cá3ni
cár4ui
cár4uī
cá2x
c2æ
3cæ.
cæ3d
cæ3n2
3cæna
3cænā
3cænă
3cæná
3cænæ
3cænǽ
3cæne
3cænē
3cænĕ
3cæné
3cæno
3cænō
3cænó
3cænu
3cænŭ
3cænú
3cæq
cæ2s3p
c2ǣ
3cǣ.
cǣ3d
cǣn2
3cǣna
3cǣnā
3cǣnă
3cǣná
3cǣnǣ
3cǣne
3cǣnē
3cǣnĕ
3cǣnō
3cǣnu
3cǣnŭ
3cǣnú
3cǣq
cǣ2s3p
3cǣ́na
3cǣ́nā
3cǣ́nă
3cǣ́nǣ
3cǣ́ne
3cǣ́nē
3cǣ́nĕ
3cǣ́nō
3cǣ́nu
3cǣ́nŭ
3cǽna
3cǽnā
3cǽnă
3cǽnæ
3cǽne
3cǽnē
3cǽnĕ
3cǽno
3cǽnō
3cǽnu
3cǽnŭ
cǽ2sp
2cc2
2c2d2
c3du
c3dŭ
c2e
3ce2a
3ceá
3ceæ
3ceǽ
3ceb
ce3d2
ced4o
3ce2e
3ceé
3ce2i
3ceí
3cemú
4c5e4nare
4c5e4naré
6c5e6nari.
6cenarib
6c5e6narin
6c5e6nariq
6c5e6naris
6c5e6narit
6c5e6nariue
6c5e6nariv
6c5e6narín
6c5e6naríq
6c5e6narís
6c5e6naríu
6c5e6narív
4c5e4náre
6c5e6nári.
6cenárib
6c5e6náris
6c5e6nárit
4c3ennā
3cent
3ce2o
3ceó
cepe3
ce3ra
ce3r2æ3
ce3r2ǣ
2cerb
ce3rē
ce3r4i
ce3rī
ce3ro
ce3rō
cer5ue
cer3uē
cer3ué
ce3run
ce2sp
ce2sq
ce2su
3cet
cete3
cete5r4
ceteri5u
ceteri5v
ce4ua.
ce4uam
ce4uan
ce4uaq
ce4uau
ce4uā.
ce4uān
ce4uāq
ce4uāu
ce4uā́
ce2uă
ce2uá
ce4uī́
ce2uí
3ceum
ce2un
3ceus
3ceú
3cē.
cē2i
4c5ē4nāre
4c5ē4nārē
4c5ē4nārĕ
4c5ē4nāré
6cēnārib
6c5ē6nāris
6c5ē6nārit
4c5ē4nārī
6cēnārĭb
6c5ē6nārĭs
6c5ē6nārĭt
6c5ē6nārĭ́s
6c5ē6nārís
6c5ē6nā́re
6c5ē6nā́rē
6c5ē6nā́rĕ
6cēnā́rib
6c5ē6nā́ris
6c5ē6nā́rit
6c5ē6nā́rī
6cēnā́rĭb
6c5ē6nā́rĭs
6c5ē6nā́rĭt
cē3ne
cēpe3
cēper4
cēpĕ5r
3cēq
cēte3
3cēu
3cēv
c2ĕ
cĕ2ă
cĕ3d
cĕ2ĭ
4c3ĕnnā
cĕ3r2a
cĕ3r2æ
cĕ3r2ǣ
2cĕrb
cĕ3rē
cĕ3r4ĕ
cĕ3rī
cĕ3rŏ
cĕ3rŭ
cĕ2s
cĕ́3rĕ
3cĕ́u
3cĕ́v
c2é
3céa
3céb
céd2
3cée
cé2i
3céne
3cént
3céq
2cérb
3cét
3céu
cé4ua.
cé4uan
cé4uā.
cé3ue
3cév
2ch.
5chane
3chă.
3chăm
3chănĕ
3chăq
3chău
3chăv
3chắm
4cháng
che1
che2i
che2s
chē2i
chĕ1
ch4lĭ
2chm
2chn
2cht
c2i
ci2a
ci4an
ci3b
3cida
3cidá
cide4i
cidē4i
3cido
3cidó
3cid4u
3cidú
cig3
ci4gn
ci2i
cin2ā
2cind
cin4e
cin4é
3cisa
3cisá
3cisæ
3cisǽ
ci4s3c
cis5ci
3cise
3cis2i
3cisí
3ciso
3cisó
4cissa
4cissā
4cissá
4cissæ
4cissǣ
4cissǽ
4cissī
4cisso
4cissō
4cissó
4cissu
4cissū
4cissú
ci4s3t
cis5ta
cis5tā
cis5té
3cisú
3citā
cī3s4uī
c2ĭ
cĭ3b
cĭn2a
cĭn2ā
cĭn2æ
2cĭnd
cĭnĭ5tĕ
cĭnĭ5tō
cĭ4st
cĭs5tā
cĭs5tă
3cĭtā
3cĭtă
4cĭ́nd
4cĭ́ssa
4cĭ́ssā
4cĭ́ssă
4cĭ́ssæ
4cĭ́ssǣ
4cĭ́ssī
4cĭ́ssō
4cĭ́ssū
4cĭ́ssŭ
cí3b
cí3d
cíg3
cí4gn
2cínd
4císsa
4císsā
4císsæ
4císsǣ
4císsī
4císso
4císsō
4císsu
4císsū
cís3t
cí3tuī
cí3tur
cí3tuu
2cj
c2l2
c4lei
c4leī
c4leí
c4leo
c4leō
c4leó
c4leu
c4leú
c4le͞
c4le͡
c3lĕg
c3léc
c3léx
2c2m2
2c1n2
cn4ē3m
3co.
co2a3q
co3ā
coǣ4u
coǣ4v
c2o3b2
cobo3l
coco5m
coc5te
co3ea
co3eā
co3eá
co2ia
co3it
coī2
coī4n
coī́4
coí2t
co3l4u
com1
co4me4d
co4me4s
co2mē
comē4d
comē4s
comḗ4d
comḗ4s
co4mé4d
comé4s
co4mit
comí4t
co4míte
3con1
4conc
co4nia
co4niá
co4niē
co4niú
cons2
co3ō
co2pī
3coq
3cor
co3re
co3rī
cot4e3
co5ter
3cou
3cov
2cōnc
cōn3s2
cō3r
cŏ3ā
cŏǣ4u
cŏǣ4v
c2ŏb2
cŏcŏ3m4
cŏc5tĕ
cŏī2
cŏī4q
cŏī́4
cŏĭ2
cŏ3ĭt
cŏĭ́2
cŏ2m1
cŏmē4d
cŏmē4s
cŏmḗ4d
cŏmḗ4s
cŏmĕ2
cŏm3ĕd
cŏmĭ́4
cŏ3ō
cŏ3pĕ
cŏ2pī
3cŏr
cŏ3rī
cŏ4rs
cŏ3t4ĕ
cŏtĕ3r
3cŏ́
cŏ́3g2
cŏ́3ī
cŏ́4m3ē
cŏ́3rĭ
cób2
cóbo3
có3ea
có3eā
có3em
cóg2
có3ie
có1ī
có3l2u
có4mes
có2m3ē
cómi4ta
cóm5ita.
cóm5i4tā
cómi6te.
cóm5itē
cómi4ti
cóm5iti.
cóm5i4tī
cómi4to
cóm5i4tō
cóm5i6tum
4cónc
có4nia
có4niu
cón3s
có2nu
cót4e3
2cq
cqui4
cquid3
cquí2
cquíd3
c2r2
3cra
3cră
cræ2ă
crǣ2ă
cre3d4
cre5di
cred6it
cre5mi
cre5mo
cre2o
cre3r
cres3
crēs3
2crĕ.
2crĕq
2crĕu
2crĕv
2cri3n
2crip
cri6spé
2crī
3crīm
3crī́m
2crĭă
2crĭb
crĭ6spĕ
2crĭŭ
3crím
cros2
3crō
crŏs2
3crŭ
2ct
ct3enn
cte5re
ct3ĕnn
ctĕ3rĕ
ct3énn
c3tr
cu3b2
cud2
cuda3
2c1uĕ
cu3ia
cu3iá
cu3iæ
cu3iǽ
cu3ii
cu3ií
cu3io
cu3ió
cu3ium
cu3ius
cu3iú
cule4i
4culix
4culíx
2culp
3cu2m1
cuma2
cu3men
cum3i2
cumī́4
cumí2
cumín3
2c3unc
2c3unx
c2uo
cupe3
cuper4a
cuper4ē
cu3ré
3cus
cus4á
cu2s3p
c2ūl
c1ūn
3cūq
cū3rē
cū3rĕ
cū3ré
cū3rĭ
3cūs
cū2su
3cūu
3cūv
c2ŭ
2cŭăr
2cŭăt
cŭ3b2
2cŭēs
2cŭĕt
2c3ŭ2lĭ
3cŭ2m
cŭm3ē
cŭmī́4
cŭm3ĭ
cŭmĭ́4
cŭmĭ́n5
2cŭŏ
cŭpĕ5rĕ
3cŭ2s
2cŭŭn
cŭ́3b
cŭ́m3ĭ
3cŭ́s
cúb2
cú3ia
cú3io
cú3ium
cú3ius
2cúlp
3cúm
cú2ma
cú2m3i2
2c3únc
2c3únx
3cús
2cv
2c2x2
cy4gn
cype3
cý4gn
1d
d2ab2
d1ac
2d1ad
da2dó
dad2u
dad2ū
dad2ú
3dae
d2aeu
d2aev
2d1a2g
da4g3n
d2al
da4mab
da4mand
da4mane
da4mans
da6mant.
d6amante
da6mantn
da6manto
da6mantó
da6mantq
da6mantu
da6mantú
da6mantv
da4maq
da4mat
da4mau
da4mav
da2má
2d3a2me
2d3a2mē
da2mé
d2a3mi
3damn
2da2mo
2d3a2mō
da2mó
2danc
da2ni
da3ni.
da3nib
da3nin
da3niq
da3nis
da3niu
da3niú
da3niv
da2p
d2a3re
da3ri
3darii
3darií
3dario
3darió
3dariu
3dariú
da3rí
d2aru
d2as3
da2x3
3dá͡e
2d1ā2g
d2ān
d2ār
2d3ā́4g
d2ă3b2
d1ăc
d1ăd
dă3d2ū
d2ăg
2d3ă2mē
2d3ă2mĕ
3dămn
2d3ă2mō
2d3ă2mŏ
2dănc
dă2p
dă3ră
dăs3
d2ăt
d2ắ
d3ắmb
5dắmnā
5dắmnă
5dắmnē
5dắmnĕm
5dắmnĕn
5dắmnĕr
5dắmnĕt
5dắmnō
5dắmnŏ
d3ắnĭ
dắ3rē
d3ắrg
d2á
3dáe
dá2g
dá4gn
2d3ámb
2dámp
2dámt
4dántr
dá2p
2d3árg
dás3
2d3áus
dá2x
dæ2a
dæ2ă
dæ2á
dæ2i
d2æu
dæ3ue
dæ3uĕ
dæ2ŭ
d2æ3v
dǣ2a
dǣ2ă
d2ǣu
dǣ3ue
dǣ3uĕ
dǣ2ŭ
d2ǣ3v
d2ǣ́u
d2ǣ́v
d2ǽu
d2ǽv
2dc2
2dd2
dde2s
ddē2s
d3do
dd4or
d2eb
ded2
de2dā
de2dē
ded4i
ded4o
de2dō
3dee
de3es
de3é2r
de3és
d2ef
2d1eg
de3go
3dei
de2ia
de2iá
de4ien
de2ii
de2ií
de4io.
de4ioq
de4ior
de4iou
de4iov
de4ión
de4ióq
de4iór
de4ióu
de4ióv
de2it
de4ium
3deī
3deí
de2ma
de2má
de4me.
de4meb
de4mem
de4mend
de4mene
de4mens
de6ment.
de6mente.
de6mentem
de6menten
de6menteq
de6mentes
de6menteu
de6mentev
de6mentém
de6mentés
de6menti.
de6mentia
de6mentib
de6mentin
de6mentiq
de6mentis.
de6mentisn
de6mentisq
de6mentisu
de6mentisv
de6mentiue
de6mentium
de6mentiúm
de6mentiv
de6mentía
de6mentín
de6mentíq
de6mentísn
de6mentísq
de6mentísu
de6mentísv
de6mentíu
de6mentív
de6mentn
de6mentq
de6mentu
de6mentú
de6mentv
de4meq
de4mer
de4mes
de4meu
de4mev
de2mé
d3e4mi.
d3e4mim
de4mine
d3e4miq
d3e4mis
d3e4mit
d3e4miu
d3e4miv
d3e2mí
d2emn
de4mo.
de4mone
de4moq
de4mor.
de4morn
de4morq
de4moru
de4morv
de4mou
de4mov
de4móne
de4móq
de4mórn
de4mórq
de4móru
de4mórv
de4móu
de4móv
de4munt
de4múnt
d2en
3deo
depe4
deper5
deperi4
deper7iu
deperí4
depé2
depér3
depéri4
2d3ept
de1r
d2e3r2e
dere5x4
de3ré
der4i
deri5c
de3rī
der4í
de3ríc
de1s
de4sca
de4scá
de4sci
de4scí
de4so
de2só
2d3ess
des2t
4dest.
de4s3ta
de4s5tā
de4s3tá
de4s5te
de4s3tē
de4s3té
desti5t4
de4s3tī
destí5t4
4destn
de4s3to
de4s3tō
de4s3tó
4destq
de4s3tú
4destv
de4uĕ
de2ul
2deun
deu4ra
deu4rá
deu4re
deu4ré
deu4ri.
deu4rin
deu4riq
deu4ris
deu4rit
deu4riu
deu4riv
deu4rín
deu4ríq
deu4rís
deu4rít
deu4ríu
deu4rív
de5u4ro.
de5u4ron
de5u4roq
de5u4ror
de5u4rou
de5u4rov
deu4ró
de3u4s
deu4tan
deu4tat
deu4tát
de5u4tet
de3uti
deu4ti.
deu4tin
deu4tiq
deu4tiu
deu4tiv
deu4tín
deu4tíq
deu4tíu
deu4tív
de3u4to
de3u4tó
de3utu
de3utú
deū4s
deū́4
deú2
de3únc
de3úr
deú4s
de3úsa
de3úsæ
de3úsi
d2ev
de2x
dē1
d2ēb
2d1ēg
dē2ia
dē2iā
dē2iá
dē2iæ
dē2iǣ
dē2iǽ
dē4ien
dē2iī
dē2iō
dē2ma
dē2mā
dē2mă
dē2má
dē4me.
dē4mene
dē6mente.
dē6mentem
dē6menten
dē6menteq
dē6menteu
dē6mentev
dē6mentē
dē6mentém
dē6mentib
dē6mentis.
dē6mentisn
dē6mentisq
dē6mentisu
dē6mentisv
dē6mentium
dē6mentiúm
dē6mentī
dē6mentísn
dē6mentísq
dē6mentísu
dē6mentísv
dē6mentu
dē6mentú
dē4meq
dē4mer
dē4met
dē4meu
dē4mev
dē2mē
dē4mĕ.
dē4mĕnĕ
dē6mĕntē
dē6mĕntĕ.
dē6mĕntĕm
dē6mĕntĕn
dē6mĕntĕq
dē6mĕntĕu
dē6mĕntĕv
dē6mĕntĕ́m
dē6mĕntī
dē6mĕntĭb
dē6mĕntĭs.
dē6mĕntĭsn
dē6mĕntĭsq
dē6mĕntĭsu
dē6mĕntĭsv
dē6mĕntĭŭm
dē6mĕntĭŭ́m
dē6mĕntĭ́sn
dē6mĕntĭ́sq
dē6mĕntĭ́su
dē6mĕntĭ́sv
dē6mĕntŭ
dē4mĕq
dē4mĕr
dē4mĕt
dē4mĕu
dē4mĕv
dē4mĕ́
d3ē2mé
dē4mim
dē4mis
d3ē4mit
d3ē2mī
dē4mĭm
dē4mĭs
d3ē4mĭt
d3ē4mĭ́
dē2mí
dē4mō.
dē4mōne
dē4mōnĕ
dē4mōq
dē4mōu
dē4mōv
dē6mṓne
dē6mṓnĕ
dē4mṓq
dē4mṓu
dē4mṓv
dēm4ū
d2ēn
dē3ne
dēpe2
dēper5
dēperi4
dēperī4
dēperī́6
dēpĕ2
dēpĕr5
dēpĕrī4
dēpĕrī́6
dēpĕrĭ4
dēpĕ́4
dēpĕ́r5
dēpĕ́rĭ6
dēpé2
dēpér3
dēpéri4
d2ēr
dē2sā
d2ēu
d2ēv
2d3ḗg
dḗ3ic
dḗ3ĭc
dḗ4ma
dḗ4mā
dḗ4mă
d3ḗ4me
dḗ4mē
d3ḗ4mĕ
dḗ4mim
dḗ4mis
dḗ4mit
d3ḗ4mī
dḗ4mĭm
dḗ4mĭs
dḗ4mĭt
dḗ4mō
dḗ4se
dḗ4sĕ
dḗ3sp
dḗ5str
d2ḗu
d2ḗv
dĕ5cĭm
dĕd2
dĕ2dā
dĕ4dă
dĕ2dē
dĕd4ĭ
dĕ2dō
dĕ2dŏ
dĕ2dŭ
3dĕĕ
dĕ3ĕ́
d2ĕf
3dĕ2ī
dĕ2ĭ
dĕ3ĭn
dĕ3ĭ́n
dĕ2ō
2d1ĕp
dĕ3r4ĕ
dĕ3rī
dĕ3rŏ
4d3ĕrŭn
dĕs5tĕ
d2ĕt
dĕū́2
2dĕŭ
3dĕŭm
3dĕŭs
d2ĕ́f
d3ĕ́mp
2d3ĕ́p
dĕ́2q
dĕ́3rĕ
3dée
dé3es
d2éf
2d1ég
dé3in
dé2ma
2d3é2me
d3é4mi.
d3é4mim
dé4mis
d3é4mit
dé4mo.
dé4mor.
2démp
2d1ép
d2ér
d3érr
dé4sa
dé4sn
dé3sp
dé4sq
2d3éss
4déstn
4déstq
4déstv
d2ésu
dé4sv
dé2x
2df
2dg2
2d1h
di2a
d2ia.
d2iab
d2iam
d2ian
d2iaq
d2iar
d2ias
d2iat
d2iau
d2iav
d2iā
2diă
d2iá
2d3i2ba
2d3i2bá
di2be
di2bé
4d3i4bim
4d3i4bis
4d3i4bit
di4bím
4d3i4bís
4d3i4bít
2d3i2bo
2d3i2bó
d2ibu
4d3i4bun
d2ibú
4d3i4bún
di3cem
di3cen
di3ces
d2icé
di3cém
di3cén
di3cés
di3cib
d2i3cu
di4c3ue
4d3i4cul
d2i3cú
4d3i4cúl
d2id
d2ieb
d2iem
d2ien
d2ies
d2iet
d2iēb
d2iēm
d2iēs
d2iēt
d2iéb
d2iém
d2ién
d2iés
d2iét
2d3i2ga
2d3i2gā
2d3i2gá
2digæ
2digǣ
2d3i2gǽ
4d3i4ge.
4d3i4gea
4d3i4geā
4d3i4geá
4d3i4geb
4d3i4gem
4d5i4gend
4d5i4gene
4d5i4gens
4d5i4gent
4d3i4geo
4d3i4geō
4d3i4geó
4d3i4geq
4d3iger
4d5i4ges.
4d5i4gesn
4d5i4gesq
4d5i4gesu
4d5i4gesv
4d3i4get
4d3i4geu
4d3i4gev
2d3i2gē
di2gé
4d3igéb
4d3igém
4d3igén
5digéna
4d3igéq
4d3igér
4d5igésn
4d5igésq
4d5igésu
4d5igésv
4d3igét
4d3igéu
4d3igév
di2gi
2d3i2gī
di2gí
dig5no.
di5gnore
di5gnori
di5gnorí
dig5norum
dig5norúm
di6g5nos.
di6g5nosn
di6g5nosq
di6g5nosu
di6g5nosv
di6g5noue.
di6g5nove.
di5g6nóre
2d3i2go
2d3i2gō
2d3i2gó
2d3i2gu
2d3i2gú
d2iīs
2dim.
2d3i2ma
2d3i2mā
2d3i2má
2di2me
2d3i2mē
di2mé
4diméb
4dimém
4dimér
4dimés
4dimét
4d3i4mi.
4d3i4mia
4d3i4miā
4d3i4miá
4d3imic
4dimie
4dimiē
4dimié
4dimii
4d3i4miī
4d3i4mií
4d3i4mim
di4mine
4d3i4mio
4d3i4miō
4d3i4mió
4d3i4miq
4dimir
4d3imis
4d3imit
4d3i4miu
4d3i4miú
4d3i4miv
2d3i2mī
2dimí
di4míe
di4mím
di4mín
di4míq
di4míu
di4mív
2dimn
2d3i2mo
2d3i2mō
2d3i2mó
2dimq
4d3i4mun
di3mú
4d3i4mún
2dimv
din2ā
din2d
d4ine
d4inē
d4iné
d4ini
d4inī
d4iní
di2nu
d4inú
d2io.
d2ioq
d2ior
d2iou
d2iov
d2iō
2diŏ
d2ió
d1ip
di2pi
di2pī
d2ips
d2iq
dir5emé
dir5e4mí
di2rē2
dirḗ4
dir5éme
diri4m
di5s6cende
di5s6cens
dispe6r5
disperi6
disperī6
disperī́6
disperí6
dispé4r5
di3spi
di3spí
di5s4ta.
di5s4tam
di5s4taq
di5s4tar
di5s4tas
di5s4tat
di3s4tā
di3stá
dis4tám
dis4tán
dis4táq
dis4tár
dis4tás
dis4tát
di5s4tem
di5s6tent.
di5s6tentn
di5s6tentq
di5s6tentue
di5s6tentv
di5s6tern
di5s4tes
di5s4tet
di3s4tē
di5s4tém
di5s6téntn
di5s6téntq
di5s6téntue
di5s6téntv
di5s6térn
di5s4tés
di5s4tét
di5stím
di5s4to.
di5s4ton
di5s4toq
di5s4tou
di5s4tov
di3s4tō
di5s4tón
di5s4tóq
di5s4tóu
di5s4tóv
di5s6trar
di5s6tras
di5s6trat
di5s6trau
di5s6trav
di5s6trār
di5s6trās
di5s6trāt
di5s6trāu
di5s6trāv
di5s6trā́r
di5s6trā́s
di5s6trā́t
di5s6trā́u
di5s6trā́v
di5s6trár
di5s6trás
di5s6trát
di5s6tráu
di5s6tráv
di5s4trī
d2ite
d2ité
di4tiā
4d3i4tib
d4itn
d4itq
4d3i4tui
4d3i4tuī
4d3i4tuí
di4tuum
4d3i4tuú
di4tūs
d4itv
4d3i4uia
4diuiā
4diuiá
4diuiæ
4diuiǣ
4diuiǽ
4d3i4uii
4d3i4uiī
4d3i4uií
4d3i4uio
4d3i4uiō
4d3i4uió
2di2uī
4d3i4uía
d4ius
2diŭ
d2iv
d3i4via
d3i4vii
d3i4viī
d3i4vií
d3i4vio
d3i4viō
d3i4vió
2di2vī
d3i4vía
di2xu
2d1ī2b
d2īne
d2īnĕ
dīo4n
dīó2
d2īq
d2īs.
dīs2c
d2īsn
2dīso
2dīsŏ
2dīsó
d2īsq
d2īsu
d2īsv
d2īu
d2īv
dī2xu
2d3ī́2b
d2ī́n
d2ī́q
d2ī́u
d2ī́v
d2ĭ3b
dĭ4cŭl
d2ĭē
d2ĭĕn
d2ĭĕt
d2ĭĕ́
dĭ2g
2dĭga
2d3ĭgā
2d3ĭgă
2dĭgá
2dĭgæ
2dĭgǣ
2dĭgǽ
2d3ĭgē
2dĭgĕ
d3ĭgĕ.
d3ĭgĕā
d3ĭgĕă
d3ĭgĕm
5dĭgĕna
5dĭgĕnā
5dĭgĕnă
5dĭgĕná
5dĭgĕnæ
5dĭgĕnǣ
5dĭgĕnǽ
d5ĭgĕnd
d5ĭgĕnĕ
5dĭgĕnī
d5ĭgĕnt
d3ĭgĕō
d3ĭgĕq
d3ĭgĕt
d3ĭgĕu
d3ĭgĕv
d3ĭgĕ́
5dĭgĕ́nă
2d3ĭgī
2d3ĭgō
2d3ĭgŭ
2d3ĭ2mā
2d3ĭ2mă
2d3ĭ2mē
2d3ĭ2mĕ
2d3ĭ2mī
d3ĭ4mĭā
d3ĭ4mĭă
d3ĭ4mĭī
d3ĭ4mĭm
d3ĭ4mĭō
d3ĭ4mĭŏ
d3ĭ4mĭs
d3ĭ4mĭt
d3ĭ4mĭŭ
d3ĭ4mĭ́
2d3ĭ2mō
2d3ĭ2mŏ
dĭ3mŭ
4d3ĭ4mŭn
dĭn2a
dĭn2ā
dĭn2æ
dĭn2d
d4ĭnē
d4ĭn2ĕ
d4ĭnī
d4ĭnĭ
d4ĭnŭ
d1ĭp
dĭ2pī
dĭ2rē2
dĭrḗ4
dĭr3ĕ
dĭ2sĭ
dĭspĕ4r5
dĭspĕrī6
dĭspĕrī́6
dĭs6pĕ́rn
dĭ3s4pĭ
dĭ3s4tā
dĭs4tăt
dĭ3s4tē
dĭ5s6tĕnt.
dĭ5s6tĕntn
dĭ5s6tĕntq
dĭ5s6tĕntu
dĭ5s6tĕntv
dĭ5s6tĕrn
dĭ5s4tĕt
dĭ5s6tĕ́ntn
dĭ5s6tĕ́ntq
dĭ5s6tĕ́ntu
dĭ5s6tĕ́ntv
dĭ5s6tĕ́rn
dĭ5s6tĕ́t
dĭ3s4tō
dĭ5s6trār
dĭ5s6trās
dĭ5s6trāt
dĭ5s6trāu
dĭ5s6trāv
dĭ5s6trā́r
dĭ5s6trā́s
dĭ5s6trā́t
dĭ5s6trā́u
dĭ5s6trā́v
dĭ5s4trī
d2ĭtĕ
dĭ4tĭā
d3ĭ4tĭb
4d3ĭ4tūs
4d3ĭ4tŭī
4d3ĭ4tŭŭ
2d1ĭ2u
2d1ĭ2v
4d3ĭ́4cŭ
dĭ́2g
4d3ĭ́4gă
4d5ĭ́gĕā
4d5ĭ́gĕă
6d5ĭ́gĕnĕ
4d5ĭ́gĕō
4d5ĭ́gĕq
4d5ĭ́gĕt
4d5ĭ́gĕu
4d5ĭ́gĕv
4d3ĭ́gŭ
4d3ĭ́4mĕ
4d5ĭ́4mĭā
4d5ĭ́4mĭă
4d5ĭ́mĭē
4d5ĭ́mĭĕ
4d5ĭ́4mĭī
4dĭ́mĭĭ
4d5ĭ́4mĭm
4d5ĭ́4mĭō
4d5ĭ́4mĭŏ
4d5ĭ́4mĭt
4d5ĭ́mĭŭ
4dĭ́nt
4d3ĭ́nu
4d3ĭ́nv
d2ĭ́p
dĭ́2r3
dĭ́5spĭ
dĭ́5s4tā
dĭ́5s4tă
dĭ́5s4tē
dĭ́5s4tĕ
dĭ́5s4tō
dĭ́4tĭb
4d3ĭ́4tŭ
2d3ĭ́2u
2d3ĭ́2v
d1íb
2dí2ba
dí2be
4dí4bim
4dí4bis
4dí4bit
2dí2bo
2dí2bu
dí4ciā
dí4cie
dí4ciē
d2ícu
dí4c3ue
4d3í4cul
2d3í2ga
4d3í4gea
4d3í4geā
4d5í4gene
4d3í4geo
4d3í4geō
4d3í4geq
4d3í4get
4d3í4geu
4d3í4gev
dí4gia
dí4gib
dí4giu
dí4g3n
2d3í2gu
2d3í2me
4d3í4mia
4d3í4miā
4d3í4mie
4d3í4miē
4d3í4mii
4d3í4miī
4d3í4mim
4d3í4mio
4d3í4miō
4d3í4mit
4d3í4miu
2dímn
2dímq
2dímv
d2ín
d3íns
2dínt
d3ínte
dí4nue
2d3ínv
d2íq
dí4r3i4m
dí3spi
dí3s4ta
dí3s4tā
dí3s4te
dí3s4tē
dí3s4to
dí3s4tō
4d3í4tib
4d3í4tui
4d3ítuī
dí3tur
4d3ítuu
d2íu
4d3í4uia
4díuiā
4díuiæ
4díuiǣ
4d3í4uii
4d3í4uiī
d2ív
4d3í4via
4díviā
4díviæ
4díviǣ
4d3í4vii
4d3í4viī
dí2xu
2dj
2dl2
d3lu
2d1m
2d1n2
d3ne
d3nĕ
dnéx2
dob3r
dob2ū
d2oc
doco2
doc5te
do1e2
4d3olem
4d5oles.
4d5olesn
4d5olesq
4d5olesu
4d5olesv
4d5olēs.
4d5olēsn
4d5olēsq
4d5olēsu
4d5olēsv
6d5olḗsn
6d5olḗsq
6d5olḗsu
6d5olḗsv
4d3olém
4d5olésn
4d5olésq
4d5olésu
4d5olésv
do4lib
dol4u
domi3
d2on
3don.
do3ne
do3ni
d1op
do2pé
2d3ord
d4ori.
d4orin
d4oriq
do4rit
d6oriue.
d6orive.
d4orī.
d4orīn
d4orīq
d6orīue.
d6orīve.
d4orī́n
d4orī́q
d6orī́ue.
d6orī́ve.
d4orín
d4oríq
d6oríue.
d6oríve.
2d3o4rn
do4rq
do4rv
d2os
dos2p
do3u
do3v
3dōc
d2ōn
3dōn.
d2ōs
4dṓrd
4dṓrn
dŏb2ū
d2ŏc
dŏc5tĕ
4d5ŏlēs.
4d5ŏlēsn
4d5ŏlēsq
4d5ŏlēsu
4d5ŏlēsv
6d5ŏlḗsn
6d5ŏlḗsq
6d5ŏlḗsu
6d5ŏlḗsv
4d3ŏ4lĕm
4d5ŏ4lĕ́m
dŏ4lĭb
dŏ4lĭs
dŏ4lĭŭ
dŏ3mĭ3
d2ŏn
d1ŏp
dŏ2r
dŏ3ră
d2ŏ3rĕ
d4ŏrī.
d4ŏrīn
d4ŏrīq
d3ŏrīs
d6ŏrīuĕ.
d6ŏrīvĕ.
d4ŏrī́n
d4ŏrī́q
d6ŏrī́uĕ.
d6ŏrī́vĕ.
d3ŏrĭt
dŏs2p
4d3ŏ́lĭ
dŏ́4lĭb
dŏ́4lĭŭ
d4ŏ́rĕ
dŏ́4rĭŭ
dób3
d2óc
dól2
2d3óli
dó2pe
dó1r
2d3órd
dó4riā
dó4rie
dó4riē
dó4rio
dó4riō
dó4riu
d2órn
4dórna
4dórnem
4dórnen
4dórner
4dórnes
4dórnet
4dórno
d2ós
dós2p
dó2xu
2dp
2dq
d3qu
dqui4
dquid3
dquí2
dquíd3
dr2
d2ra
d2rā
d2ră
d2rá
d2ræ
d2rǣ
d2rǽ
d3rex2
dre5xi
dri3e
dri3é
dri5re5
d2rĭă
drĭ3ĕ
d2rĭī
d2rĭō
d2rĭŭ
d2rō
d3rŏg
d2ró
d2ru
d2rŭ
dr4ŭn
dr4ŭ́
d2rú
2d1s2
d2ua
d2uá
dub2
4d3u4cul
4d3u4cúl
2d3ueb
2d3uem
2d3uen
2d3ues
2d3uet
d1uē
2d3uĕ
d1ué
2d3uím
d4ulæ
d4ulǽ
d4uli
d4ulí
d4ulu
d4ulú
du2m
2d3ume
2d3umé
du2n
d3unc
d3und
du3ni
du3ní
d2uo
dupe3
duper4
du3r2u
d4us.
d4usn
du3s4tr
d4usu
d4usv
d1ut
2du2ta
2du2tá
2du2tæ
2du2tǽ
2du2te
du2té
4du4ti.
4du4tib
4dutil
4du4tin
4du4tiq
4du4tis
4du4tiu
4du4tiv
2du2tí
2du2to
2du2tó
2du2tu
2du2tú
2d1u2u
2d1u2v
d2ux
du2xu
4d3ū4cul
4d3ū4cŭl
4d5ū4cŭ́l
4d3ū4cúl
2d1ū2m
dū2n
dūn4e
dūn4ĕ
dū3nī
2d1ū2t
3dūtia
3dūtiā
3dūtiá
3dūtiæ
3dūtiǣ
3dūtiǽ
3dūtiī
3dūtĭa
3dūtĭā
3dūtĭá
3dūtĭæ
3dūtĭǣ
3dūtĭǽ
3dūtĭī
4d5ū́4cul
4d5ū́4cŭl
2d3ū́2t
5dū́tia
5dū́tiā
5dū́tiæ
5dū́tiǣ
5dū́tiī
5dū́tĭa
5dū́tĭā
5dū́tĭæ
5dū́tĭǣ
dū́4tĭb
5dū́tĭī
d2ŭă
dŭb2
d1ŭē
2d3ŭĕn
2d3ŭĕt
2d3ŭĕ́
3dŭī
3dŭĭ
4dŭĭs.
d4ŭnt
dŭpĕ3r
dŭ3str
2d1ŭ2u
2d1ŭ2v
d2ŭx
dŭ́3b
d2ŭ́m
d3ŭ́nc
d3ŭ́nd
dŭ́5str
2dŭ́u
2dŭ́v
dúb2
4d3ú4cul
dú2lo
d2úm
d3úmb
dú2na
2d3únc
2d3únd
dú3s4tr
2d1ú2t
3dútia
3dútiæ
3dútii
2d1ú2u
2d1ú2v
dú2xu
2dv
d3ve
d3vĕ
2d2x2
d2y
d2ý
2ea.
eab2
e2ace
ea2cu
ea2cú
ead2
2e2ae
e2ami
e2an
2eane
2e2a3q
e2ar
2earú
e2as
ea3tr
2eau
2eav
2ea͞
e2a͞e
e2á͞
e3á͞u
2ea͡
e2a͡e
e2á͡
e3á͡u
e2ā
2eā.
2eān
2eāq
2eāru
2eārú
2eāu
2eāv
2eā́n
2eā́q
2eā́u
2eā́v
e1ă
e2ăcĕ
eă2cŭ
e2ăn
e2ăq
e2ău
e2ăv
e2ắm
e3ắmb
e2á
eá2cu
2eáe
e3ál
e3ámb
2eáne
eá2nu
2eáq
2eáu
e3áud
2eáv
2e2æ
eæ2a
eæ2á
eæ2i
2e2ǣ
eǣ2a
2e2ǽ
eb2
eba3q
ebæ3
ebe3d
ebe3ia
ebe3iá
ebe3iæ
ebe3iǽ
ebe3ie
ebe3ié
ebe3io
ebe3ió
ebe3iú
ebé3io
e3bi
ebī3u
ebī3v
eb4ri
ebs3
e2bul
e3bŭ
2ec
e4c3enn
ecen3s
ecēn3s
e4c3énn
e5cént
ec3le
ec3lē
ec3o2p
ec3ue.
ecu3ma
ecu3mā
ecu3má
ecu3me
ecu3m4i
ecumi5q
ecu3m4ī
ecumī́5n
ecumī́5q
ecumī́5u
ecumī́5v
ecu3m4í
ecumí5q
ecumí5u
ecumí5v
2ed.
ed1a
e3da.
ed2ae
ed5ama
e3dane
e3d2a3q
e5dari.
e5darin
e5dariq
e5dariv
e5darín
e5daríq
e5daríu
e5darív
e5darum
e3darú
e3daue
e3dav
e3d4a͡e
ed4á͡e
ed3ā́c
e2d3ác
e4d3áni
ede2g
e2dem
ed3eme
ed3emé
e3deō
e3deó
ede2s3
ede6ste
e3deú
edē2g
ed3ēmē
edē2s
edḗ4g
edĕ3r
edé2g
e2diǣ
e2d3i2g
ed3ime
ed3imé
edi4mis
edi4mit
ed3i4mí
e2d3in
e2di2p
edi4s3
edis5c
edi6sce
edis7cen
ed4it.
ed5i4ta͞
e4d3i4tǣ
edi4tiō
e4d3i4tī
ed5i4tōr
ed5i4tōs
e4d3i4tū
edi5ue.
edi5ve.
edī5ue.
edī5ve.
e2d3í2g
e4d3ínu
ed5í4tiō
e2d3o2l
e2do2p
e2dōr
e2d3ó2l
e2d3óp
ed2r
ed3ue.
e2d3ul
e2dun
edu3no
edu3nó
ed2ū
edū3n
e3d2ŭ
ed4ŭĕ
ed3úlc
2e1e2
e2el
e2em
ee3mi
ee3mu
ee3mú
e2en
e2e3q
ee4ra
ee3re
ee4ro
ee4rō
ee3ti
ee3tí
e2ev
eex3
2e2ē
eēn3
e1ĕ2
e2ĕō
e2ĕ3q
eĕ4rō
e2ĕŭ
eĕ́2
2eé
e2éq
eé2ru
2efe
2efé
2efi
2efí
2e3g2a
e3g2æ3
e3ge.
e3gen
e3geq
e3geu
e3gev
2egm
eg3no
e2go
e3go.
e3gon
e3goq
e3gor
e3gou
e3gov
e2gō
e3gō.
e3gōn
e3gōq
e3gōu
e3gōv
e3gṓn
e3gṓq
e3gṓu
e3gṓv
e2gót
egu6ste
e1h
2e1i
ei2a
e2ia͡
e3iát
e2iæ
e2iǣ
e2iǽ
ei2b
e3i2ce
ei2cé
ei2ci
ei2cí
ei2cu
ei2cú
e2id
ei2i
ei2m
ei2n
e2i3na
e2i3ni
e2i3nī
e2i3ní
e2i3nú
ei2o
eio2s
e2i3q
ei2r
e2is
e3ist
ei2t
ei3ta
ei3tā
ei3tá
eite3
e4i3ue
e2iué
e2iui
e2iuí
e3iur
e2i3v
2eī
e1ī2b
e1ī2m
e2īq
e1ī2r
e2īs
e3īss
e3īst
e1ī2t
e2īu
e2īv
e2ī́
e3ī́2b
e3ī́2m
e3ī́2r
e3ī́2t
e1ĭ2
eĭ́2
2eí
e1í2b
e1í2c
e2íe
e3íer
e1íi
e1í2m
e3ínc
e3índ
e2íq
e1í2r
e3íst
eí2te
eí2to
e2íu
e2ív
e3la.
e3lae
e3lam
e3lan
e3laq
e3lar
e3las
e3lau
e3lav
e3la͡
e3láe
e3lám
e3lán
e3láq
e3lár
e3lás
e3láu
e3láv
2e3læ
2e3lǽ
4e3le.
e2leg
ele2i
4e3len
4e3leq
4e3les
elē2
3e2léc
e3lis
eli6sta
e3lís
2ell
e2l3ue
el3uē
el3ué
el4ui
e2l3u2t
e1m
2em.
em2am
e4mani
e4maní
e2m3a2x
e4m3áni
e2m3áx
e5mem.
e5memn
e5memq
e5memv
em2eq
eme4s
e4m3esa
e4m3esá
e4mesæ
e4mesǽ
e4m3ese
e4m3esé
e4m3esi
e4m3esí
4emete
4emeté
2e3mēt
e5mémn
e5mémq
e5mémv
emé4s
e4mésa
e4m3ése
e4m3ési
em2i
emi3ac
emi3án
emi3es
4emini
4eminí
e5mité
emi3u
2emne
1emp
em3pn
2emq
1emt
2emu
em2uē
em2ué
e2muī
e5mul.
em3ulc
2emú
e2m3úl
2emv
en2a
en4an
ena3ni
ena3ní
5e4narib
en2ā
ená3ni
5e4nárib
2en3d2
end4u
end4ú
2ene
en3eat
en3eát
en2e2x
e3nĕ1
eni3tu
ení5tuī
en2o
eno3b2
en2ŏ
en2sc
en3s2i
ensi5ti
en4sn
en4sq
ens3t
ens4ué
en4sv
2ent
ente5re
e1n2u
e1oc
eo2g3n
e2on
eo3ni
eo3p2
eo5rā́
eo3rá
e3ors
2eorú
2e2os
e2ōn
2eōr
2e2ōs
2eṓr
2eṓs
e2ŏ
e2ó
eó2g
eó2nu
eó3p2
e3órs
2eós
eper4ē
eperi4b
eperi4r
eper4ī
eperí4r
epĕ3r
epĕ5rĭ
e3pé
epére5r
3e4pisc
epi5s4tr
3e4písc
epo4ter
epote6ri
epote6rí
epo4tes
epŏ4tĕs
2eps
ep4se.
ep4sen
ep4seq
ep4seu
ep4sev
ep2su
4e3que
2er.
2e3ra.
e3raba
e3rabá
e3rabe
e3rabé
e5rabil
e5rabim
e5rabis
e5rabit
e3rabí
e3rabo
e3rabó
e5rabunt
e5rabúnt
era2c
er3act
era2d3
eradi4
eradí4
e3rae.
e3raea
e3raeā
e3raeá
e3raei
e3raeī
e3raeí
e3raen
er3aes
e3raeu
e3raev
era2g
er5ama
e3rame
e3ramé
e5ramin
e5ramur
e5ramúr
e3rand
4e5rane
e3rané
e3rans
e5rante
e5rantē
e5ranté
e5ranto
e5rantō
e5rantó
e5rantú
era2p
2e3raq
e3rar.
e5rare.
e5rareq
e5rareu
e5rarev
e5rari.
e5raria
e5rariá
e5rariæ
e5rariǽ
e5rarie
e5rarié
e5rarii
e5rarií
e5rarim
e5rarin
e5rario
e5rarió
e5rariq
e5raris
e5rarit
e5rariu
e5rariú
e5rariv
e3rarí
e3rarn
e3rarq
e5r6arum
e5rarun
e5r6arúm
e5rarún
e3rarv
e3rass
e5rasti.
e5rastin
e5rastiq
e5rastis
e5rastiu
e5rastiv
e5rastín
e5rastíq
e5rastís
e5rastíu
e5rastív
eras4to
eras4tō
eras4tó
e3rata
e3ratá
e3ratæ
e3ratǽ
e3rate
e3rato
e3rató
e3ratr
e3ratu
e3ratú
2erau
e3raue
e3raué
e3raui
e3rauí
2e3rav
e5ra͞e.
e5ra͞ea
e5ra͞eā
e5ra͞eá
e5ra͞eī
e5ra͞en
e5ra͞eu
e5ra͞ev
e5rá͞ea
e5rá͞eā
e5rá͞eī
e5ra͡e.
e5ra͡ea
e5ra͡eā
e5ra͡eá
e5ra͡ei
e5ra͡eī
e5ra͡eí
e5ra͡en
e5ra͡eu
e5ra͡ev
e5rá͡ea
e5rá͡eā
e5rá͡ei
e5rá͡eī
e5rá͡en
e5rá͡eu
e5rá͡ev
e3r2ă
er3áct
e2r3ád
er3áes
e2r3á2g
er3áll
e4r3ámb
er3á4pe
er5ás4te
er5ás4to
er5ás4tō
er3áud
er1æ2
e3ræ.
e3ræa
e3ræā
e3ræá
e3rææ
e3ræǽ
e3ræi
e3ræī
e3ræí
e3ræn
e3ræu
e3ræv
er1ǣ2
e3rǣ.
e3rǣa
e3rǣā
e3rǣá
e3rǣǣ
e3rǣī
e3rǣn
e3rǣu
e3rǣv
e3rǣ́a
e3rǣ́ā
e3rǣ́ǣ
e3rǣ́ī
e3rǣ́n
er3ǣ́s
e3rǣ́u
e3rǣ́v
er3ǽs
e1re
2e3re.
2erea
2ereá
2e3reæ
2e3reǽ
ere4d4
ered6it
2e3ree
2e3reé
ere2g
2e3re2i
2e3reí
ere2l
e3rem.
e4r3e4ma
er3e4mā
e4r3e4má
er3e4me
er3e4mē
er3e4mé
er5e4mim
e5remini
e5reminí
er5e4mis
e4r5e4mit
er3e4mī
ere4mím
ere4mín
ere4mít
ere4mo.
ere4moq
ere4mou
ere4mov
ere4mō.
ere4mōq
ere4mōu
ere4mōv
ere4móq
ere4mór
ere4móu
ere4móv
e3remq
e3remu
e4r5e4mun
e3remú
er5e4mún
e3remv
2eren
ere4na
e3rend
e3rene
e3rent
2ere2o
2ereó
2ereq
e5reque
e3rer.
er3era
er3erā
er3erá
e3rere
e3rerí
e3rern
er3ero
er3erō
er3eró
e3rerq
e5rerue
er3erú
e3rerv
e3res.
e3resn
e3resq
er3ess
eres3t
ere4su
ere4sú
e3resv
e3ret
2ereu
e3reue
2ereú
2erev
e3reve
2erē
e2rē2d
erē2g
erē2i
e5rēminī
e5rēmu
e5rēmú
e5rēne
e5rēre
e5rēri
e5rērí
e5rēue
e5rēve
erḗ4d
e4rḗ4g
e5rḗminī
e5rḗmu
er5ḗna
e5rḗne
e5rḗq
e5rḗre
e5rḗri
e5rḗt
e5rḗue
e5rḗve
e1rĕ
erĕ2s3
2eré
3eréc
eré2d
e2ré2g
eré4mer
er5é4mim
eré6miti
eré6mito
eré6mitō
eré6mitu
e4r3éna
er3éss
e2réx
2e3ri.
e3ria.
e3riae
e3riam
e3rian
e3riaq
e3riar
e3rias
e3riat
e3riau
e3riav
e3ria͞
e3ria͡
e3riā
er3iác
e3riáe
e3riám
e3rián
e3riáq
e3riár
e3riás
e3riát
e3riáu
e3riáv
e3riæ
e3riǣ
e3riǽ
2erib
er3i4ba
er3i4bá
er3i4be
er3i4bé
er3i4bi
er3i4bí
eri4bo.
eri4bon
eri4boq
eri4bor
eri4bou
eri4bov
er3i4bó
eri6bunt
eri6búnt
eri4cer
er5i4cér
er3i4ci
e3ricu
e3ricú
e3ride
e3ridē
e3ridé
e3ridi
e3ridī
e3ridí
eri4dō
eri4dó
e3ridu
e3ridú
2erie
e3rie.
e3rieb
e3riem
e3rien
e3rieq
er3ier
e3ries
e3riet
e3rieu
e3riev
e3riē.
e3riēb
e3riēm
er6iēne
e3riēq
er3iēr
e5riēri
e5riērí
e3riēs
e3riēt
e3riēu
e3riēv
e5riḗb
e5riḗm
e5riḗri
e5riḗs
e5riḗt
2erié
e3riéb
e3riém
e5riénd
e5riént
e3riéq
er3iér
e5riéris
e3riés
e3riét
e3riéu
e3riév
er3iim
er3iis
e5riis.
e5riisn
e5riisq
e5riisu
e5riisv
er3iit
e3riīs
e5riī́s
e5riísn
e5riísq
er5iíss
er5iíst
e5riísu
e5riísv
er3iít
er3i4ma
er3i4mā
er3i4má
eri4me.
eri4meb
eri4mem
eri4men
eri4meq
eri4mer
eri4mes
eri6met.
eri6meti
eri6metí
eri6metn
eri6metq
eri6metu
eri6metú
eri6metv
eri4meu
eri4mev
eri4mēb
eri4mēm
eri4mēn
eri4mēr
eri4mēs
eri4mēt
eri6mḗb
eri6mḗm
eri6mḗn
eri6mḗr
eri6mḗs
eri6mḗt
eri4mé
er5i4mi.
er5i4mim
e6r5i6mine
e5riminī
er5i4miq
er5i4mis
er5i4mit
er5i4miu
er5i4miv
er3i4mī
er3i4mí
eri4mo.
eri4moq
eri4mor
eri4mou
eri4mov
eri4mō.
eri4mōq
eri4mōu
eri4mōv
eri4móq
eri4mór
eri4móu
eri4móv
e5rimue
er5i4mun
er5i4mún
2erin
e3rio
e3riō
e3rió
e3rip
2e3riq
er3ire
er3iré
er3iri
er3irí
eri6sne
eri6squ
eri6sue
eri6sve
e3rité
er5itib
eri6tne
e5ritōt
e5ritṓt
eri6tqu
eri6tue
er5itui
er5ituī
er5ituí
er5ituú
eri6tve
2eriu
er6iue.
er3iué
er3iui
er3iuí
e5rium.
e5riumn
e5riumq
e5riumu
e5riumv
er3iun
e5riunt
e3rius
e3riúm
er3iún
e5riúnt
e3riús
2eriv
er3ivé
er3ivi
er3iví
e3riz
2e1rī
erī3ā
er3ī2b
e2rīn
er3īr
er3īss
er3īst
er3ī́4b
er3ī́r
er3í2b
er3í4ci
er3íer
e2r3íi
e4rí4men
e4rí4meq
erí4mer
e4rí4meu
e4rí4mev
er5í4mim
e5ríminī
er5í4mit
2erín
e4ríng
2eríq
er3ír
e4r5í4tib
erí6tio.
e4r5í4tui
e4r5ítuī
e4r5ítuu
2eríu
er3íui
2erív
er3ívi
2ern
ero2b
erod4
erodi5ue
erodi5v
e3ron
ero4pu
e3ror.
ero4re
ero4ré
e3rorq
e3roru
e3rorú
e3rorv
er3o4sc
ero4s3t
3erot
e3rōq
erō4re
erō4rē
erō4ré
erō4rō
e3rōru
e3rōrú
er3ōsc
3erōt
erṓ4re
erṓ4rē
e5rṓru
er5ṓsc
3erṓt
e1rŏ
e2rób
e4ró4re
er3ó4sc
3erót
2erq
er5rue
e2r3ua
e2r3uā
e2r3uá
2erue
er5ue.
e4r3uen
e4r3ueq
e4r3ueu
er3uēm
er3uēn
er3uēs
er3uēt
er3uém
er3uén
er3ués
er3uét
e3rug
er3uīs
er3uía
2eru2m3
er3unc
er3und
e5runto
e5runtō
e5runtó
e5runtú
e2r3uo
e2r3uō
e2r3uó
er3ur
er3uss
er3ust
eru4su
er5usur
er3u4sú
e2r3u2t
e2r3uu
e2r3uú
e3rūg
erū2r
erū́4r
e1rŭ
2erúm
er3únc
e4rúnd
erú2r
e2r3út
2erv
e1ry
e1rý
2es.
1e2sæ
1e2sǽ
e3s2că
es3cæ
es4cid
e3s2cī
e3s2cĭ
es4cíd
es2cr
e2scŭ
es2e
ese2i
3eséq
3esév
e3s2i
2esn
e1s2p
espe5r4i
espe5r4ī
esper4í
e2sph
2esq
4essat
4essát
3est.
es4tān
e3s2tă
e2s3tæ
e2s3tǣ
e2s3tǽ
es3te.
es3teq
es4ter
es3teu
es3tev
e3s2tĕ
e4s5tim
e4stĭb
e3s4tĭn
e3stĭt
es4tĭ́t
3es4tn
es4tol
3estot
es4tól
3estót
3es4tq
e4strā
es4tră
es3tre
es3trē
es3tré
es4tru
es4trū
e3s4trŭ
e4stry
e2stu
e2stŭ
3es4tv
es3ue.
e2suĕ
es2ué
e2s3ui
2esv
2et
e3ta
eta3g
et3eni
ete5ram
ete5ran
ete5rar
ete6reri
ete6reru
ete4r5ie
eter5iē
eter5ié
eter5iī
eteri6mini
eteri6miní
eter5i6ta
eter5i6tā
eter5i6tá
eteri6te.
eteri6ten
eteri6teq
eteri6teu
eteri6tev
eteri6to.
eteri6ton
eteri6toq
eteri6tot
eteri6tou
eteri6tov
eteri6tō.
eteri6tōn
eteri6tōq
eteri6tōu
eteri6tōv
eteri6tṓn
eteri6tṓq
eteri6tṓu
eteri6tṓv
eteri6tón
eteri6tóq
eteri6tót
eteri6tóu
eteri6tóv
ete4rīs
eterī́6u
eterī́6v
ete4ríe
ete6rí6mini
ete6rí6te
ete3ro
ete3rō
ete5run
etĕ4r3ī4
etĕrī́4
etĕ4rĭē
etĕ4r5ĭī
etĕ4rĭt
etĕr5ĭ6tā
etĕrĭ6tĕ
etĕ5rĭtĭ
etĕrĭ6tō.
etĕrĭ6tōn
etĕrĭ6tōq
etĕrĭ6tōu
etĕrĭ6tōv
etĕrĭ6tṓn
etĕrĭ6tṓq
etĕrĭ6tṓu
etĕrĭ6tṓv
etĕrĭ́4
etĕ6rĭ́ĕ
etĕ6rĭ́t
etĕ3rŭ
etĕ́6rĕ6rĭ
etĕ́4rī
etĕ́6r5ĭī
etĕ́6r5ĭt.
etĕ́6r5ĭ6tā
etĕ́6rĭ6tĕ
etĕ́6rĭ6tō
eté6re6ri
eté4rie
eté4riē
eté4r5iī
eté6r5it.
eté6r5ita
eté6r5i6tā
etéri6te.
eté6ri6to.
eté6ri6tō
e2t3ip
e2t3íp
eto2i
etó2i
e3tr
etra3s
3ets
e4tue.
e2tuī
e3tur
e3tú
3etvi
e1u
2eu.
eua6ste
e4uasv
e4uāsv
e2uǣ́
e2uǽ
e2u3b2
eu2dă
eu4dis
eu2dī
2e3ue
e3uĕ
e4uīsv
2eum
eu3ma
1eun
e2und
2e2une
e2uni
e2uní
e2uno
e2unó
euol5ue
euol5ué
euol5ui
euol5uí
2euq
eu4rat
eu4rár
eu4rát
eu4reb
eu4rem
eu4ren
eu4rer
eu4réb
eu4rém
eu4rén
eu4rér
eu4rim
eu4rím
eu4rún
2eus
e4us.
e4usn
e4usq
eu2su
e4usv
2e2ut
eu4tami
eu4tamú
eu4tare
eu4tari
eu4tarí
eu4támi
eu4tánt
eu4táre
eu4tári
e3u4tem
e3u4ten
e5u4tere
e5u4teré
eu6teris
eu6terís
e3u4tém
e3u4tén
e5u4tére
e5u6téris
e3u4tét
eu4tim
eu4tit
e3u4tím
eutru4
eu4tun
eu4tún
2euu
2e2uv
e2ux
e1ū2
e2ū3m
e2ū́m
eū́2r
eū́2t
e1ŭ
e2ŭs
e3ŭt
e2ŭ́
e3ŭ́mb
e2ú
e3úl
2eúm
e3úmb
1eún
e3úng
e3únx
eú2r
2eús
e3úse
e3úso
e3úss
e3úst
e3úsu.
e3úsum
e3úsus
e3ú2t
eútru4
eva6ste
2e3ve
e3vĕ
ex2ă
e2x3ea
e2x3eā
e2x3eá
e2x3eo
e2x3eō
e2x3eó
ex3e2q
e2xeu
e2x3eú
e2xib
e2xiē
e2xié
exin3
e2x3íe
exō2
e3xṓ
exṓ4ra
exṓ4rā
exṓ4re
exṓ4rē
exṓ4rō
exó4ra
exó4re
exó4ri
exó4ro
ex5ter
2e2͞
2e2͡
2ē2a
ēad2
ēa2m
2ē2ā
ēā2nu
2ē2ă
ēă3d2
ēắ3d
2ē2á
2ē2æ
2ē2ǣ
2ē2ǽ
ēb2
ēba2
ēba3q
ēbá2
ēbæ3
ēbe3i
ēbī3u
ēbī3v
ēbo2
1ēbr
ēbs3
ēbu2
ē2bul
3ē2bŭl
ē4bŭ́l
ē2búl
ēce1
ē2ch
ēd2
ēda2r
ēdá2
ēdē2s
ēdi3m
ēd4it.
ēd4itu
ēd4ĭt.
ēd4ĭtn
ēd4ĭtq
ēd4ĭtu
ēd4ĭtv
ē3do
ēd4or
ēd3ue
ē3dŭ
2ē2e
2ē2ē
2ē2ĕ
ē3g2a
ēga2r
ē3g2æ3
ē3g2ǣ
ē3ge.
ē3gen
ē3geq
ē3geu
ē3gev
ē3gĕ.
ē3gĕn
ē3gĕq
ē3gĕu
ē3gĕv
ē2g3n
ēgo2
1ēgr
ēgu6ste
ēgŭ6stĕ
2ē1i2
ē2ia.
ē2iaq
ēia2r
ē2iau
ē2iav
ē3ic
ē2id
ē4iḗne
ē6iḗque
ē4iḗue
ē4iḗve
ē2i3p
ē2ir
ē2is
ē2ium
ē3iŭ
2ē2ī
2ēĭ2
ē1ĭc
ē2ĭē
ē2ĭĕ
ē2ĭ3p
ē3ĭ́2c
ē2ĭ́ĕ
ē2ĭ́p
ē1í2c
ē2íe
2ēj
ēja2r
ē2lab
ē3lā.
ē3lān
ē3lāq
ē3lār
ē3lās
ē3lāu
ē3lāv
ē3lā́n
ē3lā́q
ē3lā́r
ē3lā́s
ē3lā́u
ē3lā́v
ē3lă.
ē3lăm
ē3lăn
ē3lăq
ē3lău
ē3lăv
ē3lắ
2ē3lá
2ē3læ
2ē3lǣ
2ē3lǽ
ē2leg
ēle2r
ēlē2i
ē3lĕī
ē3lĕō
ē3lĕŭ
ēlé2
ēli2n
2ē3lī
ēlí2n
2ēll
ēl2u
ē2l3ue
ē1m
ē4mani
ē4maní
ēma2r
ēmắ2
ē4m3áni
1ēm2e
ē3me.
ē3mem
ē4mend
ē4ment.
ē6mentia
ē6mentía
ē4mentn
ē4mentq
ē4mentv
ē3meq
ē2m3es
ē3meu
ē3mev
3ē2mēr
ēmē2s
ē4m3ēse
ē4m3ēsē
ē4m3ēsĕ
ē4m3ēsī
3ē4mḗr
ēmḗ4s
ē4m5ḗse
ē4mḗsē
ē4m5ḗsĕ
ē4m5ḗsī
1ēmĕ
ē3mĕ.
ē3mĕm
ē4mĕnd
ē4mĕnt.
ē6mĕntĭă
ē6mĕntĭ́ă
ē4mĕntn
ē4mĕntq
ē4mĕntu
ē4mĕntv
ē3mĕq
ē2m3ĕs
ē3mĕu
ē3mĕv
ē3mĕ́m
ē4m3ĕ́s
ē2m3és
ēm2i1
3ēmim
4ēminī
3ēmis
ē4miss
3ē4mit.
3ē4mitn
3ē4mitq
3ē4mitu
3ē4mitv
ēm2ĭ
3ēmĭc
ēmĭ3ĕ
3ēmĭm
3ēmĭnĕ
3ēmĭs
ē4mĭss
3ē4mĭt.
3ē4mĭtn
3ē4mĭtq
3ē4mĭtu
3ē4mĭtv
3ēmĭ́n
5ē4mĭ́ss
5ē4mĭ́st
3ēmĭ́t
1ēmí
ē4míss
ē4míst
1ēmo
ē3mo.
ē3mon
ēmo4nu
ē3moq
ē4mor.
ē4morn
ē4morq
ē4moru
ē4morv
ē3mou
ē3mov
1ēmŏ
ē4mŏr.
ē4mŏrn
ē4mŏrq
ē4mŏru
ē4mŏrv
ē4mŏ́rn
ē4mŏ́rq
ē4mŏ́ru
ē4mŏ́rv
ē4mórn
ē4mórq
ē4móru
ē4mórv
1ēmp
1ēmt
2ēmu
ē2m3ul
ē2mun
ēm3ū́
2ēmŭ
ē2m3ŭl
ē2mŭn
ē4m3ŭ́l
ē4mŭ́n
2ēmú
ē2m3úl
ē2mún
ē2nat
ēn2ā
ēnā3nē
ēnā3nī
5ē4nārib
5ē4nārĭb
5ē6nā́rib
5ē6nā́rĭb
ē3nă.
ē3năm
ē3năn
ē3năq
3ēnăt
ē3nău
ē3năv
ē3nắ
2ēne
ē2n3ea
ē2n3eā
ē2n3eá
ē2n3eō
ē2neu
ē2neú
ē2n3ĕā
ē2n3ĕă
ē2n3ĕō
ē2nĕŭ
ē2n3ie
ē2n3iē
ē2n3ié
ē2n3ii
ē2n3ií
ē2n3ī2m
ē2n3ī2r
ēn3īss
ēn3īst
ē2n3ī2t
ēn3ī́4m
ēn3ī́4r
ēn5ī́ss
ēn5ī́st
ēn3ī́4t
ē2n3ĭē
ē2n3ĭĕ
ē2n3ĭĭ
ē4n3ĭ́ĕ
ē4n3ĭ́ĭ
ē2n3íe
ē2n3íi
ēn2sc
ēn3si
ēn4sn
ēn4sq
ēns4ué
ēn4sv
ē1n2u
ē2n3ue
ē3n4uen
ēn4ueq
ēn4ueu
ēn4uev
ēn2ŭ
ē1o
ē2on
ē2os
2ē2ō
ē1ŏ
ē2ŏn
ē2ŏs
ē2ŏ́
ēó2
ēpa2
ēpar3
ēpá2
ēper4ē
ēperī4n
ēperī4q
ēperī4r
ēperī4u
ēperī4v
ēperī́6n
ēperī́6q
ēperī́6r
ēperī́6u
ēperī́6v
ēperí4
ēpĕrī4n
ēpĕrī4q
ēpĕrī4r
ēpĕrī4u
ēpĕrī4v
ēpĕrī́6n
ēpĕrī́6q
ēpĕrī́6r
ēpĕrī́6u
ēpĕrī́6v
ēpĕ3rō
ē2ph
ēpo2
2ēq
ē3qu
ē1r2
ēra3g
ē3ră
ēræ2ă
ērǣ2ă
2ē3re
ē3rēm
ē3rēs
ē3rēt
ē3rēu
ē3rēv
ē3rḗm
ē3rḗs
ē3rḗt
2ē3rĕ
ē3ré2
2ērī
2ērí
1ē2ro
ēro4s3
ērō3d4
ērō5dī
ērōdī5u
ērōdī5v
1ē2rŏ
ēró2
ē2r3ue
2ērun
3ērŭd
2ērú
2ēs.
ē2sa.
ē2sae
ē2sam
ē2saq
ē2sav
1ēsā
1ēsă
ē2să.
ē2săm
ē2săq
ē2său
ē2săv
1ēsá
ē2sáe
ē2sám
1ē2sæ
1ē2sǣ
1ē2sǽ
ē2sca
ē2scă
ē2scá
ēs3cæ
ēs3cǣ
ē2scé
ē2sci
ēs3cī
ē2scĭ
ē2scí
ē2scu
ēs4cul
ēsc3ū
ē2scŭ
ē2scú
ēs2e
3ēsē.
ēsē2i
3ēsēn
3ēsēq
3ēsēv
ēs2ĕ
2ēsé
ēs2i
ēsi2n
2ēsn
ē2so2
1ē2sō
ē2sŏ
ē2só
ēs2p
ēs3po
ēs3pŏ
ēs3pó
ēs3pū
2ēsq
3ēst.
ē2ste
ēs5ter
ē2stĕ
ēs5tĕr
ēs2ti
ēsti5t4
ēs2tĭ
ēs4tíl
ēstí3t4
3ēs4tn
3ē2stō
3ēs4tq
ēs2tr
3ē2stu
ēs4tue
3ē2stŭ
ē2stú
3ēs4tv
ē2s3ue
ē2s3uĕ
ēs3ui
3ēsum
3ē2sus
1ē2sū
1ēsŭ
ē2sŭs
1ē2sú
ē3sún
2ēsv
2ēt
ē3ta
ē3tă
ē3te
ēter4a
ēte5re
ēte3ri
ēte5rī
ēterī5u
ēterī5v
ē3tĕ
ētĕ3r4a
ētĕ3rǣ
ētĕ3rĕ
ētĕ5rī
ētĕrī5u
ētĕrī5v
ētĕ3rŭ
ēti4tu
ē3tī
ē3to2
ē3tō
ētō2i
ē3tŏ
ē3tó2
ē3tr
ē1u2
ēuā6ste
ēuā6stĕ
2ē3ue
ē3uĕ
ē3uī.
ē3uīn
ē3uīq
ē3uīu
ē3uī́
ē2um
1ēuo
ēuol3u
1ēuŏ
2ē2ŭ
2ē2ú
ēvā6ste
ēvā6stĕ
2ē3ve
ē3vĕ
ē3vī.
ē3vīn
ē3vīq
ē3vīv
ē3vī́
1ēvo
1ēvŏ
ēx2
ē2x3u
ē2́
2ḗa
2ḗā
2ḗă
2ḗæ
2ḗǣ
ḗb2
ḗ3bu
ḗ3bŭ
2ḗe
2ḗē
2ḗĕ
3ḗgr
ḗ4gre
ḗ4grĕ
2ḗi
ḗi2c
ḗ3iēn
ḗ4ir
2ḗī
ḗĭ2c
2ḗj
ḗ4loq
ḗ4lŏq
ḗ1m
ḗ4mar
ḗ4măr
ḗ4mēn
ḗ4mic
3ḗmim
4ḗminī
5ḗ4mit.
3ḗ4mĭc
3ḗmĭm
5ḗ4mĭt.
ḗ4mor.
ḗ4mŏr.
3ḗmp
3ḗmt
2ḗmu
ḗ4mŭn
2ḗn
ḗ4n3ea
ḗ4n3eā
ḗ4n3eō
ḗ4n3ĕā
ḗ4n3ĕă
ḗ4n3ĕō
ḗ4n3iē
ḗ4n3ii
ḗ4n3ĭē
ḗ4n3ĭĭ
2ḗō
2ḗq
2ḗr
ḗ3r2ă
ḗ3rĕ
3ḗ4sa
3ḗ2sā
3ḗ2să
3ḗ2sæ
3ḗ2sǣ
3ḗsē.
2ḗsn
ḗ2so
3ḗ2sō
ḗ2sŏ
2ḗsq
ḗ5s4tĭn
3ḗstn
3ḗstō
3ḗstq
ḗs4trŭ
3ḗstu
3ḗstŭ
3ḗstv
ḗ2su
3ḗsum
3ḗsus
3ḗsū
ḗ4sū.
ḗ3sūs
3ḗsŭ
ḗ4sŭs
2ḗsv
2ḗt
2ḗue
2ḗŭ
2ḗve
2ĕ2a
ĕ2ā
2ĕā.
2ĕān
2ĕāq
4ĕārŭ
2ĕāu
2ĕāv
4ĕā́n
4ĕā́u
4ĕā́v
2ĕă.
ĕ1ăm
ĕ2ăn
4ĕănĕ
2ĕ2ăq
ĕ2ăr
ĕ2ăt
2ĕ2ău
2ĕ2ăv
ĕ2ắ
ĕ3ắmb
2ĕ2á
2ĕ2æ
ĕæ2ă
ĕæ2ŭ
2ĕ2ǣ
ĕǣ2ă
ĕǣ2ŭ
2ĕ2ǽ
ĕb2
ĕbĕ3d
ĕbī3u
ĕbī3v
ĕ3bŭ
2ĕc
ĕ4c3ĕnn
ĕ4c5ĕ́nn
ĕ2ch
ĕc4ĭm
ĕ2c3l
ĕcŭ3mā
ĕcŭ3mă
ĕcŭ3mĕ
ĕcŭ3m4ī
ĕcŭmī́5n
ĕcŭmī́5q
ĕcŭmī́5u
ĕcŭmī́5v
ĕcŭ3mŭ
ĕcŭpĕ3
ĕ2c3ŭ2t
ĕ2d1a
ĕd3ā́c
ĕ2d1ă2
ĕdă4m
ĕd5ămă
ĕd3áu
ĕdē2g
ĕd3ēmē
ĕdē2s
ĕdḗ4g
ĕ2dĕm
ĕ3dĕō
ĕdĕ6stĕ
ĕdī5uĕ.
ĕdī5vĕ.
ĕ2dĭa
ĕ2dĭá
ĕ2dĭæ
ĕ2dĭǣ
ĕ2dĭǽ
ĕ2d3ĭg
ĕ2dĭm
ĕ2d3ĭn
ĕ2dĭp
ĕdĭ4s
ĕ4d3ĭ4ta
ĕ4d3ĭ4tá
ĕ4d3ĭ4tæ
ĕ4d3ĭ4tǣ
ĕ4d3ĭ4tǽ
ĕ4d3ĭ4tī
ĕ4dĭtĭ
ĕd5ĭtĭō
ĕd5ĭtōr
ĕd5ĭtōs
ĕ4d3ĭ4tū
ĕd5ĭtŭm
ĕd5ĭtŭs
ĕ4d3ĭ́g
ĕd5ĭ́4tă
ĕd5ĭ́4tĭ
1ĕdō
ĕ2dōr
ĕ4dṓr
1ĕdŏ2
ĕ2d3ŏl
ĕ2dŏp
3ĕdŏr
ĕ4d3ŏ́4l
ĕ4d3ŏ́p
ĕd2r
ĕd2ū
ĕdū3n
ĕ2d3ŭl
ĕ2d3ŭn
ĕ4d3ŭ́l
ĕ4dŭ́n
2ĕē
2ĕ1ĕ
ĕĕ2ă
ĕ2ĕm
ĕ2ĕq
ĕĕ2r
ĕĕ4rō
ĕ2ĕt
ĕĕ2x
ĕ2ĕ́2
2ĕfă
2ĕfĕ
ĕ2gn
ĕ2gō
ĕ3gō.
ĕ3gōn
ĕ3gōq
ĕ3gōu
ĕ3gōv
ĕ3gṓn
ĕ3gṓq
ĕ3gṓu
ĕ3gṓv
ĕ1h
ĕ1i
ĕ3iē
2ĕī
ĕ1ī2b
ĕ1ī2m
ĕ2īq
ĕ1ī2r
ĕ1ī2t
ĕ2īu
ĕ2īv
ĕī́2b
ĕī́2m
ĕī́2r
ĕī́4t
ĕ1ĭ
ĕ2ĭc
ĕ2ĭnŭ
ĕĭ2t
ĕĭ3tā
ĕĭ3tĭ
ĕ2ĭu
ĕ2ĭv
ĕĭ́4tĕ
2ĕl
ĕlă3s2
ĕllē3i
ĕllḗ5i
ĕ2l1u
2ĕm.
ĕ1ma
ĕ1mă
2ĕmn
1ĕmp
ĕm3pn
2ĕmq
2ĕ2mu
2ĕmv
2ĕn
ĕn2ā
ĕn3d2
ĕnd4ŭ
ĕ3n2e
ĕ3n2ĕ
ĕnĕ3rŭ
ĕnĕ́s5
ĕ2ni
ĕn2ŭ
ĕ2ōn
2ĕōr
2ĕ2ōs
ĕŏ2g3n
ĕ2ŏr
ĕŏ5rā́
ĕ3ŏrs
ĕ2ŏ́
ĕ3pĕ
ĕpĕ3r
ĕpĭ5str
ĕ3pŏ
2ĕps
ĕp2su
4ĕquĕ
2ĕr.
ĕr1a
ĕ3rae.
ĕ3raea
ĕ3raeā
ĕ3raeă
ĕ3raeá
ĕ3raeī
ĕ3raen
ĕ3raeu
ĕ3raev
ĕ5ra͞e.
ĕ5ra͞ea
ĕ5ra͞eā
ĕ5ra͞eă
ĕ5ra͞eī
ĕ5ra͞en
ĕ5ra͞eu
ĕ5ra͞ev
ĕ5rá͞ea
ĕ5rá͞eā
ĕ5rá͞eă
ĕ5rá͞eī
ĕ5ra͡e.
ĕ5ra͡ea
ĕ5ra͡eā
ĕ5ra͡eă
ĕ5ra͡eī
ĕ5ra͡en
ĕ5ra͡eu
ĕ5ra͡ev
ĕ5rá͡ea
ĕ5rá͡eā
ĕ5rá͡eă
ĕ5rá͡eī
ĕrās3
ĕr4āt
ĕ1ră2
ĕ3ră.
ĕr3ăc
ĕ2răd
ĕr5ămă
ĕr3ămī
ĕ3rănĕ
ĕr3ăng
ĕ3răq
ĕ2r3ăs2
ĕ3rău
ĕ3răv
ĕrắ2
ĕ4r3ắd
ĕ4r3ắg
ĕ4r3ắl
ĕ4r5ắmb
ĕrắs6tō
ĕr3áes
ĕ2r3áu
ĕr1æ2
ĕ3ræ.
ĕ3ræā
ĕ3ræă
ĕ3rææ
ĕ3ræǽ
ĕ3ræī
ĕ3ræn
ĕ3ræu
ĕ3ræv
ĕr1ǣ2
ĕ3rǣ.
ĕ3rǣā
ĕ3rǣă
ĕ3rǣǣ
ĕ3rǣī
ĕ3rǣn
ĕ3rǣu
ĕ3rǣv
ĕ3rǣ́ā
ĕ3rǣ́ă
ĕ3rǣ́ǣ
ĕ3rǣ́ī
ĕ3rǣ́n
ĕr3ǣ́s
ĕ3rǣ́u
ĕ3rǣ́v
ĕr3ǽ2s
ĕ3r2e
2ĕrē
ĕ2r3ē2d
ĕr3ē2g
ĕ5rēmĭnī
ĕ5rēmŭ
ĕ5rēnĕ
ĕ5rērĕ
ĕ5rērĭ
ĕr3ēss
ĕr3ēst
ĕ5rēuĕ
ĕ5rēvĕ
ĕr3ḗ4d
ĕ4r3ḗ4g
ĕ5rḗmĭnī
ĕ5rḗmŭ
ĕr5ḗnă
ĕ5rḗnĕ
ĕ5rḗq
ĕ5rḗrĕ
ĕ5rḗrĭ
ĕr5ḗss
ĕr5ḗst
ĕ5rḗt
ĕ5rḗuĕ
ĕ5rḗvĕ
2ĕ1rĕ
ĕ3rĕ.
ĕr3ĕăt
ĕr3ĕ4d4
ĕ2rĕf
ĕrĕ2g
ĕrĕ2m
ĕr3ĕmā
ĕ4r3ĕmă
ĕr3ĕmē
ĕr3ĕmĕ
ĕr3ĕmī
ĕr3ĕmĭ
ĕ4r3ĕmō
ĕr3ĕmŏ
ĕr3ĕmŭ
ĕ2r3ĕ2q
ĕ5rĕquĕ
ĕ2r3ĕ2s
ĕ3rĕu
ĕ3rĕv
ĕr3ĕ́4d
ĕrĕ́4m
ĕr5ĕ́mĕ
ĕr5ĕ́mĭ
ĕ4r3ĕ́s
ĕr1i
2ĕ1rī
ĕrī3ā
ĕr3ī2b
ĕ2rīn
ĕr4īq
ĕr3ī́4b
ĕr4ī́q
ĕ4r3ĭ4cĕ
ĕr3ĭ4cĭ
ĕr3ĭ4dō
ĕ5rĭĕ.
ĕ5rĭĕn
ĕ5rĭĕq
ĕ5rĭĕu
ĕ5rĭĕv
ĕ4r3ĭ4mā
ĕ4r3ĭ4mă
ĕr5ĭ4mēb
ĕr5ĭ4mēm
ĕ4r5ĭ4mēn
ĕr5ĭ4mēr
ĕr5ĭ4mēs
ĕr5ĭ4mēt
ĕr5ĭ6mḗb
ĕr5ĭ6mḗm
ĕ6r5ĭ6mḗn
ĕr5ĭ6mḗr
ĕr5ĭ6mḗs
ĕr5ĭ6mḗt
ĕ4r3ĭ4mĕ
ĕ4r3ĭ4mī
ĕr5ĭ4mĭm
ĕr5ĭ4mĭs
ĕr5ĭ4mĭt
ĕr5ĭ4mĭ́
ĕrĭ4mō.
ĕrĭ4mōq
ĕrĭ4mōu
ĕrĭ4mōv
ĕr3ĭ4mŏ
ĕr5ĭ4mŭn
ĕr5ĭ6mŭ́n
ĕr3ĭng
ĕr4ĭō
ĕr4ĭŏ
ĕr4ĭs
ĕ4r5ĭ4tĭb
ĕ5rĭtōt
ĕ5rĭtṓt
ĕ5rĭtŏ
ĕrĭ4tūs
ĕ4r5ĭ4tŭī
ĕ5rĭtŭr
ĕ4r5ĭ4tŭŭ
ĕ5rĭtŭ́r
ĕr4ĭŭ
ĕr5ĭ́4cĭ
ĕ4r3ĭ́ĭ
ĕ6r5ĭ́6mĕn
ĕ6r5ĭ́6mĕq
ĕr5ĭ́6mĕr
ĕ6r5ĭ́6mĕu
ĕ6r5ĭ́6mĕv
ĕr5ĭ́6mĭm
ĕr5ĭ́6mĭt
ĕrĭ́6tĭb
ĕ4r5ĭ́4tŭ
2ĕrn
ĕ1ro
ĕ1rō
ĕ3rōn
ĕr3ō4rē
ĕr3ō4rĕ
ĕr3ō4rō
ĕ3rōrŭ
ĕ3rōs.
ĕr3ōsc
ĕ3rōsn
ĕ3rōsq
ĕ3rōsu
ĕ3rōsv
3ĕrōt
ĕrṓ4rē
ĕrṓ4rĕ
ĕ5rṓrŭ
ĕr5ṓsc
3ĕrṓt
ĕr1ŏ
ĕr3ŏ́l
ĕ3rŏ́r
2ĕrq
2ĕ2r1u
ĕ3rūg
ĕrū2r
ĕr3ūt
ĕr3ū́4r
ĕr3ū́t
ĕ3rŭē
ĕ3rŭĕ
ĕ3rŭī
ĕ3rŭĭ
ĕ3rŭ2m3
ĕ5rŭntō
ĕ5rŭntŏ
ĕ5rŭntŭ
ĕ3rŭs.
ĕ3rŭsn
ĕ3rŭsq
ĕr3ŭss
ĕr3ŭst
ĕ3rŭsu
ĕ3rŭsv
ĕr3ŭ2t
ĕ3rŭ́l
ĕ3rŭ́m
ĕ5rŭ́sn
ĕ5rŭ́sq
ĕr5ŭ́ss
ĕr5ŭ́st
ĕ5rŭ́su
ĕ5rŭ́sv
2ĕrv
1ĕ1sc
ĕs2cī
ĕs2cĭ
ĕs2cŭ
ĕ3s2ĕ
ĕ3sō
ĕ1sp
ĕspĕ5rī
ĕ2sph
ĕs2pl
ĕs2pō
ĕs2pŏ
ĕs2pŭ
ĕ2sq
ĕs2ta
ĕ4stēs
ĕ4stḗs
ĕ4s3tĕ.
ĕ4stĕm
ĕ4s5tĕnĕ
ĕ4s3tĕq
ĕ4s3tĕu
ĕ4s3tĕv
ĕ4stĕ́m
ĕ4s3tī.
ĕ4s5tīnĕ
ĕ4s3tīq
ĕ4s3tīs
ĕ4s3tīu
ĕ4s3tīv
ĕ6s5tī́nĕ
ĕ4s5tī́q
ĕ4s5tī́s
ĕ4s5tī́u
ĕ4s5tī́v
ĕ4stĭ́c
ĕs4tn
ĕ2s3tō
ĕs4tq
ĕs3trē
ĕs3trĕ
ĕ2s4tu
ĕs4tv
ĕ2su
ĕ3t2ă
ĕtă3g
ĕtĕ3rĕ
ĕtĕ5rī
ĕtĕrī5u
ĕtĕrī5v
ĕtĕ3rŭ
ĕtĭ4ă
ĕt3ĭp
3ĕts
ĕ2t1u
2ĕ1u
ĕ3uĕ
ĕ1ū2
ĕ2ū3m
ĕ2ū́m
ĕū́2r
ĕū́4t
1ĕŭ2
ĕ1ŭl
2ĕ2ŭm
ĕ1ŭr
2ĕŭs
ĕ1ŭt
2ĕ2ŭ́m
2ĕŭ́s
ĕ4ŭ́sq
ĕ3ŭ́t
2ĕv
ĕ3vĕ
ĕ2xă
ĕx3áu
ĕx3ĕ́m
ĕ2xi
ĕx3ĭī
ĕxō2
ĕ3xṓ
ĕxṓ4rā
ĕxṓ4ră
ĕxṓ4rē
ĕxṓ4rĕ
ĕxṓ4rō
ĕx5tĕr
ĕ2xu
ĕ2́
2ĕ́ă
ĕ́b2
ĕ́2cl
ĕ́4dăm
ĕ́4dīs
ĕ́4dĭa
ĕ́4dĭæ
ĕ́4dĭǣ
ĕ́4d5ĭ4ta
ĕ́4d5ĭ4tæ
ĕ́4d5ĭ4tǣ
ĕ́4d5ĭ4tī
ĕ́4d5ĭ4tū
ĕ́2dŏ
2ĕ́ĕ
ĕ́3ĕō
ĕ́3ĕŏ
ĕ́3ĕ2r
1ĕ́f
ĕ́1i
ĕ́3iē
2ĕ́l
2ĕ́m
2ĕ́n
ĕ́nd4
4ĕ́ps
ĕ́ră4g
ĕ́r5ĕăn
ĕ́r5ĕăt
ĕ́r3ī
ĕ́4rīs
ĕ́4r5ĭm.
ĕ́4r5ĭ4mā
ĕ́4r5ĭ4mă
ĕ́4r5ĭmĕ
ĕ́4r5ĭ4mī
ĕ́4r5ĭ4mō
ĕ́r5ĭ6tūs
ĕ́2ru
ĕ́4r3ŭt
3ĕ́sc
ĕ́3s4cī
ĕ́3sĕ
ĕ́3spŭ
4ĕ́stā
ĕ́5stĭtā
ĕ́5stĭtī
ĕ́5stĭtĭ
ĕ́5stĭtō
ĕ́4str
2ĕ́2t
ĕ́3tā
ĕ́3tă
ĕ́3tē
ĕ́3tĕ
ĕ́3tī
ĕ́3tō
ĕ́3tŏ
ĕ́3tr
3ĕ́ts
ĕ́3tŭ
ĕ́x3ĕā
ĕ́x3ĕă
ĕ́x3ĕō
ĕ́x3ĭī
2é2a
2éæ
2éb2
éba3q
ébe3
éb4ri
ébs3
é3bu
éce1
é2ch
é2c3l
éco1
écu3m4
é2c3u2t
éda2m
é4d3ama
é4damā
éd2i
é2diǣ
é2d3i2g
éd3ime
éd3i4mi
éd4is
éd3i4tǣ
éd3i4tī
éd3i4tū
é2d3o2l
éd3ue
2ée
é1ea
é1eā
é1eo
é1eō
é1e2r
é1es
éfe1
1éff
é3g2a
é3gæ
é2gl
é2g3n
é1h
2éi
é3ian
é3iaq
é3iau
é3iav
é1i2c
é1ie
é3ieq
é3ieu
é3iev
é1iē
é3iit
é2in
é3ior
é3iou
é3iov
é2is
é3iul
é2leg
é3li
élu2
é2l3ue
é2l3ut
é1m2a
ém2e1
3é4mera
ém2i
é2mic
2émin
3é4mit.
2émn
é1mo1
1émp
2émq
1émt
2ému
2émv
2én
énd2
énd4u
é2n3ea
én2ex
én3iit
én3si
é3n2ua
é3n2uē
é3n2uī
én2ul
é3n2uo
2éo
épe1
épe3r
2éps
ép4se.
ép4sen
ép4seq
ép4seu
ép4sev
ép2su
4é3que
é1r
2éra
é3ra.
é3rae
é2ra2g
ér2al
éra2m
é3ram.
ér3ama
é3ran
é3raq
éra2r
ér3ara
ér5are
ér3aro
é3ras
é3rau
é3rav
é3ra͡
é3ræ
2ére
ér3ean
ér3eat
ér3e2d4
ére2g
ére2m
é4r3ema
ér3emā
ér3eme
ér3emē
é4r3emi
ér3emī
é4r3emo
é4r3emō
é4r3emu
é4r3eru
é4rest
é2rh
é4riac
é3riar
2érib
ér5i4cit
2érie
ér3ier
é4r3iit
é4r3i4ma
é4r3i4mā
é4r3i4me
é4r3i4mē
é4r3i4mi
é4r3i4mī
é4r3i4mo
é4r3i4mō
ér5i4mun
é3rio
é3rip
é5ritor
é5ritur
éri4tūs
ér3ī
2érn
é3ro.
3é2rog
é2r3o2p
2érq
ér5rue
2éru
é2r3ua
é2r3uā
é2rue
é2r3uē
é3rul
é3rum
é3run
é2ruo
é2r3uō
é3rus
ér3u2t
é2ruu
2érv
1é2sa
1é2sæ
é3s2cī
és2i
2ésn
1é2so
éspe3
és2pu
2és3q
4ésta
4éstā
és3tib
3éstn
3éstq
3éstv
3é2su.
é4s3ue
és3ui
3ésum
3ésus
2ésv
2ét
éte1
3éts
2éu
é1ua
é2uam
é2uaq
é2uau
é1uā
é1uæ
é1uǣ
éub2
é1ue
é2uel
é1uē
é1ui
é1uī
éu1m
é3unx
éute3
éu4tra
é1ū
2év
é3ve
éx2a
é2x3ea
é2x3eā
é2x3eo
é2x3eō
éx2ib
é2xiu
éx2o
éx2ō
é2xue
éx4us
2é͞
2é͡
1f
f2a
fa4c3ue
fa1m
fa2ru
fas3
fās3
fá2c3u
fá1m
fá2ru
fece3
fe2i
fe3li
fe3ra
fe3r2æ3
fe3r2ǣ
fe3rē
fe3r4i
fe3rī
fe3ro
fe3rō
fe3ru
fes5tā
fes5te
fe2x
fē2i
fĕ3r2a
fĕ3ră
fĕ3r2æ
fĕ3r2ǣ
fĕ3rē
fĕ3r4ĕ
fĕ3rī
fĕ3rŏ
fĕ3rŭ
fĕ2s3
fĕs5tĕ
fĕ́3ră
fĕ́5r4ī
fé2i
fér4ī
fé2ru
fé2x
2ff
file2
fi1s
fis2i
fĭĕ3
fí1m
f2l2
flo3
flor2
fons3
fo3rī
fŏ3rī
fœ̄3d
f2r2
fra3g
fră3g
fre3
frem2
fre5mi
fre5mo
fr4ē3n
frḗ5n
fr4ĕ́3
fré1
fré5na
fu1s
fú1s
1g
gab2
2g1ae
g2aeq
g4aeue.
g4aeuĕ.
g4aeve.
g4aevĕ.
ga2i
gao3
g2ar
ga3re
g2au
2g1a͞
g4a͞eq
g6a͞eue.
g6a͞euĕ.
g6a͞eve.
g6a͞evĕ.
g4á͞eq
g6á͞eue.
g6á͞euĕ.
g6á͞eve.
g6á͞evĕ.
2g1a͡
g4a͡eq
g6a͡eue.
g6a͡euĕ.
g6a͡eve.
g6a͡evĕ.
g4á͡eq
g6á͡eue.
g6á͡euĕ.
g6á͡eve.
g6á͡evĕ.
gā4iae.
gā6iaene
gā6iaeque
gā6iaeue
gā6iaeve
gā6ia͞e.
gā6ia͞ene
gā6ia͞eque
gā6ia͞eue
gā6ia͞eve
gā6iá͞ene
gā6iá͞eque
gā6iá͞eue
gā6iá͞eve
gā6ia͡e.
gā6ia͡ene
gā6ia͡eque
gā6ia͡eue
gā6ia͡eve
gā6iá͡ene
gā6iá͡eque
gā6iá͡eue
gā6iá͡eve
gā2iā
gā6iáene
gā6iáeque
gā6iáeue
gā6iáeve
gā4iæ.
gā4iæne
gā6iæque
gā4iæue
gā4iæve
gā4iǣ.
gā4iǣne
gā6iǣque
gā4iǣue
gā4iǣve
gā6iǣ́ne
gā6iǣ́que
gā6iǣ́ue
gā6iǣ́ve
gā4iǽne
gā6iǽque
gā4iǽue
gā4iǽve
gā4iīs.
gā6iīsne
gā6iīsque
gā6iīsue
gā6iīsve
gā6iī́sne
gā6iī́sque
gā6iī́sue
gā6iī́sve
gā2iu
gā2iú
găb2
gă3rĕ
g4áeue.
g4áeuĕ.
g4áeve.
g4áevĕ.
gá2i
gá3ian
2g1æ2
g2æ3q
g4æue.
g4æuĕ.
g4æve.
g4ævĕ.
2g1ǣ2
g2ǣ3q
g4ǣue.
g4ǣuĕ.
g4ǣve.
g4ǣvĕ.
g2ǣ́3q
g4ǣ́ue.
g4ǣ́uĕ.
g4ǣ́ve.
g4ǣ́vĕ.
g2ǽ3q
g4ǽue.
g4ǽuĕ.
g4ǽve.
g4ǽvĕ.
2gd
g2e
ge2e
ge2i
3gena
3genā
3gená
3genæ
3genǣ
3genǽ
3genen
3geneq
3geneu
3genev
3genē
3gené
3geni
3genī
3gení
3geno
3genō
3genó
3genu
3genú
ge1r
ger2æ3
ger2ǣ
ge3rē
ge3rī
ges3t
ges5tā
ges5te
ges5tr
2getē
2geté
2getī
ge2un
3gēd
gē2i
g2ĕ
gĕ2ă
gĕ2ī
3gĕna
3gĕnā
3gĕnă
3gĕná
3gĕnæ
3gĕnǣ
3gĕnǽ
3gĕnē
3gĕnĕn
3gĕnĕq
3gĕnĕu
3gĕnĕv
3gĕnī
3gĕnō
3gĕnŭ
3gĕ3r2a
gĕ3ră
3gĕrá
3gĕ3r2æ
3gĕ3r2ǣ
3gĕrǽ
gĕ3rē
gĕ3r4ĕ
gĕ3rī
gĕ3rŏ
3gĕ3rŭ
gĕs3
gĕs5tĕ
3gĕ́nă
3gĕ́nĕ
gĕ́3rĕ
gé2i
3géna
3génen
3géneq
3géneu
3génev
3géss
3gést
2gg2
g3ga
g3gæ3
g3gǣ
g2i
3gie
gig3
gi4gn
gi2i
gi4lue
gim2
gin2ā
gis3
gi4sc
gis5ci
gispe3
gis5te
g2ĭ
3gĭĕ
gĭ5mĭn
gĭn2ā
gĭn2ĕ
gĭs5tĕ
3gĭtī
gíg3
gí2lu
gí1m
gí3tur
g2la
g2lā
g2lá
g2læ
g2lǣ
g2lǽ
g2les
g2lēs
2glĕ
g2lés
2gli
g2lī
2glĭ
g2lí
g2lo
g2lŏ
g2lu
g2lū
g2lú
2g1m2
g1n2
gn4an
gna5ni.
gna5nin
gna5niq
gna5nis
gna5niu
gna5niv
gna5nín
gna5níq
gna5nís
gna5níu
gna5nív
gnā3nī
gná5ni.
gná5nis
gnæ4uŭ
gnæ4vŭ
gnǣ4uŭ
gnǣ4vŭ
2gne
g3nem
g3nes
g3nĕm
gnĕ3rŭ
g3nĕ́
2gné
g3ném
g3nés
g3nib
g4nitæ
g2no
g3non
gno2p
g3noq
g3nor.
3gnora
3gnorá
5gnorim
5gnorit
5gnorím
5gnorít
g3norn
3gnoro
3gnoró
g3norq
5gnorun
5gnorún
g3norv
3gnos
3gnou
3gnov
3g4nóra
5g4nóre.
5g4nórim
5g4nórin
5g4nóris
5g4nórit
3g4nóro
5g4nórun
3g4nósc
3g4nóss
3g4nóst
5g4nóuer
3g4nóui
5g4nóver
3g4nóvi
g2ob2
3gog
go3n
go5ni5c
go4nn
go4nq
go4nue
go4nv
go2p
g1o2t
go3th
3gōg
g1ō2t
g3ṓ4t
g2ŏ
2gŏ.
gŏb2
2gŏm
gŏ2p
2gŏq
2gŏu
2gŏv
3góg
g1ót
gó2ti
gœ̄3d
g2r2
gra3d4
3grae
gra4ia
gra4iá
gra4iæ
gra4iǽ
gra4ie
gra4ii
gra4ií
3gra͡
grā6iāne
grā6iā́ne
grăd2
3gráe
3græ
3grǣ
3grǽ
gre3d4
gre5di
gre5dī
gres3
grĕ3d4
grĕ5dī
grĕ2s3
grĕ́s3
grés3
gré6sti
gri3n
2grī
g2u
gumi3
gus3
gūn4e
gūn4ĕ
2gŭæ
gŭ4ĕ́
2gŭīs
gŭ3m2ĭ
gý3t
h2a
hab2
ha4c3ue
hae2c3
ha2i
ha2ī
ha1m
h3ang
ha2o
ha3re
ha3rē
hā2c1
hā2i
hā2ĭ
h2ă
hă3b2
hă2ī
h3ăng
hă3ră
hă3rē
hă3rĕ
h3ắng
há2c3u
háe2c3
há2i
h3áng
hæ2a
hæ2ă
hæ2á
hæ2c1
hæ2i
hæ2ŭ
hǣ2a
hǣ2ă
hǣ2c1
hǣ2ŭ
hǽ2c1
h2e
he2a
hed2
he2e
he3g
he2ia
he2iá
he2ic3
he2ie
he2ié
he2ii
he2ií
he2io
he2ió
he2í
heíc3
he2lu
he2nu
he2o
he3r2a
hera3g
he3rá
he3r2æ
he3r2e
he3r4i
heris3
he3rī
he3ro
hero5d
he3se
he2s3p
hespe3
he2sq
he2st
he2u
he2ū
heū3s
he2x
h2ē
hē2ia
hē2iā
hē2iá
hē2iæ
hē2iǣ
hē2iǽ
hē2ie
hē2iē
hē2iī
hē2iō
hēmĭ3s
hē2nu
hē3r
hē4rn
hē4rq
hē4ru
hē4rv
hē3se
hē3sĕ
hēs3t
h2ĕ
hĕ2ă
hĕ2ĭ
hĕ3r4ĕ
hĕ3rī
hĕ3rŭ
hĕ2sp
hĕ2ū
hĕū3s
hé2i
hé1m
hé3r2a
héra3g
hé2ru
hé2x
h2i
hi4c3ue
hi2i
hin2ā
hi2o
hio2s
hi3p2t
hi4s3t
his5ta
his5tā
his5te
hi3uu
h2ī
hī2cu
hī3p2
hī3sŏ
hī́3p2
hĭn2a
hĭn2ā
hĭn2æ
hĭŏ3p
hĭ3p2t
hĭ4st
hĭs5tā
hĭs5tă
hĭs5tĕ
hĭ́p4t
hí2c3u
híp2t
h2l
2h1m2
hmĭ2ă
hmo4nu
h1n2
hno3b2
hnu3
hn4us
hnū3
h2o
ho2a
ho3b2
hobī3u
hobī3v
ho2c3u
ho2e
ho2i
hoi3q
ho2ī
hoī3u
hoī3v
hoī́3u
hoī́3v
ho2í
hon3g4
hongæ3
hongǣ́5
hongǽ3
ho2o
ho2ō
ho2ó
ho5rén
ho3rī
ho2s
ho3se
ho3si
ho3sí
ho3spe
hō2cu
hōne4
hō2nu
hō2sp
h2ŏ
2hŏ.
hŏ2ă
hŏ3b2
hŏbī3u
hŏbī3v
2hŏd
hŏ2ī
hŏī3u
hŏī3v
hŏī́3u
hŏī́3v
hŏ2ĭ
hŏn3g4
hŏngæ3
hŏngǣ́5
hŏngǽ3
hŏ2ō
hŏ3rī
hŏ2s
hŏ́3rĭ
hŏ́4s
hób2
hó2c1
hó3l
hó2nu
hó2sp
2hœ
h2r2
hras5t
hrăs3t
hu2cu
hu1i2
huic3
huí2
huíc3
hum2e
h2ū
hū2cu
hū3l
hū́3l
hŭ3mĭ
hú2c1
hú3iu
iab2
iabo3l
iab4u
1iac
3iact
iad2æ3
iad2ǣ
iad2ǽ
ia3d2e
iad2ē
iad2é
iad2i
iad2ī
i2ae
ia3iú
i3alt
iamb2
iam5bi
iambī5q
iambī5u
iambī5v
iambī́5q
iambī́5u
iambī́5v
3iamī
i3ang
i3ann
i1ap
i2aq
ia3re
ia4rid
ia4ríd
ia3s4pe
ia3spé
ias3t
ias5te
ias5tr
ia4tra
ia4trá
ia4tro
ia4tró
i2au
i1a2x
i2a͞
i2a͡
2iāc
i2ān2
3iānĕ
3iāquĕ
i2āru
3iārŭ
3iāsnĕ
5iāsquĕ
3iāsuĕ
3iāsvĕ
iā4trā
3iāuĕ
3iāvĕ
i1ā2x
3iā́nĕ
5iā́quĕ
3iā́rŭ
5iā́snĕ
5iā́squĕ
5iā́suĕ
5iā́svĕ
3iā́uĕ
3iā́vĕ
1iă
iăd2
iábo3
3iácu
2iád
i2áe
i3ált
iám3b2
i4áne
i3áng
2iáq
iá4rid
iá4tro
i1á2x
i2æ
iæ2a
iæ2á
iæ2i
i2ǣ
iǣ2a
i2ǽ
ib2
i3biu
ibī3u
ibī3v
2iboe
2iboē
2iboé
ibo3l
i3bum
ib4un
i5bund
4ibu2s3
i3bū
ib4ū́
4ibús3
2ic.
2i3ca
2i3cā
2i3cá
2i3cæ
2i3cǣ
2i3cǽ
2iceb
2icen
i4c3enn
2icet
i3cēn
2icén
i4c5énni
2icéq
2icéu
2icév
i3cia.
i3ciaq
i3ciau
i3ciav
i3cii
i3cií
i3cium
i3ciúm
2i3cīs
i3cī́s
i3cía
2icl
2icn
2i3co
2i3cō
2i3có
2icq
2ict
i2c3u2t
ic2ū
2icv
i3d2a
2i3d2e
ide3mé
ide2s
2i3dē
idē4iē
idē3m
idē2s
2i3dé
2i3d2i
idi3g
id3ips
idi4s
2i3dī
2i3dí
i3do
id4or
2i3d2u
2i3dú
2ie.
1iec
iece3
ie2e
2ieg
ie4gn
2ieī
2ieí
i2em
2ieo
2ieō
2ieó
2i2eq
ie1r
ie3r2e
ie3rī
i3erm
ie2s
i3e4sa
i3esá
ies3c
i3ese
i3esé
i3e4si
i3esí
i3e4so
i3esó
ies5tā
i3esú
2iete
iete5re
2ietē
2ieté
2ietī
2i2eu
ie2un
2ieú
2i2ev
1iex
iex2i
ie2xu
2ie͞
2ie͡
2iē.
1iēc
2iēg
i2ēn
iē3na
2iē3ne
2iēq
3iēquĕ
iē2s
iē4sa
iē3sū
4iēta.
4iētae.
6iētaene
6iētaeque
6iētaeue
6iētaeve
4iētam
4iētan
4iētaq
4iētau
4iētav
6iēta͞e.
6iēta͞ene
6iēta͞eque
6iēta͞eue
6iēta͞eve
6iētá͞ene
6iētá͞eque
6iētá͞eue
6iētá͞eve
6iēta͡e.
6iēta͡ene
6iēta͡eque
6iēta͡eue
6iēta͡eve
6iētá͡ene
6iētá͡eque
6iētá͡eue
6iētá͡eve
2iētā
5iētānĕ
5iētāquĕ
5iētārŭ
5iētāsnĕ
5iētāsquĕ
5iētāsuĕ
5iētāsvĕ
5iētāuĕ
5iētāvĕ
5iētā́nĕ
5iētā́quĕ
5iētā́rŭ
5iētā́snĕ
5iētā́squĕ
5iētā́suĕ
5iētā́svĕ
5iētā́uĕ
5iētā́vĕ
6iētáene
6iētáeque
6iētáeue
6iētáeve
4iētám
4iētæ.
4iētæne
6iētæque
4iētæue
4iētæve
4iētǣ.
4iētǣne
6iētǣque
4iētǣue
4iētǣve
6iētǣ́ne
6iētǣ́que
6iētǣ́ue
6iētǣ́ve
4iētǽne
6iētǽque
4iētǽue
4iētǽve
4iētē.
4iētēn.
4iētēne
6iētēnne
6iētēnque
6iētēnue
6iētēnve
6iētēque
4iētēs.
6iētēsne
6iētēsque
6iētēsue
6iētēsve
4iētēue
4iētēve
6iētḗne
6iētḗnne
6iētḗnque
6iētḗnue
6iētḗnve
6iētḗque
6iētḗsne
6iētḗsque
6iētḗsue
6iētḗsve
6iētḗue
6iētḗve
4iētīs.
6iētīsne
6iētīsque
6iētīsue
6iētīsve
6iētī́sne
6iētī́sque
6iētī́sue
6iētī́sve
2i2ēu
3iēuĕ
2i2ēv
3iēvĕ
1iēx
3iḗc
2iḗg
iḗ2s
4iḗta
4iḗtā
4iḗtæ
4iḗtǣ
4iḗtē
4iḗtī
i2ḗu
i2ḗv
1iĕ
iĕ1r
iĕ3r4ĕ
iĕs3
1iéc
2iég
ié4gn
i2é1m
2iéne
2iéq
i3érm
ié2s
ié4sa
i3ése
i3ési
2iéte
2iéu
2iév
1iéx
ié2xu
2ié͞
2ié͡
2if
ife6ste
ig2a
1ig2æ3
1ig2ǣ
4igena
4igenā
4igená
4igenæ
4igenǣ
4igenǽ
4igenen
4igeneq
4igeneu
4igenev
4igenē
4igené
4igeni
4igenī
4igení
4igeno
4igenō
4igenó
4igenu
4igenú
4igéna
ig2l
i2gn
ig3nat
ig3nāt
ig5nā́t
ig3nát
ig3nē
i3gr
2i1h
i3ha
ihí3
i1i2a
iiam3
i1i2á
i1ie
i1iē
i1io
i1ió
i1iu
i2iue
i1iú
i2ī
3iīnĕ
3iīuĕ
3iīvĕ
1iĭ
2ij
2i3le
ilē3i
ilḗ3i
2i3lé
i3li
ili4g5n
ilí4g3
4ille.
4illen
4illeq
6illeue.
6illeve.
4illi.
4illiq
4illis
4illiu
4illiv
2illī
6illíne.
4illíq
4illís
4illíu
4illív
2illo
2illō
2illó
4illum
4illus.
4illusn
4illusq
4illusu
4illusv
4illúm
4illúsn
4illúsq
4illúsu
4illúsv
2ilo
2iló
i2l3ua
i2luā
i2l3uá
i2l3uæ
i2luǣ
i2l3uǽ
il3ue.
il3ues
i2l3uē
il4uēr
il3ués
il5uis.
il5uisn
il5uisq
il5uisu
il3uīs
il5uī́s
il5uísn
il5uísq
il5uísu
i2luo
i2luō
i2l3uó
i2luu
i2luú
i1m
2im.
i3ma.
i2mad
ima4lu
im2am
im2an
i3maq
im2as
i3mau
i3mav
imás3
i3mæ
i3mǣ
i3mǽ
im3b2
im5biv
imbī3q
imbī3u
imbī3v
imbī́5q
imbī́5u
imbī́5v
im2e
2imed
ime5dá
ime5de
ime5dé
2imel
4imetr
2imēd
2imēl
4imḗd
4imḗl
2iméd
2imél
4i5métr
im2i
imi2a
i4micu
i4micú
3i2mie
3i2miē
3i2mié
3i2mii
i4minē
4i5minī
3i2mir
i4mitæ
i4mitǽ
i4mitu
3i2míc
3i2míi
3i2mír
imí5tur
1imm
2imn
imo4nu
i4m3ord
i4m3órd
1imp
impe5r6ii
impe5r6iī
impe5r6ií
impe5rin
impe5riue
impe5riv
impe5r4ī
2imq
2imue
2imv
i1n
i3na.
i3nae
in4al
i3nam
i3n4aq
i3nar
i3nas
i3nau
i3n4av
i3na͡
i3náe
in4ál
i3nám
i3náq
i3nár
i3nás
i3náu
i3náv
i3næ
i3nǽ
indi5st
in4d3ue
in4d3ui
in4d3uī
in4d3uí
in4d3úe
2i3ne
ine2d
ine2l
ine2x
in3e͞
in3e͡
i3né
iné2d
1inf
i3ni.
i3nia
i3niá
i3nib
ini2c
in3ice
in3ici
i3nii
i3nií
ini2m
i3nin
i3nio
i3nió
i3nis
i3nit
i3niu
i3niú
i3niv
iní4ciā
iní4cie
iní4ciē
iní4ciō
i3nín
i3níq
i3nís
i3níu
i3nív
1inj
2i3no
2i3nō
2i3nó
in5réq
1in1s2
insi5ti
instre5
instré5
4int.
in5ter
inte5ron
inte5rōn
inte5rṓn
inté6r5is
2inth
4intn
4intq
2intu
4intv
1in1u2
inu4b
4inum
2i3nus
in1ū2
inū́4b
inú2b
in3únd
1inv
io1
io2a
iob2
iobo3
io2bó
iom2
iome3
iome5d
2ion
io3n2i
io5ni5c
3iono
3ionó
2iope
2iopē
2iopé
io3rī
2ios
io2st
iot4e
io5ten
iot4é
io5tén
i2ō
iō3d
3iōnĕ
3iōrŭ
3iōuĕ
3iōvĕ
1iŏ
i1ó2b
ióbo3
2ióc
2ióni
2iós
2ipa
2ipā
2ipá
2i3pe
ipe3r
iper4a
iper4ā
iper4æ
iper4ǽ
iper4e
iper4ē
iper4o
iper4ó
2i3pē
2ipé
2iph
2i3pi.
2i3pib
2i3pin
2i3piq
4i3pis.
4i3pisn
4i3pisq
4i3pisu
4i3pisv
2i3piu
2i3piv
2ipī.
2i3pīn
2ipīq
2ipīu
2ipīv
4i3pī́n
4i3pī́q
4i3pī́u
4i3pī́v
2ipín
2ipíq
i4písc
4ipísn
4ipísq
4ipísu
4ipísv
2ipíu
2ipív
2ipl
ip2ne
ipo4s3
2i3pu
ipu3l
2ipú
2ir.
i1r2a
irad2
ira3g
iras7cen
iras5t
i1r2æ
iræ3d
i1r2ǣ
irǣ3d
i1re
i3re3d4
ire5di
ir3e4me
ire4mér
ir5e4mim
ir5e4mis
ire4mít
i3r2ex2
ire5xi
ir1ē
iré4mer
ir5é4mim
i1rh
i1r2i
i2r3i2b
iri4be
i2r3i2m
iri3n
i1rī
ir3í2b
i2r3í2m
i1ro
i1rō
1irr
ir5réq
2irrh
ir5rue
i1ru
i2rue
i1ry
i1rý
2is.
is2ad
i2s3al
is3a4tr
i2s3ā2
isā́2
is4ád
2i2sc
is3cæ
i5scendamus
i5scendamú
i5scendant
i5scendat
i5scendámus
i5scendánt
i5scendát
i6scende.
i6scendene
i6scendeq
i6scendeu
i6scendev
i5scendé
i5scendim
i5scendit
i5scendít
i5scendun
i5scendún
is7cens.
is7censn
is7censq
is7censv
i5scéndant
i5scéndat
i5scéndens
i5scéndent
i5scénder
i5scéndes
i5scéndet
i5scéndim
i5scéndit
i5scéndun
i5s6cénsa
i5s6cénsæ
i5s6cénse
i5s6cénsi
i5s6cénso
i5s6cénsu.
i5s6cénsum
i5s6cénsus
is4cid
i3s4cis
i4s5cis.
i4s5cisn
i4s5cisq
is5cisu
i4s5cisv
is3ciu
is3civ
is3cī
is4cíd
i5s4císs
2is2e
2isi
i2s3i2c
i2sie
i2siē
is4iue
2isí
i2s3í2c
2ism
2isn
2iso
3i2sod
2isó
3isód
i3spec
is3per
i5sperg
isperi6n
isperi6q
isper7i6u
isperi6v
isperī6n
isperī6q
isperī6u
isperī6v
isperī́6n
isperī́6q
isperī́6u
isperī́6v
isperí6n
isperí6q
isperí6u
isperí6v
i5spers
i3spex
i3spéc
i5spérg
i5s4pérn
i5spérs
i3spéx
is3pī
2i2s3q
i3s4tab
i3s4tan
i5s4taue
i5s4taué
i5s4tave
i5s4tavé
is4tāb
is4tāt
is4tāu
is4tāv
i3s4táb
i4s5táe
is5the
is5thé
i2sti
i3stil
i2stī
i2stí
i3s4tíl
i3stír
is3to
i5strin
2isu
i4sue
is3uis
is3uís
2isú
2isv
2it.
itas3t
ita6ste
4itatem
4itates
4itatém
4itatés
4iter.
ite3ra
ite5re
ite3ri
iteri5ue
iteri5v
4itern
ite3rō
4iterq
4iteru
ite5run
4iterv
i3tē.
i3tēn
i3tēq
i3tēu
i3tēv
i3téq
4itérn
4itérq
4itéru
4itérv
i3téu
i3tév
2ith
i4tial
i4tiál
2itn
4itōt
4i5tṓt
2itq
i3tr
it4ri
2itt
2itud
i4t3ue.
2itūd
2itúd
2itv
2iu.
2i1ua
2i1uā
2i1uá
2i1uæ
2i1uǣ
2i1uǽ
1iub2
1iuc
1iud
2iud.
iu2d3u
i1ue
i3ue.
i4uerō
2i1uē
i1ué
1iug
i1ui
2iuia
3i2uiā
3i2uiá
3i2uiæ
3i2uiǣ
3i2uiǽ
iuid4
iui3g4
2iuii
2iuiī
2iuií
2iuio
2iuiō
2iuió
i5uis.
i5uisn
i5uisq
i5uisu
4iuium
4iuius
2iuiú
2i1uī
i1uí
2i3uía
iuí3g4
i3uísn
i3uísq
i3uísu
3iulī
3iulu
i2um
iu3ma
i3und
3iung
3iunx
2iuo
2i1uō
2i1uó
1iur
iu2s3
i4us.
3iusd
i4usn
3iusp
i4usq
i4usu
i4usv
3iuua
3iuue
2i3uum
3iuuo
2i3uus
2i1uú
1iuv
1iu2x3
1iū
iūn4e
iūn4ĕ
i2ūr
iū3rē
iū2s
iū2x3
1i2ŭ
iŭ2s
iŭ́3b
i2ú
iúb2
1iúd
iú2du
1iúg
iú3lu
2iúm
i3únd
3iúng
3iúnx
1iúr
iú2s3
1iú2x
2iva
2ivá
2ivæ
2ivǽ
i3ve.
2ivia
3i2viā
3i2viá
3i2viæ
3i2viǣ
3i2viǽ
ivi3g4
2ivii
2iviī
2ivií
2ivio
2iviō
2ivió
i5vis.
i5visn
i5visq
i5visv
2iviu
2iviú
2ivī
2i3vía
iví3g4
i3vísn
i3vísq
i3vísv
2ivo
2ivó
2ivu
2ivú
2ix2
ix4eu
ixo3r
ixu3
i2x3ue
ix4us
2iz
ī2a
īa2m
īa2t
ī2ā
īā2tr
īā́4tr
ī2ă
ī2á2
ī2æ
ī2ǣ
ī2ǽ
īb2
ība2
ī3bas
ī3băs
ībá2
ī3bás
ībe3rō
ībĕ3rŭ
ībī3u
ībī3v
ībo2
2īc
īca2r
ī5cene
ī4c3enn
ī3cē
ī5cĕnĕ
ī4c3ĕnn
īc3énn
ī3ci
ī3cī
ī3cĭ
ī3cí
ī2c3ue
ī2c3u2t
ī2c3ŭt
ī3cú
2īd2
īda2r
īde2s
īdē2s
ī3do
īd4or
ī3du
īdū2
ī2e
īe2t
ī2ē
ī2ĕ
īé2
īg2
ī3ga2
īgá2
ī3gæ3
ī3gǣ
ī3gn
īg4ne
īg4nu
īgo2
2ī1h
ī3ha
ī3hă
ī1i
ī2ī
2īl
īle2i
īle2r
īlé2
īlo2
ī1m
īm2a
īm2e
īm2i
īm2ĭ
īmo3
ī1n
īn2ā
īne2r
īn2ĕ
īné2
1īnf
īno2
1īn1s2
īn2u
ī2n3ue
īn2ŭ
2īo
īo3n
īo4nn
īo4nq
īo4nv
2ī2ō
2īŏ
2īó
2ī2p
ī3pa
ī3pā
ī3pă
ī3pá
ī3pæ
ī3pǣ
ī3pǽ
ī3pe3
īper2
ī3pē
ī3pĕ
īpĕ3r4
īpĕ́3
ī3pé
ī3ph
ī3pi
ī3pī
ī3pĭ
ī3pō
ī3pu
ī3pū
ī3pŭ
ī3pú
ī1r
īr2a
īra3g
īra2r
īrās3
ī3r2ă
īræ2ă
īrǣ2ă
ī3rēu
ī3rēv
īro2
īró2
īsa2r
īsá2
īs3cæ
īs3cǣ
īs3cī
2īs2e
2ī3s2ĕ
īs2i
2īsī
1ī2so
2īsō
1ī2sŏ
1īsó
ī2sq
īs4tíl
īs3tr
ī2sue
ī2suĕ
2īsŭ
2īsú
īta2r
īta6ste
ītăs5t
ītă6stĕ
īte5re
2ītē
ītĕ3rĕ
ī1u2
2īua
2īuā
2īuă
2īuá
2īuæ
2īuǣ
2īuǽ
īuid4
īui3g4
īuĭ3g2
īuĭ́3g4
īuí3g4
ī2um
ī2un
īuo2
2īuō
2īuu
2īuŭ
2īuú
2īū
ī2ŭ
ī2ú
2īva
2īvā
2īvă
2īvá
2īvæ
2īvǣ
2īvǽ
īvi3g4
īvĭ3g2
īvĭ́3g4
īví3g4
2īvō
2īvu
2īvŭ
2īvú
īx2
īx4eu
īxo4r
ī2x3ue
īx4us
īxū3r
ī2́
ī́b2
2ī́c
ī́3ce
ī́3cĕ
ī́3cī
ī́3cĭ
2ī́d2
ī́3g2
ī́g4n
2ī́h
ī́5hai
ī́5hăĭ
ī́1i
ī́3lu
ī́1m2
ī́3met
ī́3mĕt
3ī́n3s2
ī́3r2ă
ī́3sĕ
ī́4s3t
ī́s5tr
2ī́ū
2ĭa
2ĭā
ĭā4trā
ĭ1ā2x
4ĭā́n
ĭ3ā́2x
2ĭă
ĭăb2
ĭă4cĕ́
ĭ2ăcŭ
ĭăd2a
ĭă2dă
ĭăd2æ
ĭăd2ǣ
ĭăd2ǽ
ĭăd2ē
ĭă3d2ĕ
ĭăd2ī
ĭămb2
ĭămbī5n
ĭămbī5u
ĭămbī5v
ĭămbī́5n
ĭămbī́5u
ĭămbī́5v
ĭăm5bŭ
ĭă2m3ĭ
ĭ3ăng
ĭă2nĭ
ĭ2ănt
ĭ1ă2p
ĭ2ăq
ĭ2ăr
ĭă3rĕ
ĭă3s4pĕ
ĭăs3t
ĭăs5tĕ
ĭăs5tr
ĭ2ăt
ĭ2ău
ĭ2ăv
ĭ2ắc
ĭắ3d
ĭ3ắl
ĭ2ắm
ĭắm3b4
ĭắ2n
ĭ3ắng
ĭ2ắr
2ĭá
2ĭæ
ĭæ2ă
ĭæ2ŭ
2ĭǣ
ĭǣ2ă
ĭǣ2ŭ
2ĭǽ
ĭbĕ3rŭ
ĭb2ī
ĭbī3u
ĭbī3v
ĭb2ĭ
ĭb2ō
ĭbŏ3l
ĭb2r
ĭ3b2ū
ĭb4ū́
ĭ3bŭm
2ĭ3ca
2ĭ3cā
2ĭ3că
2ĭ3cá
2ĭ3cæ
2ĭ3cǣ
2ĭ3cǽ
ĭ3cēn
2ĭ3cīs
ĭ3cī́s
2ĭ3cō
2ĭ3cŏ
ĭ2cu
ĭc2ū
2ĭd
ĭ3dă
ĭ3dē
ĭdē3m
ĭdē2s
ĭ3d2ĕ
ĭ3dī
ĭ3dĭ
ĭdĭ3g
ĭdĭ́3g
ĭd3ĭ́p
ĭ2d1u
ĭ3d2ŭ
ĭd4ŭĕ
2ĭ2e2
2ĭē.
2ĭēg
4ĭēnĕ
2ĭēq
ĭē2s
ĭ3ēsa
ĭ3ēsē
ĭ3ēsĕ
ĭ3ēsī
ĭēs3p
ĭēs3t
2ĭēu
2ĭēv
2ĭḗg
4ĭḗq
ĭḗ2s
ĭ3ḗsē
ĭ3ḗsĕ
ĭ3ḗsī
4ĭḗu
4ĭḗv
2ĭĕ.
2ĭ1ĕg
2ĭĕī
2ĭ2ĕm
2ĭĕō
2ĭĕq
ĭĕ3r2ĕ
ĭ3ĕrm
2ĭĕtē
2ĭĕtĕ
2ĭĕtī
2ĭĕtĭ
2ĭĕtŭ
2ĭĕu
2ĭ2ĕŭ
2ĭĕv
2ĭ3ĕ́g
ĭĕ́3rĕ
4ĭĕ́tĕ
4ĭĕ́tĭ
2ĭé
ĭfĕ6stĕ
1ĭg2a
1ĭgá
1ĭg2æ3
1ĭg2ǣ
1ĭgǽ
4ĭgĕna
4ĭgĕnā
4ĭgĕnă
4ĭgĕná
4ĭgĕnæ
4ĭgĕnǣ
4ĭgĕnǽ
4ĭgĕnē
4ĭgĕnĕn
4ĭgĕnĕq
4ĭgĕnĕu
4ĭgĕnĕv
4ĭgĕnī
4ĭgĕnō
4ĭgĕnŭ
3ĭgĕs
4ĭgĕ́nă
4ĭgĕ́nĕ
3ĭgĭă
3ĭgĭb
3ĭgĭŭ
ĭ2gn
ĭg3nāt
ĭg5nā́t
ĭg3nē
ĭg3nĭ
ĭ3gr
ĭ1h
ĭhĭ́3
ĭ1i
2ĭī
ĭ3ĭ2ă
ĭĭăm3
2ĭle
2ĭ3lē
ĭlē3i
ĭlḗ3i
2ĭ3lĕ
2ĭlé
2ĭ3lī
2ĭ3lĭ
2ĭllĕ
2ĭllī
2ĭllō
2ĭllŭ
ĭ2l1u
ĭ1m
ĭ2măd
ĭmăs3
ĭm3b2
ĭmbī3n
ĭmbī3u
ĭmbī3v
ĭmbī́5n
ĭmbī́5u
ĭmbī́5v
4ĭ5mĕtr
4ĭmĕ́tr
ĭm2ĭ
ĭmĭ2ă
3ĭ2mĭē
3ĭ2mĭĕ
3ĭ2mĭĭ
2ĭmĭn
ĭ4mĭnē
ĭ4mĭnĕ
1ĭmm
1ĭmp
ĭmpĕ5rī
ĭ2mu
2ĭmŭr
ĭn1a
2ĭ3nă
ĭn4ăn
ĭn4ăq
ĭn4ău
ĭn4ăv
ĭn1æ
ĭndĭ5st
ĭn4d3ŭĕ
ĭn4d3ŭī
ĭn4d3ŭĭ
ĭn4d5ŭ́ĕ
ĭn4dŭ́ĭ
ĭn3e
2ĭ3nĕ
ĭnĕ2d
ĭn4ĕn
ĭn4ĕu
ĭn4ĕv
ĭnĕ2x
ĭnĕ́4d
3ĭngr
1ĭ2n1i
2ĭnī
ĭ3n4ĭb
ĭn5ĭbĭ
ĭnĭ2c
ĭ3n4ĭs
ĭnĭ2t
ĭnĭ́4cĭ
ĭ3nĭ́s
1ĭnj
2ĭ3nō
ĭnŏ4p
ĭnŏ3s2
4ĭnt.
3ĭntĕ
ĭntĕ5rōn
4ĭntn
4ĭntq
4ĭntu
4ĭntv
1ĭnu
ĭn1ū2
ĭnū́4b
1ĭnŭ
1ĭnv
2ĭō
2ĭŏ
ĭŏb2
ĭŏ2bŏ
ĭŏm2
ĭ2ŏn
ĭ2ŏr
ĭŏ3rī
ĭŏ2s
ĭŏ́2b
ĭ2ŏ́n
ĭ2ŏ́r
2ĭpā
2ĭpē
2ĭpĕ
ĭpĕ3rĕ
ĭpĕ3rō
ĭpĕ3rŏ
2ĭpī.
2ĭ3pīn
2ĭpīq
2ĭpīu
2ĭpīv
4ĭ3pī́n
4ĭ3pī́q
4ĭ3pī́u
4ĭ3pī́v
2ĭ3pĭ
2ĭpl
ĭp2n
2ĭps.
2ĭpsn
2ĭpsq
2ĭp2su
2ĭpsv
2ĭpŭ
2ĭq
ĭ3qu
ĭ1r2a
ĭ1ră
ĭ1r2æ3
ĭ1r2ǣ
ĭrǣ3d
ĭr1ē
ĭ1rh
ĭ1rī
ĭ2r1ĭ2
ĭrĭ́2
ĭ1rō
ĭ1rŏ
2ĭrrh
ĭ1rŭ
ĭr4ŭn
ĭ1ry
2ĭs
ĭ2s3ā2
ĭsā́2
ĭ2s1ă
ĭs2ăd
ĭ2sc
ĭs3cī
ĭ3s4cĭs
ĭ5s6cĭ́ss
ĭ2si
ĭs1ĭ
ĭsĭ2c
ĭsĭ́4c
ĭ3spĕc
ĭs3pĕr
ĭ5spĕrg
ĭspĕrī6n
ĭspĕrī6q
ĭspĕrī6u
ĭspĕrī6v
ĭspĕrī́6n
ĭspĕrī́6q
ĭspĕrī́6u
ĭspĕrī́6v
ĭspĕ4r5ĭ
ĭ5spĕrs
ĭ3spĕx
ĭ5spĕ́c
ĭspĕ́4r5
ĭ5spĕ́rg
ĭ5spĕ́rn
ĭ5spĕ́rs
ĭ5spĕ́x
ĭs3pī
3ĭssĭs
ĭs4tāb
ĭs4tāns
ĭs4tāt
ĭs4tāu
ĭs4tāv
ĭs4tā́b
ĭ3s4tăn
ĭ3s4tĕm
ĭ5s4tĕ́m
ĭ3s4tĭm
2ĭt.
ĭ3tē.
ĭ3tēn
ĭ3tēq
ĭ3tēu
ĭ3tēv
ĭ3tōt
ĭ3tṓt
2ĭtŏ
ĭ3tr
ĭ2tu
2ĭ3tŭr
ĭ3tŭ́r
ĭ1u
ĭ3uĕ
2ĭuī
ĭ1ūs
2ĭŭ2
ĭ1ŭb
ĭ3ŭnd
ĭ3ŭ́nd
ĭ3vĕ
2ĭvī
ĭx2a
ĭx2ā
ĭx2ă
ĭx2ǣ
ĭx2ĕ
ĭx2ī
ĭx2ĭ
ĭx2ō
ĭx2ŏ
ĭ2xu
ĭx2ŭ
ĭ2́
2ĭ́ă
ĭ́b2ī
ĭ́bŏ3l
ĭ́b2r
2ĭ́d
ĭ́2d3u
ĭ́2ĕ
2ĭ́ĕt
3ĭ́gĭă
3ĭ́gĭb
3ĭ́gĭŭ
2ĭ́l
ĭ́5lĭn
ĭ́l3u
ĭ́m3b2
3ĭ́mĭĭ
ĭ́4mĭnē
ĭ́5mĭnī
3ĭ́mm
ĭ́n4d5ŭī
ĭ́n4dŭĭ
ĭ́n3ĕs
ĭ́n3ī
3ĭ́nj
ĭ́nŏ4p
3ĭ́ntĕ5
ĭ́n5ŭīs
ĭ́n5ŭōs
ĭ́n5ŭŭm
ĭ́n5ŭŭs
ĭ́ŏ1
ĭ́rĭ4m
2ĭ́s
ĭ́4spĕr
5ĭ́ssĭs
ĭ́5s4tān
ĭ́s4tĕm
2í2a
íad2
ía3g
ía1m
ía1s
íb2e
íbe3r
íb2i
íb2ī
íb2o
íbo3l
íb2r
íb2u
í3bum
2íc.
2íca
2íce.
2ícem
2íces
2ícet
2í3ci.
2í3cis
2ícl
2ícn
2íco
2ícq
2íct
í2c3u2t
2ícv
2íd
í3d2e
íd2i
íd2u
í3duu
í2e1
2íei
2íeī
2íen
2íeo
2íeō
2íeq
2íet
2íeu
2íev
2íf
ífe1
íg2a
í3gæ
4ígena
4ígenā
4ígenæ
4ígenǣ
4ígenē
4ígeni
4ígenī
4ígeno
4ígenō
4ígenu
í2giī
í2giō
í2gn
2í1h
í3ha
í1i
2íi.
í2im
2í2is
í2it
í3li
2ílle
4ílli.
4íllis
2íllī
2íllo
2íllō
2íllu
íl1u
í2lua
í2luā
í2luæ
í2luǣ
í4luis
íl4uit
í4luiu
í4luīs
í2luu
2í1m2a
2ím3b2
ím2e
2ímet
ím2i
í4minē
í5minī
1ímm
2ímn
í1mo
ímpe3
2ímq
ím2uī
2ímv
ín2a
ín3de
ín4d3i4g
índo4
ín4d3ol
ín4due
ín4d3ui
ín4d3uī
2íne
íni4cit
ín1ī
1ínj
ín3o4p
1ín1s2
ín2t
ínte3
ínte5r
2ínth
2íntn
ín3to
2íntq
2íntu
2íntv
í1nu
ín2ua
ín2uā
ín2uē
ín2ul
í3nus
2í2o1
2íp
ípe3
í3pi
í2pn
ípte3
ípu3l
í1r
ír2a
íra3g
ír3i4be
ír3i4bē
ír3i4ma
ír3i4mā
ír3i4me
ír3i4mē
ír3i4mi
ír3i4mī
ír3i4mo
ír3i4mō
1írr
ír5rue
í2rue
2ís
í2s3c
ís4cid
ís2i
í2s3i2c
í4sper
ís3pī
ís3q
ís4tans
í3s4tān
ís4tem
ís5tim
ís5tin
ís3to
ís3uis
íte1
í2tu
í3tu.
í3tui
4ítuis
4ítuīs
í3tum
2ítuo
2ítuō
í3tus
2ítut
í1u2
2íu.
í3ub
2íud
2íuia
3í2uiā
3í2uiæ
3í2uiǣ
2íuii
2íuiī
2íuio
2íuiō
2íuiu
2í2um
í2un
íuo1
2ívia
3í2viā
3í2viæ
3í2viǣ
2ívii
2íviī
2ívio
2íviō
2íviu
ívo1
2íx
íx2a
íx4eu
íx2i
íx2ī
íx2o
íx2ō
í2xue
íx4us
1j
j2a
jab2
jad2
jadæ3
ja2x3
jān2
2jāx
jăd2
já2x
jece3
je1r
jes5tā
jex2i
je2xu
jē3sū
jĕ1r
jĕ3r4ĕ
jĕs3
jé2xu
jo1
jo2a
jon2
jo2s
jón2
jub2
ju3ma
ju3ri
ju2s3
ju2x3
j2ū
jūn4e
jūn4ĕ
jū3rē
jū2s
jū2x3
j2ŭ
jŭ2s
jŭ́3b
júb2
jú2s3
jú2x
1l
l2a
la3b2
lab4a
labī3u
labī3v
lab4u
la3cr
la4c3ue
la3cū
lad2
lae4s5t
la3g
la2i
la3s4pe
la3spé
las3t
las5tr
late4i
latē2
la3tr
la5trí
la͞e4st
la͡e4st
l2ā
lā3cr
lā3g
lā2ia
lā2ic
lā4iīs.
lā6iīsne
lā6iīsque
lā6iīsue
lā6iīsve
lā6iī́sne
lā6iī́sque
lā6iī́sue
lā6iī́sve
lā2iu
lā2iú
lā2ĭ
lā́3cr
l2ă
lă3b2
lăbī3u
lăbī3v
lă3cū
lăs3t
lăs5tă
lăs5tr
lă5trĭ
l2á
láb2
lá4c3ue
láe2c3
láes5t
lá3g
lá2i
læ2a
læ2ă
læ2á
læ3d
læ2i
læ3q
læ2st
læ3ue
læ3uĕ
læ2ŭ
læ3v
lǣ2a
lǣ2ă
lǣ3d
lǣ3q
lǣ2st
lǣ3ue
lǣ3uĕ
lǣ2ŭ
lǣ3v
lǽ2c1
lǽ2st
2lb2
l3bi
lbī3u
lbī3v
l3bu
l3bŭ
2lc
lce1
2ld
lda1
lde3
l2e
le3br
le3bu
le2e
le3go
le3gō
le2iá
le2ii
le2ií
le2io
le2ió
le2iu
le2iú
le3l
lelu3
le1r
ler2æ3
lere3ā
ler4i
le3rī
2l3ers
2l3ert
les3c
le2s3p
les3t
le2un
le2ur
leu5rá
leu5re
leu5ré
lex2
le3x4e
le3xi
lexu3r
lexū3r
l2ē
lē3bu
lē3bŭ
lē2iá
lē2ie
lē2iō
lē2iu
lē2iú
lē3ne
lē3nĕ
lē2sp
lēs3t
3lēx
l2ĕ
lĕ2ă
lĕ3gō
lĕ2ĭ
2lĕp
lĕ3r4ĕ
lĕrĕ3ā
lĕ3rī
lĕ3rŏ
2l3ĕrs
2l3ĕrt
lĕ3rŭ
lĕs3
lĕx2
lĕxū3r
l3ĕ́rs
l3ĕ́rt
lĕ́s3
lé3br
3lég
lé3iō
2l3érs
2l3ért
lés3t
lé3uō
léx2ī
2lf
2lg2
l3ga
l3gæ3
l3gǣ
l2i
li2a
3libe
li3g4ni
li2i
3liī
lin2ā
lino3s
li3q
li4s3c
lis5ci
li4st
lis5ta
lis5tā
li3u2b
4liud
2lix
lī3q
lī2xu
lī́3q
l2ĭ
lĭ4ắ
3lĭbĕ
lĭ4ēn
3lĭĕ
3lĭī
3lĭm
3lĭn
lĭn2a
lĭn2ā
lĭn2æ
lĭn2ĕ
lĭnĭ5tĕ
lĭnĭ5tō
lĭs3
lĭ4st
lĭs5tā
lĭs5tă
2lĭŭd
lí4c3ue
lí3q
lí3tur
2lj
2ll2
lle2i
lle2x
llē2i
lli4c3u
llu2d3
llū2
l3lŭ
llú2
2l1m2
2l1n2
l2o
lo2a3
lo2ā
lo2á
lo3b2
lo4bn
lo4cue
lo2e
logæ3
longǣ4u
longǣ4v
lo3ni
lo5ni5c
lo5níc
lo4rn
lo4rq
lo4rv
lo2sp
los3t
lo2x3
lō3d2
lōe2
lō3r
lṓr2
lṓ4s5t
l2ŏ
lŏ2ā
lŏb2
lŏngǣ4u
lŏngǣ4v
lŏ2s
ló2x
2lp
lpe3r2
lpĕ3rĕ
l3pi
l3pĭ
lpo4s3
2lq
2l1s2
l2s3t
2lt
lte1
lter4a
lte5re
lte5ré
lteri5ue
lteri5v
lte5rī
lterī5ue
lterī5v
ltĕ3r4a
ltĕ3rǣ
ltĕ5rī
ltĕrī5u
ltĕrī5v
ltéri5t
l1uā
l1uă
l1uǣ
l2u3b2
lu3do
l3uea
l3ueā
l3ueá
l3uee
l3uei
l3ueī
l3ueí
l3ueo
l3ueō
l3ueó
2lues
lue6ste
l3ueú
2l3uĕ
luĕ6stĕ
l3uée
2l3uia
2l3uiā
2l3uiá
2l3uiæ
2l3uiǣ
2l3uiǽ
2l3uic
2luif
2l3uii
2l3uiī
2l3uií
2l3uio
2l3uiō
2l3uió
l3uium
l3uius
2l3uiú
l1uĭ
2l3uía
2luíc
2luíf
l3uína
l5uínen
l5uíneq
l5uíneu
l2um
lumi3
3l2un
l1uō
lu1r
luru3
lusa4t
lu2s3ā2
lu2tī
lu3xo
lū3d
lūru3
lŭ3b2
2lŭc
2l1ŭ2t
lŭ́4s
lŭ́s5t
lŭ́3u
lŭ́3v
lúb2
lú3ia
lú1r
2lv2
lve6ste
lvĕ6stĕ
2l2x2
lx3u
lý2c
2lz
1ma.
1mab2
m1ad
ma2du
3m2ae
ma2ga
ma2gā
ma2gá
ma2ge
ma2gé
ma2gī
ma4g3n
ma2gō
ma2gu
ma2gú
ma1i
ma4ia.
ma4iae
ma4iam
ma4ian
ma4iaq
ma4iar
ma4ias
ma4iau
ma4iav
ma4ia͞
ma4ia͡
ma4iā.
ma4iān
ma4iāq
ma4iār
ma4iās
ma4iāu
ma4iāv
ma4iā́n
ma4iā́q
ma4iā́r
ma4iā́s
ma4iā́u
ma4iā́v
ma4iáe
ma4iám
ma4ián
ma4iár
ma4iás
ma4iáu
ma4iáv
ma2iæ
ma2iǣ
ma2iǽ
ma4iis
ma4iīs
ma4iī́s
ma4iís
ma3io
ma3ió
ma2iq
ma4iue
ma3iú
ma2iv
1mal
mali3g4
malí3g4
mal4ui
ma4l3uī
m1am
mam4b3i4
mambī4
mambī́4
mam4b3í4
m2ami
1man
ma3ni.
ma3nin
ma3niq
ma3nis
ma3niu
ma3niv
ma3nín
ma3níq
ma3nís
ma3níu
ma3nív
man3s
man5s4i
mansi5u
mansi5v
man5s4í
1m2a3q
ma2rā
m2aru
3masi
3masí
mas2p
mas3t
1mat
ma3tr
1m2au
1mav
3m2a͞
3m2a͡
1m2ā
m3āc
mān3sa
mān3să
mān5s4i
mān3s4ī
mānsī5n
mānsī5q
mānsī5u
mānsī5v
mān5s4ĭ
2m3ā2x
m3ā́c
mā́n5s6i
mā́n5s6ĭ
2m3ā́2x
1mă.
m1ăd
mă2gā
mă2gă
mă2gī
mă2gō
mă2gŏ
mă2gŭ
mămbī4
mămbī́4
măm4b3ĭ
1m2ăn
3mănĕ
2m3ănĭ
mă4nĭ́
3măntē
3m2ă3q
m3ă2rā
mă4răn
mă4răt
mă4rĕr
mă4rĕt
m3ă2rŏ
măs2p
1m2ăt
3m2ău
3m2ăv
1m2ắ
4m3ắnĭ
1má
3m2áe
má4gn
má1i
má4iīs
má3io
má4luī
mám4b3i
m2án
mán3s4i
m2ár
2máræ
m2áu
1m2æ
mæ2a
mæ2ă
mæ2á
mæ2i
mæ2st
mæ2ŭ
1m2ǣ
mǣ2a
mǣ2ă
mǣ2st
mǣ2ŭ
1m2ǽ
2mb
m2b3ag
mb2al
m4baru
m4barv
m2bă
m3bắr
mb2ác
mbæ3
m3be.
m3bea
m3beá
m2be4d
m3ben
m3beo
m3beó
m3b2eq
mb3es
m3beu
m3beú
m3bev
m2b3ēs
m2bĕd
m3bĕn
mb3ĕ́4d
m2bé2d
m2bés
m4b3iam
m4b5iant
m4b3iar
m4b3ias
m4b5iat.
m6b5iatis
m6b5iatís
m4b5iatn
m4b5iatq
m4b5iatu
m4b5iatú
m4b5iatv
m4b3iām
m4b3iār
m4b3iās
m4b5iāti
m4b5iātí
m4b5iātu
m4b5iātú
mb3iā́
m4biā́m
m4biā́r
m4biā́s
m4biā́t
m2b3iá
mb2i3c
m2bie
mbi3eg
m2biē
m2bié
mbi3ég
mb6igene
m2bii
m2b3iī
m2b3ií
m4b3i4mi
mbi4mur
mbi4múr
m4b3io.
m4b3ion
m4b3ioq
m4b5ior.
m4b5iorn
m4b5iorq
m4b5ioru
m4b5iorv
m4b3iou
m4b3iov
m2b3iō
m2b3ió
m4b3iss
m4b3ist
m4b3i4ta
m4b3i4tá
m4b3i4tæ
m4b3i4tǽ
m4b3iti
mbi4ti.
mbi4tib
mbi4tin
mbi4tió
mbi4tiq
mbi4tiu
mbi4tiv
mbi4tín
mbi4tíq
mbi4tíu
mbi4tív
mb3ito
mbi4tor
mbi4tos
mbi4tór
mbi4tós
m4b5i4tu.
m4b5i4tum
m4b5i4tun
m4b5i4tuq
m4b5i4tur
m4b5i4tus
m4b5i4tuu
m4b5i4tuv
m4b3i4tū
mb3i4tú
m2b3iú
m4bive
m2bī2
mbī́2
mbī́4t
m4b3ĭām
m4b3ĭār
m4b3ĭās
m4b5ĭātĭ
m4b5ĭātŭ
mb3ĭā́
m4bĭā́m
m4bĭā́r
m4bĭā́s
m4bĭā́t
m2b3ĭă
mb2ĭ3c
m2bĭē
m2bĭĕ
mb6ĭgĕnĕ
m2b3ĭī
m2bĭĭ
m2b3ĭō
m4b5ĭŏr.
m4b5ĭŏrn
m4b5ĭŏrq
m4b5ĭŏru
m4b5ĭŏrv
m4b3ĭŏ́
m4b3ĭtĭ
m4b3ĭ4tū
m4b5ĭ4tŭm
m4b5ĭ4tŭs
mbĭ6tŭ́m
mbĭ6tŭ́s
m2b3ĭŭ
m4b3ĭ́ĕ
m4b3ĭ́ĭ
m4b5ĭ́4tĭ
mb1í
mb2í3c
m2bíe
mb4ígen
m2bíi
m4bí4mi
m4b3íss
m4b3íst
mbí2t
mbí4tu.
mb4ítui
mb4ítuī
mbí4tum
mbí4tus
mb2l
mb2o
mbo3r
mb2ō
m3b2r
m3bu
m5bus.
m5busn
m5busq
m5busu
m5busv
m2b3ūs
m3bŭ
2mc2
2md2
mde3d
mde2s
mdē2s
mdĕ3d
m3do
md4or
1me
mea3p2
meá3p2
m2eb
med2
me4dam
me4dan
me4dat
2me2dā
me4dám
me4dán
me4dár
me4dát
me4deb
me4den
me4der
me4det
2me2dē
me4déb
me4dén
me4dér
me4dét
med4i
me4dim
2me2dī
me4dím
me4dít
med4o
me4dor
me4dō.
me4dōq
me4dōu
me4dōv
me4dór
me4due
me4dún
me2e
mee3ri
mee3rí
m1eg
me2ge
me2gé
me2gi
me3go
me3iá
me3ie
me3io
me3ió
me2it
me3iú
me3íp
m2em
m2en
3mena
3mená
men2e
me3neu
3mené
3meni
3mení
me3p2
m1eq
m2er
me3ra
me3rē
me3ri
4merim
me3rī
2m3erm
me3ro
me3rō
me3r2u
2m3eso
me4so.
me4son
me4soq
me4sor
me4sou
me4sov
2m3e2só
me2sp
2m3ess
5messat
5messát
mes3t
me2su
m4esue
4m3esum
4m3esus
2m3e2sú
3mete
mete3r
meteri5ue
meteri5v
3meté
2mets
me2un
m2ev
m2e2x
1mē
mē4der
mē4dēr
mē4dĕr
mē4dér
mē4dim
mē4dit
mē4dĭm
mē4dĭt
mē4dít
mē2du
m1ēg
mē2ge
mē2gē
mē2gĕ
mē2gé
mē2gi
mē2gĭ
mē2gí
mē3i
m2ēl
m2ēm
m2ēn
mē3ne
mē3p2
3mēq
m2ēr
2m3ē4sa
2mē2sā
2mē2să
2mē2sá
2mēsæ
2mēsǣ
2mēsǽ
2mēsō
mēs3t
mē2su
4mēsum
4mēsus
2mē2sŭ
2mēsú
3m2ēu
3m2ēv
mḗ4der
mḗ4dĕr
mḗ4dim
mḗ4dit
mḗ4dĭm
mḗ4dĭt
mḗ4gi
mḗ4gĭ
mḗ3i
mḗ3p2
4mḗsa
4mḗsā
4mḗsă
4mḗsæ
4mḗsǣ
4mḗsō
4mḗsum
4mḗsus
4mḗ4sŭ
m2ḗu
m2ḗv
1mĕ
mĕ2ă
m1ĕd2
2mĕ2dā
2mĕ4dă
2mĕ2dē
2mĕ2dĕ
2mĕ2dī
2mĕd4ĭ
mĕ4dĭs
mĕ4dō.
m2ĕdŏ
mĕ4dŏr
2mĕ2dŭ
mĕ2ĕ
2mĕg
mĕ2ĭ
mĕ3ĭp
m2ĕm
m2ĕr
4mĕrăm
mĕ3rē
mĕ3r4ĕ
mĕ3rī
4mĕrĭm
4mĕrĭn
2m3ĕrm
3mĕ3rŏ
mĕ3rŭ
mĕ2sp
m2ĕt
mĕ2t3ĭ
2mĕts
m2ĕ́
m3ĕ́2d
5mĕ́ntĕr
5mĕ́ntĭŏ
5mĕ́ntĭŭs
m3ĕ́2q
mĕ́r6ĕă
4m3ĕ́rm
5mĕ́tr
4mĕ́ts
1mé
mé4der
mé4dim
mé4dit
mé2du
mé3i
mé4is
m2ém
5ménter
5méntio
5méntius
mé3p2
m2ér
mér4e
4mérim
2m3érm
mér4ui
mér4uī
4mérun
2mésæ
2méso
2m3éss
4méste
4méstn
4mésto
4méstq
4méstu
4méstv
mé2su
4mésu.
m4ésue
4mésum
4mésus
2méts
3méu
3mév
mé2x
2mf
mge6ste
mgĕ6stĕ
2m1h
1mi
m2ia.
mi3ad
m2iae
mi3a2g
mi3al
m2iam
miam4b3
mia2p
m2ias
mi3ass
mi3atr
m2ia͞
m2ia͡
m2iā
mi3ātr
mi3ā́x
mi3áss
m2iæ
m2iǣ
mi2be
mi2bé
m3ict
m2id
3mie.
3mieq
3mieu
3miev
m2ig
m2iīs
m2il
mi3n4a
min2ā
min4e
min2i
mini3m
min4in
min4iq
min4is
min4iu
min4iv
mi3n4ī
miní4ci
min4ín
min4íq
min4ís
min4íu
min4ív
m2i3n4u
minu3d
min2ū
minū3d
mi3nú
m2io
mio2s
m2iō
m2ió
m2is
mi3sa
mi3sá
mi4s5ci
mi3scr
mis2i
mi4sn
mi3s2p
mi4sq
mi4s5ta
mis5tā
mis5te
mi4sv
m6itate.
5mitatem
m6itatene
m6itateq
5mitates
m6itateu
m6itatev
5mitatém
5mitatés
m4itati
m4itatí
m6itatum
m6itatúm
m4itáte
5mitátem
5mitátes
m4itáti
m6itátum
mi2tū
mi4um
2miur
m2i1ū
m2iú
mi3úst
1mī
2mīc
m2īn
mī3nĕ
m2ī3q
m2īs.
mī2sc
m2īsn
mī3so
mī3sŏ
m2īsq
m2īsu
m2īsv
mī3ue.
mī3uĕ.
mī3ve.
mī3vĕ.
mī́4ba
mī́4bā
mī́4bă
mī́4be
mī́4bĕ
mī́4bo
mī́4bō
mī́4bŏ
mī́4bu
mī́4bŭ
2mī́c
m2ī́n
m2ī́q
1mĭ
3mĭa
3mĭā
mĭ3ātr
mĭ1ă
3mĭă.
mĭă2g
3mĭăm
2mĭăr
3mĭá
3mĭæ
3mĭǣ
3mĭǽ
3m2ĭb
mĭ4cĭt
2mĭcŏ
3mĭĕ.
mĭ4ĕn
3mĭ4ĕq
3mĭ4ĕu
3mĭ4ĕv
3mĭīs
3m2ĭl
mĭn2ā
mĭn4ĕ
4mĭnĕŏ
mĭ3n4ī
mĭn2ū
mĭnū3d
mĭnū3t
3m2ĭ3n4ŭ
3mĭō
mĭ3r
mĭ3s4ă
mĭ3scr
mĭ3s2p
mĭs5tā
mĭ4s5tă
mĭs5tĕ
m3ĭ2tū
mĭ1ū
3mĭŭ
3mĭ́ă
mĭ́4cĭ
mĭ́3d
mĭ4́n
mĭ́3sp
mĭ4́t
1mí
mí2ba
mí2be
mí2bu
m3íct
mí1m
mí3n4u
mí3s2p
mí4tiō
mí4tiu
mí3tuu
2ml2
m3lu
2m1m2
mmi6sta
2m1n2
m3ne
m3nē
m3né
1mo.
2mob
mob3r
1moc
modes3
m2oe
mo2ī
1mol
1m2on
mo3ni
monó3
mon4s3
mo3n2u
1moq
1m2or
mo3rī
3m2os
1mou
1mov
1mox
m2o͡
1mō
m2ōn
mōn4s3
2mōrd
m2ōs
mōs3t
mṓn4s
4mṓrd
1mŏ
3mŏ.
mŏ2c
mŏ2ī
3mŏn
3mŏq
m2ŏr
mŏ3rĕ
mŏ3rī
3mŏs
mŏs2p
3mŏu
3mŏv
mŏ́b3
m2ŏ́r
mŏ́3rĭ
1mó
2m1ób
mó2c
m2óe
món4s3
m2ór
3m2ós
m2œ
2mp
mpe4ior
mpe4iór
mpe4iu
mpe4iú
mpe3r4a
mper4ā
mpe5rem
mpe5r4er
mpere5ra
mpere5ri
mpere5rō
mpe5res
mper4ē
mperi4b
mpe6riens
mper6iere
mper6ieris
mper6ierís
mper6iēn
mper6iēre
mper6iḗn
mper6iḗre
mper6iére
mper4im
mpe5rimi
mpe5rimur
mperi6mus
mpe5rimúr
mperi6mús
mper4ir
mperi6re.
mperi6rem.
mpe5riremi
mperi6remn
mperi6remq
mperi6remue
mpe5riremur
mperi6remus
mpe5riremúr
mperi6remús
mperi6remv
mperi6rene
mperi6rent.
mperi6rentn
mperi6rentq
mperi6rentue
mpe5rirentur
mpe5rirentú
mperi6rentv
mperi6req
mpe5rirer
mperi6res
mperi6ret
mperi6reu
mperi6rev
mpe5rirémi
mperi6rémn
mperi6rémq
mperi6rémue
mpe5rirémur
mperi6rémus
mperi6rémv
mperi6réntn
mperi6réntq
mperi6réntue
mpe5riréntur
mperi6réntv
mpe5rirér
mperi6rés
mperi6rét
mpe5riri
mpe5rirí
mpe6risse
mpe6rissé
mpe6risti
mpe6ristí
mper4it
mperi6te
mperi6ti
mperi6tí
mperi6to.
mperi6ton
mperi6toq
mpe5ritor
mperi6tot
mperi6tou
mperi6tov
mperi6tón
mperi6tóq
mpe5ritór
mperi6tót
mperi6tóu
mperi6tóv
mperi6tu
mperi6tú
mpe5riú
mpe6rī6mus
mpe6rī6mús
mper4īr
mpe6rī6re.
mpe6rī6rem
mpe6rī6rene
mpe6rī6rent.
mpe6rī6rentn
mpe6rī6rentq
mpe6rī6rentue
mpe6rī6rentv
mpe6rī6req
mpe6rī6ret
mpe6rī6reu
mpe6rī6rev
mpe6rī6rēmus
mpe6rī6rēmús
mpe6rī6rēs
mpe6rī6rēt
mpe6rī6rḗmus
mpe6rī6rḗs
mpe6rī6rḗt
mpe6rī6rém
mpe6rī6réntn
mpe6rī6réntq
mpe6rī6réntue
mpe6rī6réntv
mpe6rī6rét
mpe4rīs
mpe6rī6te
mpe6rī6ti
mpe6rī6tí
mpe6rī6tō
mpe6rī6tu
mpe6rī6tú
mpe6rī́6mus
mper6ī́r
mpe6rī́6re.
mpe6rī́6rem
mpe6rī́6ren
mpe6rī́6req
mpe6rī́6ret
mpe6rī́6reu
mpe6rī́6rev
mpe6rī́6rē
mpe6rī́s
mper6ī́sn
mper6ī́sq
mper6ī́su
mper6ī́sv
mpe6rī́6te
mpe6rī́6ti
mpe6rī́6tō
mpe6rī́6tu
mper6ī́u
mper6ī́v
mpe4ríe
mper4ím
mpe6rí6mus
mper4ír
mpe6rí6re.
mpe6rí6rem
mpe6rí6ren
mpe6rí6req
mpe6rí6res
mpe6rí6ret
mpe6rí6reu
mpe6rí6rev
mpe6rísse
mpe6rísti
mpe4rít
mperí6te
mperí6ti
mperí6to.
mpe5rítor
mper4íu
mper4ív
mpe3r4o
mpe3rō
mper4ó
mpe6ste
mpē4iē
mpĕ4rĕā
mpĕ4rĕă
mpĕ4r5ĕō
mpĕ6rī6mŭs
mpĕ6rī6mŭ́s
mpĕ6rī6rēmŭs
mpĕ6rī6rēmŭ́s
mpĕ6rī6rēs
mpĕ6rī6rēt
mpĕ6rī6rḗmŭs
mpĕ6rī6rḗs
mpĕ6rī6rḗt
mpĕ6rī6rĕ.
mpĕ6rī6rĕm
mpĕ6rī6rĕnĕ
mpĕ6rī6rĕnt.
mpĕ6rī6rĕntn
mpĕ6rī6rĕntq
mpĕ6rī6rĕntu
mpĕ6rī6rĕntv
mpĕ6rī6rĕq
mpĕ6rī6rĕt
mpĕ6rī6rĕu
mpĕ6rī6rĕv
mpĕ6rī6rĕ́m
mpĕ6rī6rĕ́ntn
mpĕ6rī6rĕ́ntq
mpĕ6rī6rĕ́ntu
mpĕ6rī6rĕ́ntv
mpĕ6rī6rĕ́t
mpĕ4r5īs
mpĕr6īs.
mpĕr6īsn
mpĕr6īsq
mpĕr6īsu
mpĕr6īsv
mpĕ6rī6tĕ
mpĕ6rī6tĭ
mpĕ6rī6tō
mpĕ6rī6tŭ
mpĕ6rī́6mŭs
mpĕ6rī́6rē
mpĕ6rī́6rĕ.
mpĕ6rī́6rĕm
mpĕ6rī́6rĕn
mpĕ6rī́6rĕq
mpĕ6rī́6rĕt
mpĕ6rī́6rĕu
mpĕ6rī́6rĕv
mpĕ6rī́s
mpĕr5ī́ss
mpĕr5ī́st
mpĕ6rī́6tĕ
mpĕ6rī́6tĭ
mpĕ6rī́6tō
mpĕ6rī́6tŭ
mpĕ6rĭēn
mpĕ6rĭērĕ
mpĕ6r5ĭērŭ
mpĕ6rĭḗn
mpĕ6rĭḗrĕ
mpĕ6r5ĭḗrŭ
mpĕ6r5ĭĕr
mpĕ6r5ĭĕ́r
mpĕ6rĭtn
mpĕ6rĭtq
mpĕ6rĭtu
mpĕ6rĭtv
mpĕ6r5ĭ́ĕ
mpĕ6rĭ́t
mpĕ3rō
mpĕ3rŏ
mpĕ6stĕ
mpĕ́6r5ĕā
mpĕ́6r5ĕă
mpĕ́6r5ĕō
mpĕ́6rĭēn
m3pé
mpé4r5ea
mpé4r5eā
mpé4r5eo
mpé4r5eō
mpére5r
mpé4ri.
mpé6riens
mpé6riēn
mpé4rit
m2pn
mp2ne
mp2su
2mq
m3qu
m1r
mro3
mrod4
mro5di
mrodi5u
mrodi5v
mrō3d4
mrō5dī
mrōdī5u
mrōdī5v
2m1s2
msed4
mse5di
msēd4
msē5di
msē5dĭ
mso3
m2s3q
m3st
m2s3u
2mt
mte3r4
mte5re
mter6it
mteri5tur
mteri5u
mteri5v
mte5rī
mterī5u
mterī5v
mtĕ3r4
mtĕ5rĕ
mtĕrĕ5r
mtĕ5rī
mtĕrī5u
mtĕrī5v
mto1
mto2s
m1ua
m1uā
m1uă
m1uá
2m1ue
4m3ue.
m1uē
m1uĕ
m1ué
m1ui
m2ui.
2mui2c3
m2uim
m2uin
m2uiq
2muir
m2uit
m2uiu
m1uī2
m2uī.
muīc3
m2uīn
m2uīq
m2uīu
m1uĭ
2m3uír
1m2ul
3m2um
2m3unc
muol3u
m1uó
1m2ur
1mus
2m3ust
1mū
m3ūnc
2m1ūs
mū2su
1mŭ
m2ŭl
3m2ŭm
m2ŭs
m2ŭ́
3mŭ́m
1mú
3m2úm
2m3únc
m2ús
2m3úst
2mv2
m3ve
mvi2c3
mvī2
mvīc3
m2x2
1m2y
my2s
1mý
2mz
1na
nab2o
na2br
na2cr
n1ad
n2ada
nae2s
n2aeu
n2aev
na3ge
na3gr
na2i
nai4m
na2ī
3nal
na2ni
n3a2ní
na2o
na3q
n2ar
nas7cend
n4aue
na2x3
n2á͞
n2á͡
1nā
nā5bun
3nāc
nā2i
nā2ĭ
n1ā2n
nās3
nā́4ni
nā́4nĭ
1nă
n1ăb
nă2br
n1ăd
n2ădă
n2ăg
nă3gĕ
nă3gr
nă2ī
nă2nĭ
n2ăp
nă3q
năs2p
2năth
nắ2n
1ná
n2áb
ná2i
3nál
ná2ni
n2ár
ná2x
1næ
næ2a
næ2ă
næ2á
næ2i
n2æu
næ2ua
næ2uā
næ2uă
næ2uá
næ2uæ
næ2uǽ
næ4uen
næ4ueq
næ4ueu
næ2uē
næ4uĕn
næ4uĕq
næ4uĕu
næ2ué
næ2ui
næ2uī
næ2uí
næ2uo
næ2uō
næ2uó
næ4uum
næ4uus
næ4uŭm
næ4uŭs
næ4uúm
næ4uús
næ2ŭ
n2æv
næ2va
næ2vā
næ2vă
næ2vá
næ2væ
næ2vǽ
næ4ven
næ4veq
næ4vev
næ2vē
næ4vĕn
næ4vĕq
næ4vĕv
næ2vé
næ2vi
næ2vī
næ2ví
næ2vo
næ2vō
næ2vó
næ4vum
næ4vus
næ4vŭm
næ4vŭs
næ4vúm
næ4vús
1nǣ
nǣ2a
nǣ2ă
nǣ2ua
nǣ2uā
nǣ2uă
nǣ2uá
nǣ2uǣ
nǣ4uen
nǣ4ueq
nǣ4ueu
nǣ2uē
nǣ4uĕn
nǣ4uĕq
nǣ4uĕu
nǣ2uī
nǣ2uō
nǣ4uum
nǣ4uus
nǣ4uŭm
nǣ4uŭs
nǣ4uúm
nǣ4uús
nǣ2ŭ
nǣ2va
nǣ2vā
nǣ2vă
nǣ2vá
nǣ2vǣ
nǣ4ven
nǣ4veq
nǣ4vev
nǣ2vē
nǣ4vĕn
nǣ4vĕq
nǣ4vĕv
nǣ2vī
nǣ2vō
nǣ4vum
nǣ4vus
nǣ4vŭm
nǣ4vŭs
nǣ4vúm
nǣ4vús
nǣ́4ua
nǣ́4uā
nǣ́4uă
nǣ́4uǣ
nǣ́4uen
nǣ́4ueq
nǣ́4ueu
nǣ́4uē
nǣ́4uĕn
nǣ́4uĕq
nǣ́4uĕu
nǣ́4uī
nǣ́4uō
nǣ́4uum
nǣ́4uus
nǣ́4uŭm
nǣ́4uŭs
nǣ́4va
nǣ́4vā
nǣ́4vă
nǣ́4vǣ
nǣ́4ven
nǣ́4veq
nǣ́4vev
nǣ́4vē
nǣ́4vĕn
nǣ́4vĕq
nǣ́4vĕv
nǣ́4vī
nǣ́4vō
nǣ́4vum
nǣ́4vus
nǣ́4vŭm
nǣ́4vŭs
1nǽ
nǽ2ua
nǽ2uā
nǽ2uă
nǽ2uæ
nǽ4uen
nǽ4ueq
nǽ4ueu
nǽ2uē
nǽ4uĕn
nǽ4uĕq
nǽ4uĕu
nǽ2ui
nǽ2uī
nǽ2uo
nǽ2uō
nǽ4uum
nǽ4uus
nǽ4uŭm
nǽ4uŭs
nǽ2va
nǽ2vā
nǽ2vă
nǽ2væ
nǽ4ven
nǽ4veq
nǽ4vev
nǽ2vē
nǽ4vĕn
nǽ4vĕq
nǽ4vĕv
nǽ2vi
nǽ2vī
nǽ2vo
nǽ2vō
nǽ4vum
nǽ4vus
nǽ4vŭm
nǽ4vŭs
2nc
n3cr
n2c3ue
n2c1ū
2nd
n2d3ág
nd2e
nde4sc
nde3un
nde3ún
ndē4sc
ndĕ3ŭn
ndi4ger
n4d3igi
n4d3igí
ndi4g3n
ndi3m
n2di2p
n4d3ĭgĭ
nd2ĭn
n2dĭp
ndĭ4sp
n4d5ĭ́gĭ
n4d3í4gi
n3do
ndo3l
n4d5o4le.
ndo4lem
n6d5o6lene
n4d5o4leq
ndo6les.
ndo6lesn
ndo6lesq
ndo6lesu
ndo6lesv
n4d5o4leu
n4d5o4lev
ndo6lēs.
ndo6lēsn
ndo6lēsq
ndo6lēsu
ndo6lēsv
ndo6lḗsn
ndo6lḗsq
ndo6lḗsu
ndo6lḗsv
ndo4lém
ndo6lésn
ndo6lésq
ndo6lésu
ndo6lésv
n4d3o4li
n4d3o4lī
n4d3o4lí
nd4or
ndŏ6lēs.
ndŏ6lēsn
ndŏ6lēsq
ndŏ6lēsu
ndŏ6lēsv
ndŏ6lḗsn
ndŏ6lḗsq
ndŏ6lḗsu
ndŏ6lḗsv
n4d5ŏ4lĕ.
n6d5ŏ6lĕnĕ
n4d5ŏ4lĕq
n4d5ŏ4lĕu
n4d5ŏ4lĕv
n4d3ŏ4lī
n4d3ŏ4lĭ
n4d5ŏ́4lĕ
ndó2l
n4d3óle
ndó3lu
nd2r
n2d3ua
n2d3uā
n2d3uá
nd3ue.
nd3ueq
nd3ueu
nd3uev
n2duē
n2dué
nd3uit
n2d3uo
n2d3uō
n2d3uó
n2d3uú
n2d3ŭā
n2d3ŭă
n2dŭē
nd3ŭĕ.
nd3ŭĕq
nd3ŭĕu
nd3ŭĕv
nd3ŭĭt
n2d3ŭō
n2d3ŭŏ
n2d3ŭŭ
nd3ŭ́ĭ
nd3úen
nd3úeq
nd3úeu
nd3úev
n2d3úi
1ne
3ne.
ne2a
ne3bu
ne2cl
ne2co
ne4c3u4t
ned2
ned4i
ne2e
nee3ri
nee3rí
n1ef
ne2gl
3nei
ne2ia
ne2iá
ne2ie
ne2ié
ne2ii
ne2ií
ne2io
ne2ió
ne2it
ne2iu
ne2iú
3neí
ne2lu
ne2na
n4ene
ne2nu
3neo
3neó
3nep
nepo5t
ne1r
nera5b
nerab6u
ner2æ3
ner2ǣ
ne3rē
ne3rī
ne4ss
nes5tā
nes5te
nes5tr
n4et.
n4etn
n4etq
2nets
n4eue
2ne2un
ne2ur
neu5re
neu4ter
neu4tér
ne3u4tr
2neún
n4eve
n1ex
n2ex.
nex2a
ne3x2i
nexi3u
nexi3v
nex2ī
n2exn
ne2xo
ne2xō
nex2ó
n2exq
n2ex2u
nexu3r
nex2ū
nexū3r
nex2ú
n2exv
1nē
nē2br
n1ē2d
nē3du
nē2i
n1ēl
nē2lă
nē2lĕ
nē2lu
nē2me
nē2mĕ
nē2mo
nē2mŏ
nē2nā
nē2nu
nēs3t
nē2uī
nē2vī
nḗ4br
nḗ2d
1nĕ
3nĕa
nĕ2ă
3nĕæ
3nĕǣ
nĕ2cŏ
nĕd2
3nĕē
3nĕ2ĕ
n1ĕf
nĕ2gl
3nĕī
nĕ2ĭ
3nĕp
nĕ3r2a
nĕ3r2æ
nĕ3r2ǣ
nĕ3rē
nĕ3r4ĕ
nĕ3rī
nĕ3rŏ
n3ĕrs
n3ĕrŭn
nĕs3t
nĕs5tĕ
n4ĕt.
n4ĕtn
n4ĕtq
4nĕts
2n3ĕŭn
n1ĕx
n2ĕx.
nĕx2a
nĕx2ă
nĕx4ĕ́
nĕx2ī
nĕx2ĭ
n2ĕxn
nĕ2xō
n2ĕxq
n2ĕxu
nĕx2ū
nĕxū3r
nĕx2ŭ
n2ĕxv
3nĕ́p
nĕ́3rĕ
nĕ́3s4c
1né
né2i
3n1ép
né3q
2néts
néu4ter
né3u4tr
néx2ī
néx4ui
2nf
2ng
n3gae.
n3gaen
n3gaeq
n4gani
n4ganí
n5ga͞e.
n5ga͞en
n5ga͞eq
n5gá͞en
n5gá͞eq
n5ga͡e.
n5ga͡en
n5ga͡eq
n5gá͡en
n5gá͡eq
n4gă4nĭ
n4g5ắnĭ
n2gáe
n3gáen
n3gáeq
ng3áeu
ng3áev
n4g3áni
n3gæ.
n3gæn
n3gæq
n3gǣ.
n3gǣn
n3gǣq
ngǣ́2
n3gǣ́n
n3gǣ́q
n2g1ǽ2
n3gǽn
n3gǽq
ngu6ste
ngŭ6stĕ
n1h
nhe3
1ni
ni2a
n2ia.
n2ian
n2iaq
nia6ste
n2iau
n2iav
2niă
2n3i2ba
2n3i2bá
ni2be
ni2bé
2n3i2bi
2n3i2bí
2n3i2bo
2n3i2bó
4n3i4bun
4n3i4bún
nic4e
4ni4cer
n2i3cē
4ni4cér
ni4cim
4ni4cím
4ni4cít
n2i3cu
n2i3cú
3nid
2niec
2niex
2niēc
2niēx
2niéc
2niéx
n2i3g2
nig4n
n2il
ni3mam
ni3man
ni3mar
ni3mas
ni3mā
ni3má
ni3me
ni3mē
ni3mé
ni3mi.
ni3mie
ni3mii
ni3min
ni3miq
ni3mis
ni3miu
ni3miv
ni3mī.
ni3mīn
ni3mīq
ni3mīs
ni3mīu
ni3mīv
ni3mín
ni3míq
ni3mís
ni3míu
ni3mív
2nimm
ni3mo
ni3mō
ni3mó
ni3mu
ni3mú
2nins
n2i2o
n2ió
n2ip
n3i4qua
n3i4quá
n3i4quæ
n3i4quǽ
n5i4quen
n5i4queq
n5i4queu
n5i4quev
n3i4qué
n3i4qui
n3i4quí
n3i4quo
n3i4quó
n3i4quu
n3i4quú
n2is
ni4sc
nis5ci
nise4r3
nisé2
nis2i
3ni3sp
n2iue
n2iué
2niug
n2ium
2niux
2niū
2niŭ
2niúd
2niúg
2niúr
2niúx
1nī
2n1ī2b
2nīns
2n3ī́2b
4nī́ns
1nĭ
3nĭa
nĭă6stĕ
3nĭæ
3nĭǣ
n3ĭ2bĭ
nĭ3cē
4n3ĭ4cĕr
nĭ4cĭm
nĭ4cĭŏ
nĭ4cĭs
nĭ4cĭt
nĭ3cŭ
3nĭd
3nĭī
nĭ3mĭĕ
2nĭmŏ
nĭ2ŏ
nĭ3s2p
nĭ3tĕr
nĭ3tĕ́
nĭ3tĭs
nĭ5tĭ́s
nĭ3tŏ
n3ĭ4tūs
4n5ĭ́4cĕr
nĭ́4cĭm
nĭ́4cĭŏ
nĭ́4cĭt
n4ĭ́s
nĭ́3sp
nĭ́4s5t
1ní
2n1í2b
4ní4cer
ní4cian
ní4ciar
ní4ciat
ní4cim
ní5cis
ní4cit
ní4ciun
3níd
n2í3g2
níg4n
n2íl
ní1m
2nímm
2níns
4n3í4qua
4n3í4quæ
n5í4quen
n5í4queq
n5í4queu
n5í4quev
4n3í4qui
4n3í4quo
4n3í4quu
3ní3sp
ní3tur
2nj
2n1n2
n3ne
n3nu
nn4ue
1no
no2a
no2á
no2æ3
no2ǣ
noǣ́3
no2ǽ3
no2ba
nob2ī
nobī3u
nobī3v
nob2í
no2bó
3noc
noc5te
no2e
no2ē
no2i
no2ī
no2í
no3l4u
nom2
n2on
no3ni
3nop
n2ope
no2pi
no2pu
no2pú
n2or
no3rī
n2os
nos3c
no4sn
no4sq
nos3t
nos5te
no4sue
no4sv
no2xu
1n2ō
nōs3t
1nŏ
nŏ2a
nŏ2á
nŏ2æ3
nŏ2ǣ
nŏǣ́3
nŏ2ǽ3
nŏb2ă
nŏb2ī
nŏbī3u
nŏbī3v
nŏc5tĕ
nŏ2ē
nŏ2ī
nŏ2ĭ
n1ŏp
nŏ4pī.
nŏ4pĭ
nŏ2pŭ
nŏ3rī
nŏ4sn
nŏ4sq
nŏ4su
nŏ4sv
nŏ3t
nŏ2u3ĕ
nŏ2v3ĕ
nŏ́4p
1nó
nób2i
nó3l2u
nóp2
n2ór
n2ós
nó2xu
1nœ
npo3
npó1
2nq
n3qu
n1r2
n3rĕ
nr4ĕ́3
2ns
n3sa.
ns3a2c
n3s4ae
n3s4am
ns4an
n3s4aq
n3sar
n3sas
n3s4av
n3să.
ns3ăc
n3săm
n3săn
n3săq
n3său
n3săv
nsắ2
ns3ắb
ns3ắl
n2sál
n1sc
ns2ce
ns2cē
ns2cĕ
ns2cé
ns2ci
ns2cĭ
ns2cr
n2scu
n2scŭ
n2scú
n2se2g
n2seú
n2s3ég
nsér4ui
nsér4uī
n2s3i2c
n2sie
n2siē
n2sié
ns3iér
nsi2g
ns3ige
n2s3ii
n2sií
ns3iís
nsi3l4u
nsi4mur
nsi4múr
nsi2r
ns5i4ta͞
n4s3i4tǣ
nsi4ti
n4s3i4tī
ns3i4tō
n4s3i4tū
n2siu
nsi4ui
nsi4vi
nsī2r
nsī́4r
nsī́4to
nsī́4tŏ
nsī́4ui
nsī́4uĭ
nsī́4vi
nsī́4vĭ
n2s3ĭ2c
n2sĭē
ns3ĭēn
ns3ĭēr
n2s3ĭĕ
ns3ĭgĕ
n4s3ĭ4ta
ns5ĭ4tă.
ns5ĭ4tăm
ns3ĭ4tá
n4s3ĭ4tæ
n4s3ĭ4tǣ
ns3ĭ4tǽ
ns5ĭ4tĕ.
n4s3ĭ4tī
ns3ĭ4tĭ
ns3ĭ4tō
n4s3ĭ4tū
n4s3ĭ4tŭ
n4s3ĭ́4c
nsĭ́4g
nsĭ́4t
n4s5ĭ́tă
n4s5ĭ́tĕ
n4s5ĭ́tĭ
n4s5ĭ́tŭ
n2s3í2c
ns3íer
nsí2g
ns3íge
n2s3íi
nsíl4u
nsí4mi
nsí2r
ns5ítuī
ns5ítuu
nsí4uer
nsí4uim
nsí4uit
nsí4ver
nsí4vim
nsí4vit
n1sp
ns2pa
ns2pă
ns2pá
n3spec
n3spĕc
n5spĕ́c
n3spéc
n3s2pi
n3s2pĭ
n3s2pí
n2sq
n3s2ta
n3s2tā
n3s2tă
n3s2tá
n3s2te
n3s2tē
n3s2tĕ
n3s2té
n3sti5t4
n3stĭt
nstí3t4
n3s2to
n3s2tō
ns2tó
nstren6u
nstrē5n4
nstrḗ5n6
nstrén6u
ns2tu
n3s2tŭ
n4s3ue.
n3s2uī
2nt
n3ta
nta3g
n3tā
n3tæ
n3te
n4t3eā
nte4ia
nte4iá
nte3ī4
nteī́4
nte5ram.
nte5ramne
nte5ramq
nte5ramu
nte5ramú
nte5ramv
nte5rant
nteri4
nter5ib
nter5ic
nte4r5ie
nter5iē
nter5ié
nter5ii
nter5iī
nter5ií
nte4rim
nter5im.
nte5ri5min
nte5ri5mur
nte5ri5múr
nter5ita
nter5itā
nter5itá
nte5ri5tor.
nte5ri5torn
nte5ri5torq
nte5ri5torue
nte5ri5torv
nte5ri5tórn
nte5ri5tórq
nte5ri5tórue
nte5ri5tórv
nte4r3ī4
nterī́4
nte4r5í4c
nte4ríe
nte6r5í6mu
nte6r5í6ti
nte4rí4u
nte4rí4v
nte4ron
nte5rō.
nte5rṓq
nte5rṓu
nte5rṓv
nte4rós
nte5runt
nt4es
nte5stas
nte5stās
nte5stātí
nte5stā́s
nte5stás
nte5sto.
nte5ston
nte5stoq
nte5stou
nte5stov
nte5s4tō
nte5stón
nte5stóq
nte5stóu
nte5stóv
ntē4ia
ntē4iā
ntē4iá
ntē4iæ
ntē4iǣ
ntē4iǽ
n2t3ĕā
ntĕ3ă
ntĕ3ī4
ntĕī́4
ntĕ4r3ī4
ntĕrī́4
ntĕ4r5ĭ4c
ntĕ4rĭē
ntĕ4r5ĭī
ntĕ6r5ĭm.
ntĕ6r5ĭ6tā
ntĕ6r5ĭ́6c
ntĕ6rĭ́ĕ
ntĕ4rōn
ntĕ4rōs
ntĕ5rŭnt
ntĕ5rŭ́
nt4ĕs
ntĕ5stās
ntĕ5stā́s
ntĕ5stō
ntĕ́4rī
ntĕ́6r5ĭ6c
ntĕ́6r5ĭī
ntĕ́6r5ĭt.
ntĕ́6r5ĭ6tā
ntĕ́5stās
ntĕ́5stō
nté4r5es
nté4ri.
nté4r5i4c
nté4rie
nté4riē
nté4r5ii
nté4r5iī
nté6r5it.
nté6r5ita
nté6r5i6tā
nté5stas
nté5stās
nté5sto.
nté5s4tō
n3th
n3ti
ntis4t
nti5stá
nti5sti
nti5stí
n3tī
n3tĭ
ntĭs4tā
ntĭs4tă
ntĭ5s4tĭ
ntĭ́5s6tā
ntĭ́5s6tă
ntí5s4ta
ntí5s4tā
ntí5sti
nto2s3
n3tō
ntŏ́2
n4t3ŏ́p
n2t3óp
ntó2s3
n3tr
ntra3e
ntrān4
ntrá3e
ntro3i4
ntro3í4
ntró3i
n3tum
n3tus3
ntús3
n1ua
n2uam
n2uan
n2uar
n2uat
1n1uā
n2uām
n2uār
n2uāt
n1uă
n2uám
n2uán
n2uár
n2uát
1nuæ
1nuǣ
1nub2
nu3bi
n3ud
n4udæ
n4udǽ
n4udi
n4udí
n4u3du
n4udú
n1ue
2n3ue.
n2ueb
3n4uel
3n2uem
3nueq
3n2ues
n2uet
3nueu
3nuev
n1uē
n2uēb
n2uēm
n2uēn
n2uēr
n2uēs
n2uēt
2n3uĕ
n2uéb
n2uém
n2ués
n2uét
1nui
n2uim
n2uis
n1uī
n1uĭ
1nuí
n2uím
n2uís
1n1ul
n2u3la
n2u3lā
n2u3lá
n2u3le
nule4i
n2u3lé
n2u3li
n2u3lī
n2u3lí
3num
n4um.
n4u4mn
n4u4mq
n4u4mu
n4u4mv
1n1u2n
1nuō
n1uó
n3u2r
1nu2s
n3usi
nu4sn
nu4sq
n3uss
n3ust
nu4su
nu4sv
n2u3ta
n2u3tá
n2u3tæ
n2u3tǽ
n2u3te
nu3ti.
nu3tin
nu3tiq
nu3tis
nu3tiu
nu3tiv
nu3tín
nu3tíq
nu3tís
nu3tíu
nu3tív
n2u3to
n2u3tó
nu3tr
n2u3tu
n2u3tú
1nuu
n2uun
n2uún
n1u2x
1nū
n1ūd
nū2n
nū3nĕ
n1ū2r
n1ū2s
n2ū3ta
n2ū3tā
n2ū3tă
n2ū3tá
n2ū3tæ
n2ū3tǣ
n2ū3tǽ
n2ū3te
n2ū3tĕ
n2ū3tī
n2ū3tō
n2ū3tu
n2ū3tū
n2ū3tŭ
n2ū3tú
nū́2m
nū́2r
nū4́s
1nŭ
n1ŭl
n2ŭlā
n2ŭlă
n2ŭlī
n4ŭm.
nŭ3mĭ
n4ŭmn
n4ŭmq
n4ŭmu
n4ŭmv
n1ŭn
n1ŭr
nŭ2s
nŭ́3mĕ
1nú
núb2
n2úla
n2úle
nú2mi
n4úmn
n4úmq
n4úmu
n4úmv
2n3úng
n1ú2r
2nv
n3ve
2nx2
n3xi
n2x3u
1ny
2nyma
2nymā
2nymæ
2nymǣ
1ný
2o1a2
o2a3b
oad3
oade4
oadé2
oadi4
oadí2
oadṓ4
oadó2
oadú2
oa3ne
oa3né
oa3ru
o2as
oas3t
oa3t
oau6ste
o1ā
o2ān
o2ār
2o1á
oá2d3
oáde2
o2án
2o1æ2
o2æ3q
o1ǣ2
o2ǣ3q
oǣ́2
oǣ́3q
2o1ǽ2
o2ǽ3q
1ob1
ob2ab
o3bam
o3ban
o3b2a3q
o3bar
o3b2as
obe4ra
obe4rā
obe4rá
obe4ro
obe4rō
obe4ró
ob2ēr
obé2q
obi2b
ob3i4c
obi2m
ob2iq
ob3it.
ob3itn
ob3itq
ob3itv
o2bi2u
obi2v
obī2m
ob2īn
ob2īq
ob2īt
obí2b
obí2c
obí2m
ob2íq
ob3íss
ob3íst
o2bl
o2bo
ob4ole.
ob6olene
ob4oleq
ob4oleu
ob4olev
o2br
ob3rá
obri3
ob5rue
obs2
ob3st
ob5ste
obur3
o3ca
o3cá
1occ
2o3ce
o3cē
2o3cé
2o3ci
o3cī
2o3cí
oco2i
ocoi3q
oco2í
oco5me
oco3m4ē
ocomi5te
ocomi5té
oc4ten
oc3ue.
o3cú
o3dam.
o3dami
o3damq
o3damu
o3damú
o3damv
o3dan
o3dar
o3das
o3dat
o2d3ác
2ode
o4d5eam.
o4d5eamn
o4d5eamq
o4d5eamu
o4d5eamú
o4d5eamv
o4d3ean
o4d3eas
o4d3eat
o4d5eámn
o4d5eámq
o4d5eámu
o4d5eámv
o4d3eán
o4d3eás
o4d3eát
ode4cé
ode2g
ode2i
od3eo.
od3eon
od3eoq
od3eou
od3eov
o2d3eó
ode4st
ode4u5t
o2deú
odē2i
odé2g
od2i
o4d3ibi
o4d3ibí
o2d3i2g
od4iue.
o5dium
o5dius
od4ive.
2o3dī
2odí
o2dí2b
odí5ci
o2d3í2g
od6íue.
od6íve.
2o3do
od4or
2odō
2odó
2odu
od3ue
od3ui
od3uī
od3uí
2odú
2oea
o3eat
2oeā
o3eām
o3eāt
2oe2ă
2oeá
o3eát
oe3b
oecu3
oe3d2
oe2e
o1e2g
2oe2i
2oeī
oe2ĭ
2oeí
o2el
o3e2le
o4e3leu
o4e3lev
o1e2m
o5e4mēti
o5e4mētí
o5e4mētu
o5e4mētú
o3emu
o3emú
oepe3
o1er
oe3ro
oete5r
o1e2u
o4eue
oe2ŭ
o1eú
o1e2x3
2o1ē2
o2ēn3
o2ēs
o2ēu
o2ēv
oḗ2g
oḗ2m
2o1é
oé2g
oé2m
o2éq
o2és
1off
ofo1
og2
o3ga
o3gæ
ogæ3v
o3gǣ
o1h
oho4s
ohó2
2o1i2
o2iad2
o2iā
o2iǣ
o3ic
o2id
o4iene
o2iī
o2io
oio2s
o2iō
o2ió
o1ī
oī2b
oī2m
oī2r
oī2t
oī2u
oī2v
oī́2b
oī́2m
oī́2r
oī́2t
oī́2u
oī́2v
2o1í
oí2b
oí2c
oí2m
oí2r
o3íss
o3íst
oí2ta
oí2te
oí2to
oí4tu
oí2ui
oí2vi
o3la
o3lā
o3lá
o3læ
o3lǣ
o3lǽ
ole3ii
ole3ií
ole3io
ole3ió
ole5ium
ole3iú
olé3ia
olé3ii
olé3io
olé3iu
2o3li.
o3lia
o3lii
o3lií
2o3lin
o3lio
o3liō
o3lió
2o3liq
2o3lis
2o3liu
2o3liv
2o3lī
o3lía
2olín
2olíq
2olís
2olíu
2olív
2oll
2o3lo
2o3lō
2o3ló
o2l3ua
o2luā
o2l3uá
o2l3uæ
o2luǣ
o2l3uǽ
ol3ue.
ol3ueb
ol3uem
ol3uen
ol3ueq
ol5uerē
ol5ueré
ol3ues
ol3uet
ol3ueu
o2l3uē
o2lué
ol3uéb
ol3uém
ol3uén
ol5uéris
ol3ués
ol3uét
ol5uimi
ol5uimur
ol5uimúr
ol5uis.
ol5uisn
ol5uisq
ol5uisu
ol3uit
ol3uīs
ol5uī́s
ol3uím
ol5uísn
ol5uísq
ol5uísu
ol5uíte
2o3l4um
o2luo
o2luō
o2l3uó
2o3l4u2s3
o2l3uu
o2l3uú
2o3lúm
2o3lús
o1m2a
om2á
omb2
ombu3r
ombú3r
ome4da
ome4dá
om2eq
ome4sa
ome4sá
ome4so
om1ē
o3mēt
o3mḗt
o4mé4sa
om2i2a
om2ib
om2ic
om2im
om2in4
omini5c
om2iq
omi2t
o5mit.
om6itas.
om6itasn
om6itasq
om6itasu
om6itasv
om6itásn
om6itásq
om6itásu
om6itásv
om4ite.
om6itene
om4iteq
om4iteu
om4itev
om6itis.
om6itisn
om6itisq
om6itisu
om6itisv
om6itísn
om6itísq
om6itísu
om6itísv
o5mitn
om4ito
o5mi5tot
om4itó
o5mi5tót
o5mitq
o5m4itue
o5m4i5tur
o5m4i5túr
o5mitv
om2iu
om2iv
om2ī
om2íc
om2ím
om2íq
om4íte
o4mí4ti
om4ítn
om4ítq
om4ítu
om4ítv
om2íu
om2ív
o1mo
omo4nu
o1mœ
ompere5r
ompe6ri.
omperi6n
ompe6ri6q
ompe6ris.
ompe6risn
ompe6risq
ompe6risu
ompe6risv
omperi6u
omperi6v
ompe6rī.
omperī6n
ompe6rī6q
ompe6rī6u
ompe6rī6v
ompe6rī́6n
ompe6rī́6q
ompe6rī́6u
ompe6rī́6v
ompe6rí6n
ompe6rí6q
ompe6rísn
ompe6rísq
ompe6rísu
ompe6rísv
ompe6rí6u
ompe6rí6v
ompē4ia
ompē6iā.
ompē6iāq
ompē6iās
ompē6iā́q
ompē6iā́s
ompē4iá
ompē4iæ
ompē4iǣ
ompē4iǽ
ompē4iī
ompē4iō
ompé6r5ii
ompé6r5iī
ompé6r5is
o1m2u
om3ue
o3m2ū2
om2ú
o3n2a
o3n2ā
o3n2á
3onc
on3d
on2e
2one.
one4u5t
2o3n2é
2oni
o5nia.
o5nian
o5niaq
o5niau
o5niav
o4ni4ci
on4ier
on4iér
on2ii
on2ií
on2im
on2in
on2iq
on2it
o2niu
o3niue
o3niué
o3n4iui
o3n4iuí
o3nium
o5niúm
on2iv
on2ī
2oní
o4ní4ci
on2íe
on2íq
on2ít
on2íu
on2ív
on2o
ono3pi
ono3s4t
on2ó
onós4t
ons2c
on5sci
on3s2i
onsi5u
onsi5v
on3s4p
ons2u
on3t2
onte4i
ontes5
ontē4i
2onu
o4nue.
on2uī
on2ul
2on2ú
2o1o2
o2o3n
oo3ru
o2os
oo3u
oo3v
o1ō
o2ōn
o2ōs
2oó
o1ór
oó2re
oó2ri
1ope1
o2pem
oper4a
oper4æ
oper4ǣ
oper4ǽ
ope3r4e
oper4ē
oper4i
ope3r4ī
oper4í
operí5tur
oper4o
oper4ó
oper4u
o2pém
o2pér
opér4u
o3pic
1opī
o3pīs
opo4s3
1opp
op2su
2oq
o3qu
2or.
o1ra
or3ang
o3r2ā
o3ræ
o1rǣ
o3rǽ
2orc
o1r2e
2o3re.
2o3rea
2o3reá
2o3reæ
2o3reǽ
2o3ree
2o3reé
2o3rei
2o3reí
4o3rene
2o3reo
2o3reó
2o3req
2o3reu
2o3reú
2o3rev
o3rē
2o3réa
2o3rée
o1r2i
o3riæ
o3riǽ
2o3rib
oric4
ori5ce
o3rii
o3rií
ori3ni
4oris.
4orisn
4orisq
4orisu
4orisv
o3ría
o3ríc
o2rír
4orísn
4orísq
4orísu
4orísv
orí5tur
4orne.
o1r2o
o3ron.
o3ronn
o3ronq
o3ronu
o3ronv
o3rorú
2o3ros
oro4s3t
2o1rō
o3rónn
o3rónq
o3rónu
o3rónv
2o3rós
2orq
ort2
or3tu
2o1ru
o2rue
or3ue.
o3rum
o3rus
2o3rú
2orv
o1ry
2os.
os2a
os2cǽ
os4ch
os3cit
o4sco
o4scó
os2cr
o4scu
o4scú
os2e
ose2i
os2i
osíl2
o1s2m
2osn
o1sp
o2spa
o2spá
os2pe
ospe5ri
ospe5r4ī
osper4í
os2pé
os2pl
2o2sq
2ost
os4t3ea
os4t3eā
os4t3eá
ost5ill
osti5t4
os4t5íll
ostí3t4
os3to
os4to.
os4ton
os4toq
os4tou
os4tov
os5tri
os5trī
os3trí
os3tru
os3trú
os4tué
2osue
o4s3ue.
os2ué
os2uī
2osv
o3ta
o4t3ann
o4t3ánn
o4t3enn
o5ter.
o4t3e4ra
o4t3e4rā
o4t3e4rá
o5te5re
ote5rii
ote5rií
o4t5erim
ote5rin
o4t5erit
ote5riu
oteri5ue
ote5ri5v
ote5rī
oterī5u
oterī5v
o4t5e4rít
o5tern
o5terq
o5terue
o4t5erun
o4t3e4rú
o5terv
o4t5este
o4t5esti
o4t5estí
o4t5esto
o4t5estó
o4t3énn
o4t5é4rim
o4t5é4rit
o4t3ést
o2tl
o3t2u
2o1u2
ou3enn
ouē5nī
ou3énn
o2um
ou4st
o1ū2
oū́2
2oú2
o1út
2ov
ov3enn
ovē5nī
ov3énn
2ox2
ox4eu
o3xi
oxu3
o2x3ue
o͞e2i
o͡e2i
ō2a
ōab2
ōa2m
ōăb2
ōb2
ōba3q
ōbæ3
ōbe3
ōbī3u
ōbī3v
ōbo3
ōbŏ3r
ōbŏ́3
ō3bu
ō3bŭ
2ōc
ō2ch
ō2c3ue
ō2d1a2
ō3dam.
ō3damq
ō3damu
ō3damv
ō3d2an
ō3d2ar
ō3dat
ō2dāc
ō4d3ā́c
ō2d1ă
ō3dăm.
ō3dămq
ō3dămu
ō3dămv
ō3d2ăn
ō3dăr
ō3dăt
ō5dắmn
ō5dắmq
ō5dắmu
ō5dắmv
ō3dắn
ō3dắr
ō3dắt
ōdá2
ō4d5eam.
ō4d5eamn
ō4d5eamq
ō4d5eamu
ō4d5eamv
ō4d3ean
ō4d3eat
ō2d3eā
ō4d5eámn
ō4d5eámq
ō4d5eámu
ō4d5eámv
ō4d3eán
ō4d3eát
ō2d3eō
ō4d3e4ru
ō4d3e4rú
ō2d3e2s
ō2deu
ō3deue
ō2deú
ōdē2g
ōdē2s
ōdḗ4g
ō2d3ĕā
ō4d5ĕăm.
ō4d5ĕămn
ō4d5ĕămq
ō4d5ĕămu
ō4d5ĕămv
ō4d3ĕăn
ō4d3ĕăt
ō6d5ĕắmn
ō6d5ĕắmq
ō6d5ĕắmu
ō6d5ĕắmv
ō4d5ĕắn
ō4d5ĕắt
ō2d3ĕō
ō4d3ĕrŭ
ō2d3ĕs
ō4d3ĕ́s
ō2d3és
ō2d3i2g
ōd4īue.
ōd4īuĕ.
ōd4īve.
ōd4īvĕ.
ōd6ī́ue.
ōd6ī́uĕ.
ōd6ī́ve.
ōd6ī́vĕ.
ō2d3ĭg
ō4d3ĭ́g
ō2d3í2g
ō3do
ōd4or
ō2e
ōe2m
ō2ĕ
ōg2
ōga2
ōgá2
ōgo2
ō1h
ō1i2
ō2iad2
ō2i3b
ō3ic
ō2ien
ō2iēn
ō2is
ō1ĭ2
ō2ĭ3b
ō2ĭē
ō2ĭĕ
ōĭ́2
ō2ĭ́ĕ
ō1í2
ō2íe
ōle3i
ōle2r
ōlé3i
ōl3ue.
ō1m2
ōma2r
ōna2r
ōn2ā
ōná2
1ōnc
2ō3n2e
ōneu5t
2ōnē
2ō3n2ĕ
2ō3né
2ōn2i
2ōnī
2ōnĭ
2ōní
ōno2
ōns2c
ōns4i
ōnsi5t
ōns4ĭ
ōnsĭ5t
ōn3s4p
2ō1n2u
ō2n3ue
2ōn2ŭ
2ōnú
ōp2
ō3pi
ō3pĭ
ō3pt
2ōq
ō3qu
ō1r
2ō3ra.
4ō3rane
2ō3raq
2ō3rau
2ō3rav
2ō3ră.
4ō3rănĕ
2ō3răq
2ō3rău
2ō3răv
1ōrd
ōr2e
2ō3re.
2ō3rea
2ō3reā
2ō3reá
2ō3reæ
2ō3reǣ
2ō3reǽ
2ō3ree
2ōreē
2ō3reī
4ō3rene
2ō3reō
2ō3req
2ō3reu
2ō3reú
2ō3rev
ōrē2i
ō3rēu
ō3rēv
ōr2ĕ
2ō3rĕ.
2ō3rĕa
2ō3rĕā
2ō3rĕă
2ō3rĕá
2ō3rĕæ
2ō3rĕǣ
2ō3rĕǽ
2ōrĕē
2ō3rĕĕ
2ō3rĕī
4ō3rĕnĕ
2ō3rĕō
2ō3rĕq
2ō3rĕu
2ō3rĕŭ
2ō3rĕv
4ō3rĕ́ă
4ō3rĕ́ĕ
ōré2
2ō3réa
2ō3rée
2ō3ri
2ō3rī
2ō3rĭ
2ō3rí
1ōrn
ōro2
2ō3ron
2ō3ros
2ō3rōr
2ō3rōs
ō3rṓr
ō3rṓs
ōrŏ2
2ō3rŏn
2ō3rŏs
ō3rŏ́n
ō3rŏ́s
ōró2
2ō3rón
2ō3rós
2ō3r2u
ōr3ue.
ō4ruĕ
2ō3rŭ
ōr4ŭn
2ō3rú
2ōs.
ōs2cǽ
ō3s4ch
ōs3cit
ōs3cī
ōs3cŭ
ōsē2i
ōs4ēm
ōs2i
ōsi3l4
ōsi2n
ōsíl2
2ōsn
ō1s2p
ōspe3r
ōsper4ī
ōspĕ5rī
2ō2s3q
2ōst
ōs2ta
ōs2tā
ōs2tă
ōs2tá
ōs2te
ōs2tē
ōs2tĕ
ōs2té
ōs2ti
ōsti5t4
ōs2tĭ
ōstí3t4
ōs2tō
ōs5tri
2ō2s3ue
2ō2s3uĕ
2ōsv
ōt2
ō3ta
ō3tă
ōté2
ō2th
ōtó2
ō3tu
2ō1u
ō3ue
ō3uĕ
ō2um
2ōv
ō3ve
ō3vĕ
ō2x
2ō2́
ṓb2
ṓ3bu
ṓ3bŭ
ṓ4d3ea
ṓ4d3eā
ṓ4d3eō
ṓ4d5eru
ṓ4d3es
ṓ4d3ĕā
ṓ4d3ĕă
ṓ4d3ĕō
ṓ4d3ĕs
ṓ2ĕ
ṓ3g2
ṓi2
ṓ3ic
ṓĭ2
ṓ3ĭc
ṓ3lo
ṓ3lŏ
ṓ3luī
ṓm2
ṓ3mu
3ṓnc
ṓns4i5
ṓns4ĭ5
ṓ3p2
3ṓrd
ṓ3rĕ
3ṓrn
ṓ3spe
ṓ3s4pĕ
ṓ3spi
ṓ3spĭ
ṓ3s4ta
ṓ3s4tā
ṓ3s4tă
ṓ3s4te
ṓ3s4tē
ṓ3s4tĕ
ṓ3s4tō
ṓ5s4trē
ṓ4s5tru
ŏ1a
ŏau6stĕ
ŏ1ā
ŏ2ān
ŏ2ār
2ŏ1ă2
ŏăd3
ŏădĕ4
ŏădĕ́4
ŏădṓ4
ŏ2ăs
ŏắ2
ŏắd3
ŏắdĕ4
ŏ1á
ŏ1æ2
ŏ2æ3q
ŏ1ǣ2
ŏ2ǣ3q
ŏǣ́2
ŏ1ǽ2
ŏ2ǽ3q
1ŏb1
ŏ2ba
ŏbă2
ŏb2ăb
ŏb2ăq
ŏb2ău
ŏb2ăv
ŏbắ2
ŏb2ēr
ŏbĕ4r
ŏbĕ́2
ŏ2bi
2ŏbī
ŏbī2m
ŏb2īn
ŏb2īq
ŏb2īt
ŏbĭ2
ŏbĭ4c
ŏb3ĭt
ŏbĭ́2
ŏ2bl
ŏ2bo
ŏ2bó
ŏ2br
ŏbs2
ŏb5stĕ
ŏ3că
1ŏcc
ŏ3cē
ŏ3cĕ
ŏ3cī
ŏ3cĭ
ŏcŏ3m4ē
ŏcŏ3mĕ
ŏcŏmĭ5tĕ
ŏc4tĕn
ŏ2cu
ŏ3cŭ
2ŏdĕ
ŏdĕ4c3ĕ
ŏdĕs3
2ŏ3dī
ŏd2ĭ
2ŏdō
ŏ2d1u
2ŏdŭ
ŏ1ē2
ŏ2ēn
ŏē3nĕ
ŏ2ēs
ŏ2ēu
ŏ2ēv
ŏḗ2g
ŏḗ2m
ŏ1ĕ2
ŏ2ĕ3q
ŏ3ĕ́2
ŏfŏ1
ŏg2
ŏ3ga
ŏ3gæ
ŏgæ3u
ŏgæ3v
ŏ3gǣ
ŏ1h
ŏ1i
ŏ1ī
ŏī2b
ŏī2m
ŏī2r
ŏī2t
ŏī2u
ŏī2v
ŏī́2b
ŏī́2m
ŏī́2r
ŏī́4t
ŏī́2u
ŏī́2v
ŏ1ĭ
ŏ2ĭu
ŏ2ĭv
ŏ3la
ŏ3lā
ŏ3lá
ŏ3læ
ŏ3lǣ
ŏ3lǽ
ŏ3lēn.
2ŏ3lĕ.
4ŏ3lĕnĕ
2ŏ3lĕq
2ŏ3lĕu
2ŏ3lĕv
2ŏ3lī
2ŏll
2ŏ3lō
2ŏ3lŏ
ŏ2l1u
2ŏ3lŭm
2ŏ3lŭs
4ŏ3lŭ́m
4ŏ3lŭ́s
ŏ1ma
ŏ3m2ă
ŏmb2
ŏmbū3r
ŏmbū́3
ŏm1ē
ŏ3mēt
ŏ3mḗt
ŏ3mĕ.
ŏ3mĕm
ŏ3mĕn
ŏ3m2ĕq
ŏ3mĕu
ŏ3mĕv
ŏ3m2ī
ŏ3mĭă
ŏm2ĭn
ŏmĭnĭ5c
ŏ3mĭs
ŏmĭ2t
ŏm3ĭtŏ
ŏ3mĭ́s
ŏm3p2
ŏmpḗ5i
ŏmpĕ6rī.
ŏmpĕrī6n
ŏmpĕ6rī6q
ŏmpĕ6rī6u
ŏmpĕ6rī6v
ŏmpĕ6rī́6n
ŏmpĕ6rī́6q
ŏmpĕ6rī́6u
ŏmpĕ6rī́6v
ŏmpĕ6r5ĭī
ŏmpĕ6rĭt
ŏmpĕ́6r5ĭī
ŏ3m2ū2
ŏ3n2ā
ŏn3d2
ŏn2gá
ŏ2n1i
ŏn5ĭ4cĕ́
ŏ4n3ĭ4cĭ
ŏ4n5ĭ́4cĭ
ŏn2ŏ
ŏnŏ3s2
ŏntĕs5
ŏn2ŭ
ŏ1ō
ŏ2ōn
ŏ2ōs
ŏ1ŏ2
ŏŏ́4r
2ŏpa
2ŏpā
2ŏpæ
2ŏpǣ
ŏpe2
ŏ2pĕ
ŏpĕ3r4a
ŏpĕ3r4æ
ŏpĕ3r4ǣ
ŏpĕ3rĕ
ŏpĕ3rī
ŏpĕ3rŏ
ŏpĕ3rŭ
1ŏpī
ŏ3pīs
2ŏ3pŏ
ŏpŏ3t
ŏp2su
ŏptĕ4
ŏptĕ́4
2ŏr.
ŏ1ra
ŏ3r2ā
2ŏ1ră
ŏ1ræ
ŏ1rǣ
2ŏrc
ŏ1re
ŏ3rē
ŏ1r2ĕ
2ŏ3rĭb
2ŏ3rĭs
4ŏ3rĭ́s
2ŏrn
2ŏ1rō
ŏ1r2ŏ
2ŏrq
ŏr2su
2ŏru
2ŏ3rŭ
2ŏrv
ŏs2ă
ŏ3s2ĕ
ŏ1s2m
ŏ1sp
ŏ2spă
ŏs2pĕ
ŏspĕ5rī
ŏ2s3pĭ
ŏs2pl
ŏs3q
ŏs4t3ĕā
ŏs5tĕr
ŏst5ĭll
ŏs6t5ĭ́ll
ŏs5trī
ŏ3strŏ
ŏs3u
ŏ4t3ănn
ŏtĕ2
ŏ2t3ĕr
ŏtĕ3rĕ
ŏtĕ5rī
ŏtĕrī5u
ŏtĕrī5v
ŏ4t3ĕs.
ŏ4t3ĕsn
ŏ4t3ĕsq
ŏ4t5ĕstĕ
ŏ4t5ĕstĭ
ŏ4t3ĕsu
ŏ4t3ĕsv
ŏ4t5ĕ́rĭ
ŏ4t3ĕ́s
ŏ2tl
ŏ1u
ŏuē5nī
ŏ3u4ĕm
ŏ1ū2
ŏū́2
ŏū́4t
ŏ1ŭ
ŏ2ŭm
ŏ2ŭs
ŏ2ŭ́
ŏvē5nī
ŏ3v4ĕm
2ŏx2
ŏx4eu
ŏ2xu
ŏxŭ3
ŏxŭ́3
ŏ2́
ŏ́3ă
ŏ́b3ĕŏ
ŏ́b3ĕ4r
ŏ́bĭ2
ŏ́b3ĭt
ŏ́b5ŏlē
3ŏ́2br
ŏ́bs2
2ŏ́c
3ŏ́cc
2ŏ́d
ŏ́2d3u
ŏ́1ĕ
ŏ́ĕ2m
ŏ́1i
ŏ́ĭ2
ŏ́3ĭē
ŏ́3ĭt
4ŏ́lĕn
4ŏ́lĕq
4ŏ́lĕu
4ŏ́lĕv
2ŏ́ll
ŏ́l3u
ŏ́4m3ĕs
ŏ́mĭ4tĭ
ŏ́mĭ4tŏ
ŏ́m3p2
ŏ́3nĭb
ŏ́3ŏ
ŏ́4pĕr
ŏ́4pī
ŏ́2r
2ŏ́3ră
ŏ́3rē
ŏ́3rĕ
ŏ́3rī
ŏ́3rĭa
ŏ́3rĭæ
ŏ́3rĭǣ
4ŏ́3rĭb
ŏ́3rĭc
ŏ́3rĭd
ŏ́3rĭī
ŏ́3rĭs
2ŏ́rn
ŏ́3rō
2ŏ́rq
2ŏ́ru
ŏ́3rŭ
2ŏ́rv
ŏ́3sĕ
ŏ́3s4pĕ
ŏ́3sph
ŏ́s4t5ĕā
ŏ́t5ĕ4rā
ŏ́t5ĕ4ră
ŏ́t5ĕ4rĭ
ŏ́t5ĕrŭ
2ŏ́x
ó1ad
ób1
ób2ab
ób2a3q
ób3a2r
ób2a͡
ób2eq
óbe4r
ób3es
óbi4c
ób3i2t
ób2iu
ób2o1
ób5olen
ób5oles
ób3olē
óbo3r
1ó2br
ób2ri
ób3ru
ób5rue
1ób3s2
ób5ste
ó3b2u
1ócc
óco3m
óco5me
ó2c3ue
2ód
ód2a
ó2d3ea
ó4d3eo
ó4d3e4ru
ó4dest
ó2d3i2g
ó3ear
ó3eat
óe2ă
óe3b
óed2
óe2e
óe2i
ó1e2m
óepe3
óe2ŭ
ófe1
ófo1
óg2o3
ó1h
ói2
ó3ian
ó3iaq
ó3iau
ó3iav
ói3b
ó1ic
ó3ien
ó1iē
ó3iit
ó2in
ó2i3q
ó3it
ó1iu
ó2i3ue
ó2i3v
2ólen
2óleq
2óleu
2ólev
2óll
ó2l1u
ó3lub
ó3lum
ó3lus
ó1m
óm2a
óm2e
ó2m3e2d
óm2i
ó5mit.
óm5i4tan
óm5i4tat
ómi4tān
óm5i4tem
óm5i4ten
óm5i4tes
óm5i4tet
ómi4tēs
ómi4tor
ó5mitur
ómpe3
ómpe5r
óm2ui
óm2uī
ó3m2ū
2ó1n
3ónc
ón3g2
ón5i4cit
ón3t2
ó2nue
ón2uī
ón2ul
ó3nus
óo2
ó1or
ópe1
ó2pe3r
ó3pi
óp2su
ópu3
2óq
ó3qu
ó1ra
4órane
2óraq
2órau
2órav
ó1ræ
ó1re
2óre.
2órea
2óreæ
2óree
2órei
4órene
2óreo
2óreq
2óreu
2órev
ó1ri
2óri.
ó4riat
2órib
2óris
ó1rī
3órna
4órne.
3órnem
3órnen
3órner
3órnes
3órnet
3órno
ó1ro
ó1rō
2órq
órt2
ór3tu
2óru
ó2rue
ó3r2ui
ó3run
2órv
ós4ch
ós2i
2ósn
ó1sp
ós2pe3
2ós3q
2óst
óste3
ós4t3ea
ós4t3eā
ós5tri
2ósue
ós3uis
ó3s2uī
2ósv
ó5ter.
ót3e4ra
ót3e4rā
ót3eru
ó4test
ó2tl
2ó1u2
ó2um
2óv
2óx
óx4eu
ó3x2i
óxu3
ó2xue
2œa
œa2m
2œā
2œă
2œá
2œæ
œæ2i
œæ2ŭ
2œǽ
œb2
œ3bi
œbī3u
œbī3v
œ3bu
œ3bŭ
œce2
œcu3
œde3
œdĕ3r
œen3
œēn3
œén3
2œi
2œī
2œí
œ1m
œ1n2
œno3b2
œó1r
œpe3
œper2
œpĕ3r
œpĕ5rĭ
œ1r
œte5re
œ́3b2
œ́2i
œ́3l
œ́1n
œ́2s
1p
p2a
pab2
3pa3d2
pada3
pae4nī
pan3sa
pan5s4i
pansi5u
pansi5v
pans4í
2parg
2pars
par2u
pa4ruī
pa3tr
p2ā
pān3sa
pān3să
pān3s4ī
pānsī5n
pānsī5q
pānsī5u
pānsī5v
3pă3d2
pă3ră
2părg
pă3rŏ
2părs
păs3t
păs5tă
2păth
pắ3rē
4pắrg
4pắrs
p2á
pán3si
2párg
2párs
pá4ruī
pæ2a
pæ2ă
pæ2á
pæ2i
pæ2nī
pæ2ŭ
pǣ2a
pǣ2ă
pǣ2nī
pǣ2ŭ
p2e
3pe.
3pe2a
pe4ae
pe4am
pe4as
pe4a͞
pe4a͡
pe4ās
pe3d2
pe2e
3pei
pe4ia.
pe4iae
pe4iam
pe6iane.
pe4iaq
pe4iar
pe4ias
pe4iau
pe4iav
pe4iáe
pe4iám
pe6iáne.
pe4iár
pe4iás
pe4iáu
pe4iáv
pe4ien
pe2ié
pe2ii
pe2ií
pe4io.
pe4ioq
pe4iou
pe4iov
pe4ión
pe4ióq
pe4ióu
pe4ióv
pe4is
pe4ium
pe2ī
pe4īs
3pe2í
pe4mn
pe4mq
pe4mv
3pen
pe4nt
pe2nu
3pe2o
pe4os
pe2ō
pe4ōs
3peó
pepe3
peper4
pepere5
3peq
per1
per5a6b5únd
pe5ram.
pe5ramn
pe5ramq
pe5ramu
pe5ramú
pe5ramv
pe3ran
per6ane
pe5ras.
pe5rasn
pe5rasq
pe5rasu
pe5rasv
pe5rat.
pe5rati
pe5ratí
pe5ratn
pe5ratq
pe5ratv
pe4rāc
pe5rāt
per5ā́c
pe5rā́t
pe4r3ác
pe2re
pere4s
pere4x3
perexi4
perexí4
pe5rē.
pe4rēb
pe5rēq
perē4s
pe5rēt
perḗ4s
pe4r5énn
peré4s
peré4x3
per5i4ce
peri4cī
peri4cí
peri4mo
peri4mō
peri4mó
perin5i4
peri4n5í4
per5i6ta͞
peri6tā.
peri6tān
peri6tāq
peri6tār
peri6tāu
peri6tāv
peri4tǣ
peri4tī
peri4tō
peri6tū.
peri6tūn
peri6tūq
peri6tūr
peri6tūu
peri6tūv
pe4rí4ce
pe4rn
pero4s
per5osa
per5osá
per5osæ
per5osǽ
per5ose
per5osé
per5osi
per5osí
per5oso
per5osó
per5osú
pe3rō.
pe3rōn
perō4s
pe3rōu
pe3rōv
pe5rṓn
pe5rṓq
perṓ4s
pe5rṓu
pe5rṓv
pe4róp
peró4s
perpe5t4
perpé5t4
pe4rq
pe4rt
pe4rv
3pes
pe4sn
pe4sq
pes3t
pes5te
pe4su
pe4sv
3pet
pete5r
pete7rer
pe4tn
pe4tq
pe3tuī
pe4tv
3peu
pe4um
pe2un
pe2uo
pe2uō
pe2uó
pe4us
3peú
3pev
pex2
pe3x4e
pexu3
pexū3r
3pe͞
3pe͡
p2ē
pē4iam
pē4ian
pē6iāne.
pē4iāru
pē4iārú
pē4iāue
pē4iāve
pē6iā́ne.
pē6iā́ru
pē6iā́ue
pē6iā́ve
pē4iám
pē4iæne
pē4iæue
pē4iæve
pē4iǣne
pē4iǣue
pē4iǣve
pē4iǽne
pē4iǽue
pē4iǽve
pē4ien
pē4iīne
pē4iīue
pē4iīve
pē4iōne
pē4iōru
pē4iōrú
pē4iōue
pē4iōve
pē2iu
pē2iú
pē2nu
pē3r
p2ĕ
3pĕ.
3pĕā
3pĕ2ă
3pĕ3d2
3pĕf
3pĕn
pĕ4nt
3pĕō
3pĕq
pĕ4r3ā4c
pĕ5rāt
pĕr5ā́c
pĕ5rā́t
pĕ5rē.
pĕr3ēb
pĕ5rēq
pĕrē4s
pĕ5rēt
pĕrḗ4s
pĕr3ĕā
pĕr3ĕă
pĕ4r3ĕŏ
pĕ6r5ĕ́nn
pĕ4r5ĭ4cī
pĕr6ĭĕ.
pĕr6ĭĕn
pĕr6ĭĕq
pĕr6ĭĕu
pĕr6ĭĕv
pĕr5ĭmĭ
pĕ4r5ĭ4mō
pĕ4rĭn
pĕ5rĭō
pĕ5rĭŏ
pĕ5rĭs
pĕ4r5ĭ4ta
pĕr5ĭtā.
pĕr5ĭtān
pĕr5ĭtāq
pĕr5ĭtār
pĕr5ĭtāu
pĕr5ĭtāv
pĕ4r5ĭ4tă
pĕ4r5ĭ4tá
pĕ4r5ĭ4tæ
pĕ4r5ĭ4tǣ
pĕ4r5ĭ4tǽ
pĕr5ĭtĕ.
pĕr5ĭtĕn
pĕr5ĭtĕq
pĕr5ĭtĕu
pĕr5ĭtĕv
pĕ4r5ĭ4tī
pĕ4r5ĭ4tō
pĕr5ĭtū.
pĕr5ĭtūn
pĕr5ĭtūq
pĕr5ĭtūr
pĕr5ĭtūu
pĕr5ĭtūv
pĕ4r5ĭ4tŭ
pĕ5rĭŭ
pĕ6r5ĭ́6cĕ
pĕr5ĭ́mĭ
pĕ5rĭ́s
pĕrĭ́4t
pĕr5ĭ́tă
pĕr5ĭ́tĕ
pĕ2rō
pĕ3rō.
pĕ3rōq
pĕrō4s
pĕ3rōu
pĕ3rōv
pĕ5rṓn
pĕ5rṓq
pĕrṓ4s
pĕ5rṓu
pĕ5rṓv
pĕr5ŏ́p
pĕr3ū́
pĕr5ŭ́n
3pĕ2s
pĕs5tĕ
3pĕt
3pĕu
3pĕv
2pĕx2
pĕxū3r
pĕ́4r3ē
pĕ́6rĕăn
pĕ́6r5ĕăr
pĕ́6rĕăt
pĕ́4r5ĕŏ
4pĕ́rg
pĕ́4rī
pĕ́6r5ĭ6cĕ
pĕ́6r5ĭ6cī
pĕ́6r5ĭt.
pĕ́6r5ĭ6ta
pĕ́6r5ĭ6tă
pĕ́6r5ĭ6tæ
pĕ́6r5ĭ6tǣ
pĕ́6r5ĭ6tī
pĕ́6r5ĭ6tō
pĕ́6r5ĭ6tū
pĕ́6r5ĭ6tŭ
6pĕ́rnān
6pĕ́rnăr
6pĕ́rnăt
6pĕ́rnĕr
6pĕ́rnĕt
4pĕ́rnĭ
4pĕ́rnŏ
3pĕ́4s
pĕ́s5t
3pĕ́t
3péa
2péc
3péi
3péo
pér5ear
pér5eor
pé2r3ē
2pérg
pér5i4ce
pér5i4ci
pér5i4cī
pé4r5it.
pér5i4tæ
pér5i4tǣ
pér5i4tī
pér5i4to
pér5i4tō
pér5i4tu
pér5i4tū
pé2rī
2pérm
4pérnān
4pérner
pér4ui.
pér4uī.
3pés
3pét
3péu
pé2uo
péx2ī
3pé͞
3pé͡
2ph.
phe2i
phē2i
2phēx
phi6sta
2phn
3pho
3phŏ
3phó
2pht
p2i
3pi2a
piad2
3piā
3piá
3piæ
3piǣ
3piǽ
2pic
pic4e
pi5cen
3pid
3pie
3piē
3pié
pig3n
3pi2i
3piī
3pií
3pil
pin2ā
pin4i
pini3c
3pio.
3pion
3pioq
pio2s
3piou
3piov
3pión
3pióq
3pióu
3pióv
pi3r2
pirí3t
pi4s3c
pis5ci
pi4s3tr
3pit
pi5ter
3pium
3piúm
pi2x3
3pī.
3pīm
3pīq
pīrí3t
pīs3
3pīu
3pīv
3pĭă
2pĭc
pĭn2a
pĭn2ā
pĭn2æ
pĭr2
pĭ4str
3pĭt
pĭ5tĕr
pĭ́3d
pĭ́4s5t
3pĭ́t
3pía
3píd
3píe
píg3n
3píl
pí1m
pí4s3t
3pít
pí3tur
pí2x
p2l2
p1n2
p3nem
p3nen
p3ner
p3nes
p3net
2pni
2pní
p2o
3po.
2pond
po3ni
3poq
3por
pos3c
posí3t
po3s2u
po4t5e4ro
po4t5e4rō
po4t5e4ró
3pou
3pov
3pō.
3pōq
3pōr
3pōs
3pōu
3pōv
3pṓs
p2ŏ
pŏ3ĭ
2pŏn
3pŏny
pŏ3rĕ
pŏ3rī
pŏs4trŏ
pŏtĕ4r
pŏtĕ́4
pŏ́3rĭ
pŏ́4t5ĕ4r
3póq
3pór
pó3s4tr
pó4te4r
pót5eri
pót5ero
pót5erō
3póu
3póv
2pp
ppule4
p2r2
prae3
prae5s4
praete6ris
praete6rís
praeté6r5is
pra3s2
pra͞e5
pra͞es4
prá͞e5
prá͞es6
pra͡e5
pra͡es4
prá͡e5
prá͡es6
prā1
prās2
práe3
práes4
prá3s4t
præ3
præs4
prǣ3s
prǣ3ŭ
prǣ́3
prǣ́s4
prǽ3
prǽs4
pre3d
pre5mi
pre5mo
prē3m
pr4ĕ́
pri5mi
pri4s3
prĭ4s
3pro
pro6de6ri
pro6de6rí
pro4des
pro4dés
pro4di.
pro6di6mus
pro6di6mús
pro4di4n
pro4di4q
pro4dis
pro6dit.
pro6di6te
pro6di6tis
pro6di6tís
pro6ditn
pro6di6to.
pro6di6ton
pro6di6toq
pro6di6tot
pro6di6tou
pro6di6tov
pro6di6tón
pro6di6tóq
pro6di6tót
pro6di6tóu
pro6di6tóv
pro6ditq
pro6ditue
pro6di6tur.
pro6di6turn
pro6di6turq
pro6di6turue
pro6di6turv
pro6di6túrn
pro6di6túrq
pro6di6túrue
pro6di6túrv
pro6ditv
pro4dí4n
pro4dí4q
pro4dís
pro6dí6te
pro6dítn
pro6dítq
pro6dítu
pro6dítv
pro4d5í4u
pro4d5í4v
pro4li
3prō1
prō6de6ri
prō6de6rí
prō6dĕ6rĭ
prō6dit.
prō6ditn
prō6ditq
prō6ditue
prō6ditv
prō4dī.
prō4dī4n
prō4dī4q
prō6dī́6n
prō6dī́6q
prō6d5ī́s
prō6d5ī́6u
prō6d5ī́6v
prō6dĭt.
prō6dĭtn
prō6dĭtq
prō6dĭtu
prō6dĭtv
prō6dĭ́tn
prō6dĭ́tq
prō6dĭ́tu
prō6dĭ́tv
prō6dítn
prō6dítq
prō6dítu
prō6dítv
prō4li
prō4lĭ
prōs2
prō3s4t
prṓ6de6ri
prṓ6dĕ6rĭ
prṓ6dit.
prṓ4d5ī
prṓ6dĭt.
prṓ5s4t
3pró
pró6de6ri
pró4des
pró4di.
pró4dis
pró6dit.
pró4li
prós2
pró3st
2p1s2
psa3c
p3sá
p2s3q
p2s3ue
p2s3uĕ
2pt2
p4t3enn
pte3r4a
pte3rǣ
pte5re
pte6rea
pte6reā
pte5ré
pte3ri
pteri5u
pteri5v
pte5rī
pterī5u
pterī5v
pte3ro
pte3rō
p4t3ĕnn
ptĕ3r4a
ptĕ3rǣ
ptĕ3rĕ
ptĕ5rī
ptĕrī5u
ptĕrī5v
ptĕ3rŭ
p5tĕ́nd
pt5ĕ́nn
p4t3énn
pti4s
ptis5t
pti6sta
ptĭ4s
ptĭs5t
p3tr
p3tu
p2u
2pua
2puā
2puá
3pu3b2
pu4gn
pu2lu
pul3ue
pul3ué
pu3lum
pu1m
2puo
2puō
2puó
2puu
2puú
3pūb
pū2s
2pūt
p2ŭ
2pŭā
2pŭă
3pŭg
2pŭō
2pŭŏ
2pŭr
2pŭŭ
3púb2
pú4gn
2pút
1q
q2u2
qu4ắ
qu4ám
quás3
qu4át
que6ste
3quĕ
quĕ6stĕ
qu4ia
qui4d5ue
qui4d5ui
qui4d5uī
qui4d5uí
2quit
quí4d5ue
quí4d5ui
quí4d5uī
quo2s3
quó2s3
ra3a2
rab4a
r2ab2e
ra3bib
rabi3c
r4abis
ra3biu
rab2ī
rabī3u
rabī3v
r2abí
rab2o
ra3bu
ra4b5und
ra3ci
ra3cí
ra2cr
rad2a
rad2e
rad2ē
rad2é
rad2ī
radō5rō
rad2ó
ra3eat
ra3eāt
ra3eát
raes2
r2aeu
r2aev
r1ag
ra2gā
ra2gá
ra3g2n
ra2gr
2rah
ra1i2
ra3ic
ra3i4n
ra2io
ra2ió
ra3is
ra3it
rai4u
ra4ium
ra4ius
ra4iús
rai4v
ra1ī2
raī4n
raī́4
ra1í2
ra3í4n
ra3ís
r1al
r2a3li
ra3mam
ra4man
ra3mas
ra4mán
ra4már
ram3b2
ram5bi
rambī5q
rambī5u
rambī5v
rambī́5q
rambī́5u
rambī́5v
ram5bu
r2a3me
r2a3mé
r3amna
r3amnā
r3amná
r3amni
r3amnī
r3amní
ra5ne.
4rang
ran4si.
ran4si4m
ran4s5i4n
ran4si4q
ran4s5is
rans5it
ran4s5í4n
ran4sí4q
ran4s5ís
ran4sí4u
ran4sí4v
r2ant
ra1o
ra1ō
r2aq
ra5que
ra4rab
r4aram
ra4rar
ra4rau
ra4rav
ra2rā
ra4ráb
ra4rár
ra4ráu
ra4ráv
rar5ch
r4arem
r4aret
r3a2rē
ra4rid
4ra4ríd
r2aro
r3aror
r3a2rō
r2aró
r3arór
ra4rue
ra4rué
ra4rui
ra4ruí
ra5rum
r3a4rúe
r3a4rúi
ra5rúm
rasce5u
ra4sn
ra4s2p
ra4sq
ra4ss
ras4ta
ras4tá
ras4te
ras4tém
ras4tén
ras4tés
ras4tét
ras4tic
ras4tíc
ras5tra
ra4sui
ra4suí
ra4sv
ra5te.
ra5ten
ra5teq
ra5teu
ra5tev
ra5ti.
ra5tic
ra5tim
ra5tin
ra5tiq
ra5tis
ra5tiu
ra5tiv
ra5tíc
ra5tín
ra5tíq
ra5tís
ra5tíu
ra5tív
ra5to.
ra5ton
ra5toq
ra5tor
ra5tos
ra5tou
ra5tov
ra5tón
ra5tóq
ra5tór
ra5tós
ra5tóu
ra5tóv
ra3tr
r3att
ra5tum
ra5tus
ra5túm
ra5tús
ra5ue.
ra5ve.
ra2xu
r4a͞eu
r4a͞ev
r4á͞eu
r4á͞ev
r4a͡eu
r4a͡ev
r4á͡eu
r4á͡ev
1rā
rā5bun
rā4cer
rā4cĕr
rā4cér
2rācr
2rāct
rāi2
rā4iae.
rā6iaene
rā6iaeque
rā6iaeue
rā6iaeve
rā6ia͞e.
rā6ia͞ene
rā6ia͞eque
rā6ia͞eue
rā6ia͞eve
rā6iá͞ene
rā6iá͞eque
rā6iá͞eue
rā6iá͞eve
rā6ia͡e.
rā6ia͡ene
rā6ia͡eque
rā6ia͡eue
rā6ia͡eve
rā6iá͡ene
rā6iá͡eque
rā6iá͡eue
rā6iá͡eve
rā4iā.
rā4iāru
rā4iārú
rā4iās.
rā6iāsne
rā6iāsque
rā6iāsue
rā6iāsve
rā6iā́ru
rā6iā́sne
rā6iā́sque
rā6iā́sue
rā6iā́sve
rā6iáene
rā6iáeque
rā6iáeue
rā6iáeve
rā4iæ.
rā4iæne
rā6iæque
rā4iæue
rā4iæve
rā4iǣ.
rā4iǣne
rā6iǣque
rā4iǣue
rā4iǣve
rā6iǣ́ne
rā6iǣ́que
rā6iǣ́ue
rā6iǣ́ve
rā4iǽne
rā6iǽque
rā4iǽue
rā4iǽve
rā3ic
rā4iīs.
rā6iīsne
rā6iīsque
rā6iīsue
rā6iīsve
rā6iī́sne
rā6iī́sque
rā6iī́sue
rā6iī́sve
rāĭ2
rāĭ́2
rā1í2
r2ān
rānsī4
rānsī́4
rān6s5ĭ́t
rān4s5ít
4rārēsc
6rārḗsc
rā4rue
rā4ruē
rā4rué
rā4rui
rā4ruī
rā4ruí
r3ā4rŭē
r3ā4rŭĕ
r3ā4rŭī
r3ā4rŭĭ
rā4rŭ́ĕ
rā4rŭ́ĭ
r3ā4rúe
r3ā4rúi
rā́4cer
rā́4cĕr
r3ā́cr
4rā́ct
rā́i2
rā́3ic
rā́ĭ2
rā́3ĭc
rā́n4s5ī
rā́r2
r5ā́4rui
r5ā́4ruī
rā́4rŭī
rā́4rŭĭ
r4ā́t
2r1ăb
răb2ă
răb2ē
răb2ĕ
răb2ī
răbī3u
răbī3v
răb2ĭ
răbĭ3c
2răc
r1ăd
răd2ē
răd2ĕ
răd2ī
rădō5rō
ră3d2ŏ
2răf
2răg
ră3g2n
ră4gŏr
ră4grē
ră4grĕ
ră4grō
ră4grŏ
2răh
ră1ī2
răī4q
răī́4
ră3ĭē
ră3ĭī
2r1ăl
2rămā
2r3ă4mă
2răm3b2
rămbī5n
rămbī5u
rămbī5v
rămbī́5n
rămbī́5u
rămbī́5v
răm5bŭ
2rămī
4rămna
4r3ămnā
4r3ămnă
4rămná
4rămnæ
4rămnǣ
4rămnǽ
4r3ămnī
2rămo
2rămó
2rămœ
2rămp
2răng
2rănh
ră1ō
2răpĕ
2răpp
r2ă3q
2r1ă2r
răr3c
r4ăsĭ
ră4sn
ră4sp
ră4sq
răs5trī
ră4su
ră4sv
2rătt
r2ău
r2ăv
2rắb
rắb4ĭ
rắbĭ5c
2rắf
rắ3gn
rắm3b4
4rắmna
4r5ắmnā
4r5ắmnă
4rắmnæ
4rắmnǣ
4r5ắmnī
4rắpĕ
r3ắrd
r3ắrm
4r5ắs4tā
4r5ắs4tă
4r5ắstē
4rắstĕ
4rắs4tĭ
4rắstō
4rắtt
1r2á
ráb2i
rábi3c
2rábl
rá4cer
2r3á2cr
2ráct
4ráequa
4ráequā
4ráequă
r5áequen
4ráequē
4ráequo
4ráequō
4ráequŏ
2ráes
2r3áf
rá3g2n
r4ágr
rá3ian
rá3iā
rá3iǣ
rá3i2c
rá3ien
rá3iē
rá2iu
rá3li
2ráll
rám3b2
4r3ámna
4r3ámnā
4rámnæ
4rámnǣ
4r3ámni
4r3ámnī
2rámp
ráns5is
2rápe
2r3árd
4rá4rid
2r3árm
4r3á4r4ui
2r3ásp
4r3ás4ta
4r3ás4tā
4ráste
rás4tem
rás4tes
rás4tet
4r3ástē
rá5s4tic
4rástit
4rásto
4rástō
2rátt
2ráud
rá2xu
ræa2
ræă2
ræs2
ræ5sci
ræ5stō
r2æu
ræ3ue
ræ3uĕ
r2æ3v
rǣa2
rǣă2
rǣs2
rǣ5stō
r2ǣu
rǣ3ue
rǣ3uĕ
r2ǣ3v
r2ǣ́
1rǽ
4rǽqua
4rǽquā
4rǽquă
rǽ4quen
4rǽquē
4rǽquo
4rǽquō
4rǽquŏ
2rǽs2
r2ǽu
r2ǽv
2rb2
rba3q
rba3r
rbæ3
rbe1
r3bi
rbi3c
rbi3r
rbi5ti
rbī3r
rbī3u
rbī3v
rbī́3m
rbī́3r
rbĭ3c
rbĭ5tĭ
r3bí
rbí3m
rbí3r
rbí3to
rbí5tur
rbo3ri
rbs3
r3bu
r3bŭ
2rc2
r4chan
r2chă
rci6sta
rcum3
rcumi4
rcumī4
rcumí4
rcŭm3
rcŭmī4
rcú2m3
2rd2
rde4sc
rdē4sc
r3di
rdi4g3
r3do
rd4or
r3du
rd4ue
r3dŭ
rd4ŭĕ
re3a4tr
re3ā4tr
reā́4tr
re3á4tr
rec4e
re5cen
rec4é
re5cén
2red
re2da2
red7aman
re2dā
re4d3ea
re4d3eā
re4d3eá
re4d3eo
re4d3eō
re4d3eó
re4deú
re2dē
re4d3ii
re4d3iī
red5iít
re4d3i4r
re4diss
re4dist
red5i4tā
red5iti
redi4u
red5iuer
red5iué
red5iui.
red5iuim
red5iuin
red5iuiq
red5iuis
red5iuit
red5iuín
red5iuíq
red5iuís
red5iuít
re4di4v
red5iver
red5ivé
red5ivi.
red5ivim
red5ivin
red5iviq
red5ivis
red5ivit
red5ivín
red5ivíq
red5ivís
red5ivít
re4dīm
re4d3ī4r
re4d3īs
re4dīt
red5ī4te
red5ī4tō
red5ī4tu
red5ī4tú
re4d3ī4u
re4d3ī4v
re4dī́m
re4d5ī́4r
re4dī́s
red5ī́ss
red5ī́st
re4dī́t
red5ī́6te
red5ī́6tō
red5ī́6tu
red5ī́6ui
red5ī́6uī
red5ī́6vi
red5ī́6vī
re4d3íe
re4d3íi
re4d3í4r
re4díss
re4díst
red5í4to
redí4tu
red5í4ui
red5í4vi
re4dúl
re2er
ree3ri
ree3rí
re2es
3reē
r1ef
2r1eg
reg2l
re4gn
re3go
re3gō
re2ia
re2iā
re2iá
re3ic
re4ien
re2ii
re2iī
re2ií
re2io
re2iō
re2ió
re2iu
re2iú
re2ī
2r1el
re2le
re2lo
2remā
2reme
2remē
2remé
re4mic
4remim
re4mine
re4miné
4remis
2remī
4remím
re4míss
re4míst
4remít
4remo.
4remoq
4re4mor
4remou
4remov
4remō.
4remōq
4remōu
4remōv
4remóq
4remór
4remóu
4remóv
2remp
2remt
4remún
re5nar
re5nas
re5nau
re5nav
re1o
re1ō
repe3r
r2ere
r2eri
re3rin
re3riu
re3riv
3rerī
r2erí
re4rn
re4rq
2r3err
re4rv
re4sa
re2sá
re4so
re2só
re2sq
2ress
res2t
4rest.
4reste
re4ste.
re6stem.
re6stemn
re6stemq
re6stemue
re6stemv
re6s5tene
re4steq
re4stes
re4steu
re4stev
re4stēs
re6stḗs
re6stémn
re6stémq
re6stémue
re6stémv
re4stés
4resti
re4s5ti.
re6s5tine
re4s5tiq
re4stis
resti5t4
re4s5tiv
re4s5tī.
re6s5tīne
re4s5tīq
re4s5tīs
re4s5tīu
re4s5tīv
re6s5tī́ne
re6s5tī́q
re6s5tī́s
re6s5tī́u
re6s5tī́v
4restí
re6s5tíne
re4s5tíq
re4stís
restí5t4
re4s5tíu
re4s5tív
4restn
4r3esto
4r3es3tō
4r3estó
4restq
4r3estu
4restv
re4su.
r4esue
re4sum
re4sun
re4suq
re4suu
re4suv
re4súm
re4sún
re4súq
re4súu
re4súv
rete5re
2reun
re4uol
reu5sum
reu5sus
2reún
re3únc
re4vol
2r1ex
r2exé
rexi4t
re4xiu
re4xiv
re2x3ī4
rexī́4
rexí4t
rexí4ui
rexí4vi
re2xu
1rē
2rēbu
2rēbŭ
2rēg
rē2gr
rē2iā
rē2iu
rē2iú
2r1ē2l
r2ē3la
r2ē3lă
2rē2me
rē3men
4rēmēr
2rē2mĕ
rē3mĕn
4r3ē4mér
4rē4mic
4rē4mim
rē4mine
rē4minē
rē4miné
4rē4mis
4rēmit.
4rēmitn
4rēmitq
4rēmitu
4rēmitv
4rē4mĭc
4rē4mĭm
r5ē4mĭnē
rē4mĭnĕ
4rē4mĭs
4rēmĭt.
4rēmĭtn
4rēmĭtq
4rēmĭtu
4rēmĭtv
rē4mĭ́n
4rē4mĭ́t
4rē4mín
4rē4mít
2rē2mo
2rē2mŏ
2rē2mó
2rēmp
2rēmt
2rēna
2rē2nă
rē3ne
rēpe3r
rēpĕ3r
r2ēri
2rēro
2rērŏ
2r3ē4sa
2rē2sā
2rē2să
2rē2sá
2rēsæ
2rēsǣ
2rēsǽ
r2ēsc
2rē2se
2r3ē2sĕ
2rēsō
2rēss
2rēst
rēs3tĭ
r2ē2su
2rēsū
2rē2sŭ
2rēsú
2rēu
rē2uo
rē2uŏ
2rēv
rē2vo
rē2vŏ
rḗ3b
rḗ3ic
rḗ3ĭc
4rḗ4le
4r3ḗ4lĕ
r3ḗlŏ
4r5ḗ4mer
4r5ḗ4mĕr
4rḗ4mim
rḗ6mine
rḗ6minē
6rḗmit.
4rḗ4mĭm
r5ḗ6mĭnē
r5ḗ6mĭnĕ
6rḗmĭt.
4rḗ4mo
4r3ḗ4mŏ
4rḗmp
4rḗmt
rḗ4nat
rḗ4năt
4r3ḗro
4r3ḗrŏ
r4ḗsc
rḗ4se
r3ḗ4sĕ
4rḗss
4rḗst
r4ḗsu
rḗ4sŭ
4rḗ4uo
4r3ḗ4uŏ
4rḗ4vo
4r3ḗ4vŏ
r4ĕān
r4ĕāq
rĕ3ā4tr
r4ĕāu
r4ĕāv
rĕā́4tr
rĕ2ă
r4ĕă.
r4ĕăq
r4ĕău
r4ĕăv
2rĕd
rĕ2dā
rĕ2dá
rĕ2dē
rĕ4d3ĕā
rĕ4d3ĕă
rĕ4d3ĕō
rĕ4dīm
rĕ4d3ī4r
rĕ4d3īs
rĕ4dīt
rĕd5ī4tĕ
rĕd5ī4tō
rĕd5ī4tŭ
rĕ4d3ī4u
rĕ4d3ī4v
rĕ4dī́m
rĕ4d5ī́4r
rĕ4dī́s
rĕd5ī́ss
rĕd5ī́st
rĕ4dī́t
rĕd5ī́6tĕ
rĕd5ī́6tō
rĕd5ī́6tŭ
rĕd5ī́6uī
rĕd5ī́6uĭ
rĕd5ī́6vī
rĕd5ī́6vĭ
rĕ4d3ĭ4c
rĕd5ĭĕr
rĕ4d3ĭī
rĕ4d3ĭĭ
rĕd5ĭtā
rĕd5ĭtă
rĕ4d5ĭ́ĕ
rĕ4d5ĭ́ĭ
rĕ4dĭ́t
3rĕē
r1ĕf
2r1ĕg2
rĕ3gō
rĕ2ī
rĕ2ĭĕ
2rĕmā
2rĕmē
2rĕmĕ
2rĕmī
2rĕmĭ
4r3ĕmnē
4r3ĕmnī
4r3ĕmnĭ
2rĕmŏ
2rĕmŭ
rĕ5nĕ.
2r3ĕnn
rĕ1ō
r2ĕq
rĕ5quĕ
r2ĕr
rĕ3r4ĕ
2r3ĕrr
2r3ĕrŭ
rĕ1s
rĕs3cĭ
rĕs2p
rĕs2t
r2ĕt
rĕ5uĕ.
2rĕŭ
rĕ5vĕ.
2r1ĕ2x3
rĕ4xă
rĕxī4
rĕxī́4
2rĕ́d
rĕ́4d5ĕā
rĕ́4d5ĕă
rĕ́4d5ĕō
rĕ́4d3ī
rĕ́4d5ĭī
rĕ́4d5ĭĭ
2rĕ́f
4rĕ́mĕ
4rĕ́mĭ
4r5ĕ́mnē
4r5ĕ́mnī
4r5ĕ́mnĭ
4r5ĕ́nnā
4r5ĕ́nnă
4r5ĕ́nnē
4r5ĕ́nnĕ
4r5ĕ́nnī
4r5ĕ́nnō
2r3ĕ́2q
4r3ĕ́rr
rĕ́3sp
rĕ́5s4tā
rĕ́5s4tă
rĕ́5s6tĕnt
rĕ́5s6tĕt
rĕ́5strŭ
2r3ĕ́2x3
1ré
2réd
ré4d3ea
ré4d3eā
ré4d3eo
ré4d3eō
ré4d3iī
ré2d3ī
ré2e
2r1éf
2ré2le
2ré2lo
4rémer
4rémic
4rémim
4r5é4mine
4rémit.
4rémiti
4rémito
4rémitō
4rémitu
4r3émnē
4r3émni
4r3émnī
2rémo
ré4mor
2rémp
2rémt
ré4nat
4r3énna
4r3énnā
4rénne
4r3énnē
4r3énnī
4r3énno
4r3énnō
4réqui
r2ér
2réro
2r3érr
ré2ru
2ré4sa
2résæ
4ré4se.
2réso
ré3sp
2réss
ré3s4ta
ré3s4tā
4réste
ré5s6tent
ré5s4tet
4résti
ré5stit
4réstn
4r3ésto
4r3éstō
4réstq
rés4tru
4r3éstu
4réstv
r2é2su
4résu.
4résum
4résus
2r3é2uo
2r3é2vo
ré4xeu
ré4xiē
ré4x3is
ré2xī
ré2xu
2rf
2rg2
r3ge
r3gĕ
r1h
r2hy
r2hý
ri2a
r2ia.
r2iae
r2iam
r2ian
r2iaq
r2iar
r2ias
r2iat
ri3atr
r2iau
r2iav
r2ia͞
r2ia͡
r2iā
2riă
r2iáe
r2iám
r2ián
r2iár
r2iás
r2iát
ri3átr
r2iáu
r2iáv
r2iæ
r2iǣ
r2iǽ
2ribe
2ribē
ri4bē.
3riboe
3riboē
3riboé
ri5bus
ri5bús
ri4cie
ri4ciē
ri4cié
ri4cim
ri4cio
ri4ciō
ri4ció
4ricit
r3i4cím
r3i4cít
3ricl
r2icu
r2icú
2rido
ri4don
2ridō
ri4dōn
2ridó
r2ieb
3riei
3rieí
r2iem
r2ien
ri3enn
r2ies
r2iet
r2iēb
3riēī
r2iēm
r4iēri
r4iērí
r2iēs
r2iēt
r4iḗb
r4iḗm
r4iḗne
r4iḗq
r4iḗri
r4iḗs
r4iḗt
r4iḗu
r4iḗv
2riĕ
r2iéb
3riéi
r2iém
r2ién
ri3énn
r4iéris
r2iés
r2iét
ri3ga
ri3gæ
ri3gǣ
ri4g3n
r4iis.
r4iisn
r4iisq
r4iisu
r4iisv
r2iīs
r4iī́s
r4iísn
r4iísq
r4iísu
r4iísv
2rij
r1il
3rile
3rilé
5rille.
5rillen
5rilleq
5rilli.
5rilliq
5rillis
5rilliu
5rilliv
3rillī
5rillíq
5rillís
5rillíu
5rillív
3rillo
3rillō
3rilló
5rillum
5rillus.
5rillusn
5rillusq
5rillusu
5rillusv
5rillúm
5rillúsn
5rillúsq
5rillúsu
5rillúsv
3rim.
3rimed
3rimel
5rimetr
3rimēd
3rimēl
5rimḗd
5rimḗl
3ri5méd
3ri5mél
5rimétr
ri3min
3rimn
3rimq
4rimun
ri3mur
r4i3mus
r2imú
ri3múr
ri3mús
3rimv
ri2ni
rin3ic
ri2n3ī2
rinī́4
ri4n3í4c
r3inq
rinte5r6
rinteri5
rinterī5n
rinterī5q
rinterī5u
rinterī5v
rinterī́5
rinterí5u
rinterí5v
3rinth
ri2nu
ri4nún
r2i2o
r2iō
r2ió
r2ip
ri3pi
r2iq
ri2ra
ri2rá
ri3r4e
rir6emi
ri3r4ē
ri5rē5m
3rirrh
1r2is
ri3sa
ri4sat
ri3sá
ri4sát
ri4s3p
ris5pe
ris5pé
ris5ti
ri6stri
ri4sui
ri4suí
r2ita
r4itāt
r2itá
r4i5ter
r2ité
ri5tér
3rith
r2iti
3ritia
3ritiá
3ritiæ
3ritiǽ
3ritii
3ritií
5ritior
r5itiō.
r5itiōn
r5itiōq
r5itiōu
r5itiōv
5ritiór
5ritiss
5ritius
3ritiú
r2ití
3ritía
5ritíss
ri5tōt
3ritt
r4itue
r4iue.
2riug
r4ium.
r4iumn
r4iumq
r4iumu
r4iumv
r4iunt
r2ius
2riŭ
r4iúnt
r2iús
r4ive.
rī3āt
2rīb
rī4c5ĕ́n
rī4cén
2rīg
r2īm
rīmi3
r2īne
r4īnĕ
r2īq
2r3ī2rā
r2īs.
r2īsn
r2īsq
r2īsu
r2īsv
r2īt
r2īu
r4īue.
r4īuĕ.
r4īus
r2īv
r4īve.
r4īvĕ.
2rī́b
rī́3d
r2ī́m
r4ī́ne
r4ī́nĕ
r2ī́q
r2ī́t
r4ī́uĕ.
r4ī́vĕ.
1rĭ
rĭ4bē.
r2ĭc
rĭ3cē
rĭ3cĕ
rĭ3cī
2rĭcĭ
rĭ4cĭă
rĭ4cĭē
rĭ4cĭĕ
rĭ4cĭm
rĭ4cĭō
rĭ4cĭŏ
rĭ4cĭŭ
rĭ3cŭ
2rĭdă
2rĭdō
rĭ4dōn
r2ĭē
r4ĭē.
r4ĭēq
r4ĭēu
r4ĭēv
r2ĭĕ
r4ĭĕ.
r4ĭĕn
rĭ3ĕnn
r4ĭĕq
r4ĭĕu
r4ĭĕv
rĭ5ĕ́nn
rĭ3ga
rĭ3gæ
rĭ3gǣ
2rĭi
2r1ĭĭ
2rĭj
2r1ĭl
3rĭle
3rĭlé
3rĭllĕ
3rĭllī
3rĭllō
3rĭllŭ
4rĭmăr
4rĭmăt
2r3ĭmb
4rĭmēb
4rĭmēm
4rĭmēr
4rĭmēs
4rĭmēt
4rĭmḗb
4rĭmḗm
4rĭmḗr
4rĭmḗs
4rĭmḗt
4rĭmĕt
5rĭmĕtr
5rĭmĕ́tr
4rĭmĭm
4rĭmĭs
4rĭmĭt
4rĭmĭ́
2rĭmm
2rĭmŏ
2rĭmp
4rĭmŭn
4rĭmŭ́n
rĭ2n1
rĭ3nā
2r3ĭnc
2r3ĭnd
2rĭni
2r3ĭnī4
rĭnī́4
2r3ĭnĭ
rĭnĭ́4
2rĭnj
2r3ĭnq
rĭntĕ5r
rĭntĕrĕ5r
rĭntĕrī5n
rĭntĕrī5q
rĭntĕrī5u
rĭntĕrī5v
rĭntĕrī́5
5rĭnth
2rĭnu
2rĭnŭ
2rĭnv
rĭ2ŏ
2rĭpē
2r1ĭr
rĭ3r4ē
rĭ5rē5m
3rĭrrh
rĭ3s4ă
rĭ4sp
rĭs5pĕ
rĭs5tĭ
rĭ5strŏ
r2ĭt
4r5ĭ4tĭō.
4r5ĭ4tĭōn
4r5ĭ4tĭōq
4r5ĭ4tĭōu
4r5ĭ4tĭōv
2rĭu
2rĭv
r2ĭ́c
rĭ́3cĕ
4r5ĭ́4cĕr
4rĭ́cĭ
rĭ́4cĭā
rĭ́4cĭă
rĭ́4cĭē
rĭ́4cĭĕ
rĭ́4cĭm
rĭ́4cĭō
rĭ́4cĭŏ
rĭ́4cĭŭ
4rĭ́mĕr
4rĭ́mĭm
4rĭ́mĭt
rĭ́2n
r3ĭ́nc
4r3ĭ́nd3
r3ĭ́n3ĭ4
2r3ĭ́r
r4ĭ́s
4r5ĭ́4tĭō
1rí
2ríb
4r3í4cer
2ríci
rí5ci.
rí4ciā
rí4ciē
rí4cim
rí4cio
rí4ciō
rí5cis
r2ícu
rí3d
2rída
rí3ga
rí4g3n
2ríj
4rílli
4rímer
4rímim
rí3min
4rímit
2rímm
r2ímu
2rínc
2rín2d3
4rí4n3i4c
2rínj
2ríns
4rínte
r2íq
2rírr
rís3t
rí4sui
r2ít
4rítio.
4r3í4tiō
rí2xu
2rj
2rl2
r3lu
2r1m2
rmĭ2ă
rmí5tur
2r1n2
r3ne
rne3g
r3nĕ
rnĕ3g
rn4i3m
rn4ĭ3m
rní5ci
1ro.
ro3áq
rob2a
rob2e
rob2ē
rob2é
ro3b2i
rob2ī
rob2í
ro3b2o3
rob2ó
rob3r
r1oc
ro2da
ro4deo
ro4d5e4ra
ro4d5e4rá
rod5e6rim
rod5e6rit
rod5e6rít
ro4d5e4ro
ro4d5e4ró
ro4d5e4ru
ro4d5e4rú
rod5est
ro6d5é6rim
ro6d5é6rit
rod5ést
ro4d3ie
ro4d3ié
ro4d3ii
ro4d3ií
ro4dio
ro4diō
ro4dió
ro4d3i4r
rod5iss
rod5ist
ro4d3i4u
ro4d3i4v
ro4d3íe
ro4d3íi
ro4d5í4mu
ro4d3í4r
rod5íss
rod5íst
rod5í6te.
ro6d5í6tis
ro4d5í4to
rodí4tu
rod5ítur
rod5í4ui
rod5í4vi
ro4em
ro4en
ro3eo
ro3eō
ro3eó
ro4eq
ro4es
ro4ev
ro2ē
ro2é
ro4ia.
ro4iae
ro4iam
ro6iane.
ro4iaq
ro4iar
ro4ias
ro4iau
ro4iav
ro4ia͡
ro4iáe
ro4iám
ro6iáne.
ro4iár
ro4iás
ro4iáu
ro4iáv
ro2iæ
ro2iǽ
ro4iis.
ro4iisn
ro4iisq
ro4iisu
ro4iisv
ro3iī
ro4iísn
ro4iísq
ro4iísu
ro4iísv
ro3it
ro4ium
ro4ius
ro4iús
roī4n
roī2q
roī́4n
roī́4q
roí2t
roí2u
roí2v
2r1ol
ro2le
ro2lē
ro2lé
ro4li.
ro4lin
ro4liq
ro4lis
ro4liu
ro4liú
ro4liv
ro2lí
ro2l4u
ro2lú
r2on
ro3ni
rons3
ro2pe3
ro2pé
1roq
ro2ra
ro2rá
r3ord
ro4rer
ro4ret
ro4rén
ro4rér
ro4rét
ro4ro.
ro4ron
ro4roq
ro4ror
ro4rou
ro4rov
ro4rón
ro4róq
ro4rór
ro4róu
ro4róv
r2os
ro3s2c
ro2s3m
ro3só
ro3s2t
ro4s3ui
ro4s3uí
1rou
1rov
1ro͞
1ro͡
rō4d5e4ra
rō4d5e4rā
rō4d5e4rá
rōd5e6rim
rōd5e6rit
rōd5e6rít
rō4d5e4rō
rō4d5ĕ4rā
rō4d5ĕ4ră
rōd5ĕ6rĭm
rōd5ĕ6rĭt
rōd5ĕrĭ́t
rō4d5ĕ4rō
rō6d5ĕ́6rĭ
rō4d5é4ri
rō4d3ie
rō4d3iē
rō4d3ié
rō4d3ii
rō4d3iī
rō4d3ií
rō4d3ī4m
rō4d3ī4r
rō4d3īs
rō4d5ī4te
rō4d5ī4tĕ
rō6d5ī6tis
rō6d5ī6tĭs
rō6d5ī6tĭ́s
rō6d5ī6tís
rō4d5ī4tō
rō4d5ī4tu
rō4d5ī4tŭ
rō4d5ī4tú
rō4d3ī4u
rō4d3ī4v
rō4d5ī́4m
rō4d5ī́4r
rōd5ī́ss
rōd5ī́st
rō6d5ī́6te
rō6d5ī́6tĕ
rō6d5ī́6tis
rō6d5ī́6tĭs
rō6d5ī́6tō
rō6d5ī́6tu
rō6d5ī́6tŭ
rōd5ī́6ui
rōd5ī́6uī
rōd5ī́6uĭ
rōd5ī́6vi
rōd5ī́6vī
rōd5ī́6vĭ
rō4d3ĭē
rō4d3ĭĕ
rō4d3ĭī
rō4d3ĭĭ
rō4d5ĭ́ĕ
rō4d5ĭ́ĭ
rō4d3íe
rō4d3íi
rō4ia.
rō4iae.
rō6iaene
rō6iaeque
rō6iaeue
rō6iaeve
rō4iam
rō4ian
rō4iaq
rō4iau
rō4iav
rō6ia͞e.
rō6ia͞ene
rō6ia͞eque
rō6ia͞eue
rō6ia͞eve
rō6iá͞ene
rō6iá͞eque
rō6iá͞eue
rō6iá͞eve
rō6ia͡e.
rō6ia͡ene
rō6ia͡eque
rō6ia͡eue
rō6ia͡eve
rō6iá͡ene
rō6iá͡eque
rō6iá͡eue
rō6iá͡eve
rō4iā.
rō6iāne.
rō6iāque
rō4iāru
rō4iārú
rō4iās.
rō6iāsne
rō6iāsque
rō6iāsue
rō6iāsve
rō4iāue
rō4iāve
rō6iā́ne.
rō6iā́que
rō6iā́ru
rō6iā́sne
rō6iā́sque
rō6iā́sue
rō6iā́sve
rō6iā́ue
rō6iā́ve
rō6iáene
rō6iáeque
rō6iáeue
rō6iáeve
rō4iám
rō4iæ.
rō4iæne
rō6iæque
rō4iæue
rō4iæve
rō4iǣ.
rō4iǣne
rō6iǣque
rō4iǣue
rō4iǣve
rō6iǣ́ne
rō6iǣ́que
rō6iǣ́ue
rō6iǣ́ve
rō4iǽne
rō6iǽque
rō4iǽue
rō4iǽve
rō4iī.
rō4iīn
rō4iīq
rō4iīs.
rō6iīsne
rō6iīsque
rō6iīsue
rō6iīsve
rō4iīu
rō4iīv
rō4iī́n
rō4iī́q
rō6iī́sne
rō6iī́sque
rō6iī́sue
rō6iī́sve
rō4iī́u
rō4iī́v
rō2iō
rō4ium
rō4ius
rō4iús
rō2le
rō2lē
rō2lĕ
rō2lé
rō4lis
rō4liu
rō4liú
rō2lī
rō4lĭs
rō4lĭŭ
rō4lĭ́
rō2lí
r2ōn
rō2ra
r3ō2rā
r3ō2ră
rō2rá
2rōrd
rō4rer
rō4ret
rō4rēm
rō4rēr
rō4rēt
rō4rĕr
rō4rĕt
rō4rén
rō4rér
rō4rét
rō2ro
rō4rō.
rō4rōn
rō4rōq
rō4rōu
rō4rōv
r3ō2rŏ
rō2ró
2rōs2c
2rōt
rṓ6d5e6ra
rṓ6d5e6rā
rṓd5e6rit
rṓ6d5e6rō
rṓ6d5ĕ6rā
rṓ6d5ĕ6ră
rṓd5ĕ6rĭt
rṓ6d5ĕ6rō
rṓ4d5iē
rṓ4d5ii
rṓ4d5iī
rṓ4d5ĭē
rṓ4d5ĭī
rṓ4d5ĭĭ
rṓ2l
rṓ4lĕ
r3ṓ4ra
r3ṓ4rā
r3ṓ4ră
4rṓrd
rṓ4rer
rṓ4ret
rṓ4rĕr
rṓ4rĕt
r3ṓ4ro
r3ṓ4rō
r3ṓ4rŏ
4rṓsc
rṓ5stĭ
2rṓt
rŏb2ē
rŏb2ĕ
rŏb2ī
rŏb2ŏ
rŏ2bŭ
r1ŏc
r1ŏd
rŏ2dĭ
rŏ2ē
rŏī2n
rŏī4q
rŏī́4n
rŏī́4q
rŏ3ĭ2
rŏĭ́4
2r1ŏl
rŏ2lē
rŏ2lĕ
rŏ2lŭ
rŏm2ĕ
r2ŏn
rŏ2pŭ
1r2ŏr
r2ŏs
r2ŏ́
rŏ́3ĭ
rŏ́4lĕ
rŏ́4lŭ
rŏ́m2
4rŏ́t
1ró
rób2e
2rócc
ró4d5e4ra
ród5e6rit
ró4d5e4ro
ró4d3ie
ró4d3ii
ró3eo
ró3eō
ró3iī
ró3in
ró4ium
ró4ius
2ról2
ró2le
ró4li.
ró4lis
ró4liu
ró3m
róm4e
ró1r
2ró2ra
2r3órd
ró4rer
ró4ret
4rórna
4rórno
2ró2ro
2ró3sc
ró3sta
ró3ste
ró3sti
ró3sto
rós3ue
ró4sui
2rót
1rœ
rœ̄3d
2rp
rpe2i
rpe3r
rper4e
rper4ē
rpĕ3ră
rpĕ3rĕ
rpo1
2rq
r3qu
2r1r2
rra3d4
r3ră
r3re
rre2o
rre3r
rres3t
rrex2
rre5xi
r3rē
r3rĕ
rrĕ4s3t
rr4ĕ́
rrĕ́3q
r3ru
2r1s2
r3se
rsed4
rse5di
rse2i
rsēd4
rsē5di
rsē5dĭ
rsē2i
r3sĕ
r3si
rs4ig
rsĭ3gĕ
r2s3q
r3st
r2s3ue
r2s3uĕ
2rt
r3ta
rta3g
r3tā
rte3r
rte5re
rtĕ3rĕ
r3ti
r3tī
rtran4
rtrān4
rtrāns5
rua6ste
ruā6ste
ruā6stĕ
2r1uă
2ruæ
2r1uǣ
2ruǽ
ru3b2
rubī3q
rubī́3
2ru3d
r1ue
4rue.
r4uera
r4uerā
r4uerá
r4ueri
r4uerī
r4uerí
r4uero
r4uerō
r4ueró
r4ueru
r4uerú
ruete5
r4uēru
r4uērú
2r3uĕ
ru4gn
r1ui
rui4g3n
r2uim
r4uiss
r4uist
r2uit
r1uī
2ruīs
r4uīv
2r1uĭ
ruí4g3n
r2uíq
r4uíss
r4uíst
r2uít
1r2ul
1r2um
rum2e
ru3m2ī
ruol6uere.
ruol6uerene
ruol6uereq
ruol6uereu
ruol6uēre
ruol6uēru
ruol6uērú
ruol6uḗre
ruol6uḗru
ruol6uit.
ruol6uitn
ruol6uitq
ruol6uitue
2ruŏ
ruól6ui.
ruól6uit.
ruól4uī
rupe3r
ruperi5mus
ruperi5mú
ruperi5ti
ruperi5tí
r1u2r
ru4rs
1rus
ru2sp
2russ
2rust
4rusur
2rusú
ru2tr
ru3tu
r1uu
2ruŭ
ru2xu
rū3d
r1ūn
r1ūr
rū2ra
rū2rā
rū2ră
rū2rá
rū2rē
rū2rī
rū2ro
rū2rō
rū2rŏ
rū2ró
rū2ru
rū2rŭ
rū2rú
rū4sp
rū2ti
rū2tĭ
rū2tí
rū3tu
rū2xu
r4ū́g
rū́4ra
rū́4rā
rū́4ră
rū́4re
rū́4rē
rū́4rĕ
rū́4rī
rū́4ro
rū́4rō
rū́4rŏ
rū́4ru
rū́4rŭ
rŭb2
rŭ3bī
rŭ2bĭ
2rŭd
1rŭl
r2ŭm
rŭ3mă
rŭm2ĕ
rŭ3m2ī
r3ŭnd
r3ŭng
r1ŭr
3rŭsī
3rŭsĭ
rŭs2p
rŭ4tĕr
2rŭtr
r2ŭ́
rŭ́3b
r3ŭ́ng
r3ŭ́r
3rŭ́sĭ
rŭ́3sp
1rú
r2úe
rú4gn
r2úi
r2úl
r2úm
2rúnc
2rúng
2rúnx
2r1úr
rú2ra
rú2re
rú2ro
r2úsi
r2úsq
2rúss
2rúst
rú2tr
rú2xu
2rv2
rva6ste
rvā6ste
rvā6stĕ
r3ve
rvete5
r3vĕ
rvi4g3n
rví4g3n
2r2x
1sa
2saa
sab4a
sab3ea
sab3eā
sab3eá
sab3eo
sab3eō
sab3eó
sab3iī
sab3i4n
sab3i4q
sabi4te
sabi4to
sabi4tó
sabi4u
sabi4v
sa2bī4
sabī́4
sab3í4n
sab3í4q
sabí4t
sab3í4u
sab3í4v
sab2o
s1ac
sa2ci
2s1a2d3
sa3do
s2ae
sa2i
sali4g5
salí4g3
s3alp
sa2l3u
s2am
sa3ma
3s2an
s2a3q
s2ar
sa3re
s2as
sa4tro
sa4tró
sa4tru
sa4trú
s4aue
s3aus
s4a͞e
s4á͞
s4a͡e
s4á͡
1sā
sā5bun
2s1āc
sā2i
2s3ā́c
sā́4tr
1să
2săă
2s1ăb
săb2ă
să2bĕ
să2bī4
săbī́4
să2b3ĭ
s1ăc
să2cĭ
2s1ă2d3
să3g
s3ălp
să3rĕ
sắb3ĕ
sắb3ĭ
s3ắd
1sá
sá4b3ea
sáb3eā
sá4b3eo
sáb3eō
sá4bi.
2sá2bī
2s1ác
2s1á2d1
s2áe
sá2lu
s2ám
s2án
s2ár
s3átr
sá4tri
sá4tro
sá4tru
s2áu
1s2æ
sæ2a
sæ2ă
sæ2á
sæ2i
sæ2ŭ
1sǣ
sǣ2a
sǣ2ă
sǣ2ŭ
1s2ǽ
2sb2
s3bi
sbī3u
sbī3v
s3bu
s3bŭ
2scam
2scas
2scā
2scám
2scás
1s2cæ
1s2cǣ
2sce.
2sceb
2scem
s6ce6naria.
s6ce6narian
s6ce6nariaq
s6ce6nariau
s6ce6nariav
s6ce6narium
s6ce6nariúm
s6ce6naría
s6ce6nária.
s6ce6nárium
s6cendamus
s6cendamú
s6cendant
s6cendat
s6cendámus
s6cendánt
s6cendát
s6cendeb
s6cendem
s6cender
s6cendes
s6cendet
s4cendē
s4cendé
s6cendim
5s6cendiss
5s6cendist
s6cendit
s6cendím
5s6cendíss
5s6cendíst
s6cendít
s6cendun
s6cendún
s4c5enna
s4c5enná
6scens.
6scensn
6scensq
6s7censue
6scensv
2sceq
2scer
2sces
2scet
2sceu
2scev
2scēb
2scēm
s6cē6nāria.
s6cē6nārian
s6cē6nāriaq
s6cē6nāriau
s6cē6nāriav
s6cē6nārium
s6cē6nāriúm
s6cē6nārĭă.
s6cē6nārĭăn
s6cē6nārĭăq
s6cē6nārĭău
s6cē6nārĭăv
s6cē6nārĭŭm
s6cē6nārĭŭ́m
s6cē6nārĭ́ă
s6cē6nāría
s6cē6nā́ria.
s6cē6nā́rium
s6cē6nā́rĭă.
s6cē6nā́rĭŭm
2scēs
2scēt
2scĕ.
2scĕq
2scĕr
2scĕt
2s3cĕu
2s3cĕv
2scéb
2scém
s6céndant
s6céndar
s6céndat
s6céndens
s6céndent
s6cénder
s6céndes
s6céndet
s4céndē
s6céndim
s6céndit
s6céndor
s6céndun
2scér
2scés
2scét
2s3ch
3s4cho
3s4chŏ
3s2cia
3s2ciā
s2ciá
3s2ciǣ
3scid
5s6ciderā
5s6ciderī
5s6ciderō
5s4cidē
s7cidis.
s7cidisn
s7cidisq
5scidissē
5scidistī
s7cidisu
s7cidisv
5s4cidī
5scidíssē
5scidístī
3s2cie
3s2ciē
s2cié
3s2cii
3s2ciī
s2cií
3scind
3s2cio
3s2ciō
s2ció
s2cir
4scisa
4scisá
4scisæ
4scisǽ
4scise
4scisé
4scisi
4scisí
4sciso
4scisó
4scisu
4scisú
s4citæ
s4citǽ
s2ciu
s2ciú
s2civ
2scīd
s2cīm
s2cīr
s2cīt
s2cīu
s2cīv
3s2cĭā
3s2cĭă
3s2cĭǣ
3s2cĭd
3s2cĭē
3s2cĭĕ
3s2cĭī
3s2cĭĭ
3scĭnd
3s2cĭō
3s2cĭŏ
4s5cĭs.
4s5cĭsn
4s5cĭsq
4s5cĭsu
4s5cĭsv
3s2cĭŭ
3s4cĭ́d
5scĭ́nd
s2cía
3scíd
5s6cíderā
5s6cíderī
5s6cíderō
s2cíe
s2cíi
s4címu
3scínd
s2cír
4scísa
4scísæ
4scíse
4scísi
4scíso
s4cíta
s4cítæ
s4cíti
s4cíto
s4cíui
s4cívi
2s3c2o
sco3p
2scō
2sc2ŏ
scŏ3p
2s3có
2s3cœ
3s4crib
3scrip
s5cris
3scrīb
3scrīp
s3crīs
5scrī́b
5scrī́p
s5crī́s
s2crí
3scríb
3scríp
s3crís
2scun
s2cū
2scún
2sd
sde3d
sde2s
sdē2s
sdĕ3d
s3do
sd4or
1se
se3b
3sec
se3d2
sed4i3m
se4d3i4t
se5dit.
se5ditn
se5ditq
se5d4itu
se5ditv
sedí4t
se4d5íti
sed4o
sed4u
se2e
s1eg
se2gi
se2gí
se2gn
se2iā
se2ie
se2ié
se4in
se4iq
se4ir
se4iv
se3íp
3sem
semi5as
semi5ás
se4m5iss
se4m5íss
se4mul
s2en
3sep
s2e3q
s2e1r
ser2a
ser2æ3
ser2ǣ
se3rē
ser4i
seri5c
se3rī
se3rō
ser2u
3ses
ses3q
2se2un
se2ur
s1eú
s2ev
se2xe
se2xé
se2xi
se3x4ie
se3x4iē
1sē
sēdĕ4c3
sēdi2
sē4d3it
sē5dit.
sē5ditn
sē5ditq
sē5ditu
sē5ditv
sēdĭ2
sē4d3ĭt
sē5dĭt.
sē5dĭtn
sē5dĭtq
sē5dĭtu
sē5dĭtv
sēdĭ́4
sē6d5ĭ́tĭ
sēdí2
sē4d5íti
2s1ē2g
sē2ie
sē2iē
sē4ir
s2ēm
sēmi5ās
sēmi5ā́s
sē4m5is.
sē4m5isn
sē4m5isq
sēm5iss
sē6m5isue
sē4m5isv
sēmĭ5ās
sēmĭ5ā́s
sē4m5ĭs.
sē4m5ĭsn
sē4m5ĭsq
sēm5ĭss
sē4m5ĭsu
sē4m5ĭsv
sē6m5ĭ́sn
sē6m5ĭ́sq
sēm5ĭ́ss
sē6m5ĭ́su
sē6m5ĭ́sv
sē4m5ísn
sē4m5ísq
sēm5íss
sē4m5ísu
sē4m5ísv
sē2mū
sē3ne
sēs4cō
sēs3q
sēs3t
2s3ḗ2g
sḗmi3
sḗ4m5is
sḗmĭ3
sḗ4m5ĭs
1sĕ
sĕ2ă
sĕ3d
sĕd4ĭ3
sĕp4tĕ́
sĕ3r2a
sĕ3ră
sĕ3r2æ
sĕ3r2ǣ
sĕ3rē
sĕ3r4ĕ
sĕ3rī
sĕ3rō
sĕ3rŏ
sĕ3rū
sĕ3rŭ
sĕ2s
2sĕŭ
sĕ2x3ĕ
sĕx2ĭ
sĕ́3ră
sĕ́x4ĭ
1s2é
s1é2g
sé4ir
3sém
sémi3
sé3q
3sés
sé3x4ie
séx4iē
sg2
s3ga
s3gæ3
s3gǣ
1si
s2i2a
2si2ba
2si2bá
2si2be
2si2bé
si3bi
si4bis
si4bit
si4bís
si4bít
2si2bo
2si2bó
si4bun
si4bún
s1ie
3sie.
s1iē
3siē.
2siĕ
2siéc
2s3i2ga
2s3i2gā
2s3i2gá
2s3i2gē
2s3igé
2s3i2gi
2s3i2gī
2s3i2gí
si4g3n
2s3i2go
2s3i2gō
2s3i2gó
2s3i2gu
2s3i2gú
s3iít
3s2il
si5lum
si5lus
3sim
si3mus
s2in
sin2ā
sino3p
si2o
sio2s
2s1ir
si2re
si2ré
si2rí
si4s3t
sis5ta
sis5tā
sis5ti
s1iu
3s2ium
2siun
2s3iur
s2ius
s2i3uu
2s3iū
2siŭ
2s3iún
1sī
2s1ī2b
s3ī2mi
s3ī2mĭ
2s1īr
sī2re
sī2rē
sī2rĕ
sī2ré
sī2rī
sī2rí
sī4st
s3ī́2b
sī́4mi
sī́4mĭ
sī́4mur
sī́4mŭr
s3ī́r
sī́4re
sī́4rē
sī́4rĕ
sī́4rī
sī́4tur
sī́4tŭr
1sĭ
3sĭa
3sĭā
3sĭă
3sĭæ
3sĭǣ
s2ĭb
3sĭē.
3s4ĭĕ.
s4ĭĕn
s4ĭĕq
s4ĭĕu
s4ĭĕv
sĭ2g
2s3ĭgā
2s3ĭgă
2s3ĭgē
2s3ĭgī
2s3ĭgĭ
2s3ĭgō
2s3ĭgŏ
2s3ĭgŭ
3sĭī
2s1ĭĭ
s2ĭn
sĭn2a
sĭn2ā
sĭn2æ
sĭs3
sĭ4st
sĭs5tā
sĭs5tă
sĭs5tĭ
sĭ4́g
4s3ĭ́4gĭ
2s3ĭ́ĭ
s2ĭ́n
sĭ́s3
1sí
2sí2ba
2sí2be
sí3bi
sí4bis
sí4bit
2sí2bo
sí4bun
2s3í2gi
síg3n
s2íl
sí4mur
sí2nu
2s1ír
sí2re
sí4s3t
2sj
s1m2
2s3me
2s3mé
2s1n2
s3ne
s3nĕ
snŭ́3
1s2o
so3b2
so4l3ue
sol3ué
so4l3ui
so4l3uī
so4l3uí
3so1n
so3ni
son2u
3so3p
sos2p
1sō
sō4lue
sō2s3p
sṓ4s
1s2ŏ
sŏ3b2
sŏl4lĕ
3sŏn
sŏs2
1s2ó
2sód
sól2l
só2s
sp2
3sparg
3spars
3spărg
3spărs
5spắrg
5spắrs
3spárg
3spárs
spár4ui
4spe.
s2pec
4s3pem
4spen
4speq
spe3r4a
speras7c
sper4ā
spe3r4æ
spe3r4ǣ
sper4ǽ
spe5rem
spe5req
spe5rer
spe5r4es
spe3r4ē
sper4é
s4perg
speri4b
sper5i4m
speri4r
spe5r4it
spe4r5ī4m
spe4rī4r
sperī́6m
sperī́6r
spe4r5í4m
spe4rí4r
3s4pern
spe3r4o
spe3rō
sper4ó
s4pers
spe3rū
2spes
4speu
4spev
s2pex
4spĕ.
s2pĕc
4s3pĕm
4spĕn
4spĕq
spĕ3r4a
spĕ3r4æ
spĕ3r4ǣ
spĕ3rē
spĕ4rĕā
spĕ4rĕă
spĕ4r5ĕō
spĕ5rĕq
s4pĕrg
spĕ4r5ī4m
spĕ4r5ī4r
spĕrī́6m
spĕrī́6r
spĕ4r5ĭĕ
3s4pĕrn
spĕ3rō
spĕ3rŏ
s4pĕrs
spĕ3rū
spĕ3rŭ
2spĕs
4spĕu
4spĕv
s4pĕ́c
4spĕ́n
s6pĕ́rnē
s6pĕ́rnō
s6pĕ́rnŭ
s4pĕ́rs
4spĕ́s
s4pĕ́x
4s3pém
2spén
spé4r5ea
spé4r5eā
spé4r5eo
spé4r5eō
spé4ri.
s4pérno
s4pérs
4spés
s2péx
s2phæ
s2phǣ
s2phǽ
4sphen
4sphén
s2phr
s3pi.
4spia
s3pib
s3pin
s3pio
s3piō
s3pió
s3piq
s2pir
2spit
s3piu
s3piú
s3piv
s2pī
4spĭă
s3pĭb
2spĭt
s3pĭŭ
4spĭ́t
s2píc
s3pín
s3píq
2spít
s3píu
s3pív
2spn
s2pod
3s2pol
3spond
2s3pos
2spōs
1spŏ
s2pŏd
s2pŏl
2spŏr
2spŏs
s4pŏ́l
4spŏ́s
s2pód
3s2pól
2s3pós
2spub
s2pue
s2puē
s2pué
s2pui
s2puī
s2puí
s3pus
s2pŭē
s2pŭĕ
s2pŭī
s2pŭĭ
s3pŭm
s3pŭs
2spúb
s2púe
s2púi
s3pús
s2qua
s2quā
2s3que
2squĕ
s3qui
s1r2
2s1s2
s3sa
s3sā
s3să
s3sá
s3sæ
s3sǣ
s3sǽ
s3se
ssed4
sse5di
s3sē
ssēd4
ssē5di
ssē5dĭ
ss4ēm
s3sĕ
s3sé
ssér4ui
ssér4uī
s3si
ssi3l4
s3sī
s3sí
ssíl2
s3su
ssupe5rí
2st.
4s5taté
s5tatib
4s5tātē
4s5tāté
s5tātib
s5tātĭb
st2ă
s2tág
st4án
s5tátib
ste2ī
4stemí
ste3r4a
ste3rǣ
ste5re
ste5ré
4sterg
ste3r4i
ster6i5c
steri5ue
steri5v
ste5rī
sterī5u
sterī5v
5s4terne
5sternē
5sterné
5s4terno
5s4ternō
5s4ternó
5s4ternu
5s4ternú
ste3ro
ste3rō
4sterr
4sters
3s4tete
3steté
5s4teti.
5stetim
5s4tetin
5s4tetiq
5stetit
5s4tetiu
5s4tetiv
5s4tetín
5s4tetíq
5stetít
5s4tetíu
5s4tetív
4stēmí
3s4tēte
3stētē
3s4tētĕ
3stēté
5stētim
5stētit
3stētī
5stētĭm
5stētĭt
5stētít
5s4tḗte
5stḗtĕ
5stḗtim
5stḗtit
5stḗtī
5stḗtĭm
5stḗtĭt
stĕ2ī
stĕ3r4a
stĕ3rǣ
stĕ3rĕ
4stĕrg
stĕ5rī
stĕrī5u
stĕrī5v
stĕ5r4ĭ
stĕrĭ5c
5stĕrnē
5s4tĕrnĕ
5s4tĕrnĭ
5s4tĕrnō
5stĕrnŏ
5s4tĕrnŭ
4stĕrr
4stĕrs
stĕ3rŭ
3s2tĕs
6stĕ́nta
6stĕ́ntā
6stĕ́ntă
6stĕ́ntæ
6stĕ́ntǣ
6stĕ́ntĕ
6stĕ́ntī
6stĕ́ntō
6stĕ́ntū
4stĕ́rg
5s6tĕ́rnē
5s6tĕ́rnĭ
5s6tĕ́rnō
5stĕ́rnŏ
5s6tĕ́rnŭ
4stĕ́rr
4stĕ́rs
4stérg
stéri5t
5s4térnē
5s4térni
5s4térno
5s4térnō
5s4térnu
4stérr
4stérs
3s4téte
5stéti.
5stétim
5stétit
s2t1h
2s3tia
2s3tiā
2s3tiá
s2tib
sti4bi.
sti4bī
4s3tibu
4s3tibú
2stic
2s3tim
3s4timu
3s4tinā
3s4tinc
3s4ting
3s4tinō
3s4tinx
2s3tio
2s3tiō
2s3tió
s2tip
3s2tir
s3tis
s2tit
3stitǣ
3stitū
2s3tiu
2s3tiú
3s4tīnc
3s4tīnx
s4tī́nc
2s3tĭā
s3tĭă
stĭ4bī
4s3tĭbŭ
2stĭc
2s3tĭm
3stĭnā
4stĭnāx
3s4tĭnă
4stĭnē.
4stĭnēn
3s4tĭng
3s4tĭnō
3s4tĭnŏ
2s3tĭō
s2tĭp
3stĭr
2s3tĭs
s2tĭt
3stĭta
5stĭtā.
5stĭtān
3stĭtă
3stĭtá
3stĭtæ
3stĭtǣ
3stĭtǽ
5stĭtĕm
5stĭtĕt
5stĭtīs
5stĭtŭm
2s3tĭŭ
4s3tĭ́m
5stĭ́mŭ
5s4tĭ́ng
3s4tĭ́r
4s3tĭ́s
s3tía
2stíc
2s3tím
3s4tínc
3s4tíng
3s4tínx
s2típ
s3tís
s2tl
2stn
2stoc
2stor
2s3tot
2stōr
s3tōt
st4ṓ
4stṓr
2stŏc
4stŏ́c
2stóc
4stóre
4stóri
2s3tót
2stq
4strac
4strah
stra3p4
4strax
4stra͞
4stra͡
4strāx
4strā́x
4s5tră.
4s5trăm
s5trănĕ
4s5trăq
4s5trău
4s5trăv
s5trắm
4strác
4stráh
4stráx
s3træ
s3trǣ
s3trǽ
s3tri.
5strict
3strig
s5trine
s3triq
4s3tris
s3triu
s3triú
s3triv
4striz
s3trī.
s3trīq
4s3trīs
s3trīu
s3trīv
5strĭct
3s4trĭē
3s4trĭĕ
3strĭg
3strĭn
4strĭz
5strĭ́ct
5strĭ́gĭ
5strĭ́gŭ
5strĭ́n
5stríct
5strígi
5strígu
5stríng
5strínx
s3tríq
4s3trís
s3tríu
s3trív
4stríz
2stro
3s4trom
3strop
2strō
3s4trōm
5strṓm
2stró
3stróm
4strud
4strus
4strūd
4strūs
4strū́d
4strū́s
s5trŭm
s5trŭ́m
4strúd
4strús
2strȳ
2strý
s4tue.
s4tuĕ
2stul
3s2tup
s3tur
2stū
4stŭl
3s2tŭp
3s4tŭ́p
2stúl
2stún
s2túp
2stúq
2s3túr
2stúu
2stúv
2stv
1s2ty
1stȳ
1s2tý
s1u
1su.
3s2uam
3s2uan
3s2uar
3s2uas
3s2uat
1s2uā
1s2uá
1s2u2b1
su5ber.
sube4ra
su5bera.
su5berane
su5beraq
su5berau
su5berav
sube4rá
su5beren
su5beri.
su5berib
su5beriq
sube6ris
su5beriu
su5beriv
su5beríq
sube6rís
su5beríu
su5berív
su5bern
sube4ro
sube4ró
su5berq
su5berue
su5berv
sub3es
sub3ē
subḗ4
su5bérib
su5bérn
su5bérq
su5béru
su5bérv
sub3és
subi4
sub3is
sub3it
subí4
sub3ís
sub3ō
1su3d
2sue.
3s2ueb
3s2uem
3s2uen
3s2ueq
3s4uera
3s4uerā
3s4uerá
3s4uere
3s4uerē
3s4ueré
3s4ueri
3s4uerī
3s4uerí
3s4uero
3s4uerō
3s4ueró
3s4ueru
3s4uerú
3s2ues
3s2uet
3s2ueu
3suev
1s2uē
2suēx
4suḗx
3s2uĕn
3s2uĕq
3s2uĕu
3suĕv
1sué
s2uéb
2suéc
2suéh
s2uém
s2uén
4suérb
s4uére
s4uéri
4suérs
4suért
s4uéru
s2ués
s2uét
s2uéu
2suéx
1sug
1s2ui
s3uir
s2uī.
3s2uīn
3s2uīq
3s2uīu
3suīv
1s2uí
1s2ul
2sulm
1s2um
su3ma
sum2e
su3mun
1s2un
3s2uo.
3s2uon
3s2uoq
3s4uor.
3s4uorn
3s4uorq
3s4uoru
3s4uorv
3s2uou
3s2uov
1s2uō
3s2uón
3s2uóq
3s4uórn
3s4uórq
3s4uóru
3s4uórv
3s2uóu
3s2uóv
3sup
supere6ri
supe6re6rí
supe6res
supe4rē
supe6rés
supe6ri.
super5im
supe6riq
super5it
superī́6
supe4rí4
super5ím
super5ít
supé6r5es
1suq
1s2ur
1sus
su3spi
su3spí
1s2ut
1s2uu
1s2uŭ
1s2uú
1s2uv
1sū
sūbe3
sū3d
2sūri
2sūrĭ
2sūrí
sū2su
sū3sum
1sŭ
sŭ2b1
sŭb3ē
sŭbḗ4
sŭbī4
sŭbī́4
sŭbĭ2
sŭbĭ́4
sŭb3ō
2sŭlm
sŭpĕ4rē
sŭ5pĕ́
sŭs4pĭ
sŭ́b3
sŭ́bĭ4
sŭ́5bĭă
sŭ́5bĭīs
sŭ́5bĭō
sŭ́5bĭŭ
sŭ́3sp
1s2ú
sú2b1
sú5ber.
sú5bera.
súbe6ran
súbe6ras
súbe6rat
sú5bere
sú5beri.
súbe6ris
súbe4ro
súb3es
súbi2
súb3is
súb3it
sú3lui
sú3luī
súm2i
sú1r
sú3sp
2sv
s3ve
s3vĕ
1sy
sy2lu
1sȳ
1sý
1t
t2a
tab2
ta4c3ue
tad2
2ta2g
ta4g3n
ta3go
ta2i
ta3ma
ta3q
tasce4
tascé4
ta3s2p
tas5te
ta2s3u
5tatem
5tates
3tatém
3tatés
t2ā
tā5bun
2tāg
5tātem
5tātĕm
5tātĕ́
5tā́tē
tăd2
2tă2g
tă4gĭ
tă3gŏ
tămĕ4n
t2ăn
tă3rĕ
t2ăs
tă3s2p
tăs3pĕ
tăs3pĭ
tăs3t
tăs5tĕ
tăs4trŏ
tá4c3ue
tá2ge
tá2s3u
5tátem
5tátes
t2æ
t2ǣ
tǽ2cu
2tc
t2e
te1a
te2a͞
te2a͡
te4gn
te3go
te3gō
te3gr
te3iss
te3it
te2iu
te1ī
te3íp
te3íss
te3í2t
te4nim
te4nt
te5ra.
te3rab
te5rami
ter3ap
te5raq
te5rara
te5rará
te5rarem
te5raren
te5rarer
te5rares.
te5raresn
te5raresq
te5raresu
te5raresv
te5raret
te5rarém
te5rarén
te5rarér
te5rarésn
te5rarésq
te5rarésu
te5rarésv
te5rarét
te5rari
te5raro
te5raró
te5raru
te5rarú
te3ras
te3rat
te5rau
te5rav
ter3a͞
ter3a͡
ter5ā́c
te3r4æq
te3r4ǣq
te4r3ea
te4r3eā
te4r3eá
te6r5e6mi.
te6r5emine
te6r5e6miq
te6r5e6miu
te6r5e6miv
te4r5e4mí
te4r5e4mo
te4r5e4mō
te4r5e4mó
te4r3eo
te4r3eō
te4r3eó
te4r3eq
te4re4ra
te4re4rā
te4re4rá
te6r5erim
te6r5erit
te6r5e6rít
te4re4ro
te4re4rō
te4re4ró
te6r5erun
te4re4rú
ter5est
te4rēmē
te4r5ē4mī
te4rēmí
te3rēu
te3rēv
te6r5ḗ6mī
te4r5é4me
te6r5é6mi.
te6r5é6mit
te4r3éq
te6r5é6rim
te6r5é6rit
ter5ést
ter5ibo
ter5ibun
ter5ibún
ter5ice
te3rid
ter5iēn
ter5ime
ter5imē
ter5imé
ter4imi
ter5imo
ter5imō
ter5imó
ter4imu
ter4imú
ter4ine
teri5ni
ter4iq
teri4r
ter4is.
ter4isn
ter4isq
te4r5iss
te4r5ist
ter4isu
ter4isv
ter4it.
ter5i6ta.
ter5i6tae
ter5i6tam
ter5i6tan
ter5i6taq
ter5i6tar
ter5i6tau
ter5i6tav
ter5i6ta͞
ter5ita͡
ter5i6tā.
ter5i6tān
ter5i6tāq
ter5i6tār
ter5i6tāu
ter5i6tāv
ter5i6táe
ter5i6tám
ter5i6tán
ter5i6táq
ter5i6tár
ter5i6táu
ter5i6táv
ter5itæ
ter5i4tǣ
ter5itǽ
ter4ite
ter5i6ti.
ter5i6tin
ter5itio
ter5itiō
ter5itió
ter5i6tiq
ter6itis
ter5i6tiu
ter5i6tiv
ter5i4tī
ter5i6tín
ter5i6tíq
ter6itís
ter5i6tíu
ter5i6tív
ter4itn
ter6ito.
ter6iton
ter6itoq
ter6itor.
ter6itorn
ter6itorq
ter6itorue
ter5itorum
ter5i6torú
ter6itorv
ter5i6tos
ter6itot
ter6itou
ter6itov
ter6itō.
ter6itōn
ter6itōq
ter5i6tōr
ter5i6tōs
ter6itōu
ter6itōv
ter6itṓn
ter6itṓq
ter5i6tṓr
ter5i6tṓs
ter6itṓu
ter6itṓv
ter6itón
ter6itóq
ter6itórn
ter6itórq
ter6itórue
ter5itórum
ter6itórv
ter5i6tós
ter6itót
ter6itóu
ter6itóv
ter4itq
teri4tu
ter5itu.
ter5itum
ter5itun
ter5ituq
ter5itur
ter6itur.
ter6iturn
ter6iturq
ter6iturue
ter6iturv
ter5itus
ter5ituu
ter5ituv
ter5i4tū
ter5i6túm
ter5i6tún
ter5i6túq
ter5i6túra
ter5itúræ
ter5i6túre
ter5i6túri
ter6itúrn
ter5i6túro
ter6itúrq
ter6itúrue
ter5itúrum
ter5itúrus
ter6itúrv
ter5i6tús
ter5i6túu
ter5i6túv
ter4itv
teri4u
ter5iue
ter3i4v
te4r5ī4mi
te3r4īn
ter6īne
ter4īq
ter6īqu
te4rī4r
te4r5ī4te
te4r5ī4to
te4r5ī4tō
te4r5ī4tó
te4r5ī4tu
te4r5ī4tú
te4r3ī4u
ter6īue.
te4r3ī4v
ter6īve.
terī́6mi
ter6ī́n
ter6ī́q
te4rī́4r
terī́6te
terī́6to
terī́6tō
terī́6tu
ter6ī́ue.
terī́6ui
terī́6uī
ter6ī́ve.
terī́6vi
terī́6vī
te4r5íme
te6r5í6mur
te4rí4r
te4r5íss
te4r5íst
te4r5í4ta
te6r5í6te.
ter5ítio
te4r5í4to
te6r5ítur
ter6íue.
ter5í6uer
te4rí4ui
ter6íve.
ter5í6ver
te4rí4vi
te4rn
4ternām
4ternē
4terné
4ternim
4terním
4ternít
te3rop
te5rorn
4terot
4terōt
te3rōu
te3rōv
te4róni
4terót
te4rq
te4rr
te4rt
ter3uē
ter3uí
ter3ū2
te4rv
te2sq
2t3ess
4test.
te5s4ta.
te5stabam.
te5stabamn
te5stabamq
te5stabamue
te5stabamus
te5stabamús
te5stabamv
te5stabant.
te5stabantn
te5stabantq
te5stabantue
te5stabantv
te5stabas
te5stabat.
te5stabati
te5stabatí
te5stabatn
te5stabatq
te5stabatue
te5stabatv
te5stabámn
te5stabámq
te5stabámue
te5stabámus
te5stabámv
te5stabántn
te5stabántq
te5stabántue
te5stabántv
te5stabás
te5stabáti
te5stabátn
te5stabátq
te5stabátue
te5stabátv
te5stabimus
te5stabimús
te5stabis
te5stabit.
te5stabiti
te5stabití
te5stabitn
te5stabitq
te5stabitue
te5stabitv
te5stabís
te5stabít
te5stabo.
te5stabon
te5staboq
te5stabou
te5stabov
te5stabón
te5stabóq
te5stabóu
te5stabóv
te5stabunt.
te5stabuntn
te5stabuntq
te5stabuntue
te5stabuntv
te5stabúntn
te5stabúntq
te5stabúntue
te5stabúntv
te5stamus
te5stamús
te5stane
te5stant.
te5stantn
te5stanto.
te5stanton
te5stantoq
te5stantou
te5stantov
te5stantō
te5stantón
te5stantóq
te5stantóu
te5stantóv
te5stantq
te5stantue
te5stantv
te5s4taq
te5starem.
te5staremn
te5staremq
te5staremue
te5staremus
te5staremús
te5staremv
te5starent.
te5starentn
te5starentq
te5starentue
te5starentv
te5stares
te5staret.
te5stareti
te5staretí
te5staretn
te5staretq
te5staretue
te5staretv
te5starémn
te5starémq
te5starémue
te5starémus
te5starémv
te5staréntn
te5staréntq
te5staréntue
te5staréntv
te5starés
te5staréti
te5starétn
te5starétq
te5starétue
te5starétv
te5stat.
te5statn
te5statot
te5statót
te5statq
te5statue
te5statv
te5s4tau
te5s4tav
te5s4tā.
te5stābam
te5stābant.
te5stābantn
te5stābantq
te5stābantue
te5stābantv
te5stābat
te5stābāmus
te5stābāmús
te5stābās
te5stābāti
te5stābātí
te5stābā́mus
te5stābā́s
te5stābā́ti
te5stābám
te5stābántn
te5stābántq
te5stābántue
te5stābántv
te5stābát
te5stābimus
te5stābimús
te5stābis
te5stābit.
te5stābiti
te5stābití
te5stābitn
te5stābitq
te5stābitue
te5stābitv
te5stābís
te5stābít
te5stābō
te5stābunt.
te5stābuntn
te5stābuntq
te5stābuntue
te5stābuntv
te5stābúntn
te5stābúntq
te5stābúntue
te5stābúntv
te5stāmus
te5stāmús
te5stāne
te5s4tāq
te5stārem
te5stārent.
te5stārentn
te5stārentq
te5stārentue
te5stārentv
te5stāret
te5stārēmus
te5stārēmús
te5stārēs
te5stārēti
te5stārētí
te5stārḗmus
te5stārḗs
te5stārḗti
te5stārém
te5stāréntn
te5stāréntq
te5stāréntue
te5stāréntv
te5stārét
te5stātōt
te5stātṓt
te5s4tāu
te5s4tāv
te5stā́bam
te5stā́ban
te5stā́bat
te5stā́bā
te5stā́bimus
te5stā́bis
te5stā́bit.
te5stā́biti
te5stā́bō
te5stā́bu
te5stā́mus
te5stā́ne
te5stā́q
te5stā́rem
te5stā́rent
te5stā́ret
te5stā́rē
te5stā́u
te5stā́v
te5stábam
te5stában
te5stábas
te5stábat
te5stábimus
te5stábis
te5stábit.
te5stábiti
te5stábo.
te5stábu
te5stámus
te5stáne
te5stántn
te5stánto.
te5stántō
te5stántq
te5stántue
te5stántv
te5s4táq
te5stárem
te5stárent
te5stáres
te5stáret
te5státn
te5státq
te5státue
te5státv
te5s4táu
te5s4táv
te5stemus
te5stemús
te5stent.
te5stentn
te5stentq
te5stentue
te5stentv
te6ster
te5stet.
te5steti
te5stetí
te5stetn
te5stetq
te5stetue
te5stetv
te5stēmus
te5stēmús
tes4tēt
te5stēti
te5stētí
te5stḗmus
te5stḗti
te5stémus
te5sténtn
te5sténtq
te5sténtue
te5sténtv
te5stéti
te5stétn
te5stétq
te5stétue
te5stétv
tes3ti
4testn
4t3estō
4testq
4t3estu
4testv
te2su
tete5r
2teté
4tetim
4tetit
4tetít
te2un
te3x4e
tex2i
tex2ī
tex2o
tex2ó
tex2u
tex2ú
t2ē
tē2ie
tē2iē
tē3ne
tēte3
2tētē
2tēté
4tētim
4tētit
2tētī
4tētĭm
4tētĭt
4tētít
4tḗtī
t2ĕ
3tĕa
3tĕă
3tĕæ
3tĕǣ
3tĕē
3tĕĕ
tĕ3gō
tĕ3gr
3tĕ1ī
tĕ3ĭ
3tĕl
t3ĕ2nĭ
3tĕō
3tĕ1ŏ
tĕ3q
t4ĕr.
tĕr5ā́c
tĕ5ră.
tĕ3răr
tĕr5ắp
tĕ3r4æq
tĕ3r4ǣq
tĕ4rēmē
tĕ4r5ē4mī
tĕ6rēmĭ́
tĕ3rēu
tĕ3rēv
tĕ6r5ḗ6mī
t4ĕrĕ
tĕ4r3ĕā
tĕ4r3ĕă
tĕ3rĕn
tĕ4r3ĕō
tĕ4r3ĕŏ
tĕ4r5ĕ4rā
tĕ4r5ĕ4ră
tĕ4rĕ4rĭ
tĕr5ĕrĭm
tĕr5ĕrĭt
tĕr5ĕrĭ́t
tĕ4r5ĕ4rō
tĕ6r5ĕ́6rĭ
t4ĕrī
tĕ3rī.
tĕ3rīn
tĕ3rīq
tĕ4r3ī4r
tĕ3rīs
tĕ4r3ī4u
tĕ4r3ī4v
tĕrī́4r
tĕr3ĭē
tĕ4r3ĭĕ
tĕ4r5ĭ4mē
tĕ4r5ĭ4mō
tĕ4r5ĭ4ta
tĕr5ĭ6tā.
tĕr5ĭ6tān
tĕr5ĭ6tāq
tĕr5ĭ6tār
tĕr5ĭ6tāu
tĕr5ĭ6tāv
tĕ4r5ĭ4tă
tĕ4r5ĭ4tá
tĕ4r5ĭ4tæ
tĕ4r5ĭ4tǣ
tĕ4r5ĭ4tǽ
tĕ4r5ĭ4tī
tĕ6r5ĭ6tĭō
tĕ6r5ĭ6tōr
tĕ6r5ĭ6tōs
tĕ6r5ĭ6tṓr
tĕ6r5ĭ6tṓs
tĕ4r5ĭ4tū
tĕ6r5ĭ6tŭm
tĕ6r5ĭ6tŭs
tĕ6r5ĭ6tŭ́m
tĕ6r5ĭ6tŭ́s
tĕr5ĭ́ĕr
tĕ6r5ĭ́mĕ
tĕ6r5ĭ́6tă
tĕ6r5ĭ́tĭ
t4ĕrn
4tĕrnām
4tĕrnăr
4tĕrnăt
4tĕrnē
4tĕrnŏ
4tĕrōt
t4ĕ3rŏ
t4ĕrq
t4ĕru
tĕr3ū2
tĕ3rŭs
t4ĕrv
2t3ĕss
4t3ĕst.
tĕ5stā.
tĕ5stābāmŭs
tĕ5stābāmŭ́s
tĕ5stābās
tĕ5stābātĭ
tĕ5stābā́mŭs
tĕ5stābā́s
tĕ5stābā́tĭ
tĕ5stābăm
tĕ5stābănt.
tĕ5stābăntn
tĕ5stābăntq
tĕ5stābăntu
tĕ5stābăntv
tĕ5stābăt
tĕ5stābắm
tĕ5stābắntn
tĕ5stābắntq
tĕ5stābắntu
tĕ5stābắntv
tĕ5stābắt
tĕ5stābĭmŭs
tĕ5stābĭmŭ́s
tĕ5stābĭs
tĕ5stābĭt.
tĕ5stābĭtĭ
tĕ5stābĭtn
tĕ5stābĭtq
tĕ5stābĭtu
tĕ5stābĭtv
tĕ5stābĭ́s
tĕ5stābĭ́t
tĕ5stābō
tĕ5stābŭnt.
tĕ5stābŭntn
tĕ5stābŭntq
tĕ5stābŭntu
tĕ5stābŭntv
tĕ5stābŭ́ntn
tĕ5stābŭ́ntq
tĕ5stābŭ́ntu
tĕ5stābŭ́ntv
tĕ5stāmŭs
tĕ5stāmŭ́s
tĕ5stānĕ
tĕ5stāq
tĕ5stārēmŭs
tĕ5stārēmŭ́s
tĕ5stārēs
tĕ5stārētĭ
tĕ5stārḗmŭs
tĕ5stārḗs
tĕ5stārḗtĭ
tĕ5stārĕm
tĕ5stārĕnt.
tĕ5stārĕntn
tĕ5stārĕntq
tĕ5stārĕntu
tĕ5stārĕntv
tĕ5stārĕt
tĕ5stārĕ́m
tĕ5stārĕ́ntn
tĕ5stārĕ́ntq
tĕ5stārĕ́ntu
tĕ5stārĕ́ntv
tĕ5stārĕ́t
tĕ5stātōt
tĕ5stātṓt
tĕ5stāu
tĕ5stāv
tĕ5stā́bā
tĕ5stā́băm
tĕ5stā́băn
tĕ5stā́băt
tĕ5stā́bĭmŭs
tĕ5stā́bĭs
tĕ5stā́bĭt.
tĕ5stā́bĭtĭ
tĕ5stā́bō
tĕ5stā́bŭ
tĕ5stā́mŭs
tĕ5stā́nĕ
tĕ5stā́q
tĕ5stā́rē
tĕ5stā́rĕm
tĕ5stā́rĕnt
tĕ5stā́rĕt
tĕ5stā́u
tĕ5stā́v
tĕ5stănt.
tĕ5stăntn
tĕ5stăntō
tĕ5stăntq
tĕ5stăntu
tĕ5stăntv
tĕ5stăt
tĕ5stắntn
tĕ5stắntō
tĕ5stắntq
tĕ5stắntu
tĕ5stắntv
tĕ5stắt
tĕ5stēmŭs
tĕ5stēmŭ́s
tĕ5stētĭ
tĕ5stḗmŭs
tĕ5stḗtĭ
tĕ5stĕnt.
tĕ5stĕntn
tĕ5stĕntq
tĕ5stĕntu
tĕ5stĕntv
tĕ6stĕr
tĕ5stĕt
tĕ5stĕ́ntn
tĕ5stĕ́ntq
tĕ5stĕ́ntu
tĕ5stĕ́ntv
tĕ5stĕ́t
4t3ĕstn
4t3ĕstō
4t3ĕstq
4t3ĕstu
4t3ĕstv
2tĕtr
3tĕŭ
tĕx2ă
tĕx2ĕ
tĕx2ī
tĕx2ĭ
tĕx2ŏ
tĕx2ŭ
tĕ́3ĭ
tĕ́5răr
tĕ́4r5ĕā
tĕ́4r5ĕă
tĕ́4r5ĕō
tĕ́4r5ĕŏ
tĕ́6r5ĕ6rā
tĕ́6r5ĕ6ră
tĕ́6r5ĕ6rĭt
tĕ́6r5ĕ6rō
tĕ́6r5ĭēn
tĕ́6r5ĭ6ta
tĕ́r5ĭ6tā.
tĕ́6r5ĭ6tă
tĕ́6r5ĭ6tæ
tĕ́6r5ĭ6tǣ
tĕ́6r5ĭ6tī
tĕ́6r5ĭ6tōs
tĕ́6r5ĭ6tū
tĕ́6r5ĭ6tŭm
tĕ́6r5ĭ6tŭs
6tĕ́rnăr
6tĕ́rnăt
6tĕ́rnĕr
6tĕ́rnĕt
4tĕ́rnŏ
5tĕ́stā
tĕ́5stā.
tĕ́5s4tă
tĕ́5stĕnt
tĕ́5stĕt
tĕ́x4ĭ
té4gn
té3iī
té4r3ea
té4r3eā
té4r3eo
té4r3eō
té4r5era
té4r5e4rā
té6r5erit
té4r5e4ro
té4r5erō
tér5ien
tér5iēn
té4r5im.
téri4ta
tér5ita.
tér5itae
tér5itam
tér5ita͞
tér5ita͡
tér5i6tā.
té4r5i4tæ
té4r5i4tǣ
té6r5i6ti.
té4r5i4tī
té6r5i6tos
té6r5i6tōs
té6r5i6tu.
té6r5i6tum
té6r5i6tus
té4r5i4tū
té2rī
4térnar
4térnat
4térner
4térnes
4térnet
té2ru
2t3éss
5tésta
té5s4ta.
té5stant
té5s4tat
5téstā
té5s4tā.
té5stent
té5s4tet
4téti.
4tétim
4tétit
téx2i
téx2u
2tf
2tg
2th.
3t2he
the2i
3t2hē
thē2i
3t2hĕ
3t2hé
3thī
3thĭă
3thĭī
3thĭō
3thĭŭ
3thl
2thm
2thn
3tho
tho3sp
3thō
thŏ3sp
3thó
2thp
3thr
3thu
3thú
t2i
tiad2
3tiae
3tia͞
3tia͡
ti2á
ti4ám
3tiæ
3tiǣ
3tiǽ
ti3b
tibe3
t3ibi.
t3ibī
3tic
tic4e
ti5cen
4tiche
ti4c3ue
ti4d3ea
ti4d3eā
ti4d3eo
ti4d3eō
2tigi
2till
3tilo
3tiló
ti3m2
ti4mn
ti4mq
ti4mv
tin2ā
5tināx
tin2u
ti2o
ti3q
ti2s
ti3s2p
ti4sper
ti3sta
ti3stā
ti3s4te
ti3s4tē
ti3s4té
ti3s4to
ti3s4tō
ti3s4tó
ti3s4tr
ti3t2
ti4tn
ti4tq
ti4tv
ti3uu
2tīgi
2tīgĭ
2tīp
tī3q
tī́3q
t2ĭ
3tĭa
3tĭá
3tĭæ
3tĭǣ
3tĭǽ
2t3ĭbī
4tĭchĕ
3tĭcŭ
tĭ4d3ĕā
tĭ4d3ĕō
2tĭll
3tĭlŏ
tĭn2ā
tĭ2ŏ
2tĭr
tĭ3rĭ
tĭ3s2p
tĭ4spĕr
tĭ3stā
tĭs4tām
tĭs4tār
tĭ3stă
tĭs4tăt
tĭ3s4tē
tĭ3s4tĕ
tĭ3s4tō
tĭ3s4tŏ
tĭ3s4tr
3tĭt.
3tĭ́cŭ
tĭ́4d5ĕā
tĭ́4d5ĕō
4tĭ́mŭ
tĭ́3sp
tĭ́5s6tăt
tĭ́5s4tē
tĭ́5s4tĕ
tĭ́5stĭt
tĭ́5s4tō
tĭ́5s4tŏ
tĭ́5str
4tĭ́tă
4tĭ́tŭ
tí3b
3tíc
4tíche
tí4c3ue
tí4d3ea
tí4d3eā
tí4d3eo
tí4d3eō
4tígie
3tílo
tí1m
4tímul
tín4uī
tí3q
2tírp
tí2s
tí3sp
tís4tat
tí3s4te
tí3s4tē
tí3s4to
tí3s4tō
tí3s4tr
tís3u
4títer
4títib
4títim
4títua
4títuā
4títuē
4títui
4tí3tuī
4títuo
4títuō
tí3tur
4títuu
t2l
t3li
t3lī
t3lĭ
t3lí
2t1m2
tme1
tmĭ2
2t1n
t3ne
t2o
to3b2
to4cue
to2ia
to2iá
to2iæ
to2iǽ
to2ie
to2ié
to2ii
to2ií
to2í
2tola
tom2
ton3g4
tongæ3
tongǣ́5
tongǽ3
to3ni
to5ni5c
tons3t
ton2u
2t3o2pe
to3rī
tos3t
t2ō
tō3d
tō2ia
tō2iā
tō2iá
tō2iæ
tō2iǣ
tō2iǽ
tō2ie
tō2iē
tō2iī
tō2iō
tō2ĭ
2tōl
2tṓl
t2ŏ
tŏb2
tŏm2
tŏn3g4
tŏngæ3
tŏngǣ́5
tŏngǽ3
2t3ŏpĕ
tŏ3rĕ
tŏ3rī
tŏ́3rĭ
tó2cu
2tólo
tó2pe
2tp
tpo3
tpó1
2tq
t3qu
t2r2
trab2
tra3d4
tradi5ce
tradi5cé
tradi5ci
tradi5cí
trado3
tra3e4t
tra3g
tra3i4
3tral
tra5ma
tra5má
4trang
4tratē
trā3ĭ
tră3bŭ
trăd2
tră3g
4trăng
tră3s2
3trăt
4trătē
4trắng
trắ5st
trá3i
3trál
4tráng
trá3p2
trá2s3
træ2ă
trǣ2ă
3tre.
tre2i
tre5mi
tre5mo
2trep
3treq
3treu
3trev
trē2i
trē3m
trĕ2ĭ
2trĕp
4trĕ́p
2trép
3tria
3trib
tri5ci
4trict
4trida
4tridá
4tride
4tri5do
4tridó
2trig
3trige
3trigé
3trii
3triī
3trií
2tr4in
tri3ni
3trio
3triō
3trió
3trit
2trīd
2trīg
4trīnx
tr4ī́
4trī́d
4trī́g
4trī́nx
3trĭă
3trĭb
4trĭct
4trĭgĭ
4trĭgŭ
2tr4ĭn
3trĭs
3trĭt
3trĭŭ
4trĭ́ct
4trĭ́gĭ
4trĭ́gŭ
4trĭ́n
3tría
4tríct
4trída
4trído
4trídu
4trígi
4trígu
4tríng
4trínx
trí5tur
tro3e
4troph
trō4iē
4trṓm
4trŏph
trŏ2s
tró3ea
tró3eā
2tróm
4tróph
4truct
3trud
3trus
2trux
4trūct
3trūd
3trūs
2trūx
3trū́d
3trū́s
4trū́x
2trŭĭ
2trŭŏ
2trúc
3trúd
2trúi
3trús
2trúx
2t1s2
2tt2
tte2i
tte5re
ttē2i
ttĕ3r
3tua
3tuā
3tuá
tu2cu
tu2d3u
2t1ue
t2uea
t2ueā
t2ueá
t2ueb
3t2uem
3t2uen
tu3enn
t2ueo
t2ueó
3t2ueq
t2uer
3tuer.
3tuere
3tueri
3tuerí
3tuern
3tuerq
3tueru
3tuerv
3t2ues
3t2uet
3t2ueu
3tuev
3tuē
2t1uĕ
3tué
tu3énn
2t3uic
3tuīs
3tul
tule4i
tu3ma
tum2e
tu3m2ī
3t2uo
tuo2r
3tuō
3tuó
tupe3r4
ture5ia.
ture5iaq
ture5iau
ture5iav
ture5ii
ture5ií
ture5io
ture5ió
turé3
tu2sp
3tut
3tuun
tū2c1
tū2su
tū3sum
tū3sus
3tŭa
3tŭā
3tŭă
3tŭæ
3tŭǣ
3tŭc
3tŭē
3tŭĕ
3tŭl
tŭ3mă
tŭm2ĕ
tŭ3m2ī
tŭ3mĭ
tŭ3mŏ
3tŭō
3tŭŏ
tŭpĕ3r
tŭ2s
tŭ́3mĭ
tú2cu
tú2du
túm2i
2tv
t3ve
2tȳ
tý3l
uab2
uab4u
1uac
ua3d2
uad4o
uae4st
2uaev
u2a3g
ual4u
u2a1m
u2an
ua3p2
u2a3q
u2ar
u2as
uas3p
uas3t
uas5te
uas5tr
ua4sui
ua4suí
u2au
2uav
ua2x3
ua͞e4st
ua͡e4st
u2ā
1uād
2uāv
2uā́v
u2ă
uă3d2
uă3g
uă2m1
uăs3p
uăs5tr
2uăv
uắs3
1uác
1uád2
u2ág
u2ám
u2án
uá3p2
u2ár
uás3p
uá4sui
u2áu
2uáv
uá2x
2uæd
uæ2dī
uæ2dí
u2æq
uæ2s3t
u2æu
2u2æv
u2ǣq
uǣ2s3t
u2ǣu
2u2ǣv
uǣ́2d
uǣ́3r
2u1ǽ2d
u2ǽq
uǽ2s3t
u2ǽu
u2ǽv
uba3g
uba4i
ub2ă
ubá3g
ube2i
ube4rā
u5bere.
u5bereq
u5bereu
u5berev
ub4eris
ub4erís
ube4rō
u5berum
ubē2r
ubé4ia.
ubé4iae
ubé4iam
ubé4ias
ubé4ia͡
ubé4iæ
ubé4ii
u3bére
2ubi
ubi2b
ub3ice
ub4ii.
ub4iin
ub4iiq
ub4iiu
ub4iiv
ub4iín
ub4iíq
ub4iíu
ub4iív
u3biō
u3bió
ub2iq
ubi2u
ub4iue.
u3bium
u3biú
ubi2v
ub4ive.
u2bī2
ub2ī4n
ub2īq
ub4īue.
ub4īve.
ubī́2
ub4ī́4n
ub4ī́q
ub6ī́ue.
ub6ī́ve.
2ubí
ubí2b
ubí2c
ub2íq
ub3íss
ub3íst
ub4íue.
ub4íve.
u2bl
ubo2
u2bō
ubŏ3
u3b2œ
u2b1r
ub3s2
ub5ste
u3b2ul
u2b1ū
u3búl
2uc
u3ca
u3cá
u3ce
u3cé
u3ci
u3cí
u3c2o
uco2i
uco5n4i5
ucon4í
u3có
u3cr
u2c3ue
u3cun
u3cú
2ud
ud2ac
u3dam.
u3damq
u3damv
u2d3ap
u3da͡
ud2ā
u2dăp
u3dámn
u3dámq
u3dámv
u3dæ
u3dǽ
u3de.
u3dene
u3deq
ude2s3
ude6ste
u3deu
u3dev
udē2s
u3déne
u3déq
u3déu
u3dév
u3d2i
udi4g3
u4diso
u4disó
u3dí
ud2o
ud4or
u3dorú
u3dos
ud2ŏ
udŏ3p
u3dós
ud2u
u3dú
u2e1
ue2a
ue3b
ue3d2
ued4i
ue2e
2uef
ue2ī
ue2í
4uel.
2ueln
2uelq
2uelu
2uelú
2uelv
ue2ma
ue2má
ue4mui
ue4m3uí
ue4n3ea
ue4n3eá
ue4n3eo
ue4n3eó
ue4n3ii
ue4n3ií
ue4n3íi
2uenn
ue2o
ue2ō
uer2æ3
ue3r4e
ue5rem
uere5me
uere5mé
uer6e5mi
uere5mí
ue3r4ē
ue5rē5m
ue3rī
3uert
ue2s
ue3sá
ues3c
ue3sí
ue4s3p
ues5pe
ue4s3t
ues5tā
ues5te
ues5tr
uete5re
uete5ri
ueteri5u
uete5rī
ueterī5u
ueterī́7
ue2un
2uev
ue3x2
uex4e
uē3b
3uēnē
3uēné
3uēni
uē4n3iī
3uēnī
uē4nīs
uē4n3ĭī
3uēní
uē3r
uēs3t
3uēx
uḗ4n5iī
uḗ4n5ĭī
3uḗx
u2ĕ
uĕ2ă
uĕ2ĭ
uĕ2m3ă
uĕ3ră
uĕ3r4ē
uĕ5rē5m
uĕ3r4ĕ
uĕ3rī
uĕ3rŏ
uĕ3rŭ
uĕ2s3
uĕ4sp
uĕs5pĕ
uĕs5tĕ
2uĕv
uĕ3x2
uĕ́3ră
uĕ́3rĕ
uĕ́x2
u2é
1uéc
2uéf
1uéh
ué1i
1uél
ué4n3eo
3uéni
ué4n3ii
2uénn
2uéra
2uéro
3uérs
3uért
ués3
2uév
1uéx2
2uf
2ug
u3g2a
u3g2æ3
u3g2ǣ
u3g2l
u2g3n
u1h
u3hœ
ui2a
u2ic
3uice
ui4c5énn
1uif
uile3i
uilé3i
u2in
uin2ā
ui3oc
ui3o2p
ui3óp
ui3p2t
ui3r4i
ui3r4í
u2is
3uisc
ui3s2i
2uisv
uiu2
ui3ul
ui3uu
2uiv
u2ī
1uīc
uī4cen
uī4cĕn
uīc5ĕ́n
uī4cén
uī2ni
uī2n3ĭ
uī2ní
uī3p2
uī3q
uī3so
uī3sŏ
uī3u
2uī3v
uī́3p2
2uī́v
u2ĭ
uĭ3ăl
uĭn2a
uĭn2ā
uĭn2æ
uĭn2ĕ
uĭnĭ3t
uĭ1ŏ
uĭŏ2p
uĭŏ́2
uĭ3ŭl
uĭ́3ŏ4
u2í
1uíc
1uíf
1uíg
uí1m
uí3o2p
uí3p2t
3uísa
3uísæ
3uíse
3uísi
3uíso
uí3tur
2uív
1uíx
2u3læ
2u3lǣ
2u3lǽ
ule4ie
ule6ine
ule6iqu
ule6iue
ule6ive
ulē2i
3ulix
3u2líx
3ulm
ul3ua
ul3uá
ul3uæ
ul3uǽ
u4l3ue.
ul3uīs
ul3uó
u3lus
2um.
2uma
u3ma.
uma2g
u3m2an
u3maq
uma4tr
u3mau
u3mav
u3mā.
u3mān
u3māq
u3mār
u3mās
umā4tr
u3māu
u3māv
2u1mă
2umá
umá2g
u3mán
u3máq
u3már
u3máu
u3máv
u3mæ
u3mǣ
u3mǽ
um3b2
umb4e
umb4ē
umb4i
um5bit
umb6itu
umbi5tur
umbi5tú
umbí5te
2ume
u3me.
ume3d
ume5de
ume2g
ume2q
u3mev
umē2g
umḗ4g
umé2g
umi2b
umi2c
umi2n3
uminí4c
umi2r
umi2u
u2m3iū
umi2v
u2m1ī2
umī́4b
umī́4m
umī́4r
umī́4t
umí2b
umíni4c
umí2r
2umn
2umo
u3mo.
u3mon
u3moq
u3mor
u3mou
u3mov
u3m2ō
2umŏ
2umó
u3món
u3móq
u3mór
u3móu
u3móv
umpe3r
2umq
2umu
u4mue
um3uí
u3mus
u3mús
2umv
un3áni
un3d2
3undab
3undáb
une3b
une3d
une6ste
un2ē
2un2ĕ
un2é
uné3b
2unī
2unĭ
u3nos
2unō
u3nós
un3s
uns4i
un4sn
un4sq
un4sue
un4sv
2unt
unte5io
unte5ió
unte5iu
unte6iue
unte5iú
untē3i
untḗ5i
unté3i
u1n2u
1u2o
uob2
uo2du
2uoe
uo3i
uo4in
uo4i3q
uo4iue
uo4iv
uo4lue
uol5uere
uo4lui
uo4luī
uo4luí
uom3p2
uo3ni
uo4n3ia
uo3p2
uo3rī
uo2sp
uos3t
uos5te
uo3u
uo1ú
2uo͞
2uo͡
u2ō
uō3d
uō3i
uō2sp
uōs3t
uṓ3i
1u2ŏ
uŏ2ĭ
2uŏn3
uŏ2nĭ
uŏ3rī
uŏ4t5ắn
uŏ2t3ĕ
uŏ3ŭ
uŏ́2n3
u2ó
uód1
uó2du
uó1i
uó3io
1uól
uóm3p2
uó4n3ia
uó3p2
uó2sp
2uœ
2up
upe5raeq
upe5r6ara
upe5r6ará
upe5r6are
upe5raré
upe5raro
upe5raró
uperas6c
upe5ra͞eq
upe5r6á͞
upe5ra͡eq
upe5r6á͡
upe5ræq
upe5rǣq
upe5rǣ́
uper4ǽ
upe5remn
upere6ra
upere6rā
upere6rá
uper5erim
uper5erit
uper5e6rít
upere6ro
upere6rō
upere6ró
upere6rú
upe6r5é6rim
upe6r5é6rit
upe6résc
uperi4
upe4r5ie
uper5ié
upe4rī4
uper5īm
uper5īt
uper5ī́6m
uperī́6r
uper6ī́s
uper5ī́6t
uper6ī́u
uper6ī́v
upe4rí4r
uper5íte
uper5íto
uper4íu
uper4ív
upe5rorn
upe5ros
upe5rōs
upe5rṓs
upĕ3rĕ
upĕ3rī
upĕ3rŭ
u3pé
upé4r5ea
upé4r5eā
upé4r5eo
upé4r5eō
upé4r5e4r
upé4ri.
upé4r5ie
upé4r5iē
upo4s3
u3pŏ
2uq
u3qu
2ur.
u1r2a
u3ra.
urad2
u3rae
u3rane
u3raq
u3rarú
u3rau
u3rav
u3ra͡
2urā
2u3r2ă
u3ráe
u3ráne
u3ráq
u3ráu
u3ráv
2u3ræ
2u1rǣ
2u3rǽ
u1r2e
ure3d
ure2i
ure5iae
ure5iam
ure5iar
ure5ias
ure5ia͡
ure5iáe
ure5iám
ure5iáq
ure5iár
ure5iás
ure5iáu
ure5iáv
ure3iæ
ure3iǽ
ure5ium
ure3iú
ures3t
2u3rē
urē3ia
urē5iā.
urē5iāq
urē5iār
urē5iās
urē5iāu
urē5iāv
urē5iā́q
urē5iā́r
urē5iā́s
urē5iā́u
urē5iā́v
urē3iu
urē3iú
urḗ3i
2u1rĕ
ur2é
u3réf
u1rh
u1r2i
u3ria
u3riá
u3riæ
u3riǽ
u3rii
u3rií
ur4in
uri3ni
2urio
2urió
2u1rī
2urĭ
ur2í
u3ría
2urío
urí5tur
2urn
2u1r2o
2u1rō
2u1r2ŏ
ur2ó
u3rós
2urq
ur3ua
ur3uā
ur3uá
ur3uē
ur2ui
u3rum
ur3uō
ur3uó
u3rus
2u1rŭ
ur2ú
u3rúm
u3rús
u1ry
u1rý
2us
us2a
usa3b2
u3s2ă
usă3b2
usá4tr
u2s3c
use2i
us2i
u2sm
u1sp
us5per
u2spē
us2pĕ
us4pit
us2pĭ
us2pí
us4pít
u2s3q
u2sta
u2stā
u2stă
u2stá
u2stæ
u2stǣ
u2stǽ
u2ste
us5ter
u2stē
u2stĕ
us5tĕr
u2sté
u2sti
u2stī
u2stí
u3s4tom
u2stō
u3s4tŏm
u5s4tŏ́m
u3s4tóm
u2s3tr
us5tro
u2stu
u2stŭ
u2stú
us2ua
4u2sue
u2suĕ
u2sui
u2suí
1ut.
3u4tar.
3u4tarn
3u4tarq
3u4tarv
3u4tárn
3u4tárq
3u4tárv
3u2teb
ute2ī
ute3r4a
ute3rǣ
ute5re
ute3ri
uteri5ue
uteri5v
ute5rī
uterī5u
uterī5v
ute3ro
ute3rō
utĕ1
utĕr4a
utĕ5rī
utĕrī5u
utĕrī5v
utĕ5r4ĭ
3u2téb
2utia
2utiá
2utiæ
2utiǽ
2utii
2utií
u2til
2utio
u2tíl
3u2trā
3u2træ
3u2trǣ
3u2trǽ
ut4ri
3u2trī
3u2trō
3u2tru
3u2trú
ut2u
ut3ut
u1u
2u3ue
2uuĕ
1u2ul
uul3ui
uul3uī
uul3uí
u2um1
u2un
u2u1r
u2uu
u2uv
uū2s
1uŭ
1uúl
uúl3u
uú1r
2u3ve
ux2
u3xe
ux4eu
u3xé
u3xi
uxi3n
u3xí
u2xo3
u2xō
uxu3
u2x3ue
ux4us
uy2s
ū1
ūb2
ūba2
ūbā6iāne
ūbā6iāru
ūbā6iārú
ūbā6iæne
ūbā6iæue
ūbā6iæve
ūbā6iǣne
ūbā6iǣue
ūbā6iǣve
ūbā6iǽne
ūbā6iǽue
ūbā6iǽve
ūbá2
ūbe3ri
ūbe3rō
ūbĕ3rŭ
ūbī3u
ūbī3v
ūbo2
ūca2r
ūco2
ū3cr
ū2c3ue
ūd2
ū3da.
ū3dam
ū3dane
ū3daq
ūda2r
ū3dau
ū3dav
ū3da͞
ū3da͡
ū3dă.
ū3dăm
ū3dănĕ
ū3dăq
ū3dău
ū3dăv
ū3dắm
ūdá2
ū3dám
2ū3dæ
2ū3dǣ
2ū3dǽ
ū3de.
ū3dene
ū3deq
ūde2s3
ūde6ste
ū3deu
ū3dev
ū3dē.
ū3dēn
ū3dēq
ūdē2s
ū3dēu
ū3dēv
ū3dḗn
ū3dḗq
ū3dḗu
ū3dḗv
ū3dĕ.
ū3dĕnĕ
ū3dĕq
ūdĕ6stĕ
ū3dĕu
ū3dĕv
2ū3dī
ūdo2
ūd4or
ū3dōr
ū3dōs
ū3dṓr
ū3dṓs
ūdó2
2ū3du
2ū3dŭ
2ū3dú
ū2ē
2ūg
ū3g2a
ū3g2æ3
ū3g2ǣ
ū2gn
ū3iú
1ūl
ū2la
ū2lā
ū2lă
ū2lá
ūle3i
ūle2r
ūlé3i
ū2lo2
ū2lŏ
ū2ló
ū2l3ue
ūm2a
ūma2r
ūmá2
ūm2e
ūm2ĕ
ūm2i
ūm2ĭ
ūmo2
ūna2
ūn2ā
ūnă2
ūná2
ūn3áni
ūne3b
ūne6ste
ūn3et
ūnĕ6stĕ
ūn3ĕt
ūn2é
ūné3b
2ūni
2ūnĭ
2ūní
ūno2
ū3nōr
ū3nōs
2ūns
ūn3s2i
ūn3s4ĭ
ūn2u
ūn2ŭ
ūpe3r2
ūpĕ3r
ūpĕ5rĭ
2ūq
ūr2a
ūra2r
ūr2ă
2ūræ
ūræ2ă
2ūrǣ
ūrǣ2ă
2ūrǽ
ūr2e
ūres3
ū3rēu
ū3rēv
ūr2ĕ
ūrĕ2ĭ
ūrĕ2s3
ūr2é
ū3réf
ūr2i
ūr4in
ūr2ĭ
ūr4ĭn
ūrí2n
ūro2
ūró2
ūr2u
ū2sc
ūs2ie
ūs2iē
ūs2iu
ūso2
ū2sp
ūs5per
ūs5pĕr
ū2s3q
ū2s3t
ūs5ter
ūs5tĕr
ū2sue
ū2suĕ
ūs2uī
ūt2
ūta2r
ūtá2
ūte5re
ūtĕ3rĕ
2ū3tia
2ū3tiā
2ū3tiá
2ūtiæ
2ūtiǣ
2ūtiǽ
2ū3tiī
2ūtĭa
2ū3tĭā
2ūtĭá
2ūtĭæ
2ūtĭǣ
2ūtĭǽ
2ū3tĭī
ūtí2n
ūto2
2ūu
2ūv
ūx2
ūx4eu
ū2x3ue
ūx4us
ūxū3r
ū2́
ū́b2
ū́3cr
ū́d2
2ū́g
ū́1i
ū́2lā
ū́4lă
ū́4lĕr
ū́4lĕt
ū́2lo
ū́2lŏ
ū́3mu
ū́n3si
2ū́q
ū́rĭ5m
ū́r2u
ū́2sp
ū́s5pe
ū́4st
ū́s5tr
4ū́tia
4ū́3tiā
4ū́tiæ
4ū́tiǣ
4ū́3tiī
ū́4til
4ū́tĭa
4ū́tĭā
4ū́tĭæ
4ū́tĭǣ
4ū́tĭī
ū́4tĭl
2ū́u
2ū́v
ŭă3p2
ŭắ3p2
ŭbē2r
ŭbĕ2
ŭbĕ4r
ŭbĕ́2
ŭ2bi
ŭ2bī2
ŭb2īn
ŭb2īq
ŭb4īuĕ.
ŭb4īvĕ.
ŭbī́2
ŭb4ī́n
ŭb4ī́q
ŭbī́4t
ŭb6ī́uĕ.
ŭb6ī́vĕ.
ŭ3bĭă
ŭbĭ3cŭ
ŭ3bĭīs
ŭ5bĭī́s
ŭ3bĭō
ŭb3ĭt.
ŭ3bĭŭ
ŭ3bĭ́ă
ŭbĭ́4c
ŭbĭ́4g
ŭ2bl
ŭ2bō
ŭ2bŏ2
ŭ2b1r
ŭbs2
ŭb5stĕ
ŭ2b1ū
ŭ3b2ŭl
ŭ2cu
ŭdē2s
ŭ2du
ŭ3d2ŭ
ŭd4ŭĕ
ŭĕ2ă
ŭ3ĕnn
ŭĕ3r4ĕ
ŭĕ3rī
ŭĕ3rŭ
ŭ3ĕ́nn
ŭ3g2a
ŭ3g2æ3
ŭ3g2ǣ
ŭ2gn
ŭ1i
ŭī3p2
ŭī́3p2
ŭ2ĭ
ŭĭn2
2ŭĭs
2ŭla
2ŭlá
2ŭlæ
2ŭlǣ
2ŭlǽ
ŭlē3i
ŭlḗ3i
1ŭlm
ŭ2l1u
ŭm1
2ŭm.
ŭ3ma
ŭ3mā.
ŭ3mān
ŭ3māq
ŭ3mār
ŭ3mās
ŭmā4tr
ŭ3māu
ŭ3māv
ŭmă2
ŭ3mă.
ŭ3măn
ŭmắ2
ŭ3má
ŭ3mæ
ŭ3mǣ
ŭ3mǽ
1ŭm3b
ŭmb4ē
ŭmb4ĭ
ŭm5bĭt
ŭmē2g
ŭm2ēs
ŭm2ḗ
ŭmḗ4g
ŭ3mĕ.
ŭ3mĕn
ŭmĕ2q
ŭ3mĕu
ŭ3mĕv
ŭ2m3i
ŭ2mī2
ŭmī́4b
ŭmī́4m
ŭmī́4r
ŭmī́4t
ŭ2mĭ2
ŭmĭn3
ŭmĭnĭ́4
ŭm3ĭt
ŭmĭ́4c
ŭmĭ́nĭ6c
ŭmĭ́4t
2ŭmn
ŭ3m2ō
ŭ2mŏ
ŭmpĕ3r
2ŭmq
2ŭmu
ŭ3mŭs
2ŭmv
ŭn3d2
ŭndĕ3ŭ
ŭn2ē
ŭn2ĕ
ŭnĕ3d
2ŭnt
ŭntḗ5i
ŭŏ2r1
ŭpĕ5raeq
ŭpĕ5ra͞eq
ŭpĕ5r6á͞
ŭpĕ5ra͡eq
ŭpĕ5r6á͡
ŭpĕr5ắs
ŭpĕ5ræq
ŭpĕ5rǣq
ŭpĕ5rǣ́
ŭpĕrĕ4
ŭpĕ4rĕā
ŭpĕ4rĕă
ŭpĕ4r5ĕō
ŭpĕ6r5ĕrā
ŭpĕ6r5ĕră
ŭpĕ6r5ĕrĭ
ŭpĕ6r5ĕrō
ŭpĕrĕ́4
ŭpĕ6r5ĕ́rĭ
ŭpĕ4r3ī4
ŭpĕr4īs
ŭpĕrī́4
ŭpĕr6ī́s
ŭpĕ4r3ĭ4
ŭpĕrĭ́4
ŭpĕ5rṓs
ŭpĕ́6r5ĕā
ŭpĕ́6r5ĕă
ŭpĕ́6r5ĕō
ŭpĕ́6r5ĕ6r
ŭpĕ́6r5ĭē
ŭr1
ŭ1r2a
ŭr2ā
ŭ1r2ă
ŭ1r2æ
ŭ1r2ǣ
ŭr2ǽ
ŭ3r2ē
ŭrē3i
ŭrḗ3i
ŭ1r2ĕ
ŭ1r2ī
ŭ3r2ĭ
ŭ1r2ō
ŭ1rŏ
ŭ1rŭ
2ŭs.
ŭ2s3ā2
ŭsā́2
ŭ2s3c
ŭ2si
2ŭsn
ŭ1sp
ŭ2spē
2ŭsq
ŭs3t
ŭs5tĕr
ŭs4trĭ
ŭs5trŏ
2ŭsu
2ŭsv
1ŭt.
ŭtĕ2ī
ŭtĕ3rĕ
ŭtĕ5rī
ŭtĕrī5u
ŭtĕrī5v
ŭtĕ3rŭ
ŭ2tĭ.
1ŭ2tr
ŭ2tu
ŭ1u
1ŭ2x2
ŭ́2
ŭ́bĕ2
ŭ́b4ĭī
ŭ́bs2
ŭ́3bŭ
ŭ́3cĕ
ŭ́3cī
ŭ́3cĭ
ŭ́3cl
ŭ́3dē
ŭ́3dĕ
ŭ́3dĭ
ŭ́3g
ŭ́4gn
ŭ́3i
ŭ́3j
2ŭ́lă
ŭ́3lī
ŭ́3lĭ
ŭ́l3u
ŭ́3lŭī
ŭ́3lŭĭ
ŭ́m3ă4r
ŭ́m3b4
ŭ́m5bĭ
ŭ́m3ĕā
ŭ́m3ĕă
ŭ́3mĕn
ŭ́m3ĕō
ŭ́m3ĕŏ
ŭ́3mĕq
ŭ́3mĕu
ŭ́3mĕv
ŭ́m3ī
ŭ́m3ĭ4c
ŭ́m3ĭē
ŭ́m3ĭĭ
ŭ́3mĭn
ŭ́m3ĭ4t
2ŭ́mn
2ŭ́mq
2ŭ́mu
ŭ́3mŭ
2ŭ́mv
ŭ́3nē
ŭ́3nĕ
ŭ́3nĭ
ŭ́3pĕ
ŭ́3ră
ŭ́3rĕ
ŭ́3r2ĭ
ŭ́3rŏ
ŭ́3sĭ
2ŭ́sn
ŭ́3spĕ
ŭ́s3t
ŭ́s4trĭ
2ŭ́su
2ŭ́sv
ŭ́3tă
ŭ́3tĕ
3ŭ́4tr
1ŭ́u
ŭ́3uā
ŭ́3uă
ŭ́3uē
ŭ́3uĕ
ŭ́3uō
ŭ́3uŏ
1ŭ́v
ŭ́3vā
ŭ́3vă
ŭ́3vē
ŭ́3vĕ
ŭ́3vō
ŭ́3vŏ
úbe4ram
úbe4rā
úb4eris
ú5berum
úb4ii.
ú3b4iis
ú3biō
ú3b2iu
úbi5ui
úbi5vi
ú2bī
úb2o
úb3s2
úb5ste
ú3b2u
2úc
ú2c3ue
úd2i
úd3ue
úe1
úe2a
úe2o
2úg
ú3g2a
ú3gæ
ú3gǣ
ú2g3n
ú1iæ
ú1ii
ú2in
ú2la.
ú2lat
ú2let
ú2lu
úl3ua
úl3uæ
úl3ue
úl3uis
úl3uīs
ú3lum
úm1
ú1ma
úma2g
ú3m2an
ú3maq
úma2r
ú3mau
ú3mav
úm3b2
úmb4e
úmb4ē
úmb4i
úm5bi5t
úmb6itu
úm2e
ú2m3eā
ú2m3eō
úmi2c
úm2im
úm2in
úm2iu
ú2m3ī
2úmn
ú1mo
2úmq
2úmu
ú3mun
2úmv
5úndans
3úndān
2úni
ún3s4i
2únt
ú1n2u
úpe1
úpe3r
2úq
úr1
ú1r2a
2ú1ræ
ú1r2e
ú1r2i
2úrn
ú1r2o
2úrq
ú3r2ui
úru3m
ú2run
ú2s3c
ús2i
2úsn
ús3q
ús3t
2úsu
ú2sui
2úsv
ú2tar
úte3r
2ú3tia
2útiæ
2ú3tii
ú2til
ú1u
2úue
ú2um
ú2un
2úve
2úx
úx2a
úx4eu
úx2i
úx2o
ú2xue
úx4us
1v
vab2
va3d2
vad4o
va3g
val4u
vas3p
vas5te
v2ă
vă3d2
vă3g
văs3
vắs3
v3áed
vás3p
2væ2d
vǣ2d
vǣ́2d
2v1ǽ2d
vb2
vbi2
ve1
ve2a
ve2ia
ve2iá
ve4iene
ve2ii
ve2ií
ve4io.
ve4ioq
ve4ior
ve6ioue.
ve6iove.
ve4ión
ve4ióq
ve4iór
ve6ióue.
ve6ióve.
ve2iu
ve2iú
ve2ī
ve2í
ve2lu
ve4n3ea
ve4n3eá
ve4n3eo
ve4n3eó
ve4n3ii
ve4n3ií
ve4n3íi
2venn
ve2o
ve2ō
ver2æ3
ve3rē
ve2s
ve3sá
ve3sí
ve4s3p
ves5pe
ve4s3t
ves5te
ves5tr
vete5re
vete5ri
veteri5v
vete5rī
veterī5v
veterī́7
ve2u
vex2
vex4e
vē4iae.
vē6iaene
vē6iaeque
vē6iaeue
vē6iaeve
vē4iam
vē4ian
vē6ia͞e.
vē6ia͞ene
vē6ia͞eque
vē6ia͞eue
vē6ia͞eve
vē6iá͞ene
vē6iá͞eque
vē6iá͞eue
vē6iá͞eve
vē6ia͡e.
vē6ia͡ene
vē6ia͡eque
vē6ia͡eue
vē6ia͡eve
vē6iá͡ene
vē6iá͡eque
vē6iá͡eue
vē6iá͡eve
vē4iā.
vē4iāne
vē6iāque
vē4iāru
vē4iārú
vē4iās.
vē6iāsne
vē6iāsque
vē6iāsue
vē6iāsve
vē4iāue
vē4iāve
vē6iā́ne
vē6iā́que
vē6iā́ru
vē6iā́sne
vē6iā́sque
vē6iā́sue
vē6iā́sve
vē6iā́ue
vē6iā́ve
vē6iáene
vē6iáeque
vē6iáeue
vē6iáeve
vē4iám
vē4iæ.
vē4iæne
vē6iæque
vē4iæue
vē4iæve
vē4iǣ.
vē4iǣne
vē6iǣque
vē4iǣue
vē4iǣve
vē6iǣ́ne
vē6iǣ́que
vē6iǣ́ue
vē6iǣ́ve
vē4iǽne
vē6iǽque
vē4iǽue
vē4iǽve
vē4iene
vē4iī.
vē4iīne
vē6iīque
vē4iīs.
vē6iīsne
vē6iīsque
vē6iīsue
vē6iīsve
vē4iīue
vē4iīve
vē6iī́ne
vē6iī́que
vē6iī́sne
vē6iī́sque
vē6iī́sue
vē6iī́sve
vē6iī́ue
vē6iī́ve
vē4iō.
vē4iōne
vē6iōque
vē4iōru
vē4iōrú
vē4iōs.
vē6iōsne
vē6iōsque
vē6iōsue
vē6iōsve
vē4iōue
vē4iōve
vē6iṓne
vē6iṓque
vē6iṓru
vē6iṓsne
vē6iṓsque
vē6iṓsue
vē6iṓsve
vē6iṓue
vē6iṓve
vē2iu
vē2iú
vē4n3iī
vē4nīs
vē4n3ĭī
vē3r
vḗ4n5iī
vḗ4n5ĭī
v2ĕ
vĕ2ă
vĕ3rē
vĕ3r4ĕ
vĕ2s3
vĕ4sp
vĕs5pĕ
vĕs5tĕ
vĕ3x2
vĕ́3rĕ
vĕ́x2
vé2lu
vé4n3eo
vé4n3ii
2vénn
vés3
véx2
v2i
vi2a
vi4c5énn
vid4u
vin2ā
vi3r4i
v2ī
vī4cen
vī4cĕn
vīc5ĕ́n
vī4cén
vī3so
vī3sŏ
v2ĭ
vĭn2a
vĭn2ā
vĭn2æ
ví3d
ví3tu
2vj
2voe
vo3l4u
vo1n
vo3rī
vos3t
vos5te
2vo͞
2vo͡
vōs3t
vŏ3rī
vó3l2u
vó3ru
2vœ
vr2a
vri2
v̄2
v̆2
v̆́2
v̆́4t
v́2
1x1
xab2
xae2
x2aeq
xaes3
x2aeu
x2aev
x2ag
2xal
xam4b3i4
xambī4
xambī́4
xam4b3í4
x2ami
x2an
x2aq
x2are
x2aru
xas3
x2āg
x2ān
x2āri
x2āru
x3ā́c
3xă.
3xăm
xămbī4
xămbī́4
xăm4b3ĭ
3x2ăn
3x2ăq
3x2ăr
xăs3
3x2ăt
3x2ău
3x2ăv
3xắ
x2ắn
x2ắr
x2á
x3ác
x3áes3
2x3ál
x3ámb
xám4b3i
x3árs
xás3
x3áud
xæ2
x2æ3q
xæs3
x2æ3u
x2æ3v
xǣ2
x2ǣ3q
xǣs3
x2ǣ3u
x2ǣ3v
x2ǣ́q
xǣ́s3
x2ǣ́u
x2ǣ́v
x2ǽq
xǽ2s3
x2ǽu
x2ǽv
2xc2
xcí3
x2e1
xe2a
xe2e
x3e4ger
x3e4gér
x3e2gi
x3e2gí
xe2i
xe2ī
xe2í
x3emp
x3enn
xe2o
xe2ō
xe4qui
xe4quī
x3erc
xe2s
x3e2u
3x4eue
x2ē
x3ē2ge
x3ē4gēr
x5ē4gḗr
x3ē2gĕ
x3ē2gé
x3ē2gi
x3ē2gī
x3ē2gĭ
x3ē2gí
x3ḗ2g
xĕ2ă
x3ĕăr
x3ĕăt
2x2ĕd
x3ĕnn
2x3ĕŏ
x3ĕ4quī
xĕ4quĭ
x2ĕrā
x2ĕră
xĕ3r4ĕ
x2ĕrĭ
x2ĕrō
x2ĕt
x3ĕŭn
x2ĕ́d
xĕ́2q
x2é
x3é2g
x3émp
x3énn
xé4qui
x3érc
2xh
x2ia
x2iā
x2iæ
x2iǣ
xi2ba
xi2bá
xi2be
xi2bé
xi2bi
xi2bí
xi2bo
xi2bó
xi4bun
xi4bún
x2ic
2xie
3x2ies
3x2iēs
2xi2g
xi2i
x2im
xi2n
xin3ā
xinā́4
xi3ni
xi3nī
xi3ní
xi3nu
xi4nue
xi3nú
x2io
x2iō
x2iq
2xi2r
x2iss
xi2tæ
xi2tǣ
xi2tǽ
xi2tī
xi2tū
xi4uer
xi4uér
2xi2ui
xi2uí
x2i3uu
2x3iŭ
xi4ver
xi4vér
2xi2vi
xi2ví
2xī2b
2xī2m
x2īn
xīō2
x2īq
2xī2r
2xī2t
xī2ué
xī2ui
xī2uĭ
xī2uí
xī2vé
xī2vi
xī2vĭ
xī2ví
xī́2b
xī́2m
xī́2r
xī́4t
xī́4ui
xī́4uĭ
xī́4vi
xī́4vĭ
x2ĭb
x2ĭc
x2ĭēs
2xĭ2g
2xĭĭ
x2ĭm
xĭ2n
xĭn3ā
xĭnā́4
xĭn2ĕ
xĭ3nī
xĭ3nŭ
xĭ2ta
xĭ4tā.
xĭ2tă
xĭ2tá
xĭ2tæ
xĭ2tǣ
xĭ2tǽ
x2ĭtĕ
xĭ2tī
x2ĭtĭ
xĭ4tōs
xĭ2tū
xĭ4tŭm
xĭ4tŭs
xĭ́2g
x2ĭ́m
xĭ́4tă
x2í
2x3í2b
2x3í2g
x3íi
2x3í2mu
2x3í2r
x3í2ta
x3í4te.
2x3í2ti
2x3í2to
x3ítur
x3í4uer
x3í4uim
x3í4uit
x3í4ver
x3í4vim
x3í4vit
2xj
x2l2
2xn
x3ne
x3nĕ
xo2
3xo.
x2o3d
3xon
3xoq
xorí3t
xo4rn
xo4rq
xo3ru
xo4rv
3xos
xo4sa
xo4sn
xo4so
xo4sq
xo4su
xo4sv
x2o3t
3xo3u
3xo3v
3xō.
3x2ōn
3xōq
3xō2s
xō4sa
x2ō3t
3xōu
3xōv
xṓ4rat
xṓ4rān
xṓ4răt
xṓ4rer
xṓ4ret
xṓ4rĕr
xṓ4rĕt
x3ṓ4ro
x3ṓ4rŏ
x3ṓrs
xṓ4s
x3ṓsa
x3ṓsā
x3ṓsă
x3ṓsæ
x3ṓsǣ
x3ṓsc
x3ṓse
x3ṓsē
x3ṓsĕ
x3ṓsī
x3ṓsō
x5ṓsum
x5ṓsus
x3ṓsŭ
xŏ2
2x2ŏ3d
xŏ́2n
xó4ner
xó4rat
xó4rer
xó4ret
xó4riē
xó4ror
xó2s
xó4sa
x2ót
2xp
x3pé
2xq
x3qu
2xs2
x3sp
xs4pe
xsu4lu
xsupe3
2xt
x3ta
x3tā
x3tă
x3tá
x3tæ
x3tǣ
x3tǽ
x3te1
xter4a
xte5re
xte5ré
xteri5ue
xteri5v
xte5rī
xterī5u
xterī5v
x3tĕ
xtĕ3r4a
xtĕ3rǣ
xtĕ3rĕ
xtĕ5rī
xtĕrī5u
xtĕrī5v
xtĕ3rŭ
xtéri5t
x3ti1
x3tī
x3tĭ
x3tí
x3to
x3tō
x3tó
x3tr
x3tu
x3tū
x3tŭ
x3tú
xu2
3xu.
2x3ue.
x3uev
2x3uĕ
x2ui.
x2uis
x2uī
x2uís
3x2um
xum2e
xum2ī
xu4mn
xu4mq
xu4mv
x2une
xu1r
xu3ro
3x3us
x4us.
x4u4sn
x4u4sq
x4u4su
x4u4sv
x2uum
x2uúm
xū2b
xūbe3
x2ūne
x2ūnĕ
xū2re
xū2rē
xū2rĕ
xū2ré
xū2ri
xū2rĭ
xū2rí
xū2ro
xū2rŏ
xū2ró
x2ū2s
xū2t
xū́2b
xū́4rē
xū́4ri
xū́4rĭ
xū́4ro
xū́4rŏ
x2ū́s
xū́2t
xŭ2
2xŭā
2xŭă
x2ŭī
2xŭl
x2ŭm
xŭ3mā
xŭ3mă
xŭ3mē
xŭ3m2ĕ
xŭ3m2ī
xŭ3mŭ
2xŭō
2xŭŏ
x2ŭŭm
xŭ́4l
x2ŭ4́m
xú2b
xú2l
x2úm
x2úne
xú1r
x2úsq
xú2t
xú2ui
xú2vi
2xv
x3ve
x3vĕ
x2x2
y2a
yad2
ya1m
ya2nu
yā2nu
yá2nu
yb2
ybe2
ybē2
ybé2
ybé4i
yd2
yda3m
yde2s
ydē2
ye2
yes3
yē2
yé2
yés3
y2g3n
y2i
yi2i
yin2
yio2s
yis3
yi4sc
yis5ci
yl3ui
yl3uí
y1m
ym2a
ym2e
yme3d
yme5de
y1n
yn2ā
yne2
yn2i
yo3ne
yo3ni
yó1
yper4í
y1r
yr2a
y3rá
yr4ás
ys2i
ysta4
yste3
y1su
yte3r
yteri5ue
yteri5v
yte5rī
yterī5u
yterī5v
yx4eu
y2xu
ȳ1
ȳ2a
ȳad2
ȳ2ă
ȳăd2
ȳ2á
ȳ2i
ȳ2ĭ
ȳ2í
ȳló2
ȳmo3
ȳn2
ȳne2
ȳ3rē
ȳré2
ȳro2
ȳró2
ȳs2
ȳso2
ȳsó2
ȳ2́
ȳ́3l
ȳ́1n
ý2a1
ýb2
ýd2
ýda3
ý2g3n
ý2i
ý2l1u
ý1m
ým2e
ý1nu
ý1r
ýs2i
ýste3
ýte1
ý2th
ýx4eu
ý2xu
1z
z2a
zab2
za3r
ză3r
zá1m
ze3b
zé2ru
z2i
zmă3
zo1
zo2s
zū2
̄1
̄2a
̄a2m
̄2ā
̄2ă
̄2á
̄2ǣ
̄ǣ2ŭ
̄b2
̄be3
̄bī3u
̄bī3v
̄3bu
̄3bŭ
̄ce2
̄2cl
̄2cū
̄de3
̄dĕ3r
̄2dī
̄2e
̄2ē
̄ēn3
̄2ĕ
̄2f
̄2i
̄2ī
̄2ĭ
̄2í
̄n2
̄no3
̄2ō
̄pe3
̄per2
̄pĕ3r
̄pĕ5rĭ
̄r2
̄2s
̄to2
̄2u
̄2ŭ
̄2ú
̄2́
̄́3b2
̄́2cl
̄́3l
̄́1n
̄́2s
̆ăd2
̆b2
̆d2
̆dă3m
̆dē2
̆ĕs3
̆2gn
̆2ĭ
̆ĭ2ă
̆ĭn2
̆ĭs3
̆2lu
̆1ma
̆1mă
̆m2e
̆m2ĕ
̆1n
̆n2ā
̆1ra
̆3r2ă
̆1ræ
̆1rǣ
̆1rī
̆1rō
̆1rŏ
̆rsĭ3
̆1rŭ
̆stă4
̆tĕ5rī
̆tĕrī5u
̆tĕrī5v
̆tĕ3rŭ
̆2th
̆3thĭ
̆x2
̆2xu
̆́b2
̆́d2
̆́dă3
̆́m2ĕ
͞e1
͞ea2b3
͞eắ2
͞eá2
͞e3ác
͞e3áp
͞e3b
͞e4cue
͞e3d2
͞ed4o
͞e2eō
͞e3es
͞eé2
͞e3és
͞e3g2
͞ei2
͞e2iā
͞e3ic
͞e2iī
͞e2ī
͞e2ō
͞eó2
͞epe3
͞epote4
͞epot5er
͞epot5es
͞epo6t5és
͞epó4t5e
͞e3q
͞e3r
͞es4ca
͞es4cá
͞es4ci
͞es4cí
͞e4scu
͞e4scú
͞e4spō
͞e2sq
͞es4ta
͞es4tā
͞es4tá
͞es4te
͞es4tē
͞es4té
͞es4tin
͞esti5t4
͞es4tī
͞estí3
͞es4tít4
͞es4tō.
͞es4tōn
͞es4tōq
͞es4tōs
͞es4tōu
͞es4tōv
͞es4trú
͞e5ter
͞etere6ri
͞ete6re6rí
͞ete6r5es
͞ete6r5és
͞ete5rim
͞ete5riti
͞ete5rití
͞ete5rito
͞ete5ritó
͞ete5r6i5tur
͞ete5ritúr
͞ete4r5ī4
͞eterī́6
͞ete6rít
͞e5tĕr
͞eté6r5es
͞eté6rite
͞e3ut
͞ex2
͞e2xu
͞2u1
͞u2a
͞u2ǣ
͞u3b2
͞u3do
͞uō2
͞upe5re
͞upe5ri
͞upe5r4ī
͞uperī5n
͞uperī5q
͞uperī5u
͞uperī5v
͞u2su
͞u3sum
͞u3sus
͞u2xu
́͞2
͡e1
͡ea2b3
͡eắ2
͡e3ác
͡e3áp
͡e3b
͡e4cue
͡e3d2
͡ed4o
͡e2eo
͡e2eō
͡e2eó
͡e3es
͡eé2r
͡e3és
͡e3g2
͡ei2
͡e2iā
͡e3ic
͡e2ii
͡e2iī
͡e2ií
͡e2ī
͡e2o
͡e2ō
͡epe3
͡epo6tés
͡epó6tes
͡e3q
͡e3r
͡er4i
͡es4ca
͡es4cá
͡e5s4ci
͡es4cí
͡e4scu
͡e4scú
͡e4spō
͡e2sq
͡es4ta
͡es4tā
͡es4tá
͡es4te
͡es4tē
͡es4té
͡es4ti.
͡es4tig
͡es4tin
͡es4tiq
͡es4tis
͡esti5t4
͡es4tiv
͡es4tī
͡es4tíg
͡es4tín
͡es4tíq
͡es4tís
͡es4tí5t4
͡es4tíu
͡es4tív
͡es4to.
͡es4ton
͡es4toq
͡es4tos
͡es4tou
͡es4tov
͡es4tō.
͡es4tōn
͡es4tōq
͡es4tōs
͡es4tōu
͡es4tōv
͡es4tón
͡es4tóq
͡es4tós
͡es4tóu
͡es4tóv
͡es4trú
͡e5ter
͡etere6ri
͡ete6re6rí
͡ete4ri4
͡eter5ii
͡eter5ií
͡ete4r5ī4
͡eterī́6
͡ete4rí4
͡eter5ímu
͡eter5íti
͡e5tĕr
͡eté6ri.
͡eté6r5ii
͡eté6r5is
͡eté6rite
͡eté6ri6ti
͡e3ust
͡e3ut
͡ex2
͡e2xu
͡2u1
͡u2a
͡u3b2
͡u3do
͡uō2
͡uó2
͡upe5re
͡upe5ri
͡uperi5n
͡uperi5q
͡uperi5ue
͡uperi5v
͡upe5r4ī
͡uperī5n
͡uperī5q
͡uperī5u
͡uperī5v
͡u2xu
́͡2
́2ă
́ăd2
́ă3g
́b2a
́ba3q
́3bas
́b2ă
́4băc
́bă2r
́b3ărā
́b3ără
́b3ărē
́b3ărĕ
́b3ărō
́3băs
́b2e
́be3r
́b2ē
́b4ĭă
́bĭ4cŭ
́b4ĭēs
́2bĭĭ
́b4ĭō
́b4ĭŭ
́b2o3
́b2ŏ1
́b5ŏlĕn
́2bri
́b2rī
́b2sq
́b5s4tĕ
́b2su
́b2u
́3bŭm
́2by
́3că
́ce1
́3cē
́3ci
́cŏ3
́2cre
́2crē
́2cri
́2c3ue
́2c3u2t
́cŭ3m
́2c3ŭ2t
́dă2m
́d3ămă
́de4run
́2d3ĕ2d
́d4ĕp
́d3ĕst
́2d3i2g
́d2in
́d2ĭ
́2d3ĭg
́4d3ĭmĭ
́d3ŏ2l
́d2rē
́d2rŏ
́2d3ue
́2dū
́d2ŭ
́e2ă
́e3b
́e4cue
́e3d2
́e2eo
́e2eō
́e3es
́e3g2
́ei2
́e4ia.
́e4iam
́e4ias
́e4ia͞
́e2iā
́e2ii
́e2iī
́epe3
́e3q
́e1r
́er4i
́e3s4ca
́e3s4ci
́e3s4ta
́e5s4tā.
́e5stān
́e3s4te
́e3s4tē
́e5s4ti.
́e5s4tin
́e5s4tis
́e5stit
́e3s4tī
́e5s4to.
́e5s4tos
́e3s4tō
́es5tră
́e5stru
́es3tu
́ete3r
́etĕ5r
́e3ut
́e2ŭ
́e2x
́ĕ1
́1ĕā
́1ĕ2ă
́ĕ2mŏ
́2ĕq
́4ĕr.
́1ĕ2s
́ĕ2ŭ
́fe1
́2fē
́fĕ1
́fŏ1
́3g2a
́3gă
́3gæ
́3gǣ
́gĕ1
́2gl
́2gn
́g3no
́2gŭa
́2gŭā
́2gŭă
́2gŭǣ
́2gŭē
́2gŭĕ
́2gŭō
́2gŭŭ
́1h
́2he
́3ian
́3iaq
́3iar
́3iat
́3iau
́3iav
́i2ā
́i3b
́i2ci
́3iem
́3ien
́3ieq
́3iet
́3ieu
́3iev
́3iēs
́1ii
́1io
́3iun
́3iuu
́ĭ3b
́ĭ2cĭ
́1ĭĭ
́2ĭn2
́3ĭn.
́3lă
́2leg
́3lĕ
́4lĕg
́4lĕp
́3lix
́2lu
́3lub
́l3ue
́l3uē
́3lui
́3lum
́3lus
́1m2a
́1mă
́mă2g
́m3ără
́m3ă4rō
́m3bă
́m4bĭā
́m4b3ĭŏ
́m2e
́4mera
́4merā
́mĕ4dĭ
́4mĕdŏ
́m2in
́4minē.
́4minēn
́m2ĭ
́4mĭăn
́4mĭăt
́4mĭēn
́4mĭēs
́4mĭĕn
́4mĭĕt
́2mĭĭ
́4mĭnē.
́4mĭnēn
́4mĭŭn
́1mo1
́mŏ1
́mpĕ5r
́mpĕr6ī
́2mun
́3m2ū
́n2ā
́n2ă
́n3dĕ
́n4d3ĭg
́n4d3ŏ4l
́n4dŭĕ
́nd3ŭĭ
́n2ĕ
́n3ĕst
́n3g2
́4n3ĭcĭ
́n2o
́nŏ1
́ns2c
́n4sig
́ns5i4tæ
́ns5i4tu
́n4sĭg
́ntĕ3r
́nt5ĕrōs
́3n2ua
́n2uā
́3n2uē
́3n2uī
́n2ū
́n2ŭ
́o1
́2ŏ
́ŏ3p
́3pă
́pe1
́pe3r
́pĕ3r
́pĕ5rĭ
́3pi
́3pĭ
́3pl
́2pn
́pŏ3
́3pr
́pu3l
́3pŭī
́3pŭĭ
́1r
́r2a
́ra3g
́4r2ăb
́ră4gā
́ră4gă
́ră4gĭ
́r2ăl
́r3c
́r2e
́3rē.
́r3ĕ2d4
́rĕ2g
́rĕ2m
́r3ĕmā
́4r3ĕmă
́r3ĕmē
́r3ĕmĕ
́r3ĕmī
́r3ĕmĭ
́4r3ĕmō
́r3ĕmŏ
́r3ĕmŭ
́2r3ĕs
́2rh
́rĭ4bē
́rĭ4bĕ
́r3ĭ4cĭ
́rĭ4măn
́rĭ4măr
́rĭ4măt
́4r3ĭ4mē
́rĭ4mĕ
́4r3ĭ4mĭ
́r3ĭ4mŏ
́r5ĭ4mŭn
́3rĭŭ
́2rog
́2rŏg
́2r3ŏp
́r3ua
́r3uā
́r3uæ
́2rue
́r3uē
́r2ui
́ru3m
́r3uō
́3rū
́2sc
́s4cid
́s3cr
́s2ĕ
́s4ĕr
́3sĕŭ
́s2i
́2s3ĭ2c
́s4per
́spĕ3
́s5pĕs
́s3pī
́s3q
́s4tes
́s3tib
́3s4tin
́3stit
́5stĭtē
́5stĭtĕn
́s4trat
́s4tret
́s5tri
́3s4trŏ
́3s4tru
́s5trum
́s4trŭā
́s4trŭă
́s4trŭē
́s4trŭĕ
́s4trŭī
́s4trŭō
́s4trŭŭ
́s3ui
́3sumu
́3sun
́4tăg
́te3r
́tĕ2ī
́tĕ3ra
́t6ĕră.
́2t3ĕs
́3tha
́3thā
́3thă
́3thæ
́3thǣ
́3tĭ
́4tĭq
́2tl
́to1
́tŏ1
́5trīx
́1u
́2u1m
́2un
́uŏ1
́upe3
́upe5r
́u1r
́u2xu
́1ūn
́ŭ2
́1ŭb
́1ŭt
́vŏ1
́x2a
́x2ă
́x4eu
́x2ĕ
́x3ĕăn
́x2i
́2xia
́2xiā
́2xiæ
́2xiǣ
́2xiē
́2xiī
́2xiō
́2xiu
́x2ī
́x2ĭn
́x2o
́x2ō
́x2ŏ
́xtĕ3
́2xu
́x4us
́x2ŭĭ
́x3ŭĭs
}

