/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.internal.jaxb;

import java.io.ObjectStreamException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Iterator;
import org.apache.sis.internal.jaxb.Context;
import org.apache.sis.internal.simple.CitationConstant;
import org.apache.sis.internal.util.CollectionsExt;
import org.apache.sis.internal.util.UnmodifiableArrayList;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.xml.IdentifierSpace;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.citation.Citation;

public final class NonMarshalledAuthority<T>
extends CitationConstant.Authority<T> {
    private static final long serialVersionUID = 6299502270649111201L;
    public static final byte ID = 0;
    public static final byte UUID = 1;
    public static final byte HREF = 2;
    public static final byte XLINK = 3;
    public static final byte ISSN = 4;
    public static final byte ISBN = 5;
    final transient byte ordinal;

    public NonMarshalledAuthority(String string, byte by) {
        super(string);
        this.ordinal = by;
    }

    public static <T extends Identifier> T getMarshallable(Collection<? extends T> collection) {
        if (collection != null) {
            for (Identifier identifier : collection) {
                if (identifier == null || identifier.getAuthority() instanceof NonMarshalledAuthority) continue;
                return (T)identifier;
            }
        }
        return null;
    }

    public static <T extends Identifier> void setMarshallable(Collection<T> collection, T t) {
        Iterator<T> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Identifier identifier = (Identifier)iterator.next();
            if (identifier != null && identifier.getAuthority() instanceof NonMarshalledAuthority) continue;
            iterator.remove();
        }
        if (t != null) {
            collection.add(t);
        }
    }

    public static Collection<Identifier> filterOnMarshalling(Collection<Identifier> collection) {
        int n;
        if (collection != null && Context.isFlagSet(Context.current(), 1) && (n = collection.size()) != 0) {
            Identifier[] identifierArray = collection.toArray(new Identifier[n]);
            int n2 = n;
            while (--n2 >= 0) {
                Identifier identifier = identifierArray[n2];
                if (identifier != null && !(identifier.getAuthority() instanceof NonMarshalledAuthority)) continue;
                System.arraycopy(identifierArray, n2 + 1, identifierArray, n2, --n - n2);
            }
            collection = n != 0 ? UnmodifiableArrayList.wrap(identifierArray, 0, n) : null;
        }
        return collection;
    }

    public static Collection<? extends Identifier> setMarshallables(Collection<Identifier> collection, Collection<? extends Identifier> collection2) {
        int n;
        if (collection == null || (n = collection.size()) == 0) {
            return collection2;
        }
        ArrayList<Identifier> arrayList = null;
        for (Identifier object2 : collection) {
            if (object2 != null && object2.getAuthority() instanceof NonMarshalledAuthority) {
                if (arrayList == null) {
                    arrayList = new ArrayList<Identifier>(n);
                }
                arrayList.add(object2);
            }
            --n;
        }
        if (arrayList == null) {
            return collection2;
        }
        IdentityHashMap identityHashMap = new IdentityHashMap(4);
        ArrayList<Identifier> arrayList2 = new ArrayList<Identifier>(collection2.size());
        for (Identifier identifier : collection2) {
            Citation citation;
            arrayList2.add(identifier);
            if (identifier == null || !((citation = identifier.getAuthority()) instanceof NonMarshalledAuthority)) continue;
            identityHashMap.put(citation, identifier);
        }
        for (Identifier identifier : arrayList) {
            if (identityHashMap.containsKey(identifier.getAuthority())) continue;
            arrayList2.add(identifier);
        }
        switch (arrayList2.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(arrayList2.get(0));
            }
        }
        return Containers.unmodifiableList(CollectionsExt.toArray(arrayList2, Identifier.class));
    }

    @Override
    protected Object readResolve() throws ObjectStreamException {
        IdentifierSpace<Object> identifierSpace;
        String string = this.getName();
        int n = 0;
        do {
            switch (n++) {
                case 0: {
                    identifierSpace = IdentifierSpace.ID;
                    break;
                }
                case 1: {
                    identifierSpace = IdentifierSpace.UUID;
                    break;
                }
                case 2: {
                    identifierSpace = IdentifierSpace.HREF;
                    break;
                }
                case 3: {
                    identifierSpace = IdentifierSpace.XLINK;
                    break;
                }
                default: {
                    return super.readResolve();
                }
            }
        } while (!((NonMarshalledAuthority)identifierSpace).getName().equals(string));
        return identifierSpace;
    }
}

