/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.uf;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import ucar.nc2.NetcdfFile;
import ucar.nc2.iosp.uf.Ray;
import ucar.unidata.io.RandomAccessFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UFheader {
    RandomAccessFile raf;
    NetcdfFile ncfile;
    static final boolean littleEndianData = true;
    String dataFormat = "UNIVERSALFORMAT";
    Ray firstRay = null;
    HashMap variableGroup;
    private int max_radials = 0;
    private int min_radials = Integer.MAX_VALUE;

    public boolean isValidFile(RandomAccessFile raf) {
        try {
            raf.seek(0L);
            raf.order(0);
            byte[] b6 = new byte[6];
            byte[] b4 = new byte[4];
            raf.read(b6, 0, 6);
            String ufStr = new String(b6, 4, 2);
            if (!ufStr.equals("UF")) {
                return false;
            }
            raf.seek(0L);
            raf.read(b4, 0, 4);
            int rsize = UFheader.bytesToInt(b4, false);
            byte[] buffer = new byte[rsize];
            long offset = raf.getFilePointer();
            raf.read(buffer, 0, rsize);
            raf.read(b4, 0, 4);
            int endPoint = UFheader.bytesToInt(b4, false);
            if (endPoint != rsize) {
                return false;
            }
            ByteBuffer bos = ByteBuffer.wrap(buffer);
            this.firstRay = new Ray(bos, rsize, offset);
        }
        catch (IOException e) {
            return false;
        }
        return true;
    }

    void read(RandomAccessFile raf, NetcdfFile ncfile) throws IOException {
        this.raf = raf;
        this.ncfile = ncfile;
        this.variableGroup = new HashMap();
        raf.seek(0L);
        raf.order(0);
        int rayNumber = 0;
        while (!raf.isAtEndOfFile()) {
            byte[] b4 = new byte[4];
            raf.read(b4, 0, 4);
            int rsize = UFheader.bytesToInt(b4, false);
            byte[] buffer = new byte[rsize];
            long offset = raf.getFilePointer();
            raf.read(buffer, 0, rsize);
            raf.read(b4, 0, 4);
            int endPoint = UFheader.bytesToInt(b4, false);
            if (endPoint != rsize || rsize == 0) continue;
            ByteBuffer bos = ByteBuffer.wrap(buffer);
            Ray r = new Ray(bos, rsize, offset);
            if (this.firstRay == null) {
                this.firstRay = r;
            }
            ++rayNumber;
            HashMap<String, Ray.UF_field_header2> rayMap = r.field_header_map;
            Set<String> kSet = rayMap.keySet();
            for (String ab : kSet) {
                ArrayList<Ray> group = (ArrayList<Ray>)this.variableGroup.get(ab);
                if (null == group) {
                    group = new ArrayList<Ray>();
                    this.variableGroup.put(ab, group);
                }
                group.add(r);
            }
        }
        Set vSet = this.variableGroup.keySet();
        for (String key : vSet) {
            ArrayList group = (ArrayList)this.variableGroup.get(key);
            ArrayList sgroup = this.sortScans(key, group);
            this.variableGroup.put(key, sgroup);
        }
    }

    private ArrayList sortScans(String name, List rays) {
        HashMap<Integer, ArrayList<Ray>> groupHash = new HashMap<Integer, ArrayList<Ray>>(600);
        for (int i = 0; i < rays.size(); ++i) {
            Ray r = (Ray)rays.get(i);
            Integer groupNo = new Integer(r.uf_header2.sweepNumber);
            ArrayList<Ray> group = (ArrayList<Ray>)groupHash.get(groupNo);
            if (null == group) {
                group = new ArrayList<Ray>();
                groupHash.put(groupNo, group);
            }
            group.add(r);
        }
        ArrayList groups = new ArrayList(groupHash.values());
        Collections.sort(groups, new GroupComparator());
        for (int i = 0; i < groups.size(); ++i) {
            ArrayList group = (ArrayList)groups.get(i);
            this.max_radials = Math.max(this.max_radials, group.size());
            this.min_radials = Math.min(this.min_radials, group.size());
        }
        return groups;
    }

    public float getMeanElevation(String key, int eNum) {
        ArrayList gp = (ArrayList)this.getGroup(key);
        float meanEle = this.getMeanElevation(gp);
        return meanEle;
    }

    public float getMeanElevation(ArrayList<Ray> gList) {
        float sum = 0.0f;
        int size = 0;
        for (Ray r : gList) {
            sum += r.getElevation();
            ++size;
        }
        return sum / (float)size;
    }

    public List getGroup(String key) {
        return (ArrayList)this.variableGroup.get(key);
    }

    public int getMaxRadials() {
        return this.max_radials;
    }

    public String getDataFormat() {
        return this.dataFormat;
    }

    public Date getStartDate() {
        return this.firstRay.getDate();
    }

    public Date getEndDate() {
        return this.firstRay.getDate();
    }

    public float getHorizontalBeamWidth(String ab) {
        return this.firstRay.getHorizontalBeamWidth(ab);
    }

    public String getStationId() {
        return this.firstRay.uf_header2.siteName;
    }

    public Short getSweepMode() {
        return this.firstRay.uf_header2.sweepMode;
    }

    public float getStationLatitude() {
        return this.firstRay.getLatitude();
    }

    public float getStationLongitude() {
        return this.firstRay.getLongtitude();
    }

    public float getStationElevation() {
        return this.firstRay.getElevation();
    }

    public short getMissingData() {
        return this.firstRay.getMissingData();
    }

    protected short getShort(byte[] bytes, int offset) {
        int ndx0 = offset + 1;
        int ndx1 = offset + 0;
        return (short)(bytes[ndx0] << 8 | bytes[ndx1] & 0xFF);
    }

    public static int bytesToShort(byte a, byte b, boolean swapBytes) {
        if (swapBytes) {
            return (a & 0xFF) + (b << 8);
        }
        return (a << 8) + (b & 0xFF);
    }

    public static int bytesToInt(byte[] bytes, boolean swapBytes) {
        byte a = bytes[0];
        byte b = bytes[1];
        byte c = bytes[2];
        byte d = bytes[3];
        if (swapBytes) {
            return (a & 0xFF) + ((b & 0xFF) << 8) + ((c & 0xFF) << 16) + ((d & 0xFF) << 24);
        }
        return ((a & 0xFF) << 24) + ((b & 0xFF) << 16) + ((c & 0xFF) << 8) + (d & 0xFF);
    }

    private class GroupComparator
    implements Comparator {
        private GroupComparator() {
        }

        public int compare(Object o1, Object o2) {
            List group1 = (List)o1;
            List group2 = (List)o2;
            Ray ray1 = (Ray)group1.get(0);
            Ray ray2 = (Ray)group2.get(0);
            return ray1.uf_header2.elevation - ray2.uf_header2.elevation < 13 ? 0 : 1;
        }
    }
}

