/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.server;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import org.openqa.selenium.server.RemoteCommand;
import org.openqa.selenium.server.browserlaunchers.LauncherUtils;

public class DefaultRemoteCommand
implements RemoteCommand {
    private final String command;
    private final String field;
    private final String value;
    private final String piggybackedJavaScript;

    public DefaultRemoteCommand(String command, String field, String value) {
        this.command = command;
        this.field = field;
        this.value = value;
        this.piggybackedJavaScript = null;
    }

    public DefaultRemoteCommand(String command, String field, String value, String piggybackedJavaScript) {
        this.command = command;
        this.field = field;
        this.value = value;
        this.piggybackedJavaScript = piggybackedJavaScript != null && !"".equals(piggybackedJavaScript) ? piggybackedJavaScript : null;
    }

    public String getCommandURLString() {
        return "cmd=" + LauncherUtils.urlEncode(this.command) + "&1=" + LauncherUtils.urlEncode(this.field) + "&2=" + LauncherUtils.urlEncode(this.value);
    }

    public String getCommand() {
        return this.command;
    }

    public String getField() {
        return this.field;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        if (this.piggybackedJavaScript == null) {
            return this.getCommandURLString();
        }
        return this.getCommandURLString() + "\n" + this.getPiggybackedJavaScript();
    }

    public static RemoteCommand parse(String inputLine) {
        if (inputLine == null) {
            throw new NullPointerException("inputLine must not be null");
        }
        if (!inputLine.startsWith("cmd=")) {
            throw new IllegalArgumentException("invalid command string, missing 'cmd='=" + inputLine);
        }
        String[] parts = inputLine.split("\\&");
        HashMap<String, String> args = new HashMap<String, String>();
        for (String part : parts) {
            String[] pair = part.split("\\=");
            if (pair.length < 2) {
                args.put(pair[0], "");
                continue;
            }
            try {
                args.put(pair[0], URLDecoder.decode(pair[1], "utf-8"));
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException("Bug! utf-8 isn't supported???");
            }
        }
        String command = (String)args.get("cmd");
        String arg1 = (String)args.get("1");
        String arg2 = (String)args.get("2");
        return new DefaultRemoteCommand(command, arg1, arg2);
    }

    public String getPiggybackedJavaScript() {
        return this.piggybackedJavaScript;
    }
}

