;;; -*-  Mode: Lisp; Package: Maxima; Syntax: Common-Lisp; Base: 8 -*- ;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;     The data in this file contains enhancments.                    ;;;;;
;;;                                                                    ;;;;;
;;;  Copyright (c) 1984,1987 by William Schelter,University of Texas   ;;;;;
;;;     All rights reserved                                            ;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;

(in-package "MAXIMA")
;;to do add for other cl implementations.
(defun remove-type ( l)
  (sloop for v in l
	 when (consp v) do (setq v (car v))
	 when (symbolp v)
	 do (remprop v
		     #+ti 'compiler::variable-type
		     #+kcl 'compiler::cmp-type
		     #-(or ti kcl) nil
		     )))

(defvar *macro-file* nil)

#+gcl
(progn 
(clines "#define MAKE_UNSPECIAL(x) (check_type_symbol(&(x)),(x)->s.s_stype = stp_ordinary, Cnil)")
(defentry make-unspecial (object) (object "MAKE_UNSPECIAL"))
)

(defmacro declare-top (&rest decl-specs)
  `(eval-when ,(cond (*macro-file*  '(compile eval load))
		     (t'(eval compile)))
     ,@ (sloop for v in decl-specs
	       ;;only accept these declares for the moment
	       ;;there are type declares that hang
	       ;;around and cause problems
	       when (not (member (car v) '(special unspecial no-type))) do nil 
	       else
	       when (eql (car v) 'unspecial)
	       collect `(progn ,@ (sloop for w in
					 (cdr v)
;					 do
;					 (cond ((eql
;						  (aref (symbol-name w) 0) #\$)
;		(format t "Removing special property of  ~a " w)))
					 collect ` #-gcl(remprop ',w
							   #-excl 'special
							   #+excl 'excl::.globally-special.
							   )
				     #+gcl (make-unspecial ',w)
				     
				     ))
	       else when (eql (car v) 'fixnum)
	       collect
	       `(proclaim ',(sloop for w in  v when (symbolp w) collect w))
	       else when (eql (car v) 'notype)
	       collect `(remove-type ',(cdr v))
	       else collect `(proclaim ',v))))


;(DEFPROP DCL "12//7//81 0:57:08" VERSION) 
;(*EXPR CMOD CPLUS CTIMES CEXPT CRECIP CFACTOR) 
;(*FEXPR $FASMAK) 
;(*EXPR SOLVEQUARTIC) 
;(*EXPR $GETCHARN) 
;(*EXPR $FACOUT $DISTRIB) 
;(*LEXPR $SCSIMP) 
;(*FEXPR $GRAPH $PLOT) 
;(*EXPR $APPLY_NOUNS MTREE-SUBST) 
;(*EXPR DIMENSION-SUPERSCRIPT) 
;(*EXPR $COMBINE) 
;(*EXPR LOGARC $LOGARC) 
;(*EXPR GET-OUT GET-FLIST) 
;(*EXPR $SUBSETP $ELEMENTOF $ELEMENTP $CARDINAL $MAPSET $PREDSET $ELEMENTS $EMPTYP $UNIVERSE $MAKE_UNIVERSE) 
;(*LEXPR $SETDIFF $SYMDIFF $INTERSECTION $UNION $ORDINAL ${) 
;(*LEXPR $NROOTS $REALROOTS) 
;(*EXPR $POLYDECOMP) 
;(*EXPR $CLEARSCREEN) 
;(*LEXPR $PAUSE) 
;(*EXPR $TRIGEXPAND) 
;(*EXPR $XTHRU) 
;(*EXPR $TR_WARNINGS_GET) 
;(*EXPR $PFET) 
;(*EXPR $SUBLIST) 
;(*FEXPR $MAKELIST) 
;(*FEXPR $RENAMEFILE $FILELENGTH $FILELIST $QLISTFILES $LISTFILES $PRINTFILE) 
;(*EXPR $TLDEFINT) 
;(*LEXPR $TLIMIT) 
;(*EXPR $BEZOUT $DISCRIMINANT $RESULTANT) 
;(*FEXPR $OPTIONS) 
;(*EXPR MBUILDQ-SUBST) 
;(*FEXPR $BUILDQ) 
;(*EXPR MACSYMACALLP SUBRCALL$P SUBRCALLP) 
;(*LEXPR FMAPPLY) 
;(*EXPR DEFINE-SYMBOL) 
;(*EXPR OUTEX-HOOK-EXP $MAKE_INDEX_FILE) 
;(*EXPR $MAP_OVER_INDEX_FILE $READ_NTH_OBJECT $NUMBER_OF_OBJECTS_IN_INDEX_FILE $OPEN_INDEX_FILE) 
;(*EXPR OUTEX-HOOK-EXP $MAKE_INDEX_FILE) 
;(*EXPR $MAP_OVER_INDEX_FILE $READ_NTH_OBJECT $INDEX_FILE_DIM $OPEN_INDEX_FILE) 
;(*EXPR MMINUSP*) 
;(*EXPR LOWDEG) 
;(*EXPR $ZEROEQUIV) 
;(*EXPR SIMP-%SECH SIMP-%CSCH SIMP-%COTH SIMP-%TANH SIMP-%COSH SIMP-%SINH) 
;(*EXPR SIMP-%ASEC SIMP-%ACSC SIMP-%ACOT SIMP-%ACOS SIMP-%ASIN) 
;(*EXPR SIMP-%ASECH SIMP-%ACSCH SIMP-%ACOTH SIMP-%ATANH SIMP-%ACOSH SIMP-%ASINH) 
;(*EXPR TRIGEXPAND $TRIGEXPAND) 
;(*FEXPR $MULTIGRAPH $PARAMPLOT) 
;(*FEXPR $GRAPH $PLOT) 
;(*EXPR $TAG_FILE_INSERT) 
;(*FEXPR $PRIMER) 
;(*EXPR $SUBLIS) 
;(*LEXPR $SUSPEND) 
;(*EXPR ACSCH ASECH ACOTH ATANH ASINH ACOSH SECH CSCH COTH TANH COSH SINH ACSC ASEC ACOT ATAN1 ACOS ASIN CSC SEC COT TAN MMINUSP* MMINUSP EXPONENTIALIZE $EXPONENTIALIZE RREMAINDER RTIMES RDIFFERENCE RPLUS SIMP-%ATAN SIMP-%SEC SIMP-%CSC SIMP-%COT SIMP-%TAN SIMP-%COS SIMP-%SIN ARCP TRIGP SQ-SUMSQ SQRTX^2-1 SQRT1+X^2 SQRT1-X^2) 
;(*FEXPR $PRODUCT) 
;(*EXPR $LHS $RHS $PARTITION $DEMOIVRE) 
;(*EXPR *MERROR-1) 
;(*EXPR PTIMES PQUOTIENT PMOD PMINUS PMINUSP PDERIVATIVE PDIFFERENCE PPLUS POINTERGP) 
;(*EXPR MDESCRIBE) 
;(*FEXPR $DESCRIBE) 
;(*EXPR $TMINVERSE $TMLIN) 
;(*LEXPR $TMLINSOLVE $TMNEWDET) 
;(*LEXPR $PERMANENT $NEWDET) 
;(*EXPR $ALGNORM $SPLITFIELD $PFACTORALG $ALGTRACE) 
;(*LEXPR $BDISCR $ALGFAC) 
;(*EXPR FLUIDIZE ASS-EQ-SET ASSIGN-MODE-CHECK) 
;(*LEXPR CHEKVALUE ASS-EQ-REF) 
;(*LEXPR $TRANSLATE_FILE) 
;(*EXPR RATQUOTIENT RATPLUS RATEXPT RATTIMES RATREDUCE RATMINUS RATFACT RATDIF RATDERIVATIVE) 
;(*EXPR TRISPLIT CABS $CARG $CABS $POLARFORM $RECTFORM $IMAGPART $REALPART) 
;(*EXPR APPLY2HACK APPLY2 APPLY1HACK APPLY1 PART* PART+ FINDBASE FINDEXPON FINDFUN FINDBE $REMRULE) 
;(*FEXPR $APPLYB2 $APPLY2 $APPLYB1 $APPLY1 $DISPRULE) 
;(*EXPR $UNTRACE_IT $TRACE_IT) 
;(*EXPR $RESET $LISTOFVARS $UNKNOWN) 
;(*EXPR MAKE-TRAMP$) 
;(*LEXPR GET-ARRAY) 
;(*EXPR $ISIMPTEST $RSIMPTEST $ITEFFA $RTEFFA $TEFFS $IRES $RRES $NUPP $NUP $NU) 
;(*EXPR $DEBUG) 
;(*LEXPR $LISPDEBUGMODE $DEBUGPRINTMODE) 
;(*LEXPR $SORT) 
;(*EXPR $SUBLIST) 
;(*FEXPR $MAKELIST) 
;(*FEXPR $DEFRULE $TELLSIMPAFTER $TELLSIMP $DEFMATCH $MATCHDECLARE) 
;(*EXPR NEVERSET) 
;(*EXPR DEFINE-SYMBOL RBP LBP) 
;(*EXPR TOTAL-NARY RASSOCIATIVE LASSOCIATIVE NARY1 ANTISYM COMMUTATIVE1 ODDFUN EVENFUN DO%SUM DOSUM SIMPSUM SIMPGFACT SIMPFACT) 
;(*LEXPR $GENFACT) 
;(*FEXPR $SUM $DEFTAYLOR) 
;(*EXPR TRANSLATE-MACEXPR-TOPLEVEL TRANSLATE-AND-EVAL-MACSYMA-EXPRESSION) 
;(*EXPR MTELL5 MTELL4 MTELL3 MTELL2 MTELL1 DISPLAF *MFORMAT-5 *MFORMAT-4 *MFORMAT-3 *MFORMAT-2) 
;(*LEXPR MTELL MFORMAT) 
;(*EXPR TESTDIVIDE CFACTORW) 
;(*LEXPR $TRIGREDUCE) 
;(*EXPR PDEGREE $PRIMEP PGCD1 PQUOTIENTCHK) 
;(*EXPR $RATDISREP $RATEXPAND RATIONALIZE RATF RATREP* RATREP $GFACTOR $SQFR $TOTALDISREP $SHOWRATVARS $PRINTVARLIST $RATDENOM $RATNUMER) 
;(*LEXPR $CONTENT $GCD $REMAINDER $QUOTIENT $DIVIDE $MOD FACTOR $FACTOR $RATSIMP $RAT $FULLRATSIMP $RATVARS $TELLRAT $UNTELLRAT) 
;(*EXPR MEMALIKE ASSOLIKE ASSOL) 
;(*EXPR $POISINT $POISSQUARE $POISEXPT $POISTIMES $POISDIFF $PRINTPOIS $OUTOFPOIS $POISCTIMES $INTOPOIS $POISMAP $POISPLUS $POISSIMP) 
;(*LEXPR $POISSUBST) 
;(*EXPR $POISINT $POISSQUARE $POISEXPT $POISTIMES $POISDIFF $PRINTPOIS $OUTOFPOIS $POISCTIMES $INTOPOIS $POISMAP $POISPLUS $POISSIMP) 
;(*LEXPR $POISSUBST) 
;(*EXPR $ILT $LAPLACE) 
;(*EXPR $FASTTIMES) 
;(*LEXPR $RATWEIGHT) 
;(*LEXPR $HORNER) 
;(*EXPR $PARTFRAC) 
;(*EXPR $RATDIFF) 
;(*EXPR $PFET) 
;(*EXPR $RESULTANT $DISCRIMINANT) 
;(*EXPR $BEZOUT) 
;(*EXPR $PADE) 
;(*FEXPR $HELP) 
;(*FEXPR $SCANMAP) 
;(*LEXPR $NOFIX $MATCHFIX $NARY $INFIX $POSTFIX $PREFIX) 
;(*FEXPR $PRINTPROPS $PROPVARS $PROPERTIES) 
;(*EXPR DISPLINE MAKE-PARAM) 
;(*EXPR PABS $NTHROOT $INRT $ISQRT) 
;(*EXPR SIMPPLOG) 
;(*EXPR BINOCOMP SIMPBINOCOEF) 
;(*EXPR SIMPGAMMA SIMPBETA) 
;(*EXPR ERF SIMPERF) 
;(*EXPR $EMATRIX $ZEROMATRIX) 
;(*EXPR $AUGCOEFMATRIX $COEFMATRIX) 
;(*EXPR $ENTERMATRIX) 
;(*EXPR $XTHRU) 
;(*FEXPR $APROPOS) 
;(*EXPR $MAP_FLOAT_ARRAY $INIT_FLOAT_ARRAY) 
;(*EXPR ASCII-NUMBERP ALPHABETP CPUT A-ATOM DOT2L FSET LOG2 ASSQR FIRSTN RECONC AMONGL AMONG XOR ANDMAPCAR ORMAPC ANDMAPC MAP2C) 
;(*LEXPR CONCAT *MAKE-LIST) 
;(*EXPR META-FSET META-MPUTPROP META-PUTPROP META-ADD2LNC) 
;(*EXPR $CHANGENAME $INDICES2 $COMPONENTS $INDEXED $REMCOMPS $FLUSHND $INDICES $LC $SHOW $KDELTA $UNDIFF $CONTRACT $RIEMANN $CHR2 $CHR1 $METRIC $DUMMY) 
;(*LEXPR $REMCOORD $COORD $ENTERTENSOR $RENAME $FLUSHD $FLUSH $LORENTZ $COVDIFF $DEFCON) 
;(*FEXPR $REMCON $DISPCON) 
;(*LEXPR $FORTMX) 
;(*LEXPR $DOVER_FILE $DOVARD_FILE) 
;(*EXPR $PLOTRESET $PLOTINIT) 
;(*EXPR KILLC CONTEXTMARK KCNTXT CNTXT KILLFRAME REMOV UNKIND KILL UNTRUE DOUTERN DINTERN DINTERNP REMF ADDF DATUM PAR KIND FACT TRUE* KINDP ISP FALSEP TRUEP CLEAR VISIBLEP UNMRK MARKP MARK) 
;(*LEXPR CONTEXT DEACTIVATE ACTIVATE) 
;(*EXPR CHECK-OUT-OF-CORE-STRING ALLOCATE-MESSAGE-INDEX) 
;(*EXPR $SPECINT $LAPINT) 
;(*EXPR $GCFACTOR $JACOBI $TOTIENT $PRIME) 
;(*LEXPR $DIVSUM) 
;(*EXPR SIMPMDEFMACRO MMACRO-APPLY) 
;(*EXPR HGFSIMP-EXEC $HGFRED) 
;(*EXPR $SPECINT) 
;(*EXPR $LDEFINT) 
;(*LEXPR $LIMIT) 
;(*EXPR $ERRORMSG RATCOEFF) 
;(*EXPR STOTALDIFF DIFFNCEXPT DIFFLAPLACE DIFFSUM DIFFINT) 
;(*EXPR $AT $ATVALUE) 
;(*EXPR $LOGCONTRACT) 
;(*EXPR $NTERMS) 
;(*EXPR $FIBTOPHI) 
;(*EXPR $DERIVDEGREE) 
;(*EXPR BOX) 
;(*LEXPR $REMBOX $BOX $LPART $DPART) 
;(*EXPR $COPYLIST $COPYMATRIX) 
;(*LEXPR $GENMATRIX) 
;(*LEXPR $ADDCOL $ADDROW) 
;(*EXPR $ARRAYMAKE) 
;(*EXPR $UNORDER) 
;(*EXPR $GETCHAR) 
;(*LEXPR $CONCAT) 
;(*EXPR CG-IMAGE-TYO-N CG-TYO-N CG-IMAGE-TYO CG-TYO DIMENSION-SUPERSCRIPT DIMENSION-NOFIX DIMENSION-POSTFIX DIMENSION-NARY DIMENSION-INFIX DIMENSION-PREFIX MAKESTRING DIMENSION-STRING DIMENSION-ATOM DISPLA) 
;(*EXPR NFORMAT-ALL NFORMAT) 
;(*EXPR MSTRING) 
;(*EXPR $LOPOW $HIPOW COEFF $FLOAT $ENTIER $FIX $DENOM $NUM $SYMBOLP $ATOM $LENGTH $REVERSE $ARGS $LAST $FIRST FORMAT1 ATOMCHK $MEMBER $ENDCONS $CONS $LISTP LISTERCHK GETOPR GETOP MPART PART1 $DISPTERMS ELABEL $TRUNC REMSIMP DELSIMP NTHELEM UNION* SUBSTITUTEL NOTLOREQ ATVARSCHK SDIFF $DEL I-$DEPENDENCIES RECUR-APPLY SUBST0 SUBSTITUTE) 
;(*LEXPR $COEFF $DELETE $REST $APPEND $INPART $PART $DISPFORM $DISP $LDISP $DIFF $DEPENDS $SUBSTITUTE) 
;(*EXPR $TRANSPOSE $SETELMX $ROW $MINOR $COL $TRIANGULARIZE $RANK ONEN $ECHELON $INVERTMX $DIAGMATRIX $IDENT $DETERMINANT $CHARPOLY $MATRIXP) 
;(*LEXPR $SUBMATRIX) 
;(*EXPR $RADCAN FREEOF ARGSFREEOF $BOTHCOEF $RATSUBST RATCOEFF) 
;(*LEXPR $FREEOF $RATCOEF) 
;(*EXPR SIMPLIFY MORP PORM ROOT NCPOWER POWER* POWER NCMULN NCMUL2 DIV* DIV MULN MUL3 MUL2* MUL2 SUB* SUB NEG ADDN ADD2* ADD2) 
;(*EXPR NTHKDR *KAR SIMPARGS1 KDR KAR MATCHERR BPROG RATDENOMINATOR RATNUMERATOR SIMPNRT EXPAND1 ALIKE ALIKE1 GREAT SIMPMQAPPLY $ORDERGREATP $ORDERLESSP SIMPMATRIX SIMPEXPT EXPTRL SIMPSIGNUM SIGNUM1 SIMPDERIV INFSIMP SIMPMDEF SIMPLAMBDA SIMPEXP SIMPBIGFLOAT SIMPINTEG SIMP-LIMIT SIMPTIMES SIMPABS SIMPQUOT SIMPSQRT SIMPLN SIMPLUS FPCOFRAT TIMESK ADDK SIMPARGS SSIMPLIFYA EQTEST SIMPLIFYA FREEARGS FREEL FREE ISINOP CONSTFUN MXORLISTP MEQUALP MBAGP $NONSCALARP $SCALARP $CONSTANTP $NUMFACTOR SUBFUNARGS SUBFUNSUBS SUBFUNNAME SUBFUNMAKE SUBFUNMAKES SUBARGCHECK IMPROPER-ARG-ERR WNA-ERR TWOARGCHECK ONEARGCHECK $POLYSIGN SPECDISREP SPECREPP $RATP $RATNUMP $FLOATNUMP $EVENP $ODDP $INTEGERP $NUMBERP MRATCHECK SIMPCHECK SRATSIMP RATDISREP MQAPPLYP MNEGP MMMINUSP MLOGP MNCEXPTP MNCTIMESP MEXPTP MTIMESP MPLUSP RATNUMP EVEN MNUMP $BFLOATP ZEROP1 ONEP1 ONEP) 
;(*LEXPR $INTEGRATE $EXPAND $MULTTHRU) 
;(*FEXPR RETLIST MATCOEF) 
;(*EXPR $POWERSERIES) 
;(*EXPR MYCABS $ALGSYS) 
;(*EXPR MFILENAME-ONLYP $FILE_TYPE $LOAD $BATCHLOAD CALL-BATCH1 OPEN-IN-DSK OPEN-OUT-DSK LOAD-AND-TELL $LISTP_CHECK) 
;(*LEXPR $FILENAME_MERGE $FILE_SEARCH) 
;(*EXPR I-$STORE I-$UNSTORE) 
;(*EXPR RATINT) 
;(*EXPR $OPTIMIZE) 
;(*EXPR ARRSTORE-EXTEND MEVAL1-EXTEND $ARRAY_DIMENSION_N $ARRAY_NUMBER_OF_DIMENSIONS DIMENSION-ARRAY-OBJECT) 
;(*LEXPR $MAKE_ARRAY) 
;(*LEXPR $COMPILE_LISP_FILE) 
;(*EXPR $TIMEDATE $WHO) 
;(*EXPR $REVEAL $PICKAPART $ISOLATE) 
;(*EXPR $CHANGEVAR) 
;(*EXPR $GFACTORSUM $FACTORSUM) 
;(*EXPR $COMBINE) 
;(*LEXPR $FACTOROUT) 
;(*EXPR $CLEARSCREEN) 
;(*LEXPR $PAUSE) 
;(*EXPR $FACTCOMB $MINFACTORIAL $MAKEGAMMA $MAKEFACT) 
;(*EXPR $BERNPOLY SIMPBERN $BERN SIMPEULER $EULER) 
;(*EXPR $FIB $ZETA) 
;(*EXPR $CFEXPAND $QUNIT $CFDISREP) 
;(*EXPR $TAYTORAT) 
;(*EXPR $POLYDECOMP) 
;(*EXPR $LINSOLVE) 
;(*LEXPR $SOLVE) 
;(*LEXPR $EZGCD) 
;(*EXPR $NICEINDICES $BASHINDICES $INTOSUM $SUMCONTRACT) 
;(*EXPR APPLICATION-OPERATOR IS-BOOLE-CHECK ASSIGN-CHECK MAPPLY-TR INSURE-ARRAY-PROPS $ARRAYSETAPPLY $ARRAYAPPLY INTERVAL-ERROR) 
;(*LEXPR DISPLAY-FOR-TR MARRAYSET MARRAYREF MFUNCALL) 
;(*EXPR $TAYLORINFO) 
;(*LEXPR $TAYLOR) 
;(*EXPR $RISCH) 
;(*EXPR $SCALARP) 
;(*EXPR $RESIDUE) 
;(*EXPR DECLAREKIND RGRP $FEATUREP SIGN MNQP MGQP MGRP MEQP LIKE $SIGN ASKSIGN-P-OR-N $ASKSIGN MAXIMIN MINIMUM MAXIMUM $COMPARE RESTORE-FACTS FORGET LEARN ASSUME PRED-REVERSE PRE-ERR MEVALP2 MEVALP IS $KILLCONTEXT $NEWCONTEXT) 
;(*LEXPR $MIN $MAX $FACTS $DEACTIVATE $ACTIVATE $CONTEXT) 
;(*EXPR $GMARK $GVPRINT $GHPRINT $GTERPRI $EXITGRAPH $ENTERGRAPH $CLEAR $DRAWSYMBOL3 $LINE3 $VECTOR3 $POINT3 $SETPOINT3 $SIZE $SCREENSIZE1 $SCREENSIZE $DEFINESYMBOL $DRAWSYMBOL $LINE $VECTOR $POPDASH $PUSHDASH $CHANGEDASH $DEFINEDASH $POINT $SETPOINT) 
;(*EXPR MACHERRFUN IOLFUN TTYRETFUN TTYINTFUN TTYINTFUNSETUP $DSKGC I-$ALLOC $PAGEPAUSE MORE-FUN MTERPRI MFILE-OUT FILEPRINT FILESTRIP $DDT $LOGOUT $QUIT $TO_LISP COMPUTIME TIMEORG $THROW $UUO GETLABCHARN GETLABELS* GETLABELS $%TH $POISLIM $FPPREC CASIFY-EXPLODEN STRMEVAL MAKSTRING DOLLARIFY-NAME AMPERCHK $VERBIFY $NOUNIFY FULLSTRIP1 FULLSTRIP STRIPDOLLAR REMALIAS ALIAS RETRIEVE PRINL NONVARCHK NONSYMCHK FEXPRCHECK ERRBREAK $DEBUGMODE RULEOF REMVALUE REMLABELS KILL1 BATCH1 CARFILE MTRUENAME TRUEFNAME LOADFILE FILENAMEL MFBOUNDP DOLLARIFY LOAD-FILE FIND0 LOAD-FUNCTION FIND-FUNCTION REPRINT RUBOUT* FORMFEED $BOTHCASES TYI* ADDLABEL MEXPLODEN PRINTLABEL MAKELABEL MEVAL*) 
;(*LEXPR $FILEDEFAULTS $BREAK $RANDOM $READONLY $READ $PRINT) 
;(*EXPR MDESCRIBE) 
;(*EXPR ASK-INTEGER) 
;(*LEXPR $ASKINTEGER) 
;(*EXPR *ERRRJF-1 *MERROR-5 *MERROR-4 *MERROR-3 *MERROR-2 *MERROR-1 FSTRINGC READ-ONLY-ASSIGN $ERRORMSG) 
;(*LEXPR ERRRJF MERROR $ERROR) 
;(*EXPR FPENTIER *FPATAN ATANBIGFLOAT RATBIGFLOAT ADDBIGFLOAT $BFLOAT FP2FLO) 
;(*EXPR $ALLROOTS) 
;(*EXPR $BINOMIAL $GAMMA $ACSCH $ASECH $ACOTH $ATANH $ACOSH $ASINH $ACSC $ASEC $ACOT $ATAN $ACOS $ASIN $CSCH $SECH $COTH $TANH $COSH $SINH $CSC $SEC $COT $TAN $COS $SIN $LOG |''MAKE-FUN| DSKRAT MFILEP BIGFLOATM* ADD2LNC $SQRT $EXP RAT MRETURN OPTIONP MCONS-OP-ARGS $FUNMAKE MOPP1 MOPP ARRSTORE MGETL MREMPROP MPUTPROP MGET REMALIAS1 REMRULE REMARRELEM I-$REMVALUE REMPROPCHK REMOVE1 I-$REMOVE $PUT $REM $GET FUNCER $MAPATOM MMAPEV NEVERSET NUMERSET MSETCHK MSETERR $SUBVARP MQUOTEP MSETQP MEVALATOMS MSET MUNBIND MBIND MARGS MOP MEVAL2 MEVAL1 MEVAL MEVALN MAPPLY) 
;(*LEXPR $ALLBUT $MATRIX OUTERMAP1 FMAPL1 MCALL) 
;(*FEXPR DSKSETQ MDEFPROP) 
;;Surely we don't need to declare exprs on lispm
;;I have tried to eliminate anything other than plain functions and macros
;;with one or two defsubsts ;;which I should get rid of  --wfs
;; Definitions needed to use lmdcls.lisp
(defmacro fixnum (&rest ign)ign nil)
(defmacro flonum (&rest ign)ign nil)
;
;(proclaim '(special RULEFCNL $use_fast_arrays ))
;(proclaim '(special integerl nonintegerl))
; ;referenced in askp,declared in defint.
;(proclaim '(SPECIAL $USER_MESFILE DUMPING USER-MESFILE MASTER-MESFILE)) 
;(proclaim '(SPECIAL $UNIVERSE $DISPLAYSET)) 
;(proclaim '(SPECIAL $TR_WARN_BAD_FUNCTION_CALLS)) 
;(proclaim '(SPECIAL $RESULTANT)) 
;(proclaim '(SPECIAL $ROMBERGIT_USED $ROMBERGABS $ROMBERGTOL $ROMBERGMIN $ROMBERGIT)) 
;(proclaim '(SPECIAL $TRACE_MAX_INDENT $TRACE_BREAK_ARG $TRACE)) 
;(proclaim '(SPECIAL $TR_FLOAT_CAN_BRANCH_COMPLEX)) 
;(proclaim '(SPECIAL $SUBLIS_APPLY_LAMBDA)) 
;(proclaim '(SPECIAL $SUSPEND)) 
;(proclaim '(SPECIAL -SQRT3//2 SQRT3//2 -SQRT2//2 SQRT2//2 %PI//2 %PI//4 -1//2 1//2 $HALFANGLES $LOGARC $EXPONENTIALIZE $TRIGSIGN $TRIGEXPANDTIMES $TRIGEXPANDPLUS $TRIGEXPAND $TRIGINVERSES $%IARGS $%PIARGS)) 
;(proclaim '(SPECIAL $GAMMALIM $SUMSPLITFACT HALF%PI3 %PI2 HALF%PI FOURTH%PI %P%I)) 
;(proclaim '(SPECIAL ERRRJFFLAG HMODULUS MODULUS)) 
;(proclaim '(SPECIAL $POINTBOUND)) 
;(proclaim '(SPECIAL $MODE_CHECK_ERRORP $MODE_CHECK_WARNP $MODE_CHECKP)) 
;(proclaim '(SPECIAL $TR_GEN_TAGS $TR_STATE_VARS $TR_TRUE_NAME_OF_FILE_BEING_TRANSLATED $COMPGRIND TRANSL-FILE $TR_WINDY $TR_FILE_TTY_MESSAGESP $TR_OUTPUT_FILE_DEFAULT *TRANSL-FILE-DEBUG*)) 
;(proclaim '(SPECIAL $RATALGDENOM $RATWTLVL)) 
;(proclaim '(SPECIAL GENERATE-ATAN2 IMPLICIT-REAL)) 
;(proclaim '(SPECIAL $MAXAPPLYHEIGHT $MAXAPPLYDEPTH)) 
;(proclaim '(SPECIAL $TIMER_DEVALUE $TIMER $TRACE_MAX_INDENT $TRACE_BREAK_ARG $TRACE_SAFETY $TRACE)) 
;(FIXNUM $TRACE_MAX_INDENT) 
;(proclaim '(SPECIAL $LISTCONSTVARS)) 
;(proclaim '(SPECIAL TRAMP3$ TRAMP2$ TRAMP1$)) 
;(proclaim '(SPECIAL $PARSEWINDOW)) 
;(FIXNUM $PARSEWINDOW) 
;(proclaim '(SPECIAL $PRODHACK $SUMHACK $SIMPSUM $ZEROBERN $GENINDEX $GENSUMNUM $CAUCHYSUM)) 
;(proclaim '(SPECIAL $TR_BOUND_FUNCTION_APPLYP $TR_OPTIMIZE_MAX_LOOP *$ANY-MODES* *TR-WARN-BREAK* $TR_PREDICATE_BRAIN_DAMAGE $TR_NUMER $TR_ARRAY_AS_REF $TR_FUNCTION_CALL_DEFAULT *WARNED-MODE-VARS* *WARNED-FEXPRS* *WARNED-UN-DECLARED-VARS* $TR_WARN_UNDEFINED_VARIABLE $TR_WARN_MODE $TR_WARN_FEXPR $TR_WARN_MEVAL $TR_WARN_UNDECLARED TR-UNIQUE TR-ABORT *TRANSL-DEBUG* *TRANSL-BACKTRACE* TRANSLATE-TIME-EVALABLES SPECIALS ASSIGNS NEED-PROG? RETURN-MODE RETURNS INSIDE-MPROG TR-PROGRET FEXPRS EXPRS LEXPRS ARRAYS LOCAL TSTACK $SPECIAL $TRANSCOMPILE $TR_SEMICOMPILE $TRANSBIND)) 
;(proclaim '(special defined_variables forms-to-compile-queue typel *in-compile* declares))
;(proclaim '(SPECIAL $NEWFAC $NALGFAC SMALLPRIMES ALPHA MM* MPLC* MINPOLY* *MX* *MIN* GAUSS)) 
;(proclaim '(SPECIAL *ALPHA BIGPRIMES $GCD *GCDL*)) 
;(proclaim '(SPECIAL $RATDENOMDIVIDE $RATEXPAND $RATEPSILON $RATPRINT FR-FACTOR ADN* INRATSIMP TELLRATLIST $FACEXPAND $RATVARS $ALGEBRAIC $RATFAC $RATWEIGHTS $NOREPEAT $DONTFACTOR $FACTORFLAG $KEEPFLOAT *RATWEIGHTS *FNEWVARSW VARLIST GENPAIRS GENVAR)) 
;(proclaim '(SPECIAL $RESULTANT)) 
;(proclaim '(SPECIAL $LINSOLVE_PARAMS $%RNUM $BACKSUBST $SPARSE $GLOBALSOLVE)) 
;(proclaim '(SPECIAL $HOMOG_HACK $SAVEFACTORS $BERLEFACT $INTFACLIM LOW* ALGFAC* *IRREDS)) 
;(proclaim '(SPECIAL $BETA_ARGS_SUM_TO_INTEGER)) 
;(proclaim '(SPECIAL META-PROP-L META-PROP-P)) 
;(proclaim '(SPECIAL $FORTFLOAT $FORTINDENT $FORTSPACES)) 
;(FIXNUM $FORTINDENT) 
;(proclaim '(SPECIAL $MAXPRIME)) 
;(proclaim '(SPECIAL $MACROEXPANSION)) 
;(proclaim '(SPECIAL PRESERVE-DIRECTION LIMIT-ANSWERS SIMPLIMPLUS-PROBLEMS RD* INFINITESIMALS REAL-INFINITIES INFINITIES)) 
;(proclaim '(SPECIAL $SUPERLOGCON $LOGCONCOEFFP)) 
;(proclaim '(SPECIAL $ROOTSCONMODE)) 
;(proclaim '(SPECIAL $DISPLAY_FORMAT_INTERNAL $RMXCHAR $LMXCHAR $ABSBOXCHAR $BOXCHAR DISPLAYP STRINGDISP $FPTRUNC $NOUNDISP $DERIVABBREV $LINEDISP $LISPDISP $DISPLAY2D $LEFTJUST $STARDISP $CURSORDISP LINE-GRAPHICS-TTY CHARACTER-GRAPHICS-TTY)) 
;(proclaim '(SPECIAL $NEGSUMDISPFLAG $SQRTDISPFLAG $EXPTDISPFLAG $%EDISPFLAG $PFEFORMAT $POWERDISP)) 
;(proclaim '(SPECIAL $VECT_CROSS)) 
;(proclaim '(SPECIAL $MATRIX_ELEMENT_TRANSPOSE $MATRIX_ELEMENT_ADD $MATRIX_ELEMENT_MULT $RATMX)) 
;(proclaim '(SPECIAL DERIVSIMP ERRORSW DOSIMP $MAXNEGEX $MAXPOSEX $EXPON $EXPOP $MX0SIMP $DOMXTIMES $DOMXPLUS $DOMXEXPT $DOSCMXPLUS $NUMER_PBRANCH $SUMEXPAND $SIMP $NUMER $NEGDISTRIB $FLOAT)) 
;(FIXNUM $MAXNEGEX $MAXPOSEX $EXPON $EXPOP) 
;(proclaim '(SPECIAL ALGNOTEXACT $ALGEXACT REALONLYRATNUM $REALONLY $%RNUM_LIST)) 
;(proclaim '(SPECIAL $FILE_TYPES $FILE_SEARCH *IN-MACSYMA-INDEXER* *IN-TRANSLATE-FILE* *IN-$BATCHLOAD*)) 
;(proclaim '(SPECIAL $LET_RULE_PACKAGES $CURRENT_LET_RULE_PACKAGE $DEFAULT_LET_RULE_PACKAGE $LETRAT $LETVARSIMP)) 
;(proclaim '(SPECIAL $INTEGRATION_CONSTANT_COUNTER)) 
;(proclaim '(SPECIAL $OPTIMPREFIX)) 
;(proclaim '(SPECIAL $TO_CALL_LISP_COMPILER)) 
;(proclaim '(SPECIAL $ISOLATE_WRT_TIMES $EXPTISOLATE)) 
;(proclaim '(SPECIAL $SOLVERADCAN $SOLVETRIGWARN $SOLVENULLWARN $SOLVEFACTORS $SOLVEEXPLICIT $SOLVEDECOMPOSES $SAVEFACTORS $PROGRAMMODE $SOLVE_INCONSISTENT_ERROR $LINSOLVEWARN $MULTIPLICITIES $BREAKUP)) 
;(proclaim '(SPECIAL $TAYLOR_LOGEXPAND $TAYLOR_TRUNCATE_POLYNOMIALS $MAXTAYORDER)) 
;(proclaim '(SPECIAL $ERFFLAG $LIFLAG)) 
;(proclaim '(SPECIAL LIMITP $ASKEXP $SIGNBFLOAT $PREDERROR SIGN-IMAG-ERRP $ACTIVECONTEXTS $CONTEXTS $CONTEXT)) 
;(proclaim '(SPECIAL $SHOWTIME $FILE_STRING_PRINT $CHANGE_FILEDEFAULTS ALIASLIST $MOREWAIT $TTYINTFUN $TTYINTNUM USER-TIMESOFAR CASEP $DIREC $LINENUM $LINECHAR $OUTCHAR $INCHAR $%)) 
;(FIXNUM $LINENUM) 
;(proclaim '(SPECIAL DEFINTDEBUG)) 
;(proclaim '(SPECIAL $ERROR_SYMS $ERROR_SIZE $ERROR)) 
;(proclaim '(SPECIAL BIGFLOAT%PI BIGFLOAT%E BFMHALF BFHALF BIGFLOATONE BIGFLOATZERO $FPPREC $FPPRINTPREC $BFTRUNC $BFTORAT $FLOAT2BF)) 
;(FIXNUM $FPPRINTPREC) 
;(proclaim '(SPECIAL $ASSUMESCALAR $DOTIDENT $SCALARMATRIXP $DOMXNCTIMES $DOSCMXOPS $DOMXMXOPS $DOALLMXOPS $DOTASSOC $DOTEXPTSIMP $DOTDISTRIB $DOTSCRULES $DOT1SIMP $DOT0NSCSIMP $DOT0SIMP $DOTCONSTRULES)) 
;(proclaim '(SPECIAL $FLOATOPTIONS $FLOATWIDTH $FLOATPREC $FLOATFRAC $FLOATINT $FLOATFORMAT)) 
;(proclaim '(SPECIAL $SETCHECK MUNBINDP)) 
;(proclaim '(special $DEBUGMODE $BOTHCASES $PAGEPAUSE $DSKGC $POISLIM $STORENUM ^DMSG-ON ^DMSG-OFF ))
;
;(proclaim '(SPECIAL
;	    MSPECLIST MPROPLIST BINDLIST LOCLIST BVARS NOUNSFLAG putl
;	    NOITEMS DERIVFLAG DERIVLIST MPROGP MDOP EVP AEXPRP MLOCP $LABELS
;	    $VALUES $FUNCTIONS $ARRAYS $RULES $GRADEFS $DEPENDENCIES $ALIASES
;	    $MYOPTIONS $PROPS GENVAR $MAXPOSEX $MAXNEGEX $EXPOP $EXPON
;	    $FLOAT $NUMER ARYP MSUMP STATE-PDL EVARRP $SETVAL NOUNL
;	    $SETCHECKBREAK $REFCHECK DEBUG REFCHKL BAKTRCL MAPLP
;	    $NOREPEAT $DETOUT $DOALLMXOPS $DOSCMXOPS OPERS FACTLIST OPEXPRP
;	    $TRANSLATE $TRANSRUN $MAPERROR OUTARGS1 OUTARGS2 FMAPLVL MOPL
;	    $POWERDISP $SUBSCRMAP $DISPFLAG $OPTIONSET DSKSETP FEXPRERRP
;	    $FEATURES ALPHABET $%ENUMER $INFEVAL $SAVEDEF $%% %E-VAL
;	    $MAPPRINT FEATUREL OUTFILES FUNDEFSIMP MFEXPRP TRANSP
;	    SFINDEX MSPECLIST2 ENVLIST $MACROS LINEL $RATFAC $RATWTLVL
;	    $OPERATORS NOEVALARGS $PIECE $PARTSWITCH *GCDL*
;	    SCANMAPP ))
;
;(proclaim '	 (SPECIAL $EXPTSUBST $LINECHAR $NOLABELS
;			  $INFLAG $PIECE $DISPFLAG
;		  $GRADEFS $PROPS $DEPENDENCIES DERIVFLAG DERIVLIST
;		  $LINENUM $PARTSWITCH LINELABLE NN* DN* ISLINP
;		  $POWERDISP ATVARS ATP $ERREXP $DERIVSUBST $DOTDISTRIB
;		  $OPSUBST $SUBNUMSIMP $TRANSRUN IN-P SUBSTP $SQRTDISPFLAG
;		  $PFEFORMAT DUMMY-VARIABLE-OPERATORS))
;(proclaim '	 (SPECIAL $RADEXPAND $DOMAIN RADPE))
;(proclaim '(special lnorecurse &** timesp))
;(proclaim '(special $exponentialize))
;(proclaim '(special $functions $values linel))


;(FIXNUM $ROMBERGIT_USED $ROMBERGMIN $ROMBERGIT) 
;(FLONUM $ROMBERGABS $ROMBERGTOL) 
;(FIXNUM $TRACE_MAX_INDENT $TRACE_MAX_INDENT) 

;;this list should contain all specials required by runtime or more
;;than one macsyma file, except for some specials declared in the macro
;;files, eg displm

(eval-when (compile eval load)
(proclaim '(special
  $% $%% $%EDISPFLAG $%EMODE $%ENUMER $%E_TO_NUMLOG $%IARGS $%PIARGS
    $%RNUM $%RNUM_LIST $ABSBOXCHAR $ACTIVECONTEXTS $ALGEBRAIC $ALGEXACT
    $ALIASES $ARRAYS $ASKEXP $ASSUMESCALAR $BACKSUBST $BERLEFACT
    $BETA_ARGS_SUM_TO_INTEGER $BFTORAT $BFTRUNC $BOTHCASES $BOXCHAR
    $BREAKUP $CAUCHYSUM $CHANGE_FILEDEFAULTS $COMPGRIND $CONTEXT
    $CONTEXTS $CURRENT_LET_RULE_PACKAGE $CURSORDISP $DEBUGMODE
    $DEFAULT_LET_RULE_PACKAGE $DEMOIVRE $DEPENDENCIES $DERIVABBREV
    $DERIVSUBST $DETOUT $DIREC $DISPFLAG $DISPLAY2D $DISPLAYSET
    $DISPLAY_FORMAT_INTERNAL $DOALLMXOPS $DOMAIN $DOMXEXPT $DOMXMXOPS
    $DOMXNCTIMES $DOMXPLUS $DOMXTIMES $DONTFACTOR $DOSCMXOPS
    $DOSCMXPLUS $DOT0NSCSIMP $DOT0SIMP $DOT1SIMP $DOTASSOC
    $DOTCONSTRULES $DOTDISTRIB $DOTEXPTSIMP $DOTIDENT $DOTSCRULES
    $DSKGC $ERFFLAG $ERREXP $ERROR $ERROR_SIZE $ERROR_SYMS $EXPON
    $EXPONENTIALIZE $EXPOP $EXPTDISPFLAG $EXPTISOLATE $EXPTSUBST
    $FACEXPAND $FACTORFLAG $FEATURES $FILE_SEARCH $FILE_STRING_PRINT
    $FILE_TYPES $FLOAT $FLOAT2BF $FLOATFORMAT $FLOATFRAC $FLOATINT
    $FLOATOPTIONS $FLOATPREC $FLOATWIDTH $FORTFLOAT $FORTINDENT
    $FORTSPACES $FPPREC $FPPRINTPREC $FPTRUNC $FUNCTIONS $GAMMALIM $GCD
    $GENINDEX $GENSUMNUM $GLOBALSOLVE $GRADEFS $HALFANGLES $HOMOG_HACK
    $INCHAR $INFEVAL $INFLAG $INTEGRATION_CONSTANT_COUNTER $INTFACLIM
    $ISOLATE_WRT_TIMES $KEEPFLOAT $LABELS $LEFTJUST $LETRAT $LETVARSIMP
    $LET_RULE_PACKAGES $LIFLAG $LINECHAR $LINEDISP $LINENUM $linel
    $LINSOLVEWARN $LINSOLVE_PARAMS $LISPDISP $LISTARITH $LISTCONSTVARS
    $LMXCHAR $LOGARC $LOGCONCOEFFP $LOGEXPAND $LOGNEGINT $LOGNUMER
    $LOGSIMP $M1PBRANCH $MACROEXPANSION $MACROS $MAPERROR $MAPPRINT
    $MATRIX_ELEMENT_ADD $MATRIX_ELEMENT_MULT $MATRIX_ELEMENT_TRANSPOSE
    $MAXAPPLYDEPTH $MAXAPPLYHEIGHT $MAXNEGEX $MAXPOSEX $MAXPRIME
    $MAXTAYORDER $MODE_CHECKP $MODE_CHECK_ERRORP $MODE_CHECK_WARNP
    $MOREWAIT $MULTIPLICITIES $MX0SIMP $MYOPTIONS $NALGFAC $NEGDISTRIB
    $NEGSUMDISPFLAG $NEWFAC $NOLABELS $NOREPEAT $NOUNDISP $NUMER
    $NUMER_PBRANCH $OPERATORS $OPSUBST $OPTIMPREFIX $OPTIONSET $OUTCHAR
    $PAGEPAUSE $PARSEWINDOW $PARTSWITCH $PFEFORMAT $PIECE $POINTBOUND
    $POISLIM $POWERDISP $PREDERROR $PRODHACK $PROGRAMMODE $PROPS
    $RADEXPAND $RATALGDENOM $RATDENOMDIVIDE $RATEPSILON $RATEXPAND
    $RATFAC $RATMX $RATPRINT $RATSIMPEXPONS $RATVARS $RATWEIGHTS
    $RATWTLVL $REALONLY $REFCHECK $RESULTANT $RMXCHAR $ROMBERGABS
    $ROMBERGIT $ROMBERGIT_USED $ROMBERGMIN $ROMBERGTOL $ROOTSCONMODE
    $RULES $SAVEDEF $SAVEFACTORS $SCALARMATRIXP $SETCHECK
    $SETCHECKBREAK $SETVAL $SHOWTIME $SIGNBFLOAT $SIMP $SIMPSUM
    $SOLVEDECOMPOSES $SOLVEEXPLICIT $SOLVEFACTORS $SOLVENULLWARN
    $SOLVERADCAN $SOLVETRIGWARN $SOLVE_INCONSISTENT_ERROR $SPARSE
    $SPECIAL $SQRTDISPFLAG $STARDISP $STORENUM $SUBLIS_APPLY_LAMBDA
    $SUBNUMSIMP $SUBSCRMAP $SUMEXPAND $SUMHACK $SUMSPLITFACT
    $SUPERLOGCON $SUSPEND $TAYLOR_LOGEXPAND
    $TAYLOR_TRUNCATE_POLYNOMIALS $TIMER $TIMER_DEVALUE
    $TO_CALL_LISP_COMPILER $TRACE $TRACE_BREAK_ARG $TRACE_MAX_INDENT
    $TRACE_SAFETY $TRANSBIND $TRANSCOMPILE $TRANSLATE $TRANSRUN
    $TRIGEXPAND $TRIGEXPANDPLUS $TRIGEXPANDTIMES $TRIGINVERSES
    $TRIGSIGN $TR_ARRAY_AS_REF $TR_BOUND_FUNCTION_APPLYP
    $TR_FILE_TTY_MESSAGESP $TR_FLOAT_CAN_BRANCH_COMPLEX
    $TR_FUNCTION_CALL_DEFAULT $TR_GEN_TAGS $TR_NUMER
    $TR_OPTIMIZE_MAX_LOOP $TR_OUTPUT_FILE_DEFAULT
    $TR_PREDICATE_BRAIN_DAMAGE $TR_SEMICOMPILE $TR_STATE_VARS
    $TR_TRUE_NAME_OF_FILE_BEING_TRANSLATED $TR_WARN_BAD_FUNCTION_CALLS
    $TR_WARN_FEXPR $TR_WARN_MEVAL $TR_WARN_MODE $TR_WARN_UNDECLARED
    $TR_WARN_UNDEFINED_VARIABLE $TR_WINDY $TTYINTFUN $TTYINTNUM
    $UNIVERSE $USER_MESFILE $USE_FAST_ARRAYS $VALUES $VECT_CROSS
    $ZEROBERN %E-VAL %P%I %PI-VAL %PI//2 %PI//4 %PI2 &** *$ANY-MODES*
    *ALPHA *CONST* *FNEWVARSW *GCDL* *IN *IN-$BATCHLOAD* *IN-COMPILE*
    *IN-MACSYMA-INDEXER* *IN-TRANSLATE-FILE* *INV* *IRREDS *MIN* *MX*
    *N *OPERS-LIST *OUT *RATWEIGHTS *TR-WARN-BREAK* *TRANSL-BACKTRACE*
    *TRANSL-DEBUG* *TRANSL-FILE-DEBUG* *WARNED-FEXPRS*
    *WARNED-MODE-VARS* *WARNED-UN-DECLARED-VARS* *ZEXPTSIMP? |-1//2|
    -SQRT2//2 -SQRT3//2 |1//2| ADN* AEXPRP ALGFAC* ALGNOTEXACT
    ALIASLIST ALPHA ALPHABET ARRAYS ARYP ASSIGNS ATP ATVARS BAKTRCL
    BFHALF BFMHALF BIGFLOAT%E BIGFLOAT%PI BIGFLOATONE BIGFLOATZERO
    BIGPRIMES BINDLIST BVARS CASEP CHARACTER-GRAPHICS-TTY DEBUG
    DECLARES DEFINED_VARIABLES DEFINTDEBUG DERIVFLAG DERIVLIST
    DERIVSIMP DISPLAYP DN* DOSIMP DSKSETP DUMMY-VARIABLE-OPERATORS
    DUMPING ENVLIST ERRORSW ERRRJFFLAG EVARRP EVP EXPANDFLAG EXPANDP
    EXPRS EXPTRLSW FACTLIST FEATUREL FEXPRERRP FEXPRS FMAPLVL
    FORMS-TO-COMPILE-QUEUE FOURTH%PI FR-FACTOR FUNDEFSIMP GAUSS
    GENERATE-ATAN2 GENPAIRS GENVAR HALF%PI HALF%PI3 HMODULUS
    IMPLICIT-REAL IN-P INFINITESIMALS INFINITIES INRATSIMP INSIDE-MPROG
    INTEGERL ISLINP LEXPRS LIMIT-ANSWERS LIMITP LINE-GRAPHICS-TTY LINEL
    LINELABLE LNORECURSE LOCAL LOCLIST LOW* MAPLP MASTER-MESFILE MDOP
    META-PROP-L META-PROP-P MFEXPRP MINPOLY* MLOCP MM* MODULUS MOPL
    MPLC* MPROGP MPROPLIST MSPECLIST MSPECLIST2 MSUMP MUNBINDP
    NEED-PROG? NEGPRODS NEGSUMS NN* NOEVALARGS NOITEMS NONINTEGERL
    NOUNL NOUNSFLAG OPERS OPERS-LIST OPEXPRP OUTARGS1 OUTARGS2 OUTFILES
    PLUSFLAG PRESERVE-DIRECTION PRODS PUTL RADCANP RADPE RD*
    REAL-INFINITIES REALONLYRATNUM REFCHKL RETURN-MODE RETURNS RULEFCNL
    RULESW SCANMAPP SFINDEX SIGN-IMAG-ERRP SIMPLIMPLUS-PROBLEMS
    SMALLPRIMES SPECIALS SQRT2//2 SQRT3//2 STATE-PDL STRINGDISP SUBSTP
    SUMS TELLRATLIST TIMESINP TIMESP TR-ABORT TR-PROGRET TR-UNIQUE
    TRAMP1$ TRAMP2$ TRAMP3$ TRANSL-FILE TRANSLATE-TIME-EVALABLES TRANSP
    TSTACK TYPEL USER-MESFILE USER-TIMESOFAR VARLIST WFLAG ^DMSG-OFF
    ^DMSG-ON
    $wtlevel $cflength $weightlevels *trunclist $taylordepth
    $maxtaydiff $verbose $psexpand ps-bmt-disrep
    silent-taylor-flag $DEFINE_VARIABLE
    ))
)
(proclaim '(declaration splitfile))
(proclaim '(declaration unspecial))
(proclaim '(declaration muzzled))
(proclaim '(declaration no-type))
(proclaim '(declaration genprefix))
(proclaim '(declaration flonum))
(proclaim '(declaration *lexpr))
(proclaim '(declaration *fexpr))
(proclaim '(declaration *expr))
(proclaim '(declaration mapex))
(proclaim '(declaration macros))
(proclaim '(declaration array*))
(proclaim '(declaration notype))
(proclaim '(declaration object))
