/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2008, Red Hat Middleware LLC or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Middleware LLC.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 */
package org.hibernate.envers.test.integration.superclass.auditAtMethodSuperclassLevel;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;


/**
 * @author Adam Warski (adam at warski dot org)
 * 
 * @author Hern&aacute;n Chanfreau
 * 
 */
@Entity
public class NotAuditedSubclassEntity extends AuditedMethodMappedSuperclass {
	@Id
	@GeneratedValue
	private Integer id;
	
	private String notAuditedStr;

	public NotAuditedSubclassEntity() {
	}

	public NotAuditedSubclassEntity(Integer id, String str, String otherStr, String notAuditedStr) {
		super(str, otherStr);
		this.notAuditedStr = notAuditedStr;
		this.id = id;
	}

	public NotAuditedSubclassEntity(String str, String otherStr, String notAuditedStr) {
		super(str, otherStr);
		this.notAuditedStr = notAuditedStr;
	}

	public Integer getId() {
		return id;
	}

	public void setId(Integer id) {
		this.id = id;
	}

	public String getNotAuditedStr() {
		return notAuditedStr;
	}

	public void setNotAuditedStr(String notAuditedStr) {
		this.notAuditedStr = notAuditedStr;
	}

	public boolean equals(Object o) {
		if (this == o)
			return true;
		if (!(o instanceof NotAuditedSubclassEntity))
			return false;
		if (!super.equals(o))
			return false;

		NotAuditedSubclassEntity that = (NotAuditedSubclassEntity) o;

		if (id != null ? !id.equals(that.id) : that.id != null)
			return false;

		return true;
	}

	public int hashCode() {
		int result = super.hashCode();
		result = 31 * result + (id != null ? id.hashCode() : 0);
		return result;
	}
}
