//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

package armcustomerinsights

import (
	"context"
	"errors"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/arm"
	armruntime "github.com/Azure/azure-sdk-for-go/sdk/azcore/arm/runtime"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/cloud"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/policy"
	"github.com/Azure/azure-sdk-for-go/sdk/azcore/runtime"
	"net/http"
	"net/url"
	"strings"
)

// KpiClient contains the methods for the Kpi group.
// Don't use this type directly, use NewKpiClient() instead.
type KpiClient struct {
	host           string
	subscriptionID string
	pl             runtime.Pipeline
}

// NewKpiClient creates a new instance of KpiClient with the specified values.
// subscriptionID - Gets subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID
// forms part of the URI for every service call.
// credential - used to authorize requests. Usually a credential from azidentity.
// options - pass nil to accept the default values.
func NewKpiClient(subscriptionID string, credential azcore.TokenCredential, options *arm.ClientOptions) (*KpiClient, error) {
	if options == nil {
		options = &arm.ClientOptions{}
	}
	ep := cloud.AzurePublic.Services[cloud.ResourceManager].Endpoint
	if c, ok := options.Cloud.Services[cloud.ResourceManager]; ok {
		ep = c.Endpoint
	}
	pl, err := armruntime.NewPipeline(moduleName, moduleVersion, credential, runtime.PipelineOptions{}, options)
	if err != nil {
		return nil, err
	}
	client := &KpiClient{
		subscriptionID: subscriptionID,
		host:           ep,
		pl:             pl,
	}
	return client, nil
}

// BeginCreateOrUpdate - Creates a KPI or updates an existing KPI in the hub.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-04-26
// resourceGroupName - The name of the resource group.
// hubName - The name of the hub.
// kpiName - The name of the KPI.
// parameters - Parameters supplied to the create/update KPI operation.
// options - KpiClientBeginCreateOrUpdateOptions contains the optional parameters for the KpiClient.BeginCreateOrUpdate method.
func (client *KpiClient) BeginCreateOrUpdate(ctx context.Context, resourceGroupName string, hubName string, kpiName string, parameters KpiResourceFormat, options *KpiClientBeginCreateOrUpdateOptions) (*runtime.Poller[KpiClientCreateOrUpdateResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.createOrUpdate(ctx, resourceGroupName, hubName, kpiName, parameters, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[KpiClientCreateOrUpdateResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[KpiClientCreateOrUpdateResponse](options.ResumeToken, client.pl, nil)
	}
}

// CreateOrUpdate - Creates a KPI or updates an existing KPI in the hub.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-04-26
func (client *KpiClient) createOrUpdate(ctx context.Context, resourceGroupName string, hubName string, kpiName string, parameters KpiResourceFormat, options *KpiClientBeginCreateOrUpdateOptions) (*http.Response, error) {
	req, err := client.createOrUpdateCreateRequest(ctx, resourceGroupName, hubName, kpiName, parameters, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// createOrUpdateCreateRequest creates the CreateOrUpdate request.
func (client *KpiClient) createOrUpdateCreateRequest(ctx context.Context, resourceGroupName string, hubName string, kpiName string, parameters KpiResourceFormat, options *KpiClientBeginCreateOrUpdateOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/kpi/{kpiName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if kpiName == "" {
		return nil, errors.New("parameter kpiName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{kpiName}", url.PathEscape(kpiName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPut, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, runtime.MarshalAsJSON(req, parameters)
}

// BeginDelete - Deletes a KPI in the hub.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-04-26
// resourceGroupName - The name of the resource group.
// hubName - The name of the hub.
// kpiName - The name of the KPI.
// options - KpiClientBeginDeleteOptions contains the optional parameters for the KpiClient.BeginDelete method.
func (client *KpiClient) BeginDelete(ctx context.Context, resourceGroupName string, hubName string, kpiName string, options *KpiClientBeginDeleteOptions) (*runtime.Poller[KpiClientDeleteResponse], error) {
	if options == nil || options.ResumeToken == "" {
		resp, err := client.deleteOperation(ctx, resourceGroupName, hubName, kpiName, options)
		if err != nil {
			return nil, err
		}
		return runtime.NewPoller[KpiClientDeleteResponse](resp, client.pl, nil)
	} else {
		return runtime.NewPollerFromResumeToken[KpiClientDeleteResponse](options.ResumeToken, client.pl, nil)
	}
}

// Delete - Deletes a KPI in the hub.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-04-26
func (client *KpiClient) deleteOperation(ctx context.Context, resourceGroupName string, hubName string, kpiName string, options *KpiClientBeginDeleteOptions) (*http.Response, error) {
	req, err := client.deleteCreateRequest(ctx, resourceGroupName, hubName, kpiName, options)
	if err != nil {
		return nil, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return nil, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK, http.StatusAccepted) {
		return nil, runtime.NewResponseError(resp)
	}
	return resp, nil
}

// deleteCreateRequest creates the Delete request.
func (client *KpiClient) deleteCreateRequest(ctx context.Context, resourceGroupName string, hubName string, kpiName string, options *KpiClientBeginDeleteOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/kpi/{kpiName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if kpiName == "" {
		return nil, errors.New("parameter kpiName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{kpiName}", url.PathEscape(kpiName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodDelete, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}

// Get - Gets a KPI in the hub.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-04-26
// resourceGroupName - The name of the resource group.
// hubName - The name of the hub.
// kpiName - The name of the KPI.
// options - KpiClientGetOptions contains the optional parameters for the KpiClient.Get method.
func (client *KpiClient) Get(ctx context.Context, resourceGroupName string, hubName string, kpiName string, options *KpiClientGetOptions) (KpiClientGetResponse, error) {
	req, err := client.getCreateRequest(ctx, resourceGroupName, hubName, kpiName, options)
	if err != nil {
		return KpiClientGetResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return KpiClientGetResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusOK) {
		return KpiClientGetResponse{}, runtime.NewResponseError(resp)
	}
	return client.getHandleResponse(resp)
}

// getCreateRequest creates the Get request.
func (client *KpiClient) getCreateRequest(ctx context.Context, resourceGroupName string, hubName string, kpiName string, options *KpiClientGetOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/kpi/{kpiName}"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if kpiName == "" {
		return nil, errors.New("parameter kpiName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{kpiName}", url.PathEscape(kpiName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// getHandleResponse handles the Get response.
func (client *KpiClient) getHandleResponse(resp *http.Response) (KpiClientGetResponse, error) {
	result := KpiClientGetResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KpiResourceFormat); err != nil {
		return KpiClientGetResponse{}, err
	}
	return result, nil
}

// NewListByHubPager - Gets all the KPIs in the specified hub.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-04-26
// resourceGroupName - The name of the resource group.
// hubName - The name of the hub.
// options - KpiClientListByHubOptions contains the optional parameters for the KpiClient.ListByHub method.
func (client *KpiClient) NewListByHubPager(resourceGroupName string, hubName string, options *KpiClientListByHubOptions) *runtime.Pager[KpiClientListByHubResponse] {
	return runtime.NewPager(runtime.PagingHandler[KpiClientListByHubResponse]{
		More: func(page KpiClientListByHubResponse) bool {
			return page.NextLink != nil && len(*page.NextLink) > 0
		},
		Fetcher: func(ctx context.Context, page *KpiClientListByHubResponse) (KpiClientListByHubResponse, error) {
			var req *policy.Request
			var err error
			if page == nil {
				req, err = client.listByHubCreateRequest(ctx, resourceGroupName, hubName, options)
			} else {
				req, err = runtime.NewRequest(ctx, http.MethodGet, *page.NextLink)
			}
			if err != nil {
				return KpiClientListByHubResponse{}, err
			}
			resp, err := client.pl.Do(req)
			if err != nil {
				return KpiClientListByHubResponse{}, err
			}
			if !runtime.HasStatusCode(resp, http.StatusOK) {
				return KpiClientListByHubResponse{}, runtime.NewResponseError(resp)
			}
			return client.listByHubHandleResponse(resp)
		},
	})
}

// listByHubCreateRequest creates the ListByHub request.
func (client *KpiClient) listByHubCreateRequest(ctx context.Context, resourceGroupName string, hubName string, options *KpiClientListByHubOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/kpi"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodGet, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	req.Raw().Header["Accept"] = []string{"application/json"}
	return req, nil
}

// listByHubHandleResponse handles the ListByHub response.
func (client *KpiClient) listByHubHandleResponse(resp *http.Response) (KpiClientListByHubResponse, error) {
	result := KpiClientListByHubResponse{}
	if err := runtime.UnmarshalAsJSON(resp, &result.KpiListResult); err != nil {
		return KpiClientListByHubResponse{}, err
	}
	return result, nil
}

// Reprocess - Reprocesses the Kpi values of the specified KPI.
// If the operation fails it returns an *azcore.ResponseError type.
// Generated from API version 2017-04-26
// resourceGroupName - The name of the resource group.
// hubName - The name of the hub.
// kpiName - The name of the KPI.
// options - KpiClientReprocessOptions contains the optional parameters for the KpiClient.Reprocess method.
func (client *KpiClient) Reprocess(ctx context.Context, resourceGroupName string, hubName string, kpiName string, options *KpiClientReprocessOptions) (KpiClientReprocessResponse, error) {
	req, err := client.reprocessCreateRequest(ctx, resourceGroupName, hubName, kpiName, options)
	if err != nil {
		return KpiClientReprocessResponse{}, err
	}
	resp, err := client.pl.Do(req)
	if err != nil {
		return KpiClientReprocessResponse{}, err
	}
	if !runtime.HasStatusCode(resp, http.StatusAccepted) {
		return KpiClientReprocessResponse{}, runtime.NewResponseError(resp)
	}
	return KpiClientReprocessResponse{}, nil
}

// reprocessCreateRequest creates the Reprocess request.
func (client *KpiClient) reprocessCreateRequest(ctx context.Context, resourceGroupName string, hubName string, kpiName string, options *KpiClientReprocessOptions) (*policy.Request, error) {
	urlPath := "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.CustomerInsights/hubs/{hubName}/kpi/{kpiName}/reprocess"
	if resourceGroupName == "" {
		return nil, errors.New("parameter resourceGroupName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{resourceGroupName}", url.PathEscape(resourceGroupName))
	if hubName == "" {
		return nil, errors.New("parameter hubName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{hubName}", url.PathEscape(hubName))
	if kpiName == "" {
		return nil, errors.New("parameter kpiName cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{kpiName}", url.PathEscape(kpiName))
	if client.subscriptionID == "" {
		return nil, errors.New("parameter client.subscriptionID cannot be empty")
	}
	urlPath = strings.ReplaceAll(urlPath, "{subscriptionId}", url.PathEscape(client.subscriptionID))
	req, err := runtime.NewRequest(ctx, http.MethodPost, runtime.JoinPaths(client.host, urlPath))
	if err != nil {
		return nil, err
	}
	reqQP := req.Raw().URL.Query()
	reqQP.Set("api-version", "2017-04-26")
	req.Raw().URL.RawQuery = reqQP.Encode()
	return req, nil
}
