//go:build go1.18
// +build go1.18

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.
// DO NOT EDIT.

package armfluidrelay

import "time"

// Container - A FluidRelay Container.
type Container struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The resource-specific properties for this resource.
	Properties *ContainerProperties `json:"properties,omitempty" azure:"ro"`

	// READ-ONLY; System meta data for this resource, including creation and modification information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ContainerList - Paged response
type ContainerList struct {
	// A sequence of FluidRelay containers.
	Value []*Container `json:"value,omitempty"`

	// READ-ONLY; A link to the next page of results, if any.
	NextLink *string `json:"nextLink,omitempty" azure:"ro"`
}

// ContainerProperties - The properties of a Fluid Relay Container resource.
type ContainerProperties struct {
	// READ-ONLY; The creation time of this resource
	CreationTime *time.Time `json:"creationTime,omitempty" azure:"ro"`

	// READ-ONLY; The frsContainerId for this container
	FrsContainerID *string `json:"frsContainerId,omitempty" azure:"ro"`

	// READ-ONLY; The Fluid tenantId for this container
	FrsTenantID *string `json:"frsTenantId,omitempty" azure:"ro"`

	// READ-ONLY; Last time when user access this resource
	LastAccessTime *time.Time `json:"lastAccessTime,omitempty" azure:"ro"`

	// READ-ONLY; Provision states for FluidRelay RP
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty" azure:"ro"`
}

// ContainersClientDeleteOptions contains the optional parameters for the ContainersClient.Delete method.
type ContainersClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ContainersClientGetOptions contains the optional parameters for the ContainersClient.Get method.
type ContainersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ContainersClientListByFluidRelayServersOptions contains the optional parameters for the ContainersClient.ListByFluidRelayServers
// method.
type ContainersClientListByFluidRelayServersOptions struct {
	// placeholder for future optional parameters
}

// CustomerManagedKeyEncryptionProperties - All Customer-managed key encryption properties for the resource.
type CustomerManagedKeyEncryptionProperties struct {
	// All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
	KeyEncryptionKeyIdentity *CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentity `json:"keyEncryptionKeyIdentity,omitempty"`

	// key encryption key Url, with or without a version. Ex: https://contosovault.vault.azure.net/keys/contosokek/562a4bb76b524a1493a6afe8e536ee78
	// or https://contosovault.vault.azure.net/keys/contosokek.
	// Key auto rotation is enabled by providing a key uri without version. Otherwise, customer is responsible for rotating the
	// key. The keyEncryptionKeyIdentity(either SystemAssigned or UserAssigned) should
	// have permission to access this key url.
	KeyEncryptionKeyURL *string `json:"keyEncryptionKeyUrl,omitempty"`
}

// CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentity - All identity configuration for Customer-managed key settings
// defining which identity should be used to auth to Key Vault.
type CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentity struct {
	// Values can be SystemAssigned or UserAssigned
	IdentityType *CmkIdentityType `json:"identityType,omitempty"`

	// user assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/
	// /providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId. Mutually exclusive with identityType systemAssignedIdentity.
	UserAssignedIdentityResourceID *string `json:"userAssignedIdentityResourceId,omitempty"`
}

// EncryptionProperties - All encryption configuration for a resource.
type EncryptionProperties struct {
	// All Customer-managed key encryption properties for the resource.
	CustomerManagedKeyEncryption *CustomerManagedKeyEncryptionProperties `json:"customerManagedKeyEncryption,omitempty"`
}

// Endpoints - The Fluid Relay endpoints for this server
type Endpoints struct {
	// READ-ONLY; The Fluid Relay Orderer endpoints.
	OrdererEndpoints []*string `json:"ordererEndpoints,omitempty" azure:"ro"`

	// READ-ONLY; The Fluid Relay service endpoints.
	ServiceEndpoints []*string `json:"serviceEndpoints,omitempty" azure:"ro"`

	// READ-ONLY; The Fluid Relay storage endpoints.
	StorageEndpoints []*string `json:"storageEndpoints,omitempty" azure:"ro"`
}

// ErrorAdditionalInfo - The resource management error additional info.
type ErrorAdditionalInfo struct {
	// READ-ONLY; The additional info.
	Info interface{} `json:"info,omitempty" azure:"ro"`

	// READ-ONLY; The additional info type.
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ErrorDetail - The error detail.
type ErrorDetail struct {
	// READ-ONLY; The error additional info.
	AdditionalInfo []*ErrorAdditionalInfo `json:"additionalInfo,omitempty" azure:"ro"`

	// READ-ONLY; The error code.
	Code *string `json:"code,omitempty" azure:"ro"`

	// READ-ONLY; The error details.
	Details []*ErrorDetail `json:"details,omitempty" azure:"ro"`

	// READ-ONLY; The error message.
	Message *string `json:"message,omitempty" azure:"ro"`

	// READ-ONLY; The error target.
	Target *string `json:"target,omitempty" azure:"ro"`
}

// ErrorResponse - Common error response for all Azure Resource Manager APIs to return error details for failed operations.
// (This also follows the OData error response format.).
type ErrorResponse struct {
	// The error object.
	Error *ErrorDetail `json:"error,omitempty"`
}

// Identity for the resource.
type Identity struct {
	// The identity type.
	Type *ResourceIdentityType `json:"type,omitempty"`

	// The list of user identities associated with the resource.
	UserAssignedIdentities map[string]*UserAssignedIdentitiesValue `json:"userAssignedIdentities,omitempty"`

	// READ-ONLY; The principal ID of resource identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`

	// READ-ONLY; The tenant ID of resource.
	TenantID *string `json:"tenantId,omitempty" azure:"ro"`
}

// OperationDisplay - The object that represents the operation.
type OperationDisplay struct {
	// Description of the operation, e.g., 'Write confluent'.
	Description *string `json:"description,omitempty"`

	// Operation type, e.g., read, write, delete, etc.
	Operation *string `json:"operation,omitempty"`

	// Service provider: Microsoft.FluidRelay
	Provider *string `json:"provider,omitempty"`

	// Type on which the operation is performed, e.g., 'servers'.
	Resource *string `json:"resource,omitempty"`
}

// OperationListResult - Result of GET request to list FluidRelay operations.
type OperationListResult struct {
	// URL to get the next set of operation list results if there are any.
	NextLink *string `json:"nextLink,omitempty"`

	// List of FluidRelay operations supported by the Microsoft.FluidRelay provider.
	Value []*OperationResult `json:"value,omitempty"`
}

// OperationResult - A FluidRelay REST API operation.
type OperationResult struct {
	// The object that represents the operation.
	Display *OperationDisplay `json:"display,omitempty"`

	// Indicates whether the operation is a data action
	IsDataAction *bool `json:"isDataAction,omitempty"`

	// Operation name: {provider}/{resource}/{operation}
	Name *string `json:"name,omitempty"`
}

// OperationsClientListOptions contains the optional parameters for the OperationsClient.List method.
type OperationsClientListOptions struct {
	// placeholder for future optional parameters
}

// ProxyResource - The resource model definition for a Azure Resource Manager proxy resource. It will not have tags and a
// location
type ProxyResource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// RegenerateKeyRequest - Specifies which key should be generated.
type RegenerateKeyRequest struct {
	// REQUIRED; The key to regenerate.
	KeyName *KeyName `json:"keyName,omitempty"`
}

// Resource - Common fields that are returned in the response for all Azure Resource Manager resources
type Resource struct {
	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// Server - A FluidRelay Server.
type Server struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The type of identity used for the resource.
	Identity *Identity `json:"identity,omitempty"`

	// The resource-specific properties for this resource.
	Properties *ServerProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; System meta data for this resource, including creation and modification information.
	SystemData *SystemData `json:"systemData,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

// ServerKeys - The set of available keys for this server.
type ServerKeys struct {
	// READ-ONLY; The primary key for this server
	Key1 *string `json:"key1,omitempty" azure:"ro"`

	// READ-ONLY; The secondary key for this server
	Key2 *string `json:"key2,omitempty" azure:"ro"`
}

// ServerList - Paged response
type ServerList struct {
	// REQUIRED; A sequence of FluidRelay servers.
	Value []*Server `json:"value,omitempty"`

	// A link to the next page of results, if any.
	NextLink *string `json:"nextLink,omitempty"`
}

// ServerProperties - The properties of a Fluid Relay Service resource.
type ServerProperties struct {
	// All encryption configuration for a resource.
	Encryption *EncryptionProperties `json:"encryption,omitempty"`

	// Provision states for FluidRelay RP
	ProvisioningState *ProvisioningState `json:"provisioningState,omitempty"`

	// Sku of the storage associated with the resource
	Storagesku *StorageSKU `json:"storagesku,omitempty"`

	// READ-ONLY; The Fluid Relay Service endpoints for this server.
	FluidRelayEndpoints *Endpoints `json:"fluidRelayEndpoints,omitempty" azure:"ro"`

	// READ-ONLY; The Fluid tenantId for this server
	FrsTenantID *string `json:"frsTenantId,omitempty" azure:"ro"`
}

// ServerUpdate - The updatable properties of a Fluid Relay server
type ServerUpdate struct {
	// The type of identity used for the resource.
	Identity *Identity `json:"identity,omitempty"`

	// The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// The resource-specific properties that can be updated for this resource.
	Properties *ServerUpdateProperties `json:"properties,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`
}

// ServerUpdateProperties - The properties that can be provided when updating FluidRelayServer resource
type ServerUpdateProperties struct {
	// All encryption configuration for a resource.
	Encryption *EncryptionProperties `json:"encryption,omitempty"`
}

// ServersClientCreateOrUpdateOptions contains the optional parameters for the ServersClient.CreateOrUpdate method.
type ServersClientCreateOrUpdateOptions struct {
	// placeholder for future optional parameters
}

// ServersClientDeleteOptions contains the optional parameters for the ServersClient.Delete method.
type ServersClientDeleteOptions struct {
	// placeholder for future optional parameters
}

// ServersClientGetOptions contains the optional parameters for the ServersClient.Get method.
type ServersClientGetOptions struct {
	// placeholder for future optional parameters
}

// ServersClientListByResourceGroupOptions contains the optional parameters for the ServersClient.ListByResourceGroup method.
type ServersClientListByResourceGroupOptions struct {
	// placeholder for future optional parameters
}

// ServersClientListBySubscriptionOptions contains the optional parameters for the ServersClient.ListBySubscription method.
type ServersClientListBySubscriptionOptions struct {
	// placeholder for future optional parameters
}

// ServersClientListKeysOptions contains the optional parameters for the ServersClient.ListKeys method.
type ServersClientListKeysOptions struct {
	// placeholder for future optional parameters
}

// ServersClientRegenerateKeyOptions contains the optional parameters for the ServersClient.RegenerateKey method.
type ServersClientRegenerateKeyOptions struct {
	// placeholder for future optional parameters
}

// ServersClientUpdateOptions contains the optional parameters for the ServersClient.Update method.
type ServersClientUpdateOptions struct {
	// placeholder for future optional parameters
}

// SystemData - Metadata pertaining to creation and last modification of the resource.
type SystemData struct {
	// The timestamp of resource creation (UTC).
	CreatedAt *time.Time `json:"createdAt,omitempty"`

	// The identity that created the resource.
	CreatedBy *string `json:"createdBy,omitempty"`

	// The type of identity that created the resource.
	CreatedByType *CreatedByType `json:"createdByType,omitempty"`

	// The timestamp of resource last modification (UTC)
	LastModifiedAt *time.Time `json:"lastModifiedAt,omitempty"`

	// The identity that last modified the resource.
	LastModifiedBy *string `json:"lastModifiedBy,omitempty"`

	// The type of identity that last modified the resource.
	LastModifiedByType *CreatedByType `json:"lastModifiedByType,omitempty"`
}

// TrackedResource - The resource model definition for an Azure Resource Manager tracked top level resource which has 'tags'
// and a 'location'
type TrackedResource struct {
	// REQUIRED; The geo-location where the resource lives
	Location *string `json:"location,omitempty"`

	// Resource tags.
	Tags map[string]*string `json:"tags,omitempty"`

	// READ-ONLY; Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
	ID *string `json:"id,omitempty" azure:"ro"`

	// READ-ONLY; The name of the resource
	Name *string `json:"name,omitempty" azure:"ro"`

	// READ-ONLY; The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
	Type *string `json:"type,omitempty" azure:"ro"`
}

type UserAssignedIdentitiesValue struct {
	// READ-ONLY; The client id of user assigned identity.
	ClientID *string `json:"clientId,omitempty" azure:"ro"`

	// READ-ONLY; The principal id of user assigned identity.
	PrincipalID *string `json:"principalId,omitempty" azure:"ro"`
}
