---
stage: Application Security Testing
group: Dynamic Analysis
info: To determine the technical writer assigned to the Stage/Group associated with this page, see https://handbook.gitlab.com/handbook/product/ux/technical-writing/#assignments
---

# OS Command Injection

## Description

It is possible to execute arbitrary OS commands on the target application server.
OS Command Injection is a critical vulnerability that can lead to a full system
compromise.

## Remediation

User input should never be used in constructing commands or command arguments
to functions which execute OS commands. This includes filenames supplied by
user uploads or downloads.

Ensure your application does not:

- Use user-supplied information in the process name to execute.
- Use user-supplied information in an OS command execution function which does
  not escape shell meta-characters.
- Use user-supplied information in arguments to OS commands.

The application should have a hardcoded set of arguments that are to be passed
to OS commands. If filenames are being passed to these functions, it is
recommended that a hash of the filename be used instead, or some other unique
identifier. It is strongly recommended that a native library that implements
the same functionality be used instead of using OS system commands due to the
risk of unknown attacks against third party commands.

## Details

| ID | Aggregated | CWE | Type | Risk |
|:---|:--------|:--------|:--------|:--------|
| 78.1 | false | 78 | Active | high |

## Links

- [OWASP](https://owasp.org/www-community/attacks/Command_Injection)
- [CWE](https://cwe.mitre.org/data/definitions/78.html)
