#!/bin/sh

#-----------------------------------------------------------------------------
# Sample shell script to show to process a NcFTPd event real-time
#-----------------------------------------------------------------------------

# Sample input:
#   LOGIN anonymous  a@localhost dflt localhost
#   DOWNLOAD anonymous  a@localhost dflt localhost /home/ftp/pub/stuff 14259 0.004 3132.689  OK 

#-----------------------------------------------------------------------------
# functions
#-----------------------------------------------------------------------------

Upload () {
	echo "$f_pathname was uploaded; finishing status was $f_xferstatus." >> /tmp/ncftp.events.out
}	# Upload


Download () {
	echo "$f_pathname was downloaded; finishing status was $f_xferstatus." >> /tmp/ncftp.events.out
}	# Download


Login () {
	echo "$f_user@$f_rhost logged into $f_setname." >> /tmp/ncftp.events.out
}	# Login


Logout () {
	echo "$f_user@$f_rhost logged out of $f_setname." >> /tmp/ncftp.events.out
}	# Login

#-----------------------------------------------------------------------------
# main 
#-----------------------------------------------------------------------------

## i=0
## args=""
## for arg in "$@"
## do
## 	i=`expr $i + 1`
## 	args="$args $i=[$arg]"
## done
## echo "$args" >> /tmp/ncftp.events.out

f_event="$1"					# event type
f_user="$2"					# login name
f_restr="$3"					# restricted user type
f_email="$4"					# email address, if anonymous user
f_setname="$5"					# virtual domain set-name
f_rhost="$6"					# remote host

case "$f_event" in
	UPLOAD)
		f_pathname="$7"			# file pathname
		f_xferamt="$8"			# amount transferred
		f_xferdur="$9"			# transfer duration
		f_xferrate="${10}"		# kB/sec
		f_xfersfx="${11}"		# on-the-fly processing, if any (i.e. .tar, .tar.gz)
		f_xferstatus="${12}"		# transfer finishing status
		Upload
		;;

	DOWNLOAD)
		f_pathname="$7"			# file pathname
		f_xferamt="$8"			# amount transferred
		f_xferdur="$9"			# transfer duration
		f_xferrate="${10}"		# kB/sec
		f_xfersfx="${11}"		# on-the-fly processing, if any (i.e. .tar, .tar.gz)
		f_xferstatus="${12}"		# transfer finishing status
		Download
		;;

	LOGIN)
		# (no additional fields)
		Login
		;;

	LOGOUT)
		f_sessdur="$7"			# session duration, in seconds
		f_avgcmdwait="$8"		# average time between commands
		f_totaldl="$9"			# total bytes downloaded
		f_totalul="${10}"		# total bytes uploaded
		f_totalcmds="${11}"		# total number of FTP commands issued
		f_totaldlcmds="${12}"		# total number of downloads attempted
		f_totalulcmds="${13}"		# total number of uploads attempted
		Logout
		;;
esac
