#!/bin/sh
#
# This script is an example of how to process the NcFTPd "xfer" log files.
# The NcFTPd Reporting Package (in the ../reports directory) is also included
# in the distribution and does more complex analysis than this script.
#

if [ $# -eq 0 ] ; then
	echo "Usage:  $0 <NcFTPd xfer log files>" 1>&2
	exit 2
fi

#
# Try "nawk", "gawk", or "mawk", if you get syntax errors running this.
#
AWK="awk"

cat "$@" | \
$AWK '{
	year = substr($0, 1, 4);
	month = substr($0, 6, 2);
	day = substr($0, 9, 2);
	hour = substr($0, 12, 2);
	minute = substr($0, 15, 2);
	second = substr($0, 18, 2);

	for (i=20; i<length($0); i++) {
		if (substr($0, i, 1) == "|")
			break;
	}
	if (substr($0, i, 1) == "|") {
		rest = substr($0, i + 2);
		ltype = substr(rest, 1, 1);
		if ((ltype == "R") || (ltype == "S")) {
			# Note:  only process R and S lines,
			# which are Retrieve and Store (download and upload)
			# log entries.
			#
			printf("%s,%s,%s,%s,%s,%s,%s\n", year, month, day, hour, minute, second, rest);
		}
	}
}' | \
sed 's/,,/, ,/g;s/,,,/, , ,/g;s/,,/, ,/g' | \
$AWK '-F,' '{
	year=$1;
	month=int($2);
	day=$3;
	hour=$4;
	minute=$5;
	second=$6;
	retr=$7;	# R for retrieve, S for store
	filename=$8;
	filesize=$9;
	dura=$10;
	kbsec=$11;
	login=$12;
	email=$13;	# may not be valid
	host=$14;
	suffix=$15;	# empty for plain transfers, or ".tar", ".gz",
			# or ".tar.gz" if they used on-the-fly

	if (login == " ")
		login = "unknown";
	if (host == " ")
		host = "unknown";
	if (email == " ")
		email = "unknown";

	if (retr == "S") {
		uploaded += filesize / 1024.0;
		uploads++;
		uploadtime += dura;
	} else {
		downloaded += filesize / 1024.0;
		downloads++;
		downloadtime += dura;
	}
}
END {
	if (uploadtime > 0) {
		urate = uploaded / uploadtime;
		printf("Total number of uploads:    %9d\n", uploads);
		printf("Total kilobytes uploaded:   %9d\n", uploaded);
		printf("Average upload rate:        %12.2f kB/sec\n", urate);
		print "";
	}
	if (downloadtime > 0) {
		drate = downloaded / downloadtime;
		printf("Total number of downloads:  %9d\n", downloads);
		printf("Total kilobytes downloaded: %9d\n", downloaded);
		printf("Average download rate:      %12.2f kB/sec\n", drate);
		print "";
		printf("Most popular downloads:\n");
		printf("======================\n");
	}
}'

cat "$@" | fgrep '| R,/' | cut -d, -f2 | sort | uniq -c | sort -n -r | head -14
exit 0
