#!/bin/ksh

#############################################################################
# Copyright 1998, Mike Gleason.  All rights reserved.
#############################################################################

. /usr/local/etc/ncftpd/rptbin/ncftpd_reports.env

#############################################################################
# No more user-configurable options below this point.
#############################################################################

whoiam1=`$WHOAMI 2>/dev/null`
if [ "$whoiam1" = "" ] ; then whoiam="web" ; else whoiam="<b>$whoiam1</b>" ; fi

onhost1=`uname -n 2>/dev/null`
if [ "$onhost1" != "" ] ; then onhost=" on <b>$onhost1</b>" ; else onhost="" ; fi

#############################################################################
# Validate the input
#############################################################################

echo "Content-type: text/html"
echo ""

if [ "$#" -ne 11 ] ; then
	echo "<html><head><title>error</title></head><body>"
	echo "<p>Not enough parameters ($# of 11) given to generate report.</p>"
	echo "<p><address></address></body></html>"
	exit 2
fi

start_Y="$1"
start_B="$2"
start_d="$3"
start_H="$4"
start_M="$5"
shift 5

end_Y="$1"
end_B="$2"
end_d="$3"
end_H="$4"
end_M="$5"
shift 5

user="$1"

#############################################################################
# Sanity checks
#############################################################################

if [ ! -x "$LOGCAT" ] ; then
	echo "<html><head><title>error</title></head><body>"
	echo "<p>Cannot execute <TT>$LOGCAT</TT> as $whoiam user${onhost}."
	echo "<p><address></address></body></html>"
	exit 2
fi

##############################################################################
# Convert the "%B" form of the month into "%m" form
# (Unfortunate english language dependency)
##############################################################################

B="$start_B"
case "$B" in
	Jan*)	m=01 ;; Feb*)	m=02 ;; Mar*)	m=03 ;;
	Apr*)	m=04 ;; May*)	m=05 ;; Jun*)	m=06 ;;
	Jul*)	m=07 ;; Aug*)	m=08 ;; Sep*)	m=09 ;;
	Oct*)	m=10 ;; Nov*)	m=11 ;; Dec*)	m=12 ;;
	[0-9]*)	m="$B";; *)	m=01 ;;
esac
start_m="$m"

B="$end_B"
case "$B" in
	Jan*)	m=01 ;; Feb*)	m=02 ;; Mar*)	m=03 ;;
	Apr*)	m=04 ;; May*)	m=05 ;; Jun*)	m=06 ;;
	Jul*)	m=07 ;; Aug*)	m=08 ;; Sep*)	m=09 ;;
	Oct*)	m=10 ;; Nov*)	m=11 ;; Dec*)	m=12 ;;
	[0-9]*)	m="$B";; *)	m=01 ;;
esac
end_m="$m"

##############################################################################
# Convert the dates into timestamps.
# This is needed so we can compute the names of the monthly log files
# that will be used to get the stats from.
##############################################################################

start_date="${start_Y}-${start_m}-${start_d} ${start_H}:${start_M}:00"
start_ts=`$DATEMUNGER "$start_date"`
case "$start_ts" in
	[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]*)
		;;
	*)
		echo "<html><head><title>error</title></head><body>"
		echo "<p>Could not convert \"$start_date\" back to a timestamp."
		echo "<p><address></address></body></html>"
		exit 1
esac

end_date="${end_Y}-${end_m}-${end_d} ${end_H}:${end_M}:00"
end_ts=`$DATEMUNGER "$end_date"`
case "$end_ts" in
	[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]*)
		;;
	*)
		echo "<html><head><title>error</title></head><body>"
		echo "<p>Could not convert \"$end_date\" back to a timestamp."
		echo "<p><address></address></body></html>"
		exit 1
esac

#############################################################################
# Start the HTML page
#############################################################################

echo "<html>"
echo "<head>"
echo "<title>NcFTPd: Anonymous user $user summary from $start_date to $end_date</title>"
echo "</head>"
echo "<body>"

##############################################################################
# Compute the lognames.
##############################################################################

start_yyyymmddHHMMSS=`$DATEMUNGER "$start_ts" formatted "%Y%m%d%H%M%S"`
end_yyyymmddHHMMSS=`$DATEMUNGER "$end_ts" formatted "%Y%m%d%H%M%S"`

echo "<!-- timestamps:  start=$start_ts             end=$end_ts -->"
echo "<!-- full:        start=$start_yyyymmddHHMMSS end=$end_yyyymmddHHMMSS-->"
echo "<!-- $0 -->"

ztype=" $type"

$LOGCAT "$start_yyyymmddHHMMSS" "$end_yyyymmddHHMMSS" log-xfer "$DOMAIN_CF" "${vdomains-ALL}" \
	| tr '|' ',' \
	| $AWK -F, '
		{
			if (user == $8)
				print;
		}' user="$user" | sort | $AWK -F, '{
			linesUsed++;

			if (linesUsed == 1) {
				printf("<table cellspacing=5>\n");
				printf("\t<tr>\n");
				printf("\t\t<th align=left>%s</th>\n", "Date");
				printf("\t\t<th align=left>%s</th>\n", "Event");
				printf("\t\t<th align=left>%s</th>\n", "Item");
				printf("\t\t<th align=right>%s</th>\n", "Size");
				printf("\t\t<th align=center>%s</th>\n", "Completion");
				printf("\t\t<th align=left>%s</th>\n", "From");
				printf("\t</tr>\n");

			}

			i = index($0, "#");
			when = substr($0, 1, i - 2);

			if ($2 == " S")
				event = "Upload";
			else
				event = "Download";

			fn=$3;
			size=$4;
			host=$9;
			complete=$11;

			printf("\t<tr>\n");
			printf("\t\t<td align=left>%s</td>\n", when);
			printf("\t\t<td align=left>%s</td>\n", event);
			printf("\t\t<td align=left>%s</td>\n", fn);
			printf("\t\t<td align=right>%s</td>\n", size);
			printf("\t\t<td align=center>%s</td>\n", complete);
			printf("\t\t<td align=left>%s</td>\n", host);
			printf("\t</tr>\n");
		}
		END {
			if (linesUsed > 0) {
				printf("</table>\n");
				printf("<p><hr><p>\n");
			} else {
				printf("<P>Sorry, there were no items found in the logs for the user <B>%s</B> during the specified time period.\n", user);
			}
		}' user="$user" | "$RERESOLV"

$LOGCAT "$start_yyyymmddHHMMSS" "$end_yyyymmddHHMMSS" log-session "$DOMAIN_CF" "${vdomains-ALL}" \
	| $AWK -F, '
		{
			if ($3 == user)
				print;
		}' user="$user" | sort \
	| $AWK -F, '
		{
			nlogins = $21;
			linesUsed++;
			if (linesUsed == 1) {
				printf("<table cellspacing=5>\n");
				printf("\t<tr>\n");
				printf("\t\t<th align=left>%s</th>\n", "Logout");
				printf("\t\t<th align=left>%s</th>\n", "Duration");
				printf("\t\t<th align=right>%s</th>\n", "Downloads");
				printf("\t\t<th align=right>%s</th>\n", "Megabytes");
				printf("\t\t<th align=right>%s</th>\n", "Uploads");
				printf("\t\t<th align=right>%s</th>\n", "Megabytes");
				printf("\t\t<th align=right>%s</th>\n", "Listings");
				printf("\t\t<th align=left>%s</th>\n", "From");
				printf("\t</tr>\n");
			}

			i = index($0, "#");
			logintime = substr($0, 1, i - 2);
			kdl = int(($7 + 512) / 1024);
			kul = int(($8 + 512) / 1024);
			ndl = $10;
			nul = $11;
			host = $4;
			dura = $5;
			nl = $13 + $14;

			duraS = int(dura % 60);
			duraM = int((dura / 60) % 60);
			duraH = int(dura / 3600);

			printf("\t<tr>\n");
			printf("\t\t<td align=left>%s</td>\n", logintime);
			printf("\t\t<td align=left>%d:%02d:%02d</td>\n", duraH, duraM, duraS);
			printf("\t\t<td align=right>%d</td>\n", ndl);
			printf("\t\t<td align=right>%.2f</td>\n", kdl / 1024.0);
			printf("\t\t<td align=right>%d</td>\n", nul);
			printf("\t\t<td align=right>%.2f</td>\n", kul / 1024.0);
			printf("\t\t<td align=right>%d</td>\n", nl);
			printf("\t\t<td align=left>%s</td>\n", host);
			printf("\t</tr>\n");

			tkdl += kdl;
			tkul += kul;
			tndl += ndl;
			tnul += nul;
			tdura += dura;
			tnl += nl;
		}
		END {
			if (linesUsed > 0) {
				duraS = int(tdura % 60);
				duraM = int((tdura / 60) % 60);
				duraH = int(tdura / 3600);
				printf("\t<tr>\n");
				printf("\t\t<td align=left>%s</td>\n", "<B>TOTAL</B>");
				printf("\t\t<td align=left>%d:%02d:%02d</td>\n", duraH, duraM, duraS);
				printf("\t\t<td align=right>%d</td>\n", tndl);
				printf("\t\t<td align=right>%.2f</td>\n", tkdl / 1024.0);
				printf("\t\t<td align=right>%d</td>\n", tnul);
				printf("\t\t<td align=right>%.2f</td>\n", tkul / 1024.0);
				printf("\t\t<td align=right>%d</td>\n", tnl);
				printf("\t\t<td align=left>%s</td>\n", host);
				printf("\t</tr>\n");
				printf("</table>\n");
				}
		}' user="$user" | "$RERESOLV"

##############################################################################
# End the finished web page.
##############################################################################

echo "<p><address></address></body></html>"
exit 0
