#!/bin/ksh

#############################################################################
#
# NcFTPd Reporting Request Form
# =============================
#
# Copyright 1998, Mike Gleason.  All rights reserved.
#
# Function:
#
#   *  Simply generate an HTML form and process the submitted data.
#      This script is NOT responsible for generating the report output.
#
# Requirements:
#
#   *  This script needs to be able to re-execute itself, so "."
#      needs to be in the $PATH.
#
#   *  This script must be executable (chmod a+rx) by public.
#
#   *  form2env
#
#   *  datemunger
#
#############################################################################

. /usr/local/etc/ncftpd/rptbin/ncftpd_reports.env

#############################################################################
# No more user-configurable options below this point.
#############################################################################

me=`basename $0`

if [ "$#" -eq 0 ] ; then
	#####################################################################
	# The default action for this script is to display the form HTML page
	#####################################################################

	host=`uname -n 2>/dev/null`
	if [ "$host" = "" ] ; then
		onhost=""
	else
		onhost=" for $host"
	fi
	echo "Content-type: text/html"
	echo ""
	echo "<html>"
	echo "<head>"
	echo "<title>NcFTPd: Report Request${onhost}</title>"
	echo "</head>"
	echo "<body>"

	#####################################################################
	# Calculate default reporting range based on current time
	#####################################################################

	end_Y=`$DATEMUNGER now formatted "%Y"`
	this_Y="$end_Y"
	end_m=`$DATEMUNGER now formatted "%m"`
	end_B=`$DATEMUNGER now formatted "%B"`	# Full month
	end_d=`$DATEMUNGER now formatted "%d"`
	end_H=`$DATEMUNGER now formatted "%H"`
	end_M=`$DATEMUNGER now formatted "%M"`

	start_Y=`$DATEMUNGER now - 2 weeks formatted "%Y"`
	start_m=`$DATEMUNGER now - 2 weeks formatted "%m"`
	start_B=`$DATEMUNGER now - 2 weeks formatted "%B"`	# Full month
	start_d=`$DATEMUNGER now - 2 weeks formatted "%d"`
	# start_H=`$DATEMUNGER now - 2 weeks formatted "%H"`
	# start_M=`$DATEMUNGER now - 2 weeks formatted "%M"`
	start_H=0
	start_M=0

	#####################################################################
	# Calculate a date/time set of inputs
	#####################################################################

	tmp=/tmp/rptgen1.$$
	tmp2=/tmp/rptgen2.$$
	trap "/bin/rm -f $tmp $tmp2 ; exit 15" 1 2 15

	echo "<P>Starting date:" > $tmp
	echo "$start_B" | $AWK 2>&1 '{
		m[1] = "January"; m[2] = "February"; m[3] = "March";
		m[4] = "April"; m[5] = "May"; m[6] = "June";
		m[7] = "July"; m[8] = "August"; m[9] = "September";
		m[10] = "October"; m[11] = "November"; m[12] = "December";

		B=$0;
		if (B == "")
			B = "October";

		printf("<select name=\"%s\">\n", name);
		for (i=1; i<=12; i++) {
			if (B == m[i])
				printf("<option selected>%s</option>\n", m[i]);
			else
				printf("<option>%s</option>\n", m[i]);
		}
		printf("</select>\n");
	}' name="start_B_ao" >> $tmp

	echo "$start_d" | $AWK '{
		d=int($1);
		if (d == 0)
			d = int(1);

		printf("<select name=\"%s\">\n", name);
		for (i=int(1); i<=31; i++) {
			if (d == i)
				printf("<option selected>%02d</option>\n", i);
			else
				printf("<option>%02d</option>\n", i);
		}
		printf("</select>\n");
	}' name="start_d_num_02d" >> $tmp

	echo "$start_Y" | $AWK '{
		Y=int($1);
		if (Y == 0)
			Y = this_Y;

		printf("<select name=\"%s\">\n", name);
		for (i=int(1997); i<=int(this_Y); i++) {
			if (Y == i)
				printf("<option selected>%s</option>\n", i);
			else
				printf("<option>%s</option>\n", i);
		}
		printf("</select>\n");
	}' name="start_Y_num" this_Y="$this_Y" >> $tmp

	echo "time:" >> $tmp

	echo "$start_H" | $AWK '{
		H=int($1);

		printf("<select name=\"%s\">\n", name);
		for (i=0; i<=23; i++) {
			if (H == i)
				printf("<option selected>%02d</option>\n", i);
			else
				printf("<option>%02d</option>\n", i);
		}
		printf("</select>\n");
	}' name="start_H_num_02d" >> $tmp

	echo ":" >> $tmp

	echo "$start_M" | $AWK '{
		M=int($1);
		if (M < 15) {
			M = 0;
		} else if (M < 30) {
			M = 15;
		} else if (M < 45) {
			M = 30;
		} else {
			M = 45;
		}
		printf("<select name=\"%s\">\n", name);
		if (M == 0)
			printf("<option selected>%02d</option>\n", M);
		else
			printf("<option>%02d</option>\n", 0);
		if (M == 15)
			printf("<option selected>%02d</option>\n", M);
		else
			printf("<option>%02d</option>\n", 15);
		if (M == 30)
			printf("<option selected>%02d</option>\n", M);
		else
			printf("<option>%02d</option>\n", 30);
		if (M == 45)
			printf("<option selected>%02d</option>\n", M);
		else
			printf("<option>%02d</option>\n", 45);
		printf("</select>\n");
	}' name="start_M_num_02d" >> $tmp

	echo "<P>Ending date:" >> $tmp

	echo "$end_B" | $AWK 2>&1 '{
		m[1] = "January"; m[2] = "February"; m[3] = "March";
		m[4] = "April"; m[5] = "May"; m[6] = "June";
		m[7] = "July"; m[8] = "August"; m[9] = "September";
		m[10] = "October"; m[11] = "November"; m[12] = "December";

		B=$0;
		if (B == "")
			B = "October";

		printf("<select name=\"%s\">\n", name);
		for (i=1; i<=12; i++) {
			if (B == m[i])
				printf("<option selected>%s</option>\n", m[i]);
			else
				printf("<option>%s</option>\n", m[i]);
		}
		printf("</select>\n");
	}' name="end_B_ao" >> $tmp

	echo "$end_d" | $AWK '{
		d=int($1);
		if (d == 0)
			d = int(1);

		printf("<select name=\"%s\">\n", name);
		for (i=int(1); i<=31; i++) {
			if (d == i)
				printf("<option selected>%02d</option>\n", i);
			else
				printf("<option>%02d</option>\n", i);
		}
		printf("</select>\n");
	}' name="end_d_num_02d" >> $tmp

	echo "$end_Y" | $AWK '{
		Y=int($1);
		if (Y == 0)
			Y = this_Y;

		printf("<select name=\"%s\">\n", name);
		for (i=int(1997); i<=int(this_Y); i++) {
			if (Y == i)
				printf("<option selected>%s</option>\n", i);
			else
				printf("<option>%s</option>\n", i);
		}
		printf("</select>\n");
	}' name="end_Y_num" this_Y="$this_Y" >> $tmp

	echo "time:" >> $tmp

	echo "$end_H" | $AWK '{
		H=int($1);

		printf("<select name=\"%s\">\n", name);
		for (i=0; i<=23; i++) {
			if (H == i)
				printf("<option selected>%02d</option>\n", i);
			else
				printf("<option>%02d</option>\n", i);
		}
		printf("</select>\n");
	}' name="end_H_num_02d" >> $tmp

	echo ":" >> $tmp

	echo "$end_M" | $AWK '{
		M=int($1);
		if (M < 15) {
			M = 0;
		} else if (M < 30) {
			M = 15;
		} else if (M < 45) {
			M = 30;
		} else {
			M = 45;
		}
		printf("<select name=\"%s\">\n", name);
		if (M == 0)
			printf("<option selected>%02d</option>\n", M);
		else
			printf("<option>%02d</option>\n", 0);
		if (M == 15)
			printf("<option selected>%02d</option>\n", M);
		else
			printf("<option>%02d</option>\n", 15);
		if (M == 30)
			printf("<option selected>%02d</option>\n", M);
		else
			printf("<option>%02d</option>\n", 30);
		if (M == 45)
			printf("<option selected>%02d</option>\n", M);
		else
			printf("<option>%02d</option>\n", 45);
		printf("</select>\n");
	}' name="end_M_num_02d" >> $tmp

	cat "$DOMAIN_CF" 2>/dev/null | tr '=#' '  ' | $AWK '($1 == "set-name") { print $2; }' | sort -u | $AWK '{
			if (NR == 1) {
				printf("<select name=\"vdomain\">\n");
				printf("<option selected>ALL</option>\n");
			}
			printf("<option>%s</option>\n", $1);
		}
		END {
			if (NR > 0)
				printf("</select>\n");
		}' > "$tmp2"

	#####################################################################
	# General report form
	#####################################################################

	echo "<P>The <b>General</b> report provides a wide variety"
	echo "of statistics and information, based upon the"
	echo "near real-time <TT>stat</TT> logs that <I>NcFTPd</I>"
	echo "generates."
	echo "<p>Report complexity: <b>low</b>"
	echo "<ul>"
	echo "<small>"
	echo "Relatively quick to generate since it summarizes data that"
	echo "has been pre-computed.  Drawing the graphs may take a few"
	echo "moments, however."
	echo "<p><b>Note</b>: The data source for this report is only"
	echo "available for systems with System V IPC (Shared Memory)."
	echo "This report will not work for systems lacking that feature"
	echo "(i.e. BSD/OS, SunOS 4.1)."
	echo "</small>"
	echo "</ul>"
	echo "<p>To run this report, select the timespan that you"
	echo "want the report to cover, and then click the <b>submit</b>"
	echo "button."
	echo "<form action=\"${me}?general\" method=\"post\">"

	cat "$tmp" 

	echo "<p>"
	echo "<input value=\"Submit\" type=\"submit\">"
	echo "</form>"

	echo "<p><hr><p>"

	#####################################################################
	# Top Download report form
	#####################################################################

	echo "<P>The <b>Top Downloads</b> report shows the most popular"
	echo "files downloaded for a period of time.  You can run this"
	echo "report for a specific virtual domain <I>only</I> if it has"
	echo "its own log files.  (i.e. you used different pathnames"
	echo "for the <TT>log-xfer</TT> option)."
	echo "<p>Report complexity: <b>high</b>"
	echo "<ul>"
	echo "<small>"
	echo "<P>This report can be resource intensive because the entire"
	echo "span of log data must be sorted first, and then examined."
	echo "Therefore, the complexity increases with larger timespans."
	echo "</small>"
	echo "</ul>"
	echo "<form action=\"${me}?topdl\" method=\"post\">"

	cat "$tmp" 

	echo "<p>Show the top"
	echo "<input type=text name=\"topN_num\" value=\"20\" size=4>"
	echo "downloads for virtual domain: "

	cat "$tmp2"

	echo "<p>"
	echo "<input value=\"Submit\" type=\"submit\">"
	echo "</form>"

	echo "<p><hr><p>"

	#####################################################################
	# Download summary report form
	#####################################################################

	echo "<P>The <b>Downloaded Files</b> report shows all"
	echo "files downloaded for a period of time.  You can run this"
	echo "report for a specific virtual domain <I>only</I> if it has"
	echo "its own log files.  (i.e. you used different pathnames"
	echo "for the <TT>log-xfer</TT> option)."
	echo "<p>Report complexity: <b>medium</b>"
	echo "<ul>"
	echo "<small>"
	echo "<P>This report can easily produce an overwhelming amount"
	echo "of output, since it essentially re-formats the log data."
	echo "It requires a sequential scan of the <tt>xfer</tt> logs."
	echo "</small>"
	echo "</ul>"
	echo "<form action=\"${me}?dlsum\" method=\"post\">"

	cat "$tmp" 

	echo "<p>Show a maximum of"
	echo "<input type=text name=\"topN_num\" value=\"1000\" size=5>"
	echo "downloads for virtual domain: "

	cat "$tmp2"

	echo "<p>"
	echo "<input value=\"Submit\" type=\"submit\">"
	echo "</form>"

	echo "<p><hr><p>"

	#####################################################################
	# Downloaded File report form
	#####################################################################

	echo "<P>The <b>Downloaded File Summary</b> report lets you"
	echo "find out how many times a specific file was downloaded."
	echo "You specify the complete pathname (no symlinks!) and"
	echo "whether you just want a count, or listing of each transfer."
	echo "<p>Report complexity: <b>medium</b>"
	echo "<ul>"
	echo "<small>"
	echo "<P>This report can produce a lot of"
	echo "of output, depending on the number of hits."
	echo "It requires a sequential scan of the <tt>xfer</tt> logs."
	echo "</small>"
	echo "</ul>"
	echo "<form action=\"${me}?dlquery\" method=\"post\">"

	cat "$tmp" 

	echo "<P>Pathname of file to look for:"
	samplefile=`csh -c 'cd ~ftp ; echo $cwd/pub/filename'`
	echo "<input type=text name=\"pathname_nosh\" value=\"$samplefile\" size=60>"
	echo "<P>Print each transaction:"
	echo "<select name=\"printEach_lco\">"
	echo "<option selected>yes</option>"
	echo "<option>no</option>"
	echo "</select>"
	echo "<P>For virtual domain: "

	cat "$tmp2"

	echo "<p>"
	echo "<input value=\"Submit\" type=\"submit\">"
	echo "</form>"

	echo "<p><hr><p>"

	#####################################################################
	# Upload summary report form
	#####################################################################

	echo "<P>The <b>Uploaded Files</b> report shows all"
	echo "files uploaded for a period of time.  You can run this"
	echo "report for a specific virtual domain <I>only</I> if it has"
	echo "its own log files.  (i.e. you used different pathnames"
	echo "for the <TT>log-xfer</TT> option)."
	echo "<p>Report complexity: <b>medium</b>"
	echo "<ul>"
	echo "<small>"
	echo "<P>This report can easily produce an overwhelming amount"
	echo "of output, since it essentially re-formats the log data."
	echo "It requires a sequential scan of the <tt>xfer</tt> logs."
	echo "</small>"
	echo "</ul>"
	echo "<form action=\"${me}?ulsum\" method=\"post\">"

	cat "$tmp" 

	echo "<p>Show a maximum of"
	echo "<input type=text name=\"topN_num\" value=\"1000\" size=5>"
	echo "uploads for virtual domain: "

	cat "$tmp2"

	echo "<p>"
	echo "<input value=\"Submit\" type=\"submit\">"
	echo "</form>"

	echo "<p><hr><p>"

	#####################################################################
	# Uploaded File report form
	#####################################################################

	echo "<P>The <b>Uploaded File Summary</b> report lets you"
	echo "find out how many times a specific file was uploaded."
	echo "You specify the complete pathname (no symlinks!) and"
	echo "whether you just want a count, or listing of each transfer."
	echo "<p>Report complexity: <b>medium</b>"
	echo "<ul>"
	echo "<small>"
	echo "<P>This report can produce a lot of"
	echo "of output, depending on the number of hits."
	echo "It requires a sequential scan of the <tt>xfer</tt> logs."
	echo "</small>"
	echo "</ul>"
	echo "<form action=\"${me}?ulquery\" method=\"post\">"

	cat "$tmp" 

	echo "<P>Pathname of file to look for:"
	echo "<input type=text name=\"pathname_nosh\" value=\"$samplefile\" size=60>"
	echo "<P>Print each transaction:"
	echo "<select name=\"printEach_lco\">"
	echo "<option selected>yes</option>"
	echo "<option>no</option>"
	echo "</select>"
	echo "<P>For virtual domain: "

	cat "$tmp2"

	echo "<p>"
	echo "<input value=\"Submit\" type=\"submit\">"
	echo "</form>"

	echo "<p><hr><p>"

	#####################################################################
	# Traffic summary report form
	#####################################################################

	echo "<P>The <b>Traffic Summary</b> report shows the number"
	echo "of transfers and total bytes transferred.  This can"
	echo "tell you how much data is going through the server."
	echo "<P>This report can give you the statistics for specific"
	echo "virtual domains <I>only</I> if each has"
	echo "its own log files.  (i.e. you used different pathnames"
	echo "for the <TT>log-xfer</TT> option)."
	echo "<p>Report complexity: <b>medium</b>"
	echo "<ul>"
	echo "<small>"
	echo "This requires a sequential scan of the <tt>xfer</tt> logs."
	echo "</small>"
	echo "</ul>"
	echo "<form action=\"${me}?traffic\" method=\"post\">"

	cat "$tmp" 

	echo "<p>"
	echo "<input value=\"Submit\" type=\"submit\">"
	echo "</form>"

	echo "<p><hr><p>"

	#####################################################################
	# Real users login report form
	#####################################################################

	echo "<P>The <b>Real Users</b> report shows a summary of the"
	echo "last FTP logins by the users in the <TT>/etc/passwd</TT> file."
	echo "<p>Report complexity: <b>medium</b>"
	echo "<ul>"
	echo "<small>"
	echo "<P>It requires a sequential scan of the <tt>session</tt> logs."
	echo "</small>"
	echo "</ul>"
	echo "<form action=\"${me}?realusers\" method=\"post\">"

	cat "$tmp" 

	echo "<p>"
	echo "<input value=\"Submit\" type=\"submit\">"
	echo "</form>"

	echo "<p><hr><p>"

	#####################################################################
	# Real user query report form
	#####################################################################

	echo "<P>The <b>Real User Query</b> report shows transfer of the"
	echo "activity for a real user."
	echo "<p>Report complexity: <b>high</b>"
	echo "<ul>"
	echo "<small>"
	echo "<P>It requires a sequential scan of both the <tt>session</tt> logs and the <tt>xfer</tt> logs."
	echo "</small>"
	echo "</ul>"
	echo "<form action=\"${me}?realuserquery\" method=\"post\">"

	echo "<P>User login to look for:"
	sample=`tail -1 /etc/passwd | cut -d: -f1`
	echo "<input type=text name=\"user_ano\" value=\"$sample\" size=8>"

	cat "$tmp" 

	echo "<p>"
	echo "<input value=\"Submit\" type=\"submit\">"
	echo "</form>"

	echo "<p><hr><p>"

	#####################################################################
	# Email summary report form
	#####################################################################

	echo "<P>The <b>E-Mail Address Summary</b> report tells you the number"
	echo "of unique anonymous users that used your server, and a list of"
	echo "the most frequent."
	echo "You can run this"
	echo "report for a specific virtual domain <I>only</I> if it has"
	echo "its own log files.  (i.e. you used different pathnames"
	echo "for the <TT>log-session</TT> option)."
	echo "<p>Report complexity: <b>high</b>"
	echo "<ul>"
	echo "<small>"
	echo "<P>This report requires a sequential scan of the"
	echo "<tt>session</tt> logs, and needs to be able to sort"
	echo "a potentially large dataset."
	echo "</small>"
	echo "</ul>"
	echo "<form action=\"${me}?emsum\" method=\"post\">"

	cat "$tmp" 

	echo "<p>Show the top"
	echo "<input type=text name=\"topN_num\" value=\"20\" size=4>"
	echo "anonymous users using virtual domain: "

	cat "$tmp2"

	echo "<p>"
	echo "<input value=\"Submit\" type=\"submit\">"
	echo "</form>"

	echo "<p><hr><p>"

	#####################################################################
	# Anonymous user query report form
	#####################################################################

	echo "<P>The <b>Anonymous User Query</b> report shows transfer of the"
	echo "activity for an anonymous user (identified by the E-mail"
	echo "address used for the password when they logged in)."
	echo "<p>Report complexity: <b>high</b>"
	echo "<ul>"
	echo "<small>"
	echo "<P>It requires a sequential scan of both the <tt>session</tt> logs and the <tt>xfer</tt> logs."
	echo "</small>"
	echo "</ul>"
	echo "<form action=\"${me}?anonuserquery\" method=\"post\">"

	echo "<P>E-mail address to look for:"
	sample="mozilla@microsoft.com"	# ;-)
	echo "<input type=text name=\"user_nosh\" value=\"$sample\" size=40>"

	cat "$tmp" 

	echo "<p>"
	echo "<input value=\"Submit\" type=\"submit\">"
	echo "</form>"

	echo "<p><hr><p>"

	#####################################################################
	# IP summary report form
	#####################################################################

	echo "<P>The <b>Client IP Summary</b> report tells you the number"
	echo "of unique IP addresses that used your server, and a list of"
	echo "the most frequent."
	echo "You can run this"
	echo "report for a specific virtual domain <I>only</I> if it has"
	echo "its own log files.  (i.e. you used different pathnames"
	echo "for the <TT>log-session</TT> option)."
	echo "<p>Report complexity: <b>high</b>"
	echo "<ul>"
	echo "<small>"
	echo "<P>This report requires a sequential scan of the"
	echo "<tt>session</tt> logs, and needs to be able to sort"
	echo "a potentially large dataset."
	echo "</small>"
	echo "</ul>"
	echo "<form action=\"${me}?ipsum\" method=\"post\">"

	cat "$tmp" 

	echo "<p>Show the top"
	echo "<input type=text name=\"topN_num\" value=\"20\" size=4>"
	echo "client IP addresses using virtual domain: "

	cat "$tmp2"

	echo "<p>"
	echo "<input value=\"Submit\" type=\"submit\">"
	echo "</form>"

	#####################################################################
	# End the HTML page
	#####################################################################

	/bin/rm -f "$tmp" "$tmp2"
	echo "<p><address></address></body></html>"

else
	#####################################################################
	# Process the form data
	#####################################################################

	if [ "$DEBUG" = yes ] ; then
		echo '-----before-----' > /tmp/form.env
		set >> /tmp/form.env
		eval `tee /tmp/form.input | $FORM2ENV`
		echo '-----after-----' >> /tmp/form.env
		set >> /tmp/form.env
	else
		eval `$FORM2ENV`
	fi

	#####################################################################
	# This set the following environment variables based upon the
	# form response data:
	#
	#	form_end_B_ao
	#	form_end_H_num_02d
	#	form_end_M_num_02d
	#	form_end_Y_num
	#	form_end_d_num_02d
	#	form_start_B_ao
	#	form_start_H_num_02d
	#	form_start_M_num_02d
	#	form_start_Y_num
	#	form_start_d_num_02d
	#
	# The naming convention determines how the form data is filtered
	# by the form2env program.  This is important since a common attack
	# on CGI scripts is to try and pass in characters that could cause
	# a command to be run.
	#
	# The "_ao" means alphabetic-only, so every character except A-Z
	# and a-z are deleted from the input.
	#
	# The "_num" means only 0-9 and . are allowed.  The "_num_02d"
	# means to make sure the result is zero-padded to two digits.
	#####################################################################

	#####################################################################
	# Run the appropriate report generator, which produces HTML output
	#####################################################################

	if [ "$1" = general ] ; then
		"$RPTGENERAL" \
			"$form_start_Y_num" \
			"$form_start_B_ao" \
			"$form_start_d_num_02d" \
			"$form_start_H_num_02d" \
			"$form_start_M_num_02d" \
			"$form_end_Y_num" \
			"$form_end_B_ao" \
			"$form_end_d_num_02d" \
			"$form_end_H_num_02d" \
			"$form_end_M_num_02d"
	elif [ "$1" = topdl ] ; then
		"$RPTFTOP" \
			"$form_start_Y_num" \
			"$form_start_B_ao" \
			"$form_start_d_num_02d" \
			"$form_start_H_num_02d" \
			"$form_start_M_num_02d" \
			"$form_end_Y_num" \
			"$form_end_B_ao" \
			"$form_end_d_num_02d" \
			"$form_end_H_num_02d" \
			"$form_end_M_num_02d" \
			"R" \
			"$form_topN_num" \
			"$form_vdomain"
	elif [ "$1" = dlsum ] ; then
		"$RPTFSUM" \
			"$form_start_Y_num" \
			"$form_start_B_ao" \
			"$form_start_d_num_02d" \
			"$form_start_H_num_02d" \
			"$form_start_M_num_02d" \
			"$form_end_Y_num" \
			"$form_end_B_ao" \
			"$form_end_d_num_02d" \
			"$form_end_H_num_02d" \
			"$form_end_M_num_02d" \
			"R" \
			"${form_topN_num}" \
			"${form_vdomain-ALL}"
	elif [ "$1" = dlquery ] ; then
		"$RPTFQUERY" \
			"$form_start_Y_num" \
			"$form_start_B_ao" \
			"$form_start_d_num_02d" \
			"$form_start_H_num_02d" \
			"$form_start_M_num_02d" \
			"$form_end_Y_num" \
			"$form_end_B_ao" \
			"$form_end_d_num_02d" \
			"$form_end_H_num_02d" \
			"$form_end_M_num_02d" \
			"$form_pathname_nosh" \
			"R" \
			"$form_printEach_lco" \
			"${form_vdomain-ALL}"
	elif [ "$1" = ulsum ] ; then
		"$RPTFSUM" \
			"$form_start_Y_num" \
			"$form_start_B_ao" \
			"$form_start_d_num_02d" \
			"$form_start_H_num_02d" \
			"$form_start_M_num_02d" \
			"$form_end_Y_num" \
			"$form_end_B_ao" \
			"$form_end_d_num_02d" \
			"$form_end_H_num_02d" \
			"$form_end_M_num_02d" \
			"S" \
			"${form_topN_num}" \
			"${form_vdomain-ALL}"
	elif [ "$1" = ulquery ] ; then
		"$RPTFQUERY" \
			"$form_start_Y_num" \
			"$form_start_B_ao" \
			"$form_start_d_num_02d" \
			"$form_start_H_num_02d" \
			"$form_start_M_num_02d" \
			"$form_end_Y_num" \
			"$form_end_B_ao" \
			"$form_end_d_num_02d" \
			"$form_end_H_num_02d" \
			"$form_end_M_num_02d" \
			"$form_pathname_nosh" \
			"S" \
			"$form_printEach_lco" \
			"${form_vdomain-ALL}"
	elif [ "$1" = realusers ] ; then
		"$RPTREALUSERS" \
			"$form_start_Y_num" \
			"$form_start_B_ao" \
			"$form_start_d_num_02d" \
			"$form_start_H_num_02d" \
			"$form_start_M_num_02d" \
			"$form_end_Y_num" \
			"$form_end_B_ao" \
			"$form_end_d_num_02d" \
			"$form_end_H_num_02d" \
			"$form_end_M_num_02d"
	elif [ "$1" = realuserquery ] ; then
		"$RPTREALUSERQUERY" \
			"$form_start_Y_num" \
			"$form_start_B_ao" \
			"$form_start_d_num_02d" \
			"$form_start_H_num_02d" \
			"$form_start_M_num_02d" \
			"$form_end_Y_num" \
			"$form_end_B_ao" \
			"$form_end_d_num_02d" \
			"$form_end_H_num_02d" \
			"$form_end_M_num_02d" \
			"$form_user_ano"
	elif [ "$1" = anonuserquery ] ; then
		"$RPTANONUSERQUERY" \
			"$form_start_Y_num" \
			"$form_start_B_ao" \
			"$form_start_d_num_02d" \
			"$form_start_H_num_02d" \
			"$form_start_M_num_02d" \
			"$form_end_Y_num" \
			"$form_end_B_ao" \
			"$form_end_d_num_02d" \
			"$form_end_H_num_02d" \
			"$form_end_M_num_02d" \
			"$form_user_nosh"
	elif [ "$1" = emsum ] ; then
		"$RPTEMSUMMARY" \
			"$form_start_Y_num" \
			"$form_start_B_ao" \
			"$form_start_d_num_02d" \
			"$form_start_H_num_02d" \
			"$form_start_M_num_02d" \
			"$form_end_Y_num" \
			"$form_end_B_ao" \
			"$form_end_d_num_02d" \
			"$form_end_H_num_02d" \
			"$form_end_M_num_02d" \
			"${form_topN_num-10}" \
			"${form_vdomain-ALL}"
	elif [ "$1" = ipsum ] ; then
		"$RPTIPSUMMARY" \
			"$form_start_Y_num" \
			"$form_start_B_ao" \
			"$form_start_d_num_02d" \
			"$form_start_H_num_02d" \
			"$form_start_M_num_02d" \
			"$form_end_Y_num" \
			"$form_end_B_ao" \
			"$form_end_d_num_02d" \
			"$form_end_H_num_02d" \
			"$form_end_M_num_02d" \
			"${form_topN_num-10}" \
			"${form_vdomain-ALL}"
	elif [ "$1" = traffic ] ; then
		"$RPTTRAFFIC" \
			"$form_start_Y_num" \
			"$form_start_B_ao" \
			"$form_start_d_num_02d" \
			"$form_start_H_num_02d" \
			"$form_start_M_num_02d" \
			"$form_end_Y_num" \
			"$form_end_B_ao" \
			"$form_end_d_num_02d" \
			"$form_end_H_num_02d" \
			"$form_end_M_num_02d"
	fi
fi
