#!/usr/bin/awk -f
{
### start parsing parameters ###
	s0				= $1;
	t0				= $2;
	s1				= $3;
	t1				= $4;

	session_n			= $5;
	session_refused			= $6;
	session_denied			= $7;
	session_login			= $8;
	session_failedLogin		= $9;
	session_secs			= $10;
	session_dirListings		= $11;
	session_withDirListing		= $12;
	session_withDownload		= $13;
	session_withUpload		= $14;
	session_client_unknown		= $15;
	session_client_NcFTP		= $16;
	session_client_Netscape		= $17;
	session_client_InternetExplorer	= $18;
	session_client_reserved1	= $19;
	session_client_reserved2	= $20;
	session_client_reserved3	= $21;
	session_client_reserved4	= $22;
	session_modem_33kbit		= $23;
	session_modem_56kbit		= $24;
	session_modem_256kbit		= $25;
	session_modem_10Mbit		= $26;
	session_modem_100Mbit		= $27;
	session_modem_1Gbit		= $28;
	session_reserved1		= $29;
	session_reserved2		= $30;
	session_reserved3		= $31;

	download_n			= $32;
	download_result_ok		= $33;
	download_result_abor		= $34;
	download_result_error		= $35;
	download_result_incomplete	= $36;
	download_result_noent		= $37;
	download_result_perm		= $38;
	download_result_reserved1	= $39;
	download_result_reserved1	= $40;
	download_kb			= $41;
	download_reserved1		= $42;
	download_reserved1		= $43;
	download_reserved1		= $44;
	download_secs			= $45;

	upload_n			= $46;
	upload_result_ok		= $47;
	upload_result_abor		= $48;
	upload_result_error		= $49;
	upload_result_incomplete	= $50;
	upload_result_noent		= $51;
	upload_result_perm		= $52;
	upload_result_reserved1		= $53;
	upload_result_reserved1		= $54;
	upload_kb			= $55;
	upload_reserved1		= $56;
	upload_reserved1		= $57;
	upload_reserved1		= $58;
	upload_secs			= $59;

	period_max_simul_users		= $60;
### end parsing parameters ###

	if (session_n != 0) {

	download_mb = download_kb / (1024.0);
	download_gb = download_kb / (1024.0 * 1024.0);
	download_tb = download_kb / (1024.0 * 1024.0 * 1024.0);

	upload_mb = upload_kb / (1024.0);
	upload_gb = upload_kb / (1024.0 * 1024.0);
	upload_tb = upload_kb / (1024.0 * 1024.0 * 1024.0);

	session_modem_detected = session_modem_33kbit + session_modem_56kbit;
	session_modem_detected += session_modem_256kbit + session_modem_10Mbit;
	session_modem_detected += session_modem_100Mbit + session_modem_1Gbit;

	if (download_secs < 1)
		download_kbsec = 0;
	else
		download_kbsec = download_kb / download_secs;

	if (upload_secs < 1)
		upload_kbsec = 0;
	else
		upload_kbsec = upload_kb / upload_secs;

	if (session_login < 1) {
		avg_session_min = 0;
		avg_session_sec = 0;
		perc_netscape = 0;
		perc_ncftp = 0;
		perc_ie = 0;
		perc_unknown = 100.0;
	} else {
		avg_session_sec = session_secs / session_login;
		avg_session_min = avg_session_sec / 60;
		avg_session_sec = avg_session_sec % 60;
		perc_netscape = 100.0 * session_client_Netscape / session_login;
		perc_ncftp = 100.0 * session_client_NcFTP / session_login;
		perc_ie = 100.0 * session_client_InternetExplorer / session_login;
		perc_unknown = 100.0 * session_client_unknown / session_login;
	}

	printf("<table>\n");
	printf("\t<tr><th align=left width=500>Total number of user sessions</th><td width=150>%d</td></tr>\n", session_n);
	
	printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;Connections refused (server full)</th>");
	printf("<td>%d</td><td><small>(%.2f%%)</small></td></tr>\n", session_refused, session_refused * 100.0 / session_n);
	
	printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;Connections denied (IP blocked)</th>");
	printf("<td>%d</td><td><small>(%.2f%%)</small></td></tr>\n", session_denied, session_denied * 100.0 / session_n);
	
	printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;Failed logins</th>");
	printf("<td>%d</td><td><small>(%.2f%%)</small></td></tr>\n", session_failedLogin, session_failedLogin * 100.0 / session_n);
	
	printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;Successful logins</th>");
	printf("<td>%d</td><td><small>(%.2f%%)</small></td></tr>\n", session_login, session_login * 100.0 / session_n);
	
	if (session_login > 0) {
		printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Average login duration</th>");
		printf("<td>%d:%02d</td><td><small><i>minutes:seconds</i></small></tr>\n", avg_session_min, avg_session_sec);
	
		printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Logins with at least one complete download</th>");
		printf("<td>%d</td><td><small>(%.2f%%)</small></tr>\n", session_withDownload, 100.0 * session_withDownload / session_login);
	
		printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Logins with at least one complete upload</th>");
		printf("<td>%d</td><td><small>(%.2f%%)</small></tr>\n", session_withUpload, 100.0 * session_withUpload / session_login);
	
		printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Logins with at least one successful directory listing</th>");
		printf("<td>%d</td><td><small>(%.2f%%)</small></tr>\n", session_withDirListing, 100.0 * session_withDirListing / session_login);
	
		printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Average number of directory listings per login</th>");
		printf("<td>%.1f</td><td></tr>\n", session_dirListings / session_login);
	}
	
	printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;Maximum simultaneous users</th>");
	printf("<td>%d</td><td></td></tr>\n", period_max_simul_users);
	
	printf("</table>\n");


	printf("<table>\n");
	printf("\t<tr><th align=left width=500>Number of downloads</th><td width=150>%d</td></tr>\n", download_n);
	if (download_n > 0) {
		printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;Explicitly aborted by client</th>");
		printf("<td>%d</td><td><small>(%.2f%%)</small></td></tr>\n", download_result_abor, download_result_abor * 100.0 / download_n);
	
		printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;Connection to client lost</th>");
		printf("<td>%d</td><td><small>(%.2f%%)</small></td></tr>\n", download_result_incomplete, download_result_incomplete * 100.0 / download_n);
	
		printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;Non-existent file requested by client</th>");
		printf("<td>%d</td><td><small>(%.2f%%)</small></td></tr>\n", download_result_noent, download_result_noent * 100.0 / download_n);
	
		printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;Access denied to file requested by client</th>");
		printf("<td>%d</td><td><small>(%.2f%%)</small></td></tr>\n", download_result_perm, download_result_perm * 100.0 / download_n);
	
		printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;Miscellaneous I/O error</th>");
		printf("<td>%d</td><td><small>(%.2f%%)</small></td></tr>\n", download_result_error, download_result_error * 100.0 / download_n);
	
		printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;Complete</th>");
		printf("<td>%d</td><td><small>(%.2f%%)</small></td></tr>\n", download_result_ok, download_result_ok * 100.0 / download_n);
	
		printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Kilobytes transferred</th>");
		printf("<td>%d</td><td><small>kB</small></td></tr>\n", download_kb);
	
		if (download_tb > 1.0) {
			printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Terabytes transferred</th>");
			printf("<td>%.2f</td><td><small>TB</small></td></tr>\n", download_tb);
		} else if (download_gb > 1.0) {
			printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Gigabytes transferred</th>");
			printf("<td>%.2f</td><td><small>GB</small></td></tr>\n", download_gb);
		} else if (download_mb > 1.0) {
			printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Megabytes transferred</th>");
			printf("<td>%.2f</td><td><small>MB</small></td></tr>\n", download_mb);
		}
		
		printf("\t<tr><th align=left>&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;Average throughput</th>");
		printf("<td>%.2f</td><td><small>kB/sec</small></td></tr>\n", download_kbsec);
	}
	printf("</table>\n");

	if (session_modem_detected > 0) {
		printf("<table>\n");

		printf("\t<tr><th align=left width=500>Percentage of users transferring at 33.6 modem speed</th>");
		printf("<td width=150>%.2f%%</td></tr>\n", 100 * session_modem_33kbit / session_modem_detected);

		printf("\t<tr><th align=left width=500>&nbsp;&nbsp;&nbsp;&nbsp;at 56 kbit/sec</th>");
		printf("<td width=150>%.2f%%</td></tr>\n", 100 * session_modem_56kbit / session_modem_detected);

		printf("\t<tr><th align=left width=500>&nbsp;&nbsp;&nbsp;&nbsp;at 256 kbit/sec</th>");
		printf("<td width=150>%.2f%%</td></tr>\n", 100 * session_modem_256kbit / session_modem_detected);

		printf("\t<tr><th align=left width=500>&nbsp;&nbsp;&nbsp;&nbsp;at 10 Mbit/sec</th>");
		printf("<td width=150>%.2f%%</td></tr>\n", 100 * session_modem_10Mbit / session_modem_detected);

		printf("\t<tr><th align=left width=500>&nbsp;&nbsp;&nbsp;&nbsp;at 100 Mbit/sec</th>");
		printf("<td width=150>%.2f%%</td></tr>\n", 100 * session_modem_100Mbit / session_modem_detected);

		printf("\t<tr><th align=left width=500>&nbsp;&nbsp;&nbsp;&nbsp;at more than 100 Mbit/sec</th>");
		printf("<td width=150>%.2f%%</td></tr>\n", 100 * session_modem_1Gbit / session_modem_detected);

		printf("</table>\n");
	}

	if (perc_unknown < 99.0) {
		printf("<table>\n");
		if (perc_netscape > 0.0) {
			printf("\t<tr><th align=left width=500>Users using Netscape Navigator</th><td width=150>%.2f%%</td></tr>\n", perc_netscape);
		}
		if (perc_ie > 0.0) {
			printf("\t<tr><th align=left width=500>Users using Internet Explorer</th><td width=150>%.2f%%</td></tr>\n", perc_ie);
		}
		if (perc_ncftp > 0.0) {
			printf("\t<tr><th align=left width=500>Users using NcFTP Client</th><td width=150>%.2f%%</td></tr>\n", perc_ncftp);
		}
		printf("\t<tr><th align=left width=500>Users using other FTP clients</th><td width=150>%.2f%%</td></tr>\n", perc_unknown);
		printf("</table>\n");
	}

	linesUsed++;
	}
}
END {
	if (linesUsed < 1) {
		printf("<P>Sorry, there was no activity in the logs for that time period.\n");
	}
}
