#!/bin/ksh

#############################################################################
# Copyright 1998, Mike Gleason.  All rights reserved.
#############################################################################

. /usr/local/etc/ncftpd/rptbin/ncftpd_reports.env

#############################################################################
# No more user-configurable options below this point.
#############################################################################

whoiam1=`$WHOAMI 2>/dev/null`
if [ "$whoiam1" = "" ] ; then whoiam="web" ; else whoiam="<b>$whoiam1</b>" ; fi

onhost1=`uname -n 2>/dev/null`
if [ "$onhost1" != "" ] ; then onhost=" on <b>$onhost1</b>" ; else onhost="" ; fi

#############################################################################
# Validate the input
#############################################################################

echo "Content-type: text/html"
echo ""

if [ "$#" -ne 10 ] ; then
	echo "<html><head><title>error</title></head><body>"
	echo "<p>Not enough parameters ($# of 10) given to generate report.</p>"
	echo "<p><address></address></body></html>"
	exit 2
fi

start_Y="$1"
start_B="$2"
start_d="$3"
start_H="$4"
start_M="$5"
shift 5

end_Y="$1"
end_B="$2"
end_d="$3"
end_H="$4"
end_M="$5"

#############################################################################
# Sanity checks
#############################################################################

if [ ! -x "$LOGCAT" ] ; then
	echo "<html><head><title>error</title></head><body>"
	echo "<p>Cannot execute <TT>$LOGCAT</TT> as $whoiam user${onhost}."
	echo "<p><address></address></body></html>"
	exit 2
fi

##############################################################################
# Convert the "%B" form of the month into "%m" form
# (Unfortunate english language dependency)
##############################################################################

B="$start_B"
case "$B" in
	Jan*)	m=01 ;; Feb*)	m=02 ;; Mar*)	m=03 ;;
	Apr*)	m=04 ;; May*)	m=05 ;; Jun*)	m=06 ;;
	Jul*)	m=07 ;; Aug*)	m=08 ;; Sep*)	m=09 ;;
	Oct*)	m=10 ;; Nov*)	m=11 ;; Dec*)	m=12 ;;
	[0-9]*)	m="$B";; *)	m=01 ;;
esac
start_m="$m"

B="$end_B"
case "$B" in
	Jan*)	m=01 ;; Feb*)	m=02 ;; Mar*)	m=03 ;;
	Apr*)	m=04 ;; May*)	m=05 ;; Jun*)	m=06 ;;
	Jul*)	m=07 ;; Aug*)	m=08 ;; Sep*)	m=09 ;;
	Oct*)	m=10 ;; Nov*)	m=11 ;; Dec*)	m=12 ;;
	[0-9]*)	m="$B";; *)	m=01 ;;
esac
end_m="$m"

##############################################################################
# Convert the dates into timestamps.
# This is needed so we can compute the names of the monthly log files
# that will be used to get the stats from.
##############################################################################

start_date="${start_Y}-${start_m}-${start_d} ${start_H}:${start_M}:00"
start_ts=`$DATEMUNGER "$start_date"`
case "$start_ts" in
	[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]*)
		;;
	*)
		echo "<html><head><title>error</title></head><body>"
		echo "<p>Could not convert \"$start_date\" back to a timestamp."
		echo "<p><address></address></body></html>"
		exit 1
esac

end_date="${end_Y}-${end_m}-${end_d} ${end_H}:${end_M}:00"
end_ts=`$DATEMUNGER "$end_date"`
case "$end_ts" in
	[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]*)
		;;
	*)
		echo "<html><head><title>error</title></head><body>"
		echo "<p>Could not convert \"$end_date\" back to a timestamp."
		echo "<p><address></address></body></html>"
		exit 1
esac

#############################################################################
# Start the HTML page
#############################################################################

echo "<html>"
echo "<head>"
echo "<title>NcFTPd: Real user login summary from $start_date to $end_date</title>"
echo "</head>"
echo "<body>"

##############################################################################
# Compute the lognames.
##############################################################################

start_yyyymmddHHMMSS=`$DATEMUNGER "$start_ts" formatted "%Y%m%d%H%M%S"`
end_yyyymmddHHMMSS=`$DATEMUNGER "$end_ts" formatted "%Y%m%d%H%M%S"`

echo "<!-- timestamps:  start=$start_ts             end=$end_ts -->"
echo "<!-- full:        start=$start_yyyymmddHHMMSS end=$end_yyyymmddHHMMSS-->"

ztype=" $type"

tmp1=/tmp/ru1.cgi.$$
tmp2=/tmp/ru2.cgi.$$
tmp3=/tmp/ru3.cgi.$$
tmp4=/tmp/ru3.cgi.$$

trap "/bin/rm -f $tmp1 $tmp2 $tmp3 $tmp4 ; exit 15" 1 2 15
$LOGCAT "$start_yyyymmddHHMMSS" "$end_yyyymmddHHMMSS" log-session "$DOMAIN_CF" "${vdomains-ALL}" \
	| tr '|' ',' \
	| $AWK -F, '
		{
			user = substr($2, 2);
			nlogins = $21;
			if ((user != "anonymous") && (nlogins > 0)) {
				linesUsed++;

				i = index($0, "#");
				logintime = substr($0, 1, i - 2);
				kdl = int(($7 + 512) / 1024);
				kul = int(($8 + 512) / 1024);
				ndl = $10;
				nul = $11;

				logins[user] += nlogins;
				if ((lastlogin[user] == "") || (logintime > lastlogin[user])) {
					lastlogin[user] = logintime;
					host[user] = $4;
				}
				downloads[user] += ndl;
				uploads[user] += nul;
				kbdl[user] += kdl;
				kbul[user] += kul;
			}
		}
		END {
			if (linesUsed > 0) {
				for (u in logins) {
					printf("%d,%s,%s,%d,%d,%d,%d,%s\n", logins[u], u, lastlogin[u], downloads[u], kbdl[u], uploads[u], kbul[u], host[u]);
				}
			}
		}' | sort -t, -n -r > "$tmp1"

cut -d, -f2 "$tmp1" | sort > "$tmp2"
cut -d: -f1 /etc/passwd | sort > "$tmp3"
comm -13 "$tmp2" "$tmp3" | $AWK '{print "0," $0;}' >> "$tmp1"

$AWK -F, < "$tmp1" '
BEGIN {
	printf("<table cellspacing=5>\n");
	printf("\t<tr>\n");
	printf("\t\t<th align=left>%s</th>\n", "User");
	printf("\t\t<th align=right>%s</th>\n", "Logins");
	printf("\t\t<th align=left>%s</th>\n", "Last");
	printf("\t\t<th align=left>%s</th>\n", "From");
	printf("\t\t<th align=right>%s</th>\n", "Downloads");
	printf("\t\t<th align=right>%s</th>\n", "Megabytes");
	printf("\t\t<th align=right>%s</th>\n", "Uploads");
	printf("\t\t<th align=right>%s</th>\n", "Megabytes");
	printf("\t</tr>\n");
}
{
	printf("\t<tr>\n");
	printf("\t\t<td align=left><a href=\"rptrealuserquery.cgi?%s+%s+%s+%s+%s+%s+%s+%s+%s+%s+%s\">%s</a></td>\n", a01, a02, a03, a04, a05, a06, a07, a08, a09, a10, $2, $2);
	printf("\t\t<td align=right>%d</td>\n", $1);
	printf("\t\t<td align=left>%s</td>\n", $3);
	printf("\t\t<td align=left>%s</td>\n", $8);
	printf("\t\t<td align=right>%d</td>\n", $4);
	printf("\t\t<td align=right>%.2f</td>\n", $5 / 1024.0);
	printf("\t\t<td align=right>%d</td>\n", $6);
	printf("\t\t<td align=right>%.2f</td>\n", $7 / 1024.0);
	printf("\t</tr>\n");
}
END {
	printf("</table>\n");
}' a01="$start_Y" a02="$start_B" a03="$start_d" a04="$start_H" a05="$start_M" a06="$end_Y" a07="$end_B" a08="$end_d" a09="$end_H" a10="$end_M"

/bin/rm -f $tmp1 $tmp2 $tmp3 $tmp4

##############################################################################
# End the finished web page.
##############################################################################

echo "<p><address></address></body></html>"
exit 0
