#!/bin/ksh

#############################################################################
# Copyright 1998, Mike Gleason.  All rights reserved.
#############################################################################

. /usr/local/etc/ncftpd/rptbin/ncftpd_reports.env

#############################################################################
# No more user-configurable options below this point.
#############################################################################

whoiam1=`$WHOAMI 2>/dev/null`
if [ "$whoiam1" = "" ] ; then whoiam="web" ; else whoiam="<b>$whoiam1</b>" ; fi

onhost1=`uname -n 2>/dev/null`
if [ "$onhost1" != "" ] ; then onhost=" on <b>$onhost1</b>" ; else onhost="" ; fi

#############################################################################
# Validate the input
#############################################################################

echo "Content-type: text/html"
echo ""

if [ "$#" -ne 10 ] ; then
	echo "<html><head><title>error</title></head><body>"
	echo "<p>Not enough parameters ($# of 10) given to generate report.</p>"
	echo "<p><address></address></body></html>"
	exit 2
fi

start_Y="$1"
start_B="$2"
start_d="$3"
start_H="$4"
start_M="$5"
shift 5

end_Y="$1"
end_B="$2"
end_d="$3"
end_H="$4"
end_M="$5"
shift 5

#############################################################################
# Sanity checks
#############################################################################

if [ ! -x "$LOGCAT" ] ; then
	echo "<html><head><title>error</title></head><body>"
	echo "<p>Cannot execute <TT>$LOGCAT</TT> as $whoiam user${onhost}."
	echo "<p><address></address></body></html>"
	exit 2
fi

##############################################################################
# Convert the "%B" form of the month into "%m" form
# (Unfortunate english language dependency)
##############################################################################

B="$start_B"
case "$B" in
	Jan*)	m=01 ;; Feb*)	m=02 ;; Mar*)	m=03 ;;
	Apr*)	m=04 ;; May*)	m=05 ;; Jun*)	m=06 ;;
	Jul*)	m=07 ;; Aug*)	m=08 ;; Sep*)	m=09 ;;
	Oct*)	m=10 ;; Nov*)	m=11 ;; Dec*)	m=12 ;;
	[0-9]*)	m="$B";; *)	m=01 ;;
esac
start_m="$m"

B="$end_B"
case "$B" in
	Jan*)	m=01 ;; Feb*)	m=02 ;; Mar*)	m=03 ;;
	Apr*)	m=04 ;; May*)	m=05 ;; Jun*)	m=06 ;;
	Jul*)	m=07 ;; Aug*)	m=08 ;; Sep*)	m=09 ;;
	Oct*)	m=10 ;; Nov*)	m=11 ;; Dec*)	m=12 ;;
	[0-9]*)	m="$B";; *)	m=01 ;;
esac
end_m="$m"

##############################################################################
# Convert the dates into timestamps.
# This is needed so we can compute the names of the monthly log files
# that will be used to get the stats from.
##############################################################################

start_date="${start_Y}-${start_m}-${start_d} ${start_H}:${start_M}:00"
start_ts=`$DATEMUNGER "$start_date"`
case "$start_ts" in
	[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]*)
		;;
	*)
		echo "<html><head><title>error</title></head><body>"
		echo "<p>Could not convert \"$start_date\" back to a timestamp."
		echo "<p><address></address></body></html>"
		exit 1
esac

end_date="${end_Y}-${end_m}-${end_d} ${end_H}:${end_M}:00"
end_ts=`$DATEMUNGER "$end_date"`
case "$end_ts" in
	[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]*)
		;;
	*)
		echo "<html><head><title>error</title></head><body>"
		echo "<p>Could not convert \"$end_date\" back to a timestamp."
		echo "<p><address></address></body></html>"
		exit 1
esac

#############################################################################
# Start the HTML page
#############################################################################

echo "<html>"
echo "<head>"
echo "<title>NcFTPd: Traffic Summary from $start_date to $end_date</title>"
echo "</head>"
echo "<body>"
echo "<!-- user: $whoiam1  host: $onhost1 -->"

##############################################################################
# Compute the lognames.
##############################################################################

start_yyyymmddHHMMSS=`$DATEMUNGER "$start_ts" formatted "%Y%m%d%H%M%S"`
end_yyyymmddHHMMSS=`$DATEMUNGER "$end_ts" formatted "%Y%m%d%H%M%S"`

echo "<!-- timestamps:  start=$start_ts             end=$end_ts -->"
echo "<!-- full:        start=$start_yyyymmddHHMMSS end=$end_yyyymmddHHMMSS -->"

$LOGCAT "$start_yyyymmddHHMMSS" "$end_yyyymmddHHMMSS" log-xfer "$DOMAIN_CF" "ALL" "set-name" \
	| tr '|' ',' \
	| $AWK -F, '
		{
			linesUsed++;
			i = index($0, "#");
			when = substr($0, 1, i - 2);

			type = $2;
			fn = $3;
			size = $4;
			completion = $11;

			vdomain = $NF;
			if (items[vdomain] != 1) {
				okdownloads[vdomain] = int(0);
				okmbdownloaded[vdomain] = 0.0;
				okuploads[vdomain] = int(0);
				okmbuploaded[vdomain] = 0.0;
			}
			items[vdomain] = 1;

			if (type == " R") {
				okdownloads[vdomain]++;
				okmbdownloaded[vdomain] += (size / (1024.0 * 1024.0));
			} else if (type == " S") {
				okuploads[vdomain]++;
				okmbuploaded[vdomain] += (size / (1024.0 * 1024.0));
			}
		}
		END {
			if (linesUsed < 1) {
				printf("<P>Sorry, there was no activity in the logs for that time period.\n");
			} else {
				printf("<table cellspacing=5>\n");
				printf("\t<tr>\n");
				printf("\t\t<th align=left>Domain</th>\n");
				printf("\t\t<th align=right>Downloads</th>\n");
				printf("\t\t<th align=right>MBytes</th>\n");
				printf("\t\t<th align=right>Uploads</th>\n");
				printf("\t\t<th align=right>MBytes</th>\n");
				printf("\t\t<th align=right>Total</th>\n");
				printf("\t\t<th align=right>MBytes</th>\n");
				printf("\t</tr>\n");
				for (vdomain in items) {
					printf("\t<tr>\n");
					printf("\t\t<td align=left>%s</td>\n", vdomain);
					printf("\t\t<td align=right>%d</td>\n", okdownloads[vdomain]);
					printf("\t\t<td align=right>%.3f</td>\n", okmbdownloaded[vdomain]);
					printf("\t\t<td align=right>%d</td>\n", okuploads[vdomain]);
					printf("\t\t<td align=right>%.3f</td>\n", okmbuploaded[vdomain]);
					printf("\t\t<td align=right>%d</td>\n", okuploads[vdomain] + okdownloads[vdomain]);
					printf("\t\t<td align=right>%.3f</td>\n", okmbuploaded[vdomain] + okmbdownloaded[vdomain]);
					printf("\t</tr>\n");
				}
				printf("</table>\n");
			}
		}'

##############################################################################
# End the finished web page.
##############################################################################

echo "<p><address></address></body></html>"
exit 0
