#!/bin/sh

#############################################################################
#
# How to use this CGI script:
#
# This CGI script can be used to designated system administrators manipulate
# NcFTPd password database using a web-based interface instead of running
# "ncftpd_passwd" directly.
#
# For highest security, do not install this script at all and continue to
# manually run "ncftpd_passwd".
#
# (1) Install "form2env" and set the path below.  "form2env" comes with the
#     NcFTPd Reporting Package, which is included in the "rptbin" directory
#     of the NcFTPd distribution you downloaded.
#
# (2) Create the file /etc/ftp.passwd.conf.  "chown root" and "chmod 600"
#     the file.  Then edit the file and add a line that contains the complete
#     pathname to the password database, followed by a space, followed by
#     the username the web server runs the CGI as, followed by a comma,
#     followed by the token "allow-setuid-root".  A sample line could look
#     like:
#        /usr/local/etc/ncftpd/passwd.db web,allow-setuid-root
#
# (3) Make ncftpd_passwd setuid root.  I.e., "chown root ncftpd_passwd",
#     "chgrp 0 ncftpd_passwd", and "chmod 4711 ncftpd_passwd".  Make sure
#     that the NCFTPD_PASSWD shell variable above is set to the correct
#     path.
#
# (4) Copy this script to a cgi-bin directory, preferably one only
#     accessible by an https:// URL, since the form data transmits the
#     passwords in cleartext otherwise.
#
# (5) Don't forget to edit ADMINPASS below with your desired password.
#
# For better security, put a copy of ncftpd_passwd in a directory only
# accessible by the web user.  That way the only time the setuid-root
# version of ncftpd_passwd you just made is only used by the web server.
#
#############################################################################

FORM2ENV=/usr/local/bin/form2env
PASSWDDB=/usr/local/etc/ncftpd/passwd.db
NCFTPD_PASSWD=/usr/local/etc/ncftpd/ncftpd_passwd
ADMINPASS='test123'
DEBUG=no

#############################################################################
# No more user-configurable options below this point.
#############################################################################

me=`basename $0`

if [ "$#" -eq 0 ] ; then
	#####################################################################
	# The default action for this script is to display the form HTML page
	#####################################################################

	echo "Content-type: text/html"
	echo ""
	echo "<html>"
	echo "<head>"
	echo "<title>NcFTPd: Virtual User Administration</title>"
	echo "</head>"
	echo "<body bgcolor=\"#FFFFFF\">"

	echo "<p>"
	echo "<form action=\"${me}?query\" method=\"post\">"
	echo "<table>"
	echo "<tr><td><b>Admin Password</b>:</td><td><input type=text name=\"admin_nosh\" size=16 maxlength=63></td></tr>"
	echo "<tr><td><b>Username</b>:</td><td><input type=text name=\"user_ano\" size=16 maxlength=63></td></tr>"
	echo "<tr><td></td><td><input value=\"Query User\" type=\"submit\"></td></tr>"
	echo "</table>"
	echo "</form>"
	echo "<hr>"

	echo "<p>"
	echo "<form action=\"${me}?list\" method=\"post\">"
	echo "<table>"
	echo "<tr><td><b>Admin Password</b>:</td><td><input type=text name=\"admin_nosh\" size=16 maxlength=63></td></tr>"
	echo "<tr><td></td><td><input value=\"List All Users\" type=\"submit\"></td></tr>"
	echo "</table>"
	echo "</form>"
	echo "<hr>"

	echo "<p>"
	echo "<form action=\"${me}?delete\" method=\"post\">"
	echo "<table>"
	echo "<tr><td><b>Admin Password</b>:</td><td><input type=text name=\"admin_nosh\" size=16 maxlength=63></td></tr>"
	echo "<tr><td><b>Username</b>:</td><td><input type=text name=\"user_ano\" size=16 maxlength=63></td></tr>"
	echo "<tr><td></td><td><input value=\"Delete User\" type=\"submit\"></td></tr>"
	echo "</table>"
	echo "</form>"
	echo "<hr>"

	echo "<p>"
	echo "<form action=\"${me}?add\" method=\"post\">"
	echo "<table>"
	echo "<tr><td><b>Admin Password</b>:</td><td><input type=text name=\"admin_nosh\" size=16 maxlength=63></td></tr>"
	echo "<tr><td><b>New Username</b>:</td><td><input type=text name=\"user_ano\" size=16 maxlength=63></td></tr>"
	echo "<tr><td><b>New Password</b>:</td><td><input type=text name=\"pass\" size=16 maxlength=63></td></tr>"
	echo "<tr><td><b>UID</b>:</td><td><input type=text name=\"uid_num\" size=6 maxlength=6></td></tr>"
	echo "<tr><td><b>GID</b>:</td><td><input type=text name=\"gid_num\" size=6 maxlength=6></td></tr>"
	echo "<tr><td><b>Directory</b>:</td><td><input type=text name=\"home_nosh\" size=40 maxlength=127></td></tr>"
	echo "<tr><td><b>Quota</b>:</td><td><input type=text name=\"qbh_num\" size=6 maxlength=6> kB</td></tr>"
	echo "<tr><td></td><td><input type=text name=\"qfh_num\" size=6 maxlength=6> files</td></tr>"
	echo "<tr><td><b>Bandwidth Limit (download)</b>:</td><td><input type=text name=\"downlim_num\" size=6 maxlength=6> kB/sec</td></tr>"
	echo "<tr><td><b>Bandwidth Limit (upload)</b>:</td><td><input type=text name=\"uplim_num\" size=6 maxlength=6> kB/sec</td></tr>"
	echo "<tr><td></td><td><input value=\"Add New User\" type=\"submit\"></td></tr>"
	echo "</table>"
	echo "</form>"

	echo "<p><address></address></body></html>"
else
	#####################################################################
	# Process the form data
	#####################################################################

	for f in "$FORM2ENV" "$NCFTPD_PASSWD" "$PASSWDDB" ; do
		if [ ! -f "$f" ] ; then
			echo "Content-type: text/html"
			echo ""
			echo "<html>"
			echo "<head>"
			echo "<title>Error</title>"
			echo "</head>"
			echo "<body><p>"
			echo "Missing <TT>$f</TT>, or it is not accessible."
			echo "Check the permissions on the parent directories and the file itself."
			echo "</p></body>"
			echo "</html>"
			exit 1
		fi
	done

	for f in "$FORM2ENV" "$NCFTPD_PASSWD" ; do
		if [ ! -x "$f" ] ; then
			echo "Content-type: text/html"
			echo ""
			echo "<html>"
			echo "<head>"
			echo "<title>Error</title>"
			echo "</head>"
			echo "<body>"
			echo "<p>"
			echo "Cannot execute <TT>$f</TT>."
			echo "</p><pre>"
			/bin/ls -l "$f" 2>&1
			echo "</pre>"
			echo "</body>"
			echo "</html>"
			exit 1
		fi
	done

	if [ "$DEBUG" = yes ] ; then
		/bin/rm -f /tmp/form.env
		echo '-----before-----' > /tmp/form.env
		set >> /tmp/form.env
		eval `tee /tmp/form.input | $FORM2ENV`
		echo '-----after-----' >> /tmp/form.env
		set >> /tmp/form.env
	else
		eval `$FORM2ENV`
	fi

	#####################################################################
	# This set the following environment variables based upon the
	# form response data:
	#
	#       form_admin_nosh
	#       form_user_ano
	#	form_pass
	#	form_uid_num
	#	form_gid_num
	#	form_home_nosh
	#	form_qbh_num
	#	form_qfh_num
	#	form_downlim_num
	#	form_uplim_num
	#
	# The naming convention determines how the form data is filtered
	# by the form2env program.  This is important since a common attack
	# on CGI scripts is to try and pass in characters that could cause
	# a command to be run.
	#
	# The "_ao" means alphabetic-only, so every character except A-Z
	# and a-z are deleted from the input.  "_ano" means alpha-numeric
	# only, and "_nosh" means exclude characters that have special
	# meaning to the shell.
	#
	# The "_num" means only 0-9 and . are allowed.  The "_num_02d"
	# means to make sure the result is zero-padded to two digits.
	#####################################################################

	if [ "$ADMINPASS" = test123 ] ; then
		echo "Content-type: text/html"
		echo ""
		echo "<html>"
		echo "<head>"
		echo "<title>Error</title>"
		echo "</head>"
		echo "<body><p>"
		echo "Admin password has not been changed from the default vaule."
		echo "Edit the script and choose a new password."
		echo "</p></body>"
		echo "</html>"
		exit 1
	fi

	if [ "$form_admin_nosh" != "$ADMINPASS" ] ; then
		echo "Content-type: text/html"
		echo ""
		echo "<html>"
		echo "<head>"
		echo "<title>Error</title>"
		echo "</head>"
		echo "<body><p>"
		echo "Admin password was incorrect.  Please verify your password and try again."
		echo "</p></body>"
		echo "</html>"
		exit 1
	fi

	echo "Content-type: text/html"
	echo ""
	echo "<html>"
	echo "<head>"
	echo "<title>NcFTPd: Results</title>"
	echo "</head>"
	echo "<body bgcolor=\"#FFFFFF\">"
	echo "<p>"

	case "$1" in
		delete)
			$NCFTPD_PASSWD -f "$PASSWDDB" -d "$form_user_ano" 2>&1
			;;
		list)
			echo "<table>"
			echo "<tr align=left valign=bottom>"
			echo "	<th>User</th>"
			echo "	<th>UID</th>"
			echo "	<th>GIDs</th>"
			echo "	<th>Directory</th>"
			echo "	<th>Quota<br>kB</th>"
			echo "	<th>Quota<br>files</th>"
			echo "	<th>Bandwidth<br>Download</th>"
			echo "	<th>Bandwidth<br>Upload</th>"
			echo "</tr>"
			$NCFTPD_PASSWD -f "$PASSWDDB" -x 2>&1 | \
			sort -t: -f | \
			awk -F: '{
printf("<tr align=left>\n\t<td>%s</td>\n", $1);
printf("\t<td>%s</td>\n", $3);
printf("\t<td>%s</td>\n", $4);
printf("\t<td>%s</td>\n", $6);
printf("\t<td>%s</td>\n", $8);
printf("\t<td>%s</td>\n", $10);
printf("\t<td>%s</td>\n", $13);
printf("\t<td>%s</td>\n", $14);
printf("</tr>\n");
			}'
			echo "</table>"
			echo "</pre>"
			;;
		query)
			echo "<table>"
			echo "<tr align=left valign=bottom>"
			echo "	<th>User</th>"
			echo "	<th>UID</th>"
			echo "	<th>GIDs</th>"
			echo "	<th>Directory</th>"
			echo "	<th>Quota<br>kB</th>"
			echo "	<th>Quota<br>files</th>"
			echo "	<th>Bandwidth<br>Download</th>"
			echo "	<th>Bandwidth<br>Upload</th>"
			echo "</tr>"
			$NCFTPD_PASSWD -f "$PASSWDDB" -Q "$form_user_ano" 2>&1 | \
			awk -F: '{
printf("<tr align=left>\n\t<td>%s</td>\n", $1);
printf("\t<td>%s</td>\n", $3);
printf("\t<td>%s</td>\n", $4);
printf("\t<td>%s</td>\n", $6);
printf("\t<td>%s</td>\n", $8);
printf("\t<td>%s</td>\n", $10);
printf("\t<td>%s</td>\n", $13);
printf("\t<td>%s</td>\n", $14);
printf("</tr>\n");
			}'
			echo "</table>"
			echo "</pre>"
			;;
		add)
			form_qbs_num="$form_qbh_num"
			form_qfs_num="$form_qfh_num"
			form_qflags=0
			pwline="$form_user_ano-$form_pass-$form_uid_num-$form_gid_num---$form_home_nosh-/bin/false-$form_qbh_num-$form_qbs_num-$form_qfh_num-$form_qfh_num-$form_qflags-$form_downlim_num-$form_uplim_num"
			case "$pwline" in
				*:*)
					pwline="invalid"
					;;
				*)
					pwline="$form_user_ano:$form_pass:$form_uid_num:$form_gid_num:-:$form_home_nosh:/bin/false:$form_qbh_num:$form_qbs_num:$form_qfh_num:$form_qfh_num:$form_qflags:$form_downlim_num:$form_uplim_num"
					;;
			esac
			echo "<pre>"
			$NCFTPD_PASSWD -f "$PASSWDDB" -a "$pwline" -c 2>&1
			echo "</pre>"
			;;
		*)
			echo "The form processor did not receive a &quot;submit&quot; argument."
			;;
	esac
	echo "</p>"
	echo "</body>"
	echo "</html>"
fi
