#!/bin/sh

#############################################################################
# Copyright 1998, Mike Gleason.  All rights reserved.
#############################################################################

. /usr/local/etc/ncftpd/rptbin/ncftpd_reports.env

#############################################################################
# No more user-configurable options below this point.
#############################################################################

whoiam1=`$WHOAMI 2>/dev/null`
if [ "$whoiam1" = "" ] ; then whoiam="web" ; else whoiam="<b>$whoiam1</b>" ; fi

onhost1=`uname -n 2>/dev/null`
if [ "$onhost1" != "" ] ; then onhost=" on <b>$onhost1</b>" ; else onhost="" ; fi

#############################################################################
# Validate the input
#############################################################################

echo "Content-type: text/html"
echo ""

if [ "$#" -ne 13 ] ; then
	echo "<html><head><title>error</title></head><body>"
	echo "<p>Not enough parameters ($# of 13) given to generate report.</p>"
	echo "<p><address></address></body></html>"
	exit 2
fi

start_Y="$1"
start_B="$2"
start_d="$3"
start_H="$4"
start_M="$5"
shift 5

end_Y="$1"
end_B="$2"
end_d="$3"
end_H="$4"
end_M="$5"
shift 5

type="$1"
if [ "$type" = S ] ; then
	xtype="upload"
	Xtype="Upload"
else
	xtype="download"
	Xtype="Download"
fi
topN="$2"
vdomains="$3"

#############################################################################
# Sanity checks
#############################################################################

if [ ! -x "$LOGCAT" ] ; then
	echo "<html><head><title>error</title></head><body>"
	echo "<p>Cannot execute <TT>$LOGCAT</TT> as $whoiam user${onhost}."
	echo "<p><address></address></body></html>"
	exit 2
fi

##############################################################################
# Convert the "%B" form of the month into "%m" form
# (Unfortunate english language dependency)
##############################################################################

B="$start_B"
case "$B" in
	Jan*)	m=01 ;; Feb*)	m=02 ;; Mar*)	m=03 ;;
	Apr*)	m=04 ;; May*)	m=05 ;; Jun*)	m=06 ;;
	Jul*)	m=07 ;; Aug*)	m=08 ;; Sep*)	m=09 ;;
	Oct*)	m=10 ;; Nov*)	m=11 ;; Dec*)	m=12 ;;
	[0-9]*)	m="$B";; *)	m=01 ;;
esac
start_m="$m"

B="$end_B"
case "$B" in
	Jan*)	m=01 ;; Feb*)	m=02 ;; Mar*)	m=03 ;;
	Apr*)	m=04 ;; May*)	m=05 ;; Jun*)	m=06 ;;
	Jul*)	m=07 ;; Aug*)	m=08 ;; Sep*)	m=09 ;;
	Oct*)	m=10 ;; Nov*)	m=11 ;; Dec*)	m=12 ;;
	[0-9]*)	m="$B";; *)	m=01 ;;
esac
end_m="$m"

##############################################################################
# Convert the dates into timestamps.
# This is needed so we can compute the names of the monthly log files
# that will be used to get the stats from.
##############################################################################

start_date="${start_Y}-${start_m}-${start_d} ${start_H}:${start_M}:00"
start_ts=`$DATEMUNGER "$start_date"`
case "$start_ts" in
	[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]*)
		;;
	*)
		echo "<html><head><title>error</title></head><body>"
		echo "<p>Could not convert \"$start_date\" back to a timestamp."
		echo "<p><address></address></body></html>"
		exit 1
esac

end_date="${end_Y}-${end_m}-${end_d} ${end_H}:${end_M}:00"
end_ts=`$DATEMUNGER "$end_date"`
case "$end_ts" in
	[0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9][0-9]*)
		;;
	*)
		echo "<html><head><title>error</title></head><body>"
		echo "<p>Could not convert \"$end_date\" back to a timestamp."
		echo "<p><address></address></body></html>"
		exit 1
esac

#############################################################################
# Start the HTML page
#############################################################################

echo "<html>"
echo "<head>"
if [ "$type" = S ] ; then
	echo "<title>NcFTPd: Top $topN Uploads from $start_date to $end_date</title>"
else
	echo "<title>NcFTPd: Top $topN Downloads from $start_date to $end_date</title>"
fi
echo "</head>"
echo "<body>"
echo "<!-- user: $whoiam1  host: $onhost1 -->"
echo "<!-- top $topN for [$vdomains] -->"

##############################################################################
# Compute the lognames.
##############################################################################

start_yyyymmddHHMMSS=`$DATEMUNGER "$start_ts" formatted "%Y%m%d%H%M%S"`
end_yyyymmddHHMMSS=`$DATEMUNGER "$end_ts" formatted "%Y%m%d%H%M%S"`

echo "<!-- timestamps:  start=$start_ts             end=$end_ts -->"
echo "<!-- full:        start=$start_yyyymmddHHMMSS end=$end_yyyymmddHHMMSS-->"

ztype=" $type"
$LOGCAT "$start_yyyymmddHHMMSS" "$end_yyyymmddHHMMSS" log-xfer "$DOMAIN_CF" "$vdomains" \
	| tr '|' ',' \
	| $AWK -F, '($2 == "'"$ztype"'") && ($11 == "OK") {print $3;}' \
	| sort \
	| uniq -c \
	| sort -nr \
	| sed -n "1,${topN}p" \
	| $AWK '
		BEGIN {
			printf("<table cellspacing=3>\n");
			count = int(-1);
		}
		{
			linesUsed++;
			if (linesUsed == 1) {
				printf("\t<tr><th align=right>Rank</th><th align=left>Pathname</th><th align=right>%ss</th></tr>\n", Xtype);
			}
			col = index($0, $2);
			count = int($1);
			fn = substr($0, col);
			if (prevCount == count)
				rank = prevRank;
			else
				rank = linesUsed;
			printf("\t<tr><td align=right>#%d.<td align=left>%s</td><td align=right>%d</td></tr>\n", rank, fn, count);
			prevRank = rank;
			prevCount = count;
		}
		END {
			printf("</table>\n");
			if (linesUsed < 1) {
				printf("<P>Sorry, there was no activity in the logs for that time period.\n");
			}
		}' Xtype="$Xtype"

##############################################################################
# End the finished web page.
##############################################################################

echo "<p><address></address></body></html>"
exit 0
