#!/bin/sh

. /usr/local/etc/ncftpd/rptbin/ncftpd_reports.env

if [ $? -ne 0 ] ; then
	echo "Content-type: text/html"
	echo ""
	echo "<html>"
	echo "<head>"
	echo "<title>NcFTPd: Test Form</title>"
	echo "</head>"
	echo "<body>"
	echo "Could not source the <TT>/usr/local/etc/ncftpd/rptbin/ncftpd_reports.env</TT> file."
	echo "</body>"
	echo "</html>"
	exit 1
fi

DEBUG=yes

#############################################################################
# No more user-configurable options below this point.
#############################################################################

me=`basename $0`

if [ "$#" -eq 0 ] ; then
	#####################################################################
	# The default action for this script is to display the form HTML page
	#####################################################################

	echo "Content-type: text/html"
	echo ""
	echo "<html>"
	echo "<head>"
	echo "<title>NcFTPd: Test Form</title>"
	echo "</head>"
	echo "<body>"

	start_Y=`$DATEMUNGER now - 2 weeks formatted "%Y"`
	start_m=`$DATEMUNGER now - 2 weeks formatted "%m"`
	start_B=`$DATEMUNGER now - 2 weeks formatted "%B"`	# Full month
	start_d=`$DATEMUNGER now - 2 weeks formatted "%d"`
	start_H=00
	start_M=00
	echo "<p>"
	echo "<form action=\"${me}?submit\" method=\"post\">"

	echo "<P>You should see below the date and time of the start of the day two weeks ago, of the form &quot;yyyy-mm-dd, HH:MM&quot;:"
	echo "<ul>"
	echo "<li>$start_Y-$start_m-$start_d, $start_H:$start_M"
	echo "</ul>"
	echo "<P>Now, we'll test whether we can process the form."
	echo "To do that, select an (arbitrary) hour below."
	echo "When you hit the submit button, you should see the"
	echo "date of two weeks ago, with the hour changed to what you entered."
	echo "<P>Hour:"
	echo "<select name=\"hour_num_02d\">"
	echo "<option>00</option>"
	echo "<option>04</option>"
	echo "<option>08</option>"
	echo "<option>12</option>"
	echo "<option>16</option>"
	echo "<option>20</option>"
	echo "</select>"

	echo "<p>"
	echo "<input value=\"Submit\" type=\"submit\">"
	echo "</form>"
	echo "<p><address></address></body></html>"
else
	#####################################################################
	# Process the form data
	#####################################################################

	if [ "$DEBUG" = yes ] ; then
		echo '-----before-----' > /tmp/form.env
		set >> /tmp/form.env
		eval `tee /tmp/form.input | $FORM2ENV | tee /tmp/form2env.out`
		echo '-----after-----' >> /tmp/form.env
		set >> /tmp/form.env
	else
		eval `$FORM2ENV`
	fi

	#####################################################################
	# This set the following environment variable based upon the
	# form response data:
	#
	#	form_hour_num_02d
	#
	# The naming convention determines how the form data is filtered
	# by the form2env program.  This is important since a common attack
	# on CGI scripts is to try and pass in characters that could cause
	# a command to be run.
	#
	# The "_ao" means alphabetic-only, so every character except A-Z
	# and a-z are deleted from the input.
	#
	# The "_num" means only 0-9 and . are allowed.  The "_num_02d"
	# means to make sure the result is zero-padded to two digits.
	#####################################################################

	echo "Content-type: text/html"
	echo ""
	echo "<html>"
	echo "<head>"
	echo "<title>NcFTPd: Test Form Results</title>"
	echo "</head>"
	echo "<body>"
	echo "<p>"

	if [ "$1" != submit ] ; then
		echo "The form processor did not receive a &quot;submit&quot; argument."
	elif [ ! -x "$FORM2ENV" ] ; then
		echo "The form processor could not execute form2env ($FORM2ENV)."
	elif [ "$form_hour_num_02d" = "" ] ; then
		echo "The form processor could not parse the hour you entered."
		echo "<P>Is the form2env ($FORM2ENV) program executable?"
		echo "<P>"
		/bin/ls -ld "$FORM2ENV" 2>&1
	else
		echo "The form processor parsed &quot;${form_hour_num_02d}&quot; as the hour you entered."
		echo "<P>Now we will run datemunger ($DATEMUNGER) again to see if it understood the entire date.  You should see below a copy of the command line run, followed by a date of the form &quot;Weekday, MonthName DD, YYYY, at HH:MM:SS TIMEZONE&quot;:"
		start_Y=`$DATEMUNGER now - 2 weeks formatted "%Y"`
		start_m=`$DATEMUNGER now - 2 weeks formatted "%m"`
		start_d=`$DATEMUNGER now - 2 weeks formatted "%d"`
		start_H="$form_hour_num_02d"
		start_M=00

		echo "<ul>"
		echo "<li>"
		echo $DATEMUNGER "$start_Y-$start_m-$start_d,$start_H:$start_M:00" formatted "%A, %B %d, %Y, at %H:%M:00 %Z"
		echo "</li>"
		echo "<li>"
		$DATEMUNGER "$start_Y-$start_m-$start_d,$start_H:$start_M:00" formatted "%A, %B %d, %Y, at %H:%M:00 %Z"
		echo "</li>"
		echo "</ul>"
	fi
	echo "</body>"
	echo "</html>"
fi
