#!/bin/sh

echo "Content-type: text/html"
echo ""
echo "<html>"
echo "<head>"
echo "<title>NcFTPd: Test Plot</title>"
echo "</head>"
echo "<body>"
echo "<p>"

. /usr/local/etc/ncftpd/rptbin/ncftpd_reports.env

if [ $? -ne 0 ] ; then
	echo "Could not source the <TT>/usr/local/etc/ncftpd/rptbin/ncftpd_reports.env</TT> file."
	echo "</body>"
	echo "</html>"
	exit 1
fi

DEBUG=yes

#############################################################################
# No more user-configurable options below this point.
#############################################################################

if [ "$PLOTTING_GRAPHS" != yes ] ; then
	echo "Your <TT>ncftpd_reports.env</TT> file does not have PLOTTING_GRAPHS=yes."
	echo "</body>"
	echo "</html>"
	exit 1
fi

if [ "$PNG_GRAPH_OUTPUT" = yes ] ; then
	gp_term="png small color"
	gp_fmt="png"
else
	gp_term="gif small"
	gp_fmt="gif"
fi

#####################################################################
# The default action for this script is to display a sample graph
#####################################################################

relodir=$RELODIR/testplot
odir=$ODIR/testplot
if [ -d "$odir" ] ; then
	/bin/rm -rf "$odir"
	if [ -d "$odir" ] ; then
		echo "<p>Error: could not rm -r the existing <tt>$odir</tt> directory."
		echo "Make sure that <tt>`$WHOAMI`</tt> can write to <tt>$ODIR</tt>."
		echo "<p>"
		echo "<pre>"
		/bin/ls -ld "$ODIR" 2>&1
		/bin/ls -ld "$odir" 2>&1
		echo "Contents of <tt>$odir</tt>:"
		/bin/ls -lA "$odir" 2>&1
		echo "</pre>"
		echo "<p>"
	fi
fi
mkdirerr=`mkdir "$odir" 2>&1`
if [ ! -d "$odir" ] ; then
	echo "<p>Error: could not create the directory <tt>$odir</tt>."
	echo "Make sure that <tt>`$WHOAMI`</tt> can write to <tt>$ODIR</tt>."
	echo "<p>"
	echo "<pre>"
	/bin/ls -ld "$ODIR" 2>&1
	/bin/ls -ld "$odir" 2>&1
	echo "mkdir error was:"
	echo "$mkdirerr"
	echo "</pre>"
	echo "<p>"
fi
chmod 755 "$odir"

plotdata="$odir/data.txt"
script="$odir/gp.script"
gif="$odir/plot.${gp_fmt}"
relgif="$relodir/plot.${gp_fmt}"
gpresult="$odir/gp.result"

cat > "$plotdata" <<EOF
1 31
2 28
3 31
4 30
5 31
6 30
7 31
8 31
9 30
10 31
11 30
12 31
EOF

title="Number of days per month"
xlabel="Month"
intervalright=12

xtics=1
		cat > $script <<EOF
set term $gp_term
set title '$title'
set xlabel '$xlabel'
set xtics $xtics
set size 0.9,0.5
set output '$gif'
plot [1:$intervalright] [0: ] '$plotdata' title '' with boxes
EOF
		$GNUPLOT > $gpresult 2>&1 < $script

echo "<P>Gnuplot is installed as:"
echo "<P><pre>"
ls -l "$GNUPLOT" 2>&1
echo "</pre>"
echo "<P>"
echo "<P>"

echo "<P>You should see below a sample bar graph, which shows how many days"
echo "are in each month."
		echo "<p><center><img src=\"$relgif\" alt=\"$title\"></center>"

echo "<P>If you see the graph, then gnuplot is installed correctly."
echo "The graph file is stored as <TT>$gif</TT> and appears to a web browser as the relative URL <a href="$relgif">$relgif</a>."

if [ -f "$gif" ] ; then
echo "<P><pre>"
ls -l "$gif" 2>&1
echo "</pre>"
fi

if [ -s "$gpresult" ] ; then
	echo "<P><HR><P>"
	echo "Gnuplot printed the following messages when it was run:"
	echo "<pre>"
	cat $gpresult
	echo "</pre>"
fi

echo "<P><HR><P>"
echo "Gnuplot used the following command script file:"
echo "<pre>"
cat $script
echo "</pre>"

echo "<P><HR><P>"
echo "Gnuplot used the following plot data file:"
echo "<pre>"
cat $plotdata
echo "</pre>"

echo "<P><HR><P>"
echo "The equivalent shell script to generate the sample plot image would be:"
echo "<pre>"
echo "#!/bin/sh"
echo "#"
echo "# Run this script as user:"
echo "#   whoami=\"`whoami`\""
echo "#   id=\"`id 2>/dev/null`\""
echo "#"
echo ""
echo "cd /"
echo "if [ -d \"$odir\" ] ; then"
echo "    /bin/rm -rf \"$odir\""
echo "    if [ -d \"$odir\" ] ; then"
echo "        echo \"You did not have adequate permission to reset testplot directory.\" 1&gt;&amp;2"
echo "        exit 1"
echo "    fi"
echo "fi"
echo ""
echo "mkdir \"$odir\""
echo "if [ ! -d \"$odir\" ] ; then"
echo "    echo \"You did not have adequate permission to create the testplot directory.\" 1&gt;&amp;2"
echo "    exit 2"
echo "fi"
echo ""
echo "cat &gt; $plotdata &lt;&lt;EOF"
echo "1 31"
echo "2 28"
echo "3 31"
echo "4 30"
echo "5 31"
echo "6 30"
echo "7 31"
echo "8 31"
echo "9 30"
echo "10 31"
echo "11 30"
echo "12 31"
echo "EOF"
echo ""
echo "cat &gt; $script &lt;&lt;EOF"
echo "set term $gp_term"
echo "set title '$title'"
echo "set xlabel '$xlabel'"
echo "set xtics $xtics"
echo "set size 0.9,0.5"
echo "set output '$gif'"
echo "plot [1:$intervalright] [0: ] '$plotdata' title '' with boxes"
echo "EOF"
echo ""
echo "$GNUPLOT &gt; $gpresult 2&gt;&amp;1 &lt; $script"
echo ""
echo "/bin/ls -l $gif"
echo "exit 0	# end of script"
echo "</pre>"

echo "<p><address></address></body></html>"
