/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CCanvas;
import apple.awt.GraphicsClipper;
import apple.awt.MyCToolkit;
import apple.awt.PeerImpl;
import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.PaintEvent;
import jep.AppletFrame;
import jep.AppletHandlerFactory;
import sun.awt.RepaintArea;
import sun.java2d.SunGraphics2D;

public class MyCCanvas
extends CCanvas {
    protected static boolean showDebugInfo = false;
    protected AppletFrame ancestor = null;

    public static MyCCanvas createNew(Canvas canvas, long l, AppletFrame appletFrame) {
        MyCCanvas myCCanvas = new MyCCanvas(canvas, l);
        myCCanvas.setAncestor(appletFrame);
        myCCanvas.initPeer();
        return myCCanvas;
    }

    public MyCCanvas(Canvas canvas, long l) {
        super(canvas, l);
        if (showDebugInfo) {
            System.err.println("Called MyCCanvas(): Canvas (" + (canvas == null ? "null" : canvas.toString()) + ") " + "innerView (0x" + Long.toHexString(l) + ")");
        }
    }

    public void setAncestor(AppletFrame appletFrame) {
        this.ancestor = appletFrame;
    }

    public void handleEvent(AWTEvent aWTEvent) {
        if (aWTEvent == null) {
            return;
        }
        if (!(aWTEvent instanceof PaintEvent)) {
            super.handleEvent(aWTEvent);
            return;
        }
        if (this.ancestor == null) {
            super.handleEvent(aWTEvent);
            return;
        }
        if (!AppletHandlerFactory.isAppletViewDisplayable(this.ancestor.getCocoaParentView())) {
            if (showDebugInfo) {
                System.err.println("MyCCanvas handleEvent(): Skipping paint event because applet invisible");
            }
            return;
        }
        if (this.ancestor.updatesOff) {
            if (showDebugInfo) {
                System.err.println("MyCCanvas handleEvent(): Skipping paint event because updates off");
            }
            return;
        }
        Rectangle rectangle = this.ancestor.translateCurrentClip(MyCToolkit.getPeerTarget((PeerImpl)this));
        Rectangle rectangle2 = ((PaintEvent)aWTEvent).getUpdateRect();
        if (rectangle2 == null) {
            super.handleEvent(aWTEvent);
            return;
        }
        rectangle = rectangle.intersection(rectangle2);
        if (showDebugInfo) {
            System.err.println("MyCCanvas handleEvent(): updateRect clipped from " + rectangle2.toString() + " to " + rectangle.toString());
        }
        if (!rectangle.isEmpty()) {
            RepaintArea repaintArea = new RepaintArea();
            repaintArea.add(rectangle, aWTEvent.getID());
            this.paintArea = repaintArea;
            ((PaintEvent)aWTEvent).setUpdateRect(rectangle);
            super.handleEvent(aWTEvent);
        }
    }

    public Graphics getGraphics() {
        SunGraphics2D sunGraphics2D = (SunGraphics2D)super.getGraphics();
        GraphicsClipper graphicsClipper = null;
        try {
            Object[] objectArray = new Object[]{sunGraphics2D, this.ancestor, this};
            graphicsClipper = (GraphicsClipper)AppletHandlerFactory.graphicsClipperCreateNew.invoke(null, objectArray);
        }
        catch (Throwable throwable) {
            System.err.println("MyCCanvas getGraphics(): exception: " + throwable.getMessage());
            throwable.printStackTrace();
            return sunGraphics2D;
        }
        graphicsClipper.validateDevClip();
        return sunGraphics2D;
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " (jep)";
    }

    static {
        if ("true".equalsIgnoreCase(System.getProperty("jep.debuginfo", "false"))) {
            showDebugInfo = true;
        }
    }
}

