-- Copyright (C) 2000-2008 MySQL AB, 2008-2009 Sun Microsystems, Inc.
-- 
-- This program is free software; you can redistribute it and/or modify
-- it under the terms of the GNU General Public License as published by
-- the Free Software Foundation; version 2 of the License.
-- 
-- This program is distributed in the hope that it will be useful,
-- but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
-- GNU General Public License for more details.
-- 
-- You should have received a copy of the GNU General Public License
-- along with this program; if not, write to the Free Software
-- Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

-- DO NOT EDIT THIS FILE. It is generated automatically.

-- To use this file, load its contents into the mysql database. For example,
-- with the mysql client program, process the file like this, where
-- file_name is the name of this file:

--     mysql -u root -p mysql < file_name

set names 'utf8';

delete from help_topic;
delete from help_category;
delete from help_keyword;
delete from help_relation;

insert into help_category (help_category_id,name,parent_category_id,url) values (1,'Geographic',0,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (2,'Polygon properties',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (3,'WKT',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (4,'Numeric Functions',36,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (5,'Plugins',33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (6,'MBR',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (7,'Control flow functions',36,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (8,'Transactions',33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (9,'Account Management',33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (10,'Point properties',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (11,'Encryption Functions',36,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (12,'LineString properties',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (13,'Logical operators',36,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (14,'Miscellaneous Functions',36,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (15,'Information Functions',36,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (16,'Functions and Modifiers for Use with GROUP BY',33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (17,'Comparison operators',36,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (18,'Bit Functions',36,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (19,'Table Maintenance',33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (20,'Data Types',33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (21,'User-Defined Functions',33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (22,'Compound Statements',33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (23,'Geometry constructors',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (24,'GeometryCollection properties',1,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (25,'Administration',33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (26,'Data Manipulation',33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (27,'Utility',33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (28,'Language Structure',33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (29,'Geometry relations',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (30,'Date and Time Functions',36,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (31,'WKB',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (32,'Geographic Features',33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (33,'Contents',0,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (34,'Geometry properties',32,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (35,'String Functions',36,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (36,'Functions',33,'');
insert into help_category (help_category_id,name,parent_category_id,url) values (37,'Data Definition',33,'');

insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (0,16,'MIN','Syntax:\nMIN([DISTINCT] expr)\n\nReturns the minimum value of expr. MIN() may take a string argument; in\nsuch cases, it returns the minimum string value. See\nhttp://dev.mysql.com/doc/refman/5.1/en/mysql-indexes.html. The DISTINCT\nkeyword can be used to find the minimum of the distinct values of expr,\nhowever, this produces the same result as omitting DISTINCT.\n\nMIN() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','mysql> SELECT student_name, MIN(test_score), MAX(test_score)\n    ->        FROM student\n    ->        GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (1,26,'JOIN','MySQL supports the following JOIN syntaxes for the table_references\npart of SELECT statements and multiple-table DELETE and UPDATE\nstatements:\n\ntable_references:\n    table_reference [, table_reference] ...\n\ntable_reference:\n    table_factor\n  | join_table\n\ntable_factor:\n    tbl_name [[AS] alias] [index_hint_list]\n  | table_subquery [AS] alias\n  | ( table_references )\n  | { OJ table_reference LEFT OUTER JOIN table_reference\n        ON conditional_expr }\n\njoin_table:\n    table_reference [INNER | CROSS] JOIN table_factor [join_condition]\n  | table_reference STRAIGHT_JOIN table_factor\n  | table_reference STRAIGHT_JOIN table_factor ON conditional_expr\n  | table_reference {LEFT|RIGHT} [OUTER] JOIN table_reference join_condition\n  | table_reference NATURAL [{LEFT|RIGHT} [OUTER]] JOIN table_factor\n\njoin_condition:\n    ON conditional_expr\n  | USING (column_list)\n\nindex_hint_list:\n    index_hint [, index_hint] ...\n\nindex_hint:\n    USE {INDEX|KEY}\n      [{FOR {JOIN|ORDER BY|GROUP BY}] ([index_list])\n  | IGNORE {INDEX|KEY}\n      [{FOR {JOIN|ORDER BY|GROUP BY}] (index_list)\n  | FORCE {INDEX|KEY}\n      [{FOR {JOIN|ORDER BY|GROUP BY}] (index_list)\n\nindex_list:\n    index_name [, index_name] ...\n\nA table reference is also known as a join expression.\n\nThe syntax of table_factor is extended in comparison with the SQL\nStandard. The latter accepts only table_reference, not a list of them\ninside a pair of parentheses.\n\nThis is a conservative extension if we consider each comma in a list of\ntable_reference items as equivalent to an inner join. For example:\n\nSELECT * FROM t1 LEFT JOIN (t2, t3, t4)\n                 ON (t2.a=t1.a AND t3.b=t1.b AND t4.c=t1.c)\n\nis equivalent to:\n\nSELECT * FROM t1 LEFT JOIN (t2 CROSS JOIN t3 CROSS JOIN t4)\n                 ON (t2.a=t1.a AND t3.b=t1.b AND t4.c=t1.c)\n\nIn MySQL, CROSS JOIN is a syntactic equivalent to INNER JOIN (they can\nreplace each other). In standard SQL, they are not equivalent. INNER\nJOIN is used with an ON clause, CROSS JOIN is used otherwise.\n\nIn general, parentheses can be ignored in join expressions containing\nonly inner join operations. MySQL also supports nested joins (see\nhttp://dev.mysql.com/doc/refman/5.1/en/nested-join-optimization.html).\n\nIndex hints can be specified to affect how the MySQL optimizer makes\nuse of indexes. For more information, see\nhttp://dev.mysql.com/doc/refman/5.1/en/index-hints.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/join.html\n\n','SELECT left_tbl.*\n  FROM left_tbl LEFT JOIN right_tbl ON left_tbl.id = right_tbl.id\n  WHERE right_tbl.id IS NULL;\n','http://dev.mysql.com/doc/refman/5.1/en/join.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (2,35,'HEX','Syntax:\nHEX(N_or_S)\n\nIf N_or_S is a number, returns a string representation of the\nhexadecimal value of N, where N is a longlong (BIGINT) number. This is\nequivalent to CONV(N,10,16).\n\nIf N_or_S is a string, returns a hexadecimal string representation of\nN_or_S where each character in N_or_S is converted to two hexadecimal\ndigits. The inverse of this operation is performed by the UNHEX()\nfunction.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT HEX(255);\n        -> \'FF\'\nmysql> SELECT 0x616263;\n        -> \'abc\'\nmysql> SELECT HEX(\'abc\');\n        -> 616263\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (3,26,'REPLACE','Syntax:\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name [(col_name,...)]\n    {VALUES | VALUE} ({expr | DEFAULT},...),(...),...\n\nOr:\n\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name\n    SET col_name={expr | DEFAULT}, ...\n\nOr:\n\nREPLACE [LOW_PRIORITY | DELAYED]\n    [INTO] tbl_name [(col_name,...)]\n    SELECT ...\n\nREPLACE works exactly like INSERT, except that if an old row in the\ntable has the same value as a new row for a PRIMARY KEY or a UNIQUE\nindex, the old row is deleted before the new row is inserted. See [HELP\nINSERT].\n\nREPLACE is a MySQL extension to the SQL standard. It either inserts, or\ndeletes and inserts. For another MySQL extension to standard SQL ---\nthat either inserts or updates --- see\nhttp://dev.mysql.com/doc/refman/5.1/en/insert-on-duplicate.html.\n\nNote that unless the table has a PRIMARY KEY or UNIQUE index, using a\nREPLACE statement makes no sense. It becomes equivalent to INSERT,\nbecause there is no index to be used to determine whether a new row\nduplicates another.\n\nValues for all columns are taken from the values specified in the\nREPLACE statement. Any missing columns are set to their default values,\njust as happens for INSERT. You cannot refer to values from the current\nrow and use them in the new row. If you use an assignment such as SET\ncol_name = col_name + 1, the reference to the column name on the right\nhand side is treated as DEFAULT(col_name), so the assignment is\nequivalent to SET col_name = DEFAULT(col_name) + 1.\n\nTo use REPLACE, you must have both the INSERT and DELETE privileges for\nthe table.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/replace.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/replace.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (4,29,'CONTAINS','Contains(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 completely contains g2. This\ntests the opposite relationship as Within().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (5,34,'SRID','SRID(g)\n\nReturns an integer indicating the Spatial Reference System ID for the\ngeometry value g.\n\nIn MySQL, the SRID value is just an integer associated with the\ngeometry value. All calculations are done assuming Euclidean (planar)\ngeometry.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#general-geometry-property-functions\n\n','mysql> SELECT SRID(GeomFromText(\'LineString(1 1,2 2)\',101));\n+-----------------------------------------------+\n| SRID(GeomFromText(\'LineString(1 1,2 2)\',101)) |\n+-----------------------------------------------+\n|                                           101 |\n+-----------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#general-geometry-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (6,30,'CURRENT_TIMESTAMP','Syntax:\nCURRENT_TIMESTAMP, CURRENT_TIMESTAMP()\n\nCURRENT_TIMESTAMP and CURRENT_TIMESTAMP() are synonyms for NOW().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (7,25,'SHOW CONTRIBUTORS','Syntax:\nSHOW CONTRIBUTORS\n\nThe SHOW CONTRIBUTORS statement displays information about the people\nwho contribute to MySQL source or to causes that we support. For each\ncontributor, it displays Name, Location, and Comment values.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-contributors.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-contributors.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (8,16,'VARIANCE','Syntax:\nVARIANCE(expr)\n\nReturns the population standard variance of expr. This is an extension\nto standard SQL. The standard SQL function VAR_POP() can be used\ninstead.\n\nVARIANCE() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (9,37,'DROP SERVER','Syntax:\nDROP SERVER [ IF EXISTS ] server_name\n\nDrops the server definition for the server named server_name. The\ncorresponding row within the mysql.servers table will be deleted. This\nstatement requires the SUPER privilege.\n\nDropping a server for a table does not affect any FEDERATED tables that\nused this connection information when they were created. See [HELP\nCREATE SERVER].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-server.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-server.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (10,25,'SHOW AUTHORS','Syntax:\nSHOW AUTHORS\n\nThe SHOW AUTHORS statement displays information about the people who\nwork on MySQL. For each author, it displays Name, Location, and Comment\nvalues.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-authors.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-authors.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (11,16,'VAR_SAMP','Syntax:\nVAR_SAMP(expr)\n\nReturns the sample variance of expr. That is, the denominator is the\nnumber of rows minus one.\n\nVAR_SAMP() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (12,35,'CONCAT','Syntax:\nCONCAT(str1,str2,...)\n\nReturns the string that results from concatenating the arguments. May\nhave one or more arguments. If all arguments are nonbinary strings, the\nresult is a nonbinary string. If the arguments include any binary\nstrings, the result is a binary string. A numeric argument is converted\nto its equivalent binary string form; if you want to avoid that, you\ncan use an explicit type cast, as in this example:\n\nSELECT CONCAT(CAST(int_col AS CHAR), char_col);\n\nCONCAT() returns NULL if any argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT CONCAT(\'My\', \'S\', \'QL\');\n        -> \'MySQL\'\nmysql> SELECT CONCAT(\'My\', NULL, \'QL\');\n        -> NULL\nmysql> SELECT CONCAT(14.3);\n        -> \'14.3\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (13,32,'GEOMETRY HIERARCHY','Geometry is the base class. It is an abstract class. The instantiable\nsubclasses of Geometry are restricted to zero-, one-, and\ntwo-dimensional geometric objects that exist in two-dimensional\ncoordinate space. All instantiable geometry classes are defined so that\nvalid instances of a geometry class are topologically closed (that is,\nall defined geometries include their boundary).\n\nThe base Geometry class has subclasses for Point, Curve, Surface, and\nGeometryCollection:\n\no Point represents zero-dimensional objects.\n\no Curve represents one-dimensional objects, and has subclass\n  LineString, with sub-subclasses Line and LinearRing.\n\no Surface is designed for two-dimensional objects and has subclass\n  Polygon.\n\no GeometryCollection has specialized zero-, one-, and two-dimensional\n  collection classes named MultiPoint, MultiLineString, and\n  MultiPolygon for modeling geometries corresponding to collections of\n  Points, LineStrings, and Polygons, respectively. MultiCurve and\n  MultiSurface are introduced as abstract superclasses that generalize\n  the collection interfaces to handle Curves and Surfaces.\n\nGeometry, Curve, Surface, MultiCurve, and MultiSurface are defined as\nnoninstantiable classes. They define a common set of methods for their\nsubclasses and are included for extensibility.\n\nPoint, LineString, Polygon, GeometryCollection, MultiPoint,\nMultiLineString, and MultiPolygon are instantiable classes.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-geometry-class-hierarchy.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-geometry-class-hierarchy.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (14,35,'CHAR FUNCTION','Syntax:\nCHAR(N,... [USING charset_name])\n\nCHAR() interprets each argument N as an integer and returns a string\nconsisting of the characters given by the code values of those\nintegers. NULL values are skipped.\nBy default, CHAR() returns a binary string. To produce a string in a\ngiven character set, use the optional USING clause:\n\nmysql> SELECT CHARSET(CHAR(0x65)), CHARSET(CHAR(0x65 USING utf8));\n+---------------------+--------------------------------+\n| CHARSET(CHAR(0x65)) | CHARSET(CHAR(0x65 USING utf8)) |\n+---------------------+--------------------------------+\n| binary              | utf8                           |\n+---------------------+--------------------------------+\n\nIf USING is given and the result string is illegal for the given\ncharacter set, a warning is issued. Also, if strict SQL mode is\nenabled, the result from CHAR() becomes NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT CHAR(77,121,83,81,\'76\');\n        -> \'MySQL\'\nmysql> SELECT CHAR(77,77.3,\'77.3\');\n        -> \'MMM\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (15,20,'DATETIME','DATETIME\n\nA date and time combination. The supported range is \'1000-01-01\n00:00:00\' to \'9999-12-31 23:59:59\'. MySQL displays DATETIME values in\n\'YYYY-MM-DD HH:MM:SS\' format, but allows assignment of values to\nDATETIME columns using either strings or numbers.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (16,22,'OPEN','Syntax:\nOPEN cursor_name\n\nThis statement opens a previously declared cursor.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/open.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/open.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (17,25,'SHOW CREATE TRIGGER','Syntax:\nSHOW CREATE TRIGGER trigger_name\n\nThis statement shows a CREATE TRIGGER statement that creates the given\ntrigger.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-create-trigger.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-create-trigger.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (18,25,'SHOW CREATE PROCEDURE','Syntax:\nSHOW CREATE PROCEDURE proc_name\n\nThis statement is a MySQL extension. It returns the exact string that\ncan be used to re-create the named stored procedure. A similar\nstatement, SHOW CREATE FUNCTION, displays information about stored\nfunctions (see [HELP SHOW CREATE FUNCTION]).\n\nBoth statements require that you be the owner of the routine or have\nSELECT access to the mysql.proc table. If you do not have privileges\nfor the routine itself, the value displayed for the Create Procedure or\nCreate Function field will be NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-create-procedure.html\n\n','mysql> SHOW CREATE PROCEDURE test.simpleproc\\G\n*************************** 1. row ***************************\n           Procedure: simpleproc\n            sql_mode:\n    Create Procedure: CREATE PROCEDURE `simpleproc`(OUT param1 INT)\n                      BEGIN\n                      SELECT COUNT(*) INTO param1 FROM t;\n                      END\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n  Database Collation: latin1_swedish_ci\n\nmysql> SHOW CREATE FUNCTION test.hello\\G\n*************************** 1. row ***************************\n            Function: hello\n            sql_mode:\n     Create Function: CREATE FUNCTION `hello`(s CHAR(20))\n                      RETURNS CHAR(50)\n                      RETURN CONCAT(\'Hello, \',s,\'!\')\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n  Database Collation: latin1_swedish_ci\n','http://dev.mysql.com/doc/refman/5.1/en/show-create-procedure.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (19,20,'INTEGER','INTEGER[(M)] [UNSIGNED] [ZEROFILL]\n\nThis type is a synonym for INT.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (20,35,'LOWER','Syntax:\nLOWER(str)\n\nReturns the string str with all characters changed to lowercase\naccording to the current character set mapping. The default is latin1\n(cp1252 West European).\n\nmysql> SELECT LOWER(\'QUADRATICALLY\');\n        -> \'quadratically\'\n\nLOWER() (and UPPER()) are ineffective when applied to binary strings\n(BINARY, VARBINARY, BLOB). To perform lettercase conversion, convert\nthe string to a nonbinary string:\n\nmysql> SET @str = BINARY \'New York\';\nmysql> SELECT LOWER(@str), LOWER(CONVERT(@str USING latin1));\n+-------------+-----------------------------------+\n| LOWER(@str) | LOWER(CONVERT(@str USING latin1)) |\n+-------------+-----------------------------------+\n| New York    | new york                          |\n+-------------+-----------------------------------+\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (21,25,'SHOW COLUMNS','Syntax:\nSHOW [FULL] COLUMNS {FROM | IN} tbl_name [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW COLUMNS displays information about the columns in a given table.\nIt also works for views. The LIKE clause, if present, indicates which\ncolumn names to match. The WHERE clause can be given to select rows\nusing more general conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.1/en/extended-show.html.\n\nmysql> SHOW COLUMNS FROM City;\n+------------+----------+------+-----+---------+----------------+\n| Field      | Type     | Null | Key | Default | Extra          |\n+------------+----------+------+-----+---------+----------------+\n| Id         | int(11)  | NO   | PRI | NULL    | auto_increment |\n| Name       | char(35) | NO   |     |         |                |\n| Country    | char(3)  | NO   | UNI |         |                |\n| District   | char(20) | YES  | MUL |         |                |\n| Population | int(11)  | NO   |     | 0       |                |\n+------------+----------+------+-----+---------+----------------+\n5 rows in set (0.00 sec)\n\nIf the data types differ from what you expect them to be based on a\nCREATE TABLE statement, note that MySQL sometimes changes data types\nwhen you create or alter a table. The conditions under which this\noccurs are described in\nhttp://dev.mysql.com/doc/refman/5.1/en/silent-column-changes.html.\n\nThe FULL keyword causes the output to include the column collation and\ncomments, as well as the privileges you have for each column.\n\nYou can use db_name.tbl_name as an alternative to the tbl_name FROM\ndb_name syntax. In other words, these two statements are equivalent:\n\nmysql> SHOW COLUMNS FROM mytable FROM mydb;\nmysql> SHOW COLUMNS FROM mydb.mytable;\n\nSHOW COLUMNS displays the following values for each table column:\n\nField indicates the column name.\n\nType indicates the column data type.\n\nCollation indicates the collation for nonbinary string columns, or NULL\nfor other columns. This value is displayed only if you use the FULL\nkeyword.\n\nThe Null field contains YES if NULL values can be stored in the column,\nNO if not.\n\nThe Key field indicates whether the column is indexed:\n\no If Key is empty, the column either is not indexed or is indexed only\n  as a secondary column in a multiple-column, nonunique index.\n\no If Key is PRI, the column is a PRIMARY KEY or is one of the columns\n  in a multiple-column PRIMARY KEY.\n\no If Key is UNI, the column is the first column of a unique-valued\n  index that cannot contain NULL values.\n\no If Key is MUL, multiple occurrences of a given value are allowed\n  within the column. The column is the first column of a nonunique\n  index or a unique-valued index that can contain NULL values.\n\nIf more than one of the Key values applies to a given column of a\ntable, Key displays the one with the highest priority, in the order\nPRI, UNI, MUL.\n\nA UNIQUE index may be displayed as PRI if it cannot contain NULL values\nand there is no PRIMARY KEY in the table. A UNIQUE index may display as\nMUL if several columns form a composite UNIQUE index; although the\ncombination of the columns is unique, each column can still hold\nmultiple occurrences of a given value.\n\nThe Default field indicates the default value that is assigned to the\ncolumn.\n\nThe Extra field contains any additional information that is available\nabout a given column. The value is nonempty in these cases:\nauto_increment for columns that have the AUTO_INCREMENT attribute; as\nof MySQL 5.1.23, on update CURRENT_TIMESTAMP for TIMESTAMP columns that\nhave the ON UPDATE CURRENT_TIMESTAMP attribute.\n\nPrivileges indicates the privileges you have for the column. This value\nis displayed only if you use the FULL keyword.\n\nComment indicates any comment the column has. This value is displayed\nonly if you use the FULL keyword.\n\nSHOW FIELDS is a synonym for SHOW COLUMNS. You can also list a table\'s\ncolumns with the mysqlshow db_name tbl_name command.\n\nThe DESCRIBE statement provides information similar to SHOW COLUMNS.\nSee [HELP DESCRIBE].\n\nThe SHOW CREATE TABLE, SHOW TABLE STATUS, and SHOW INDEX statements\nalso provide information about tables. See [HELP SHOW].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-columns.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-columns.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (22,37,'CREATE TRIGGER','Syntax:\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    TRIGGER trigger_name trigger_time trigger_event\n    ON tbl_name FOR EACH ROW trigger_stmt\n\nThis statement creates a new trigger. A trigger is a named database\nobject that is associated with a table, and that activates when a\nparticular event occurs for the table. The trigger becomes associated\nwith the table named tbl_name, which must refer to a permanent table.\nYou cannot associate a trigger with a TEMPORARY table or a view.\n\nCREATE TRIGGER requires the TRIGGER privilege for the table associated\nwith the trigger. (Before MySQL 5.1.6, this statement requires the\nSUPER privilege.)\n\nThe DEFINER clause determines the security context to be used when\nchecking access privileges at trigger activation time.\n\ntrigger_time is the trigger action time. It can be BEFORE or AFTER to\nindicate that the trigger activates before or after each row to be\nmodified.\n\ntrigger_event indicates the kind of statement that activates the\ntrigger. The trigger_event can be one of the following:\n\no INSERT: The trigger is activated whenever a new row is inserted into\n  the table; for example, through INSERT, LOAD DATA, and REPLACE\n  statements.\n\no UPDATE: The trigger is activated whenever a row is modified; for\n  example, through UPDATE statements.\n\no DELETE: The trigger is activated whenever a row is deleted from the\n  table; for example, through DELETE and REPLACE statements. However,\n  DROP TABLE and TRUNCATE statements on the table do not activate this\n  trigger, because they do not use DELETE. Dropping a partition does\n  not activate DELETE triggers, either. See [HELP TRUNCATE TABLE].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-trigger.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-trigger.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (23,30,'MONTH','Syntax:\nMONTH(date)\n\nReturns the month for date, in the range 1 to 12 for January to\nDecember, or 0 for dates such as \'0000-00-00\' or \'2008-00-00\' that have\na zero month part.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT MONTH(\'2008-02-03\');\n        -> 2\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (24,20,'TINYINT','TINYINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA very small integer. The signed range is -128 to 127. The unsigned\nrange is 0 to 255.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (25,25,'SHOW TRIGGERS','Syntax:\nSHOW TRIGGERS [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW TRIGGERS lists the triggers currently defined for tables in a\ndatabase (the default database unless a FROM clause is given). This\nstatement requires the TRIGGER privilege (prior to MySQL 5.1.22, it\nrequires the SUPER privilege). The LIKE clause, if present, indicates\nwhich table names to match and causes the statement to display triggers\nfor those tables. The WHERE clause can be given to select rows using\nmore general conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.1/en/extended-show.html.\n\nFor the trigger ins_sum as defined in\nhttp://dev.mysql.com/doc/refman/5.1/en/triggers.html, the output of\nthis statement is as shown here:\n\nmysql> SHOW TRIGGERS LIKE \'acc%\'\\G\n*************************** 1. row ***************************\n             Trigger: ins_sum\n               Event: INSERT\n               Table: account\n           Statement: SET @sum = @sum + NEW.amount\n              Timing: BEFORE\n             Created: NULL\n            sql_mode:\n             Definer: myname@localhost\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n  Database Collation: latin1_swedish_ci\n\ncharacter_set_client is the session value of the character_set_client\nsystem variable when the trigger was created. collation_connection is\nthe session value of the collation_connection system variable when the\ntrigger was created. Database Collation is the collation of the\ndatabase with which the trigger is associated. These columns were added\nin MySQL 5.1.21.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-triggers.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-triggers.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (26,14,'MASTER_POS_WAIT','Syntax:\nMASTER_POS_WAIT(log_name,log_pos[,timeout])\n\nThis function is useful for control of master/slave synchronization. It\nblocks until the slave has read and applied all updates up to the\nspecified position in the master log. The return value is the number of\nlog events the slave had to wait for to advance to the specified\nposition. The function returns NULL if the slave SQL thread is not\nstarted, the slave\'s master information is not initialized, the\narguments are incorrect, or an error occurs. It returns -1 if the\ntimeout has been exceeded. If the slave SQL thread stops while\nMASTER_POS_WAIT() is waiting, the function returns NULL. If the slave\nis past the specified position, the function returns immediately.\n\nIf a timeout value is specified, MASTER_POS_WAIT() stops waiting when\ntimeout seconds have elapsed. timeout must be greater than 0; a zero or\nnegative timeout means no timeout.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (27,35,'REGEXP','Syntax:\nexpr REGEXP pat, expr RLIKE pat\n\nPerforms a pattern match of a string expression expr against a pattern\npat. The pattern can be an extended regular expression. The syntax for\nregular expressions is discussed in\nhttp://dev.mysql.com/doc/refman/5.1/en/regexp.html. Returns 1 if expr\nmatches pat; otherwise it returns 0. If either expr or pat is NULL, the\nresult is NULL. RLIKE is a synonym for REGEXP, provided for mSQL\ncompatibility.\n\nThe pattern need not be a literal string. For example, it can be\nspecified as a string expression or table column.\n\n*Note*: Because MySQL uses the C escape syntax in strings (for example,\n"\\n" to represent the newline character), you must double any "\\" that\nyou use in your REGEXP strings.\n\nREGEXP is not case sensitive, except when used with binary strings.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/regexp.html\n\n','mysql> SELECT \'Monty!\' REGEXP \'m%y%%\';\n        -> 0\nmysql> SELECT \'Monty!\' REGEXP \'.*\';\n        -> 1\nmysql> SELECT \'new*\\n*line\' REGEXP \'new\\\\*.\\\\*line\';\n        -> 1\nmysql> SELECT \'a\' REGEXP \'A\', \'a\' REGEXP BINARY \'A\';\n        -> 1  0\nmysql> SELECT \'a\' REGEXP \'^[a-d]\';\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/regexp.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (28,22,'IF STATEMENT','Syntax:\nIF search_condition THEN statement_list\n    [ELSEIF search_condition THEN statement_list] ...\n    [ELSE statement_list]\nEND IF\n\nIF implements a basic conditional construct. If the search_condition\nevaluates to true, the corresponding SQL statement list is executed. If\nno search_condition matches, the statement list in the ELSE clause is\nexecuted. Each statement_list consists of one or more statements.\n\n*Note*: There is also an IF() function, which differs from the IF\nstatement described here. See\nhttp://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/if-statement.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/if-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (29,18,'^','Syntax:\n^\n\nBitwise XOR:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html\n\n','mysql> SELECT 1 ^ 1;\n        -> 0\nmysql> SELECT 1 ^ 0;\n        -> 1\nmysql> SELECT 11 ^ 3;\n        -> 8\n','http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (30,37,'DROP VIEW','Syntax:\nDROP VIEW [IF EXISTS]\n    view_name [, view_name] ...\n    [RESTRICT | CASCADE]\n\nDROP VIEW removes one or more views. You must have the DROP privilege\nfor each view. If any of the views named in the argument list do not\nexist, MySQL returns an error indicating by name which nonexisting\nviews it was unable to drop, but it also drops all of the views in the\nlist that do exist.\n\nThe IF EXISTS clause prevents an error from occurring for views that\ndon\'t exist. When this clause is given, a NOTE is generated for each\nnonexistent view. See [HELP SHOW WARNINGS].\n\nRESTRICT and CASCADE, if given, are parsed and ignored.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-view.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-view.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (31,29,'WITHIN','Within(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially within g2. This\ntests the opposite relationship as Contains().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (32,30,'WEEK','Syntax:\nWEEK(date[,mode])\n\nThis function returns the week number for date. The two-argument form\nof WEEK() allows you to specify whether the week starts on Sunday or\nMonday and whether the return value should be in the range from 0 to 53\nor from 1 to 53. If the mode argument is omitted, the value of the\ndefault_week_format system variable is used. See\nhttp://dev.mysql.com/doc/refman/5.1/en/server-system-variables.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT WEEK(\'2008-02-20\');\n        -> 7\nmysql> SELECT WEEK(\'2008-02-20\',0);\n        -> 7\nmysql> SELECT WEEK(\'2008-02-20\',1);\n        -> 8\nmysql> SELECT WEEK(\'2008-12-31\',1);\n        -> 53\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (33,25,'SHOW PLUGINS','Syntax:\nSHOW PLUGINS\n\nSHOW PLUGINS displays information about known plugins.\n\nmysql> SHOW PLUGINS;\n+------------+--------+----------------+---------+\n| Name       | Status | Type           | Library |\n+------------+--------+----------------+---------+\n| MEMORY     | ACTIVE | STORAGE ENGINE | NULL    |\n| MyISAM     | ACTIVE | STORAGE ENGINE | NULL    |\n| InnoDB     | ACTIVE | STORAGE ENGINE | NULL    |\n| ARCHIVE    | ACTIVE | STORAGE ENGINE | NULL    |\n| CSV        | ACTIVE | STORAGE ENGINE | NULL    |\n| BLACKHOLE  | ACTIVE | STORAGE ENGINE | NULL    |\n| FEDERATED  | ACTIVE | STORAGE ENGINE | NULL    |\n| MRG_MYISAM | ACTIVE | STORAGE ENGINE | NULL    |\n+------------+--------+----------------+---------+\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-plugins.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-plugins.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (34,21,'DROP FUNCTION UDF','Syntax:\nDROP FUNCTION function_name\n\nThis statement drops the user-defined function (UDF) named\nfunction_name.\n\nTo drop a function, you must have the DELETE privilege for the mysql\ndatabase. This is because DROP FUNCTION removes a row from the\nmysql.func system table that records the function\'s name, type, and\nshared library name.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-function-udf.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-function-udf.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (35,25,'PREPARE','Syntax:\nPREPARE stmt_name FROM preparable_stmt\n\nThe PREPARE statement prepares a statement and assigns it a name,\nstmt_name, by which to refer to the statement later. Statement names\nare not case sensitive. preparable_stmt is either a string literal or a\nuser variable that contains the text of the statement. The text must\nrepresent a single SQL statement, not multiple statements. Within the\nstatement, "?" characters can be used as parameter markers to indicate\nwhere data values are to be bound to the query later when you execute\nit. The "?" characters should not be enclosed within quotes, even if\nyou intend to bind them to string values. Parameter markers can be used\nonly where data values should appear, not for SQL keywords,\nidentifiers, and so forth.\n\nIf a prepared statement with the given name already exists, it is\ndeallocated implicitly before the new statement is prepared. This means\nthat if the new statement contains an error and cannot be prepared, an\nerror is returned and no statement with the given name exists.\n\nA prepared statement is executed with EXECUTE and released with\nDEALLOCATE PREPARE.\n\nThe scope of a prepared statement is the session within which it is\ncreated. Other sessions cannot see it.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/prepare.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/prepare.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (36,8,'LOCK','Syntax:\nLOCK TABLES\n    tbl_name [[AS] alias] lock_type\n    [, tbl_name [[AS] alias] lock_type] ...\n\nlock_type:\n    READ [LOCAL]\n  | [LOW_PRIORITY] WRITE\n\nUNLOCK TABLES\n\nMySQL enables client sessions to acquire table locks explicitly for the\npurpose of cooperating with other sessions for access to tables, or to\nprevent other sessions from modifying tables during periods when a\nsession requires exclusive access to them. A session can acquire or\nrelease locks only for itself. One session cannot acquire locks for\nanother session or release locks held by another session.\n\nLocks may be used to emulate transactions or to get more speed when\nupdating tables. This is explained in more detail later in this\nsection.\n\nLOCK TABLES explicitly acquires table locks for the current client\nsession. Table locks can be acquired for base tables or views. You must\nhave the LOCK TABLES privilege, and the SELECT privilege for each\nobject to be locked.\n\nFor view locking, LOCK TABLES adds all base tables used in the view to\nthe set of tables to be locked and locks them automatically. If you\nlock a table explicitly with LOCK TABLES, any tables used in triggers\nare also locked implicitly, as described in\nhttp://dev.mysql.com/doc/refman/5.1/en/lock-tables-and-triggers.html.\n\nUNLOCK TABLES explicitly releases any table locks held by the current\nsession.\n\nAnother use for UNLOCK TABLES is to release the global read lock\nacquired with the FLUSH TABLES WITH READ LOCK statement, which enables\nyou to lock all tables in all databases. See [HELP FLUSH]. (This is a\nvery convenient way to get backups if you have a file system such as\nVeritas that can take snapshots in time.)\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/lock-tables.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/lock-tables.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (37,35,'UPDATEXML','Syntax:\nUpdateXML(xml_target, xpath_expr, new_xml)\n\nThis function replaces a single portion of a given fragment of XML\nmarkup xml_target with a new XML fragment new_xml, and then returns the\nchanged XML. The portion of xml_target that is replaced matches an\nXPath expression xpath_expr supplied by the user. If no expression\nmatching xpath_expr is found, or if multiple matches are found, the\nfunction returns the original xml_target XML fragment. All three\narguments should be strings.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/xml-functions.html\n\n','mysql> SELECT\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'/a\', \'<e>fff</e>\') AS val1,\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'/b\', \'<e>fff</e>\') AS val2,\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'//b\', \'<e>fff</e>\') AS val3,\n    ->   UpdateXML(\'<a><b>ccc</b><d></d></a>\', \'/a/d\', \'<e>fff</e>\') AS val4,\n    ->   UpdateXML(\'<a><d></d><b>ccc</b><d></d></a>\', \'/a/d\', \'<e>fff</e>\') AS val5\n    -> \\G\n\n*************************** 1. row ***************************\nval1: <e>fff</e>\nval2: <a><b>ccc</b><d></d></a>\nval3: <a><e>fff</e><d></d></a>\nval4: <a><b>ccc</b><e>fff</e></a>\nval5: <a><d></d><b>ccc</b><d></d></a>\n','http://dev.mysql.com/doc/refman/5.1/en/xml-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (38,25,'RESET SLAVE','Syntax:\nRESET SLAVE\n\nRESET SLAVE makes the slave forget its replication position in the\nmaster\'s binary logs. This statement is meant to be used for a clean\nstart: It deletes the master.info and relay-log.info files, all the\nrelay logs, and starts a new relay log.\n\n*Note*: All relay logs are deleted, even if they have not been\ncompletely executed by the slave SQL thread. (This is a condition\nlikely to exist on a replication slave if you have issued a STOP SLAVE\nstatement or if the slave is highly loaded.)\n\nConnection information stored in the master.info file is immediately\nreset using any values specified in the corresponding startup options.\nThis information includes values such as master host, master port,\nmaster user, and master password. If the slave SQL thread was in the\nmiddle of replicating temporary tables when it was stopped, and RESET\nSLAVE is issued, these replicated temporary tables are deleted on the\nslave.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/reset-slave.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/reset-slave.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (39,25,'SHOW BINARY LOGS','Syntax:\nSHOW BINARY LOGS\nSHOW MASTER LOGS\n\nLists the binary log files on the server. This statement is used as\npart of the procedure described in [HELP PURGE BINARY LOGS], that shows\nhow to determine which logs can be purged.\n\nmysql> SHOW BINARY LOGS;\n+---------------+-----------+\n| Log_name      | File_size |\n+---------------+-----------+\n| binlog.000015 |    724935 |\n| binlog.000016 |    733481 |\n+---------------+-----------+\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-binary-logs.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-binary-logs.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (40,23,'POLYGON','Polygon(ls1,ls2,...)\n\nConstructs a Polygon value from a number of LineString or WKB\nLineString arguments. If any argument does not represent a LinearRing\n(that is, not a closed and simple LineString), the return value is\nNULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-mysql-specific-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-mysql-specific-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (41,30,'MINUTE','Syntax:\nMINUTE(time)\n\nReturns the minute for time, in the range 0 to 59.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT MINUTE(\'2008-02-03 10:05:03\');\n        -> 5\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (42,30,'DAY','Syntax:\nDAY(date)\n\nDAY() is a synonym for DAYOFMONTH().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (43,35,'MID','Syntax:\nMID(str,pos,len)\n\nMID(str,pos,len) is a synonym for SUBSTRING(str,pos,len).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (44,14,'UUID','Syntax:\nUUID()\n\nReturns a Universal Unique Identifier (UUID) generated according to\n"DCE 1.1: Remote Procedure Call" (Appendix A) CAE (Common Applications\nEnvironment) Specifications published by The Open Group in October 1997\n(Document Number C706,\nhttp://www.opengroup.org/public/pubs/catalog/c706.htm).\n\nA UUID is designed as a number that is globally unique in space and\ntime. Two calls to UUID() are expected to generate two different\nvalues, even if these calls are performed on two separate computers\nthat are not connected to each other.\n\nA UUID is a 128-bit number represented by a utf8 string of five\nhexadecimal numbers in aaaaaaaa-bbbb-cccc-dddd-eeeeeeeeeeee format:\n\no The first three numbers are generated from a timestamp.\n\no The fourth number preserves temporal uniqueness in case the timestamp\n  value loses monotonicity (for example, due to daylight saving time).\n\no The fifth number is an IEEE 802 node number that provides spatial\n  uniqueness. A random number is substituted if the latter is not\n  available (for example, because the host computer has no Ethernet\n  card, or we do not know how to find the hardware address of an\n  interface on your operating system). In this case, spatial uniqueness\n  cannot be guaranteed. Nevertheless, a collision should have very low\n  probability.\n\n  Currently, the MAC address of an interface is taken into account only\n  on FreeBSD and Linux. On other operating systems, MySQL uses a\n  randomly generated 48-bit number.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','mysql> SELECT UUID();\n        -> \'6ccd780c-baba-1026-9564-0040f4311e29\'\n','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (45,23,'LINESTRING','LineString(pt1,pt2,...)\n\nConstructs a LineString value from a number of Point or WKB Point\narguments. If the number of arguments is less than two, the return\nvalue is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-mysql-specific-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-mysql-specific-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (46,14,'SLEEP','Syntax:\nSLEEP(duration)\n\nSleeps (pauses) for the number of seconds given by the duration\nargument, then returns 0. If SLEEP() is interrupted, it returns 1. The\nduration may have a fractional part given in microseconds.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (47,15,'CONNECTION_ID','Syntax:\nCONNECTION_ID()\n\nReturns the connection ID (thread ID) for the connection. Every\nconnection has an ID that is unique among the set of currently\nconnected clients.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT CONNECTION_ID();\n        -> 23786\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (48,26,'DELETE','Syntax:\nSingle-table syntax:\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE] FROM tbl_name\n    [WHERE where_condition]\n    [ORDER BY ...]\n    [LIMIT row_count]\n\nMultiple-table syntax:\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE]\n    tbl_name[.*] [, tbl_name[.*]] ...\n    FROM table_references\n    [WHERE where_condition]\n\nOr:\n\nDELETE [LOW_PRIORITY] [QUICK] [IGNORE]\n    FROM tbl_name[.*] [, tbl_name[.*]] ...\n    USING table_references\n    [WHERE where_condition]\n\nFor the single-table syntax, the DELETE statement deletes rows from\ntbl_name and returns a count of the number of deleted rows. This count\ncan be obtained by calling the ROW_COUNT() function (see\nhttp://dev.mysql.com/doc/refman/5.1/en/information-functions.html). The\nWHERE clause, if given, specifies the conditions that identify which\nrows to delete. With no WHERE clause, all rows are deleted. If the\nORDER BY clause is specified, the rows are deleted in the order that is\nspecified. The LIMIT clause places a limit on the number of rows that\ncan be deleted.\n\nFor the multiple-table syntax, DELETE deletes from each tbl_name the\nrows that satisfy the conditions. In this case, ORDER BY and LIMIT\ncannot be used.\n\nwhere_condition is an expression that evaluates to true for each row to\nbe deleted. It is specified as described in\nhttp://dev.mysql.com/doc/refman/5.1/en/select.html.\n\nCurrently, you cannot delete from a table and select from the same\ntable in a subquery.\n\nYou need the DELETE privilege on a table to delete rows from it. You\nneed only the SELECT privilege for any columns that are only read, such\nas those named in the WHERE clause.\n\nAs stated, a DELETE statement with no WHERE clause deletes all rows. A\nfaster way to do this, when you do not need to know the number of\ndeleted rows, is to use TRUNCATE TABLE. However, within a transaction\nor if you have a lock on the table, TRUNCATE TABLE cannot be used\nwhereas DELETE can. See [HELP TRUNCATE TABLE], and [HELP LOCK].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/delete.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/delete.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (49,4,'ROUND','Syntax:\nROUND(X), ROUND(X,D)\n\nRounds the argument X to D decimal places. The rounding algorithm\ndepends on the data type of X. D defaults to 0 if not specified. D can\nbe negative to cause D digits left of the decimal point of the value X\nto become zero.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT ROUND(-1.23);\n        -> -1\nmysql> SELECT ROUND(-1.58);\n        -> -2\nmysql> SELECT ROUND(1.58);\n        -> 2\nmysql> SELECT ROUND(1.298, 1);\n        -> 1.3\nmysql> SELECT ROUND(1.298, 0);\n        -> 1\nmysql> SELECT ROUND(23.298, -1);\n        -> 20\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (50,7,'NULLIF','Syntax:\nNULLIF(expr1,expr2)\n\nReturns NULL if expr1 = expr2 is true, otherwise returns expr1. This is\nthe same as CASE WHEN expr1 = expr2 THEN NULL ELSE expr1 END.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html\n\n','mysql> SELECT NULLIF(1,1);\n        -> NULL\nmysql> SELECT NULLIF(1,2);\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (51,22,'CLOSE','Syntax:\nCLOSE cursor_name\n\nThis statement closes a previously opened cursor.\n\nIf not closed explicitly, a cursor is closed at the end of the compound\nstatement in which it was declared.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/close.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/close.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (52,25,'STOP SLAVE','Syntax:\nSTOP SLAVE [thread_type [, thread_type] ... ]\n\nthread_type: IO_THREAD | SQL_THREAD\n\nStops the slave threads. STOP SLAVE requires the SUPER privilege.\n\nLike START SLAVE, this statement may be used with the IO_THREAD and\nSQL_THREAD options to name the thread or threads to be stopped.\n\n*Note*: The transactional behavior of STOP SLAVE changed in MySQL\n5.1.35. Previously, it took effect immediately; beginning with MySQL\n5.1.35, it waits until the current replication event group (if any) has\nfinished executing, or until the user issues a KILL QUERY or KILL\nCONNECTION statement. (Bug#319 (http://bugs.mysql.com/319), Bug#38205\n(http://bugs.mysql.com/38205))\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/stop-slave.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/stop-slave.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (53,30,'TIMEDIFF','Syntax:\nTIMEDIFF(expr1,expr2)\n\nTIMEDIFF() returns expr1 - expr2 expressed as a time value. expr1 and\nexpr2 are time or date-and-time expressions, but both must be of the\nsame type.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT TIMEDIFF(\'2000:01:01 00:00:00\',\n    ->                 \'2000:01:01 00:00:00.000001\');\n        -> \'-00:00:00.000001\'\nmysql> SELECT TIMEDIFF(\'2008-12-31 23:59:59.000001\',\n    ->                 \'2008-12-30 01:01:01.000002\');\n        -> \'46:58:57.999999\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (54,35,'REPLACE FUNCTION','Syntax:\nREPLACE(str,from_str,to_str)\n\nReturns the string str with all occurrences of the string from_str\nreplaced by the string to_str. REPLACE() performs a case-sensitive\nmatch when searching for from_str.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT REPLACE(\'www.mysql.com\', \'w\', \'Ww\');\n        -> \'WwWwWw.mysql.com\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (55,27,'USE','Syntax:\nUSE db_name\n\nThe USE db_name statement tells MySQL to use the db_name database as\nthe default (current) database for subsequent statements. The database\nremains the default until the end of the session or another USE\nstatement is issued:\n\nUSE db1;\nSELECT COUNT(*) FROM mytable;   # selects from db1.mytable\nUSE db2;\nSELECT COUNT(*) FROM mytable;   # selects from db2.mytable\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/use.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/use.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (56,3,'LINEFROMTEXT','LineFromText(wkt[,srid]), LineStringFromText(wkt[,srid])\n\nConstructs a LINESTRING value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkt-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkt-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (57,7,'CASE OPERATOR','Syntax:\nCASE value WHEN [compare_value] THEN result [WHEN [compare_value] THEN\nresult ...] [ELSE result] END\n\nCASE WHEN [condition] THEN result [WHEN [condition] THEN result ...]\n[ELSE result] END\n\nThe first version returns the result where value=compare_value. The\nsecond version returns the result for the first condition that is true.\nIf there was no matching result value, the result after ELSE is\nreturned, or NULL if there is no ELSE part.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html\n\n','mysql> SELECT CASE 1 WHEN 1 THEN \'one\'\n    ->     WHEN 2 THEN \'two\' ELSE \'more\' END;\n        -> \'one\'\nmysql> SELECT CASE WHEN 1>0 THEN \'true\' ELSE \'false\' END;\n        -> \'true\'\nmysql> SELECT CASE BINARY \'B\'\n    ->     WHEN \'a\' THEN 1 WHEN \'b\' THEN 2 END;\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (58,25,'SHOW MASTER STATUS','Syntax:\nSHOW MASTER STATUS\n\nThis statement provides status information about the binary log files\nof the master. It requires either the SUPER or REPLICATION CLIENT\nprivilege.\n\nExample:\n\nmysql> SHOW MASTER STATUS;\n+---------------+----------+--------------+------------------+\n| File          | Position | Binlog_Do_DB | Binlog_Ignore_DB |\n+---------------+----------+--------------+------------------+\n| mysql-bin.003 | 73       | test         | manual,mysql     |\n+---------------+----------+--------------+------------------+\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-master-status.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-master-status.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (59,30,'ADDTIME','Syntax:\nADDTIME(expr1,expr2)\n\nADDTIME() adds expr2 to expr1 and returns the result. expr1 is a time\nor datetime expression, and expr2 is a time expression.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT ADDTIME(\'2007-12-31 23:59:59.999999\', \'1 1:1:1.000002\');\n        -> \'2008-01-02 01:01:01.000001\'\nmysql> SELECT ADDTIME(\'01:00:00.999999\', \'02:00:00.999998\');\n        -> \'03:00:01.999997\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (60,32,'SPATIAL','MySQL can create spatial indexes using syntax similar to that for\ncreating regular indexes, but extended with the SPATIAL keyword.\nCurrently, columns in spatial indexes must be declared NOT NULL. The\nfollowing examples demonstrate how to create spatial indexes:\n\no With CREATE TABLE:\n\nCREATE TABLE geom (g GEOMETRY NOT NULL, SPATIAL INDEX(g));\n\no With ALTER TABLE:\n\nALTER TABLE geom ADD SPATIAL INDEX(g);\n\no With CREATE INDEX:\n\nCREATE SPATIAL INDEX sp_index ON geom (g);\n\nFor MyISAM tables, SPATIAL INDEX creates an R-tree index. For storage\nengines that support nonspatial indexing of spatial columns, the engine\ncreates a B-tree index. A B-tree index on spatial values will be useful\nfor exact-value lookups, but not for range scans.\n\nFor more information on indexing spatial columns, see [HELP CREATE\nINDEX].\n\nTo drop spatial indexes, use ALTER TABLE or DROP INDEX:\n\no With ALTER TABLE:\n\nALTER TABLE geom DROP INDEX g;\n\no With DROP INDEX:\n\nDROP INDEX sp_index ON geom;\n\nExample: Suppose that a table geom contains more than 32,000\ngeometries, which are stored in the column g of type GEOMETRY. The\ntable also has an AUTO_INCREMENT column fid for storing object ID\nvalues.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-indexes.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-indexes.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (61,30,'TIMESTAMPDIFF','Syntax:\nTIMESTAMPDIFF(unit,datetime_expr1,datetime_expr2)\n\nReturns datetime_expr2 - datetime_expr1, where datetime_expr1 and\ndatetime_expr2 are date or datetime expressions. One expression may be\na date and the other a datetime; a date value is treated as a datetime\nhaving the time part \'00:00:00\' where necessary. The unit for the\nresult (an integer) is given by the unit argument. The legal values for\nunit are the same as those listed in the description of the\nTIMESTAMPADD() function.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT TIMESTAMPDIFF(MONTH,\'2003-02-01\',\'2003-05-01\');\n        -> 3\nmysql> SELECT TIMESTAMPDIFF(YEAR,\'2002-05-01\',\'2001-01-01\');\n        -> -1\nmysql> SELECT TIMESTAMPDIFF(MINUTE,\'2003-02-01\',\'2003-05-01 12:05:55\');\n        -> 128885\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (62,35,'UPPER','Syntax:\nUPPER(str)\n\nReturns the string str with all characters changed to uppercase\naccording to the current character set mapping. The default is latin1\n(cp1252 West European).\n\nmysql> SELECT UPPER(\'Hej\');\n        -> \'HEJ\'\n\nUPPER() is ineffective when applied to binary strings (BINARY,\nVARBINARY, BLOB). The description of LOWER() shows how to perform\nlettercase conversion of binary strings.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (63,30,'FROM_UNIXTIME','Syntax:\nFROM_UNIXTIME(unix_timestamp), FROM_UNIXTIME(unix_timestamp,format)\n\nReturns a representation of the unix_timestamp argument as a value in\n\'YYYY-MM-DD HH:MM:SS\' or YYYYMMDDHHMMSS.uuuuuu format, depending on\nwhether the function is used in a string or numeric context. The value\nis expressed in the current time zone. unix_timestamp is an internal\ntimestamp value such as is produced by the UNIX_TIMESTAMP() function.\n\nIf format is given, the result is formatted according to the format\nstring, which is used the same way as listed in the entry for the\nDATE_FORMAT() function.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT FROM_UNIXTIME(1196440219);\n        -> \'2007-11-30 10:30:19\'\nmysql> SELECT FROM_UNIXTIME(1196440219) + 0;\n        -> 20071130103019.000000\nmysql> SELECT FROM_UNIXTIME(UNIX_TIMESTAMP(),\n    ->                      \'%Y %D %M %h:%i:%s %x\');\n        -> \'2007 30th November 10:30:59 2007\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (64,20,'MEDIUMBLOB','MEDIUMBLOB\n\nA BLOB column with a maximum length of 16,777,215 (224 - 1) bytes. Each\nMEDIUMBLOB value is stored using a three-byte length prefix that\nindicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (65,7,'IFNULL','Syntax:\nIFNULL(expr1,expr2)\n\nIf expr1 is not NULL, IFNULL() returns expr1; otherwise it returns\nexpr2. IFNULL() returns a numeric or string value, depending on the\ncontext in which it is used.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html\n\n','mysql> SELECT IFNULL(1,0);\n        -> 1\nmysql> SELECT IFNULL(NULL,10);\n        -> 10\nmysql> SELECT IFNULL(1/0,10);\n        -> 10\nmysql> SELECT IFNULL(1/0,\'yes\');\n        -> \'yes\'\n','http://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (66,25,'SHOW FUNCTION CODE','Syntax:\nSHOW FUNCTION CODE func_name\n\nThis statement is similar to SHOW PROCEDURE CODE but for stored\nfunctions. See [HELP SHOW PROCEDURE CODE].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-function-code.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-function-code.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (67,25,'SHOW ERRORS','Syntax:\nSHOW ERRORS [LIMIT [offset,] row_count]\nSHOW COUNT(*) ERRORS\n\nThis statement is similar to SHOW WARNINGS, except that instead of\ndisplaying errors, warnings, and notes, it displays only errors.\n\nThe LIMIT clause has the same syntax as for the SELECT statement. See\nhttp://dev.mysql.com/doc/refman/5.1/en/select.html.\n\nThe SHOW COUNT(*) ERRORS statement displays the number of errors. You\ncan also retrieve this number from the error_count variable:\n\nSHOW COUNT(*) ERRORS;\nSELECT @@error_count;\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-errors.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-errors.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (68,17,'LEAST','Syntax:\nLEAST(value1,value2,...)\n\nWith two or more arguments, returns the smallest (minimum-valued)\nargument. The arguments are compared using the following rules:\n\no If the return value is used in an INTEGER context or all arguments\n  are integer-valued, they are compared as integers.\n\no If the return value is used in a REAL context or all arguments are\n  real-valued, they are compared as reals.\n\no If any argument is a case-sensitive string, the arguments are\n  compared as case-sensitive strings.\n\no In all other cases, the arguments are compared as case-insensitive\n  strings.\n\nLEAST() returns NULL if any argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT LEAST(2,0);\n        -> 0\nmysql> SELECT LEAST(34.0,3.0,5.0,767.0);\n        -> 3.0\nmysql> SELECT LEAST(\'B\',\'A\',\'C\');\n        -> \'A\'\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (69,17,'=','=\n\nEqual:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 1 = 0;\n        -> 0\nmysql> SELECT \'0\' = 0;\n        -> 1\nmysql> SELECT \'0.0\' = 0;\n        -> 1\nmysql> SELECT \'0.01\' = 0;\n        -> 0\nmysql> SELECT \'.01\' = 0.01;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (70,35,'REVERSE','Syntax:\nREVERSE(str)\n\nReturns the string str with the order of the characters reversed.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT REVERSE(\'abc\');\n        -> \'cba\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (71,17,'ISNULL','Syntax:\nISNULL(expr)\n\nIf expr is NULL, ISNULL() returns 1, otherwise it returns 0.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT ISNULL(1+1);\n        -> 0\nmysql> SELECT ISNULL(1/0);\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (72,20,'BINARY','BINARY(M)\n\nThe BINARY type is similar to the CHAR type, but stores binary byte\nstrings rather than nonbinary character strings. M represents the\ncolumn length in bytes.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (73,20,'BLOB DATA TYPE','A BLOB is a binary large object that can hold a variable amount of\ndata. The four BLOB types are TINYBLOB, BLOB, MEDIUMBLOB, and LONGBLOB.\nThese differ only in the maximum length of the values they can hold.\nThe four TEXT types are TINYTEXT, TEXT, MEDIUMTEXT, and LONGTEXT. These\ncorrespond to the four BLOB types and have the same maximum lengths and\nstorage requirements. See\nhttp://dev.mysql.com/doc/refman/5.1/en/storage-requirements.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/blob.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/blob.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (74,34,'BOUNDARY','Boundary(g)\n\nReturns a geometry that is the closure of the combinatorial boundary of\nthe geometry value g.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#general-geometry-property-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#general-geometry-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (75,9,'CREATE USER','Syntax:\nCREATE USER user [IDENTIFIED BY [PASSWORD] \'password\']\n    [, user [IDENTIFIED BY [PASSWORD] \'password\']] ...\n\nThe CREATE USER statement creates new MySQL accounts. To use it, you\nmust have the global CREATE USER privilege or the INSERT privilege for\nthe mysql database. For each account, CREATE USER creates a new row in\nthe mysql.user table that has no privileges. An error occurs if the\naccount already exists. Each account is named using the same format as\nfor the GRANT statement; for example, \'jeffrey\'@\'localhost\'. If you\nspecify only the user name part of the account name, a host name part\nof \'%\' is used. For additional information about specifying account\nnames, see [HELP GRANT].\n\nThe account can be given a password with the optional IDENTIFIED BY\nclause. The user value and the password are given the same way as for\nthe GRANT statement. In particular, to specify the password in plain\ntext, omit the PASSWORD keyword. To specify the password as the hashed\nvalue as returned by the PASSWORD() function, include the PASSWORD\nkeyword. See [HELP GRANT].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-user.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-user.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (76,23,'POINT','Point(x,y)\n\nConstructs a Point using its coordinates.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-mysql-specific-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-mysql-specific-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (77,15,'CURRENT_USER','Syntax:\nCURRENT_USER, CURRENT_USER()\n\nReturns the user name and host name combination for the MySQL account\nthat the server used to authenticate the current client. This account\ndetermines your access privileges. The return value is a string in the\nutf8 character set.\n\nThe value of CURRENT_USER() can differ from the value of USER().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT USER();\n        -> \'davida@localhost\'\nmysql> SELECT * FROM mysql.user;\nERROR 1044: Access denied for user \'\'@\'localhost\' to\ndatabase \'mysql\'\nmysql> SELECT CURRENT_USER();\n        -> \'@localhost\'\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (78,35,'LCASE','Syntax:\nLCASE(str)\n\nLCASE() is a synonym for LOWER().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (79,17,'<=','Syntax:\n<=\n\nLess than or equal:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 0.1 <= 2;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (80,25,'SHOW PROFILES','Syntax:\nSHOW PROFILE [type [, type] ... ]\n    [FOR QUERY n]\n    [LIMIT row_count [OFFSET offset]]\n\ntype:\n    ALL\n  | BLOCK IO\n  | CONTEXT SWITCHES\n  | CPU\n  | IPC\n  | MEMORY\n  | PAGE FAULTS\n  | SOURCE\n  | SWAPS\n\nThe SHOW PROFILES and SHOW PROFILE statements display profiling\ninformation that indicates resource usage for statements executed\nduring the course of the current session.\n\nProfiling is controlled by the profiling session variable, which has a\ndefault value of 0 (OFF). Profiling is enabled by setting profiling to\n1 or ON:\n\nmysql> SET profiling = 1;\n\nSHOW PROFILES displays a list of the most recent statements sent to the\nmaster. The size of the list is controlled by the\nprofiling_history_size session variable, which has a default value of\n15. The maximum value is 100. Setting the value to 0 has the practical\neffect of disabling profiling.\n\nAll statements are profiled except SHOW PROFILES and SHOW PROFILE, so\nyou will find neither of those statements in the profile list.\nMalformed statements are profiled. For example, SHOW PROFILING is an\nillegal statement, and a syntax error occurs if you try to execute it,\nbut it will show up in the profiling list.\n\nSHOW PROFILE displays detailed information about a single statement.\nWithout the FOR QUERY n clause, the output pertains to the most\nrecently executed statement. If FOR QUERY n is included, SHOW PROFILE\ndisplays information for statement n. The values of n correspond to the\nQuery_ID values displayed by SHOW PROFILES.\n\nThe LIMIT row_count clause may be given to limit the output to\nrow_count rows. If LIMIT is given, OFFSET offset may be added to begin\nthe output offset rows into the full set of rows.\n\nBy default, SHOW PROFILE displays Status and Duration columns. The\nStatus values are like the State values displayed by SHOW PROCESSLIST,\nalthought there might be some minor differences in interpretion for the\ntwo statements for some status values (see\nhttp://dev.mysql.com/doc/refman/5.1/en/thread-information.html).\n\nOptional type values may be specified to display specific additional\ntypes of information:\n\no ALL displays all information\n\no BLOCK IO displays counts for block input and output operations\n\no CONTEXT SWITCHES displays counts for voluntary and involuntary\n  context switches\n\no CPU displays user and system CPU usage times\n\no IPC displays counts for messages sent and received\n\no MEMORY is not currently implemented\n\no PAGE FAULTS displays counts for major and minor page faults\n\no SOURCE displays the names of functions from the source code, together\n  with the name and line number of the file in which the function\n  occurs\n\no SWAPS displays swap counts\n\nProfiling is enabled per session. When a session ends, its profiling\ninformation is lost.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-profiles.html\n\n','mysql> SELECT @@profiling;\n+-------------+\n| @@profiling |\n+-------------+\n|           0 |\n+-------------+\n1 row in set (0.00 sec)\n\nmysql> SET profiling = 1;\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> DROP TABLE IF EXISTS t1;\nQuery OK, 0 rows affected, 1 warning (0.00 sec)\n\nmysql> CREATE TABLE T1 (id INT);\nQuery OK, 0 rows affected (0.01 sec)\n\nmysql> SHOW PROFILES;\n+----------+----------+--------------------------+\n| Query_ID | Duration | Query                    |\n+----------+----------+--------------------------+\n|        0 | 0.000088 | SET PROFILING = 1        |\n|        1 | 0.000136 | DROP TABLE IF EXISTS t1  |\n|        2 | 0.011947 | CREATE TABLE t1 (id INT) |\n+----------+----------+--------------------------+\n3 rows in set (0.00 sec)\n\nmysql> SHOW PROFILE;\n+----------------------+----------+\n| Status               | Duration |\n+----------------------+----------+\n| checking permissions | 0.000040 |\n| creating table       | 0.000056 |\n| After create         | 0.011363 |\n| query end            | 0.000375 |\n| freeing items        | 0.000089 |\n| logging slow query   | 0.000019 |\n| cleaning up          | 0.000005 |\n+----------------------+----------+\n7 rows in set (0.00 sec)\n\nmysql> SHOW PROFILE FOR QUERY 1;\n+--------------------+----------+\n| Status             | Duration |\n+--------------------+----------+\n| query end          | 0.000107 |\n| freeing items      | 0.000008 |\n| logging slow query | 0.000015 |\n| cleaning up        | 0.000006 |\n+--------------------+----------+\n4 rows in set (0.00 sec)\n\nmysql> SHOW PROFILE CPU FOR QUERY 2;\n+----------------------+----------+----------+------------+\n| Status               | Duration | CPU_user | CPU_system |\n+----------------------+----------+----------+------------+\n| checking permissions | 0.000040 | 0.000038 |   0.000002 |\n| creating table       | 0.000056 | 0.000028 |   0.000028 |\n| After create         | 0.011363 | 0.000217 |   0.001571 |\n| query end            | 0.000375 | 0.000013 |   0.000028 |\n| freeing items        | 0.000089 | 0.000010 |   0.000014 |\n| logging slow query   | 0.000019 | 0.000009 |   0.000010 |\n| cleaning up          | 0.000005 | 0.000003 |   0.000002 |\n+----------------------+----------+----------+------------+\n7 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.1/en/show-profiles.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (81,26,'UPDATE','Syntax:\nSingle-table syntax:\n\nUPDATE [LOW_PRIORITY] [IGNORE] table_reference\n    SET col_name1={expr1|DEFAULT} [, col_name2={expr2|DEFAULT}] ...\n    [WHERE where_condition]\n    [ORDER BY ...]\n    [LIMIT row_count]\n\nMultiple-table syntax:\n\nUPDATE [LOW_PRIORITY] [IGNORE] table_references\n    SET col_name1={expr1|DEFAULT} [, col_name2={expr2|DEFAULT}] ...\n    [WHERE where_condition]\n\nFor the single-table syntax, the UPDATE statement updates columns of\nexisting rows in the named table with new values. The SET clause\nindicates which columns to modify and the values they should be given.\nEach value can be given as an expression, or the keyword DEFAULT to set\na column explicitly to its default value. The WHERE clause, if given,\nspecifies the conditions that identify which rows to update. With no\nWHERE clause, all rows are updated. If the ORDER BY clause is\nspecified, the rows are updated in the order that is specified. The\nLIMIT clause places a limit on the number of rows that can be updated.\n\nFor the multiple-table syntax, UPDATE updates rows in each table named\nin table_references that satisfy the conditions. In this case, ORDER BY\nand LIMIT cannot be used.\n\nwhere_condition is an expression that evaluates to true for each row to\nbe updated.\n\ntable_references and where_condition are is specified as described in\nhttp://dev.mysql.com/doc/refman/5.1/en/select.html.\n\nYou need the UPDATE privilege only for columns referenced in an UPDATE\nthat are actually updated. You need only the SELECT privilege for any\ncolumns that are read but not modified.\n\nThe UPDATE statement supports the following modifiers:\n\no If you use the LOW_PRIORITY keyword, execution of the UPDATE is\n  delayed until no other clients are reading from the table. This\n  affects only storage engines that use only table-level locking\n  (MyISAM, MEMORY, MERGE).\n\no If you use the IGNORE keyword, the update statement does not abort\n  even if errors occur during the update. Rows for which duplicate-key\n  conflicts occur are not updated. Rows for which columns are updated\n  to values that would cause data conversion errors are updated to the\n  closest valid values instead.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/update.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/update.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (82,17,'IS NOT NULL','Syntax:\nIS NOT NULL\n\nTests whether a value is not NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 1 IS NOT NULL, 0 IS NOT NULL, NULL IS NOT NULL;\n        -> 1, 1, 0\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (83,22,'CASE STATEMENT','Syntax:\nCASE case_value\n    WHEN when_value THEN statement_list\n    [WHEN when_value THEN statement_list] ...\n    [ELSE statement_list]\nEND CASE\n\nOr:\n\nCASE\n    WHEN search_condition THEN statement_list\n    [WHEN search_condition THEN statement_list] ...\n    [ELSE statement_list]\nEND CASE\n\nThe CASE statement for stored programs implements a complex conditional\nconstruct. If a search_condition evaluates to true, the corresponding\nSQL statement list is executed. If no search condition matches, the\nstatement list in the ELSE clause is executed. Each statement_list\nconsists of one or more statements.\n\nIf no when_value or search_condition matches the value tested and the\nCASE statement contains no ELSE clause, a Case not found for CASE\nstatement error results.\n\nEach statement_list consists of one or more statements; an empty\nstatement_list is not allowed. To handle situations where no value is\nmatched by any WHEN clause, use an ELSE containing an empty BEGIN ...\nEND block, as shown in this example: DELIMITER | CREATE PROCEDURE p()\nBEGIN DECLARE v INT DEFAULT 1; CASE v WHEN 2 THEN SELECT v; WHEN 3 THEN\nSELECT 0; ELSE BEGIN END; END CASE; END; | (The indentation used here\nin the ELSE clause is for purposes of clarity only, and is not\notherwise significant.)\n\n*Note*: The syntax of the CASE statement used inside stored programs\ndiffers slightly from that of the SQL CASE expression described in\nhttp://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html. The\nCASE statement cannot have an ELSE NULL clause, and it is terminated\nwith END CASE instead of END.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/case-statement.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/case-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (84,25,'EXECUTE STATEMENT','Syntax:\nEXECUTE stmt_name\n    [USING @var_name [, @var_name] ...]\n\nAfter preparing a statement with PREPARE, you execute it with an\nEXECUTE statement that refers to the prepared statement name. If the\nprepared statement contains any parameter markers, you must supply a\nUSING clause that lists user variables containing the values to be\nbound to the parameters. Parameter values can be supplied only by user\nvariables, and the USING clause must name exactly as many variables as\nthe number of parameter markers in the statement.\n\nYou can execute a given prepared statement multiple times, passing\ndifferent variables to it or setting the variables to different values\nbefore each execution.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/execute.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/execute.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (85,37,'DROP INDEX','Syntax:\nDROP [ONLINE|OFFLINE] INDEX index_name ON tbl_name\n\nDROP INDEX drops the index named index_name from the table tbl_name.\nThis statement is mapped to an ALTER TABLE statement to drop the index.\nSee [HELP ALTER TABLE].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-index.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-index.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (86,35,'MATCH AGAINST','Syntax:\nMATCH (col1,col2,...) AGAINST (expr [search_modifier])\n\nMySQL has support for full-text indexing and searching:\n\no A full-text index in MySQL is an index of type FULLTEXT.\n\no Full-text indexes can be used only with MyISAM tables, and can be\n  created only for CHAR, VARCHAR, or TEXT columns.\n\no A FULLTEXT index definition can be given in the CREATE TABLE\n  statement when a table is created, or added later using ALTER TABLE\n  or CREATE INDEX.\n\no For large data sets, it is much faster to load your data into a table\n  that has no FULLTEXT index and then create the index after that, than\n  to load data into a table that has an existing FULLTEXT index.\n\nFull-text searching is performed using MATCH() ... AGAINST syntax.\nMATCH() takes a comma-separated list that names the columns to be\nsearched. AGAINST takes a string to search for, and an optional\nmodifier that indicates what type of search to perform. The search\nstring must be a literal string, not a variable or a column name. There\nare three types of full-text searches:\n\no A boolean search interprets the search string using the rules of a\n  special query language. The string contains the words to search for.\n  It can also contain operators that specify requirements such that a\n  word must be present or absent in matching rows, or that it should be\n  weighted higher or lower than usual. Common words such as "some" or\n  "then" are stopwords and do not match if present in the search\n  string. The IN BOOLEAN MODE modifier specifies a boolean search. For\n  more information, see\n  http://dev.mysql.com/doc/refman/5.1/en/fulltext-boolean.html.\n\no A natural language search interprets the search string as a phrase in\n  natural human language (a phrase in free text). There are no special\n  operators. The stopword list applies. In addition, words that are\n  present in 50% or more of the rows are considered common and do not\n  match. Full-text searches are natural language searches if the IN\n  NATURAL LANGUAGE MODE modifier is given or if no modifier is given.\n\no A query expansion search is a modification of a natural language\n  search. The search string is used to perform a natural language\n  search. Then words from the most relevant rows returned by the search\n  are added to the search string and the search is done again. The\n  query returns the rows from the second search. The IN NATURAL\n  LANGUAGE MODE WITH QUERY EXPANSION or WITH QUERY EXPANSION modifier\n  specifies a query expansion search. For more information, see\n  http://dev.mysql.com/doc/refman/5.1/en/fulltext-query-expansion.html.\n\nThe IN NATURAL LANGUAGE MODE and IN NATURAL LANGUAGE MODE WITH QUERY\nEXPANSION modifiers were added in MySQL 5.1.7.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/fulltext-search.html\n\n','mysql> SELECT id, body, MATCH (title,body) AGAINST\n    -> (\'Security implications of running MySQL as root\'\n    -> IN NATURAL LANGUAGE MODE) AS score\n    -> FROM articles WHERE MATCH (title,body) AGAINST\n    -> (\'Security implications of running MySQL as root\'\n    -> IN NATURAL LANGUAGE MODE);\n+----+-------------------------------------+-----------------+\n| id | body                                | score           |\n+----+-------------------------------------+-----------------+\n|  4 | 1. Never run mysqld as root. 2. ... | 1.5219271183014 |\n|  6 | When configured properly, MySQL ... | 1.3114095926285 |\n+----+-------------------------------------+-----------------+\n2 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.1/en/fulltext-search.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (87,37,'CREATE EVENT','Syntax:\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    EVENT\n    [IF NOT EXISTS]\n    event_name\n    ON SCHEDULE schedule\n    [ON COMPLETION [NOT] PRESERVE]\n    [ENABLE | DISABLE | DISABLE ON SLAVE]\n    [COMMENT \'comment\']\n    DO sql_statement;\n\nschedule:\n    AT timestamp [+ INTERVAL interval] ...\n  | EVERY interval\n    [STARTS timestamp [+ INTERVAL interval] ...]\n    [ENDS timestamp [+ INTERVAL interval] ...]\n\ninterval:\n    quantity {YEAR | QUARTER | MONTH | DAY | HOUR | MINUTE |\n              WEEK | SECOND | YEAR_MONTH | DAY_HOUR | DAY_MINUTE |\n              DAY_SECOND | HOUR_MINUTE | HOUR_SECOND | MINUTE_SECOND}\n\nThis statement creates and schedules a new event. It requires the EVENT\nprivilege for the schema in which the event is to be created.\n\nThe minimum requirements for a valid CREATE EVENT statement are as\nfollows:\n\no The keywords CREATE EVENT plus an event name, which uniquely\n  identifies the event in the current schema. (Prior to MySQL 5.1.12,\n  the event name needed to be unique only among events created by the\n  same user on a given database.)\n\no An ON SCHEDULE clause, which determines when and how often the event\n  executes.\n\no A DO clause, which contains the SQL statement to be executed by an\n  event.\n\nThis is an example of a minimal CREATE EVENT statement:\n\nCREATE EVENT myevent\n    ON SCHEDULE AT CURRENT_TIMESTAMP + INTERVAL 1 HOUR\n    DO\n      UPDATE myschema.mytable SET mycol = mycol + 1;\n\nThe previous statement creates an event named myevent. This event\nexecutes once --- one hour following its creation --- by running an SQL\nstatement that increments the value of the myschema.mytable table\'s\nmycol column by 1.\n\nThe event_name must be a valid MySQL identifier with a maximum length\nof 64 characters. It may be delimited using back ticks, and may be\nqualified with the name of a database schema. An event is associated\nwith both a MySQL user (the definer) and a schema, and its name must be\nunique among names of events within that schema. In general, the rules\ngoverning event names are the same as those for names of stored\nroutines. See http://dev.mysql.com/doc/refman/5.1/en/identifiers.html.\n\nIf no schema is indicated as part of event_name, the default (current)\nschema is assumed.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-event.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-event.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (88,4,'ABS','Syntax:\nABS(X)\n\nReturns the absolute value of X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT ABS(2);\n        -> 2\nmysql> SELECT ABS(-32);\n        -> 32\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (89,31,'POLYFROMWKB','PolyFromWKB(wkb[,srid]), PolygonFromWKB(wkb[,srid])\n\nConstructs a POLYGON value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkb-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkb-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (90,35,'NOT LIKE','Syntax:\nexpr NOT LIKE pat [ESCAPE \'escape_char\']\n\nThis is the same as NOT (expr LIKE pat [ESCAPE \'escape_char\']).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-comparison-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-comparison-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (91,35,'SPACE','Syntax:\nSPACE(N)\n\nReturns a string consisting of N space characters.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT SPACE(6);\n        -> \'      \'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (92,6,'MBR DEFINITION','Its MBR (Minimum Bounding Rectangle), or Envelope. This is the bounding\ngeometry, formed by the minimum and maximum (X,Y) coordinates:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-class-geometry.html\n\n','((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n','http://dev.mysql.com/doc/refman/5.1/en/gis-class-geometry.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (93,23,'GEOMETRYCOLLECTION','GeometryCollection(g1,g2,...)\n\nConstructs a GeometryCollection.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-mysql-specific-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-mysql-specific-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (94,16,'MAX','Syntax:\nMAX([DISTINCT] expr)\n\nReturns the maximum value of expr. MAX() may take a string argument; in\nsuch cases, it returns the maximum string value. See\nhttp://dev.mysql.com/doc/refman/5.1/en/mysql-indexes.html. The DISTINCT\nkeyword can be used to find the maximum of the distinct values of expr,\nhowever, this produces the same result as omitting DISTINCT.\n\nMAX() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','mysql> SELECT student_name, MIN(test_score), MAX(test_score)\n    ->        FROM student\n    ->        GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (95,21,'CREATE FUNCTION UDF','Syntax:\nCREATE [AGGREGATE] FUNCTION function_name RETURNS {STRING|INTEGER|REAL|DECIMAL}\n    SONAME shared_library_name\n\nA user-defined function (UDF) is a way to extend MySQL with a new\nfunction that works like a native (built-in) MySQL function such as\nABS() or CONCAT().\n\nfunction_name is the name that should be used in SQL statements to\ninvoke the function. The RETURNS clause indicates the type of the\nfunction\'s return value. DECIMAL is a legal value after RETURNS, but\ncurrently DECIMAL functions return string values and should be written\nlike STRING functions.\n\nshared_library_name is the basename of the shared object file that\ncontains the code that implements the function. The file must be\nlocated in the plugin directory. This directory is given by the value\nof the plugin_dir system variable.\n\n*Note*: This is a change in MySQL 5.1. For earlier versions of MySQL,\nthe shared object can be located in any directory that is searched by\nyour system\'s dynamic linker.\n\nTo create a function, you must have the INSERT privilege for the mysql\ndatabase. This is necessary because CREATE FUNCTION adds a row to the\nmysql.func system table that records the function\'s name, type, and\nshared library name. If you do not have this table, you should run the\nmysql_upgrade command to create it. See\nhttp://dev.mysql.com/doc/refman/5.1/en/mysql-upgrade.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-function-udf.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-function-udf.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (96,4,'*','Syntax:\n*\n\nMultiplication:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html\n\n','mysql> SELECT 3*5;\n        -> 15\nmysql> SELECT 18014398509481984*18014398509481984.0;\n        -> 324518553658426726783156020576256.0\nmysql> SELECT 18014398509481984*18014398509481984;\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (97,20,'TIMESTAMP','TIMESTAMP\n\nA timestamp. The range is \'1970-01-01 00:00:01\' UTC to \'2038-01-19\n03:14:07\' UTC. TIMESTAMP values are stored as the number of seconds\nsince the epoch (\'1970-01-01 00:00:00\' UTC). A TIMESTAMP cannot\nrepresent the value \'1970-01-01 00:00:00\' because that is equivalent to\n0 seconds from the epoch and the value 0 is reserved for representing\n\'0000-00-00 00:00:00\', the "zero" TIMESTAMP value.\n\nA TIMESTAMP column is useful for recording the date and time of an\nINSERT or UPDATE operation. By default, the first TIMESTAMP column in a\ntable is automatically set to the date and time of the most recent\noperation if you do not assign it a value yourself. You can also set\nany TIMESTAMP column to the current date and time by assigning it a\nNULL value. Variations on automatic initialization and update\nproperties are described in\nhttp://dev.mysql.com/doc/refman/5.1/en/timestamp.html.\n\nA TIMESTAMP value is returned as a string in the format \'YYYY-MM-DD\nHH:MM:SS\' with a display width fixed at 19 characters. To obtain the\nvalue as a number, you should add +0 to the timestamp column.\n\n*Note*: The TIMESTAMP format that was used prior to MySQL 4.1 is not\nsupported in MySQL 5.1; see MySQL 3.23, 4.0, 4.1 Reference Manual for\ninformation regarding the old format.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (98,11,'DES_DECRYPT','Syntax:\nDES_DECRYPT(crypt_str[,key_str])\n\nDecrypts a string encrypted with DES_ENCRYPT(). If an error occurs,\nthis function returns NULL.\n\nThis function works only if MySQL has been configured with SSL support.\nSee http://dev.mysql.com/doc/refman/5.1/en/secure-connections.html.\n\nIf no key_str argument is given, DES_DECRYPT() examines the first byte\nof the encrypted string to determine the DES key number that was used\nto encrypt the original string, and then reads the key from the DES key\nfile to decrypt the message. For this to work, the user must have the\nSUPER privilege. The key file can be specified with the --des-key-file\nserver option.\n\nIf you pass this function a key_str argument, that string is used as\nthe key for decrypting the message.\n\nIf the crypt_str argument does not appear to be an encrypted string,\nMySQL returns the given crypt_str.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (99,25,'CACHE INDEX','Syntax:\nCACHE INDEX\n  tbl_index_list [, tbl_index_list] ...\n  IN key_cache_name\n\ntbl_index_list:\n  tbl_name [[INDEX|KEY] (index_name[, index_name] ...)]\n\nThe CACHE INDEX statement assigns table indexes to a specific key\ncache. It is used only for MyISAM tables.\n\nThe following statement assigns indexes from the tables t1, t2, and t3\nto the key cache named hot_cache:\n\nmysql> CACHE INDEX t1, t2, t3 IN hot_cache;\n+---------+--------------------+----------+----------+\n| Table   | Op                 | Msg_type | Msg_text |\n+---------+--------------------+----------+----------+\n| test.t1 | assign_to_keycache | status   | OK       |\n| test.t2 | assign_to_keycache | status   | OK       |\n| test.t3 | assign_to_keycache | status   | OK       |\n+---------+--------------------+----------+----------+\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/cache-index.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/cache-index.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (100,12,'ENDPOINT','EndPoint(ls)\n\nReturns the Point that is the endpoint of the LineString value ls.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#linestring-property-functions\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT AsText(EndPoint(GeomFromText(@ls)));\n+-------------------------------------+\n| AsText(EndPoint(GeomFromText(@ls))) |\n+-------------------------------------+\n| POINT(3 3)                          |\n+-------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#linestring-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (101,11,'COMPRESS','Syntax:\nCOMPRESS(string_to_compress)\n\nCompresses a string and returns the result as a binary string. This\nfunction requires MySQL to have been compiled with a compression\nlibrary such as zlib. Otherwise, the return value is always NULL. The\ncompressed string can be uncompressed with UNCOMPRESS().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','mysql> SELECT LENGTH(COMPRESS(REPEAT(\'a\',1000)));\n        -> 21\nmysql> SELECT LENGTH(COMPRESS(\'\'));\n        -> 0\nmysql> SELECT LENGTH(COMPRESS(\'a\'));\n        -> 13\nmysql> SELECT LENGTH(COMPRESS(REPEAT(\'a\',16)));\n        -> 15\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (102,26,'INSERT','Syntax:\nINSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name [(col_name,...)]\n    {VALUES | VALUE} ({expr | DEFAULT},...),(...),...\n    [ ON DUPLICATE KEY UPDATE\n      col_name=expr\n        [, col_name=expr] ... ]\n\nOr:\n\nINSERT [LOW_PRIORITY | DELAYED | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name\n    SET col_name={expr | DEFAULT}, ...\n    [ ON DUPLICATE KEY UPDATE\n      col_name=expr\n        [, col_name=expr] ... ]\n\nOr:\n\nINSERT [LOW_PRIORITY | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name [(col_name,...)]\n    SELECT ...\n    [ ON DUPLICATE KEY UPDATE\n      col_name=expr\n        [, col_name=expr] ... ]\n\nINSERT inserts new rows into an existing table. The INSERT ... VALUES\nand INSERT ... SET forms of the statement insert rows based on\nexplicitly specified values. The INSERT ... SELECT form inserts rows\nselected from another table or tables. INSERT ... SELECT is discussed\nfurther in [HELP INSERT SELECT].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/insert.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/insert.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (103,16,'COUNT','Syntax:\nCOUNT(expr)\n\nReturns a count of the number of non-NULL values of expr in the rows\nretrieved by a SELECT statement. The result is a BIGINT value.\n\nCOUNT() returns 0 if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','mysql> SELECT student.student_name,COUNT(*)\n    ->        FROM student,course\n    ->        WHERE student.student_id=course.student_id\n    ->        GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (104,26,'HANDLER','Syntax:\nHANDLER tbl_name OPEN [ [AS] alias]\nHANDLER tbl_name READ index_name { = | >= | <= | < } (value1,value2,...)\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name READ index_name { FIRST | NEXT | PREV | LAST }\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name READ { FIRST | NEXT }\n    [ WHERE where_condition ] [LIMIT ... ]\nHANDLER tbl_name CLOSE\n\nThe HANDLER statement provides direct access to table storage engine\ninterfaces. It is available for MyISAM and InnoDB tables.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/handler.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/handler.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (105,3,'MLINEFROMTEXT','MLineFromText(wkt[,srid]), MultiLineStringFromText(wkt[,srid])\n\nConstructs a MULTILINESTRING value using its WKT representation and\nSRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkt-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkt-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (106,31,'GEOMCOLLFROMWKB','GeomCollFromWKB(wkb[,srid]), GeometryCollectionFromWKB(wkb[,srid])\n\nConstructs a GEOMETRYCOLLECTION value using its WKB representation and\nSRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkb-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkb-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (107,37,'RENAME TABLE','Syntax:\nRENAME TABLE tbl_name TO new_tbl_name\n    [, tbl_name2 TO new_tbl_name2] ...\n\nThis statement renames one or more tables.\n\nThe rename operation is done atomically, which means that no other\nsession can access any of the tables while the rename is running. For\nexample, if you have an existing table old_table, you can create\nanother table new_table that has the same structure but is empty, and\nthen replace the existing table with the empty one as follows (assuming\nthat backup_table does not already exist):\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/rename-table.html\n\n','CREATE TABLE new_table (...);\nRENAME TABLE old_table TO backup_table, new_table TO old_table;\n','http://dev.mysql.com/doc/refman/5.1/en/rename-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (108,20,'BOOLEAN','BOOL, BOOLEAN\n\nThese types are synonyms for TINYINT(1). A value of zero is considered\nfalse. Nonzero values are considered true:\n\nmysql> SELECT IF(0, \'true\', \'false\');\n+------------------------+\n| IF(0, \'true\', \'false\') |\n+------------------------+\n| false                  |\n+------------------------+\n\nmysql> SELECT IF(1, \'true\', \'false\');\n+------------------------+\n| IF(1, \'true\', \'false\') |\n+------------------------+\n| true                   |\n+------------------------+\n\nmysql> SELECT IF(2, \'true\', \'false\');\n+------------------------+\n| IF(2, \'true\', \'false\') |\n+------------------------+\n| true                   |\n+------------------------+\n\nHowever, the values TRUE and FALSE are merely aliases for 1 and 0,\nrespectively, as shown here:\n\nmysql> SELECT IF(0 = FALSE, \'true\', \'false\');\n+--------------------------------+\n| IF(0 = FALSE, \'true\', \'false\') |\n+--------------------------------+\n| true                           |\n+--------------------------------+\n\nmysql> SELECT IF(1 = TRUE, \'true\', \'false\');\n+-------------------------------+\n| IF(1 = TRUE, \'true\', \'false\') |\n+-------------------------------+\n| true                          |\n+-------------------------------+\n\nmysql> SELECT IF(2 = TRUE, \'true\', \'false\');\n+-------------------------------+\n| IF(2 = TRUE, \'true\', \'false\') |\n+-------------------------------+\n| false                         |\n+-------------------------------+\n\nmysql> SELECT IF(2 = FALSE, \'true\', \'false\');\n+--------------------------------+\n| IF(2 = FALSE, \'true\', \'false\') |\n+--------------------------------+\n| false                          |\n+--------------------------------+\n\nThe last two statements display the results shown because 2 is equal to\nneither 1 nor 0.\n\nWe intend to implement full boolean type handling, in accordance with\nstandard SQL, in a future MySQL release.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (109,14,'DEFAULT','Syntax:\nDEFAULT(col_name)\n\nReturns the default value for a table column. An error results if the\ncolumn has no default value.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','mysql> UPDATE t SET i = DEFAULT(i)+1 WHERE id < 100;\n','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (110,4,'MOD','Syntax:\nMOD(N,M), N % M, N MOD M\n\nModulo operation. Returns the remainder of N divided by M.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT MOD(234, 10);\n        -> 4\nmysql> SELECT 253 % 7;\n        -> 1\nmysql> SELECT MOD(29,9);\n        -> 2\nmysql> SELECT 29 MOD 9;\n        -> 2\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (111,20,'TINYTEXT','TINYTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 255 (28 - 1) characters. The\neffective maximum length is less if the value contains multi-byte\ncharacters. Each TINYTEXT value is stored using a one-byte length\nprefix that indicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (112,19,'OPTIMIZE TABLE','Syntax:\nOPTIMIZE [NO_WRITE_TO_BINLOG | LOCAL] TABLE\n    tbl_name [, tbl_name] ...\n\nOPTIMIZE TABLE should be used if you have deleted a large part of a\ntable or if you have made many changes to a table with variable-length\nrows (tables that have VARCHAR, VARBINARY, BLOB, or TEXT columns).\nDeleted rows are maintained in a linked list and subsequent INSERT\noperations reuse old row positions. You can use OPTIMIZE TABLE to\nreclaim the unused space and to defragment the data file.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nBeginning with MySQL 5.1.27, OPTIMIZE TABLE is also supported for\npartitioned tables. Also beginning with MySQL 5.1.27, you can use ALTER\nTABLE ... OPTIMIZE PARTITION to optimize one or more partitions; for\nmore information, see [HELP ALTER TABLE], and\nhttp://dev.mysql.com/doc/refman/5.1/en/partitioning-maintenance.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/optimize-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/optimize-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (113,11,'DECODE','Syntax:\nDECODE(crypt_str,pass_str)\n\nDecrypts the encrypted string crypt_str using pass_str as the password.\ncrypt_str should be a string returned from ENCODE().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (114,17,'<=>','Syntax:\n<=>\n\nNULL-safe equal. This operator performs an equality comparison like the\n= operator, but returns 1 rather than NULL if both operands are NULL,\nand 0 rather than NULL if one operand is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 1 <=> 1, NULL <=> NULL, 1 <=> NULL;\n        -> 1, 1, 0\nmysql> SELECT 1 = 1, NULL = NULL, 1 = NULL;\n        -> 1, NULL, NULL\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (115,25,'LOAD DATA FROM MASTER','Syntax:\nLOAD DATA FROM MASTER\n\nThis feature is deprecated and should be avoided. It is subject to\nremoval in a future version of MySQL.\n\nSince the current implementation of LOAD DATA FROM MASTER and LOAD\nTABLE FROM MASTER is very limited, these statements are deprecated in\nversions 4.1 of MySQL and above. We will introduce a more advanced\ntechnique (called "online backup") in a future version. That technique\nwill have the additional advantage of working with more storage\nengines.\n\nFor MySQL 5.1 and earlier, the recommended alternative solution to\nusing LOAD DATA FROM MASTER or LOAD TABLE FROM MASTER is using\nmysqldump or mysqlhotcopy. The latter requires Perl and two Perl\nmodules (DBI and DBD:mysql) and works for MyISAM and ARCHIVE tables\nonly. With mysqldump, you can create SQL dumps on the master and pipe\n(or copy) these to a mysql client on the slave. This has the advantage\nof working for all storage engines, but can be quite slow, since it\nworks using SELECT.\n\nThis statement takes a snapshot of the master and copies it to the\nslave. It updates the values of MASTER_LOG_FILE and MASTER_LOG_POS so\nthat the slave starts replicating from the correct position. Any table\nand database exclusion rules specified with the --replicate-*-do-* and\n--replicate-*-ignore-* options are honored. --replicate-rewrite-db is\nnot taken into account because a user could use this option to set up a\nnonunique mapping such as --replicate-rewrite-db="db1->db3" and\n--replicate-rewrite-db="db2->db3", which would confuse the slave when\nloading tables from the master.\n\nUse of this statement is subject to the following conditions:\n\no It works only for MyISAM tables. Attempting to load a non-MyISAM\n  table results in the following error:\n\nERROR 1189 (08S01): Net error reading from master\n\no It acquires a global read lock on the master while taking the\n  snapshot, which prevents updates on the master during the load\n  operation.\n\nIf you are loading large tables, you might have to increase the values\nof net_read_timeout and net_write_timeout on both the master and slave\nservers. See\nhttp://dev.mysql.com/doc/refman/5.1/en/server-system-variables.html.\n\nNote that LOAD DATA FROM MASTER does not copy any tables from the mysql\ndatabase. This makes it easy to have different users and privileges on\nthe master and the slave.\n\nTo use LOAD DATA FROM MASTER, the replication account that is used to\nconnect to the master must have the RELOAD and SUPER privileges on the\nmaster and the SELECT privilege for all master tables you want to load.\nAll master tables for which the user does not have the SELECT privilege\nare ignored by LOAD DATA FROM MASTER. This is because the master hides\nthem from the user: LOAD DATA FROM MASTER calls SHOW DATABASES to know\nthe master databases to load, but SHOW DATABASES returns only databases\nfor which the user has some privilege. See [HELP SHOW DATABASES]. On\nthe slave side, the user that issues LOAD DATA FROM MASTER must have\nprivileges for dropping and creating the databases and tables that are\ncopied.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/load-data-from-master.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/load-data-from-master.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (116,25,'RESET','Syntax:\nRESET reset_option [, reset_option] ...\n\nThe RESET statement is used to clear the state of various server\noperations. You must have the RELOAD privilege to execute RESET.\n\nRESET acts as a stronger version of the FLUSH statement. See [HELP\nFLUSH].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/reset.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/reset.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (117,27,'HELP STATEMENT','Syntax:\nHELP \'search_string\'\n\nThe HELP statement returns online information from the MySQL Reference\nmanual. Its proper operation requires that the help tables in the mysql\ndatabase be initialized with help topic information (see\nhttp://dev.mysql.com/doc/refman/5.1/en/server-side-help-support.html).\n\nThe HELP statement searches the help tables for the given search string\nand displays the result of the search. The search string is not case\nsensitive.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/help.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/help.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (118,14,'GET_LOCK','Syntax:\nGET_LOCK(str,timeout)\n\nTries to obtain a lock with a name given by the string str, using a\ntimeout of timeout seconds. Returns 1 if the lock was obtained\nsuccessfully, 0 if the attempt timed out (for example, because another\nclient has previously locked the name), or NULL if an error occurred\n(such as running out of memory or the thread was killed with mysqladmin\nkill). If you have a lock obtained with GET_LOCK(), it is released when\nyou execute RELEASE_LOCK(), execute a new GET_LOCK(), or your\nconnection terminates (either normally or abnormally). Locks obtained\nwith GET_LOCK() do not interact with transactions. That is, committing\na transaction does not release any such locks obtained during the\ntransaction.\n\nThis function can be used to implement application locks or to simulate\nrecord locks. Names are locked on a server-wide basis. If a name has\nbeen locked by one client, GET_LOCK() blocks any request by another\nclient for a lock with the same name. This allows clients that agree on\na given lock name to use the name to perform cooperative advisory\nlocking. But be aware that it also allows a client that is not among\nthe set of cooperating clients to lock a name, either inadvertently or\ndeliberately, and thus prevent any of the cooperating clients from\nlocking that name. One way to reduce the likelihood of this is to use\nlock names that are database-specific or application-specific. For\nexample, use lock names of the form db_name.str or app_name.str.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','mysql> SELECT GET_LOCK(\'lock1\',10);\n        -> 1\nmysql> SELECT IS_FREE_LOCK(\'lock2\');\n        -> 1\nmysql> SELECT GET_LOCK(\'lock2\',10);\n        -> 1\nmysql> SELECT RELEASE_LOCK(\'lock2\');\n        -> 1\nmysql> SELECT RELEASE_LOCK(\'lock1\');\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (119,35,'UCASE','Syntax:\nUCASE(str)\n\nUCASE() is a synonym for UPPER().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (120,25,'SHOW BINLOG EVENTS','Syntax:\nSHOW BINLOG EVENTS\n   [IN \'log_name\'] [FROM pos] [LIMIT [offset,] row_count]\n\nShows the events in the binary log. If you do not specify \'log_name\',\nthe first binary log is displayed.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-binlog-events.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-binlog-events.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (121,31,'MPOLYFROMWKB','MPolyFromWKB(wkb[,srid]), MultiPolygonFromWKB(wkb[,srid])\n\nConstructs a MULTIPOLYGON value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkb-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkb-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (122,22,'ITERATE','Syntax:\nITERATE label\n\nITERATE can appear only within LOOP, REPEAT, and WHILE statements.\nITERATE means "do the loop again."\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/iterate-statement.html\n\n','CREATE PROCEDURE doiterate(p1 INT)\nBEGIN\n  label1: LOOP\n    SET p1 = p1 + 1;\n    IF p1 < 10 THEN ITERATE label1; END IF;\n    LEAVE label1;\n  END LOOP label1;\n  SET @x = p1;\nEND\n','http://dev.mysql.com/doc/refman/5.1/en/iterate-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (123,26,'DO','Syntax:\nDO expr [, expr] ...\n\nDO executes the expressions but does not return any results. In most\nrespects, DO is shorthand for SELECT expr, ..., but has the advantage\nthat it is slightly faster when you do not care about the result.\n\nDO is useful primarily with functions that have side effects, such as\nRELEASE_LOCK().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/do.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/do.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (124,30,'CURTIME','Syntax:\nCURTIME()\n\nReturns the current time as a value in \'HH:MM:SS\' or HHMMSS.uuuuuu\nformat, depending on whether the function is used in a string or\nnumeric context. The value is expressed in the current time zone.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT CURTIME();\n        -> \'23:50:26\'\nmysql> SELECT CURTIME() + 0;\n        -> 235026.000000\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (125,35,'CHAR_LENGTH','Syntax:\nCHAR_LENGTH(str)\n\nReturns the length of the string str, measured in characters. A\nmulti-byte character counts as a single character. This means that for\na string containing five two-byte characters, LENGTH() returns 10,\nwhereas CHAR_LENGTH() returns 5.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (126,20,'BIGINT','BIGINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA large integer. The signed range is -9223372036854775808 to\n9223372036854775807. The unsigned range is 0 to 18446744073709551615.\n\nSERIAL is an alias for BIGINT UNSIGNED NOT NULL AUTO_INCREMENT UNIQUE.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (127,25,'SET','Syntax:\nSET variable_assignment [, variable_assignment] ...\n\nvariable_assignment:\n      user_var_name = expr\n    | [GLOBAL | SESSION] system_var_name = expr\n    | [@@global. | @@session. | @@]system_var_name = expr\n\nThe SET statement assigns values to different types of variables that\naffect the operation of the server or your client. Older versions of\nMySQL employed SET OPTION, but this syntax is deprecated in favor of\nSET without OPTION.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/set-option.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/set-option.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (128,4,'CONV','Syntax:\nCONV(N,from_base,to_base)\n\nConverts numbers between different number bases. Returns a string\nrepresentation of the number N, converted from base from_base to base\nto_base. Returns NULL if any argument is NULL. The argument N is\ninterpreted as an integer, but may be specified as an integer or a\nstring. The minimum base is 2 and the maximum base is 36. If to_base is\na negative number, N is regarded as a signed number. Otherwise, N is\ntreated as unsigned. CONV() works with 64-bit precision.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT CONV(\'a\',16,2);\n        -> \'1010\'\nmysql> SELECT CONV(\'6E\',18,8);\n        -> \'172\'\nmysql> SELECT CONV(-17,10,-18);\n        -> \'-H\'\nmysql> SELECT CONV(10+\'10\'+\'10\'+0xa,10,10);\n        -> \'40\'\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (129,20,'DATE','DATE\n\nA date. The supported range is \'1000-01-01\' to \'9999-12-31\'. MySQL\ndisplays DATE values in \'YYYY-MM-DD\' format, but allows assignment of\nvalues to DATE columns using either strings or numbers.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (130,25,'SHOW OPEN TABLES','Syntax:\nSHOW OPEN TABLES [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW OPEN TABLES lists the non-TEMPORARY tables that are currently open\nin the table cache. See\nhttp://dev.mysql.com/doc/refman/5.1/en/table-cache.html. The WHERE\nclause can be given to select rows using more general conditions, as\ndiscussed in http://dev.mysql.com/doc/refman/5.1/en/extended-show.html.\n\nThe FROM and LIKE clauses may be used beginning with MySQL 5.1.24. The\nLIKE clause, if present, indicates which table names to match. The FROM\nclause, if present, restricts the tables shown to those present in the\ndb_name database.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-open-tables.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-open-tables.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (131,30,'EXTRACT','Syntax:\nEXTRACT(unit FROM date)\n\nThe EXTRACT() function uses the same kinds of unit specifiers as\nDATE_ADD() or DATE_SUB(), but extracts parts from the date rather than\nperforming date arithmetic.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT EXTRACT(YEAR FROM \'2009-07-02\');\n       -> 2009\nmysql> SELECT EXTRACT(YEAR_MONTH FROM \'2009-07-02 01:02:03\');\n       -> 200907\nmysql> SELECT EXTRACT(DAY_MINUTE FROM \'2009-07-02 01:02:03\');\n       -> 20102\nmysql> SELECT EXTRACT(MICROSECOND\n    ->                FROM \'2003-01-02 10:30:00.000123\');\n        -> 123\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (132,11,'ENCRYPT','Syntax:\nENCRYPT(str[,salt])\n\nEncrypts str using the Unix crypt() system call and returns a binary\nstring. The salt argument should be a string with at least two\ncharacters. If no salt argument is given, a random value is used.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','mysql> SELECT ENCRYPT(\'hello\');\n        -> \'VxuFAJXVARROc\'\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (133,25,'SHOW STATUS','Syntax:\nSHOW [GLOBAL | SESSION] STATUS\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW STATUS provides server status information. This information also\ncan be obtained using the mysqladmin extended-status command. The LIKE\nclause, if present, indicates which variable names to match. The WHERE\nclause can be given to select rows using more general conditions, as\ndiscussed in http://dev.mysql.com/doc/refman/5.1/en/extended-show.html.\nThis statement does not require any privilege. It requires only the\nability to connect to the server.\nWith a LIKE clause, the statement displays only rows for those\nvariables with names that match the pattern:\n\nmysql> SHOW STATUS LIKE \'Key%\';\n+--------------------+----------+\n| Variable_name      | Value    |\n+--------------------+----------+\n| Key_blocks_used    | 14955    |\n| Key_read_requests  | 96854827 |\n| Key_reads          | 162040   |\n| Key_write_requests | 7589728  |\n| Key_writes         | 3813196  |\n+--------------------+----------+\n\nWith the GLOBAL modifier, SHOW STATUS displays the status values for\nall connections to MySQL. With SESSION, it displays the status values\nfor the current connection. If no modifier is present, the default is\nSESSION. LOCAL is a synonym for SESSION.\n\nSome status variables have only a global value. For these, you get the\nsame value for both GLOBAL and SESSION. The scope for each status\nvariable is listed at\nhttp://dev.mysql.com/doc/refman/5.1/en/server-status-variables.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-status.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-status.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (134,35,'EXTRACTVALUE','Syntax:\nExtractValue(xml_frag, xpath_expr)\n\nExtractValue() takes two string arguments, a fragment of XML markup\nxml_frag and an XPath expression xpath_expr (also known as a locator);\nit returns the text (CDATA) of the first text node which is a child of\nthe element(s) matched by the XPath expression. It is the equivalent of\nperforming a match using the xpath_expr after appending /text(). In\nother words, ExtractValue(\'<a><b>Sakila</b></a>\', \'/a/b\') and\nExtractValue(\'<a><b>Sakila</b></a>\', \'/a/b/text()\') produce the same\nresult.\n\nIf multiple matches are found, then the content of the first child text\nnode of each matching element is returned (in the order matched) as a\nsingle, space-delimited string.\n\nIf no matching text node is found for the expression (including the\nimplicit /text()) --- for whatever reason, as long as xpath_expr is\nvalid, and xml_frag consists of elements which are properly nested and\nclosed --- an empty string is returned. No distinction is made between\na match on an empty element and no match at all. This is by design.\n\nIf you need to determine whether no matching element was found in\nxml_frag or such an element was found but contained no child text\nnodes, you should test the result of an expression that uses the XPath\ncount() function. For example, both of these statements return an empty\nstring, as shown here:\n\nmysql> SELECT ExtractValue(\'<a><b/></a>\', \'/a/b\');\n+-------------------------------------+\n| ExtractValue(\'<a><b/></a>\', \'/a/b\') |\n+-------------------------------------+\n|                                     |\n+-------------------------------------+\n1 row in set (0.00 sec)\n\nmysql> SELECT ExtractValue(\'<a><c/></a>\', \'/a/b\');\n+-------------------------------------+\n| ExtractValue(\'<a><c/></a>\', \'/a/b\') |\n+-------------------------------------+\n|                                     |\n+-------------------------------------+\n1 row in set (0.00 sec)\n\nHowever, you can determine whether there was actually a matching\nelement using the following:\n\nmysql> SELECT ExtractValue(\'<a><b/></a>\', \'count(/a/b)\');\n+-------------------------------------+\n| ExtractValue(\'<a><b/></a>\', \'count(/a/b)\') |\n+-------------------------------------+\n| 1                                   |\n+-------------------------------------+\n1 row in set (0.00 sec)\n\nmysql> SELECT ExtractValue(\'<a><c/></a>\', \'count(/a/b)\');\n+-------------------------------------+\n| ExtractValue(\'<a><c/></a>\', \'count(/a/b)\') |\n+-------------------------------------+\n| 0                                   |\n+-------------------------------------+\n1 row in set (0.01 sec)\n\n*Important*: ExtractValue() returns only CDATA, and does not return any\ntags that might be contained within a matching tag, nor any of their\ncontent (see the result returned as val1 in the following example).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/xml-functions.html\n\n','mysql> SELECT\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'/a\') AS val1,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'/a/b\') AS val2,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'//b\') AS val3,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b></a>\', \'/b\') AS val4,\n    ->   ExtractValue(\'<a>ccc<b>ddd</b><b>eee</b></a>\', \'//b\') AS val5;\n\n+------+------+------+------+---------+\n| val1 | val2 | val3 | val4 | val5    |\n+------+------+------+------+---------+\n| ccc  | ddd  | ddd  |      | ddd eee |\n+------+------+------+------+---------+\n','http://dev.mysql.com/doc/refman/5.1/en/xml-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (135,11,'OLD_PASSWORD','Syntax:\nOLD_PASSWORD(str)\n\nOLD_PASSWORD() was added to MySQL when the implementation of PASSWORD()\nwas changed to improve security. OLD_PASSWORD() returns the value of\nthe old (pre-4.1) implementation of PASSWORD() as a binary string, and\nis intended to permit you to reset passwords for any pre-4.1 clients\nthat need to connect to your version 5.1 MySQL server without locking\nthem out. See\nhttp://dev.mysql.com/doc/refman/5.1/en/password-hashing.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (136,22,'SET VARIABLE','Syntax:\nSET var_name = expr [, var_name = expr] ...\n\nThe SET statement in stored programs is an extended version of the\ngeneral SET statement (see [HELP SET]). Referenced variables may be\nones declared inside a stored program, global system variables, or\nuser-defined variables.\n\nThe SET statement in stored programs is implemented as part of the\npre-existing SET syntax. This allows an extended syntax of SET a=x,\nb=y, ... where different variable types (locally declared variables,\nglobal and session server variables, user-defined variables) can be\nmixed. This also allows combinations of local variables and some\noptions that make sense only for system variables; in that case, the\noptions are recognized but ignored.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/set-statement.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/set-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (137,35,'FORMAT','Syntax:\nFORMAT(X,D)\n\nFormats the number X to a format like \'#,###,###.##\', rounded to D\ndecimal places, and returns the result as a string. If D is 0, the\nresult has no decimal point or fractional part.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT FORMAT(12332.123456, 4);\n        -> \'12,332.1235\'\nmysql> SELECT FORMAT(12332.1,4);\n        -> \'12,332.1000\'\nmysql> SELECT FORMAT(12332.2,0);\n        -> \'12,332\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (138,13,'||','Syntax:\nOR, ||\n\nLogical OR. When both operands are non-NULL, the result is 1 if any\noperand is nonzero, and 0 otherwise. With a NULL operand, the result is\n1 if the other operand is nonzero, and NULL otherwise. If both operands\nare NULL, the result is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/logical-operators.html\n\n','mysql> SELECT 1 || 1;\n        -> 1\nmysql> SELECT 1 || 0;\n        -> 1\nmysql> SELECT 0 || 0;\n        -> 0\nmysql> SELECT 0 || NULL;\n        -> NULL\nmysql> SELECT 1 || NULL;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/logical-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (139,35,'BIT_LENGTH','Syntax:\nBIT_LENGTH(str)\n\nReturns the length of the string str in bits.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT BIT_LENGTH(\'text\');\n        -> 32\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (140,2,'EXTERIORRING','ExteriorRing(poly)\n\nReturns the exterior ring of the Polygon value poly as a LineString.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#polygon-property-functions\n\n','mysql> SET @poly =\n    -> \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT AsText(ExteriorRing(GeomFromText(@poly)));\n+-------------------------------------------+\n| AsText(ExteriorRing(GeomFromText(@poly))) |\n+-------------------------------------------+\n| LINESTRING(0 0,0 3,3 3,3 0,0 0)           |\n+-------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#polygon-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (141,31,'GEOMFROMWKB','GeomFromWKB(wkb[,srid]), GeometryFromWKB(wkb[,srid])\n\nConstructs a geometry value of any type using its WKB representation\nand SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkb-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkb-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (142,25,'SHOW SLAVE HOSTS','Syntax:\nSHOW SLAVE HOSTS\n\nDisplays a list of replication slaves currently registered with the\nmaster. Only slaves started with the --report-host=host_name option are\nvisible in this list.\n\nThe list is displayed on any server (not just the master server). The\noutput looks like this:\n\nmysql> SHOW SLAVE HOSTS;\n+------------+-----------+------+-----------+\n| Server_id  | Host      | Port | Master_id |\n+------------+-----------+------+-----------+\n|  192168010 | iconnect2 | 3306 | 192168011 |\n| 1921680101 | athena    | 3306 | 192168011 |\n+------------+-----------+------+-----------+\n\no Server_id: The unique server ID of the slave server, as configured in\n  the server\'s option file, or on the command line with\n  --server-id=value.\n\no Host: The host name of the slave server, as configured in the\n  server\'s option file, or on the command line with\n  --report-host=host_name. Note that this can differ from the machine\n  name as configured in the operating system.\n\no Port: The port the slave server is listening on.\n\no Master_id: The unique server ID of the master server that the slave\n  server is replicating from.\n\nSome MySQL versions report another variable, Rpl_recovery_rank. This\nvariable was never used, and was eventually removed.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-slave-hosts.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-slave-hosts.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (143,8,'START TRANSACTION','Syntax:\nSTART TRANSACTION [WITH CONSISTENT SNAPSHOT] | BEGIN [WORK]\nCOMMIT [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nROLLBACK [WORK] [AND [NO] CHAIN] [[NO] RELEASE]\nSET autocommit = {0 | 1}\n\nThe START TRANSACTION or BEGIN statement begins a new transaction.\nCOMMIT commits the current transaction, making its changes permanent.\nROLLBACK rolls back the current transaction, canceling its changes. The\nSET autocommit statement disables or enables the default autocommit\nmode for the current session.\n\nThe optional WORK keyword is supported for COMMIT and ROLLBACK, as are\nthe CHAIN and RELEASE clauses. CHAIN and RELEASE can be used for\nadditional control over transaction completion. The value of the\ncompletion_type system variable determines the default completion\nbehavior. See\nhttp://dev.mysql.com/doc/refman/5.1/en/server-system-variables.html.\n\n*Note*: Within all stored programs (stored procedures and functions,\ntriggers, and events), the parser treats BEGIN [WORK] as the beginning\nof a BEGIN ... END block. Begin a transaction in this context with\nSTART TRANSACTION instead.\n\nThe AND CHAIN clause causes a new transaction to begin as soon as the\ncurrent one ends, and the new transaction has the same isolation level\nas the just-terminated transaction. The RELEASE clause causes the\nserver to disconnect the current client session after terminating the\ncurrent transaction. Including the NO keyword suppresses CHAIN or\nRELEASE completion, which can be useful if the completion_type system\nvariable is set to cause chaining or release completion by default.\n\nBy default, MySQL runs with autocommit mode enabled. This means that as\nsoon as you execute a statement that updates (modifies) a table, MySQL\nstores the update on disk to make it permanent. To disable autocommit\nmode, use the following statement:\n\nSET autocommit=0;\n\nAfter disabling autocommit mode by setting the autocommit variable to\nzero, changes to transaction-safe tables (such as those for InnoDB or\nNDBCLUSTER) are not made permanent immediately. You must use COMMIT to\nstore your changes to disk or ROLLBACK to ignore the changes.\n\nTo disable autocommit mode for a single series of statements, use the\nSTART TRANSACTION statement:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/commit.html\n\n','START TRANSACTION;\nSELECT @A:=SUM(salary) FROM table1 WHERE type=1;\nUPDATE table2 SET summary=@A WHERE type=1;\nCOMMIT;\n','http://dev.mysql.com/doc/refman/5.1/en/commit.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (144,17,'BETWEEN AND','Syntax:\nexpr BETWEEN min AND max\n\nIf expr is greater than or equal to min and expr is less than or equal\nto max, BETWEEN returns 1, otherwise it returns 0. This is equivalent\nto the expression (min <= expr AND expr <= max) if all the arguments\nare of the same type. Otherwise type conversion takes place according\nto the rules described in\nhttp://dev.mysql.com/doc/refman/5.1/en/type-conversion.html, but\napplied to all the three arguments.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 2 BETWEEN 1 AND 3, 2 BETWEEN 3 and 1;\n        -> 1, 0\nmysql> SELECT 1 BETWEEN 2 AND 3;\n        -> 0\nmysql> SELECT \'b\' BETWEEN \'a\' AND \'c\';\n        -> 1\nmysql> SELECT 2 BETWEEN 2 AND \'3\';\n        -> 1\nmysql> SELECT 2 BETWEEN 2 AND \'x-3\';\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (145,23,'MULTIPOLYGON','MultiPolygon(poly1,poly2,...)\n\nConstructs a MultiPolygon value from a set of Polygon or WKB Polygon\narguments.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-mysql-specific-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-mysql-specific-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (146,30,'TIME_FORMAT','Syntax:\nTIME_FORMAT(time,format)\n\nThis is used like the DATE_FORMAT() function, but the format string may\ncontain format specifiers only for hours, minutes, seconds, and\nmicroseconds. Other specifiers produce a NULL value or 0.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT TIME_FORMAT(\'100:00:00\', \'%H %k %h %I %l\');\n        -> \'100 100 04 04 4\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (147,35,'LEFT','Syntax:\nLEFT(str,len)\n\nReturns the leftmost len characters from the string str, or NULL if any\nargument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT LEFT(\'foobarbar\', 5);\n        -> \'fooba\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (148,25,'FLUSH QUERY CACHE','You can defragment the query cache to better utilize its memory with\nthe FLUSH QUERY CACHE statement. The statement does not remove any\nqueries from the cache.\n\nThe RESET QUERY CACHE statement removes all query results from the\nquery cache. The FLUSH TABLES statement also does this.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/query-cache-status-and-maintenance.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/query-cache-status-and-maintenance.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (149,20,'SET DATA TYPE','SET(\'value1\',\'value2\',...) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nA set. A string object that can have zero or more values, each of which\nmust be chosen from the list of values \'value1\', \'value2\', ... A SET\ncolumn can have a maximum of 64 members. SET values are represented\ninternally as integers.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (150,4,'RAND','Syntax:\nRAND(), RAND(N)\n\nReturns a random floating-point value v in the range 0 <= v < 1.0. If a\nconstant integer argument N is specified, it is used as the seed value,\nwhich produces a repeatable sequence of column values. In the following\nexample, note that the sequences of values produced by RAND(3) is the\nsame both places where it occurs.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> CREATE TABLE t (i INT);\nQuery OK, 0 rows affected (0.42 sec)\n\nmysql> INSERT INTO t VALUES(1),(2),(3);\nQuery OK, 3 rows affected (0.00 sec)\nRecords: 3  Duplicates: 0  Warnings: 0\n\nmysql> SELECT i, RAND() FROM t;\n+------+------------------+\n| i    | RAND()           |\n+------+------------------+\n|    1 | 0.61914388706828 |\n|    2 | 0.93845168309142 |\n|    3 | 0.83482678498591 |\n+------+------------------+\n3 rows in set (0.00 sec)\n\nmysql> SELECT i, RAND(3) FROM t;\n+------+------------------+\n| i    | RAND(3)          |\n+------+------------------+\n|    1 | 0.90576975597606 |\n|    2 | 0.37307905813035 |\n|    3 | 0.14808605345719 |\n+------+------------------+\n3 rows in set (0.00 sec)\n\nmysql> SELECT i, RAND() FROM t;\n+------+------------------+\n| i    | RAND()           |\n+------+------------------+\n|    1 | 0.35877890638893 |\n|    2 | 0.28941420772058 |\n|    3 | 0.37073435016976 |\n+------+------------------+\n3 rows in set (0.00 sec)\n\nmysql> SELECT i, RAND(3) FROM t;\n+------+------------------+\n| i    | RAND(3)          |\n+------+------------------+\n|    1 | 0.90576975597606 |\n|    2 | 0.37307905813035 |\n|    3 | 0.14808605345719 |\n+------+------------------+\n3 rows in set (0.01 sec)\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (151,35,'RPAD','Syntax:\nRPAD(str,len,padstr)\n\nReturns the string str, right-padded with the string padstr to a length\nof len characters. If str is longer than len, the return value is\nshortened to len characters.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT RPAD(\'hi\',5,\'?\');\n        -> \'hi???\'\nmysql> SELECT RPAD(\'hi\',1,\'?\');\n        -> \'h\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (152,37,'CREATE DATABASE','Syntax:\nCREATE {DATABASE | SCHEMA} [IF NOT EXISTS] db_name\n    [create_specification] ...\n\ncreate_specification:\n    [DEFAULT] CHARACTER SET [=] charset_name\n  | [DEFAULT] COLLATE [=] collation_name\n\nCREATE DATABASE creates a database with the given name. To use this\nstatement, you need the CREATE privilege for the database. CREATE\nSCHEMA is a synonym for CREATE DATABASE.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-database.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-database.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (153,20,'DEC','DEC[(M[,D])] [UNSIGNED] [ZEROFILL], NUMERIC[(M[,D])] [UNSIGNED]\n[ZEROFILL], FIXED[(M[,D])] [UNSIGNED] [ZEROFILL]\n\nThese types are synonyms for DECIMAL. The FIXED synonym is available\nfor compatibility with other database systems.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (154,16,'VAR_POP','Syntax:\nVAR_POP(expr)\n\nReturns the population standard variance of expr. It considers rows as\nthe whole population, not as a sample, so it has the number of rows as\nthe denominator. You can also use VARIANCE(), which is equivalent but\nis not standard SQL.\n\nVAR_POP() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (155,35,'ELT','Syntax:\nELT(N,str1,str2,str3,...)\n\nReturns str1 if N = 1, str2 if N = 2, and so on. Returns NULL if N is\nless than 1 or greater than the number of arguments. ELT() is the\ncomplement of FIELD().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT ELT(1, \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> \'ej\'\nmysql> SELECT ELT(4, \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> \'foo\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (156,37,'ALTER VIEW','Syntax:\nALTER\n    [ALGORITHM = {UNDEFINED | MERGE | TEMPTABLE}]\n    [DEFINER = { user | CURRENT_USER }]\n    [SQL SECURITY { DEFINER | INVOKER }]\n    VIEW view_name [(column_list)]\n    AS select_statement\n    [WITH [CASCADED | LOCAL] CHECK OPTION]\n\nThis statement changes the definition of a view, which must exist. The\nsyntax is similar to that for CREATE VIEW and the effect is the same as\nfor CREATE OR REPLACE VIEW. See [HELP CREATE VIEW]. This statement\nrequires the CREATE VIEW and DROP privileges for the view, and some\nprivilege for each column referred to in the SELECT statement. As of\nMySQL 5.1.23, ALTER VIEW is allowed only to the definer or users with\nthe SUPER privilege.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/alter-view.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/alter-view.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (157,25,'SHOW DATABASES','Syntax:\nSHOW {DATABASES | SCHEMAS}\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW DATABASES lists the databases on the MySQL server host. SHOW\nSCHEMAS is a synonym for SHOW DATABASES. The LIKE clause, if present,\nindicates which database names to match. The WHERE clause can be given\nto select rows using more general conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.1/en/extended-show.html.\n\nYou see only those databases for which you have some kind of privilege,\nunless you have the global SHOW DATABASES privilege. You can also get\nthis list using the mysqlshow command.\n\nIf the server was started with the --skip-show-database option, you\ncannot use this statement at all unless you have the SHOW DATABASES\nprivilege.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-databases.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-databases.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (158,18,'~','Syntax:\n~\n\nInvert all bits.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html\n\n','mysql> SELECT 5 & ~1;\n        -> 4\n','http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (159,20,'TEXT','TEXT[(M)] [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 65,535 (216 - 1) characters. The\neffective maximum length is less if the value contains multi-byte\ncharacters. Each TEXT value is stored using a two-byte length prefix\nthat indicates the number of bytes in the value.\n\nAn optional length M can be given for this type. If this is done, MySQL\ncreates the column as the smallest TEXT type large enough to hold\nvalues M characters long.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (160,35,'CONCAT_WS','Syntax:\nCONCAT_WS(separator,str1,str2,...)\n\nCONCAT_WS() stands for Concatenate With Separator and is a special form\nof CONCAT(). The first argument is the separator for the rest of the\narguments. The separator is added between the strings to be\nconcatenated. The separator can be a string, as can the rest of the\narguments. If the separator is NULL, the result is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT CONCAT_WS(\',\',\'First name\',\'Second name\',\'Last Name\');\n        -> \'First name,Second name,Last Name\'\nmysql> SELECT CONCAT_WS(\',\',\'First name\',NULL,\'Last Name\');\n        -> \'First name,Last Name\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (161,15,'ROW_COUNT','Syntax:\nROW_COUNT()\n\nROW_COUNT() returns the number of rows updated, inserted, or deleted by\nthe preceding statement. This is the same as the row count that the\nmysql client displays and the value from the mysql_affected_rows() C\nAPI function.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> INSERT INTO t VALUES(1),(2),(3);\nQuery OK, 3 rows affected (0.00 sec)\nRecords: 3  Duplicates: 0  Warnings: 0\n\nmysql> SELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           3 |\n+-------------+\n1 row in set (0.00 sec)\n\nmysql> DELETE FROM t WHERE i IN(1,2);\nQuery OK, 2 rows affected (0.00 sec)\n\nmysql> SELECT ROW_COUNT();\n+-------------+\n| ROW_COUNT() |\n+-------------+\n|           2 |\n+-------------+\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (162,4,'ASIN','Syntax:\nASIN(X)\n\nReturns the arc sine of X, that is, the value whose sine is X. Returns\nNULL if X is not in the range -1 to 1.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT ASIN(0.2);\n        -> 0.20135792079033\nmysql> SELECT ASIN(\'foo\');\n\n+-------------+\n| ASIN(\'foo\') |\n+-------------+\n|           0 |\n+-------------+\n1 row in set, 1 warning (0.00 sec)\n\nmysql> SHOW WARNINGS;\n+---------+------+-----------------------------------------+\n| Level   | Code | Message                                 |\n+---------+------+-----------------------------------------+\n| Warning | 1292 | Truncated incorrect DOUBLE value: \'foo\' |\n+---------+------+-----------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (163,4,'SIGN','Syntax:\nSIGN(X)\n\nReturns the sign of the argument as -1, 0, or 1, depending on whether X\nis negative, zero, or positive.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT SIGN(-32);\n        -> -1\nmysql> SELECT SIGN(0);\n        -> 0\nmysql> SELECT SIGN(234);\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (164,30,'SEC_TO_TIME','Syntax:\nSEC_TO_TIME(seconds)\n\nReturns the seconds argument, converted to hours, minutes, and seconds,\nas a TIME value. The range of the result is constrained to that of the\nTIME data type. A warning occurs if the argument corresponds to a value\noutside that range.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT SEC_TO_TIME(2378);\n        -> \'00:39:38\'\nmysql> SELECT SEC_TO_TIME(2378) + 0;\n        -> 3938\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (165,20,'FLOAT','FLOAT[(M,D)] [UNSIGNED] [ZEROFILL]\n\nA small (single-precision) floating-point number. Allowable values are\n-3.402823466E+38 to -1.175494351E-38, 0, and 1.175494351E-38 to\n3.402823466E+38. These are the theoretical limits, based on the IEEE\nstandard. The actual range might be slightly smaller depending on your\nhardware or operating system.\n\nM is the total number of digits and D is the number of digits following\nthe decimal point. If M and D are omitted, values are stored to the\nlimits allowed by the hardware. A single-precision floating-point\nnumber is accurate to approximately 7 decimal places.\n\nUNSIGNED, if specified, disallows negative values.\n\nUsing FLOAT might give you some unexpected problems because all\ncalculations in MySQL are done with double precision. See\nhttp://dev.mysql.com/doc/refman/5.1/en/no-matching-rows.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (166,35,'LOCATE','Syntax:\nLOCATE(substr,str), LOCATE(substr,str,pos)\n\nThe first syntax returns the position of the first occurrence of\nsubstring substr in string str. The second syntax returns the position\nof the first occurrence of substring substr in string str, starting at\nposition pos. Returns 0 if substr is not in str.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT LOCATE(\'bar\', \'foobarbar\');\n        -> 4\nmysql> SELECT LOCATE(\'xbar\', \'foobar\');\n        -> 0\nmysql> SELECT LOCATE(\'bar\', \'foobarbar\', 5);\n        -> 7\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (167,25,'SHOW EVENTS','Syntax:\nSHOW EVENTS [{FROM | IN} schema_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nIn its simplest form, SHOW EVENTS lists all of the events in the\ncurrent schema:\n\nmysql> SELECT CURRENT_USER(), SCHEMA();\n+----------------+----------+\n| CURRENT_USER() | SCHEMA() |\n+----------------+----------+\n| jon@ghidora    | myschema |\n+----------------+----------+\n1 row in set (0.00 sec)\n\nmysql> SHOW EVENTS\\G\n*************************** 1. row ***************************\n                  Db: myschema\n                Name: e_daily\n             Definer: jon@ghidora\n           Time zone: SYSTEM\n                Type: RECURRING\n          Execute at: NULL\n      Interval value: 10\n      Interval field: SECOND\n              Starts: 2006-02-09 10:41:23\n                Ends: 0000-00-00 00:00:00\n              Status: ENABLED\n          Originator: 0\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n  Database Collation: latin1_swedish_ci\n\nThe LIKE clause, if present, indicates which event names to match. The\nWHERE clause can be given to select rows using more general conditions,\nas discussed in\nhttp://dev.mysql.com/doc/refman/5.1/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-events.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-events.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (168,15,'CHARSET','Syntax:\nCHARSET(str)\n\nReturns the character set of the string argument.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT CHARSET(\'abc\');\n        -> \'latin1\'\nmysql> SELECT CHARSET(CONVERT(\'abc\' USING utf8));\n        -> \'utf8\'\nmysql> SELECT CHARSET(USER());\n        -> \'utf8\'\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (169,30,'SUBDATE','Syntax:\nSUBDATE(date,INTERVAL expr unit), SUBDATE(expr,days)\n\nWhen invoked with the INTERVAL form of the second argument, SUBDATE()\nis a synonym for DATE_SUB(). For information on the INTERVAL unit\nargument, see the discussion for DATE_ADD().\n\nmysql> SELECT DATE_SUB(\'2008-01-02\', INTERVAL 31 DAY);\n        -> \'2007-12-02\'\nmysql> SELECT SUBDATE(\'2008-01-02\', INTERVAL 31 DAY);\n        -> \'2007-12-02\'\n\nThe second form allows the use of an integer value for days. In such\ncases, it is interpreted as the number of days to be subtracted from\nthe date or datetime expression expr.\n\nmysql> SELECT SUBDATE(\'2008-01-02 12:00:00\', 31);\n        -> \'2007-12-02 12:00:00\'\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (170,30,'DAYOFYEAR','Syntax:\nDAYOFYEAR(date)\n\nReturns the day of the year for date, in the range 1 to 366.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT DAYOFYEAR(\'2007-02-03\');\n        -> 34\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (171,20,'LONGTEXT','LONGTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 4,294,967,295 or 4GB (232 - 1)\ncharacters. The effective maximum length is less if the value contains\nmulti-byte characters. The effective maximum length of LONGTEXT columns\nalso depends on the configured maximum packet size in the client/server\nprotocol and available memory. Each LONGTEXT value is stored using a\nfour-byte length prefix that indicates the number of bytes in the\nvalue.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (172,4,'%','Syntax:\nN % M\n\nModulo operation. Returns the remainder of N divided by M. For more\ninformation, see the description for the MOD() function in\nhttp://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (173,25,'KILL','Syntax:\nKILL [CONNECTION | QUERY] thread_id\n\nEach connection to mysqld runs in a separate thread. You can see which\nthreads are running with the SHOW PROCESSLIST statement and kill a\nthread with the KILL thread_id statement.\n\nKILL allows the optional CONNECTION or QUERY modifier:\n\no KILL CONNECTION is the same as KILL with no modifier: It terminates\n  the connection associated with the given thread_id.\n\no KILL QUERY terminates the statement that the connection is currently\n  executing, but leaves the connection itself intact.\n\nIf you have the PROCESS privilege, you can see all threads. If you have\nthe SUPER privilege, you can kill all threads and statements.\nOtherwise, you can see and kill only your own threads and statements.\n\nYou can also use the mysqladmin processlist and mysqladmin kill\ncommands to examine and kill threads.\n\n*Note*: You cannot use KILL with the Embedded MySQL Server library,\nbecause the embedded server merely runs inside the threads of the host\napplication. It does not create any connection threads of its own.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/kill.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/kill.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (174,29,'DISJOINT','Disjoint(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially disjoint from (does\nnot intersect) g2.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (175,3,'ASTEXT','AsText(g), AsWKT(g)\n\nConverts a value in internal geometry format to its WKT representation\nand returns the string result.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-to-convert-geometries-between-formats.html\n\n','mysql> SET @g = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT AsText(GeomFromText(@g));\n+--------------------------+\n| AsText(GeomFromText(@g)) |\n+--------------------------+\n| LINESTRING(1 1,2 2,3 3)  |\n+--------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/functions-to-convert-geometries-between-formats.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (176,35,'LPAD','Syntax:\nLPAD(str,len,padstr)\n\nReturns the string str, left-padded with the string padstr to a length\nof len characters. If str is longer than len, the return value is\nshortened to len characters.\n\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT LPAD(\'hi\',4,\'??\');\n        -> \'??hi\'\nmysql> SELECT LPAD(\'hi\',1,\'??\');\n        -> \'h\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (177,19,'RESTORE TABLE','Syntax:\nRESTORE TABLE tbl_name [, tbl_name] ... FROM \'/path/to/backup/directory\'\n\nRESTORE TABLE restores the table or tables from a backup that was made\nwith BACKUP TABLE. The directory should be specified as a full path\nname.\n\nExisting tables are not overwritten; if you try to restore over an\nexisting table, an error occurs. Just as for BACKUP TABLE, RESTORE\nTABLE currently works only for MyISAM tables. Restored tables are not\nreplicated from master to slave.\n\nThe backup for each table consists of its .frm format file and .MYD\ndata file. The restore operation restores those files, and then uses\nthem to rebuild the .MYI index file. Restoring takes longer than\nbacking up due to the need to rebuild the indexes. The more indexes the\ntable has, the longer it takes.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/restore-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/restore-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (178,22,'DECLARE CONDITION','Syntax:\nDECLARE condition_name CONDITION FOR condition_value\n\ncondition_value:\n    SQLSTATE [VALUE] sqlstate_value\n  | mysql_error_code\n\nThe DECLARE ... CONDITION statement defines a named error condition. It\nspecifies a condition that needs specific handling and associates a\nname with that condition. The name can be referred to in a subsequence\nDECLARE ... HANDLER statement. See [HELP DECLARE HANDLER].\n\nA condition_value for DECLARE ... CONDITION can be an SQLSTATE value (a\n5-character string literal) or a MySQL error code (a number). You\nshould not use SQLSTATE value \'00000\' or MySQL error code 0, because\nthose indicate sucess rather than an error condition. For a list of\nSQLSTATE values and MySQL error codes, see\nhttp://dev.mysql.com/doc/refman/5.1/en/error-messages-server.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/declare-condition.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/declare-condition.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (179,29,'OVERLAPS','Overlaps(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially overlaps g2. The term\nspatially overlaps is used if two geometries intersect and their\nintersection results in a geometry of the same dimension but not equal\nto either of the given geometries.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (180,25,'SET GLOBAL SQL_SLAVE_SKIP_COUNTER','Syntax:\nSET GLOBAL SQL_SLAVE_SKIP_COUNTER = N\n\nThis statement skips the next N events from the master. This is useful\nfor recovering from replication stops caused by a statement.\n\nThis statement is valid only when the slave thread is not running.\nOtherwise, it produces an error.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/set-global-sql-slave-skip-counter.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/set-global-sql-slave-skip-counter.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (181,24,'NUMGEOMETRIES','NumGeometries(gc)\n\nReturns the number of geometries in the GeometryCollection value gc.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#geometrycollection-property-functions\n\n','mysql> SET @gc = \'GeometryCollection(Point(1 1),LineString(2 2, 3 3))\';\nmysql> SELECT NumGeometries(GeomFromText(@gc));\n+----------------------------------+\n| NumGeometries(GeomFromText(@gc)) |\n+----------------------------------+\n|                                2 |\n+----------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#geometrycollection-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (182,30,'MONTHNAME','Syntax:\nMONTHNAME(date)\n\nReturns the full name of the month for date. As of MySQL 5.1.12, the\nlanguage used for the name is controlled by the value of the\nlc_time_names system variable\n(http://dev.mysql.com/doc/refman/5.1/en/locale-support.html).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT MONTHNAME(\'2008-02-03\');\n        -> \'February\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (183,36,'PROCEDURE ANALYSE','Syntax:\nANALYSE([max_elements[,max_memory]])\n\nANALYSE() is defined in the sql/sql_analyse.cc source file, which\nserves as an example of how to create a procedure for use with the\nPROCEDURE clause of SELECT statements. ANALYSE() is built in and is\navailable by default; other procedures can be created using the format\ndemonstrated in the source file.\n\nANALYSE() examines the result from a query and returns an analysis of\nthe results that suggests optimal data types for each column that may\nhelp reduce table sizes. To obtain this analysis, append PROCEDURE\nANALYSE to the end of a SELECT statement:\n\nSELECT ... FROM ... WHERE ... PROCEDURE ANALYSE([max_elements,[max_memory]])\n\nFor example:\n\nSELECT col1, col2 FROM table1 PROCEDURE ANALYSE(10, 2000);\n\nThe results show some statistics for the values returned by the query,\nand propose an optimal data type for the columns. This can be helpful\nfor checking your existing tables, or after importing new data. You may\nneed to try different settings for the arguments so that PROCEDURE\nANALYSE() does not suggest the ENUM data type when it is not\nappropriate.\n\nThe arguments are optional and are used as follows:\n\no max_elements (default 256) is the maximum number of distinct values\n  that ANALYSE() notices per column. This is used by ANALYSE() to check\n  whether the optimal data type should be of type ENUM; if there are\n  more than max_elements distinct values, then ENUM is not a suggested\n  type.\n\no max_memory (default 8192) is the maximum amount of memory that\n  ANALYSE() should allocate per column while trying to find all\n  distinct values.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/procedure-analyse.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/procedure-analyse.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (184,25,'CHANGE MASTER TO','Syntax:\nCHANGE MASTER TO master_def [, master_def] ...\n\nmaster_def:\n    MASTER_BIND = \'interface_name\'\n  | MASTER_HOST = \'host_name\'\n  | MASTER_USER = \'user_name\'\n  | MASTER_PASSWORD = \'password\'\n  | MASTER_PORT = port_num\n  | MASTER_CONNECT_RETRY = interval\n  | MASTER_HEARTBEAT_PERIOD = interval\n  | MASTER_LOG_FILE = \'master_log_name\'\n  | MASTER_LOG_POS = master_log_pos\n  | RELAY_LOG_FILE = \'relay_log_name\'\n  | RELAY_LOG_POS = relay_log_pos\n  | MASTER_SSL = {0|1}\n  | MASTER_SSL_CA = \'ca_file_name\'\n  | MASTER_SSL_CAPATH = \'ca_directory_name\'\n  | MASTER_SSL_CERT = \'cert_file_name\'\n  | MASTER_SSL_KEY = \'key_file_name\'\n  | MASTER_SSL_CIPHER = \'cipher_list\'\n  | MASTER_SSL_VERIFY_SERVER_CERT = {0|1}\n\nCHANGE MASTER TO changes the parameters that the slave server uses for\nconnecting to and communicating with the master server. It also updates\nthe contents of the master.info and relay-log.info files.\n\nMASTER_USER, MASTER_PASSWORD, MASTER_SSL, MASTER_SSL_CA,\nMASTER_SSL_CAPATH, MASTER_SSL_CERT, MASTER_SSL_KEY, MASTER_SSL_CIPHER,\nand MASTER_SSL_VERIFY_SERVER_CERT provide information to the slave\nabout how to connect to its master. MASTER_SSL_VERIFY_SERVER_CERT was\nadded in MySQL 5.1.18. It is used as described for the\n--ssl-verify-server-cert option in\nhttp://dev.mysql.com/doc/refman/5.1/en/ssl-options.html.\n\nMASTER_CONNECT_RETRY specifies how many seconds to wait between connect\nretries. The default is 60. The number of reconnection attempts is\nlimited by the --master-retry-count server option; for more\ninformation, see\nhttp://dev.mysql.com/doc/refman/5.1/en/replication-options.html.\n\nThe SSL options (MASTER_SSL, MASTER_SSL_CA, MASTER_SSL_CAPATH,\nMASTER_SSL_CERT, MASTER_SSL_KEY, MASTER_SSL_CIPHER), and\nMASTER_SSL_VERIFY_SERVER_CERT can be changed even on slaves that are\ncompiled without SSL support. They are saved to the master.info file,\nbut are ignored unless you use a server that has SSL support enabled.\n\nIf you do not specify a given parameter, it keeps its old value, except\nas indicated in the following discussion. For example, if the password\nto connect to your MySQL master has changed, you just need to issue\nthese statements to tell the slave about the new password:\n\nSTOP SLAVE; -- if replication was running\nCHANGE MASTER TO MASTER_PASSWORD=\'new3cret\';\nSTART SLAVE; -- if you want to restart replication\n\nThere is no need to specify the parameters that do not change (host,\nport, user, and so forth).\n\nMASTER_HOST and MASTER_PORT are the host name (or IP address) of the\nmaster host and its TCP/IP port.\n\nThe next two options (MASTER_BIND and MASTER_HEARTBEAT_PERIOD) are\navailable in MySQL Cluster NDB 6.3 and later, but are not supported in\nmainline MySQL 5.1:\n\no MASTER_BIND is for use on replication slaves having multiple network\n  interfaces, and determines which of the slave\'s network interfaces is\n  chosen for connecting to the master. It is also possible to determine\n  which network interface is to be used in such cases by starting the\n  slave mysqld process with the --master-bind option.\n\n  The ability to bind a replication slave to specific network interface\n  was added in MySQL Cluster NDB 6.3.4.\n\no MASTER_HEARTBEAT_PERIOD is used to set the interval in seconds\n  between replication heartbeats. Whenever the master\'s binlog is\n  updated with an event, the waiting period for the next heartbeat is\n  reset. interval is a decimal value having the range 0 to 4294967\n  seconds and a resolution to hundredths of a second; the smallest\n  nonzero value is 0.001. Heartbeats are sent by the master only if\n  there are no unsent events in the binlog file for a period longer\n  than interval.\n\n  Setting interval to 0 disables heartbeats altogether. The default\n  value for interval is equal to the value of slave_net_timeout divided\n  by 2.\n\n  Setting @@global.slave_net_timeout to a value less than that of the\n  current heartbeat interval results in a warning being issued. The\n  effect of issuing RESET SLAVE on the heartbeat interval is to reset\n  it to the default value.\n\n  MASTER_HEARTBEAT_PERIOD was added in MySQL Cluster NDB 6.3.4.\n\n*Note*: Replication cannot use Unix socket files. You must be able to\nconnect to the master MySQL server using TCP/IP.\n\nIf you specify MASTER_HOST or MASTER_PORT, the slave assumes that the\nmaster server is different from before (even if you specify a host or\nport value that is the same as the current value.) In this case, the\nold values for the master binary log name and position are considered\nno longer applicable, so if you do not specify MASTER_LOG_FILE and\nMASTER_LOG_POS in the statement, MASTER_LOG_FILE=\'\' and\nMASTER_LOG_POS=4 are silently appended to it.\n\nSetting MASTER_HOST=\'\' --- that is, setting its value explicitly to an\nempty string --- is not the same as not setting it at all. Setting this\noption to an empty string causes START SLAVE subsequently to fail. This\nissue is addressed in MySQL 6.0. (Bug#28796\n(http://bugs.mysql.com/28796))\n\nMASTER_LOG_FILE and MASTER_LOG_POS are the coordinates at which the\nslave I/O thread should begin reading from the master the next time the\nthread starts. If you specify either of them, you cannot specify\nRELAY_LOG_FILE or RELAY_LOG_POS. If neither of MASTER_LOG_FILE or\nMASTER_LOG_POS are specified, the slave uses the last coordinates of\nthe slave SQL thread before CHANGE MASTER TO was issued. This ensures\nthat there is no discontinuity in replication, even if the slave SQL\nthread was late compared to the slave I/O thread, when you merely want\nto change, say, the password to use.\n\nCHANGE MASTER TO deletes all relay log files and starts a new one,\nunless you specify RELAY_LOG_FILE or RELAY_LOG_POS. In that case, relay\nlogs are kept; the relay_log_purge global variable is set silently to\n0.\n\nCHANGE MASTER TO is useful for setting up a slave when you have the\nsnapshot of the master and have recorded the log and the offset\ncorresponding to it. After loading the snapshot into the slave, you can\nrun CHANGE MASTER TO MASTER_LOG_FILE=\'log_name_on_master\',\nMASTER_LOG_POS=log_offset_on_master on the slave.\n\nThe following example changes the master and master\'s binary log\ncoordinates. This is used when you want to set up the slave to\nreplicate the master:\n\nCHANGE MASTER TO\n  MASTER_HOST=\'master2.mycompany.com\',\n  MASTER_USER=\'replication\',\n  MASTER_PASSWORD=\'bigs3cret\',\n  MASTER_PORT=3306,\n  MASTER_LOG_FILE=\'master2-bin.001\',\n  MASTER_LOG_POS=4,\n  MASTER_CONNECT_RETRY=10;\n\nThe next example shows an operation that is less frequently employed.\nIt is used when the slave has relay logs that you want it to execute\nagain for some reason. To do this, the master need not be reachable.\nYou need only use CHANGE MASTER TO and start the SQL thread (START\nSLAVE SQL_THREAD):\n\nCHANGE MASTER TO\n  RELAY_LOG_FILE=\'slave-relay-bin.006\',\n  RELAY_LOG_POS=4025;\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/change-master-to.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/change-master-to.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (185,37,'DROP DATABASE','Syntax:\nDROP {DATABASE | SCHEMA} [IF EXISTS] db_name\n\nDROP DATABASE drops all tables in the database and deletes the\ndatabase. Be very careful with this statement! To use DROP DATABASE,\nyou need the DROP privilege on the database. DROP SCHEMA is a synonym\nfor DROP DATABASE.\n\n*Important*: When a database is dropped, user privileges on the\ndatabase are not automatically dropped. See [HELP GRANT].\n\nIF EXISTS is used to prevent an error from occurring if the database\ndoes not exist.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-database.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-database.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (186,6,'MBREQUAL','MBREqual(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 are the same.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (187,30,'TIMESTAMP FUNCTION','Syntax:\nTIMESTAMP(expr), TIMESTAMP(expr1,expr2)\n\nWith a single argument, this function returns the date or datetime\nexpression expr as a datetime value. With two arguments, it adds the\ntime expression expr2 to the date or datetime expression expr1 and\nreturns the result as a datetime value.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT TIMESTAMP(\'2003-12-31\');\n        -> \'2003-12-31 00:00:00\'\nmysql> SELECT TIMESTAMP(\'2003-12-31 12:00:00\',\'12:00:00\');\n        -> \'2004-01-01 00:00:00\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (188,35,'CHARACTER_LENGTH','Syntax:\nCHARACTER_LENGTH(str)\n\nCHARACTER_LENGTH() is a synonym for CHAR_LENGTH().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (189,25,'SHOW GRANTS','Syntax:\nSHOW GRANTS [FOR user]\n\nThis statement lists the GRANT statement or statements that must be\nissued to duplicate the privileges that are granted to a MySQL user\naccount. The account is named using the same format as for the GRANT\nstatement; for example, \'jeffrey\'@\'localhost\'. If you specify only the\nuser name part of the account name, a host name part of \'%\' is used.\nFor additional information about specifying account names, see [HELP\nGRANT].\n\nmysql> SHOW GRANTS FOR \'root\'@\'localhost\';\n+---------------------------------------------------------------------+\n| Grants for root@localhost                                           |\n+---------------------------------------------------------------------+\n| GRANT ALL PRIVILEGES ON *.* TO \'root\'@\'localhost\' WITH GRANT OPTION |\n+---------------------------------------------------------------------+\n\nTo list the privileges granted to the account that you are using to\nconnect to the server, you can use any of the following statements:\n\nSHOW GRANTS;\nSHOW GRANTS FOR CURRENT_USER;\nSHOW GRANTS FOR CURRENT_USER();\n\nAs of MySQL 5.1.12, if SHOW GRANTS FOR CURRENT_USER (or any of the\nequivalent syntaxes) is used in DEFINER context, such as within a\nstored procedure that is defined with SQL SECURITY DEFINER), the grants\ndisplayed are those of the definer and not the invoker.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-grants.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-grants.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (190,25,'SHOW PRIVILEGES','Syntax:\nSHOW PRIVILEGES\n\nSHOW PRIVILEGES shows the list of system privileges that the MySQL\nserver supports. The exact list of privileges depends on the version of\nyour server.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-privileges.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-privileges.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (191,37,'CREATE TABLESPACE','Syntax:\nCREATE TABLESPACE tablespace_name\n    ADD DATAFILE \'file_name\'\n    USE LOGFILE GROUP logfile_group\n    [EXTENT_SIZE [=] extent_size]\n    [INITIAL_SIZE [=] initial_size]\n    [AUTOEXTEND_SIZE [=] autoextend_size]\n    [MAX_SIZE [=] max_size]\n    [NODEGROUP [=] nodegroup_id]\n    [WAIT]\n    [COMMENT [=] comment_text]\n    ENGINE [=] engine_name\n\nThis statement is used to create a tablespace, which can contain one or\nmore data files, providing storage space for tables. One data file is\ncreated and added to the tablespace using this statement. Additional\ndata files may be added to the tablespace by using the ALTER TABLESPACE\nstatement (see [HELP ALTER TABLESPACE]). For rules covering the naming\nof tablespaces, see\nhttp://dev.mysql.com/doc/refman/5.1/en/identifiers.html.\n\n*Note*: All MySQL Cluster Disk Data objects share the same namespace.\nThis means that each Disk Data object must be uniquely named (and not\nmerely each Disk Data object of a given type). For example, you cannot\nhave a tablespace and a log file group with the same name, or a\ntablespace and a data file with the same name.\n\nPrior to MySQL Cluster NDB 6.2.17, 6.3.23, and 6.4.3, path and file\nnames for data files could not be longer than 128 characters.\n(Bug#31770 (http://bugs.mysql.com/31770))\n\nA log file group of one or more UNDO log files must be assigned to the\ntablespace to be created with the USE LOGFILE GROUP clause.\nlogfile_group must be an existing log file group created with CREATE\nLOGFILE GROUP (see\nhttp://dev.mysql.com/doc/refman/5.1/en/create-logfile-group.html).\nMultiple tablespaces may use the same log file group for UNDO logging.\n\nThe EXTENT_SIZE sets the size, in bytes, of the extents used by any\nfiles belonging to the tablespace. The default value is 1M. The minimum\nsize is 32K, and theoretical maximum is 2G, although the practical\nmaximum size depends on a number of factors. In most cases, changing\nthe extent size does not have any measurable effect on performance, and\nthe default value is recommended for all but the most unusual\nsituations.\n\nAn extent is a unit of disk space allocation. One extent is filled with\nas much data as that extent can contain before another extent is used.\nIn theory, up to 65,535 (64K) extents may used per data file; however,\nthe recommended maximum is 32,768 (32K). The recommended maximum size\nfor a single data file is 32G --- that is, 32K extents x 1 MB per\nextent. In addition, once an extent is allocated to a given partition,\nit cannot be used to store data from a different partition; an extent\ncannot store data from more than one partition. This means, for example\nthat a tablespace having a single datafile whose INITIAL_SIZE is 256 MB\nand whose EXTENT_SIZE is 128M has just two extents, and so can be used\nto store data from at most two different disk data table partitions.\n\nYou can see how many extents remain free in a given data file by\nquerying the INFORMATION_SCHEMA.FILES table, and so derive an estimate\nfor how much space remains free in the file. For further discussion and\nexamples, see http://dev.mysql.com/doc/refman/5.1/en/files-table.html.\n\nThe INITIAL_SIZE parameter sets the data file\'s total size in bytes.\nOnce the file has been created, its size cannot be changed; however,\nyou can add more data files to the tablespace using ALTER TABLESPACE\n... ADD DATAFILE. See [HELP ALTER TABLESPACE].\n\nINITIAL_SIZE is optional; its default value is 128M.\n\nOn 32-bit systems, the maximum supported value for INITIAL_SIZE is 4G.\n(Bug#29186 (http://bugs.mysql.com/29186))\n\nWhen setting EXTENT_SIZE or INITIAL_SIZE (either or both), you may\noptionally follow the number with a one-letter abbreviation for an\norder of magnitude, similar to those used in my.cnf. Generally, this is\none of the letters M (for megabytes) or G (for gigabytes).\n\nAUTOEXTEND_SIZE, MAX_SIZE, NODEGROUP, WAIT, and COMMENT are parsed but\nignored, and so have no effect in MySQL 5.1. These options are intended\nfor future expansion.\n\nThe ENGINE parameter determines the storage engine which uses this\ntablespace, with engine_name being the name of the storage engine. In\nMySQL 5.1, engine_name must be one of the values NDB or NDBCLUSTER.\n\nWhen CREATE TABLESPACE is used with ENGINE = NDB, a tablespace and\nassociated data file are created on each Cluster data node. You can\nverify that the data files were created and obtain information about\nthem by querying the INFORMATION_SCHEMA.FILES table. For example:\n\nmysql> SELECT LOGFILE_GROUP_NAME, FILE_NAME, EXTRA\n    -> FROM INFORMATION_SCHEMA.FILES\n    -> WHERE TABLESPACE_NAME = \'newts\' AND FILE_TYPE = \'DATAFILE\';\n+--------------------+-------------+----------------+\n| LOGFILE_GROUP_NAME | FILE_NAME   | EXTRA          |\n+--------------------+-------------+----------------+\n| lg_3               | newdata.dat | CLUSTER_NODE=3 |\n| lg_3               | newdata.dat | CLUSTER_NODE=4 |\n+--------------------+-------------+----------------+\n2 rows in set (0.01 sec)\n\n(See http://dev.mysql.com/doc/refman/5.1/en/files-table.html.)\n\nCREATE TABLESPACE was added in MySQL 5.1.6. In MySQL 5.1, it is useful\nonly with Disk Data storage for MySQL Cluster. See\nhttp://dev.mysql.com/doc/refman/5.1/en/mysql-cluster-disk-data.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-tablespace.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-tablespace.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (192,35,'INSERT FUNCTION','Syntax:\nINSERT(str,pos,len,newstr)\n\nReturns the string str, with the substring beginning at position pos\nand len characters long replaced by the string newstr. Returns the\noriginal string if pos is not within the length of the string. Replaces\nthe rest of the string from position pos if len is not within the\nlength of the rest of the string. Returns NULL if any argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT INSERT(\'Quadratic\', 3, 4, \'What\');\n        -> \'QuWhattic\'\nmysql> SELECT INSERT(\'Quadratic\', -1, 4, \'What\');\n        -> \'Quadratic\'\nmysql> SELECT INSERT(\'Quadratic\', 3, 100, \'What\');\n        -> \'QuWhat\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (193,4,'CRC32','Syntax:\nCRC32(expr)\n\nComputes a cyclic redundancy check value and returns a 32-bit unsigned\nvalue. The result is NULL if the argument is NULL. The argument is\nexpected to be a string and (if possible) is treated as one if it is\nnot.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT CRC32(\'MySQL\');\n        -> 3259397556\nmysql> SELECT CRC32(\'mysql\');\n        -> 2501908538\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (194,13,'XOR','Syntax:\nXOR\n\nLogical XOR. Returns NULL if either operand is NULL. For non-NULL\noperands, evaluates to 1 if an odd number of operands is nonzero,\notherwise 0 is returned.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/logical-operators.html\n\n','mysql> SELECT 1 XOR 1;\n        -> 0\nmysql> SELECT 1 XOR 0;\n        -> 1\nmysql> SELECT 1 XOR NULL;\n        -> NULL\nmysql> SELECT 1 XOR 1 XOR 1;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/logical-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (195,12,'STARTPOINT','StartPoint(ls)\n\nReturns the Point that is the start point of the LineString value ls.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#linestring-property-functions\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT AsText(StartPoint(GeomFromText(@ls)));\n+---------------------------------------+\n| AsText(StartPoint(GeomFromText(@ls))) |\n+---------------------------------------+\n| POINT(1 1)                            |\n+---------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#linestring-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (196,22,'DECLARE VARIABLE','Syntax:\nDECLARE var_name [, var_name] ... type [DEFAULT value]\n\nThis statement is used to declare local variables within stored\nprograms. To provide a default value for the variable, include a\nDEFAULT clause. The value can be specified as an expression; it need\nnot be a constant. If the DEFAULT clause is missing, the initial value\nis NULL.\n\nLocal variables are treated like stored routine parameters with respect\nto data type and overflow checking. See [HELP CREATE PROCEDURE].\n\nLocal variable names are not case sensitive.\n\nThe scope of a local variable is within the BEGIN ... END block where\nit is declared. The variable can be referred to in blocks nested within\nthe declaring block, except those blocks that declare a variable with\nthe same name.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/declare-local-variable.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/declare-local-variable.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (197,9,'GRANT','Syntax:\nGRANT\n    priv_type [(column_list)]\n      [, priv_type [(column_list)]] ...\n    ON [object_type] priv_level\n    TO user [IDENTIFIED BY [PASSWORD] \'password\']\n        [, user [IDENTIFIED BY [PASSWORD] \'password\']] ...\n    [REQUIRE {NONE | ssl_option [[AND] ssl_option] ...}]\n    [WITH with_option [with_option] ...]\n\nobject_type:\n    TABLE\n  | FUNCTION\n  | PROCEDURE\n\npriv_level:\n    *\n  | *.*\n  | db_name.*\n  | db_name.tbl_name\n  | tbl_name\n  | db_name.routine_name\n\nwith_option:\n    GRANT OPTION\n  | MAX_QUERIES_PER_HOUR count\n  | MAX_UPDATES_PER_HOUR count\n  | MAX_CONNECTIONS_PER_HOUR count\n  | MAX_USER_CONNECTIONS count\n\nssl_option:\n    SSL\n  | X509\n  | CIPHER \'cipher\'\n  | ISSUER \'issuer\'\n  | SUBJECT \'subject\'\n\nThe GRANT statement enables system administrators to create MySQL user\naccounts and to grant rights to accounts. To use GRANT, you must have\nthe GRANT OPTION privilege, and you must have the privileges that you\nare granting. The REVOKE statement is related and enables\nadministrators to remove account privileges. To determine what\nprivileges an account has, use SHOW GRANTS. See [HELP REVOKE], and\n[HELP SHOW GRANTS].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/grant.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/grant.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (198,3,'MPOLYFROMTEXT','MPolyFromText(wkt[,srid]), MultiPolygonFromText(wkt[,srid])\n\nConstructs a MULTIPOLYGON value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkt-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkt-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (199,6,'MBRINTERSECTS','MBRIntersects(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 intersect.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (200,16,'BIT_OR','Syntax:\nBIT_OR(expr)\n\nReturns the bitwise OR of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (201,30,'YEARWEEK','Syntax:\nYEARWEEK(date), YEARWEEK(date,mode)\n\nReturns year and week for a date. The mode argument works exactly like\nthe mode argument to WEEK(). The year in the result may be different\nfrom the year in the date argument for the first and the last week of\nthe year.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT YEARWEEK(\'1987-01-01\');\n        -> 198653\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (202,17,'NOT BETWEEN','Syntax:\nexpr NOT BETWEEN min AND max\n\nThis is the same as NOT (expr BETWEEN min AND max).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (203,17,'IS NOT','Syntax:\nIS NOT boolean_value\n\nTests a value against a boolean value, where boolean_value can be TRUE,\nFALSE, or UNKNOWN.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 1 IS NOT UNKNOWN, 0 IS NOT UNKNOWN, NULL IS NOT UNKNOWN;\n        -> 1, 1, 0\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (204,4,'LOG10','Syntax:\nLOG10(X)\n\nReturns the base-10 logarithm of X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT LOG10(2);\n        -> 0.30102999566398\nmysql> SELECT LOG10(100);\n        -> 2\nmysql> SELECT LOG10(-100);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (205,4,'SQRT','Syntax:\nSQRT(X)\n\nReturns the square root of a nonnegative number X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT SQRT(4);\n        -> 2\nmysql> SELECT SQRT(20);\n        -> 4.4721359549996\nmysql> SELECT SQRT(-16);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (206,20,'DECIMAL','DECIMAL[(M[,D])] [UNSIGNED] [ZEROFILL]\n\nA packed "exact" fixed-point number. M is the total number of digits\n(the precision) and D is the number of digits after the decimal point\n(the scale). The decimal point and (for negative numbers) the "-" sign\nare not counted in M. If D is 0, values have no decimal point or\nfractional part. The maximum number of digits (M) for DECIMAL is 65.\nThe maximum number of supported decimals (D) is 30. If D is omitted,\nthe default is 0. If M is omitted, the default is 10.\n\nUNSIGNED, if specified, disallows negative values.\n\nAll basic calculations (+, -, *, /) with DECIMAL columns are done with\na precision of 65 digits.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (207,37,'CREATE INDEX','Syntax:\nCREATE [ONLINE|OFFLINE] [UNIQUE|FULLTEXT|SPATIAL] INDEX index_name\n    [index_type]\n    ON tbl_name (index_col_name,...)\n    [index_option] ...\n\nindex_col_name:\n    col_name [(length)] [ASC | DESC]\n\nindex_type:\n    USING {BTREE | HASH | RTREE}\n\nindex_option:\n    KEY_BLOCK_SIZE [=] value\n  | index_type\n  | WITH PARSER parser_name\n\nCREATE INDEX is mapped to an ALTER TABLE statement to create indexes.\nSee [HELP ALTER TABLE]. CREATE INDEX cannot be used to create a PRIMARY\nKEY; use ALTER TABLE instead. For more information about indexes, see\nhttp://dev.mysql.com/doc/refman/5.1/en/mysql-indexes.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-index.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-index.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (208,37,'CREATE FUNCTION','The CREATE FUNCTION statement is used to create stored functions and\nuser-defined functions (UDFs):\n\no For information about creating stored functions, see [HELP CREATE\n  PROCEDURE].\n\no For information about creating user-defined functions, see [HELP\n  CREATE FUNCTION UDF].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-function.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-function.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (209,37,'ALTER DATABASE','Syntax:\nALTER {DATABASE | SCHEMA} [db_name]\n    alter_specification ...\nALTER {DATABASE | SCHEMA} db_name\n    UPGRADE DATA DIRECTORY NAME\n\nalter_specification:\n    [DEFAULT] CHARACTER SET [=] charset_name\n  | [DEFAULT] COLLATE [=] collation_name\n\nALTER DATABASE enables you to change the overall characteristics of a\ndatabase. These characteristics are stored in the db.opt file in the\ndatabase directory. To use ALTER DATABASE, you need the ALTER privilege\non the database. ALTER SCHEMA is a synonym for ALTER DATABASE.\n\nThe CHARACTER SET clause changes the default database character set.\nThe COLLATE clause changes the default database collation.\nhttp://dev.mysql.com/doc/refman/5.1/en/charset.html, discusses\ncharacter set and collation names.\n\nYou can see what character sets and collations are available using,\nrespectively, the SHOW CHARACTER SET and SHOW COLLATION statements. See\n[HELP SHOW CHARACTER SET], and [HELP SHOW COLLATION], for more\ninformation.\n\nThe database name can be omitted from the first syntax, in which case\nthe statement applies to the default database.\n\nThe syntax that includes the UPGRADE DATA DIRECTORY NAME clause was\nadded in MySQL 5.1.23. It updates the name of the directory associated\nwith the database to use the encoding implemented in MySQL 5.1 for\nmapping database names to database directory names (see\nhttp://dev.mysql.com/doc/refman/5.1/en/identifier-mapping.html). This\nclause is for use under these conditions:\n\no It is intended when upgrading MySQL to 5.1 or later from older\n  versions.\n\no It is intended to update a database directory name to the current\n  encoding format if the name contains special characters that need\n  encoding.\n\no The statement is used by mysqlcheck (as invoked by mysql_upgrade).\n\nFor example,if a database in MySQL 5.0 has a name of a-b-c, the name\ncontains instance of the `-\' character. In 5.0, the database directory\nis also named a-b-c, which is not necessarily safe for all file\nsystems. In MySQL 5.1 and up, the same database name is encoded as\na@002db@002dc to produce a file system-neutral directory name.\n\nWhen a MySQL installation is upgraded to MySQL 5.1 or later from an\nolder version,the server displays a name such as a-b-c (which is in the\nold format) as #mysql50#a-b-c, and you must refer to the name using the\n#mysql50# prefix. Use UPGRADE DATA DIRECTORY NAME in this case to\nexplicitly tell the server to re-encode the database directory name to\nthe current encoding format:\n\nALTER DATABASE `#mysql50#a-b-c` UPGRADE DATA DIRECTORY NAME;\n\nAfter executing this statement, you can refer to the database as a-b-c\nwithout the special #mysql50# prefix.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/alter-database.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/alter-database.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (210,24,'GEOMETRYN','GeometryN(gc,N)\n\nReturns the N-th geometry in the GeometryCollection value gc.\nGeometries are numbered beginning with 1.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#geometrycollection-property-functions\n\n','mysql> SET @gc = \'GeometryCollection(Point(1 1),LineString(2 2, 3 3))\';\nmysql> SELECT AsText(GeometryN(GeomFromText(@gc),1));\n+----------------------------------------+\n| AsText(GeometryN(GeomFromText(@gc),1)) |\n+----------------------------------------+\n| POINT(1 1)                             |\n+----------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#geometrycollection-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (211,18,'<<','Syntax:\n<<\n\nShifts a longlong (BIGINT) number to the left.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html\n\n','mysql> SELECT 1 << 2;\n        -> 4\n','http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (212,25,'SHOW TABLE STATUS','Syntax:\nSHOW TABLE STATUS [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW TABLE STATUS works likes SHOW TABLES, but provides a lot of\ninformation about each non-TEMPORARY table. You can also get this list\nusing the mysqlshow --status db_name command. The LIKE clause, if\npresent, indicates which table names to match. The WHERE clause can be\ngiven to select rows using more general conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.1/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-table-status.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-table-status.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (213,11,'MD5','Syntax:\nMD5(str)\n\nCalculates an MD5 128-bit checksum for the string. The value is\nreturned as a binary string of 32 hex digits, or NULL if the argument\nwas NULL. The return value can, for example, be used as a hash key.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','mysql> SELECT MD5(\'testing\');\n        -> \'ae2b1fca515949e5d54fb22b8ed95575\'\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (214,17,'<','Syntax:\n<\n\nLess than:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 2 < 2;\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (215,30,'UNIX_TIMESTAMP','Syntax:\nUNIX_TIMESTAMP(), UNIX_TIMESTAMP(date)\n\nIf called with no argument, returns a Unix timestamp (seconds since\n\'1970-01-01 00:00:00\' UTC) as an unsigned integer. If UNIX_TIMESTAMP()\nis called with a date argument, it returns the value of the argument as\nseconds since \'1970-01-01 00:00:00\' UTC. date may be a DATE string, a\nDATETIME string, a TIMESTAMP, or a number in the format YYMMDD or\nYYYYMMDD. The server interprets date as a value in the current time\nzone and converts it to an internal value in UTC. Clients can set their\ntime zone as described in\nhttp://dev.mysql.com/doc/refman/5.1/en/time-zone-support.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT UNIX_TIMESTAMP();\n        -> 1196440210\nmysql> SELECT UNIX_TIMESTAMP(\'2007-11-30 10:30:19\');\n        -> 1196440219\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (216,30,'DAYOFMONTH','Syntax:\nDAYOFMONTH(date)\n\nReturns the day of the month for date, in the range 1 to 31, or 0 for\ndates such as \'0000-00-00\' or \'2008-00-00\' that have a zero day part.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT DAYOFMONTH(\'2007-02-03\');\n        -> 3\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (217,35,'ASCII','Syntax:\nASCII(str)\n\nReturns the numeric value of the leftmost character of the string str.\nReturns 0 if str is the empty string. Returns NULL if str is NULL.\nASCII() works for 8-bit characters.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT ASCII(\'2\');\n        -> 50\nmysql> SELECT ASCII(2);\n        -> 50\nmysql> SELECT ASCII(\'dx\');\n        -> 100\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (218,4,'DIV','Syntax:\nDIV\n\nInteger division. Similar to FLOOR(), but is safe with BIGINT values.\nIncorrect results may occur for noninteger operands that exceed BIGINT\nrange.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html\n\n','mysql> SELECT 5 DIV 2;\n        -> 2\n','http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (219,9,'RENAME USER','Syntax:\nRENAME USER old_user TO new_user\n    [, old_user TO new_user] ...\n\nThe RENAME USER statement renames existing MySQL accounts. To use it,\nyou must have the global CREATE USER privilege or the UPDATE privilege\nfor the mysql database. An error occurs if any old account does not\nexist or any new account exists. Each account is named using the same\nformat as for the GRANT statement; for example, \'jeffrey\'@\'localhost\'.\nIf you specify only the user name part of the account name, a host name\npart of \'%\' is used. For additional information about specifying\naccount names, see [HELP GRANT].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/rename-user.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/rename-user.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (220,25,'SHOW SLAVE STATUS','Syntax:\nSHOW SLAVE STATUS\n\nThis statement provides status information on essential parameters of\nthe slave threads. It requires either the SUPER or REPLICATION CLIENT\nprivilege.\n\nIf you issue this statement using the mysql client, you can use a \\G\nstatement terminator rather than a semicolon to obtain a more readable\nvertical layout:\n\nmysql> SHOW SLAVE STATUS\\G\n*************************** 1. row ***************************\n               Slave_IO_State: Waiting for master to send event\n                  Master_Host: localhost\n                  Master_User: root\n                  Master_Port: 3306\n                Connect_Retry: 3\n              Master_Log_File: gbichot-bin.005\n          Read_Master_Log_Pos: 79\n               Relay_Log_File: gbichot-relay-bin.005\n                Relay_Log_Pos: 548\n        Relay_Master_Log_File: gbichot-bin.005\n             Slave_IO_Running: Yes\n            Slave_SQL_Running: Yes\n              Replicate_Do_DB:\n          Replicate_Ignore_DB:\n                   Last_Errno: 0\n                   Last_Error:\n                 Skip_Counter: 0\n          Exec_Master_Log_Pos: 79\n              Relay_Log_Space: 552\n              Until_Condition: None\n               Until_Log_File:\n                Until_Log_Pos: 0\n           Master_SSL_Allowed: No\n           Master_SSL_CA_File:\n           Master_SSL_CA_Path:\n              Master_SSL_Cert:\n            Master_SSL_Cipher:\n               Master_SSL_Key:\n        Seconds_Behind_Master: 8\nMaster_SSL_Verify_Server_Cert: No\n                Last_IO_Errno: 0\n                Last_IO_Error:\n               Last_SQL_Errno: 0\n               Last_SQL_Error:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-slave-status.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-slave-status.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (221,32,'GEOMETRY','MySQL provides a standard way of creating spatial columns for geometry\ntypes, for example, with CREATE TABLE or ALTER TABLE. Currently,\nspatial columns are supported for MyISAM, InnoDB, NDB, and ARCHIVE\ntables. See also the annotations about spatial indexes under [HELP\nSPATIAL].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-columns.html\n\n','CREATE TABLE geom (g GEOMETRY);\n','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-columns.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (222,12,'NUMPOINTS','NumPoints(ls)\n\nReturns the number of Point objects in the LineString value ls.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#linestring-property-functions\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT NumPoints(GeomFromText(@ls));\n+------------------------------+\n| NumPoints(GeomFromText(@ls)) |\n+------------------------------+\n|                            3 |\n+------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#linestring-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (223,37,'ALTER LOGFILE GROUP','Syntax:\nALTER LOGFILE GROUP logfile_group\n    ADD UNDOFILE \'file_name\'\n    [INITIAL_SIZE [=] size]\n    [WAIT]\n    ENGINE [=] engine_name\n\nThis statement adds an UNDO file named \'file_name\' to an existing log\nfile group logfile_group. An ALTER LOGFILE GROUP statement has one and\nonly one ADD UNDOFILE clause. No DROP UNDOFILE clause is currently\nsupported.\n\n*Note*: All MySQL Cluster Disk Data objects share the same namespace.\nThis means that each Disk Data object must be uniquely named (and not\nmerely each Disk Data object of a given type). For example, you cannot\nhave a tablespace and an undo log file with the same name, or an undo\nlog file and a data file with the same name.\n\nPrior to MySQL Cluster NDB 6.2.17, 6.3.23, and 6.4.3, path and file\nnames for undo log files could not be longer than 128 characters.\n(Bug#31769 (http://bugs.mysql.com/31769))\n\nThe optional INITIAL_SIZE parameter sets the UNDO file\'s initial size\nin bytes; if not specified, the initial size default to 128M (128\nmegabytes). You may optionally follow size with a one-letter\nabbreviation for an order of magnitude, similar to those used in\nmy.cnf. Generally, this is one of the letters M (for megabytes) or G\n(for gigabytes).\n\nOn 32-bit systems, the maximum supported value for INITIAL_SIZE is 4G.\n(Bug#29186 (http://bugs.mysql.com/29186))\n\nBeginning with MySQL Cluster NDB 2.1.18, 6.3.24, and 7.0.4, the minimum\nallowed value for INITIAL_SIZE is 1M. (Bug#29574\n(http://bugs.mysql.com/29574))\n\n*Note*: WAIT is parsed but otherwise ignored, and so has no effect in\nMySQL 5.1 and MySQL Cluster NDB 6.x. It is intended for future\nexpansion.\n\nThe ENGINE parameter (required) determines the storage engine which is\nused by this log file group, with engine_name being the name of the\nstorage engine. In MySQL 5.1 and MySQL Cluster NDB 6.x, the only\naccepted values for engine_name are "NDBCLUSTER" and "NDB". The two\nvalues are equivalent.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/alter-logfile-group.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/alter-logfile-group.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (224,18,'&','Syntax:\n&\n\nBitwise AND:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html\n\n','mysql> SELECT 29 & 15;\n        -> 13\n','http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (225,30,'LOCALTIMESTAMP','Syntax:\nLOCALTIMESTAMP, LOCALTIMESTAMP()\n\nLOCALTIMESTAMP and LOCALTIMESTAMP() are synonyms for NOW().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (226,35,'CONVERT','Syntax:\nCONVERT(expr,type), CONVERT(expr USING transcoding_name)\n\nThe CONVERT() and CAST() functions take a value of one type and produce\na value of another type.\n\nThe type can be one of the following values:\n\no BINARY[(N)]\n\no CHAR[(N)]\n\no DATE\n\no DATETIME\n\no DECIMAL[(M[,D])]\n\no SIGNED [INTEGER]\n\no TIME\n\no UNSIGNED [INTEGER]\n\nBINARY produces a string with the BINARY data type. See\nhttp://dev.mysql.com/doc/refman/5.1/en/binary-varbinary.html for a\ndescription of how this affects comparisons. If the optional length N\nis given, BINARY(N) causes the cast to use no more than N bytes of the\nargument. Values shorter than N bytes are padded with 0x00 bytes to a\nlength of N.\n\nCHAR(N) causes the cast to use no more than N characters of the\nargument.\n\nCAST() and CONVERT(... USING ...) are standard SQL syntax. The\nnon-USING form of CONVERT() is ODBC syntax.\n\nCONVERT() with USING is used to convert data between different\ncharacter sets. In MySQL, transcoding names are the same as the\ncorresponding character set names. For example, this statement converts\nthe string \'abc\' in the default character set to the corresponding\nstring in the utf8 character set:\n\nSELECT CONVERT(\'abc\' USING utf8);\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/cast-functions.html\n\n','SELECT enum_col FROM tbl_name ORDER BY CAST(enum_col AS CHAR);\n','http://dev.mysql.com/doc/refman/5.1/en/cast-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (227,30,'ADDDATE','Syntax:\nADDDATE(date,INTERVAL expr unit), ADDDATE(expr,days)\n\nWhen invoked with the INTERVAL form of the second argument, ADDDATE()\nis a synonym for DATE_ADD(). The related function SUBDATE() is a\nsynonym for DATE_SUB(). For information on the INTERVAL unit argument,\nsee the discussion for DATE_ADD().\n\nmysql> SELECT DATE_ADD(\'2008-01-02\', INTERVAL 31 DAY);\n        -> \'2008-02-02\'\nmysql> SELECT ADDDATE(\'2008-01-02\', INTERVAL 31 DAY);\n        -> \'2008-02-02\'\n\nWhen invoked with the days form of the second argument, MySQL treats it\nas an integer number of days to be added to expr.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT ADDDATE(\'2008-01-02\', 31);\n        -> \'2008-02-02\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (228,22,'REPEAT LOOP','Syntax:\n[begin_label:] REPEAT\n    statement_list\nUNTIL search_condition\nEND REPEAT [end_label]\n\nThe statement list within a REPEAT statement is repeated until the\nsearch_condition is true. Thus, a REPEAT always enters the loop at\nleast once. statement_list consists of one or more statements, each\nterminated by a semicolon (;) statement delimiter.\n\nA REPEAT statement can be labeled. end_label cannot be given unless\nbegin_label also is present. If both are present, they must be the\nsame.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/repeat-statement.html\n\n','mysql> delimiter //\n\nmysql> CREATE PROCEDURE dorepeat(p1 INT)\n    -> BEGIN\n    ->   SET @x = 0;\n    ->   REPEAT SET @x = @x + 1; UNTIL @x > p1 END REPEAT;\n    -> END\n    -> //\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> CALL dorepeat(1000)//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @x//\n+------+\n| @x   |\n+------+\n| 1001 |\n+------+\n1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.1/en/repeat-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (229,37,'ALTER FUNCTION','Syntax:\nALTER FUNCTION func_name [characteristic ...]\n\ncharacteristic:\n    { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\n  | SQL SECURITY { DEFINER | INVOKER }\n  | COMMENT \'string\'\n\nThis statement can be used to change the characteristics of a stored\nfunction. More than one change may be specified in an ALTER FUNCTION\nstatement. However, you cannot change the parameters or body of a\nstored function using this statement; to make such changes, you must\ndrop and re-create the function using DROP FUNCTION and CREATE\nFUNCTION.\n\nYou must have the ALTER ROUTINE privilege for the function. (That\nprivilege is granted automatically to the function creator.) If binary\nlogging is enabled, the ALTER FUNCTION statement might also require the\nSUPER privilege, as described in\nhttp://dev.mysql.com/doc/refman/5.1/en/stored-programs-logging.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/alter-function.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/alter-function.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (230,20,'SMALLINT','SMALLINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA small integer. The signed range is -32768 to 32767. The unsigned\nrange is 0 to 65535.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (231,20,'DOUBLE PRECISION','DOUBLE PRECISION[(M,D)] [UNSIGNED] [ZEROFILL], REAL[(M,D)] [UNSIGNED]\n[ZEROFILL]\n\nThese types are synonyms for DOUBLE. Exception: If the REAL_AS_FLOAT\nSQL mode is enabled, REAL is a synonym for FLOAT rather than DOUBLE.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (232,35,'ORD','Syntax:\nORD(str)\n\nIf the leftmost character of the string str is a multi-byte character,\nreturns the code for that character, calculated from the numeric values\nof its constituent bytes using this formula:\n\n  (1st byte code)\n+ (2nd byte code x 256)\n+ (3rd byte code x 2562) ...\n\nIf the leftmost character is not a multi-byte character, ORD() returns\nthe same value as the ASCII() function.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT ORD(\'2\');\n        -> 50\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (233,25,'DEALLOCATE PREPARE','Syntax:\n{DEALLOCATE | DROP} PREPARE stmt_name\n\nTo deallocate a prepared statement produced with PREPARE, use a\nDEALLOCATE PREPARE statement that refers to the prepared statement\nname. Attempting to execute a prepared statement after deallocating it\nresults in an error.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/deallocate-prepare.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/deallocate-prepare.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (234,34,'ENVELOPE','Envelope(g)\n\nReturns the Minimum Bounding Rectangle (MBR) for the geometry value g.\nThe result is returned as a Polygon value.\n\nThe polygon is defined by the corner points of the bounding box:\n\nPOLYGON((MINX MINY, MAXX MINY, MAXX MAXY, MINX MAXY, MINX MINY))\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#general-geometry-property-functions\n\n','mysql> SELECT AsText(Envelope(GeomFromText(\'LineString(1 1,2 2)\')));\n+-------------------------------------------------------+\n| AsText(Envelope(GeomFromText(\'LineString(1 1,2 2)\'))) |\n+-------------------------------------------------------+\n| POLYGON((1 1,2 1,2 2,1 2,1 1))                        |\n+-------------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#general-geometry-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (235,14,'IS_FREE_LOCK','Syntax:\nIS_FREE_LOCK(str)\n\nChecks whether the lock named str is free to use (that is, not locked).\nReturns 1 if the lock is free (no one is using the lock), 0 if the lock\nis in use, and NULL if an error occurs (such as an incorrect argument).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (236,29,'TOUCHES','Touches(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially touches g2. Two\ngeometries spatially touch if the interiors of the geometries do not\nintersect, but the boundary of one of the geometries intersects either\nthe boundary or the interior of the other.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (237,14,'INET_ATON','Syntax:\nINET_ATON(expr)\n\nGiven the dotted-quad representation of a network address as a string,\nreturns an integer that represents the numeric value of the address.\nAddresses may be 4- or 8-byte addresses.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','mysql> SELECT INET_ATON(\'209.207.224.40\');\n        -> 3520061480\n','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (238,11,'UNCOMPRESS','Syntax:\nUNCOMPRESS(string_to_uncompress)\n\nUncompresses a string compressed by the COMPRESS() function. If the\nargument is not a compressed value, the result is NULL. This function\nrequires MySQL to have been compiled with a compression library such as\nzlib. Otherwise, the return value is always NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','mysql> SELECT UNCOMPRESS(COMPRESS(\'any string\'));\n        -> \'any string\'\nmysql> SELECT UNCOMPRESS(\'any string\');\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (239,20,'AUTO_INCREMENT','The AUTO_INCREMENT attribute can be used to generate a unique identity\nfor new rows:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/example-auto-increment.html\n\n','CREATE TABLE animals (\n     id MEDIUMINT NOT NULL AUTO_INCREMENT,\n     name CHAR(30) NOT NULL,\n     PRIMARY KEY (id)\n );\n\nINSERT INTO animals (name) VALUES\n    (\'dog\'),(\'cat\'),(\'penguin\'),\n    (\'lax\'),(\'whale\'),(\'ostrich\');\n\nSELECT * FROM animals;\n','http://dev.mysql.com/doc/refman/5.1/en/example-auto-increment.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (240,34,'ISSIMPLE','IsSimple(g)\n\nCurrently, this function is a placeholder and should not be used. If\nimplemented, its behavior will be as described in the next paragraph.\n\nReturns 1 if the geometry value g has no anomalous geometric points,\nsuch as self-intersection or self-tangency. IsSimple() returns 0 if the\nargument is not simple, and -1 if it is NULL.\n\nThe description of each instantiable geometric class given earlier in\nthe chapter includes the specific conditions that cause an instance of\nthat class to be classified as not simple. (See [HELP Geometry\nhierarchy].)\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#general-geometry-property-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#general-geometry-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (241,4,'- BINARY','Syntax:\n-\n\nSubtraction:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html\n\n','mysql> SELECT 3-5;\n        -> -2\n','http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (242,3,'GEOMCOLLFROMTEXT','GeomCollFromText(wkt[,srid]), GeometryCollectionFromText(wkt[,srid])\n\nConstructs a GEOMETRYCOLLECTION value using its WKT representation and\nSRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkt-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkt-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (243,3,'WKT DEFINITION','The Well-Known Text (WKT) representation of Geometry is designed to\nexchange geometry data in ASCII form.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-format.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/gis-wkt-format.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (244,30,'CURRENT_TIME','Syntax:\nCURRENT_TIME, CURRENT_TIME()\n\nCURRENT_TIME and CURRENT_TIME() are synonyms for CURTIME().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (245,9,'REVOKE','Syntax:\nREVOKE\n    priv_type [(column_list)]\n      [, priv_type [(column_list)]] ...\n    ON [object_type] priv_level\n    FROM user [, user] ...\n\nREVOKE ALL PRIVILEGES, GRANT OPTION\n    FROM user [, user] ...\n\nThe REVOKE statement enables system administrators to revoke privileges\nfrom MySQL accounts. Each account is named using the same format as for\nthe GRANT statement; for example, \'jeffrey\'@\'localhost\'. If you specify\nonly the user name part of the account name, a host name part of \'%\' is\nused. For details on the levels at which privileges exist, the\nallowable priv_type and priv_level values, and the syntax for\nspecifying users and passwords, see [HELP GRANT]\n\nTo use the first REVOKE syntax, you must have the GRANT OPTION\nprivilege, and you must have the privileges that you are revoking.\n\nTo revoke all privileges, use the second syntax, which drops all\nglobal, database, table, column, and routine privileges for the named\nuser or users:\n\nREVOKE ALL PRIVILEGES, GRANT OPTION FROM user [, user] ...\n\nTo use this REVOKE syntax, you must have the global CREATE USER\nprivilege or the UPDATE privilege for the mysql database.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/revoke.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/revoke.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (246,15,'LAST_INSERT_ID','Syntax:\nLAST_INSERT_ID(), LAST_INSERT_ID(expr)\n\nFor MySQL 5.1.12 and later, LAST_INSERT_ID() (no arguments) returns the\nfirst automatically generated value successfully inserted for an\nAUTO_INCREMENT column as a result of the most recently executed INSERT\nstatement. The value of LAST_INSERT_ID() remains unchanged if no rows\nare successfully inserted.\n\nFor example, after inserting a row that generates an AUTO_INCREMENT\nvalue, you can get the value like this:\n\nmysql> SELECT LAST_INSERT_ID();\n        -> 195\n\nIn MySQL 5.1.11 and earlier, LAST_INSERT_ID() (no arguments) returns\nthe first automatically generated value if any rows were successfully\ninserted or updated. This means that the returned value could be a\nvalue that was not successfully inserted into the table. If no rows\nwere successfully inserted, LAST_INSERT_ID() returns 0.\n\nThe value of LAST_INSERT_ID() will be consistent across all versions if\nall rows in the INSERT or UPDATE statement were successful.\n\nif a table contains an AUTO_INCREMENT column and INSERT ... ON\nDUPLICATE KEY UPDATE updates (rather than inserts) a row, the value of\nLAST_INSERT_ID() is not meaningful prior to MySQL 5.1.12. For a\nworkaround, see\nhttp://dev.mysql.com/doc/refman/5.1/en/insert-on-duplicate.html.\n\nThe currently executing statement does not affect the value of\nLAST_INSERT_ID(). Suppose that you generate an AUTO_INCREMENT value\nwith one statement, and then refer to LAST_INSERT_ID() in a\nmultiple-row INSERT statement that inserts rows into a table with its\nown AUTO_INCREMENT column. The value of LAST_INSERT_ID() will remain\nstable in the second statement; its value for the second and later rows\nis not affected by the earlier row insertions. (However, if you mix\nreferences to LAST_INSERT_ID() and LAST_INSERT_ID(expr), the effect is\nundefined.)\n\nIf the previous statement returned an error, the value of\nLAST_INSERT_ID() is undefined. For transactional tables, if the\nstatement is rolled back due to an error, the value of LAST_INSERT_ID()\nis left undefined. For manual ROLLBACK, the value of LAST_INSERT_ID()\nis not restored to that before the transaction; it remains as it was at\nthe point of the ROLLBACK.\n\nWithin the body of a stored routine (procedure or function) or a\ntrigger, the value of LAST_INSERT_ID() changes the same way as for\nstatements executed outside the body of these kinds of objects. The\neffect of a stored routine or trigger upon the value of\nLAST_INSERT_ID() that is seen by following statements depends on the\nkind of routine:\n\no If a stored procedure executes statements that change the value of\n  LAST_INSERT_ID(), the changed value will be seen by statements that\n  follow the procedure call.\n\no For stored functions and triggers that change the value, the value is\n  restored when the function or trigger ends, so following statements\n  will not see a changed value.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (247,30,'LAST_DAY','Syntax:\nLAST_DAY(date)\n\nTakes a date or datetime value and returns the corresponding value for\nthe last day of the month. Returns NULL if the argument is invalid.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT LAST_DAY(\'2003-02-05\');\n        -> \'2003-02-28\'\nmysql> SELECT LAST_DAY(\'2004-02-05\');\n        -> \'2004-02-29\'\nmysql> SELECT LAST_DAY(\'2004-01-01 01:01:01\');\n        -> \'2004-01-31\'\nmysql> SELECT LAST_DAY(\'2003-03-32\');\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (248,20,'MEDIUMINT','MEDIUMINT[(M)] [UNSIGNED] [ZEROFILL]\n\nA medium-sized integer. The signed range is -8388608 to 8388607. The\nunsigned range is 0 to 16777215.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (249,4,'FLOOR','Syntax:\nFLOOR(X)\n\nReturns the largest integer value not greater than X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT FLOOR(1.23);\n        -> 1\nmysql> SELECT FLOOR(-1.23);\n        -> -2\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (250,35,'RTRIM','Syntax:\nRTRIM(str)\n\nReturns the string str with trailing space characters removed.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT RTRIM(\'barbar   \');\n        -> \'barbar\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (251,27,'EXPLAIN','Syntax:\nEXPLAIN tbl_name\n\nOr:\n\nEXPLAIN [EXTENDED | PARTITIONS] SELECT select_options\n\nThe EXPLAIN statement can be used either as a synonym for DESCRIBE or\nas a way to obtain information about how MySQL executes a SELECT\nstatement:\n\no EXPLAIN tbl_name is synonymous with DESCRIBE tbl_name or SHOW COLUMNS\n  FROM tbl_name.\n\n  For a description of the DESCRIBE and SHOW COLUMNS statements, see\n  [HELP DESCRIBE], and [HELP SHOW COLUMNS].\n\no When you precede a SELECT statement with the keyword EXPLAIN, MySQL\n  displays information from the optimizer about the query execution\n  plan. That is, MySQL explains how it would process the SELECT,\n  including information about how tables are joined and in which order.\n  EXPLAIN EXTENDED can be used to provide additional information.\n\n  For information regarding the use of EXPLAIN and EXPLAIN EXTENDED for\n  obtaining query execution plan information, see\n  http://dev.mysql.com/doc/refman/5.1/en/using-explain.html.\n\no EXPLAIN PARTITIONS is available beginning with MySQL 5.1.5. It is\n  useful only when examining queries involving partitioned tables.\n\n  For details, see\n  http://dev.mysql.com/doc/refman/5.1/en/partitioning-info.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/explain.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/explain.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (252,4,'DEGREES','Syntax:\nDEGREES(X)\n\nReturns the argument X, converted from radians to degrees.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT DEGREES(PI());\n        -> 180\nmysql> SELECT DEGREES(PI() / 2);\n        -> 90\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (253,20,'VARCHAR','[NATIONAL] VARCHAR(M) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nA variable-length string. M represents the maximum column length in\ncharacters. The range of M is 0 to 65,535. The effective maximum length\nof a VARCHAR is subject to the maximum row size (65,535 bytes, which is\nshared among all columns) and the character set used. For example, utf8\ncharacters can require up to three bytes per character, so a VARCHAR\ncolumn that uses the utf8 character set can be declared to be a maximum\nof 21,844 characters.\n\nMySQL stores VARCHAR values as a one-byte or two-byte length prefix\nplus data. The length prefix indicates the number of bytes in the\nvalue. A VARCHAR column uses one length byte if values require no more\nthan 255 bytes, two length bytes if values may require more than 255\nbytes.\n\n*Note*: MySQL 5.1 follows the standard SQL specification, and does not\nremove trailing spaces from VARCHAR values.\n\nVARCHAR is shorthand for CHARACTER VARYING. NATIONAL VARCHAR is the\nstandard SQL way to define that a VARCHAR column should use some\npredefined character set. MySQL 4.1 and up uses utf8 as this predefined\ncharacter set.\nhttp://dev.mysql.com/doc/refman/5.1/en/charset-national.html. NVARCHAR\nis shorthand for NATIONAL VARCHAR.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (254,35,'UNHEX','Syntax:\n\nUNHEX(str)\n\nPerforms the inverse operation of HEX(str). That is, it interprets each\npair of hexadecimal digits in the argument as a number and converts it\nto the character represented by the number. The resulting characters\nare returned as a binary string.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT UNHEX(\'4D7953514C\');\n        -> \'MySQL\'\nmysql> SELECT 0x4D7953514C;\n        -> \'MySQL\'\nmysql> SELECT UNHEX(HEX(\'string\'));\n        -> \'string\'\nmysql> SELECT HEX(UNHEX(\'1267\'));\n        -> \'1267\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (255,4,'- UNARY','Syntax:\n-\n\nUnary minus. This operator changes the sign of the argument.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html\n\n','mysql> SELECT - 2;\n        -> -2\n','http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (256,22,'SELECT INTO','Syntax:\nSELECT col_name [, col_name] ...\n    INTO var_name [, var_name] ...\n    table_expr\n\nSELECT ... INTO syntax enables selected columns to be stored directly\ninto variables. The query should return a single row. If the query\nreturns no rows, a warning with error code 1329 occurs (No data), and\nthe variable values remain unchanged. If the query returns multiple\nrows, error 1172 occurs (Result consisted of more than one row). If it\nis possible that the statement may retrieve multiple rows, you can use\nLIMIT 1 to limit the result set to a single row.\n\nIn the context of such statements that occur as part of events executed\nby the Event Scheduler, diagnostics messages (not only errors, but also\nwarnings) are written to the error log, and, on Windows, to the\napplication event log. For additional information, see\nhttp://dev.mysql.com/doc/refman/5.1/en/events-status-info.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/select-into-statement.html\n\n','SELECT id,data INTO x,y FROM test.t1 LIMIT 1;\n','http://dev.mysql.com/doc/refman/5.1/en/select-into-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (257,16,'STD','Syntax:\nSTD(expr)\n\nReturns the population standard deviation of expr. This is an extension\nto standard SQL. The standard SQL function STDDEV_POP() can be used\ninstead.\n\nThis function returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (258,4,'COS','Syntax:\nCOS(X)\n\nReturns the cosine of X, where X is given in radians.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT COS(PI());\n        -> -1\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (259,30,'DATE FUNCTION','Syntax:\nDATE(expr)\n\nExtracts the date part of the date or datetime expression expr.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT DATE(\'2003-12-31 01:02:03\');\n        -> \'2003-12-31\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (260,37,'DROP TRIGGER','Syntax:\nDROP TRIGGER [IF EXISTS] [schema_name.]trigger_name\n\nThis statement drops a trigger. The schema (database) name is optional.\nIf the schema is omitted, the trigger is dropped from the default\nschema. DROP TRIGGER was added in MySQL 5.0.2. Its use requires the\nTRIGGER privilege for the table associated with the trigger. (This\nstatement requires the SUPER privilege prior to MySQL 5.1.6.)\n\nUse IF EXISTS to prevent an error from occurring for a trigger that\ndoes not exist. A NOTE is generated for a nonexistent trigger when\nusing IF EXISTS. See [HELP SHOW WARNINGS]. The IF EXISTS clause was\nadded in MySQL 5.1.14.\n\nTriggers for a table are also dropped if you drop the table.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-trigger.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-trigger.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (261,25,'RESET MASTER','Syntax:\nRESET MASTER\n\nDeletes all binary logs listed in the index file, resets the binary log\nindex file to be empty, and creates a new binary log file. It is\nintended to be used only when the master is started for the first time.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/reset-master.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/reset-master.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (262,4,'TAN','Syntax:\nTAN(X)\n\nReturns the tangent of X, where X is given in radians.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT TAN(PI());\n        -> -1.2246063538224e-16\nmysql> SELECT TAN(PI()+1);\n        -> 1.5574077246549\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (263,4,'PI','Syntax:\nPI()\n\nReturns the value of π (pi). The default number of decimal places\ndisplayed is seven, but MySQL uses the full double-precision value\ninternally.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT PI();\n        -> 3.141593\nmysql> SELECT PI()+0.000000000000000000;\n        -> 3.141592653589793116\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (264,30,'WEEKOFYEAR','Syntax:\nWEEKOFYEAR(date)\n\nReturns the calendar week of the date as a number in the range from 1\nto 53. WEEKOFYEAR() is a compatibility function that is equivalent to\nWEEK(date,3).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT WEEKOFYEAR(\'2008-02-20\');\n        -> 8\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (265,4,'/','Syntax:\n/\n\nDivision:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html\n\n','mysql> SELECT 3/5;\n        -> 0.60\n','http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (266,25,'PURGE BINARY LOGS','Syntax:\nPURGE { BINARY | MASTER } LOGS\n    { TO \'log_name\' | BEFORE datetime_expr }\n\nThe binary log is a set of files that contain information about data\nmodifications made by the MySQL server. The log consists of a set of\nbinary log files, plus an index file.\n\nThe PURGE BINARY LOGS statement deletes all the binary log files listed\nin the log index file prior to the specified log file name or date. The\nlog files also are removed from the list recorded in the index file, so\nthat the given log file becomes the first.\n\nThis statement has no effect if the --log-bin option has not been\nenabled.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/purge-binary-logs.html\n\n','PURGE BINARY LOGS TO \'mysql-bin.010\';\nPURGE BINARY LOGS BEFORE \'2008-04-02 22:46:26\';\n','http://dev.mysql.com/doc/refman/5.1/en/purge-binary-logs.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (267,16,'STDDEV_SAMP','Syntax:\nSTDDEV_SAMP(expr)\n\nReturns the sample standard deviation of expr (the square root of\nVAR_SAMP().\n\nSTDDEV_SAMP() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (268,15,'SCHEMA','Syntax:\nSCHEMA()\n\nThis function is a synonym for DATABASE().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (269,31,'MLINEFROMWKB','MLineFromWKB(wkb[,srid]), MultiLineStringFromWKB(wkb[,srid])\n\nConstructs a MULTILINESTRING value using its WKB representation and\nSRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkb-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkb-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (270,4,'LOG2','Syntax:\nLOG2(X)\n\nReturns the base-2 logarithm of X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT LOG2(65536);\n        -> 16\nmysql> SELECT LOG2(-100);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (271,30,'SUBTIME','Syntax:\nSUBTIME(expr1,expr2)\n\nSUBTIME() returns expr1 - expr2 expressed as a value in the same format\nas expr1. expr1 is a time or datetime expression, and expr2 is a time\nexpression.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT SUBTIME(\'2007-12-31 23:59:59.999999\',\'1 1:1:1.000002\');\n        -> \'2007-12-30 22:58:58.999997\'\nmysql> SELECT SUBTIME(\'01:00:00.999999\', \'02:00:00.999998\');\n        -> \'-00:59:59.999999\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (272,11,'UNCOMPRESSED_LENGTH','Syntax:\nUNCOMPRESSED_LENGTH(compressed_string)\n\nReturns the length that the compressed string had before being\ncompressed.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','mysql> SELECT UNCOMPRESSED_LENGTH(COMPRESS(REPEAT(\'a\',30)));\n        -> 30\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (273,37,'DROP TABLE','Syntax:\nDROP [TEMPORARY] TABLE [IF EXISTS]\n    tbl_name [, tbl_name] ...\n    [RESTRICT | CASCADE]\n\nDROP TABLE removes one or more tables. You must have the DROP privilege\nfor each table. All table data and the table definition are removed, so\nbe careful with this statement! If any of the tables named in the\nargument list do not exist, MySQL returns an error indicating by name\nwhich nonexisting tables it was unable to drop, but it also drops all\nof the tables in the list that do exist.\n\n*Important*: When a table is dropped, user privileges on the table are\nnot automatically dropped. See [HELP GRANT].\n\nNote that for a partitioned table, DROP TABLE permanently removes the\ntable definition, all of its partitions, and all of the data which was\nstored in those partitions. It also removes the partitioning definition\n(.par) file associated with the dropped table.\n\nUse IF EXISTS to prevent an error from occurring for tables that do not\nexist. A NOTE is generated for each nonexistent table when using IF\nEXISTS. See [HELP SHOW WARNINGS].\n\nRESTRICT and CASCADE are allowed to make porting easier. In MySQL 5.1,\nthey do nothing.\n\n*Note*: DROP TABLE automatically commits the current active\ntransaction, unless you use the TEMPORARY keyword.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (274,4,'POW','Syntax:\nPOW(X,Y)\n\nReturns the value of X raised to the power of Y.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT POW(2,2);\n        -> 4\nmysql> SELECT POW(2,-2);\n        -> 0.25\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (275,25,'SHOW CREATE TABLE','Syntax:\nSHOW CREATE TABLE tbl_name\n\nShows the CREATE TABLE statement that creates the given table. The\nstatement requires the SELECT privilege for the table. This statement\nalso works with views.\nSHOW CREATE TABLE quotes table and column names according to the value\nof the sql_quote_show_create option. See\nhttp://dev.mysql.com/doc/refman/5.1/en/server-session-variables.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-create-table.html\n\n','mysql> SHOW CREATE TABLE t\\G\n*************************** 1. row ***************************\n       Table: t\nCreate Table: CREATE TABLE t (\n  id INT(11) default NULL auto_increment,\n  s char(60) default NULL,\n  PRIMARY KEY (id)\n) ENGINE=MyISAM\n','http://dev.mysql.com/doc/refman/5.1/en/show-create-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (276,26,'DUAL','You are allowed to specify DUAL as a dummy table name in situations\nwhere no tables are referenced:\n\nmysql> SELECT 1 + 1 FROM DUAL;\n        -> 2\n\nDUAL is purely for the convenience of people who require that all\nSELECT statements should have FROM and possibly other clauses. MySQL\nmay ignore the clauses. MySQL does not require FROM DUAL if no tables\nare referenced.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/select.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/select.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (277,35,'INSTR','Syntax:\nINSTR(str,substr)\n\nReturns the position of the first occurrence of substring substr in\nstring str. This is the same as the two-argument form of LOCATE(),\nexcept that the order of the arguments is reversed.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT INSTR(\'foobarbar\', \'bar\');\n        -> 4\nmysql> SELECT INSTR(\'xbar\', \'foobar\');\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (278,30,'NOW','Syntax:\nNOW()\n\nReturns the current date and time as a value in \'YYYY-MM-DD HH:MM:SS\'\nor YYYYMMDDHHMMSS.uuuuuu format, depending on whether the function is\nused in a string or numeric context. The value is expressed in the\ncurrent time zone.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT NOW();\n        -> \'2007-12-15 23:50:26\'\nmysql> SELECT NOW() + 0;\n        -> 20071215235026.000000\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (279,25,'SHOW ENGINES','Syntax:\nSHOW [STORAGE] ENGINES\n\nSHOW ENGINES displays status information about the server\'s storage\nengines. This is particularly useful for checking whether a storage\nengine is supported, or to see what the default engine is. SHOW TABLE\nTYPES is a deprecated synonym.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-engines.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-engines.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (280,17,'>=','Syntax:\n>=\n\nGreater than or equal:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 2 >= 2;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (281,4,'EXP','Syntax:\nEXP(X)\n\nReturns the value of e (the base of natural logarithms) raised to the\npower of X. The inverse of this function is LOG() (using a single\nargument only) or LN().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT EXP(2);\n        -> 7.3890560989307\nmysql> SELECT EXP(-2);\n        -> 0.13533528323661\nmysql> SELECT EXP(0);\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (282,20,'LONGBLOB','LONGBLOB\n\nA BLOB column with a maximum length of 4,294,967,295 or 4GB (232 - 1)\nbytes. The effective maximum length of LONGBLOB columns depends on the\nconfigured maximum packet size in the client/server protocol and\navailable memory. Each LONGBLOB value is stored using a four-byte\nlength prefix that indicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (283,12,'POINTN','PointN(ls,N)\n\nReturns the N-th Point in the Linestring value ls. Points are numbered\nbeginning with 1.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#linestring-property-functions\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT AsText(PointN(GeomFromText(@ls),2));\n+-------------------------------------+\n| AsText(PointN(GeomFromText(@ls),2)) |\n+-------------------------------------+\n| POINT(2 2)                          |\n+-------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#linestring-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (284,20,'YEAR DATA TYPE','YEAR[(2|4)]\n\nA year in two-digit or four-digit format. The default is four-digit\nformat. In four-digit format, the allowable values are 1901 to 2155,\nand 0000. In two-digit format, the allowable values are 70 to 69,\nrepresenting years from 1970 to 2069. MySQL displays YEAR values in\nYYYY format, but allows you to assign values to YEAR columns using\neither strings or numbers.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (285,16,'SUM','Syntax:\nSUM([DISTINCT] expr)\n\nReturns the sum of expr. If the return set has no rows, SUM() returns\nNULL. The DISTINCT keyword can be used in MySQL 5.1 to sum only the\ndistinct values of expr.\n\nSUM() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (286,4,'OCT','Syntax:\nOCT(N)\n\nReturns a string representation of the octal value of N, where N is a\nlonglong (BIGINT) number. This is equivalent to CONV(N,10,8). Returns\nNULL if N is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT OCT(12);\n        -> \'14\'\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (287,30,'SYSDATE','Syntax:\nSYSDATE()\n\nReturns the current date and time as a value in \'YYYY-MM-DD HH:MM:SS\'\nor YYYYMMDDHHMMSS.uuuuuu format, depending on whether the function is\nused in a string or numeric context.\n\nSYSDATE() returns the time at which it executes. This differs from the\nbehavior for NOW(), which returns a constant time that indicates the\ntime at which the statement began to execute. (Within a stored function\nor trigger, NOW() returns the time at which the function or triggering\nstatement began to execute.)\n\nmysql> SELECT NOW(), SLEEP(2), NOW();\n+---------------------+----------+---------------------+\n| NOW()               | SLEEP(2) | NOW()               |\n+---------------------+----------+---------------------+\n| 2006-04-12 13:47:36 |        0 | 2006-04-12 13:47:36 |\n+---------------------+----------+---------------------+\n\nmysql> SELECT SYSDATE(), SLEEP(2), SYSDATE();\n+---------------------+----------+---------------------+\n| SYSDATE()           | SLEEP(2) | SYSDATE()           |\n+---------------------+----------+---------------------+\n| 2006-04-12 13:47:44 |        0 | 2006-04-12 13:47:46 |\n+---------------------+----------+---------------------+\n\nIn addition, the SET TIMESTAMP statement affects the value returned by\nNOW() but not by SYSDATE(). This means that timestamp settings in the\nbinary log have no effect on invocations of SYSDATE().\n\nBecause SYSDATE() can return different values even within the same\nstatement, and is not affected by SET TIMESTAMP, it is nondeterministic\nand therefore unsafe for replication if statement-based binary logging\nis used. If that is a problem, you can use row-based logging, or start\nthe server with the --sysdate-is-now option to cause SYSDATE() to be an\nalias for NOW(). The nondeterministic nature of SYSDATE() also means\nthat indexes cannot be used for evaluating expressions that refer to\nit.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (288,5,'UNINSTALL PLUGIN','Syntax:\nUNINSTALL PLUGIN plugin_name\n\nThis statement removes an installed plugin. You cannot uninstall a\nplugin if any table that uses it is open.\n\nplugin_name must be the name of some plugin that is listed in the\nmysql.plugin table. The server executes the plugin\'s deinitialization\nfunction and removes the row for the plugin from the mysql.plugin\ntable, so that subsequent server restarts will not load and initialize\nthe plugin. UNINSTALL PLUGIN does not remove the plugin\'s shared\nlibrary file.\n\nTo use UNINSTALL PLUGIN, you must have the DELETE privilege for the\nmysql.plugin table.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/uninstall-plugin.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/uninstall-plugin.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (289,31,'ASBINARY','AsBinary(g), AsWKB(g)\n\nConverts a value in internal geometry format to its WKB representation\nand returns the binary result.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-to-convert-geometries-between-formats.html\n\n','SELECT AsBinary(g) FROM geom;\n','http://dev.mysql.com/doc/refman/5.1/en/functions-to-convert-geometries-between-formats.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (290,35,'REPEAT FUNCTION','Syntax:\nREPEAT(str,count)\n\nReturns a string consisting of the string str repeated count times. If\ncount is less than 1, returns an empty string. Returns NULL if str or\ncount are NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT REPEAT(\'MySQL\', 3);\n        -> \'MySQLMySQLMySQL\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (291,25,'SHOW TABLES','Syntax:\nSHOW [FULL] TABLES [{FROM | IN} db_name]\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW TABLES lists the non-TEMPORARY tables in a given database. You can\nalso get this list using the mysqlshow db_name command. The LIKE\nclause, if present, indicates which table names to match. The WHERE\nclause can be given to select rows using more general conditions, as\ndiscussed in http://dev.mysql.com/doc/refman/5.1/en/extended-show.html.\n\nThis statement also lists any views in the database. The FULL modifier\nis supported such that SHOW FULL TABLES displays a second output\ncolumn. Values for the second column are BASE TABLE for a table and\nVIEW for a view.\n\nIf you have no privileges for a base table or view, it does not show up\nin the output from SHOW TABLES or mysqlshow db_name.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-tables.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-tables.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (292,30,'MAKEDATE','Syntax:\nMAKEDATE(year,dayofyear)\n\nReturns a date, given year and day-of-year values. dayofyear must be\ngreater than 0 or the result is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT MAKEDATE(2011,31), MAKEDATE(2011,32);\n        -> \'2011-01-31\', \'2011-02-01\'\nmysql> SELECT MAKEDATE(2011,365), MAKEDATE(2014,365);\n        -> \'2011-12-31\', \'2014-12-31\'\nmysql> SELECT MAKEDATE(2011,0);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (293,35,'BINARY OPERATOR','Syntax:\nBINARY\n\nThe BINARY operator casts the string following it to a binary string.\nThis is an easy way to force a column comparison to be done byte by\nbyte rather than character by character. This causes the comparison to\nbe case sensitive even if the column isn\'t defined as BINARY or BLOB.\nBINARY also causes trailing spaces to be significant.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/cast-functions.html\n\n','mysql> SELECT \'a\' = \'A\';\n        -> 1\nmysql> SELECT BINARY \'a\' = \'A\';\n        -> 0\nmysql> SELECT \'a\' = \'a \';\n        -> 1\nmysql> SELECT BINARY \'a\' = \'a \';\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/cast-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (294,6,'MBROVERLAPS','MBROverlaps(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 overlap. The term spatially overlaps is\nused if two geometries intersect and their intersection results in a\ngeometry of the same dimension but not equal to either of the given\ngeometries.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (295,35,'SOUNDEX','Syntax:\nSOUNDEX(str)\n\nReturns a soundex string from str. Two strings that sound almost the\nsame should have identical soundex strings. A standard soundex string\nis four characters long, but the SOUNDEX() function returns an\narbitrarily long string. You can use SUBSTRING() on the result to get a\nstandard soundex string. All nonalphabetic characters in str are\nignored. All international alphabetic characters outside the A-Z range\nare treated as vowels.\n\n*Important*: When using SOUNDEX(), you should be aware of the following\nlimitations:\n\no This function, as currently implemented, is intended to work well\n  with strings that are in the English language only. Strings in other\n  languages may not produce reliable results.\n\no This function is not guaranteed to provide consistent results with\n  strings that use multi-byte character sets, including utf-8.\n\n  We hope to remove these limitations in a future release. See\n  Bug#22638 (http://bugs.mysql.com/22638) for more information.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT SOUNDEX(\'Hello\');\n        -> \'H400\'\nmysql> SELECT SOUNDEX(\'Quadratically\');\n        -> \'Q36324\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (296,6,'MBRTOUCHES','MBRTouches(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 touch. Two geometries spatially touch if\nthe interiors of the geometries do not intersect, but the boundary of\none of the geometries intersects either the boundary or the interior of\nthe other.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (297,37,'DROP EVENT','Syntax:\nDROP EVENT [IF EXISTS] event_name\n\nThis statement drops the event named event_name. The event immediately\nceases being active, and is deleted completely from the server.\n\nIf the event does not exist, the error ERROR 1517 (HY000): Unknown\nevent \'event_name\' results. You can override this and cause the\nstatement to generate a warning for nonexistent events instead using IF\nEXISTS.\n\nBeginning with MySQL 5.1.12, this statement requires the EVENT\nprivilege for the schema to which the event to be dropped belongs. (In\nMySQL 5.1.11 and earlier, an event could be dropped only by its\ndefiner, or by a user having the SUPER privilege.)\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-event.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-event.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (298,26,'INSERT SELECT','Syntax:\nINSERT [LOW_PRIORITY | HIGH_PRIORITY] [IGNORE]\n    [INTO] tbl_name [(col_name,...)]\n    SELECT ...\n    [ ON DUPLICATE KEY UPDATE col_name=expr, ... ]\n\nWith INSERT ... SELECT, you can quickly insert many rows into a table\nfrom one or many tables. For example:\n\nINSERT INTO tbl_temp2 (fld_id)\n  SELECT tbl_temp1.fld_order_id\n  FROM tbl_temp1 WHERE tbl_temp1.fld_order_id > 100;\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/insert-select.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/insert-select.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (299,37,'CREATE PROCEDURE','Syntax:\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    PROCEDURE sp_name ([proc_parameter[,...]])\n    [characteristic ...] routine_body\n\nCREATE\n    [DEFINER = { user | CURRENT_USER }]\n    FUNCTION sp_name ([func_parameter[,...]])\n    RETURNS type\n    [characteristic ...] routine_body\n\nproc_parameter:\n    [ IN | OUT | INOUT ] param_name type\n\nfunc_parameter:\n    param_name type\n\ntype:\n    Any valid MySQL data type\n\ncharacteristic:\n    LANGUAGE SQL\n  | [NOT] DETERMINISTIC\n  | { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\n  | SQL SECURITY { DEFINER | INVOKER }\n  | COMMENT \'string\'\n\nroutine_body:\n    Valid SQL procedure statement\n\nThese statements create stored routines. By default, a routine is\nassociated with the default database. To associate the routine\nexplicitly with a given database, specify the name as db_name.sp_name\nwhen you create it.\n\nThe CREATE FUNCTION statement is also used in MySQL to support UDFs\n(user-defined functions). See\nhttp://dev.mysql.com/doc/refman/5.1/en/adding-functions.html. A UDF can\nbe regarded as an external stored function. However, do note that\nstored functions share their namespace with UDFs. See\nhttp://dev.mysql.com/doc/refman/5.1/en/function-resolution.html, for\nthe rules describing how the server interprets references to different\nkinds of functions.\n\nTo invoke a stored procedure, use the CALL statement (see [HELP CALL]).\nTo invoke a stored function, refer to it in an expression. The function\nreturns a value during expression evaluation.\n\nTo execute the CREATE PROCEDURE or CREATE FUNCTION statement, it is\nnecessary to have the CREATE ROUTINE privilege. By default, MySQL\nautomatically grants the ALTER ROUTINE and EXECUTE privileges to the\nroutine creator. This behavior can be changed by disabling the\nautomatic_sp_privileges system variable. See\nhttp://dev.mysql.com/doc/refman/5.1/en/stored-routines-privileges.html.\nIf binary logging is enabled, the CREATE FUNCTION statement might also\nrequire the SUPER privilege, as described in\nhttp://dev.mysql.com/doc/refman/5.1/en/stored-programs-logging.html.\n\nThe DEFINER and SQL SECURITY clauses specify the security context to be\nused when checking access privileges at routine execution time, as\ndescribed later.\n\nIf the routine name is the same as the name of a built-in SQL function,\na syntax error occurs unless you use a space between the name and the\nfollowing parenthesis when defining the routine or invoking it later.\nFor this reason, avoid using the names of existing SQL functions for\nyour own stored routines.\n\nThe IGNORE_SPACE SQL mode applies to built-in functions, not to stored\nroutines. It is always allowable to have spaces after a stored routine\nname, regardless of whether IGNORE_SPACE is enabled.\n\nThe parameter list enclosed within parentheses must always be present.\nIf there are no parameters, an empty parameter list of () should be\nused. Parameter names are not case sensitive.\n\nEach parameter is an IN parameter by default. To specify otherwise for\na parameter, use the keyword OUT or INOUT before the parameter name.\n\n*Note*: Specifying a parameter as IN, OUT, or INOUT is valid only for a\nPROCEDURE. (FUNCTION parameters are always regarded as IN parameters.)\n\nAn IN parameter passes a value into a procedure. The procedure might\nmodify the value, but the modification is not visible to the caller\nwhen the procedure returns. An OUT parameter passes a value from the\nprocedure back to the caller. Its initial value is NULL within the\nprocedure, and its value is visible to the caller when the procedure\nreturns. An INOUT parameter is initialized by the caller, can be\nmodified by the procedure, and any change made by the procedure is\nvisible to the caller when the procedure returns.\n\nFor each OUT or INOUT parameter, pass a user-defined variable in the\nCALL statement that invokes the procedure so that you can obtain its\nvalue when the procedure returns. If you are calling the procedure from\nwithin another stored procedure or function, you can also pass a\nroutine parameter or local routine variable as an IN or INOUT\nparameter.\n\nThe following example shows a simple stored procedure that uses an OUT\nparameter:\n\nmysql> delimiter //\n\nmysql> CREATE PROCEDURE simpleproc (OUT param1 INT)\n    -> BEGIN\n    ->   SELECT COUNT(*) INTO param1 FROM t;\n    -> END//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> delimiter ;\n\nmysql> CALL simpleproc(@a);\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @a;\n+------+\n| @a   |\n+------+\n| 3    |\n+------+\n1 row in set (0.00 sec)\n\nThe example uses the mysql client delimiter command to change the\nstatement delimiter from ; to // while the procedure is being defined.\nThis allows the ; delimiter used in the procedure body to be passed\nthrough to the server rather than being interpreted by mysql itself.\nSee\nhttp://dev.mysql.com/doc/refman/5.1/en/stored-programs-defining.html.\n\nThe RETURNS clause may be specified only for a FUNCTION, for which it\nis mandatory. It indicates the return type of the function, and the\nfunction body must contain a RETURN value statement. If the RETURN\nstatement returns a value of a different type, the value is coerced to\nthe proper type. For example, if a function specifies an ENUM or SET\nvalue in the RETURNS clause, but the RETURN statement returns an\ninteger, the value returned from the function is the string for the\ncorresponding ENUM member of set of SET members.\n\nThe following example function takes a parameter, performs an operation\nusing an SQL function, and returns the result. In this case, it is\nunnecessary to use delimiter because the function definition contains\nno internal ; statement delimiters:\n\nmysql> CREATE FUNCTION hello (s CHAR(20))\nmysql> RETURNS CHAR(50) DETERMINISTIC\n    -> RETURN CONCAT(\'Hello, \',s,\'!\');\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT hello(\'world\');\n+----------------+\n| hello(\'world\') |\n+----------------+\n| Hello, world!  |\n+----------------+\n1 row in set (0.00 sec)\n\nParameter types and function return types can be declared to use any\nvalid data type, except that the COLLATE attribute cannot be used.\n\nThe routine_body consists of a valid SQL procedure statement. This can\nbe a simple statement such as SELECT or INSERT, or it can be a compound\nstatement written using BEGIN and END. Compound statements can contain\ndeclarations, loops, and other control structure statements. The syntax\nfor these statements is described in\nhttp://dev.mysql.com/doc/refman/5.1/en/sql-syntax-compound-statements.h\ntml.\n\nMySQL allows routines to contain DDL statements, such as CREATE and\nDROP. MySQL also allows stored procedures (but not stored functions) to\ncontain SQL transaction statements such as COMMIT. Stored functions may\nnot contain statements that perform explicit or implicit commit or\nrollback. Support for these statements is not required by the SQL\nstandard, which states that each DBMS vendor may decide whether to\nallow them.\n\nStatements that return a result set can be used within a stored\nprocedcure but not within a stored function. This prohibition includes\nSELECT statements that do not have an INTO var_list clause and other\nstatements such as SHOW, EXPLAIN, and CHECK TABLE. For statements that\ncan be determined at function definition time to return a result set, a\nNot allowed to return a result set from a function error occurs\n(ER_SP_NO_RETSET). For statements that can be determined only at\nruntime to return a result set, a PROCEDURE %s can\'t return a result\nset in the given context error occurs (ER_SP_BADSELECT).\n\nUSE statements within stored routines are disallowed. When a routine is\ninvoked, an implicit USE db_name is performed (and undone when the\nroutine terminates). The causes the routine to have the given default\ndatabase while it executes. References to objects in databases other\nthan the routine default database should be qualified with the\nappropriate database name.\n\nFor additional information about statements that are not allowed in\nstored routines, see\nhttp://dev.mysql.com/doc/refman/5.1/en/stored-program-restrictions.html\n.\n\nFor information about invoking stored procedures from within programs\nwritten in a language that has a MySQL interface, see [HELP CALL].\n\nMySQL stores the sql_mode system variable setting that is in effect at\nthe time a routine is created, and always executes the routine with\nthis setting in force, regardless of the server SQL mode in effect when\nthe routine is invoked.\n\nThe switch from the SQL mode of the invoker to that of the routine\noccurs after evaluation of arguments and assignment of the resulting\nvalues to routine parameters. If you define a routine in strict SQL\nmode but invoke it in nonstrict mode, assignment of arguments to\nroutine parameters does not take place in strict mode. If you require\nthat expressions passed to a routine be assigned in strict SQL mode,\nyou should invoke the routine with strict mode in effect.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-procedure.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-procedure.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (300,20,'VARBINARY','VARBINARY(M)\n\nThe VARBINARY type is similar to the VARCHAR type, but stores binary\nbyte strings rather than nonbinary character strings. M represents the\nmaximum column length in bytes.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (301,25,'LOAD INDEX','Syntax:\nLOAD INDEX INTO CACHE\n  tbl_index_list [, tbl_index_list] ...\n\ntbl_index_list:\n  tbl_name\n    [[INDEX|KEY] (index_name[, index_name] ...)]\n    [IGNORE LEAVES]\n\nThe LOAD INDEX INTO CACHE statement preloads a table index into the key\ncache to which it has been assigned by an explicit CACHE INDEX\nstatement, or into the default key cache otherwise. LOAD INDEX INTO\nCACHE is used only for MyISAM tables. It is not supported for tables\nhaving user-defined partitioning (see\nhttp://dev.mysql.com/doc/refman/5.1/en/partitioning-limitations.html.)\n\nThe IGNORE LEAVES modifier causes only blocks for the nonleaf nodes of\nthe index to be preloaded.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/load-index.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/load-index.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (302,26,'UNION','Syntax:\nSELECT ...\nUNION [ALL | DISTINCT] SELECT ...\n[UNION [ALL | DISTINCT] SELECT ...]\n\nUNION is used to combine the result from multiple SELECT statements\ninto a single result set.\n\nThe column names from the first SELECT statement are used as the column\nnames for the results returned. Selected columns listed in\ncorresponding positions of each SELECT statement should have the same\ndata type. (For example, the first column selected by the first\nstatement should have the same type as the first column selected by the\nother statements.)\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/union.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/union.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (303,30,'TO_DAYS','Syntax:\nTO_DAYS(date)\n\nGiven a date date, returns a day number (the number of days since year\n0).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT TO_DAYS(950501);\n        -> 728779\nmysql> SELECT TO_DAYS(\'2007-10-07\');\n        -> 733321\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (304,35,'NOT REGEXP','Syntax:\nexpr NOT REGEXP pat, expr NOT RLIKE pat\n\nThis is the same as NOT (expr REGEXP pat).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/regexp.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/regexp.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (305,25,'SHOW INDEX','Syntax:\nSHOW {INDEX | INDEXES | KEYS}\n    {FROM | IN} tbl_name\n    [{FROM | IN} db_name]\n\nSHOW INDEX returns table index information. The format resembles that\nof the SQLStatistics call in ODBC.\nYou can use db_name.tbl_name as an alternative to the tbl_name FROM\ndb_name syntax. These two statements are equivalent:\n\nSHOW INDEX FROM mytable FROM mydb;\nSHOW INDEX FROM mydb.mytable;\n\nYou can also list a table\'s indexes with the mysqlshow -k db_name\ntbl_name command.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-index.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-index.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (306,25,'SHOW CREATE DATABASE','Syntax:\nSHOW CREATE {DATABASE | SCHEMA} db_name\n\nShows the CREATE DATABASE statement that creates the given database.\nSHOW CREATE SCHEMA is a synonym for SHOW CREATE DATABASE.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-create-database.html\n\n','mysql> SHOW CREATE DATABASE test\\G\n*************************** 1. row ***************************\n       Database: test\nCreate Database: CREATE DATABASE `test`\n                 /*!40100 DEFAULT CHARACTER SET latin1 */\n\nmysql> SHOW CREATE SCHEMA test\\G\n*************************** 1. row ***************************\n       Database: test\nCreate Database: CREATE DATABASE `test`\n                 /*!40100 DEFAULT CHARACTER SET latin1 */\n','http://dev.mysql.com/doc/refman/5.1/en/show-create-database.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (307,22,'LEAVE','Syntax:\nLEAVE label\n\nThis statement is used to exit the flow control construct that has the\ngiven label. It can be used within BEGIN ... END or loop constructs\n(LOOP, REPEAT, WHILE).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/leave-statement.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/leave-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (308,17,'NOT IN','Syntax:\nexpr NOT IN (value,...)\n\nThis is the same as NOT (expr IN (value,...)).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (309,13,'!','Syntax:\nNOT, !\n\nLogical NOT. Evaluates to 1 if the operand is 0, to 0 if the operand is\nnonzero, and NOT NULL returns NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/logical-operators.html\n\n','mysql> SELECT NOT 10;\n        -> 0\nmysql> SELECT NOT 0;\n        -> 1\nmysql> SELECT NOT NULL;\n        -> NULL\nmysql> SELECT ! (1+1);\n        -> 0\nmysql> SELECT ! 1+1;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/logical-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (310,22,'DECLARE HANDLER','Syntax:\nDECLARE handler_type HANDLER\n    FOR condition_value [, condition_value] ...\n    statement\n\nhandler_type:\n    CONTINUE\n  | EXIT\n  | UNDO\n\ncondition_value:\n    SQLSTATE [VALUE] sqlstate_value\n  | condition_name\n  | SQLWARNING\n  | NOT FOUND\n  | SQLEXCEPTION\n  | mysql_error_code\n\nThe DECLARE ... HANDLER statement specifies handlers that each may deal\nwith one or more conditions. If one of these conditions occurs, the\nspecified statement is executed. statement can be a simple statement\n(for example, SET var_name = value), or it can be a compound statement\nwritten using BEGIN and END (see [HELP BEGIN END]).\n\nFor a CONTINUE handler, execution of the current program continues\nafter execution of the handler statement. For an EXIT handler,\nexecution terminates for the BEGIN ... END compound statement in which\nthe handler is declared. (This is true even if the condition occurs in\nan inner block.) The UNDO handler type statement is not supported.\n\nIf a condition occurs for which no handler has been declared, the\ndefault action is EXIT.\n\nA condition_value for DECLARE ... HANDLER can be any of the following\nvalues:\n\no An SQLSTATE value (a 5-character string literal) or a MySQL error\n  code (a number). You should not use SQLSTATE value \'00000\' or MySQL\n  error code 0, because those indicate sucess rather than an error\n  condition. For a list of SQLSTATE values and MySQL error codes, see\n  http://dev.mysql.com/doc/refman/5.1/en/error-messages-server.html.\n\no A condition name previously specified with DECLARE ... CONDITION. See\n  [HELP DECLARE CONDITION].\n\no SQLWARNING is shorthand for the class of SQLSTATE values that begin\n  with \'01\'.\n\no NOT FOUND is shorthand for the class of SQLSTATE values that begin\n  with \'02\'. This is relevant only the context of cursors and is used\n  to control what happens when a cursor reaches the end of a data set.\n  If no more rows are available, a No Data condition occurs with\n  SQLSTATE value 02000. To detect this condition, you can set up a\n  handler for it (or for a NOT FOUND condition). An example is shown in\n  http://dev.mysql.com/doc/refman/5.1/en/cursors.html. This condition\n  also occurs for SELECT ... INTO var_list statements that retrieve no\n  rows.\n\no SQLEXCEPTION is shorthand for the class of SQLSTATE values that do\n  not begin with \'00\', \'01\', or \'02\'.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/declare-handler.html\n\n','mysql> CREATE TABLE test.t (s1 INT, PRIMARY KEY (s1));\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> delimiter //\n\nmysql> CREATE PROCEDURE handlerdemo ()\n    -> BEGIN\n    ->   DECLARE CONTINUE HANDLER FOR SQLSTATE \'23000\' SET @x2 = 1;\n    ->   SET @x = 1;\n    ->   INSERT INTO test.t VALUES (1);\n    ->   SET @x = 2;\n    ->   INSERT INTO test.t VALUES (1);\n    ->   SET @x = 3;\n    -> END;\n    -> //\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> CALL handlerdemo()//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT @x//\n    +------+\n    | @x   |\n    +------+\n    | 3    |\n    +------+\n    1 row in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.1/en/declare-handler.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (311,20,'DOUBLE','DOUBLE[(M,D)] [UNSIGNED] [ZEROFILL]\n\nA normal-size (double-precision) floating-point number. Allowable\nvalues are -1.7976931348623157E+308 to -2.2250738585072014E-308, 0, and\n2.2250738585072014E-308 to 1.7976931348623157E+308. These are the\ntheoretical limits, based on the IEEE standard. The actual range might\nbe slightly smaller depending on your hardware or operating system.\n\nM is the total number of digits and D is the number of digits following\nthe decimal point. If M and D are omitted, values are stored to the\nlimits allowed by the hardware. A double-precision floating-point\nnumber is accurate to approximately 15 decimal places.\n\nUNSIGNED, if specified, disallows negative values.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (312,20,'TIME','TIME\n\nA time. The range is \'-838:59:59\' to \'838:59:59\'. MySQL displays TIME\nvalues in \'HH:MM:SS\' format, but allows assignment of values to TIME\ncolumns using either strings or numbers.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (313,13,'&&','Syntax:\nAND, &&\n\nLogical AND. Evaluates to 1 if all operands are nonzero and not NULL,\nto 0 if one or more operands are 0, otherwise NULL is returned.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/logical-operators.html\n\n','mysql> SELECT 1 && 1;\n        -> 1\nmysql> SELECT 1 && 0;\n        -> 0\nmysql> SELECT 1 && NULL;\n        -> NULL\nmysql> SELECT 0 && NULL;\n        -> 0\nmysql> SELECT NULL && 0;\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/logical-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (314,10,'X','X(p)\n\nReturns the X-coordinate value for the point p as a double-precision\nnumber.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#point-property-functions\n\n','mysql> SET @pt = \'Point(56.7 53.34)\';\nmysql> SELECT X(GeomFromText(@pt));\n+----------------------+\n| X(GeomFromText(@pt)) |\n+----------------------+\n|                 56.7 |\n+----------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#point-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (315,15,'FOUND_ROWS','Syntax:\nFOUND_ROWS()\n\nA SELECT statement may include a LIMIT clause to restrict the number of\nrows the server returns to the client. In some cases, it is desirable\nto know how many rows the statement would have returned without the\nLIMIT, but without running the statement again. To obtain this row\ncount, include a SQL_CALC_FOUND_ROWS option in the SELECT statement,\nand then invoke FOUND_ROWS() afterward:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT SQL_CALC_FOUND_ROWS * FROM tbl_name\n    -> WHERE id > 100 LIMIT 10;\nmysql> SELECT FOUND_ROWS();\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (316,15,'SYSTEM_USER','Syntax:\nSYSTEM_USER()\n\nSYSTEM_USER() is a synonym for USER().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (317,29,'CROSSES','Crosses(g1,g2)\n\nReturns 1 if g1 spatially crosses g2. Returns NULL if g1 is a Polygon\nor a MultiPolygon, or if g2 is a Point or a MultiPoint. Otherwise,\nreturns 0.\n\nThe term spatially crosses denotes a spatial relation between two given\ngeometries that has the following properties:\n\no The two geometries intersect\n\no Their intersection results in a geometry that has a dimension that is\n  one less than the maximum dimension of the two given geometries\n\no Their intersection is not equal to either of the two given geometries\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (318,26,'TRUNCATE TABLE','Syntax:\nTRUNCATE [TABLE] tbl_name\n\nTRUNCATE TABLE empties a table completely. Logically, this is\nequivalent to a DELETE statement that deletes all rows, but there are\npractical differences under some circumstances.\n\nFor an InnoDB table, InnoDB processes TRUNCATE TABLE by deleting rows\none by one if there are any FOREIGN KEY constraints that reference the\ntable. If there are no FOREIGN KEY constraints, InnoDB performs fast\ntruncation by dropping the original table and creating an empty one\nwith the same definition, which is much faster than deleting rows one\nby one. The AUTO_INCREMENT counter is reset by TRUNCATE TABLE,\nregardless of whether there is a FOREIGN KEY constraint.\n\nIn the case that FOREIGN KEY constraints reference the table, InnoDB\ndeletes rows one by one and processes the constraints on each one. If\nthe FOREIGN KEY constraint specifies DELETE CASCADE, rows from the\nchild (referenced) table are deleted, and the truncated table becomes\nempty. If the FOREIGN KEY constraint does not specify CASCADE, the\nTRUNCATE statement deletes rows one by one and stops if it encounters a\nparent row that is referenced by the child, returning this error:\n\nERROR 1451 (23000): Cannot delete or update a parent row: a foreign\nkey constraint fails (`test`.`child`, CONSTRAINT `child_ibfk_1`\nFOREIGN KEY (`parent_id`) REFERENCES `parent` (`id`))\n\nThis is the same as a DELETE statement with no WHERE clause.\n\nBeginning with MySQL 5.1.32, TRUNCATE is treated for purposes of binary\nlogging and replication as DROP TABLE followed by CREATE TABLE --- that\nis, as DDL rather than DML. This is due to the fact that, when using\nInnoDB and other transactional storage engines where the transaction\nisolation level does not allow for statement-based logging (READ\nCOMMITTED or READ UNCOMMITTED), the statement was not logged and\nreplicated when using STATEMENT or MIXED logging mode. (Bug#36763\n(http://bugs.mysql.com/36763)) However, it is still applied on\nreplication slaves using InnoDB in the manner described previously.\n\nThe count of rows affected by TRUNCATE TABLE is accurate only when it\nis mapped to a DELETE statement.\n\nFor other storage engines, TRUNCATE TABLE differs from DELETE in the\nfollowing ways in MySQL 5.1:\n\no Truncate operations drop and re-create the table, which is much\n  faster than deleting rows one by one, particularly for large tables.\n\no Truncate operations cause an implicit commit.\n\no Truncation operations cannot be performed if the session holds an\n  active table lock.\n\no Truncation operations do not return a meaningful value for the number\n  of deleted rows. The usual result is "0 rows affected," which should\n  be interpreted as "no information."\n\no As long as the table format file tbl_name.frm is valid, the table can\n  be re-created as an empty table with TRUNCATE TABLE, even if the data\n  or index files have become corrupted.\n\no The table handler does not remember the last used AUTO_INCREMENT\n  value, but starts counting from the beginning. This is true even for\n  MyISAM and InnoDB, which normally do not reuse sequence values.\n\no When used with partitioned tables, TRUNCATE TABLE preserves the\n  partitioning; that is, the data and index files are dropped and\n  re-created, while the partition definitions (.par) file is\n  unaffected.\n\no Since truncation of a table does not make any use of DELETE, the\n  TRUNCATE statement does not invoke ON DELETE triggers.\n\nTRUNCATE TABLE requires the DROP privilege as of MySQL 5.1.16. (Before\n5.1.16, it requires the DELETE privilege.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/truncate.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/truncate.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (319,16,'BIT_XOR','Syntax:\nBIT_XOR(expr)\n\nReturns the bitwise XOR of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (320,30,'CURRENT_DATE','Syntax:\nCURRENT_DATE, CURRENT_DATE()\n\nCURRENT_DATE and CURRENT_DATE() are synonyms for CURDATE().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (321,25,'START SLAVE','Syntax:\nSTART SLAVE [thread_type [, thread_type] ... ]\nSTART SLAVE [SQL_THREAD] UNTIL\n    MASTER_LOG_FILE = \'log_name\', MASTER_LOG_POS = log_pos\nSTART SLAVE [SQL_THREAD] UNTIL\n    RELAY_LOG_FILE = \'log_name\', RELAY_LOG_POS = log_pos\n\nthread_type: IO_THREAD | SQL_THREAD\n\nSTART SLAVE with no thread_type options starts both of the slave\nthreads. The I/O thread reads queries from the master server and stores\nthem in the relay log. The SQL thread reads the relay log and executes\nthe queries. START SLAVE requires the SUPER privilege.\n\nIf START SLAVE succeeds in starting the slave threads, it returns\nwithout any error. However, even in that case, it might be that the\nslave threads start and then later stop (for example, because they do\nnot manage to connect to the master or read its binary logs, or some\nother problem). START SLAVE does not warn you about this. You must\ncheck the slave\'s error log for error messages generated by the slave\nthreads, or check that they are running satisfactorily with SHOW SLAVE\nSTATUS.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/start-slave.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/start-slave.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (322,2,'AREA','Area(poly)\n\nReturns as a double-precision number the area of the Polygon value\npoly, as measured in its spatial reference system.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#polygon-property-functions\n\n','mysql> SET @poly = \'Polygon((0 0,0 3,3 0,0 0),(1 1,1 2,2 1,1 1))\';\nmysql> SELECT Area(GeomFromText(@poly));\n+---------------------------+\n| Area(GeomFromText(@poly)) |\n+---------------------------+\n|                         4 |\n+---------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#polygon-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (323,22,'BEGIN END','Syntax:\n[begin_label:] BEGIN\n    [statement_list]\nEND [end_label]\n\nBEGIN ... END syntax is used for writing compound statements, which can\nappear within stored programs. A compound statement can contain\nmultiple statements, enclosed by the BEGIN and END keywords.\nstatement_list represents a list of one or more statements, each\nterminated by a semicolon (;) statement delimiter. statement_list is\noptional, which means that the empty compound statement (BEGIN END) is\nlegal.\n\nUse of multiple statements requires that a client is able to send\nstatement strings containing the ; statement delimiter. This is handled\nin the mysql command-line client with the delimiter command. Changing\nthe ; end-of-statement delimiter (for example, to //) allows ; to be\nused in a program body. For an example, see\nhttp://dev.mysql.com/doc/refman/5.1/en/stored-programs-defining.html.\n\nA compound statement can be labeled. end_label cannot be given unless\nbegin_label also is present. If both are present, they must be the\nsame.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/begin-end.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/begin-end.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (324,25,'FLUSH','Syntax:\nFLUSH [NO_WRITE_TO_BINLOG | LOCAL]\n    flush_option [, flush_option] ...\n\nThe FLUSH statement clears or reloads various internal caches used by\nMySQL. To execute FLUSH, you must have the RELOAD privilege.\n\nThe RESET statement is similar to FLUSH. See [HELP RESET].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/flush.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/flush.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (325,25,'SHOW PROCEDURE STATUS','Syntax:\nSHOW PROCEDURE STATUS\n    [LIKE \'pattern\' | WHERE expr]\n\nThis statement is a MySQL extension. It returns characteristics of a\nstored procedure, such as the database, name, type, creator, creation\nand modification dates, and character set information. A similar\nstatement, SHOW FUNCTION STATUS, displays information about stored\nfunctions (see [HELP SHOW FUNCTION STATUS]).\n\nThe LIKE clause, if present, indicates which procedure or function\nnames to match. The WHERE clause can be given to select rows using more\ngeneral conditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.1/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-procedure-status.html\n\n','mysql> SHOW PROCEDURE STATUS LIKE \'sp1\'\\G\n*************************** 1. row ***************************\n                  Db: test\n                Name: sp1\n                Type: PROCEDURE\n             Definer: testuser@localhost\n            Modified: 2004-08-03 15:29:37\n             Created: 2004-08-03 15:29:37\n       Security_type: DEFINER\n             Comment:\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n  Database Collation: latin1_swedish_ci\n','http://dev.mysql.com/doc/refman/5.1/en/show-procedure-status.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (326,25,'SHOW WARNINGS','Syntax:\nSHOW WARNINGS [LIMIT [offset,] row_count]\nSHOW COUNT(*) WARNINGS\n\nSHOW WARNINGS shows the error, warning, and note messages that resulted\nfrom the last statement that generated messages in the current session.\nIt shows nothing if the last statement used a table and generated no\nmessages. (That is, a statement that uses a table but generates no\nmessages clears the message list.) Statements that do not use tables\nand do not generate messages have no effect on the message list.\n\nWarnings are generated for DML statements such as INSERT, UPDATE, and\nLOAD DATA INFILE as well as DDL statements such as CREATE TABLE and\nALTER TABLE.\n\nA related statement, SHOW ERRORS, shows only the errors. See [HELP SHOW\nERRORS].\n\nThe SHOW COUNT(*) WARNINGS statement displays the total number of\nerrors, warnings, and notes. You can also retrieve this number from the\nwarning_count variable:\n\nSHOW COUNT(*) WARNINGS;\nSELECT @@warning_count;\n\nThe value of warning_count might be greater than the number of messages\ndisplayed by SHOW WARNINGS if the max_error_count system variable is\nset so low that not all messages are stored. An example shown later in\nthis section demonstrates how this can happen.\n\nThe LIMIT clause has the same syntax as for the SELECT statement. See\nhttp://dev.mysql.com/doc/refman/5.1/en/select.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-warnings.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-warnings.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (327,27,'DESCRIBE','Syntax:\n{DESCRIBE | DESC} tbl_name [col_name | wild]\n\nDESCRIBE provides information about the columns in a table. It is a\nshortcut for SHOW COLUMNS FROM. These statements also display\ninformation for views. (See [HELP SHOW COLUMNS].)\n\ncol_name can be a column name, or a string containing the SQL "%" and\n"_" wildcard characters to obtain output only for the columns with\nnames matching the string. There is no need to enclose the string\nwithin quotes unless it contains spaces or other special characters.\n\nmysql> DESCRIBE City;\n+------------+----------+------+-----+---------+----------------+\n| Field      | Type     | Null | Key | Default | Extra          |\n+------------+----------+------+-----+---------+----------------+\n| Id         | int(11)  | NO   | PRI | NULL    | auto_increment |\n| Name       | char(35) | NO   |     |         |                |\n| Country    | char(3)  | NO   | UNI |         |                |\n| District   | char(20) | YES  | MUL |         |                |\n| Population | int(11)  | NO   |     | 0       |                |\n+------------+----------+------+-----+---------+----------------+\n5 rows in set (0.00 sec)\n\nThe description for SHOW COLUMNS provides more information about the\noutput columns (see [HELP SHOW COLUMNS]).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/describe.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/describe.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (328,9,'DROP USER','Syntax:\nDROP USER user [, user] ...\n\nThe DROP USER statement removes one or more MySQL accounts. It removes\nprivilege rows for the account from all grant tables. To use this\nstatement, you must have the global CREATE USER privilege or the DELETE\nprivilege for the mysql database. Each account is named using the same\nformat as for the GRANT statement; for example, \'jeffrey\'@\'localhost\'.\nIf you specify only the user name part of the account name, a host name\npart of \'%\' is used. For additional information about specifying\naccount names, see [HELP GRANT].\n\nWith DROP USER, you can remove an account and its privileges as\nfollows:\n\nDROP USER user;\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-user.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-user.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (329,16,'STDDEV_POP','Syntax:\nSTDDEV_POP(expr)\n\nReturns the population standard deviation of expr (the square root of\nVAR_POP()). You can also use STD() or STDDEV(), which are equivalent\nbut not standard SQL.\n\nSTDDEV_POP() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (330,25,'SHOW CHARACTER SET','Syntax:\nSHOW CHARACTER SET\n    [LIKE \'pattern\' | WHERE expr]\n\nThe SHOW CHARACTER SET statement shows all available character sets.\nThe LIKE clause, if present, indicates which character set names to\nmatch. The WHERE clause can be given to select rows using more general\nconditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.1/en/extended-show.html. For example:\n\nmysql> SHOW CHARACTER SET LIKE \'latin%\';\n+---------+-----------------------------+-------------------+--------+\n| Charset | Description                 | Default collation | Maxlen |\n+---------+-----------------------------+-------------------+--------+\n| latin1  | cp1252 West European        | latin1_swedish_ci |      1 |\n| latin2  | ISO 8859-2 Central European | latin2_general_ci |      1 |\n| latin5  | ISO 8859-9 Turkish          | latin5_turkish_ci |      1 |\n| latin7  | ISO 8859-13 Baltic          | latin7_general_ci |      1 |\n+---------+-----------------------------+-------------------+--------+\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-character-set.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-character-set.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (331,35,'SUBSTRING','Syntax:\nSUBSTRING(str,pos), SUBSTRING(str FROM pos), SUBSTRING(str,pos,len),\nSUBSTRING(str FROM pos FOR len)\n\nThe forms without a len argument return a substring from string str\nstarting at position pos. The forms with a len argument return a\nsubstring len characters long from string str, starting at position\npos. The forms that use FROM are standard SQL syntax. It is also\npossible to use a negative value for pos. In this case, the beginning\nof the substring is pos characters from the end of the string, rather\nthan the beginning. A negative value may be used for pos in any of the\nforms of this function.\n\nFor all forms of SUBSTRING(), the position of the first character in\nthe string from which the substring is to be extracted is reckoned as\n1.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT SUBSTRING(\'Quadratically\',5);\n        -> \'ratically\'\nmysql> SELECT SUBSTRING(\'foobarbar\' FROM 4);\n        -> \'barbar\'\nmysql> SELECT SUBSTRING(\'Quadratically\',5,6);\n        -> \'ratica\'\nmysql> SELECT SUBSTRING(\'Sakila\', -3);\n        -> \'ila\'\nmysql> SELECT SUBSTRING(\'Sakila\', -5, 3);\n        -> \'aki\'\nmysql> SELECT SUBSTRING(\'Sakila\' FROM -4 FOR 2);\n        -> \'ki\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (332,34,'ISEMPTY','IsEmpty(g)\n\nReturns 1 if the geometry value g is the empty geometry, 0 if it is not\nempty, and -1 if the argument is NULL. If the geometry is empty, it\nrepresents the empty point set.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#general-geometry-property-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#general-geometry-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (333,25,'SHOW FUNCTION STATUS','Syntax:\nSHOW FUNCTION STATUS\n    [LIKE \'pattern\' | WHERE expr]\n\nThis statement is similar to SHOW PROCEDURE STATUS but for stored\nfunctions. See [HELP SHOW PROCEDURE STATUS].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-function-status.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-function-status.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (334,35,'LTRIM','Syntax:\nLTRIM(str)\n\nReturns the string str with leading space characters removed.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT LTRIM(\'  barbar\');\n        -> \'barbar\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (335,29,'INTERSECTS','Intersects(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 spatially intersects g2.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (336,26,'CALL','Syntax:\nCALL sp_name([parameter[,...]])\nCALL sp_name[()]\n\nThe CALL statement invokes a stored procedure that was defined\npreviously with CREATE PROCEDURE.\n\nAs of MySQL 5.1.13, stored procedures that take no arguments can be\ninvoked without parentheses. That is, CALL p() and CALL p are\nequivalent.\n\nCALL can pass back values to its caller using parameters that are\ndeclared as OUT or INOUT parameters. When the procedure returns, a\nclient program can also obtain the number of rows affected for the\nfinal statement executed within the routine: At the SQL level, call the\nROW_COUNT() function; from the C API, call the mysql_affected_rows()\nfunction.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/call.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/call.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (337,6,'MBRDISJOINT','MBRDisjoint(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangles of\nthe two geometries g1 and g2 are disjoint (do not intersect).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (338,14,'VALUES','Syntax:\nVALUES(col_name)\n\nIn an INSERT ... ON DUPLICATE KEY UPDATE statement, you can use the\nVALUES(col_name) function in the UPDATE clause to refer to column\nvalues from the INSERT portion of the statement. In other words,\nVALUES(col_name) in the UPDATE clause refers to the value of col_name\nthat would be inserted, had no duplicate-key conflict occurred. This\nfunction is especially useful in multiple-row inserts. The VALUES()\nfunction is meaningful only in INSERT ... ON DUPLICATE KEY UPDATE\nstatements and returns NULL otherwise.\nhttp://dev.mysql.com/doc/refman/5.1/en/insert-on-duplicate.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','mysql> INSERT INTO table (a,b,c) VALUES (1,2,3),(4,5,6)\n    -> ON DUPLICATE KEY UPDATE c=VALUES(a)+VALUES(b);\n','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (339,35,'SUBSTRING_INDEX','Syntax:\nSUBSTRING_INDEX(str,delim,count)\n\nReturns the substring from string str before count occurrences of the\ndelimiter delim. If count is positive, everything to the left of the\nfinal delimiter (counting from the left) is returned. If count is\nnegative, everything to the right of the final delimiter (counting from\nthe right) is returned. SUBSTRING_INDEX() performs a case-sensitive\nmatch when searching for delim.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT SUBSTRING_INDEX(\'www.mysql.com\', \'.\', 2);\n        -> \'www.mysql\'\nmysql> SELECT SUBSTRING_INDEX(\'www.mysql.com\', \'.\', -2);\n        -> \'mysql.com\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (340,11,'ENCODE','Syntax:\nENCODE(str,pass_str)\n\nEncrypt str using pass_str as the password. To decrypt the result, use\nDECODE().\n\nThe result is a binary string of the same length as str.\n\nThe strength of the encryption is based on how good the random\ngenerator is. It should suffice for short strings.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (341,22,'LOOP','Syntax:\n[begin_label:] LOOP\n    statement_list\nEND LOOP [end_label]\n\nLOOP implements a simple loop construct, enabling repeated execution of\nthe statement list, which consists of one or more statements, each\nterminated by a semicolon (;) statement delimiter. The statements\nwithin the loop are repeated until the loop is exited; usually this is\naccomplished with a LEAVE statement.\n\nA LOOP statement can be labeled. end_label cannot be given unless\nbegin_label also is present. If both are present, they must be the\nsame.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/loop-statement.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/loop-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (342,4,'TRUNCATE','Syntax:\nTRUNCATE(X,D)\n\nReturns the number X, truncated to D decimal places. If D is 0, the\nresult has no decimal point or fractional part. D can be negative to\ncause D digits left of the decimal point of the value X to become zero.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT TRUNCATE(1.223,1);\n        -> 1.2\nmysql> SELECT TRUNCATE(1.999,1);\n        -> 1.9\nmysql> SELECT TRUNCATE(1.999,0);\n        -> 1\nmysql> SELECT TRUNCATE(-1.999,1);\n        -> -1.9\nmysql> SELECT TRUNCATE(122,-2);\n       -> 100\nmysql> SELECT TRUNCATE(10.28*100,0);\n       -> 1028\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (343,30,'TIMESTAMPADD','Syntax:\nTIMESTAMPADD(unit,interval,datetime_expr)\n\nAdds the integer expression interval to the date or datetime expression\ndatetime_expr. The unit for interval is given by the unit argument,\nwhich should be one of the following values: FRAC_SECOND\n(microseconds), SECOND, MINUTE, HOUR, DAY, WEEK, MONTH, QUARTER, or\nYEAR.\n\nBeginning with MySQL 5.1.24, it is possible to use MICROSECOND in place\nof FRAC_SECOND with this function, and FRAC_SECOND is deprecated.\n\nThe unit value may be specified using one of keywords as shown, or with\na prefix of SQL_TSI_. For example, DAY and SQL_TSI_DAY both are legal.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT TIMESTAMPADD(MINUTE,1,\'2003-01-02\');\n        -> \'2003-01-02 00:01:00\'\nmysql> SELECT TIMESTAMPADD(WEEK,1,\'2003-01-02\');\n        -> \'2003-01-09\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (344,25,'SHOW','SHOW has many forms that provide information about databases, tables,\ncolumns, or status information about the server. This section describes\nthose following:\n\nSHOW AUTHORS\nSHOW CHARACTER SET [like_or_where]\nSHOW COLLATION [like_or_where]\nSHOW [FULL] COLUMNS FROM tbl_name [FROM db_name] [like_or_where]\nSHOW CONTRIBUTORS\nSHOW CREATE DATABASE db_name\nSHOW CREATE EVENT event_name\nSHOW CREATE FUNCTION func_name\nSHOW CREATE PROCEDURE proc_name\nSHOW CREATE TABLE tbl_name\nSHOW CREATE TRIGGER trigger_name\nSHOW CREATE VIEW view_name\nSHOW DATABASES [like_or_where]\nSHOW ENGINE engine_name {STATUS | MUTEX}\nSHOW [STORAGE] ENGINES\nSHOW ERRORS [LIMIT [offset,] row_count]\nSHOW [FULL] EVENTS\nSHOW FUNCTION CODE func_name\nSHOW FUNCTION STATUS [like_or_where]\nSHOW GRANTS FOR user\nSHOW INDEX FROM tbl_name [FROM db_name]\nSHOW INNODB STATUS\nSHOW OPEN TABLES [FROM db_name] [like_or_where]\nSHOW PLUGINS\nSHOW PROCEDURE CODE proc_name\nSHOW PROCEDURE STATUS [like_or_where]\nSHOW PRIVILEGES\nSHOW [FULL] PROCESSLIST\nSHOW PROFILE [types] [FOR QUERY n] [OFFSET n] [LIMIT n]\nSHOW PROFILES\nSHOW SCHEDULER STATUS\nSHOW [GLOBAL | SESSION] STATUS [like_or_where]\nSHOW TABLE STATUS [FROM db_name] [like_or_where]\nSHOW TABLES [FROM db_name] [like_or_where]\nSHOW TRIGGERS [FROM db_name] [like_or_where]\nSHOW [GLOBAL | SESSION] VARIABLES [like_or_where]\nSHOW WARNINGS [LIMIT [offset,] row_count]\n\nlike_or_where:\n    LIKE \'pattern\'\n  | WHERE expr\n\nIf the syntax for a given SHOW statement includes a LIKE \'pattern\'\npart, \'pattern\' is a string that can contain the SQL "%" and "_"\nwildcard characters. The pattern is useful for restricting statement\noutput to matching values.\n\nSeveral SHOW statements also accept a WHERE clause that provides more\nflexibility in specifying which rows to display. See\nhttp://dev.mysql.com/doc/refman/5.1/en/extended-show.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (345,17,'GREATEST','Syntax:\nGREATEST(value1,value2,...)\n\nWith two or more arguments, returns the largest (maximum-valued)\nargument. The arguments are compared using the same rules as for\nLEAST().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT GREATEST(2,0);\n        -> 2\nmysql> SELECT GREATEST(34.0,3.0,5.0,767.0);\n        -> 767.0\nmysql> SELECT GREATEST(\'B\',\'A\',\'C\');\n        -> \'C\'\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (346,25,'SHOW VARIABLES','Syntax:\nSHOW [GLOBAL | SESSION] VARIABLES\n    [LIKE \'pattern\' | WHERE expr]\n\nSHOW VARIABLES shows the values of MySQL system variables. This\ninformation also can be obtained using the mysqladmin variables\ncommand. The LIKE clause, if present, indicates which variable names to\nmatch. The WHERE clause can be given to select rows using more general\nconditions, as discussed in\nhttp://dev.mysql.com/doc/refman/5.1/en/extended-show.html. This\nstatement does not require any privilege. It requires only the ability\nto connect to the server.\n\nWith the GLOBAL modifier, SHOW VARIABLES displays the values that are\nused for new connections to MySQL. With SESSION, it displays the values\nthat are in effect for the current connection. If no modifier is\npresent, the default is SESSION. LOCAL is a synonym for SESSION.\nWith a LIKE clause, the statement displays only rows for those\nvariables with names that match the pattern. To obtain the row for a\nspecific variable, use a LIKE clause as shown:\n\nSHOW VARIABLES LIKE \'max_join_size\';\nSHOW SESSION VARIABLES LIKE \'max_join_size\';\n\nTo get a list of variables whose name match a pattern, use the "%"\nwildcard character in a LIKE clause:\n\nSHOW VARIABLES LIKE \'%size%\';\nSHOW GLOBAL VARIABLES LIKE \'%size%\';\n\nWildcard characters can be used in any position within the pattern to\nbe matched. Strictly speaking, because "_" is a wildcard that matches\nany single character, you should escape it as "\\_" to match it\nliterally. In practice, this is rarely necessary.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-variables.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-variables.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (347,25,'BINLOG','Syntax:\nBINLOG \'str\'\n\nBINLOG is an internal-use statement. It is generated by the mysqlbinlog\nprogram as the printable representation of certain events in binary log\nfiles. (See http://dev.mysql.com/doc/refman/5.1/en/mysqlbinlog.html.)\nThe \'str\' value is a base 64-encoded string the that server decodes to\ndetermine the data change indicated by the corresponding event. This\nstatement requires the SUPER privilege. It was added in MySQL 5.1.5.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/binlog.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/binlog.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (348,16,'BIT_AND','Syntax:\nBIT_AND(expr)\n\nReturns the bitwise AND of all bits in expr. The calculation is\nperformed with 64-bit (BIGINT) precision.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (349,30,'SECOND','Syntax:\nSECOND(time)\n\nReturns the second for time, in the range 0 to 59.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT SECOND(\'10:05:03\');\n        -> 3\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (350,4,'ATAN2','Syntax:\nATAN(Y,X), ATAN2(Y,X)\n\nReturns the arc tangent of the two variables X and Y. It is similar to\ncalculating the arc tangent of Y / X, except that the signs of both\narguments are used to determine the quadrant of the result.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT ATAN(-2,2);\n        -> -0.78539816339745\nmysql> SELECT ATAN2(PI(),0);\n        -> 1.5707963267949\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (351,6,'MBRCONTAINS','MBRContains(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\ncontains the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRWithin().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html\n\n','mysql> SET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nmysql> SET @g2 = GeomFromText(\'Point(1 1)\');\nmysql> SELECT MBRContains(@g1,@g2), MBRContains(@g2,@g1);\n----------------------+----------------------+\n| MBRContains(@g1,@g2) | MBRContains(@g2,@g1) |\n+----------------------+----------------------+\n|                    1 |                    0 |\n+----------------------+----------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (352,30,'HOUR','Syntax:\nHOUR(time)\n\nReturns the hour for time. The range of the return value is 0 to 23 for\ntime-of-day values. However, the range of TIME values actually is much\nlarger, so HOUR can return values greater than 23.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT HOUR(\'10:05:03\');\n        -> 10\nmysql> SELECT HOUR(\'272:59:59\');\n        -> 272\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (353,26,'SELECT','Syntax:\nSELECT\n    [ALL | DISTINCT | DISTINCTROW ]\n      [HIGH_PRIORITY]\n      [STRAIGHT_JOIN]\n      [SQL_SMALL_RESULT] [SQL_BIG_RESULT] [SQL_BUFFER_RESULT]\n      [SQL_CACHE | SQL_NO_CACHE] [SQL_CALC_FOUND_ROWS]\n    select_expr [, select_expr ...]\n    [FROM table_references\n    [WHERE where_condition]\n    [GROUP BY {col_name | expr | position}\n      [ASC | DESC], ... [WITH ROLLUP]]\n    [HAVING where_condition]\n    [ORDER BY {col_name | expr | position}\n      [ASC | DESC], ...]\n    [LIMIT {[offset,] row_count | row_count OFFSET offset}]\n    [PROCEDURE procedure_name(argument_list)]\n    [INTO OUTFILE \'file_name\'\n        [CHARACTER SET charset_name]\n        export_options\n      | INTO DUMPFILE \'file_name\'\n      | INTO var_name [, var_name]]\n    [FOR UPDATE | LOCK IN SHARE MODE]]\n\nSELECT is used to retrieve rows selected from one or more tables, and\ncan include UNION statements and subqueries. See [HELP UNION], and\nhttp://dev.mysql.com/doc/refman/5.1/en/subqueries.html.\n\nThe most commonly used clauses of SELECT statements are these:\n\no Each select_expr indicates a column that you want to retrieve. There\n  must be at least one select_expr.\n\no table_references indicates the table or tables from which to retrieve\n  rows. Its syntax is described in [HELP JOIN].\n\no The WHERE clause, if given, indicates the condition or conditions\n  that rows must satisfy to be selected. where_condition is an\n  expression that evaluates to true for each row to be selected. The\n  statement selects all rows if there is no WHERE clause.\n\n  In the WHERE clause, you can use any of the functions and operators\n  that MySQL supports, except for aggregate (summary) functions. See\n  http://dev.mysql.com/doc/refman/5.1/en/functions.html.\n\nSELECT can also be used to retrieve rows computed without reference to\nany table.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/select.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/select.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (354,4,'COT','Syntax:\nCOT(X)\n\nReturns the cotangent of X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT COT(12);\n        -> -1.5726734063977\nmysql> SELECT COT(0);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (355,25,'SHOW CREATE EVENT','Syntax:\nSHOW CREATE EVENT event_name\n\nThis statement displays the CREATE EVENT statement needed to re-create\na given event. For example (using the same event e_daily defined and\nthen altered in [HELP SHOW EVENTS]):\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-create-event.html\n\n','mysql> SHOW CREATE EVENT test.e_daily\\G\n*************************** 1. row ***************************\n               Event: e_daily\n            sql_mode:\n           time_zone: SYSTEM\n        Create Event: CREATE EVENT `e_daily`\n                        ON SCHEDULE EVERY 1 DAY\n                        STARTS CURRENT_TIMESTAMP + INTERVAL 6 HOUR\n                        ON COMPLETION NOT PRESERVE\n                        ENABLE\n                        COMMENT \'Saves total number of sessions then\n                                clears the table each day\'\n                        DO BEGIN\n                          INSERT INTO site_activity.totals (time, total)\n                            SELECT CURRENT_TIMESTAMP, COUNT(*)\n                            FROM site_activity.sessions;\n                          DELETE FROM site_activity.sessions;\n                        END\ncharacter_set_client: latin1\ncollation_connection: latin1_swedish_ci\n  Database Collation: latin1_swedish_ci\n','http://dev.mysql.com/doc/refman/5.1/en/show-create-event.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (356,19,'BACKUP TABLE','Syntax:\nBACKUP TABLE tbl_name [, tbl_name] ... TO \'/path/to/backup/directory\'\n\n*Note*: This statement is deprecated. We are working on a better\nreplacement for it that will provide online backup capabilities. In the\nmeantime, the mysqlhotcopy script can be used instead.\n\nBACKUP TABLE copies to the backup directory the minimum number of table\nfiles needed to restore the table, after flushing any buffered changes\nto disk. The statement works only for MyISAM tables. It copies the .frm\ndefinition and .MYD data files. The .MYI index file can be rebuilt from\nthose two files. The directory should be specified as a full path name.\nTo restore the table, use RESTORE TABLE.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/backup-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/backup-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (357,35,'LOAD_FILE','Syntax:\nLOAD_FILE(file_name)\n\nReads the file and returns the file contents as a string. To use this\nfunction, the file must be located on the server host, you must specify\nthe full path name to the file, and you must have the FILE privilege.\nThe file must be readable by all and its size less than\nmax_allowed_packet bytes. If the secure_file_priv system variable is\nset to a nonempty directory name, the file to be loaded must be located\nin that directory.\n\nIf the file does not exist or cannot be read because one of the\npreceding conditions is not satisfied, the function returns NULL.\n\nAs of MySQL 5.1.6, the character_set_filesystem system variable\ncontrols interpretation of file names that are given as literal\nstrings.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> UPDATE t\n            SET blob_col=LOAD_FILE(\'/tmp/picture\')\n            WHERE id=1;\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (358,25,'LOAD TABLE FROM MASTER','Syntax:\nLOAD TABLE tbl_name FROM MASTER\n\nThis feature is deprecated and should be avoided. It is subject to\nremoval in a future version of MySQL.\n\nSince the current implementation of LOAD DATA FROM MASTER and LOAD\nTABLE FROM MASTER is very limited, these statements are deprecated in\nversions 4.1 of MySQL and above. We will introduce a more advanced\ntechnique (called "online backup") in a future version. That technique\nwill have the additional advantage of working with more storage\nengines.\n\nFor MySQL 5.1 and earlier, the recommended alternative solution to\nusing LOAD DATA FROM MASTER or LOAD TABLE FROM MASTER is using\nmysqldump or mysqlhotcopy. The latter requires Perl and two Perl\nmodules (DBI and DBD:mysql) and works for MyISAM and ARCHIVE tables\nonly. With mysqldump, you can create SQL dumps on the master and pipe\n(or copy) these to a mysql client on the slave. This has the advantage\nof working for all storage engines, but can be quite slow, since it\nworks using SELECT.\n\nTransfers a copy of the table from the master to the slave. This\nstatement is implemented mainly debugging LOAD DATA FROM MASTER\noperations. To use LOAD TABLE, the account used for connecting to the\nmaster server must have the RELOAD and SUPER privileges on the master\nand the SELECT privilege for the master table to load. On the slave\nside, the user that issues LOAD TABLE FROM MASTER must have privileges\nfor dropping and creating the table.\n\nThe conditions for LOAD DATA FROM MASTER apply here as well. For\nexample, LOAD TABLE FROM MASTER works only for MyISAM tables. The\ntimeout notes for LOAD DATA FROM MASTER apply as well.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/load-table-from-master.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/load-table-from-master.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (359,3,'POINTFROMTEXT','PointFromText(wkt[,srid])\n\nConstructs a POINT value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkt-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkt-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (360,16,'GROUP_CONCAT','Syntax:\nGROUP_CONCAT(expr)\n\nThis function returns a string result with the concatenated non-NULL\nvalues from a group. It returns NULL if there are no non-NULL values.\nThe full syntax is as follows:\n\nGROUP_CONCAT([DISTINCT] expr [,expr ...]\n             [ORDER BY {unsigned_integer | col_name | expr}\n                 [ASC | DESC] [,col_name ...]]\n             [SEPARATOR str_val])\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','mysql> SELECT student_name,\n    ->     GROUP_CONCAT(test_score)\n    ->     FROM student\n    ->     GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (361,30,'DATE_FORMAT','Syntax:\nDATE_FORMAT(date,format)\n\nFormats the date value according to the format string.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT DATE_FORMAT(\'2009-10-04 22:23:00\', \'%W %M %Y\');\n        -> \'Sunday October 2009\'\nmysql> SELECT DATE_FORMAT(\'2007-10-04 22:23:00\', \'%H:%i:%s\');\n        -> \'22:23:00\'\nmysql> SELECT DATE_FORMAT(\'1900-10-04 22:23:00\',\n    ->                 \'%D %y %a %d %m %b %j\');\n        -> \'4th 00 Thu 04 10 Oct 277\'\nmysql> SELECT DATE_FORMAT(\'1997-10-04 22:23:00\',\n    ->                 \'%H %k %I %r %T %S %w\');\n        -> \'22 22 10 10:23:00 PM 22:23:00 00 6\'\nmysql> SELECT DATE_FORMAT(\'1999-01-01\', \'%X %V\');\n        -> \'1998 52\'\nmysql> SELECT DATE_FORMAT(\'2006-06-00\', \'%d\');\n        -> \'00\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (362,15,'BENCHMARK','Syntax:\nBENCHMARK(count,expr)\n\nThe BENCHMARK() function executes the expression expr repeatedly count\ntimes. It may be used to time how quickly MySQL processes the\nexpression. The result value is always 0. The intended use is from\nwithin the mysql client, which reports query execution times:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\'));\n+----------------------------------------------+\n| BENCHMARK(1000000,ENCODE(\'hello\',\'goodbye\')) |\n+----------------------------------------------+\n|                                            0 |\n+----------------------------------------------+\n1 row in set (4.74 sec)\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (363,30,'YEAR','Syntax:\nYEAR(date)\n\nReturns the year for date, in the range 1000 to 9999, or 0 for the\n"zero" date.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT YEAR(\'1987-01-01\');\n        -> 1987\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (364,25,'SHOW ENGINE','Syntax:\nSHOW ENGINE engine_name {STATUS | MUTEX}\n\nSHOW ENGINE displays operational information about a storage engine.\nThe following statements currently are supported:\n\nSHOW ENGINE INNODB STATUS\nSHOW ENGINE INNODB MUTEX\nSHOW ENGINE {NDB | NDBCLUSTER} STATUS\n\nOlder (and now deprecated) synonyms are SHOW INNODB STATUS for SHOW\nENGINE INNODB STATUS and SHOW MUTEX STATUS for SHOW ENGINE INNODB\nMUTEX.\n\nIn MySQL 5.0, SHOW ENGINE INNODB MUTEX is invoked as SHOW MUTEX STATUS.\nThe latter statement displays similar information but in a somewhat\ndifferent output format.\n\nSHOW ENGINE BDB LOGS formerly displayed status information about BDB\nlog files. As of MySQL 5.1.12, the BDB storage engine is not supported,\nand this statement produces a warning.\n\nSHOW ENGINE INNODB STATUS displays extensive information from the\nstandard InnoDB Monitor about the state of the InnoDB storage engine.\nFor information about the standard monitor and other InnoDB Monitors\nthat provide information about InnoDB processing, see\nhttp://dev.mysql.com/doc/refman/5.1/en/innodb-monitors.html.\n\nSHOW ENGINE INNODB MUTEX displays InnoDB mutex statistics. From MySQL\n5.1.2 to 5.1.14, the statement displays the following output fields:\n\no Type\n\n  Always InnoDB.\n\no Name\n\n  The mutex name and the source file where it is implemented. Example:\n  &pool->mutex:mem0pool.c\n\n  The mutex name indicates its purpose. For example, the log_sys mutex\n  is used by the InnoDB logging subsystem and indicates how intensive\n  logging activity is. The buf_pool mutex protects the InnoDB buffer\n  pool.\n\no Status\n\n  The mutex status. The fields contains several values:\n\n  o count indicates how many times the mutex was requested.\n\n  o spin_waits indicates how many times the spinlock had to run.\n\n  o spin_rounds indicates the number of spinlock rounds. (spin_rounds\n    divided by spin_waits provides the average round count.)\n\n  o os_waits indicates the number of operating system waits. This\n    occurs when the spinlock did not work (the mutex was not locked\n    during the spinlock and it was necessary to yield to the operating\n    system and wait).\n\n  o os_yields indicates the number of times a the thread trying to lock\n    a mutex gave up its timeslice and yielded to the operating system\n    (on the presumption that allowing other threads to run will free\n    the mutex so that it can be locked).\n\n  o os_wait_times indicates the amount of time (in ms) spent in\n    operating system waits, if the timed_mutexes system variable is 1\n    (ON). If timed_mutexes is 0 (OFF), timing is disabled, so\n    os_wait_times is 0. timed_mutexes is off by default.\n\nFrom MySQL 5.1.15 on, the statement displays the following output\nfields:\n\no Type\n\n  Always InnoDB.\n\no Name\n\n  The source file where the mutex is implemented, and the line number\n  in the file where the mutex is created. The line number may change\n  depending on your version of MySQL.\n\no Status\n\n  This field displays the same values as previously described (count,\n  spin_waits, spin_rounds, os_waits, os_yields, os_wait_times), but\n  only if UNIV_DEBUG was defined at MySQL compilation time (for\n  example, in include/univ.h in the InnoDB part of the MySQL source\n  tree). If UNIV_DEBUG was not defined, the statement displays only the\n  os_waits value. In the latter case (without UNIV_DEBUG), the\n  information on which the output is based is insufficient to\n  distinguish regular mutexes and mutexes that protect rw-locks (which\n  allow multiple readers or a single writer). Consequently, the output\n  may appear to contain multiple rows for the same mutex.\n\nInformation from this statement can be used to diagnose system\nproblems. For example, large values of spin_waits and spin_rounds may\nindicate scalability problems.\n\nIf the server has the NDBCLUSTER storage engine enabled, SHOW ENGINE\nNDB STATUS displays cluster status information such as the number of\nconnected data nodes, the cluster connectstring, and cluster binlog\nepochs, as well as counts of various Cluster API objects created by the\nMySQL Server when connected to the cluster. Sample output from this\nstatement is shown here:\n\nmysql> SHOW ENGINE NDB STATUS;\n+------------+-----------------------+--------------------------------------------------+\n| Type       | Name                  | Status                                           |\n+------------+-----------------------+--------------------------------------------------+\n| ndbcluster | connection            | cluster_node_id=7,\n  connected_host=192.168.0.103, connected_port=1186, number_of_data_nodes=4,\n  number_of_ready_data_nodes=3, connect_count=0                                         |\n| ndbcluster | NdbTransaction        | created=6, free=0, sizeof=212                    |\n| ndbcluster | NdbOperation          | created=8, free=8, sizeof=660                    |\n| ndbcluster | NdbIndexScanOperation | created=1, free=1, sizeof=744                    |\n| ndbcluster | NdbIndexOperation     | created=0, free=0, sizeof=664                    |\n| ndbcluster | NdbRecAttr            | created=1285, free=1285, sizeof=60               |\n| ndbcluster | NdbApiSignal          | created=16, free=16, sizeof=136                  |\n| ndbcluster | NdbLabel              | created=0, free=0, sizeof=196                    |\n| ndbcluster | NdbBranch             | created=0, free=0, sizeof=24                     |\n| ndbcluster | NdbSubroutine         | created=0, free=0, sizeof=68                     |\n| ndbcluster | NdbCall               | created=0, free=0, sizeof=16                     |\n| ndbcluster | NdbBlob               | created=1, free=1, sizeof=264                    |\n| ndbcluster | NdbReceiver           | created=4, free=0, sizeof=68                     |\n| ndbcluster | binlog                | latest_epoch=155467, latest_trans_epoch=148126,\n  latest_received_binlog_epoch=0, latest_handled_binlog_epoch=0,\n  latest_applied_binlog_epoch=0                                                         |\n+------------+-----------------------+--------------------------------------------------+\n\nThe rows with connection and binlog in the Name column were added to\nthe output of this statement in MySQL 5.1. The Status column in each of\nthese rows provides information about the MySQL server\'s connection to\nthe cluster and about the cluster binary log\'s status, respectively.\nThe Status information is in the form of comma-delimited set of\nname/value pairs.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-engine.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-engine.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (365,14,'NAME_CONST','Syntax:\nNAME_CONST(name,value)\n\nReturns the given value. When used to produce a result set column,\nNAME_CONST() causes the column to have the given name. The arguments\nshould be constants.\n\nmysql> SELECT NAME_CONST(\'myname\', 14);\n+--------+\n| myname |\n+--------+\n|     14 |\n+--------+\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (366,14,'RELEASE_LOCK','Syntax:\nRELEASE_LOCK(str)\n\nReleases the lock named by the string str that was obtained with\nGET_LOCK(). Returns 1 if the lock was released, 0 if the lock was not\nestablished by this thread (in which case the lock is not released),\nand NULL if the named lock did not exist. The lock does not exist if it\nwas never obtained by a call to GET_LOCK() or if it has previously been\nreleased.\n\nThe DO statement is convenient to use with RELEASE_LOCK(). See [HELP\nDO].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (367,17,'IS NULL','Syntax:\nIS NULL\n\nTests whether a value is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 1 IS NULL, 0 IS NULL, NULL IS NULL;\n        -> 0, 0, 1\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (368,30,'CONVERT_TZ','Syntax:\nCONVERT_TZ(dt,from_tz,to_tz)\n\nCONVERT_TZ() converts a datetime value dt from the time zone given by\nfrom_tz to the time zone given by to_tz and returns the resulting\nvalue. Time zones are specified as described in\nhttp://dev.mysql.com/doc/refman/5.1/en/time-zone-support.html. This\nfunction returns NULL if the arguments are invalid.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT CONVERT_TZ(\'2004-01-01 12:00:00\',\'GMT\',\'MET\');\n        -> \'2004-01-01 13:00:00\'\nmysql> SELECT CONVERT_TZ(\'2004-01-01 12:00:00\',\'+00:00\',\'+10:00\');\n        -> \'2004-01-01 22:00:00\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (369,30,'TIME_TO_SEC','Syntax:\nTIME_TO_SEC(time)\n\nReturns the time argument, converted to seconds.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT TIME_TO_SEC(\'22:23:00\');\n        -> 80580\nmysql> SELECT TIME_TO_SEC(\'00:39:38\');\n        -> 2378\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (370,30,'WEEKDAY','Syntax:\nWEEKDAY(date)\n\nReturns the weekday index for date (0 = Monday, 1 = Tuesday, ... 6 =\nSunday).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT WEEKDAY(\'2008-02-03 22:23:00\');\n        -> 6\nmysql> SELECT WEEKDAY(\'2007-11-06\');\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (371,35,'EXPORT_SET','Syntax:\nEXPORT_SET(bits,on,off[,separator[,number_of_bits]])\n\nReturns a string such that for every bit set in the value bits, you get\nan on string and for every bit not set in the value, you get an off\nstring. Bits in bits are examined from right to left (from low-order to\nhigh-order bits). Strings are added to the result from left to right,\nseparated by the separator string (the default being the comma\ncharacter ","). The number of bits examined is given by number_of_bits\n(defaults to 64).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT EXPORT_SET(5,\'Y\',\'N\',\',\',4);\n        -> \'Y,N,Y,N\'\nmysql> SELECT EXPORT_SET(6,\'1\',\'0\',\',\',10);\n        -> \'0,1,1,0,0,0,0,0,0,0\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (372,37,'ALTER SERVER','Syntax:\nALTER SERVER  server_name\n    OPTIONS (option [, option] ...)\n\nAlters the server information for server_name, adjusting the specified\noptions as per the CREATE SERVER command. See [HELP CREATE SERVER]. The\ncorresponding fields in the mysql.servers table are updated\naccordingly. This statement requires the SUPER privilege.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/alter-server.html\n\n','ALTER SERVER s OPTIONS (USER \'sally\');\n','http://dev.mysql.com/doc/refman/5.1/en/alter-server.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (373,30,'TIME FUNCTION','Syntax:\nTIME(expr)\n\nExtracts the time part of the time or datetime expression expr and\nreturns it as a string.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT TIME(\'2003-12-31 01:02:03\');\n        -> \'01:02:03\'\nmysql> SELECT TIME(\'2003-12-31 01:02:03.000123\');\n        -> \'01:02:03.000123\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (374,30,'DATE_ADD','Syntax:\nDATE_ADD(date,INTERVAL expr unit), DATE_SUB(date,INTERVAL expr unit)\n\nThese functions perform date arithmetic. The date argument specifies\nthe starting date or datetime value. expr is an expression specifying\nthe interval value to be added or subtracted from the starting date.\nexpr is a string; it may start with a "-" for negative intervals. unit\nis a keyword indicating the units in which the expression should be\ninterpreted.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT \'2008-12-31 23:59:59\' + INTERVAL 1 SECOND;\n        -> \'2009-01-01 00:00:00\'\nmysql> SELECT INTERVAL 1 DAY + \'2008-12-31\';\n        -> \'2009-01-01\'\nmysql> SELECT \'2005-01-01\' - INTERVAL 1 SECOND;\n        -> \'2004-12-31 23:59:59\'\nmysql> SELECT DATE_ADD(\'2000-12-31 23:59:59\',\n    ->                 INTERVAL 1 SECOND);\n        -> \'2001-01-01 00:00:00\'\nmysql> SELECT DATE_ADD(\'2010-12-31 23:59:59\',\n    ->                 INTERVAL 1 DAY);\n        -> \'2011-01-01 23:59:59\'\nmysql> SELECT DATE_ADD(\'2100-12-31 23:59:59\',\n    ->                 INTERVAL \'1:1\' MINUTE_SECOND);\n        -> \'2101-01-01 00:01:00\'\nmysql> SELECT DATE_SUB(\'2005-01-01 00:00:00\',\n    ->                 INTERVAL \'1 1:1:1\' DAY_SECOND);\n        -> \'2004-12-30 22:58:59\'\nmysql> SELECT DATE_ADD(\'1900-01-01 00:00:00\',\n    ->                 INTERVAL \'-1 10\' DAY_HOUR);\n        -> \'1899-12-30 14:00:00\'\nmysql> SELECT DATE_SUB(\'1998-01-02\', INTERVAL 31 DAY);\n        -> \'1997-12-02\'\nmysql> SELECT DATE_ADD(\'1992-12-31 23:59:59.000002\',\n    ->            INTERVAL \'1.999999\' SECOND_MICROSECOND);\n        -> \'1993-01-01 00:00:01.000001\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (375,35,'CAST','Syntax:\nCAST(expr AS type)\n\nThe CAST() function takes a value of one type and produce a value of\nanother type, similar to CONVERT(). See the description of CONVERT()\nfor more information.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/cast-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/cast-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (376,35,'SOUNDS LIKE','Syntax:\nexpr1 SOUNDS LIKE expr2\n\nThis is the same as SOUNDEX(expr1) = SOUNDEX(expr2).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (377,30,'PERIOD_DIFF','Syntax:\nPERIOD_DIFF(P1,P2)\n\nReturns the number of months between periods P1 and P2. P1 and P2\nshould be in the format YYMM or YYYYMM. Note that the period arguments\nP1 and P2 are not date values.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT PERIOD_DIFF(200802,200703);\n        -> 11\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (378,35,'LIKE','Syntax:\nexpr LIKE pat [ESCAPE \'escape_char\']\n\nPattern matching using SQL simple regular expression comparison.\nReturns 1 (TRUE) or 0 (FALSE). If either expr or pat is NULL, the\nresult is NULL.\n\nThe pattern need not be a literal string. For example, it can be\nspecified as a string expression or table column.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-comparison-functions.html\n\n','mysql> SELECT \'David!\' LIKE \'David_\';\n        -> 1\nmysql> SELECT \'David!\' LIKE \'%D%v%\';\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/string-comparison-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (379,23,'MULTIPOINT','MultiPoint(pt1,pt2,...)\n\nConstructs a MultiPoint value using Point or WKB Point arguments.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-mysql-specific-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-mysql-specific-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (380,18,'>>','Syntax:\n>>\n\nShifts a longlong (BIGINT) number to the right.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html\n\n','mysql> SELECT 4 >> 2;\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (381,22,'FETCH','Syntax:\nFETCH cursor_name INTO var_name [, var_name] ...\n\nThis statement fetches the next row (if a row exists) using the\nspecified open cursor, and advances the cursor pointer.\n\nIf no more rows are available, a No Data condition occurs with SQLSTATE\nvalue 02000. To detect this condition, you can set up a handler for it\n(or for a NOT FOUND condition). An example is shown in\nhttp://dev.mysql.com/doc/refman/5.1/en/cursors.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/fetch.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/fetch.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (382,16,'AVG','Syntax:\nAVG([DISTINCT] expr)\n\nReturns the average value of expr. The DISTINCT option can be used to\nreturn the average of the distinct values of expr.\n\nAVG() returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','mysql> SELECT student_name, AVG(test_score)\n    ->        FROM student\n    ->        GROUP BY student_name;\n','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (383,28,'TRUE FALSE','The constants TRUE and FALSE evaluate to 1 and 0, respectively. The\nconstant names can be written in any lettercase.\n\nmysql> SELECT TRUE, true, FALSE, false;\n        -> 1, 1, 0, 0\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/boolean-values.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/boolean-values.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (384,6,'MBRWITHIN','MBRWithin(g1,g2)\n\nReturns 1 or 0 to indicate whether the Minimum Bounding Rectangle of g1\nis within the Minimum Bounding Rectangle of g2. This tests the opposite\nrelationship as MBRContains().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html\n\n','mysql> SET @g1 = GeomFromText(\'Polygon((0 0,0 3,3 3,3 0,0 0))\');\nmysql> SET @g2 = GeomFromText(\'Polygon((0 0,0 5,5 5,5 0,0 0))\');\nmysql> SELECT MBRWithin(@g1,@g2), MBRWithin(@g2,@g1);\n+--------------------+--------------------+\n| MBRWithin(@g1,@g2) | MBRWithin(@g2,@g1) |\n+--------------------+--------------------+\n|                  1 |                  0 |\n+--------------------+--------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/relations-on-geometry-mbr.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (385,17,'IN','Syntax:\nexpr IN (value,...)\n\nReturns 1 if expr is equal to any of the values in the IN list, else\nreturns 0. If all values are constants, they are evaluated according to\nthe type of expr and sorted. The search for the item then is done using\na binary search. This means IN is very quick if the IN value list\nconsists entirely of constants. Otherwise, type conversion takes place\naccording to the rules described in\nhttp://dev.mysql.com/doc/refman/5.1/en/type-conversion.html, but\napplied to all the arguments.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 2 IN (0,3,5,7);\n        -> 0\nmysql> SELECT \'wefwf\' IN (\'wee\',\'wefwf\',\'weg\');\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (386,35,'QUOTE','Syntax:\nQUOTE(str)\n\nQuotes a string to produce a result that can be used as a properly\nescaped data value in an SQL statement. The string is returned enclosed\nby single quotes and with each instance of single quote ("\'"),\nbackslash ("\\"), ASCII NUL, and Control-Z preceded by a backslash. If\nthe argument is NULL, the return value is the word "NULL" without\nenclosing single quotes.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT QUOTE(\'Don\\\'t!\');\n        -> \'Don\\\'t!\'\nmysql> SELECT QUOTE(NULL);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (387,15,'SESSION_USER','Syntax:\nSESSION_USER()\n\nSESSION_USER() is a synonym for USER().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (388,25,'HELP COMMAND','Syntax:\nmysql> help search_string\n\nIf you provide an argument to the help command, mysql uses it as a\nsearch string to access server-side help from the contents of the MySQL\nReference Manual. The proper operation of this command requires that\nthe help tables in the mysql database be initialized with help topic\ninformation (see\nhttp://dev.mysql.com/doc/refman/5.1/en/server-side-help-support.html).\n\nIf there is no match for the search string, the search fails:\n\nmysql> help me\n\nNothing found\nPlease try to run \'help contents\' for a list of all accessible topics\n\nUse help contents to see a list of the help categories:\n\nmysql> help contents\nYou asked for help about help category: "Contents"\nFor more information, type \'help <item>\', where <item> is one of the\nfollowing categories:\n   Account Management\n   Administration\n   Data Definition\n   Data Manipulation\n   Data Types\n   Functions\n   Functions and Modifiers for Use with GROUP BY\n   Geographic Features\n   Language Structure\n   Plugins\n   Storage Engines\n   Stored Routines\n   Table Maintenance\n   Transactions\n   Triggers\n\nIf the search string matches multiple items, mysql shows a list of\nmatching topics:\n\nmysql> help logs\nMany help items for your request exist.\nTo make a more specific request, please type \'help <item>\',\nwhere <item> is one of the following topics:\n   SHOW\n   SHOW BINARY LOGS\n   SHOW ENGINE\n   SHOW LOGS\n\nUse a topic as the search string to see the help entry for that topic:\n\nmysql> help show binary logs\nName: \'SHOW BINARY LOGS\'\nDescription:\nSyntax:\nSHOW BINARY LOGS\nSHOW MASTER LOGS\n\nLists the binary log files on the server. This statement is used as\npart of the procedure described in [purge-binary-logs], that shows how\nto determine which logs can be purged.\n\nmysql> SHOW BINARY LOGS;\n+---------------+-----------+\n| Log_name      | File_size |\n+---------------+-----------+\n| binlog.000015 |    724935 |\n| binlog.000016 |    733481 |\n+---------------+-----------+\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mysql-server-side-help.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/mysql-server-side-help.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (389,30,'QUARTER','Syntax:\nQUARTER(date)\n\nReturns the quarter of the year for date, in the range 1 to 4.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT QUARTER(\'2008-04-01\');\n        -> 2\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (390,35,'POSITION','Syntax:\nPOSITION(substr IN str)\n\nPOSITION(substr IN str) is a synonym for LOCATE(substr,str).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (391,25,'SHOW CREATE FUNCTION','Syntax:\nSHOW CREATE FUNCTION func_name\n\nThis statement is similar to SHOW CREATE PROCEDURE but for stored\nfunctions. See [HELP SHOW CREATE PROCEDURE].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-create-function.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-create-function.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (392,14,'IS_USED_LOCK','Syntax:\nIS_USED_LOCK(str)\n\nChecks whether the lock named str is in use (that is, locked). If so,\nit returns the connection identifier of the client that holds the lock.\nOtherwise, it returns NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (393,3,'POLYFROMTEXT','PolyFromText(wkt[,srid]), PolygonFromText(wkt[,srid])\n\nConstructs a POLYGON value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkt-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkt-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (394,11,'DES_ENCRYPT','Syntax:\nDES_ENCRYPT(str[,{key_num|key_str}])\n\nEncrypts the string with the given key using the Triple-DES algorithm.\n\nThis function works only if MySQL has been configured with SSL support.\nSee http://dev.mysql.com/doc/refman/5.1/en/secure-connections.html.\n\nThe encryption key to use is chosen based on the second argument to\nDES_ENCRYPT(), if one was given. With no argument, the first key from\nthe DES key file is used. With a key_num argument, the given key number\n(0-9) from the DES key file is used. With a key_str argument, the given\nkey string is used to encrypt str.\n\nThe key file can be specified with the --des-key-file server option.\n\nThe return string is a binary string where the first character is\nCHAR(128 | key_num). If an error occurs, DES_ENCRYPT() returns NULL.\n\nThe 128 is added to make it easier to recognize an encrypted key. If\nyou use a string key, key_num is 127.\n\nThe string length for the result is given by this formula:\n\nnew_len = orig_len + (8 - (orig_len % 8)) + 1\n\nEach line in the DES key file has the following format:\n\nkey_num des_key_str\n\nEach key_num value must be a number in the range from 0 to 9. Lines in\nthe file may be in any order. des_key_str is the string that is used to\nencrypt the message. There should be at least one space between the\nnumber and the key. The first key is the default key that is used if\nyou do not specify any key argument to DES_ENCRYPT().\n\nYou can tell MySQL to read new key values from the key file with the\nFLUSH DES_KEY_FILE statement. This requires the RELOAD privilege.\n\nOne benefit of having a set of default keys is that it gives\napplications a way to check for the existence of encrypted column\nvalues, without giving the end user the right to decrypt those values.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','mysql> SELECT customer_address FROM customer_table \n     > WHERE crypted_credit_card = DES_ENCRYPT(\'credit_card_number\');\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (395,4,'CEIL','Syntax:\nCEIL(X)\n\nCEIL() is a synonym for CEILING().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (396,35,'LENGTH','Syntax:\nLENGTH(str)\n\nReturns the length of the string str, measured in bytes. A multi-byte\ncharacter counts as multiple bytes. This means that for a string\ncontaining five two-byte characters, LENGTH() returns 10, whereas\nCHAR_LENGTH() returns 5.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT LENGTH(\'text\');\n        -> 4\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (397,30,'STR_TO_DATE','Syntax:\nSTR_TO_DATE(str,format)\n\nThis is the inverse of the DATE_FORMAT() function. It takes a string\nstr and a format string format. STR_TO_DATE() returns a DATETIME value\nif the format string contains both date and time parts, or a DATE or\nTIME value if the string contains only date or time parts. If the date,\ntime, or datetime value extracted from str is illegal, STR_TO_DATE()\nreturns NULL and produces a warning.\n\nThe server scans str attempting to match format to it. The format\nstring can contain literal characters and format specifiers beginning\nwith %. Literal characters in format must match literally in str.\nFormat specifiers in format must match a date or time part in str. For\nthe specifiers that can be used in format, see the DATE_FORMAT()\nfunction description.\n\nmysql> SELECT STR_TO_DATE(\'01,5,2013\',\'%d,%m,%Y\');\n        -> \'2013-05-01\'\nmysql> SELECT STR_TO_DATE(\'May 1, 2013\',\'%M %d,%Y\');\n        -> \'2013-05-01\'\n\nScanning starts at the beginning of str and fails if format is found\nnot to match. Extra characters at the end of str are ignored.\n\nmysql> SELECT STR_TO_DATE(\'a09:30:17\',\'a%h:%i:%s\');\n        -> \'09:30:17\'\nmysql> SELECT STR_TO_DATE(\'a09:30:17\',\'%h:%i:%s\');\n        -> NULL\nmysql> SELECT STR_TO_DATE(\'09:30:17a\',\'%h:%i:%s\');\n        -> \'09:30:17\'\n\nUnspecified date or time parts have a value of 0, so incompletely\nspecified values in str produce a result with some or all parts set to\n0:\n\nmysql> SELECT STR_TO_DATE(\'abc\',\'abc\');\n        -> \'0000-00-00\'\nmysql> SELECT STR_TO_DATE(\'9\',\'%m\');\n        -> \'0000-09-00\'\nmysql> SELECT STR_TO_DATE(\'9\',\'%s\');\n        -> \'00:00:09\'\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (398,10,'Y','Y(p)\n\nReturns the Y-coordinate value for the point p as a double-precision\nnumber.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#point-property-functions\n\n','mysql> SET @pt = \'Point(56.7 53.34)\';\nmysql> SELECT Y(GeomFromText(@pt));\n+----------------------+\n| Y(GeomFromText(@pt)) |\n+----------------------+\n|                53.34 |\n+----------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#point-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (399,25,'SHOW INNODB STATUS','Syntax:\nSHOW INNODB STATUS\n\nIn MySQL 5.1, this is a deprecated synonym for SHOW ENGINE INNODB\nSTATUS. See [HELP SHOW ENGINE].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-innodb-status.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-innodb-status.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (400,19,'CHECKSUM TABLE','Syntax:\nCHECKSUM TABLE tbl_name [, tbl_name] ... [ QUICK | EXTENDED ]\n\nCHECKSUM TABLE reports a table checksum.\n\nWith QUICK, the live table checksum is reported if it is available, or\nNULL otherwise. This is very fast. A live checksum is enabled by\nspecifying the CHECKSUM=1 table option when you create the table;\ncurrently, this is supported only for MyISAM tables. See [HELP CREATE\nTABLE].\n\nWith EXTENDED, the entire table is read row by row and the checksum is\ncalculated. This can be very slow for large tables.\n\nIf neither QUICK nor EXTENDED is specified, MySQL returns a live\nchecksum if the table storage engine supports it and scans the table\notherwise.\n\nFor a nonexistent table, CHECKSUM TABLE returns NULL and generates a\nwarning.\n\nThe checksum value depends on the table row format. If the row format\nchanges, the checksum also changes. For example, the storage format for\nVARCHAR changed between MySQL 4.1 and 5.0, so if a 4.1 table is\nupgraded to MySQL 5.0, the checksum value may change.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/checksum-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/checksum-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (401,2,'NUMINTERIORRINGS','NumInteriorRings(poly)\n\nReturns the number of interior rings in the Polygon value poly.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#polygon-property-functions\n\n','mysql> SET @poly =\n    -> \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT NumInteriorRings(GeomFromText(@poly));\n+---------------------------------------+\n| NumInteriorRings(GeomFromText(@poly)) |\n+---------------------------------------+\n|                                     1 |\n+---------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#polygon-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (402,2,'INTERIORRINGN','InteriorRingN(poly,N)\n\nReturns the N-th interior ring for the Polygon value poly as a\nLineString. Rings are numbered beginning with 1.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#polygon-property-functions\n\n','mysql> SET @poly =\n    -> \'Polygon((0 0,0 3,3 3,3 0,0 0),(1 1,1 2,2 2,2 1,1 1))\';\nmysql> SELECT AsText(InteriorRingN(GeomFromText(@poly),1));\n+----------------------------------------------+\n| AsText(InteriorRingN(GeomFromText(@poly),1)) |\n+----------------------------------------------+\n| LINESTRING(1 1,1 2,2 2,2 1,1 1)              |\n+----------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#polygon-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (403,30,'UTC_TIME','Syntax:\nUTC_TIME, UTC_TIME()\n\nReturns the current UTC time as a value in \'HH:MM:SS\' or HHMMSS.uuuuuu\nformat, depending on whether the function is used in a string or\nnumeric context.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT UTC_TIME(), UTC_TIME() + 0;\n        -> \'18:07:53\', 180753.000000\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (404,37,'DROP FUNCTION','The DROP FUNCTION statement is used to drop stored functions and\nuser-defined functions (UDFs):\n\no For information about dropping stored functions, see [HELP DROP\n  PROCEDURE].\n\no For information about dropping user-defined functions, see [HELP DROP\n  FUNCTION UDF].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-function.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-function.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (405,37,'ALTER EVENT','Syntax:\nALTER\n    [DEFINER = { user | CURRENT_USER }]\n    EVENT event_name\n    [ON SCHEDULE schedule]\n    [ON COMPLETION [NOT] PRESERVE]\n    [RENAME TO new_event_name]\n    [ENABLE | DISABLE | DISABLE ON SLAVE]\n    [COMMENT \'comment\']\n    [DO sql_statement]\n\nThe ALTER EVENT statement is used to change one or more of the\ncharacteristics of an existing event without the need to drop and\nrecreate it. The syntax for each of the DEFINER, ON SCHEDULE, ON\nCOMPLETION, COMMENT, ENABLE / DISABLE, and DO clauses is exactly the\nsame as when used with CREATE EVENT. (See [HELP CREATE EVENT].)\n\nSupport for the DEFINER clause was added in MySQL 5.1.17.\n\nBeginning with MySQL 5.1.12, this statement requires the EVENT\nprivilege. When a user executes a successful ALTER EVENT statement,\nthat user becomes the definer for the affected event.\n\n(In MySQL 5.1.11 and earlier, an event could be altered only by its\ndefiner, or by a user having the SUPER privilege.)\n\nALTER EVENT works only with an existing event:\n\nmysql> ALTER EVENT no_such_event \n     >     ON SCHEDULE \n     >       EVERY \'2:3\' DAY_HOUR;\nERROR 1517 (HY000): Unknown event \'no_such_event\'\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/alter-event.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/alter-event.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (406,16,'STDDEV','Syntax:\nSTDDEV(expr)\n\nReturns the population standard deviation of expr. This function is\nprovided for compatibility with Oracle. The standard SQL function\nSTDDEV_POP() can be used instead.\n\nThis function returns NULL if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (407,30,'DATE_SUB','Syntax:\nDATE_SUB(date,INTERVAL expr unit)\n\nSee the description for DATE_ADD().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (408,30,'PERIOD_ADD','Syntax:\nPERIOD_ADD(P,N)\n\nAdds N months to period P (in the format YYMM or YYYYMM). Returns a\nvalue in the format YYYYMM. Note that the period argument P is not a\ndate value.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT PERIOD_ADD(200801,2);\n        -> 200803\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (409,18,'|','Syntax:\n|\n\nBitwise OR:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html\n\n','mysql> SELECT 29 | 15;\n        -> 31\n','http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (410,3,'GEOMFROMTEXT','GeomFromText(wkt[,srid]), GeometryFromText(wkt[,srid])\n\nConstructs a geometry value of any type using its WKT representation\nand SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkt-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkt-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (411,14,'UUID_SHORT','Syntax:\nUUID_SHORT()\n\nReturns a "short" universal identifier as a 64-bit unsigned integer\n(rather than a string-form 128-bit identifier as returned by the UUID()\nfunction).\n\nThe value of UUID_SHORT() is guaranteed to be unique if the following\nconditions hold:\n\no The server_id of the current host is unique among your set of master\n  and slave servers\n\no server_id is between 0 and 255\n\no You don\'t set back your system time for your server between mysqld\n  restarts\n\no You do not invoke UUID_SHORT() on average more than 16 million times\n  per second between mysqld restarts\n\nThe UUID_SHORT() return value is constructed this way:\n\n  (server_id & 255) << 56\n+ (server_startup_time_in_seconds << 24)\n+ incremented_variable++;\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','mysql> SELECT UUID_SHORT();\n        -> 92395783831158784\n','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (412,35,'RIGHT','Syntax:\nRIGHT(str,len)\n\nReturns the rightmost len characters from the string str, or NULL if\nany argument is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT RIGHT(\'foobarbar\', 4);\n        -> \'rbar\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (413,30,'DATEDIFF','Syntax:\nDATEDIFF(expr1,expr2)\n\nDATEDIFF() returns expr1 - expr2 expressed as a value in days from one\ndate to the other. expr1 and expr2 are date or date-and-time\nexpressions. Only the date parts of the values are used in the\ncalculation.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT DATEDIFF(\'2007-12-31 23:59:59\',\'2007-12-30\');\n        -> 1\nmysql> SELECT DATEDIFF(\'2010-11-30 23:59:59\',\'2010-12-31\');\n        -> -31\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (414,37,'DROP TABLESPACE','Syntax:\nDROP TABLESPACE tablespace_name\n    ENGINE [=] engine_name\n\nThis statement drops a tablespace that was previously created using\nCREATE TABLESPACE (see [HELP CREATE TABLESPACE]).\n\n*Important*: The tablespace to be dropped must not contain any data\nfiles; in other words, before you can drop a tablespace, you must first\ndrop each of its data files using ALTER TABLESPACE ... DROP DATAFILE\n(see [HELP ALTER TABLESPACE]).\n\nThe ENGINE clause (required) specifies the storage engine used by the\ntablespace. In MySQL 5.1, the only accepted values for engine_name are\nNDB and NDBCLUSTER.\n\nDROP TABLESPACE was added in MySQL 5.1.6. In MySQL 5.1, it is useful\nonly with Disk Data storage for MySQL Cluster. See\nhttp://dev.mysql.com/doc/refman/5.1/en/mysql-cluster-disk-data.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-tablespace.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-tablespace.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (415,37,'DROP PROCEDURE','Syntax:\nDROP {PROCEDURE | FUNCTION} [IF EXISTS] sp_name\n\nThis statement is used to drop a stored procedure or function. That is,\nthe specified routine is removed from the server. You must have the\nALTER ROUTINE privilege for the routine. (That privilege is granted\nautomatically to the routine creator.)\n\nThe IF EXISTS clause is a MySQL extension. It prevents an error from\noccurring if the procedure or function does not exist. A warning is\nproduced that can be viewed with SHOW WARNINGS.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/drop-procedure.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/drop-procedure.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (416,19,'CHECK TABLE','Syntax:\nCHECK TABLE tbl_name [, tbl_name] ... [option] ...\n\noption = {FOR UPGRADE | QUICK | FAST | MEDIUM | EXTENDED | CHANGED}\n\nCHECK TABLE checks a table or tables for errors. CHECK TABLE works for\nMyISAM, InnoDB, and ARCHIVE tables. Starting with MySQL 5.1.9, CHECK\nTABLE is also valid for CSV tables, see\nhttp://dev.mysql.com/doc/refman/5.1/en/csv-storage-engine.html. For\nMyISAM tables, the key statistics are updated as well.\n\nCHECK TABLE can also check views for problems, such as tables that are\nreferenced in the view definition that no longer exist.\n\nBeginning with MySQL 5.1.27, CHECK TABLE is also supported for\npartitioned tables. Also beginning with MySQL 5.1.27, you can use ALTER\nTABLE ... CHECK PARTITION to check one or more partitions; for more\ninformation, see [HELP ALTER TABLE], and\nhttp://dev.mysql.com/doc/refman/5.1/en/partitioning-maintenance.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/check-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/check-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (417,35,'BIN','Syntax:\nBIN(N)\n\nReturns a string representation of the binary value of N, where N is a\nlonglong (BIGINT) number. This is equivalent to CONV(N,10,2). Returns\nNULL if N is NULL.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT BIN(12);\n        -> \'1100\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (418,5,'INSTALL PLUGIN','Syntax:\nINSTALL PLUGIN plugin_name SONAME \'plugin_library\'\n\nThis statement installs a plugin.\n\nplugin_name is the name of the plugin as defined in the plugin\ndeclaration structure contained in the library file. Plugin names are\nnot case sensitive. For maximal compatibility, plugin names should be\nlimited to ASCII letters, digits, and underscore, because they are used\nin C source files, shell command lines, M4 and Bourne shell scripts,\nand SQL environments.\n\nplugin_library is the name of the shared library that contains the\nplugin code. The name includes the file name extension (for example,\nlibmyplugin.so or libmyplugin.dylib).\n\nThe shared library must be located in the plugin directory (that is,\nthe directory named by the plugin_dir system variable). The library\nmust be in the plugin directory itself, not in a subdirectory. By\ndefault, plugin_dir is plugin directory under the directory named by\nthe pkglibdir configuration variable, but it can be changed by setting\nthe value of plugin_dir at server startup. For example, set its value\nin a my.cnf file:\n\n[mysqld]\nplugin_dir=/path/to/plugin/directory\n\nIf the value of plugin_dir is a relative path name, it is taken to be\nrelative to the MySQL base directory (the value of the basedir system\nvariable).\n\nINSTALL PLUGIN adds a line to the mysql.plugin table that describes the\nplugin. This table contains the plugin name and library file name.\n\nAs of MySQL 5.1.33, INSTALL PLUGIN causes the server to read option\n(my.cnf) files just as during server startup. This enables the plugin\nto pick up any relevant options from those files. It is possible to add\nplugin options to an option file even before loading a plugin (if the\nloose prefix is used). It is also possible to uninstall a plugin, edit\nmy.cnf, and install the plugin again. Restarting the plugin this way\nenables it to the new option values without a server restart.\n\nBefore MySQL 5.1.33, a plugin is started with each option set to its\ndefault value.\n\nINSTALL PLUGIN also loads and initializes the plugin code to make the\nplugin available for use. A plugin is initialized by executing its\ninitialization function, which handles any setup that the plugin must\nperform before it can be used.\n\nTo use INSTALL PLUGIN, you must have the INSERT privilege for the\nmysql.plugin table.\n\nAt server startup, the server loads and initializes any plugin that is\nlisted in the mysql.plugin table. This means that a plugin is installed\nwith INSTALL PLUGIN only once, not every time the server starts. Plugin\nloading at startup does not occur if the server is started with the\n--skip-grant-tables option.\n\nWhen the server shuts down, it executes the deinitialization function\nfor each plugin that is loaded so that the plugin has a change to\nperform any final cleanup.\n\nFor options that control individual plugin loading at server startup,\nsee http://dev.mysql.com/doc/refman/5.1/en/server-plugin-options.html.\nIf you need to load plugins for a single server startup when the\n--skip-grant-tables option is given (which tells the server not to read\nsystem tables), use the --plugin-load option. See\nhttp://dev.mysql.com/doc/refman/5.1/en/server-options.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/install-plugin.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/install-plugin.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (419,22,'DECLARE CURSOR','Syntax:\nDECLARE cursor_name CURSOR FOR select_statement\n\nThis statement declares a cursor. Multiple cursors may be declared in a\nstored program, but each cursor in a given block must have a unique\nname.\n\nThe SELECT statement cannot have an INTO clause.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/declare-cursor.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/declare-cursor.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (420,26,'LOAD DATA','Syntax:\nLOAD DATA [LOW_PRIORITY | CONCURRENT] [LOCAL] INFILE \'file_name\'\n    [REPLACE | IGNORE]\n    INTO TABLE tbl_name\n    [CHARACTER SET charset_name]\n    [{FIELDS | COLUMNS}\n        [TERMINATED BY \'string\']\n        [[OPTIONALLY] ENCLOSED BY \'char\']\n        [ESCAPED BY \'char\']\n    ]\n    [LINES\n        [STARTING BY \'string\']\n        [TERMINATED BY \'string\']\n    ]\n    [IGNORE number LINES]\n    [(col_name_or_user_var,...)]\n    [SET col_name = expr,...]\n\nThe LOAD DATA INFILE statement reads rows from a text file into a table\nat a very high speed. The file name must be given as a literal string.\n\nLOAD DATA INFILE is the complement of SELECT ... INTO OUTFILE. (See\nhttp://dev.mysql.com/doc/refman/5.1/en/select.html.) To write data from\na table to a file, use SELECT ... INTO OUTFILE. To read the file back\ninto a table, use LOAD DATA INFILE. The syntax of the FIELDS and LINES\nclauses is the same for both statements. Both clauses are optional, but\nFIELDS must precede LINES if both are specified.\n\nFor more information about the efficiency of INSERT versus LOAD DATA\nINFILE and speeding up LOAD DATA INFILE, see\nhttp://dev.mysql.com/doc/refman/5.1/en/insert-speed.html.\n\nThe character set indicated by the character_set_database system\nvariable is used to interpret the information in the file. SET NAMES\nand the setting of character_set_client do not affect interpretation of\ninput. If the contents of the input file use a character set that\ndiffers from the default, it is usually preferable to specify the\ncharacter set of the file by using the CHARACTER SET clause, which is\navailable as of MySQL 5.1.17. A character set of binary specifies "no\nconversion."\n\nLOAD DATA INFILE interprets all fields in the file as having the same\ncharacter set, regardless of the data types of the columns into which\nfield values are loaded. For proper interpretation of file contents,\nyou must ensure that it was written with the correct character set. For\nexample, if you write a data file with mysqldump -T or by issuing a\nSELECT ... INTO OUTFILE statement in mysql, be sure to use a\n--default-character-set option with mysqldump or mysql so that output\nis written in the character set to be used when the file is loaded with\nLOAD DATA INFILE.\n\nNote that it is currently not possible to load data files that use the\nucs2, utf16, or utf32 character set.\n\nAs of MySQL 5.1.6, the character_set_filesystem system variable\ncontrols the interpretation of the file name.\n\nYou can also load data files by using the mysqlimport utility; it\noperates by sending a LOAD DATA INFILE statement to the server. The\n--local option causes mysqlimport to read data files from the client\nhost. You can specify the --compress option to get better performance\nover slow networks if the client and server support the compressed\nprotocol. See http://dev.mysql.com/doc/refman/5.1/en/mysqlimport.html.\n\nIf you use LOW_PRIORITY, execution of the LOAD DATA statement is\ndelayed until no other clients are reading from the table. This affects\nonly storage engines that use only table-level locking (MyISAM, MEMORY,\nMERGE).\n\nIf you specify CONCURRENT with a MyISAM table that satisfies the\ncondition for concurrent inserts (that is, it contains no free blocks\nin the middle), other threads can retrieve data from the table while\nLOAD DATA is executing. Using this option affects the performance of\nLOAD DATA a bit, even if no other thread is using the table at the same\ntime.\n\nCONCURRENT is not replicated when using statement-based replication;\nhowever, it is replicated when using row-based replication. See\nhttp://dev.mysql.com/doc/refman/5.1/en/replication-features-load-data.h\ntml, for more information.\n\n*Note*: Prior to MySQL 5.1.23, LOAD DATA performed very poorly when\nimporting into partitioned tables. The statement now uses buffering to\nimprove performance; however, the buffer uses 130 KB memory per\npartition to achieve this. (Bug#26527 (http://bugs.mysql.com/26527))\n\nThe LOCAL keyword, if specified, is interpreted with respect to the\nclient end of the connection:\n\no If LOCAL is specified, the file is read by the client program on the\n  client host and sent to the server. The file can be given as a full\n  path name to specify its exact location. If given as a relative path\n  name, the name is interpreted relative to the directory in which the\n  client program was started.\n\no If LOCAL is not specified, the file must be located on the server\n  host and is read directly by the server. The server uses the\n  following rules to locate the file:\n\n  o If the file name is an absolute path name, the server uses it as\n    given.\n\n  o If the file name is a relative path name with one or more leading\n    components, the server searches for the file relative to the\n    server\'s data directory.\n\n  o If a file name with no leading components is given, the server\n    looks for the file in the database directory of the default\n    database.\n\nNote that, in the non-LOCAL case, these rules mean that a file named as\n./myfile.txt is read from the server\'s data directory, whereas the file\nnamed as myfile.txt is read from the database directory of the default\ndatabase. For example, if db1 is the default database, the following\nLOAD DATA statement reads the file data.txt from the database directory\nfor db1, even though the statement explicitly loads the file into a\ntable in the db2 database:\n\nLOAD DATA INFILE \'data.txt\' INTO TABLE db2.my_table;\n\nWindows path names are specified using forward slashes rather than\nbackslashes. If you do use backslashes, you must double them.\n\nFor security reasons, when reading text files located on the server,\nthe files must either reside in the database directory or be readable\nby all. Also, to use LOAD DATA INFILE on server files, you must have\nthe FILE privilege. See\nhttp://dev.mysql.com/doc/refman/5.1/en/privileges-provided.html. For\nnon-LOCAL load operations, if the secure_file_priv system variable is\nset to a nonempty directory name, the file to be loaded must be located\nin that directory.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/load-data.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/load-data.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (421,23,'MULTILINESTRING','MultiLineString(ls1,ls2,...)\n\nConstructs a MultiLineString value using LineString or WKB LineString\narguments.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-mysql-specific-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-mysql-specific-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (422,30,'LOCALTIME','Syntax:\nLOCALTIME, LOCALTIME()\n\nLOCALTIME and LOCALTIME() are synonyms for NOW().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (423,3,'MPOINTFROMTEXT','MPointFromText(wkt[,srid]), MultiPointFromText(wkt[,srid])\n\nConstructs a MULTIPOINT value using its WKT representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkt-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkt-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (424,20,'BLOB','BLOB[(M)]\n\nA BLOB column with a maximum length of 65,535 (216 - 1) bytes. Each\nBLOB value is stored using a two-byte length prefix that indicates the\nnumber of bytes in the value.\n\nAn optional length M can be given for this type. If this is done, MySQL\ncreates the column as the smallest BLOB type large enough to hold\nvalues M bytes long.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (425,11,'SHA1','Syntax:\nSHA1(str), SHA(str)\n\nCalculates an SHA-1 160-bit checksum for the string, as described in\nRFC 3174 (Secure Hash Algorithm). The value is returned as a binary\nstring of 40 hex digits, or NULL if the argument was NULL. One of the\npossible uses for this function is as a hash key. You can also use it\nas a cryptographic function for storing passwords. SHA() is synonymous\nwith SHA1().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','mysql> SELECT SHA1(\'abc\');\n        -> \'a9993e364706816aba3e25717850c26c9cd0d89d\'\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (426,35,'SUBSTR','Syntax:\nSUBSTR(str,pos), SUBSTR(str FROM pos), SUBSTR(str,pos,len), SUBSTR(str\nFROM pos FOR len)\n\nSUBSTR() is a synonym for SUBSTRING().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (427,11,'PASSWORD','Syntax:\nPASSWORD(str)\n\nCalculates and returns a password string from the plaintext password\nstr and returns a binary string, or NULL if the argument was NULL. This\nis the function that is used for encrypting MySQL passwords for storage\nin the Password column of the user grant table.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','mysql> SELECT PASSWORD(\'badpwd\');\n        -> \'*AAB3E285149C0135D51A520E1940DD3263DC008C\'\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (428,20,'CHAR','[NATIONAL] CHAR[(M)] [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nA fixed-length string that is always right-padded with spaces to the\nspecified length when stored. M represents the column length in\ncharacters. The range of M is 0 to 255. If M is omitted, the length is\n1.\n\n*Note*: Trailing spaces are removed when CHAR values are retrieved\nunless the PAD_CHAR_TO_FULL_LENGTH SQL mode is enabled.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (429,30,'UTC_DATE','Syntax:\nUTC_DATE, UTC_DATE()\n\nReturns the current UTC date as a value in \'YYYY-MM-DD\' or YYYYMMDD\nformat, depending on whether the function is used in a string or\nnumeric context.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT UTC_DATE(), UTC_DATE() + 0;\n        -> \'2003-08-14\', 20030814\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (430,34,'DIMENSION','Dimension(g)\n\nReturns the inherent dimension of the geometry value g. The result can\nbe -1, 0, 1, or 2. The meaning of these values is given in\nhttp://dev.mysql.com/doc/refman/5.1/en/gis-class-geometry.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#general-geometry-property-functions\n\n','mysql> SELECT Dimension(GeomFromText(\'LineString(1 1,2 2)\'));\n+------------------------------------------------+\n| Dimension(GeomFromText(\'LineString(1 1,2 2)\')) |\n+------------------------------------------------+\n|                                              1 |\n+------------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#general-geometry-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (431,16,'COUNT DISTINCT','Syntax:\nCOUNT(DISTINCT expr,[expr...])\n\nReturns a count of the number of different non-NULL values.\n\nCOUNT(DISTINCT) returns 0 if there were no matching rows.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html\n\n','mysql> SELECT COUNT(DISTINCT results) FROM student;\n','http://dev.mysql.com/doc/refman/5.1/en/group-by-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (432,20,'BIT','BIT[(M)]\n\nA bit-field type. M indicates the number of bits per value, from 1 to\n64. The default is 1 if M is omitted.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (433,29,'EQUALS','Equals(g1,g2)\n\nReturns 1 or 0 to indicate whether g1 is spatially equal to g2.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/functions-that-test-spatial-relationships-between-geometries.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (434,25,'SHOW CREATE VIEW','Syntax:\nSHOW CREATE VIEW view_name\n\nThis statement shows a CREATE VIEW statement that creates the given\nview.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-create-view.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-create-view.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (435,17,'INTERVAL','Syntax:\nINTERVAL(N,N1,N2,N3,...)\n\nReturns 0 if N < N1, 1 if N < N2 and so on or -1 if N is NULL. All\narguments are treated as integers. It is required that N1 < N2 < N3 <\n... < Nn for this function to work correctly. This is because a binary\nsearch is used (very fast).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT INTERVAL(23, 1, 15, 17, 30, 44, 200);\n        -> 3\nmysql> SELECT INTERVAL(10, 1, 10, 100, 1000);\n        -> 2\nmysql> SELECT INTERVAL(22, 23, 30, 44, 200);\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (436,30,'FROM_DAYS','Syntax:\nFROM_DAYS(N)\n\nGiven a day number N, returns a DATE value.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT FROM_DAYS(730669);\n        -> \'2007-07-03\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (437,37,'ALTER PROCEDURE','Syntax:\nALTER PROCEDURE proc_name [characteristic ...]\n\ncharacteristic:\n    { CONTAINS SQL | NO SQL | READS SQL DATA | MODIFIES SQL DATA }\n  | SQL SECURITY { DEFINER | INVOKER }\n  | COMMENT \'string\'\n\nThis statement can be used to change the characteristics of a stored\nprocedure. More than one change may be specified in an ALTER PROCEDURE\nstatement. However, you cannot change the parameters or body of a\nstored procedure using this statement; to make such changes, you must\ndrop and re-create the procedure using DROP PROCEDURE and CREATE\nPROCEDURE.\n\nYou must have the ALTER ROUTINE privilege for the procedure. (That\nprivilege is granted automatically to the procedure creator.)\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/alter-procedure.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/alter-procedure.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (438,18,'BIT_COUNT','Syntax:\nBIT_COUNT(N)\n\nReturns the number of bits that are set in the argument N.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html\n\n','mysql> SELECT BIT_COUNT(29), BIT_COUNT(b\'101010\');\n        -> 4, 3\n','http://dev.mysql.com/doc/refman/5.1/en/bit-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (439,35,'OCTET_LENGTH','Syntax:\nOCTET_LENGTH(str)\n\nOCTET_LENGTH() is a synonym for LENGTH().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (440,30,'UTC_TIMESTAMP','Syntax:\nUTC_TIMESTAMP, UTC_TIMESTAMP()\n\nReturns the current UTC date and time as a value in \'YYYY-MM-DD\nHH:MM:SS\' or YYYYMMDDHHMMSS.uuuuuu format, depending on whether the\nfunction is used in a string or numeric context.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT UTC_TIMESTAMP(), UTC_TIMESTAMP() + 0;\n        -> \'2003-08-14 18:08:04\', 20030814180804.000000\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (441,11,'AES_ENCRYPT','Syntax:\nAES_ENCRYPT(str,key_str)\n\nAES_ENCRYPT() and AES_DECRYPT() allow encryption and decryption of data\nusing the official AES (Advanced Encryption Standard) algorithm,\npreviously known as "Rijndael." Encoding with a 128-bit key length is\nused, but you can extend it up to 256 bits by modifying the source. We\nchose 128 bits because it is much faster and it is secure enough for\nmost purposes.\n\nAES_ENCRYPT() encrypts a string and returns a binary string.\nAES_DECRYPT() decrypts the encrypted string and returns the original\nstring. The input arguments may be any length. If either argument is\nNULL, the result of this function is also NULL.\n\nBecause AES is a block-level algorithm, padding is used to encode\nuneven length strings and so the result string length may be calculated\nusing this formula:\n\n16 x (trunc(string_length / 16) + 1)\n\nIf AES_DECRYPT() detects invalid data or incorrect padding, it returns\nNULL. However, it is possible for AES_DECRYPT() to return a non-NULL\nvalue (possibly garbage) if the input data or the key is invalid.\n\nYou can use the AES functions to store data in an encrypted form by\nmodifying your queries:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','INSERT INTO t VALUES (1,AES_ENCRYPT(\'text\',\'password\'));\n','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (442,4,'+','Syntax:\n+\n\nAddition:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html\n\n','mysql> SELECT 3+5;\n        -> 8\n','http://dev.mysql.com/doc/refman/5.1/en/arithmetic-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (443,14,'INET_NTOA','Syntax:\nINET_NTOA(expr)\n\nGiven a numeric network address in network byte order (4 or 8 byte),\nreturns the dotted-quad representation of the address as a string.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html\n\n','mysql> SELECT INET_NTOA(3520061480);\n        -> \'209.207.224.40\'\n','http://dev.mysql.com/doc/refman/5.1/en/miscellaneous-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (444,4,'ACOS','Syntax:\nACOS(X)\n\nReturns the arc cosine of X, that is, the value whose cosine is X.\nReturns NULL if X is not in the range -1 to 1.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT ACOS(1);\n        -> 0\nmysql> SELECT ACOS(1.0001);\n        -> NULL\nmysql> SELECT ACOS(0);\n        -> 1.5707963267949\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (445,8,'ISOLATION','Syntax:\nSET [GLOBAL | SESSION] TRANSACTION ISOLATION LEVEL\n  {\n       READ UNCOMMITTED\n     | READ COMMITTED\n     | REPEATABLE READ\n     | SERIALIZABLE\n   }\n\nThis statement sets the transaction isolation level globally, for the\ncurrent session, or for the next transaction:\n\no With the GLOBAL keyword, the statement sets the default transaction\n  level globally for all subsequent sessions. Existing sessions are\n  unaffected.\n\no With the SESSION keyword, the statement sets the default transaction\n  level for all subsequent transactions performed within the current\n  session.\n\no Without any SESSION or GLOBAL keyword, the statement sets the\n  isolation level for the next (not started) transaction performed\n  within the current session.\n\nA change to the global default isolation level requires the SUPER\nprivilege. Any session is free to change its session isolation level\n(even in the middle of a transaction), or the isolation level for its\nnext transaction.\n\nTo set the global default isolation level at server startup, use the\n--transaction-isolation=level option to mysqld on the command line or\nin an option file. Values of level for this option use dashes rather\nthan spaces, so the allowable values are READ-UNCOMMITTED,\nREAD-COMMITTED, REPEATABLE-READ, or SERIALIZABLE. For example, to set\nthe default isolation level to REPEATABLE READ, use these lines in the\n[mysqld] section of an option file:\n\n[mysqld]\ntransaction-isolation = REPEATABLE-READ\n\nTo determine the global and session transaction isolation levels at\nruntime, check the value of the tx_isolation system variable:\n\nSELECT @@GLOBAL.tx_isolation, @@tx_isolation;\n\nInnoDB supports each of the translation isolation levels described here\nusing different locking strategies. The default level is REPEATABLE\nREAD. For additional information about InnoDB record-level locks and\nhow it uses them to execute various types of statements, see\nhttp://dev.mysql.com/doc/refman/5.1/en/innodb-record-level-locks.html,\nand http://dev.mysql.com/doc/refman/5.1/en/innodb-locks-set.html.\n\nThe following list describes how MySQL supports the different\ntransaction levels:\n\no READ UNCOMMITTED\n\n  SELECT statements are performed in a nonlocking fashion, but a\n  possible earlier version of a row might be used. Thus, using this\n  isolation level, such reads are not consistent. This is also called a\n  "dirty read." Otherwise, this isolation level works like READ\n  COMMITTED.\n\no READ COMMITTED\n\n  A somewhat Oracle-like isolation level with respect to consistent\n  (nonlocking) reads: Each consistent read, even within the same\n  transaction, sets and reads its own fresh snapshot. See\n  http://dev.mysql.com/doc/refman/5.1/en/innodb-consistent-read.html.\n\n  For locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE),\n  InnoDB locks only index records, not the gaps before them, and thus\n  allows the free insertion of new records next to locked records. For\n  UPDATE and DELETE statements, locking depends on whether the\n  statement uses a unique index with a unique search condition (such as\n  WHERE id = 100), or a range-type search condition (such as WHERE id >\n  100). For a unique index with a unique search condition, InnoDB locks\n  only the index record found, not the gap before it. For range-type\n  searches, InnoDB locks the index range scanned, using gap locks or\n  next-key (gap plus index-record) locks to block insertions by other\n  sessions into the gaps covered by the range. This is necessary\n  because "phantom rows" must be blocked for MySQL replication and\n  recovery to work.\n\n  *Note*: In MySQL 5.1, if the READ COMMITTED isolation level is used\n  or the innodb_locks_unsafe_for_binlog system variable is enabled,\n  there is no InnoDB gap locking except for foreign-key constraint\n  checking and duplicate-key checking. Also, record locks for\n  nonmatching rows are released after MySQL has evaluated the WHERE\n  condition. As of MySQL 5.1, if you use READ COMMITTED or enable\n  innodb_locks_unsafe_for_binlog, you must use row-based binary\n  logging.\n\no REPEATABLE READ\n\n  This is the default isolation level for InnoDB. For consistent reads,\n  there is an important difference from the READ COMMITTED isolation\n  level: All consistent reads within the same transaction read the\n  snapshot established by the first read. This convention means that if\n  you issue several plain (nonlocking) SELECT statements within the\n  same transaction, these SELECT statements are consistent also with\n  respect to each other. See\n  http://dev.mysql.com/doc/refman/5.1/en/innodb-consistent-read.html.\n\n  For locking reads (SELECT with FOR UPDATE or LOCK IN SHARE MODE),\n  UPDATE, and DELETE statements, locking depends on whether the\n  statement uses a unique index with a unique search condition, or a\n  range-type search condition. For a unique index with a unique search\n  condition, InnoDB locks only the index record found, not the gap\n  before it. For other search conditions, InnoDB locks the index range\n  scanned, using gap locks or next-key (gap plus index-record) locks to\n  block insertions by other sessions into the gaps covered by the\n  range.\n\no SERIALIZABLE\n\n  This level is like REPEATABLE READ, but InnoDB implicitly converts\n  all plain SELECT statements to SELECT ... LOCK IN SHARE MODE if\n  autocommit is disabled. If autocommit is enabled, the SELECT is its\n  own transaction. It therefore is known to be read only and can be\n  serialized if performed as a consistent (nonlocking) read and need\n  not block for other transactions. (This means that to force a plain\n  SELECT to block if other transactions have modified the selected\n  rows, you should disable autocommit.)\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/set-transaction.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/set-transaction.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (446,4,'CEILING','Syntax:\nCEILING(X)\n\nReturns the smallest integer value not less than X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT CEILING(1.23);\n        -> 2\nmysql> SELECT CEILING(-1.23);\n        -> -1\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (447,4,'SIN','Syntax:\nSIN(X)\n\nReturns the sine of X, where X is given in radians.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT SIN(PI());\n        -> 1.2246063538224e-16\nmysql> SELECT ROUND(SIN(PI()));\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (448,30,'DAYOFWEEK','Syntax:\nDAYOFWEEK(date)\n\nReturns the weekday index for date (1 = Sunday, 2 = Monday, ..., 7 =\nSaturday). These index values correspond to the ODBC standard.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT DAYOFWEEK(\'2007-02-03\');\n        -> 7\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (449,25,'SHOW PROCESSLIST','Syntax:\nSHOW [FULL] PROCESSLIST\n\nSHOW PROCESSLIST shows you which threads are running. You can also get\nthis information from the INFORMATION_SCHEMA PROCESSLIST table or the\nmysqladmin processlist command. If you have the PROCESS privilege, you\ncan see all threads. Otherwise, you can see only your own threads (that\nis, threads associated with the MySQL account that you are using). If\nyou do not use the FULL keyword, only the first 100 characters of each\nstatement are shown in the Info field.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-processlist.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-processlist.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (450,31,'LINEFROMWKB','LineFromWKB(wkb[,srid]), LineStringFromWKB(wkb[,srid])\n\nConstructs a LINESTRING value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkb-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkb-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (451,34,'GEOMETRYTYPE','GeometryType(g)\n\nReturns as a string the name of the geometry type of which the geometry\ninstance g is a member. The name corresponds to one of the instantiable\nGeometry subclasses.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#general-geometry-property-functions\n\n','mysql> SELECT GeometryType(GeomFromText(\'POINT(1 1)\'));\n+------------------------------------------+\n| GeometryType(GeomFromText(\'POINT(1 1)\')) |\n+------------------------------------------+\n| POINT                                    |\n+------------------------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#general-geometry-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (452,37,'CREATE VIEW','Syntax:\nCREATE\n    [OR REPLACE]\n    [ALGORITHM = {UNDEFINED | MERGE | TEMPTABLE}]\n    [DEFINER = { user | CURRENT_USER }]\n    [SQL SECURITY { DEFINER | INVOKER }]\n    VIEW view_name [(column_list)]\n    AS select_statement\n    [WITH [CASCADED | LOCAL] CHECK OPTION]\n\nThe CREATE VIEW statement creates a new view, or replaces an existing\none if the OR REPLACE clause is given. If the view does not exist,\nCREATE OR REPLACE VIEW is the same as CREATE VIEW. If the view does\nexist, CREATE OR REPLACE VIEW is the same as ALTER VIEW.\n\nThe select_statement is a SELECT statement that provides the definition\nof the view. (When you select from the view, you select in effect using\nthe SELECT statement.) select_statement can select from base tables or\nother views.\n\nThe view definition is "frozen" at creation time, so changes to the\nunderlying tables afterward do not affect the view definition. For\nexample, if a view is defined as SELECT * on a table, new columns added\nto the table later do not become part of the view.\n\nThe ALGORITHM clause affects how MySQL processes the view. The DEFINER\nand SQL SECURITY clauses specify the security context to be used when\nchecking access privileges at view invocation time. The WITH CHECK\nOPTION clause can be given to constrain inserts or updates to rows in\ntables referenced by the view. These clauses are described later in\nthis section.\n\nThe CREATE VIEW statement requires the CREATE VIEW privilege for the\nview, and some privilege for each column selected by the SELECT\nstatement. For columns used elsewhere in the SELECT statement you must\nhave the SELECT privilege. If the OR REPLACE clause is present, you\nmust also have the DROP privilege for the view.\n\nA view belongs to a database. By default, a new view is created in the\ndefault database. To create the view explicitly in a given database,\nspecify the name as db_name.view_name when you create it.\n\nmysql> CREATE VIEW test.v AS SELECT * FROM t;\n\nBase tables and views share the same namespace within a database, so a\ndatabase cannot contain a base table and a view that have the same\nname.\n\nViews must have unique column names with no duplicates, just like base\ntables. By default, the names of the columns retrieved by the SELECT\nstatement are used for the view column names. To define explicit names\nfor the view columns, the optional column_list clause can be given as a\nlist of comma-separated identifiers. The number of names in column_list\nmust be the same as the number of columns retrieved by the SELECT\nstatement.\n\n*Note*: Prior to MySQL 5.1.29, when you modify an existing view, the\ncurrent view definition is backed up and saved. It is stored in that\ntable\'s database directory, in a subdirectory named arc. The backup\nfile for a view v is named v.frm-00001. If you alter the view again,\nthe next backup is named v.frm-00002. The three latest view backup\ndefinitions are stored. Backed up view definitions are not preserved by\nmysqldump, or any other such programs, but you can retain them using a\nfile copy operation. However, they are not needed for anything but to\nprovide you with a backup of your previous view definition. It is safe\nto remove these backup definitions, but only while mysqld is not\nrunning. If you delete the arc subdirectory or its files while mysqld\nis running, you will receive an error the next time you try to alter\nthe view: mysql> ALTER VIEW v AS SELECT * FROM t; ERROR 6 (HY000):\nError on delete of \'.\\test\\arc/v.frm-0004\' (Errcode: 2)\n\nColumns retrieved by the SELECT statement can be simple references to\ntable columns. They can also be expressions that use functions,\nconstant values, operators, and so forth.\n\nUnqualified table or view names in the SELECT statement are interpreted\nwith respect to the default database. A view can refer to tables or\nviews in other databases by qualifying the table or view name with the\nproper database name.\n\nA view can be created from many kinds of SELECT statements. It can\nrefer to base tables or other views. It can use joins, UNION, and\nsubqueries. The SELECT need not even refer to any tables. The following\nexample defines a view that selects two columns from another table, as\nwell as an expression calculated from those columns:\n\nmysql> CREATE TABLE t (qty INT, price INT);\nmysql> INSERT INTO t VALUES(3, 50);\nmysql> CREATE VIEW v AS SELECT qty, price, qty*price AS value FROM t;\nmysql> SELECT * FROM v;\n+------+-------+-------+\n| qty  | price | value |\n+------+-------+-------+\n|    3 |    50 |   150 |\n+------+-------+-------+\n\nA view definition is subject to the following restrictions:\n\no The SELECT statement cannot contain a subquery in the FROM clause.\n\no The SELECT statement cannot refer to system or user variables.\n\no Within a stored program, the definition cannot refer to program\n  parameters or local variables.\n\no The SELECT statement cannot refer to prepared statement parameters.\n\no Any table or view referred to in the definition must exist. However,\n  after a view has been created, it is possible to drop a table or view\n  that the definition refers to. In this case, use of the view results\n  in an error. To check a view definition for problems of this kind,\n  use the CHECK TABLE statement.\n\no The definition cannot refer to a TEMPORARY table, and you cannot\n  create a TEMPORARY view.\n\no Any tables named in the view definition must exist at definition\n  time.\n\no You cannot associate a trigger with a view.\n\no As of MySQL 5.1.23, aliases for column names in the SELECT statement\n  are checked against the maximum column length of 64 characters (not\n  the maximum alias length of 256 characters).\n\nORDER BY is allowed in a view definition, but it is ignored if you\nselect from a view using a statement that has its own ORDER BY.\n\nFor other options or clauses in the definition, they are added to the\noptions or clauses of the statement that references the view, but the\neffect is undefined. For example, if a view definition includes a LIMIT\nclause, and you select from the view using a statement that has its own\nLIMIT clause, it is undefined which limit applies. This same principle\napplies to options such as ALL, DISTINCT, or SQL_SMALL_RESULT that\nfollow the SELECT keyword, and to clauses such as INTO, FOR UPDATE,\nLOCK IN SHARE MODE, and PROCEDURE.\n\nIf you create a view and then change the query processing environment\nby changing system variables, that may affect the results that you get\nfrom the view:\n\nmysql> CREATE VIEW v (mycol) AS SELECT \'abc\';\nQuery OK, 0 rows affected (0.01 sec)\n\nmysql> SET sql_mode = \'\';\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT "mycol" FROM v;\n+-------+\n| mycol |\n+-------+\n| mycol |\n+-------+\n1 row in set (0.01 sec)\n\nmysql> SET sql_mode = \'ANSI_QUOTES\';\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SELECT "mycol" FROM v;\n+-------+\n| mycol |\n+-------+\n| abc   |\n+-------+\n1 row in set (0.00 sec)\n\nThe DEFINER and SQL SECURITY clauses determine which MySQL account to\nuse when checking access privileges for the view when a statement is\nexecuted that references the view. They were addded in MySQL 5.1.2. The\nlegal SQL SECURITY characteristic values are DEFINER and INVOKER. These\nindicate that the required privileges must be held by the user who\ndefined or invoked the view, respectively. The default SQL SECURITY\nvalue is DEFINER.\n\nIf a user value is given for the DEFINER clause, it should be a MySQL\naccount in \'user_name\'@\'host_name\' format (the same format used in the\nGRANT statement). The user_name and host_name values both are required.\nThe definer can also be given as CURRENT_USER or CURRENT_USER(). The\ndefault DEFINER value is the user who executes the CREATE VIEW\nstatement. This is the same as specifying DEFINER = CURRENT_USER\nexplicitly.\n\nIf you specify the DEFINER clause, these rules determine the legal\nDEFINER user values:\n\no If you do not have the SUPER privilege, the only legal user value is\n  your own account, either specified literally or by using\n  CURRENT_USER. You cannot set the definer to some other account.\n\no If you have the SUPER privilege, you can specify any syntactically\n  legal account name. If the account does not actually exist, a warning\n  is generated.\n\no If the SQL SECURITY value is DEFINER but the definer account does not\n  exist when the view is referenced, an error occurs.\n\nWithin a view definition, CURRENT_USER returns the view\'s DEFINER value\nby default as of MySQL 5.1.12. For older versions, and for views\ndefined with the SQL SECURITY INVOKER characteristic, CURRENT_USER\nreturns the account for the view\'s invoker. For information about user\nauditing within views, see\nhttp://dev.mysql.com/doc/refman/5.1/en/account-activity-auditing.html.\n\nWithin a stored routine that is defined with the SQL SECURITY DEFINER\ncharacteristic, CURRENT_USER returns the routine\'s DEFINER value. This\nalso affects a view defined within such a program, if the view\ndefinition contains a DEFINER value of CURRENT_USER.\n\nAs of MySQL 5.1.2 (when the DEFINER and SQL SECURITY clauses were\nimplemented), view privileges are checked like this:\n\no At view definition time, the view creator must have the privileges\n  needed to use the top-level objects accessed by the view. For\n  example, if the view definition refers to table columns, the creator\n  must have privileges for the columns, as described previously. If the\n  definition refers to a stored function, only the privileges needed to\n  invoke the function can be checked. The privileges required when the\n  function runs can be checked only as it executes: For different\n  invocations of the function, different execution paths within the\n  function might be taken.\n\no When a view is referenced, privileges for objects accessed by the\n  view are checked against the privileges held by the view creator or\n  invoker, depending on whether the SQL SECURITY characteristic is\n  DEFINER or INVOKER, respectively.\n\no If reference to a view causes execution of a stored function,\n  privilege checking for statements executed within the function depend\n  on whether the function is defined with a SQL SECURITY characteristic\n  of DEFINER or INVOKER. If the security characteristic is DEFINER, the\n  function runs with the privileges of its creator. If the\n  characteristic is INVOKER, the function runs with the privileges\n  determined by the view\'s SQL SECURITY characteristic.\n\nPrior to MySQL 5.1.2 (before the DEFINER and SQL SECURITY clauses were\nimplemented), privileges required for objects used in a view are\nchecked at view creation time.\n\nExample: A view might depend on a stored function, and that function\nmight invoke other stored routines. For example, the following view\ninvokes a stored function f():\n\nCREATE VIEW v AS SELECT * FROM t WHERE t.id = f(t.name);\n\nSuppose that f() contains a statement such as this:\n\nIF name IS NULL then\n  CALL p1();\nELSE\n  CALL p2();\nEND IF;\n\nThe privileges required for executing statements within f() need to be\nchecked when f() executes. This might mean that privileges are needed\nfor p1() or p2(), depending on the execution path within f(). Those\nprivileges must be checked at runtime, and the user who must possess\nthe privileges is determined by the SQL SECURITY values of the view v\nand the function f().\n\nThe DEFINER and SQL SECURITY clauses for views are extensions to\nstandard SQL. In standard SQL, views are handled using the rules for\nSQL SECURITY INVOKER.\n\nIf you invoke a view that was created before MySQL 5.1.2, it is treated\nas though it was created with a SQL SECURITY DEFINER clause and with a\nDEFINER value that is the same as your account. However, because the\nactual definer is unknown, MySQL issues a warning. To make the warning\ngo away, it is sufficient to re-create the view so that the view\ndefinition includes a DEFINER clause.\n\nThe optional ALGORITHM clause is a MySQL extension to standard SQL. It\naffects how MySQL processes the view. ALGORITHM takes three values:\nMERGE, TEMPTABLE, or UNDEFINED. The default algorithm is UNDEFINED if\nno ALGORITHM clause is present. For more information, see\nhttp://dev.mysql.com/doc/refman/5.1/en/view-algorithms.html.\n\nSome views are updatable. That is, you can use them in statements such\nas UPDATE, DELETE, or INSERT to update the contents of the underlying\ntable. For a view to be updatable, there must be a one-to-one\nrelationship between the rows in the view and the rows in the\nunderlying table. There are also certain other constructs that make a\nview nonupdatable.\n\nThe WITH CHECK OPTION clause can be given for an updatable view to\nprevent inserts or updates to rows except those for which the WHERE\nclause in the select_statement is true.\n\nIn a WITH CHECK OPTION clause for an updatable view, the LOCAL and\nCASCADED keywords determine the scope of check testing when the view is\ndefined in terms of another view. The LOCAL keyword restricts the CHECK\nOPTION only to the view being defined. CASCADED causes the checks for\nunderlying views to be evaluated as well. When neither keyword is\ngiven, the default is CASCADED.\n\nFor more information about updatable views and the WITH CHECK OPTION\nclause, see\nhttp://dev.mysql.com/doc/refman/5.1/en/view-updatability.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-view.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-view.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (453,35,'TRIM','Syntax:\nTRIM([{BOTH | LEADING | TRAILING} [remstr] FROM] str), TRIM([remstr\nFROM] str)\n\nReturns the string str with all remstr prefixes or suffixes removed. If\nnone of the specifiers BOTH, LEADING, or TRAILING is given, BOTH is\nassumed. remstr is optional and, if not specified, spaces are removed.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT TRIM(\'  bar   \');\n        -> \'bar\'\nmysql> SELECT TRIM(LEADING \'x\' FROM \'xxxbarxxx\');\n        -> \'barxxx\'\nmysql> SELECT TRIM(BOTH \'x\' FROM \'xxxbarxxx\');\n        -> \'bar\'\nmysql> SELECT TRIM(TRAILING \'xyz\' FROM \'barxxyz\');\n        -> \'barx\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (454,17,'IS','Syntax:\nIS boolean_value\n\nTests a value against a boolean value, where boolean_value can be TRUE,\nFALSE, or UNKNOWN.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 1 IS TRUE, 0 IS FALSE, NULL IS UNKNOWN;\n        -> 1, 1, 1\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (455,30,'GET_FORMAT','Syntax:\nGET_FORMAT({DATE|TIME|DATETIME}, {\'EUR\'|\'USA\'|\'JIS\'|\'ISO\'|\'INTERNAL\'})\n\nReturns a format string. This function is useful in combination with\nthe DATE_FORMAT() and the STR_TO_DATE() functions.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT DATE_FORMAT(\'2003-10-03\',GET_FORMAT(DATE,\'EUR\'));\n        -> \'03.10.2003\'\nmysql> SELECT STR_TO_DATE(\'10.31.2003\',GET_FORMAT(DATE,\'USA\'));\n        -> \'2003-10-31\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (456,20,'TINYBLOB','TINYBLOB\n\nA BLOB column with a maximum length of 255 (28 - 1) bytes. Each\nTINYBLOB value is stored using a one-byte length prefix that indicates\nthe number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (457,8,'SAVEPOINT','Syntax:\nSAVEPOINT identifier\nROLLBACK [WORK] TO [SAVEPOINT] identifier\nRELEASE SAVEPOINT identifier\n\nInnoDB supports the SQL statements SAVEPOINT, ROLLBACK TO SAVEPOINT,\nRELEASE SAVEPOINT and the optional WORK keyword for ROLLBACK.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/savepoint.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/savepoint.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (458,15,'USER','Syntax:\nUSER()\n\nReturns the current MySQL user name and host name as a string in the\nutf8 character set.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT USER();\n        -> \'davida@localhost\'\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (459,37,'ALTER TABLE','Syntax:\nALTER [ONLINE | OFFLINE] [IGNORE] TABLE tbl_name\n    alter_specification [, alter_specification] ...\n\nalter_specification:\n    table_options\n  | ADD [COLUMN] col_name column_definition\n        [FIRST | AFTER col_name ]\n  | ADD [COLUMN] (col_name column_definition,...)\n  | ADD {INDEX|KEY} [index_name]\n        [index_type] (index_col_name,...) [index_option] ...\n  | ADD [CONSTRAINT [symbol]] PRIMARY KEY\n        [index_type] (index_col_name,...) [index_option] ...\n  | ADD [CONSTRAINT [symbol]]\n        UNIQUE [INDEX|KEY] [index_name]\n        [index_type] (index_col_name,...) [index_option] ...\n  | ADD FULLTEXT [INDEX|KEY] [index_name]\n        (index_col_name,...) [index_option] ...\n  | ADD SPATIAL [INDEX|KEY] [index_name]\n        (index_col_name,...) [index_option] ...\n  | ADD [CONSTRAINT [symbol]]\n        FOREIGN KEY [index_name] (index_col_name,...)\n        reference_definition\n  | ALTER [COLUMN] col_name {SET DEFAULT literal | DROP DEFAULT}\n  | CHANGE [COLUMN] old_col_name new_col_name column_definition\n        [FIRST|AFTER col_name]\n  | MODIFY [COLUMN] col_name column_definition\n        [FIRST | AFTER col_name]\n  | DROP [COLUMN] col_name\n  | DROP PRIMARY KEY\n  | DROP {INDEX|KEY} index_name\n  | DROP FOREIGN KEY fk_symbol\n  | DISABLE KEYS\n  | ENABLE KEYS\n  | RENAME [TO] new_tbl_name\n  | ORDER BY col_name [, col_name] ...\n  | CONVERT TO CHARACTER SET charset_name [COLLATE collation_name]\n  | [DEFAULT] CHARACTER SET [=] charset_name [COLLATE [=] collation_name]\n  | DISCARD TABLESPACE\n  | IMPORT TABLESPACE\n  | partition_options\n  | ADD PARTITION (partition_definition)\n  | DROP PARTITION partition_names\n  | COALESCE PARTITION number\n  | REORGANIZE PARTITION [partition_names INTO (partition_definitions)]\n  | ANALYZE PARTITION partition_names\n  | CHECK PARTITION partition_names\n  | OPTIMIZE PARTITION partition_names\n  | REBUILD PARTITION partition_names\n  | REPAIR PARTITION partition_names\n  | REMOVE PARTITIONING\n\nindex_col_name:\n    col_name [(length)] [ASC | DESC]\n\nindex_type:\n    USING {BTREE | HASH | RTREE}\n\nindex_option:\n    KEY_BLOCK_SIZE [=] value\n  | index_type\n  | WITH PARSER parser_name\n  | COMMENT \'string\'\n\ntable_options:\n    table_option [[,] table_option] ...\n\nALTER TABLE enables you to change the structure of an existing table.\nFor example, you can add or delete columns, create or destroy indexes,\nchange the type of existing columns, or rename columns or the table\nitself. You can also change the comment for the table and type of the\ntable.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/alter-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/alter-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (460,31,'MPOINTFROMWKB','MPointFromWKB(wkb[,srid]), MultiPointFromWKB(wkb[,srid])\n\nConstructs a MULTIPOINT value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkb-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkb-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (461,20,'CHAR BYTE','The CHAR BYTE data type is an alias for the BINARY data type. This is a\ncompatibility feature.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (462,19,'REPAIR TABLE','Syntax:\nREPAIR [NO_WRITE_TO_BINLOG | LOCAL] TABLE\n    tbl_name [, tbl_name] ...\n    [QUICK] [EXTENDED] [USE_FRM]\n\nREPAIR TABLE repairs a possibly corrupted table. By default, it has the\nsame effect as myisamchk --recover tbl_name. REPAIR TABLE works for\nMyISAM and for ARCHIVE tables. Starting with MySQL 5.1.9, REPAIR is\nalso valid for CSV tables. See\nhttp://dev.mysql.com/doc/refman/5.1/en/myisam-storage-engine.html, and\nhttp://dev.mysql.com/doc/refman/5.1/en/archive-storage-engine.html, and\nhttp://dev.mysql.com/doc/refman/5.1/en/csv-storage-engine.html\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nBeginning with MySQL 5.1.27, REPAIR TABLE is also supported for\npartitioned tables. However, the USE_FRM option cannot be used with\nthis statement on a partitioned table.\n\nAlso beginning with MySQL 5.1.27, you can use ALTER TABLE ... REPAIR\nPARTITION to repair one or more partitions; for more information, see\n[HELP ALTER TABLE], and\nhttp://dev.mysql.com/doc/refman/5.1/en/partitioning-maintenance.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/repair-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/repair-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (463,37,'MERGE','The MERGE storage engine, also known as the MRG_MyISAM engine, is a\ncollection of identical MyISAM tables that can be used as one.\n"Identical" means that all tables have identical column and index\ninformation. You cannot merge MyISAM tables in which the columns are\nlisted in a different order, do not have exactly the same columns, or\nhave the indexes in different order. However, any or all of the MyISAM\ntables can be compressed with myisampack. See\nhttp://dev.mysql.com/doc/refman/5.1/en/myisampack.html. Differences in\ntable options such as AVG_ROW_LENGTH, MAX_ROWS, or PACK_KEYS do not\nmatter.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/merge-storage-engine.html\n\n','mysql> CREATE TABLE t1 (\n    ->    a INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->    message CHAR(20)) ENGINE=MyISAM;\nmysql> CREATE TABLE t2 (\n    ->    a INT NOT NULL AUTO_INCREMENT PRIMARY KEY,\n    ->    message CHAR(20)) ENGINE=MyISAM;\nmysql> INSERT INTO t1 (message) VALUES (\'Testing\'),(\'table\'),(\'t1\');\nmysql> INSERT INTO t2 (message) VALUES (\'Testing\'),(\'table\'),(\'t2\');\nmysql> CREATE TABLE total (\n    ->    a INT NOT NULL AUTO_INCREMENT,\n    ->    message CHAR(20), INDEX(a))\n    ->    ENGINE=MERGE UNION=(t1,t2) INSERT_METHOD=LAST;\n','http://dev.mysql.com/doc/refman/5.1/en/merge-storage-engine.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (464,37,'CREATE TABLE','Syntax:\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    (create_definition,...)\n    [table_options]\n    [partition_options]\n\nOr:\n\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    [(create_definition,...)]\n    [table_options]\n    [partition_options]\n    select_statement\n\nOr:\n\nCREATE [TEMPORARY] TABLE [IF NOT EXISTS] tbl_name\n    { LIKE old_tbl_name | (LIKE old_tbl_name) }\n\ncreate_definition:\n    col_name column_definition\n  | [CONSTRAINT [symbol]] PRIMARY KEY [index_type] (index_col_name,...)\n      [index_option] ...\n  | {INDEX|KEY} [index_name] [index_type] (index_col_name,...)\n      [index_option] ...\n  | [CONSTRAINT [symbol]] UNIQUE [INDEX|KEY]\n      [index_name] [index_type] (index_col_name,...)\n      [index_option] ...\n  | {FULLTEXT|SPATIAL} [INDEX|KEY] [index_name] (index_col_name,...)\n      [index_option] ...\n  | [CONSTRAINT [symbol]] FOREIGN KEY\n      [index_name] (index_col_name,...) reference_definition\n  | CHECK (expr)\n\ncolumn_definition:\n    data_type [NOT NULL | NULL] [DEFAULT default_value]\n      [AUTO_INCREMENT] [UNIQUE [KEY] | [PRIMARY] KEY]\n      [COMMENT \'string\']\n      [COLUMN_FORMAT {FIXED|DYNAMIC|DEFAULT}]\n      [STORAGE {DISK|MEMORY|DEFAULT}]\n      [reference_definition]\n\ndata_type:\n    BIT[(length)]\n  | TINYINT[(length)] [UNSIGNED] [ZEROFILL]\n  | SMALLINT[(length)] [UNSIGNED] [ZEROFILL]\n  | MEDIUMINT[(length)] [UNSIGNED] [ZEROFILL]\n  | INT[(length)] [UNSIGNED] [ZEROFILL]\n  | INTEGER[(length)] [UNSIGNED] [ZEROFILL]\n  | BIGINT[(length)] [UNSIGNED] [ZEROFILL]\n  | REAL[(length,decimals)] [UNSIGNED] [ZEROFILL]\n  | DOUBLE[(length,decimals)] [UNSIGNED] [ZEROFILL]\n  | FLOAT[(length,decimals)] [UNSIGNED] [ZEROFILL]\n  | DECIMAL[(length[,decimals])] [UNSIGNED] [ZEROFILL]\n  | NUMERIC[(length[,decimals])] [UNSIGNED] [ZEROFILL]\n  | DATE\n  | TIME\n  | TIMESTAMP\n  | DATETIME\n  | YEAR\n  | CHAR[(length)]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | VARCHAR(length)\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | BINARY[(length)]\n  | VARBINARY(length)\n  | TINYBLOB\n  | BLOB\n  | MEDIUMBLOB\n  | LONGBLOB\n  | TINYTEXT [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | TEXT [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | MEDIUMTEXT [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | LONGTEXT [BINARY]\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | ENUM(value1,value2,value3,...)\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | SET(value1,value2,value3,...)\n      [CHARACTER SET charset_name] [COLLATE collation_name]\n  | spatial_type\n\nindex_col_name:\n    col_name [(length)] [ASC | DESC]\n\nindex_type:\n    USING {BTREE | HASH | RTREE}\n\nindex_option:\n    KEY_BLOCK_SIZE [=] value\n  | index_type\n  | WITH PARSER parser_name\n\nreference_definition:\n    REFERENCES tbl_name (index_col_name,...)\n      [MATCH FULL | MATCH PARTIAL | MATCH SIMPLE]\n      [ON DELETE reference_option]\n      [ON UPDATE reference_option]\n\nreference_option:\n    RESTRICT | CASCADE | SET NULL | NO ACTION\n\ntable_options:\n    table_option [[,] table_option] ...\n\ntable_option:\n    ENGINE [=] engine_name\n  | AUTO_INCREMENT [=] value\n  | AVG_ROW_LENGTH [=] value\n  | [DEFAULT] CHARACTER SET [=] charset_name\n  | CHECKSUM [=] {0 | 1}\n  | [DEFAULT] COLLATE [=] collation_name\n  | COMMENT [=] \'string\'\n  | CONNECTION [=] \'connect_string\'\n  | DATA DIRECTORY [=] \'absolute path to directory\'\n  | DELAY_KEY_WRITE [=] {0 | 1}\n  | INDEX DIRECTORY [=] \'absolute path to directory\'\n  | INSERT_METHOD [=] { NO | FIRST | LAST }\n  | KEY_BLOCK_SIZE [=] value\n  | MAX_ROWS [=] value\n  | MIN_ROWS [=] value\n  | PACK_KEYS [=] {0 | 1 | DEFAULT}\n  | PASSWORD [=] \'string\'\n  | ROW_FORMAT [=] {DEFAULT|DYNAMIC|FIXED|COMPRESSED|REDUNDANT|COMPACT}\n  | TABLESPACE tablespace_name [STORAGE {DISK|MEMORY|DEFAULT}]\n  | UNION [=] (tbl_name[,tbl_name]...)\n\npartition_options:\n    PARTITION BY\n        { [LINEAR] HASH(expr)\n        | [LINEAR] KEY(column_list)\n        | RANGE(expr)\n        | LIST(expr) }\n    [PARTITIONS num]\n    [SUBPARTITION BY\n        { [LINEAR] HASH(expr)\n        | [LINEAR] KEY(column_list) }\n      [SUBPARTITIONS num]\n    ]\n    [(partition_definition [, partition_definition] ...)]\n\npartition_definition:\n    PARTITION partition_name\n        [VALUES {LESS THAN {(expr) | MAXVALUE} | IN (value_list)}]\n        [[STORAGE] ENGINE [=] engine_name]\n        [COMMENT [=] \'comment_text\' ]\n        [DATA DIRECTORY [=] \'data_dir\']\n        [INDEX DIRECTORY [=] \'index_dir\']\n        [MAX_ROWS [=] max_number_of_rows]\n        [MIN_ROWS [=] min_number_of_rows]\n        [TABLESPACE [=] tablespace_name]\n        [NODEGROUP [=] node_group_id]\n        [(subpartition_definition [, subpartition_definition] ...)]\n\nsubpartition_definition:\n    SUBPARTITION logical_name\n        [[STORAGE] ENGINE [=] engine_name]\n        [COMMENT [=] \'comment_text\' ]\n        [DATA DIRECTORY [=] \'data_dir\']\n        [INDEX DIRECTORY [=] \'index_dir\']\n        [MAX_ROWS [=] max_number_of_rows]\n        [MIN_ROWS [=] min_number_of_rows]\n        [TABLESPACE [=] tablespace_name]\n        [NODEGROUP [=] node_group_id]\n\nselect_statement:\n    [IGNORE | REPLACE] [AS] SELECT ...   (Some legal select statement)\n\nCREATE TABLE creates a table with the given name. You must have the\nCREATE privilege for the table.\n\nRules for allowable table names are given in\nhttp://dev.mysql.com/doc/refman/5.1/en/identifiers.html. By default,\nthe table is created in the default database. An error occurs if the\ntable exists, if there is no default database, or if the database does\nnot exist.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/create-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (465,17,'>','Syntax:\n>\n\nGreater than:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT 2 > 2;\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (466,19,'ANALYZE TABLE','Syntax:\nANALYZE [NO_WRITE_TO_BINLOG | LOCAL] TABLE\n    tbl_name [, tbl_name] ...\n\nANALYZE TABLE analyzes and stores the key distribution for a table.\nDuring the analysis, the table is locked with a read lock for MyISAM.\nFor InnoDB the table is locked with a write lock. This statement works\nwith MyISAM, and InnoDB tables. For MyISAM tables, this statement is\nequivalent to using myisamchk --analyze.\n\nFor more information on how the analysis works within InnoDB, see\nhttp://dev.mysql.com/doc/refman/5.1/en/innodb-restrictions.html.\n\nMySQL uses the stored key distribution to decide the order in which\ntables should be joined when you perform a join on something other than\na constant. In addition, key distributions can be used when deciding\nwhich indexes to use for a specific table within a query.\n\nThis statement requires SELECT and INSERT privileges for the table.\n\nBeginning with MySQL 5.1.27, ANALYZE TABLE is also supported for\npartitioned tables. Also beginning with MySQL 5.1.27, you can use ALTER\nTABLE ... ANALYZE PARTITION to analyze one or more partitions; for more\ninformation, see [HELP ALTER TABLE], and\nhttp://dev.mysql.com/doc/refman/5.1/en/partitioning-maintenance.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/analyze-table.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/analyze-table.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (467,30,'MICROSECOND','Syntax:\nMICROSECOND(expr)\n\nReturns the microseconds from the time or datetime expression expr as a\nnumber in the range from 0 to 999999.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT MICROSECOND(\'12:00:00.123456\');\n        -> 123456\nmysql> SELECT MICROSECOND(\'2009-12-31 23:59:59.000010\');\n        -> 10\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (468,37,'CONSTRAINT','InnoDB supports foreign key constraints. The syntax for a foreign key\nconstraint definition in InnoDB looks like this:\n\n[CONSTRAINT [symbol]] FOREIGN KEY\n    [index_name] (index_col_name, ...)\n    REFERENCES tbl_name (index_col_name,...)\n    [ON DELETE reference_option]\n    [ON UPDATE reference_option]\n\nreference_option:\n    RESTRICT | CASCADE | SET NULL | NO ACTION\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/innodb-foreign-key-constraints.html\n\n','CREATE TABLE product (category INT NOT NULL, id INT NOT NULL,\n                      price DECIMAL,\n                      PRIMARY KEY(category, id)) ENGINE=INNODB;\nCREATE TABLE customer (id INT NOT NULL,\n                       PRIMARY KEY (id)) ENGINE=INNODB;\nCREATE TABLE product_order (no INT NOT NULL AUTO_INCREMENT,\n                            product_category INT NOT NULL,\n                            product_id INT NOT NULL,\n                            customer_id INT NOT NULL,\n                            PRIMARY KEY(no),\n                            INDEX (product_category, product_id),\n                            FOREIGN KEY (product_category, product_id)\n                              REFERENCES product(category, id)\n                              ON UPDATE CASCADE ON DELETE RESTRICT,\n                            INDEX (customer_id),\n                            FOREIGN KEY (customer_id)\n                              REFERENCES customer(id)) ENGINE=INNODB;\n','http://dev.mysql.com/doc/refman/5.1/en/innodb-foreign-key-constraints.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (469,37,'CREATE SERVER','Syntax:\nCREATE SERVER server_name\n    FOREIGN DATA WRAPPER wrapper_name\n    OPTIONS (option [, option] ...)\n\noption:\n  { HOST character-literal\n  | DATABASE character-literal\n  | USER character-literal\n  | PASSWORD character-literal\n  | SOCKET character-literal\n  | OWNER character-literal\n  | PORT numeric-literal }\n\nThis statement creates the definition of a server for use with the\nFEDERATED storage engine. The CREATE SERVER statement creates a new row\nwithin the servers table within the mysql database. This statement\nrequires the SUPER privilege.\n\nThe server_name should be a unique reference to the server. Server\ndefinitions are global within the scope of the server, it is not\npossible to qualify the server definition to a specific database.\nserver_name has a maximum length of 64 characters (names longer than 64\ncharacters are silently truncated), and is case insensitive. You may\nspecify the name as a quoted string.\n\nThe wrapper_name should be mysql, and may be quoted with single quotes.\nOther values for wrapper_name are not currently supported.\n\nFor each option you must specify either a character literal or numeric\nliteral. Character literals are UTF-8, support a maximum length of 64\ncharacters and default to a blank (empty) string. String literals are\nsilently truncated to 64 characters. Numeric literals must be a number\nbetween 0 and 9999, default value is 0.\n\n*Note*: Note that the OWNER option is currently not applied, and has no\neffect on the ownership or operation of the server connection that is\ncreated.\n\nThe CREATE SERVER statement creates an entry in the mysql.server table\nthat can later be used with the CREATE TABLE statement when creating a\nFEDERATED table. The options that you specify will be used to populate\nthe columns in the mysql.server table. The table columns are\nServer_name, Host, Db, Username, Password, Port and Socket.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/create-server.html\n\n','CREATE SERVER s\nFOREIGN DATA WRAPPER mysql\nOPTIONS (USER \'Remote\', HOST \'192.168.1.106\', DATABASE \'test\');\n','http://dev.mysql.com/doc/refman/5.1/en/create-server.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (470,35,'FIELD','Syntax:\nFIELD(str,str1,str2,str3,...)\n\nReturns the index (position) of str in the str1, str2, str3, ... list.\nReturns 0 if str is not found.\n\nIf all arguments to FIELD() are strings, all arguments are compared as\nstrings. If all arguments are numbers, they are compared as numbers.\nOtherwise, the arguments are compared as double.\n\nIf str is NULL, the return value is 0 because NULL fails equality\ncomparison with any value. FIELD() is the complement of ELT().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT FIELD(\'ej\', \'Hej\', \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> 2\nmysql> SELECT FIELD(\'fo\', \'Hej\', \'ej\', \'Heja\', \'hej\', \'foo\');\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (471,30,'MAKETIME','Syntax:\nMAKETIME(hour,minute,second)\n\nReturns a time value calculated from the hour, minute, and second\narguments.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT MAKETIME(12,15,30);\n        -> \'12:15:30\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (472,30,'CURDATE','Syntax:\nCURDATE()\n\nReturns the current date as a value in \'YYYY-MM-DD\' or YYYYMMDD format,\ndepending on whether the function is used in a string or numeric\ncontext.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT CURDATE();\n        -> \'2008-06-13\'\nmysql> SELECT CURDATE() + 0;\n        -> 20080613\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (473,9,'SET PASSWORD','Syntax:\nSET PASSWORD [FOR user] =\n    {\n        PASSWORD(\'some password\')\n      | OLD_PASSWORD(\'some password\')\n      | \'encrypted password\'\n    }\n\nThe SET PASSWORD statement assigns a password to an existing MySQL user\naccount.\n\nIf the password is specified using the PASSWORD() or OLD_PASSWORD()\nfunction, the literal text of the password should be given. If the\npassword is specified without using either function, the password\nshould be the already-encrypted password value as returned by\nPASSWORD().\n\nWith no FOR clause, this statement sets the password for the current\nuser. Any client that has connected to the server using a nonanonymous\naccount can change the password for that account.\n\nWith a FOR clause, this statement sets the password for a specific\naccount on the current server host. Only clients that have the UPDATE\nprivilege for the mysql database can do this. The user value should be\ngiven in user_name@host_name format, where user_name and host_name are\nexactly as they are listed in the User and Host columns of the\nmysql.user table entry. For example, if you had an entry with User and\nHost column values of \'bob\' and \'%.loc.gov\', you would write the\nstatement like this:\n\nSET PASSWORD FOR \'bob\'@\'%.loc.gov\' = PASSWORD(\'newpass\');\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/set-password.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/set-password.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (474,37,'ALTER TABLESPACE','Syntax:\nALTER TABLESPACE tablespace_name\n    {ADD|DROP} DATAFILE \'file_name\'\n    [INITIAL_SIZE [=] size]\n    [WAIT]\n    ENGINE [=] engine_name\n\nThis statement can be used either to add a new data file, or to drop a\ndata file from a tablespace.\n\nThe ADD DATAFILE variant allows you to specify an initial size using an\nINITIAL_SIZE clause, where size is measured in bytes; the default value\nis 128M (128 megabytes). You may optionally follow this integer value\nwith a one-letter abbreviation for an order of magnitude, similar to\nthose used in my.cnf. Generally, this is one of the letters M (for\nmegabytes) or G (for gigabytes).\n\n*Note*: All MySQL Cluster Disk Data objects share the same namespace.\nThis means that each Disk Data object must be uniquely named (and not\nmerely each Disk Data object of a given type). For example, you cannot\nhave a tablespace and an data file with the same name, or an undo log\nfile and a with the same name.\n\nPrior to MySQL Cluster NDB 6.2.17, 6.3.23, and 6.4.3, path and file\nnames for data files could not be longer than 128 characters.\n(Bug#31770 (http://bugs.mysql.com/31770))\n\nOn 32-bit systems, the maximum supported value for INITIAL_SIZE is 4G.\n(Bug#29186 (http://bugs.mysql.com/29186))\n\nOnce a data file has been created, its size cannot be changed; however,\nyou can add more data files to the tablespace using additional ALTER\nTABLESPACE ... ADD DATAFILE statements.\n\nUsing DROP DATAFILE with ALTER TABLESPACE drops the data file\n\'file_name\' from the tablespace. This file must already have been added\nto the tablespace using CREATE TABLESPACE or ALTER TABLESPACE;\notherwise an error will result.\n\nBoth ALTER TABLESPACE ... ADD DATAFILE and ALTER TABLESPACE ... DROP\nDATAFILE require an ENGINE clause which specifies the storage engine\nused by the tablespace. In MySQL 5.1, the only accepted values for\nengine_name are NDB and NDBCLUSTER.\n\nWAIT is parsed but otherwise ignored, and so has no effect in MySQL\n5.1. It is intended for future expansion.\n\nWhen ALTER TABLESPACE ... ADD DATAFILE is used with ENGINE = NDB, a\ndata file is created on each Cluster data node. You can verify that the\ndata files were created and obtain information about them by querying\nthe INFORMATION_SCHEMA.FILES table. For example, the following query\nshows all data files belonging to the tablespace named newts:\n\nmysql> SELECT LOGFILE_GROUP_NAME, FILE_NAME, EXTRA\n    -> FROM INFORMATION_SCHEMA.FILES\n    -> WHERE TABLESPACE_NAME = \'newts\' AND FILE_TYPE = \'DATAFILE\';\n+--------------------+--------------+----------------+\n| LOGFILE_GROUP_NAME | FILE_NAME    | EXTRA          |\n+--------------------+--------------+----------------+\n| lg_3               | newdata.dat  | CLUSTER_NODE=3 |\n| lg_3               | newdata.dat  | CLUSTER_NODE=4 |\n| lg_3               | newdata2.dat | CLUSTER_NODE=3 |\n| lg_3               | newdata2.dat | CLUSTER_NODE=4 |\n+--------------------+--------------+----------------+\n2 rows in set (0.03 sec)\n\nSee http://dev.mysql.com/doc/refman/5.1/en/files-table.html.\n\nALTER TABLESPACE was added in MySQL 5.1.6. In MySQL 5.1, it is useful\nonly with Disk Data storage for MySQL Cluster. See\nhttp://dev.mysql.com/doc/refman/5.1/en/mysql-cluster-disk-data.html.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/alter-tablespace.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/alter-tablespace.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (475,20,'ENUM','ENUM(\'value1\',\'value2\',...) [CHARACTER SET charset_name] [COLLATE\ncollation_name]\n\nAn enumeration. A string object that can have only one value, chosen\nfrom the list of values \'value1\', \'value2\', ..., NULL or the special \'\'\nerror value. An ENUM column can have a maximum of 65,535 distinct\nvalues. ENUM values are represented internally as integers.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (476,7,'IF FUNCTION','Syntax:\nIF(expr1,expr2,expr3)\n\nIf expr1 is TRUE (expr1 <> 0 and expr1 <> NULL) then IF() returns\nexpr2; otherwise it returns expr3. IF() returns a numeric or string\nvalue, depending on the context in which it is used.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html\n\n','mysql> SELECT IF(1>2,2,3);\n        -> 3\nmysql> SELECT IF(1<2,\'yes\',\'no\');\n        -> \'yes\'\nmysql> SELECT IF(STRCMP(\'test\',\'test1\'),\'no\',\'yes\');\n        -> \'no\'\n','http://dev.mysql.com/doc/refman/5.1/en/control-flow-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (477,15,'DATABASE','Syntax:\nDATABASE()\n\nReturns the default (current) database name as a string in the utf8\ncharacter set. If there is no default database, DATABASE() returns\nNULL. Within a stored routine, the default database is the database\nthat the routine is associated with, which is not necessarily the same\nas the database that is the default in the calling context.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT DATABASE();\n        -> \'test\'\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (478,31,'POINTFROMWKB','PointFromWKB(wkb[,srid])\n\nConstructs a POINT value using its WKB representation and SRID.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkb-functions\n\n','','http://dev.mysql.com/doc/refman/5.1/en/creating-spatial-values.html#gis-wkb-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (479,4,'POWER','Syntax:\nPOWER(X,Y)\n\nThis is a synonym for POW().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (480,4,'ATAN','Syntax:\nATAN(X)\n\nReturns the arc tangent of X, that is, the value whose tangent is X.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT ATAN(2);\n        -> 1.1071487177941\nmysql> SELECT ATAN(-2);\n        -> -1.1071487177941\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (481,35,'STRCMP','Syntax:\nSTRCMP(expr1,expr2)\n\nSTRCMP() returns 0 if the strings are the same, -1 if the first\nargument is smaller than the second according to the current sort\norder, and 1 otherwise.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-comparison-functions.html\n\n','mysql> SELECT STRCMP(\'text\', \'text2\');\n        -> -1\nmysql> SELECT STRCMP(\'text2\', \'text\');\n        -> 1\nmysql> SELECT STRCMP(\'text\', \'text\');\n        -> 0\n','http://dev.mysql.com/doc/refman/5.1/en/string-comparison-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (482,26,'INSERT DELAYED','Syntax:\nINSERT DELAYED ...\n\nThe DELAYED option for the INSERT statement is a MySQL extension to\nstandard SQL that is very useful if you have clients that cannot or\nneed not wait for the INSERT to complete. This is a common situation\nwhen you use MySQL for logging and you also periodically run SELECT and\nUPDATE statements that take a long time to complete.\n\nWhen a client uses INSERT DELAYED, it gets an okay from the server at\nonce, and the row is queued to be inserted when the table is not in use\nby any other thread.\n\nAnother major benefit of using INSERT DELAYED is that inserts from many\nclients are bundled together and written in one block. This is much\nfaster than performing many separate inserts.\n\nNote that INSERT DELAYED is slower than a normal INSERT if the table is\nnot otherwise in use. There is also the additional overhead for the\nserver to handle a separate thread for each table for which there are\ndelayed rows. This means that you should use INSERT DELAYED only when\nyou are really sure that you need it.\n\nThe queued rows are held only in memory until they are inserted into\nthe table. This means that if you terminate mysqld forcibly (for\nexample, with kill -9) or if mysqld dies unexpectedly, any queued rows\nthat have not been written to disk are lost.\n\nThere are some constraints on the use of DELAYED:\n\no INSERT DELAYED works only with MyISAM, MEMORY, ARCHIVE, and (as of\n  MySQL 5.1.19) BLACKHOLE tables. For engines that do not support\n  DELAYED, an error occurs.\n\no An error occurs for INSERT DELAYED if used with a table that has been\n  locked with LOCK TABLES because the insert must be handled by a\n  separate thread, not by the session that holds the lock.\n\no For MyISAM tables, if there are no free blocks in the middle of the\n  data file, concurrent SELECT and INSERT statements are supported.\n  Under these circumstances, you very seldom need to use INSERT DELAYED\n  with MyISAM.\n\no INSERT DELAYED should be used only for INSERT statements that specify\n  value lists. The server ignores DELAYED for INSERT ... SELECT or\n  INSERT ... ON DUPLICATE KEY UPDATE statements.\n\no Because the INSERT DELAYED statement returns immediately, before the\n  rows are inserted, you cannot use LAST_INSERT_ID() to get the\n  AUTO_INCREMENT value that the statement might generate.\n\no DELAYED rows are not visible to SELECT statements until they actually\n  have been inserted.\n\no INSERT DELAYED is treated as a normal INSERT if the statement inserts\n  multiple rows and binary logging is enabled and the global logging\n  format is to use statement-based logging (binlog_format is set to\n  STATEMENT). This restriction does not apply to row-based binary\n  logging.\n\no DELAYED is ignored on slave replication servers, so that INSERT\n  DELAYED is treated as a normal INSERT on slaves. This is because\n  DELAYED could cause the slave to have different data than the master.\n\no Pending INSERT DELAYED statements are lost if a table is write locked\n  and ALTER TABLE is used to modify the table structure.\n\no INSERT DELAYED is not supported for views.\n\no INSERT DELAYED is not supported for partitioned tables.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/insert-delayed.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/insert-delayed.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (483,25,'SHOW PROFILE','Syntax:\nSHOW PROFILES\n\nThe SHOW PROFILE statement display profiling information that indicates\nresource usage for statements executed during the course of the current\nsession. It is used together with SHOW PROFILES; see [HELP SHOW\nPROFILES].\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-profile.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-profile.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (484,25,'SHOW PROCEDURE CODE','Syntax:\nSHOW PROCEDURE CODE proc_name\n\nThis statement is a MySQL extension that is available only for servers\nthat have been built with debugging support. It displays a\nrepresentation of the internal implementation of the named stored\nprocedure. A similar statement, SHOW FUNCTION CODE, displays\ninformation about stored functions (see [HELP SHOW FUNCTION CODE]).\n\nBoth statements require that you be the owner of the routine or have\nSELECT access to the mysql.proc table.\n\nIf the named routine is available, each statement produces a result\nset. Each row in the result set corresponds to one "instruction" in the\nroutine. The first column is Pos, which is an ordinal number beginning\nwith 0. The second column is Instruction, which contains an SQL\nstatement (usually changed from the original source), or a directive\nwhich has meaning only to the stored-routine handler.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-procedure-code.html\n\n','mysql> DELIMITER //\nmysql> CREATE PROCEDURE p1 ()\n    -> BEGIN\n    ->   DECLARE fanta INT DEFAULT 55;\n    ->   DROP TABLE t2;\n    ->   LOOP\n    ->     INSERT INTO t3 VALUES (fanta);\n    ->     END LOOP;\n    ->   END//\nQuery OK, 0 rows affected (0.00 sec)\n\nmysql> SHOW PROCEDURE CODE p1//\n+-----+----------------------------------------+\n| Pos | Instruction                            |\n+-----+----------------------------------------+\n|   0 | set fanta@0 55                         |\n|   1 | stmt 9 "DROP TABLE t2"                 |\n|   2 | stmt 5 "INSERT INTO t3 VALUES (fanta)" |\n|   3 | jump 2                                 |\n+-----+----------------------------------------+\n4 rows in set (0.00 sec)\n','http://dev.mysql.com/doc/refman/5.1/en/show-procedure-code.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (485,20,'MEDIUMTEXT','MEDIUMTEXT [CHARACTER SET charset_name] [COLLATE collation_name]\n\nA TEXT column with a maximum length of 16,777,215 (224 - 1) characters.\nThe effective maximum length is less if the value contains multi-byte\ncharacters. Each MEDIUMTEXT value is stored using a three-byte length\nprefix that indicates the number of bytes in the value.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/string-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (486,4,'LN','Syntax:\nLN(X)\n\nReturns the natural logarithm of X; that is, the base-e logarithm of X.\nIf X is less than or equal to 0, then NULL is returned.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT LN(2);\n        -> 0.69314718055995\nmysql> SELECT LN(-2);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (487,22,'RETURN','Syntax:\nRETURN expr\n\nThe RETURN statement terminates execution of a stored function and\nreturns the value expr to the function caller. There must be at least\none RETURN statement in a stored function. There may be more than one\nif the function has multiple exit points.\n\nThis statement is not used in stored procedures, triggers, or events.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/return.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/return.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (488,25,'SHOW COLLATION','Syntax:\nSHOW COLLATION\n    [LIKE \'pattern\' | WHERE expr]\n\nThis statement lists collations supported by the server. By default,\nthe output from SHOW COLLATION includes all available collations. The\nLIKE clause, if present, indicates which collation names to match. The\nWHERE clause can be given to select rows using more general conditions,\nas discussed in\nhttp://dev.mysql.com/doc/refman/5.1/en/extended-show.html. For example:\n\nmysql> SHOW COLLATION LIKE \'latin1%\';\n+-------------------+---------+----+---------+----------+---------+\n| Collation         | Charset | Id | Default | Compiled | Sortlen |\n+-------------------+---------+----+---------+----------+---------+\n| latin1_german1_ci | latin1  |  5 |         |          |       0 |\n| latin1_swedish_ci | latin1  |  8 | Yes     | Yes      |       0 |\n| latin1_danish_ci  | latin1  | 15 |         |          |       0 |\n| latin1_german2_ci | latin1  | 31 |         | Yes      |       2 |\n| latin1_bin        | latin1  | 47 |         | Yes      |       0 |\n| latin1_general_ci | latin1  | 48 |         |          |       0 |\n| latin1_general_cs | latin1  | 49 |         |          |       0 |\n| latin1_spanish_ci | latin1  | 94 |         |          |       0 |\n+-------------------+---------+----+---------+----------+---------+\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/show-collation.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/show-collation.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (489,4,'LOG','Syntax:\nLOG(X), LOG(B,X)\n\nIf called with one parameter, this function returns the natural\nlogarithm of X. If X is less than or equal to 0, then NULL is returned.\n\nThe inverse of this function (when called with a single argument) is\nthe EXP() function.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT LOG(2);\n        -> 0.69314718055995\nmysql> SELECT LOG(-2);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (490,25,'SET SQL_LOG_BIN','Syntax:\nSET sql_log_bin = {0|1}\n\nDisables or enables binary logging for the current connection\n(sql_log_bin is a session variable) if the client has the SUPER\nprivilege. The statement is refused with an error if the client does\nnot have that privilege.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/set-sql-log-bin.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/set-sql-log-bin.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (491,17,'!=','Syntax:\n<>, !=\n\nNot equal:\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT \'.01\' <> \'0.01\';\n        -> 1\nmysql> SELECT .01 <> \'0.01\';\n        -> 0\nmysql> SELECT \'zapp\' <> \'zappp\';\n        -> 1\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (492,22,'WHILE','Syntax:\n[begin_label:] WHILE search_condition DO\n    statement_list\nEND WHILE [end_label]\n\nThe statement list within a WHILE statement is repeated as long as the\nsearch_condition is true. statement_list consists of one or more\nstatements.\n\nA WHILE statement can be labeled. end_label cannot be given unless\nbegin_label also is present. If both are present, they must be the\nsame.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/while-statement.html\n\n','CREATE PROCEDURE dowhile()\nBEGIN\n  DECLARE v1 INT DEFAULT 5;\n\n  WHILE v1 > 0 DO\n    ...\n    SET v1 = v1 - 1;\n  END WHILE;\nEND\n','http://dev.mysql.com/doc/refman/5.1/en/while-statement.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (493,11,'AES_DECRYPT','Syntax:\nAES_DECRYPT(crypt_str,key_str)\n\nThis function allows decryption of data using the official AES\n(Advanced Encryption Standard) algorithm. For more information, see the\ndescription of AES_ENCRYPT().\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/encryption-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (494,30,'DAYNAME','Syntax:\nDAYNAME(date)\n\nReturns the name of the weekday for date. As of MySQL 5.1.12, the\nlanguage used for the name is controlled by the value of the\nlc_time_names system variable\n(http://dev.mysql.com/doc/refman/5.1/en/locale-support.html).\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html\n\n','mysql> SELECT DAYNAME(\'2007-02-03\');\n        -> \'Saturday\'\n','http://dev.mysql.com/doc/refman/5.1/en/date-and-time-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (495,15,'COERCIBILITY','Syntax:\nCOERCIBILITY(str)\n\nReturns the collation coercibility value of the string argument.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT COERCIBILITY(\'abc\' COLLATE latin1_swedish_ci);\n        -> 0\nmysql> SELECT COERCIBILITY(USER());\n        -> 3\nmysql> SELECT COERCIBILITY(\'abc\');\n        -> 4\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (496,20,'INT','INT[(M)] [UNSIGNED] [ZEROFILL]\n\nA normal-size integer. The signed range is -2147483648 to 2147483647.\nThe unsigned range is 0 to 4294967295.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html\n\n','','http://dev.mysql.com/doc/refman/5.1/en/numeric-type-overview.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (497,12,'GLENGTH','GLength(ls)\n\nReturns as a double-precision number the length of the LineString value\nls in its associated spatial reference.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#linestring-property-functions\n\n','mysql> SET @ls = \'LineString(1 1,2 2,3 3)\';\nmysql> SELECT GLength(GeomFromText(@ls));\n+----------------------------+\n| GLength(GeomFromText(@ls)) |\n+----------------------------+\n|            2.8284271247462 |\n+----------------------------+\n','http://dev.mysql.com/doc/refman/5.1/en/geometry-property-functions.html#linestring-property-functions');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (498,4,'RADIANS','Syntax:\nRADIANS(X)\n\nReturns the argument X, converted from degrees to radians. (Note that\nπ radians equals 180 degrees.)\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html\n\n','mysql> SELECT RADIANS(90);\n        -> 1.5707963267949\n','http://dev.mysql.com/doc/refman/5.1/en/mathematical-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (499,15,'COLLATION','Syntax:\nCOLLATION(str)\n\nReturns the collation of the string argument.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT COLLATION(\'abc\');\n        -> \'latin1_swedish_ci\'\nmysql> SELECT COLLATION(_utf8\'abc\');\n        -> \'utf8_general_ci\'\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (500,17,'COALESCE','Syntax:\nCOALESCE(value,...)\n\nReturns the first non-NULL value in the list, or NULL if there are no\nnon-NULL values.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html\n\n','mysql> SELECT COALESCE(NULL,1);\n        -> 1\nmysql> SELECT COALESCE(NULL,NULL,NULL);\n        -> NULL\n','http://dev.mysql.com/doc/refman/5.1/en/comparison-operators.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (501,15,'VERSION','Syntax:\nVERSION()\n\nReturns a string that indicates the MySQL server version. The string\nuses the utf8 character set.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/information-functions.html\n\n','mysql> SELECT VERSION();\n        -> \'5.1.40-standard\'\n','http://dev.mysql.com/doc/refman/5.1/en/information-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (502,35,'MAKE_SET','Syntax:\nMAKE_SET(bits,str1,str2,...)\n\nReturns a set value (a string containing substrings separated by ","\ncharacters) consisting of the strings that have the corresponding bit\nin bits set. str1 corresponds to bit 0, str2 to bit 1, and so on. NULL\nvalues in str1, str2, ... are not appended to the result.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT MAKE_SET(1,\'a\',\'b\',\'c\');\n        -> \'a\'\nmysql> SELECT MAKE_SET(1 | 4,\'hello\',\'nice\',\'world\');\n        -> \'hello,world\'\nmysql> SELECT MAKE_SET(1 | 4,\'hello\',\'nice\',NULL,\'world\');\n        -> \'hello\'\nmysql> SELECT MAKE_SET(0,\'a\',\'b\',\'c\');\n        -> \'\'\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');
insert into help_topic (help_topic_id,help_category_id,name,description,example,url) values (503,35,'FIND_IN_SET','Syntax:\nFIND_IN_SET(str,strlist)\n\nReturns a value in the range of 1 to N if the string str is in the\nstring list strlist consisting of N substrings. A string list is a\nstring composed of substrings separated by "," characters. If the first\nargument is a constant string and the second is a column of type SET,\nthe FIND_IN_SET() function is optimized to use bit arithmetic. Returns\n0 if str is not in strlist or if strlist is the empty string. Returns\nNULL if either argument is NULL. This function does not work properly\nif the first argument contains a comma (",") character.\n\nURL: http://dev.mysql.com/doc/refman/5.1/en/string-functions.html\n\n','mysql> SELECT FIND_IN_SET(\'b\',\'a,b,c,d\');\n        -> 2\n','http://dev.mysql.com/doc/refman/5.1/en/string-functions.html');

insert into help_keyword (help_keyword_id,name) values (0,'JOIN');
insert into help_keyword (help_keyword_id,name) values (1,'HOST');
insert into help_keyword (help_keyword_id,name) values (2,'REPEAT');
insert into help_keyword (help_keyword_id,name) values (3,'SERIALIZABLE');
insert into help_keyword (help_keyword_id,name) values (4,'REPLACE');
insert into help_keyword (help_keyword_id,name) values (5,'AT');
insert into help_keyword (help_keyword_id,name) values (6,'SCHEDULE');
insert into help_keyword (help_keyword_id,name) values (7,'RETURNS');
insert into help_keyword (help_keyword_id,name) values (8,'STARTS');
insert into help_keyword (help_keyword_id,name) values (9,'MASTER_SSL_CA');
insert into help_keyword (help_keyword_id,name) values (10,'NCHAR');
insert into help_keyword (help_keyword_id,name) values (11,'COLUMNS');
insert into help_keyword (help_keyword_id,name) values (12,'COMPLETION');
insert into help_keyword (help_keyword_id,name) values (13,'WORK');
insert into help_keyword (help_keyword_id,name) values (14,'DATETIME');
insert into help_keyword (help_keyword_id,name) values (15,'MODE');
insert into help_keyword (help_keyword_id,name) values (16,'OPEN');
insert into help_keyword (help_keyword_id,name) values (17,'INTEGER');
insert into help_keyword (help_keyword_id,name) values (18,'ESCAPE');
insert into help_keyword (help_keyword_id,name) values (19,'VALUE');
insert into help_keyword (help_keyword_id,name) values (20,'MASTER_SSL_VERIFY_SERVER_CERT');
insert into help_keyword (help_keyword_id,name) values (21,'SQL_BIG_RESULT');
insert into help_keyword (help_keyword_id,name) values (22,'DROP');
insert into help_keyword (help_keyword_id,name) values (23,'GEOMETRYCOLLECTIONFROMWKB');
insert into help_keyword (help_keyword_id,name) values (24,'EVENTS');
insert into help_keyword (help_keyword_id,name) values (25,'MONTH');
insert into help_keyword (help_keyword_id,name) values (26,'INFO');
insert into help_keyword (help_keyword_id,name) values (27,'PROFILES');
insert into help_keyword (help_keyword_id,name) values (28,'DUPLICATE');
insert into help_keyword (help_keyword_id,name) values (29,'REPLICATION');
insert into help_keyword (help_keyword_id,name) values (30,'UNLOCK');
insert into help_keyword (help_keyword_id,name) values (31,'INNODB');
insert into help_keyword (help_keyword_id,name) values (32,'YEAR_MONTH');
insert into help_keyword (help_keyword_id,name) values (33,'SUBJECT');
insert into help_keyword (help_keyword_id,name) values (34,'PREPARE');
insert into help_keyword (help_keyword_id,name) values (35,'LOCK');
insert into help_keyword (help_keyword_id,name) values (36,'NDB');
insert into help_keyword (help_keyword_id,name) values (37,'CHECK');
insert into help_keyword (help_keyword_id,name) values (38,'FULL');
insert into help_keyword (help_keyword_id,name) values (39,'INT4');
insert into help_keyword (help_keyword_id,name) values (40,'BY');
insert into help_keyword (help_keyword_id,name) values (41,'NO');
insert into help_keyword (help_keyword_id,name) values (42,'MINUTE');
insert into help_keyword (help_keyword_id,name) values (43,'PARTITION');
insert into help_keyword (help_keyword_id,name) values (44,'DATA');
insert into help_keyword (help_keyword_id,name) values (45,'DAY');
insert into help_keyword (help_keyword_id,name) values (46,'SHARE');
insert into help_keyword (help_keyword_id,name) values (47,'REAL');
insert into help_keyword (help_keyword_id,name) values (48,'SEPARATOR');
insert into help_keyword (help_keyword_id,name) values (49,'MASTER_HEARTBEAT_PERIOD');
insert into help_keyword (help_keyword_id,name) values (50,'DELETE');
insert into help_keyword (help_keyword_id,name) values (51,'ON');
insert into help_keyword (help_keyword_id,name) values (52,'CONNECTION');
insert into help_keyword (help_keyword_id,name) values (53,'CLOSE');
insert into help_keyword (help_keyword_id,name) values (54,'X509');
insert into help_keyword (help_keyword_id,name) values (55,'USE');
insert into help_keyword (help_keyword_id,name) values (56,'WHERE');
insert into help_keyword (help_keyword_id,name) values (57,'PRIVILEGES');
insert into help_keyword (help_keyword_id,name) values (58,'SPATIAL');
insert into help_keyword (help_keyword_id,name) values (59,'EVENT');
insert into help_keyword (help_keyword_id,name) values (60,'SUPER');
insert into help_keyword (help_keyword_id,name) values (61,'SQL_BUFFER_RESULT');
insert into help_keyword (help_keyword_id,name) values (62,'IGNORE');
insert into help_keyword (help_keyword_id,name) values (63,'QUICK');
insert into help_keyword (help_keyword_id,name) values (64,'SIGNED');
insert into help_keyword (help_keyword_id,name) values (65,'OFFLINE');
insert into help_keyword (help_keyword_id,name) values (66,'SECURITY');
insert into help_keyword (help_keyword_id,name) values (67,'AUTOEXTEND_SIZE');
insert into help_keyword (help_keyword_id,name) values (68,'NDBCLUSTER');
insert into help_keyword (help_keyword_id,name) values (69,'POLYGONFROMWKB');
insert into help_keyword (help_keyword_id,name) values (70,'FALSE');
insert into help_keyword (help_keyword_id,name) values (71,'LEVEL');
insert into help_keyword (help_keyword_id,name) values (72,'FORCE');
insert into help_keyword (help_keyword_id,name) values (73,'BINARY');
insert into help_keyword (help_keyword_id,name) values (74,'TO');
insert into help_keyword (help_keyword_id,name) values (75,'CHANGE');
insert into help_keyword (help_keyword_id,name) values (76,'CURRENT_USER');
insert into help_keyword (help_keyword_id,name) values (77,'HOUR_MINUTE');
insert into help_keyword (help_keyword_id,name) values (78,'UPDATE');
insert into help_keyword (help_keyword_id,name) values (79,'PRESERVE');
insert into help_keyword (help_keyword_id,name) values (80,'INTO');
insert into help_keyword (help_keyword_id,name) values (81,'FEDERATED');
insert into help_keyword (help_keyword_id,name) values (82,'VARYING');
insert into help_keyword (help_keyword_id,name) values (83,'MAX_SIZE');
insert into help_keyword (help_keyword_id,name) values (84,'HOUR_SECOND');
insert into help_keyword (help_keyword_id,name) values (85,'VARIABLE');
insert into help_keyword (help_keyword_id,name) values (86,'ROLLBACK');
insert into help_keyword (help_keyword_id,name) values (87,'RTREE');
insert into help_keyword (help_keyword_id,name) values (88,'PROCEDURE');
insert into help_keyword (help_keyword_id,name) values (89,'TIMESTAMP');
insert into help_keyword (help_keyword_id,name) values (90,'IMPORT');
insert into help_keyword (help_keyword_id,name) values (91,'AGAINST');
insert into help_keyword (help_keyword_id,name) values (92,'CHECKSUM');
insert into help_keyword (help_keyword_id,name) values (93,'COUNT');
insert into help_keyword (help_keyword_id,name) values (94,'LONGBINARY');
insert into help_keyword (help_keyword_id,name) values (95,'THEN');
insert into help_keyword (help_keyword_id,name) values (96,'INSERT');
insert into help_keyword (help_keyword_id,name) values (97,'ENGINES');
insert into help_keyword (help_keyword_id,name) values (98,'HANDLER');
insert into help_keyword (help_keyword_id,name) values (99,'PORT');
insert into help_keyword (help_keyword_id,name) values (100,'DAY_SECOND');
insert into help_keyword (help_keyword_id,name) values (101,'EXISTS');
insert into help_keyword (help_keyword_id,name) values (102,'MUTEX');
insert into help_keyword (help_keyword_id,name) values (103,'RELEASE');
insert into help_keyword (help_keyword_id,name) values (104,'BOOLEAN');
insert into help_keyword (help_keyword_id,name) values (105,'MOD');
insert into help_keyword (help_keyword_id,name) values (106,'DEFAULT');
insert into help_keyword (help_keyword_id,name) values (107,'TYPE');
insert into help_keyword (help_keyword_id,name) values (108,'NO_WRITE_TO_BINLOG');
insert into help_keyword (help_keyword_id,name) values (109,'OPTIMIZE');
insert into help_keyword (help_keyword_id,name) values (110,'RESET');
insert into help_keyword (help_keyword_id,name) values (111,'ITERATE');
insert into help_keyword (help_keyword_id,name) values (112,'INSTALL');
insert into help_keyword (help_keyword_id,name) values (113,'DO');
insert into help_keyword (help_keyword_id,name) values (114,'BIGINT');
insert into help_keyword (help_keyword_id,name) values (115,'SET');
insert into help_keyword (help_keyword_id,name) values (116,'ISSUER');
insert into help_keyword (help_keyword_id,name) values (117,'DATE');
insert into help_keyword (help_keyword_id,name) values (118,'STATUS');
insert into help_keyword (help_keyword_id,name) values (119,'FULLTEXT');
insert into help_keyword (help_keyword_id,name) values (120,'COMMENT');
insert into help_keyword (help_keyword_id,name) values (121,'MASTER_CONNECT_RETRY');
insert into help_keyword (help_keyword_id,name) values (122,'INNER');
insert into help_keyword (help_keyword_id,name) values (123,'STOP');
insert into help_keyword (help_keyword_id,name) values (124,'MASTER_LOG_FILE');
insert into help_keyword (help_keyword_id,name) values (125,'MRG_MYISAM');
insert into help_keyword (help_keyword_id,name) values (126,'PRECISION');
insert into help_keyword (help_keyword_id,name) values (127,'REQUIRE');
insert into help_keyword (help_keyword_id,name) values (128,'TRAILING');
insert into help_keyword (help_keyword_id,name) values (129,'PARTITIONS');
insert into help_keyword (help_keyword_id,name) values (130,'LONG');
insert into help_keyword (help_keyword_id,name) values (131,'OPTION');
insert into help_keyword (help_keyword_id,name) values (132,'REORGANIZE');
insert into help_keyword (help_keyword_id,name) values (133,'ELSE');
insert into help_keyword (help_keyword_id,name) values (134,'DEALLOCATE');
insert into help_keyword (help_keyword_id,name) values (135,'IO_THREAD');
insert into help_keyword (help_keyword_id,name) values (136,'CASE');
insert into help_keyword (help_keyword_id,name) values (137,'CIPHER');
insert into help_keyword (help_keyword_id,name) values (138,'CONTINUE');
insert into help_keyword (help_keyword_id,name) values (139,'FROM');
insert into help_keyword (help_keyword_id,name) values (140,'READ');
insert into help_keyword (help_keyword_id,name) values (141,'LEFT');
insert into help_keyword (help_keyword_id,name) values (142,'ELSEIF');
insert into help_keyword (help_keyword_id,name) values (143,'MINUTE_SECOND');
insert into help_keyword (help_keyword_id,name) values (144,'COMPACT');
insert into help_keyword (help_keyword_id,name) values (145,'RESTORE');
insert into help_keyword (help_keyword_id,name) values (146,'DEC');
insert into help_keyword (help_keyword_id,name) values (147,'FOR');
insert into help_keyword (help_keyword_id,name) values (148,'WARNINGS');
insert into help_keyword (help_keyword_id,name) values (149,'MIN_ROWS');
insert into help_keyword (help_keyword_id,name) values (150,'CONDITION');
insert into help_keyword (help_keyword_id,name) values (151,'STRING');
insert into help_keyword (help_keyword_id,name) values (152,'ENCLOSED');
insert into help_keyword (help_keyword_id,name) values (153,'FUNCTION');
insert into help_keyword (help_keyword_id,name) values (154,'AGGREGATE');
insert into help_keyword (help_keyword_id,name) values (155,'FIELDS');
insert into help_keyword (help_keyword_id,name) values (156,'INT3');
insert into help_keyword (help_keyword_id,name) values (157,'ARCHIVE');
insert into help_keyword (help_keyword_id,name) values (158,'AVG_ROW_LENGTH');
insert into help_keyword (help_keyword_id,name) values (159,'ADD');
insert into help_keyword (help_keyword_id,name) values (160,'KILL');
insert into help_keyword (help_keyword_id,name) values (161,'FLOAT4');
insert into help_keyword (help_keyword_id,name) values (162,'TABLESPACE');
insert into help_keyword (help_keyword_id,name) values (163,'VIEW');
insert into help_keyword (help_keyword_id,name) values (164,'REPEATABLE');
insert into help_keyword (help_keyword_id,name) values (165,'INFILE');
insert into help_keyword (help_keyword_id,name) values (166,'ORDER');
insert into help_keyword (help_keyword_id,name) values (167,'USING');
insert into help_keyword (help_keyword_id,name) values (168,'MIDDLEINT');
insert into help_keyword (help_keyword_id,name) values (169,'GRANT');
insert into help_keyword (help_keyword_id,name) values (170,'UNSIGNED');
insert into help_keyword (help_keyword_id,name) values (171,'DECIMAL');
insert into help_keyword (help_keyword_id,name) values (172,'GEOMETRYFROMTEXT');
insert into help_keyword (help_keyword_id,name) values (173,'INDEXES');
insert into help_keyword (help_keyword_id,name) values (174,'FOREIGN');
insert into help_keyword (help_keyword_id,name) values (175,'CACHE');
insert into help_keyword (help_keyword_id,name) values (176,'HOSTS');
insert into help_keyword (help_keyword_id,name) values (177,'COMMIT');
insert into help_keyword (help_keyword_id,name) values (178,'SCHEMAS');
insert into help_keyword (help_keyword_id,name) values (179,'LEADING');
insert into help_keyword (help_keyword_id,name) values (180,'SNAPSHOT');
insert into help_keyword (help_keyword_id,name) values (181,'DECLARE');
insert into help_keyword (help_keyword_id,name) values (182,'LOAD');
insert into help_keyword (help_keyword_id,name) values (183,'SQL_CACHE');
insert into help_keyword (help_keyword_id,name) values (184,'CONVERT');
insert into help_keyword (help_keyword_id,name) values (185,'DYNAMIC');
insert into help_keyword (help_keyword_id,name) values (186,'COLLATE');
insert into help_keyword (help_keyword_id,name) values (187,'POLYGONFROMTEXT');
insert into help_keyword (help_keyword_id,name) values (188,'BYTE');
insert into help_keyword (help_keyword_id,name) values (189,'GLOBAL');
insert into help_keyword (help_keyword_id,name) values (190,'LINESTRINGFROMWKB');
insert into help_keyword (help_keyword_id,name) values (191,'WHEN');
insert into help_keyword (help_keyword_id,name) values (192,'COLUMN_FORMAT');
insert into help_keyword (help_keyword_id,name) values (193,'HAVING');
insert into help_keyword (help_keyword_id,name) values (194,'AS');
insert into help_keyword (help_keyword_id,name) values (195,'STARTING');
insert into help_keyword (help_keyword_id,name) values (196,'RELOAD');
insert into help_keyword (help_keyword_id,name) values (197,'AUTOCOMMIT');
insert into help_keyword (help_keyword_id,name) values (198,'REVOKE');
insert into help_keyword (help_keyword_id,name) values (199,'GRANTS');
insert into help_keyword (help_keyword_id,name) values (200,'OUTER');
insert into help_keyword (help_keyword_id,name) values (201,'FLOOR');
insert into help_keyword (help_keyword_id,name) values (202,'EXPLAIN');
insert into help_keyword (help_keyword_id,name) values (203,'WITH');
insert into help_keyword (help_keyword_id,name) values (204,'AFTER');
insert into help_keyword (help_keyword_id,name) values (205,'STD');
insert into help_keyword (help_keyword_id,name) values (206,'CSV');
insert into help_keyword (help_keyword_id,name) values (207,'DISABLE');
insert into help_keyword (help_keyword_id,name) values (208,'UNINSTALL');
insert into help_keyword (help_keyword_id,name) values (209,'OUTFILE');
insert into help_keyword (help_keyword_id,name) values (210,'LOW_PRIORITY');
insert into help_keyword (help_keyword_id,name) values (211,'FILE');
insert into help_keyword (help_keyword_id,name) values (212,'NODEGROUP');
insert into help_keyword (help_keyword_id,name) values (213,'SCHEMA');
insert into help_keyword (help_keyword_id,name) values (214,'SONAME');
insert into help_keyword (help_keyword_id,name) values (215,'POW');
insert into help_keyword (help_keyword_id,name) values (216,'DUAL');
insert into help_keyword (help_keyword_id,name) values (217,'MULTIPOINTFROMWKB');
insert into help_keyword (help_keyword_id,name) values (218,'INDEX');
insert into help_keyword (help_keyword_id,name) values (219,'BACKUP');
insert into help_keyword (help_keyword_id,name) values (220,'MULTIPOINTFROMTEXT');
insert into help_keyword (help_keyword_id,name) values (221,'DEFINER');
insert into help_keyword (help_keyword_id,name) values (222,'MASTER_BIND');
insert into help_keyword (help_keyword_id,name) values (223,'REMOVE');
insert into help_keyword (help_keyword_id,name) values (224,'EXTENDED');
insert into help_keyword (help_keyword_id,name) values (225,'MULTILINESTRINGFROMWKB');
insert into help_keyword (help_keyword_id,name) values (226,'CROSS');
insert into help_keyword (help_keyword_id,name) values (227,'CONTRIBUTORS');
insert into help_keyword (help_keyword_id,name) values (228,'NATIONAL');
insert into help_keyword (help_keyword_id,name) values (229,'GROUP');
insert into help_keyword (help_keyword_id,name) values (230,'SHA');
insert into help_keyword (help_keyword_id,name) values (231,'ONLINE');
insert into help_keyword (help_keyword_id,name) values (232,'UNDO');
insert into help_keyword (help_keyword_id,name) values (233,'ZEROFILL');
insert into help_keyword (help_keyword_id,name) values (234,'CLIENT');
insert into help_keyword (help_keyword_id,name) values (235,'MASTER_PASSWORD');
insert into help_keyword (help_keyword_id,name) values (236,'OWNER');
insert into help_keyword (help_keyword_id,name) values (237,'RELAY_LOG_FILE');
insert into help_keyword (help_keyword_id,name) values (238,'TRUE');
insert into help_keyword (help_keyword_id,name) values (239,'CHARACTER');
insert into help_keyword (help_keyword_id,name) values (240,'MASTER_USER');
insert into help_keyword (help_keyword_id,name) values (241,'TABLE');
insert into help_keyword (help_keyword_id,name) values (242,'ENGINE');
insert into help_keyword (help_keyword_id,name) values (243,'INSERT_METHOD');
insert into help_keyword (help_keyword_id,name) values (244,'CASCADE');
insert into help_keyword (help_keyword_id,name) values (245,'RELAY_LOG_POS');
insert into help_keyword (help_keyword_id,name) values (246,'SQL_CALC_FOUND_ROWS');
insert into help_keyword (help_keyword_id,name) values (247,'UNION');
insert into help_keyword (help_keyword_id,name) values (248,'MYISAM');
insert into help_keyword (help_keyword_id,name) values (249,'LEAVE');
insert into help_keyword (help_keyword_id,name) values (250,'MODIFY');
insert into help_keyword (help_keyword_id,name) values (251,'MATCH');
insert into help_keyword (help_keyword_id,name) values (252,'MASTER_LOG_POS');
insert into help_keyword (help_keyword_id,name) values (253,'DISTINCTROW');
insert into help_keyword (help_keyword_id,name) values (254,'DESC');
insert into help_keyword (help_keyword_id,name) values (255,'TIME');
insert into help_keyword (help_keyword_id,name) values (256,'NUMERIC');
insert into help_keyword (help_keyword_id,name) values (257,'EXPANSION');
insert into help_keyword (help_keyword_id,name) values (258,'CURSOR');
insert into help_keyword (help_keyword_id,name) values (259,'CODE');
insert into help_keyword (help_keyword_id,name) values (260,'GEOMETRYCOLLECTIONFROMTEXT');
insert into help_keyword (help_keyword_id,name) values (261,'CHAIN');
insert into help_keyword (help_keyword_id,name) values (262,'LOGFILE');
insert into help_keyword (help_keyword_id,name) values (263,'FLUSH');
insert into help_keyword (help_keyword_id,name) values (264,'CREATE');
insert into help_keyword (help_keyword_id,name) values (265,'DESCRIBE');
insert into help_keyword (help_keyword_id,name) values (266,'EXTENT_SIZE');
insert into help_keyword (help_keyword_id,name) values (267,'MAX_UPDATES_PER_HOUR');
insert into help_keyword (help_keyword_id,name) values (268,'INT2');
insert into help_keyword (help_keyword_id,name) values (269,'PROCESSLIST');
insert into help_keyword (help_keyword_id,name) values (270,'ENDS');
insert into help_keyword (help_keyword_id,name) values (271,'LOGS');
insert into help_keyword (help_keyword_id,name) values (272,'DISCARD');
insert into help_keyword (help_keyword_id,name) values (273,'HEAP');
insert into help_keyword (help_keyword_id,name) values (274,'SOUNDS');
insert into help_keyword (help_keyword_id,name) values (275,'BETWEEN');
insert into help_keyword (help_keyword_id,name) values (276,'MULTILINESTRINGFROMTEXT');
insert into help_keyword (help_keyword_id,name) values (277,'REPAIR');
insert into help_keyword (help_keyword_id,name) values (278,'PACK_KEYS');
insert into help_keyword (help_keyword_id,name) values (279,'FAST');
insert into help_keyword (help_keyword_id,name) values (280,'VALUES');
insert into help_keyword (help_keyword_id,name) values (281,'CALL');
insert into help_keyword (help_keyword_id,name) values (282,'LOOP');
insert into help_keyword (help_keyword_id,name) values (283,'VARCHARACTER');
insert into help_keyword (help_keyword_id,name) values (284,'BEFORE');
insert into help_keyword (help_keyword_id,name) values (285,'TRUNCATE');
insert into help_keyword (help_keyword_id,name) values (286,'SHOW');
insert into help_keyword (help_keyword_id,name) values (287,'ALL');
insert into help_keyword (help_keyword_id,name) values (288,'REDUNDANT');
insert into help_keyword (help_keyword_id,name) values (289,'USER_RESOURCES');
insert into help_keyword (help_keyword_id,name) values (290,'PARTIAL');
insert into help_keyword (help_keyword_id,name) values (291,'BINLOG');
insert into help_keyword (help_keyword_id,name) values (292,'END');
insert into help_keyword (help_keyword_id,name) values (293,'SECOND');
insert into help_keyword (help_keyword_id,name) values (294,'AND');
insert into help_keyword (help_keyword_id,name) values (295,'FLOAT8');
insert into help_keyword (help_keyword_id,name) values (296,'PREV');
insert into help_keyword (help_keyword_id,name) values (297,'HOUR');
insert into help_keyword (help_keyword_id,name) values (298,'SELECT');
insert into help_keyword (help_keyword_id,name) values (299,'DATABASES');
insert into help_keyword (help_keyword_id,name) values (300,'OR');
insert into help_keyword (help_keyword_id,name) values (301,'IDENTIFIED');
insert into help_keyword (help_keyword_id,name) values (302,'WRAPPER');
insert into help_keyword (help_keyword_id,name) values (303,'MASTER_SSL_CIPHER');
insert into help_keyword (help_keyword_id,name) values (304,'SQL_SLAVE_SKIP_COUNTER');
insert into help_keyword (help_keyword_id,name) values (305,'BOTH');
insert into help_keyword (help_keyword_id,name) values (306,'BOOL');
insert into help_keyword (help_keyword_id,name) values (307,'YEAR');
insert into help_keyword (help_keyword_id,name) values (308,'MASTER_PORT');
insert into help_keyword (help_keyword_id,name) values (309,'CONCURRENT');
insert into help_keyword (help_keyword_id,name) values (310,'HELP');
insert into help_keyword (help_keyword_id,name) values (311,'UNIQUE');
insert into help_keyword (help_keyword_id,name) values (312,'TRIGGERS');
insert into help_keyword (help_keyword_id,name) values (313,'PROCESS');
insert into help_keyword (help_keyword_id,name) values (314,'OPTIONS');
insert into help_keyword (help_keyword_id,name) values (315,'CONSISTENT');
insert into help_keyword (help_keyword_id,name) values (316,'MASTER_SSL');
insert into help_keyword (help_keyword_id,name) values (317,'DATE_ADD');
insert into help_keyword (help_keyword_id,name) values (318,'MAX_CONNECTIONS_PER_HOUR');
insert into help_keyword (help_keyword_id,name) values (319,'LIKE');
insert into help_keyword (help_keyword_id,name) values (320,'PLUGIN');
insert into help_keyword (help_keyword_id,name) values (321,'FETCH');
insert into help_keyword (help_keyword_id,name) values (322,'IN');
insert into help_keyword (help_keyword_id,name) values (323,'COLUMN');
insert into help_keyword (help_keyword_id,name) values (324,'DUMPFILE');
insert into help_keyword (help_keyword_id,name) values (325,'USAGE');
insert into help_keyword (help_keyword_id,name) values (326,'EXECUTE');
insert into help_keyword (help_keyword_id,name) values (327,'MEMORY');
insert into help_keyword (help_keyword_id,name) values (328,'CEIL');
insert into help_keyword (help_keyword_id,name) values (329,'QUERY');
insert into help_keyword (help_keyword_id,name) values (330,'MASTER_HOST');
insert into help_keyword (help_keyword_id,name) values (331,'LINES');
insert into help_keyword (help_keyword_id,name) values (332,'SQL_THREAD');
insert into help_keyword (help_keyword_id,name) values (333,'SERVER');
insert into help_keyword (help_keyword_id,name) values (334,'MAX_QUERIES_PER_HOUR');
insert into help_keyword (help_keyword_id,name) values (335,'MASTER_SSL_CERT');
insert into help_keyword (help_keyword_id,name) values (336,'MULTIPOLYGONFROMWKB');
insert into help_keyword (help_keyword_id,name) values (337,'TRANSACTION');
insert into help_keyword (help_keyword_id,name) values (338,'DAY_MINUTE');
insert into help_keyword (help_keyword_id,name) values (339,'STDDEV');
insert into help_keyword (help_keyword_id,name) values (340,'DATE_SUB');
insert into help_keyword (help_keyword_id,name) values (341,'REBUILD');
insert into help_keyword (help_keyword_id,name) values (342,'GEOMETRYFROMWKB');
insert into help_keyword (help_keyword_id,name) values (343,'INT1');
insert into help_keyword (help_keyword_id,name) values (344,'RENAME');
insert into help_keyword (help_keyword_id,name) values (345,'PARSER');
insert into help_keyword (help_keyword_id,name) values (346,'RIGHT');
insert into help_keyword (help_keyword_id,name) values (347,'ALTER');
insert into help_keyword (help_keyword_id,name) values (348,'MAX_ROWS');
insert into help_keyword (help_keyword_id,name) values (349,'SOCKET');
insert into help_keyword (help_keyword_id,name) values (350,'STRAIGHT_JOIN');
insert into help_keyword (help_keyword_id,name) values (351,'NATURAL');
insert into help_keyword (help_keyword_id,name) values (352,'VARIABLES');
insert into help_keyword (help_keyword_id,name) values (353,'ESCAPED');
insert into help_keyword (help_keyword_id,name) values (354,'SHA1');
insert into help_keyword (help_keyword_id,name) values (355,'KEY_BLOCK_SIZE');
insert into help_keyword (help_keyword_id,name) values (356,'PASSWORD');
insert into help_keyword (help_keyword_id,name) values (357,'OFFSET');
insert into help_keyword (help_keyword_id,name) values (358,'CHAR');
insert into help_keyword (help_keyword_id,name) values (359,'NEXT');
insert into help_keyword (help_keyword_id,name) values (360,'SQL_LOG_BIN');
insert into help_keyword (help_keyword_id,name) values (361,'ERRORS');
insert into help_keyword (help_keyword_id,name) values (362,'TEMPORARY');
insert into help_keyword (help_keyword_id,name) values (363,'COMMITTED');
insert into help_keyword (help_keyword_id,name) values (364,'SQL_SMALL_RESULT');
insert into help_keyword (help_keyword_id,name) values (365,'UPGRADE');
insert into help_keyword (help_keyword_id,name) values (366,'BEGIN');
insert into help_keyword (help_keyword_id,name) values (367,'DELAY_KEY_WRITE');
insert into help_keyword (help_keyword_id,name) values (368,'PROFILE');
insert into help_keyword (help_keyword_id,name) values (369,'MEDIUM');
insert into help_keyword (help_keyword_id,name) values (370,'INTERVAL');
insert into help_keyword (help_keyword_id,name) values (371,'SSL');
insert into help_keyword (help_keyword_id,name) values (372,'DAY_HOUR');
insert into help_keyword (help_keyword_id,name) values (373,'NAME');
insert into help_keyword (help_keyword_id,name) values (374,'REFERENCES');
insert into help_keyword (help_keyword_id,name) values (375,'AES_ENCRYPT');
insert into help_keyword (help_keyword_id,name) values (376,'STORAGE');
insert into help_keyword (help_keyword_id,name) values (377,'ISOLATION');
insert into help_keyword (help_keyword_id,name) values (378,'CEILING');
insert into help_keyword (help_keyword_id,name) values (379,'EVERY');
insert into help_keyword (help_keyword_id,name) values (380,'INT8');
insert into help_keyword (help_keyword_id,name) values (381,'AUTHORS');
insert into help_keyword (help_keyword_id,name) values (382,'RESTRICT');
insert into help_keyword (help_keyword_id,name) values (383,'UNCOMMITTED');
insert into help_keyword (help_keyword_id,name) values (384,'LINESTRINGFROMTEXT');
insert into help_keyword (help_keyword_id,name) values (385,'IS');
insert into help_keyword (help_keyword_id,name) values (386,'NOT');
insert into help_keyword (help_keyword_id,name) values (387,'ANALYSE');
insert into help_keyword (help_keyword_id,name) values (388,'DATAFILE');
insert into help_keyword (help_keyword_id,name) values (389,'DES_KEY_FILE');
insert into help_keyword (help_keyword_id,name) values (390,'COMPRESSED');
insert into help_keyword (help_keyword_id,name) values (391,'START');
insert into help_keyword (help_keyword_id,name) values (392,'PLUGINS');
insert into help_keyword (help_keyword_id,name) values (393,'SAVEPOINT');
insert into help_keyword (help_keyword_id,name) values (394,'IF');
insert into help_keyword (help_keyword_id,name) values (395,'PRIMARY');
insert into help_keyword (help_keyword_id,name) values (396,'PURGE');
insert into help_keyword (help_keyword_id,name) values (397,'LAST');
insert into help_keyword (help_keyword_id,name) values (398,'USER');
insert into help_keyword (help_keyword_id,name) values (399,'INNOBASE');
insert into help_keyword (help_keyword_id,name) values (400,'EXIT');
insert into help_keyword (help_keyword_id,name) values (401,'KEYS');
insert into help_keyword (help_keyword_id,name) values (402,'LIMIT');
insert into help_keyword (help_keyword_id,name) values (403,'KEY');
insert into help_keyword (help_keyword_id,name) values (404,'MERGE');
insert into help_keyword (help_keyword_id,name) values (405,'UNTIL');
insert into help_keyword (help_keyword_id,name) values (406,'SQL_NO_CACHE');
insert into help_keyword (help_keyword_id,name) values (407,'DELAYED');
insert into help_keyword (help_keyword_id,name) values (408,'ANALYZE');
insert into help_keyword (help_keyword_id,name) values (409,'CONSTRAINT');
insert into help_keyword (help_keyword_id,name) values (410,'SERIAL');
insert into help_keyword (help_keyword_id,name) values (411,'ACTION');
insert into help_keyword (help_keyword_id,name) values (412,'WRITE');
insert into help_keyword (help_keyword_id,name) values (413,'INITIAL_SIZE');
insert into help_keyword (help_keyword_id,name) values (414,'SESSION');
insert into help_keyword (help_keyword_id,name) values (415,'DATABASE');
insert into help_keyword (help_keyword_id,name) values (416,'NULL');
insert into help_keyword (help_keyword_id,name) values (417,'POWER');
insert into help_keyword (help_keyword_id,name) values (418,'USE_FRM');
insert into help_keyword (help_keyword_id,name) values (419,'TERMINATED');
insert into help_keyword (help_keyword_id,name) values (420,'SLAVE');
insert into help_keyword (help_keyword_id,name) values (421,'NVARCHAR');
insert into help_keyword (help_keyword_id,name) values (422,'ASC');
insert into help_keyword (help_keyword_id,name) values (423,'RETURN');
insert into help_keyword (help_keyword_id,name) values (424,'OPTIONALLY');
insert into help_keyword (help_keyword_id,name) values (425,'ENABLE');
insert into help_keyword (help_keyword_id,name) values (426,'DIRECTORY');
insert into help_keyword (help_keyword_id,name) values (427,'WHILE');
insert into help_keyword (help_keyword_id,name) values (428,'MAX_USER_CONNECTIONS');
insert into help_keyword (help_keyword_id,name) values (429,'LOCAL');
insert into help_keyword (help_keyword_id,name) values (430,'DISTINCT');
insert into help_keyword (help_keyword_id,name) values (431,'AES_DECRYPT');
insert into help_keyword (help_keyword_id,name) values (432,'MASTER_SSL_KEY');
insert into help_keyword (help_keyword_id,name) values (433,'NONE');
insert into help_keyword (help_keyword_id,name) values (434,'TABLES');
insert into help_keyword (help_keyword_id,name) values (435,'<>');
insert into help_keyword (help_keyword_id,name) values (436,'RLIKE');
insert into help_keyword (help_keyword_id,name) values (437,'TRIGGER');
insert into help_keyword (help_keyword_id,name) values (438,'COLLATION');
insert into help_keyword (help_keyword_id,name) values (439,'SHUTDOWN');
insert into help_keyword (help_keyword_id,name) values (440,'HIGH_PRIORITY');
insert into help_keyword (help_keyword_id,name) values (441,'BTREE');
insert into help_keyword (help_keyword_id,name) values (442,'FIRST');
insert into help_keyword (help_keyword_id,name) values (443,'COALESCE');
insert into help_keyword (help_keyword_id,name) values (444,'WAIT');
insert into help_keyword (help_keyword_id,name) values (445,'TYPES');
insert into help_keyword (help_keyword_id,name) values (446,'MASTER');
insert into help_keyword (help_keyword_id,name) values (447,'FIXED');
insert into help_keyword (help_keyword_id,name) values (448,'MULTIPOLYGONFROMTEXT');
insert into help_keyword (help_keyword_id,name) values (449,'ROW_FORMAT');

insert into help_relation (help_topic_id,help_keyword_id) values (1,0);
insert into help_relation (help_topic_id,help_keyword_id) values (353,0);
insert into help_relation (help_topic_id,help_keyword_id) values (469,1);
insert into help_relation (help_topic_id,help_keyword_id) values (228,2);
insert into help_relation (help_topic_id,help_keyword_id) values (445,3);
insert into help_relation (help_topic_id,help_keyword_id) values (3,4);
insert into help_relation (help_topic_id,help_keyword_id) values (420,4);
insert into help_relation (help_topic_id,help_keyword_id) values (87,5);
insert into help_relation (help_topic_id,help_keyword_id) values (405,6);
insert into help_relation (help_topic_id,help_keyword_id) values (87,6);
insert into help_relation (help_topic_id,help_keyword_id) values (95,7);
insert into help_relation (help_topic_id,help_keyword_id) values (87,8);
insert into help_relation (help_topic_id,help_keyword_id) values (184,9);
insert into help_relation (help_topic_id,help_keyword_id) values (428,10);
insert into help_relation (help_topic_id,help_keyword_id) values (344,11);
insert into help_relation (help_topic_id,help_keyword_id) values (21,11);
insert into help_relation (help_topic_id,help_keyword_id) values (420,11);
insert into help_relation (help_topic_id,help_keyword_id) values (405,12);
insert into help_relation (help_topic_id,help_keyword_id) values (87,12);
insert into help_relation (help_topic_id,help_keyword_id) values (143,13);
insert into help_relation (help_topic_id,help_keyword_id) values (226,14);
insert into help_relation (help_topic_id,help_keyword_id) values (86,15);
insert into help_relation (help_topic_id,help_keyword_id) values (353,15);
insert into help_relation (help_topic_id,help_keyword_id) values (16,16);
insert into help_relation (help_topic_id,help_keyword_id) values (130,16);
insert into help_relation (help_topic_id,help_keyword_id) values (344,16);
insert into help_relation (help_topic_id,help_keyword_id) values (104,16);
insert into help_relation (help_topic_id,help_keyword_id) values (496,17);
insert into help_relation (help_topic_id,help_keyword_id) values (95,17);
insert into help_relation (help_topic_id,help_keyword_id) values (378,18);
insert into help_relation (help_topic_id,help_keyword_id) values (3,19);
insert into help_relation (help_topic_id,help_keyword_id) values (102,19);
insert into help_relation (help_topic_id,help_keyword_id) values (239,19);
insert into help_relation (help_topic_id,help_keyword_id) values (184,20);
insert into help_relation (help_topic_id,help_keyword_id) values (353,21);
insert into help_relation (help_topic_id,help_keyword_id) values (474,22);
insert into help_relation (help_topic_id,help_keyword_id) values (34,22);
insert into help_relation (help_topic_id,help_keyword_id) values (233,22);
insert into help_relation (help_topic_id,help_keyword_id) values (297,22);
insert into help_relation (help_topic_id,help_keyword_id) values (9,22);
insert into help_relation (help_topic_id,help_keyword_id) values (414,22);
insert into help_relation (help_topic_id,help_keyword_id) values (273,22);
insert into help_relation (help_topic_id,help_keyword_id) values (415,22);
insert into help_relation (help_topic_id,help_keyword_id) values (30,22);
insert into help_relation (help_topic_id,help_keyword_id) values (85,22);
insert into help_relation (help_topic_id,help_keyword_id) values (260,22);
insert into help_relation (help_topic_id,help_keyword_id) values (185,22);
insert into help_relation (help_topic_id,help_keyword_id) values (404,22);
insert into help_relation (help_topic_id,help_keyword_id) values (328,22);
insert into help_relation (help_topic_id,help_keyword_id) values (459,22);
insert into help_relation (help_topic_id,help_keyword_id) values (106,23);
insert into help_relation (help_topic_id,help_keyword_id) values (120,24);
insert into help_relation (help_topic_id,help_keyword_id) values (167,24);
insert into help_relation (help_topic_id,help_keyword_id) values (374,25);
insert into help_relation (help_topic_id,help_keyword_id) values (256,26);
insert into help_relation (help_topic_id,help_keyword_id) values (80,27);
insert into help_relation (help_topic_id,help_keyword_id) values (102,28);
insert into help_relation (help_topic_id,help_keyword_id) values (197,29);
insert into help_relation (help_topic_id,help_keyword_id) values (36,30);
insert into help_relation (help_topic_id,help_keyword_id) values (399,31);
insert into help_relation (help_topic_id,help_keyword_id) values (344,31);
insert into help_relation (help_topic_id,help_keyword_id) values (464,31);
insert into help_relation (help_topic_id,help_keyword_id) values (374,32);
insert into help_relation (help_topic_id,help_keyword_id) values (197,33);
insert into help_relation (help_topic_id,help_keyword_id) values (35,34);
insert into help_relation (help_topic_id,help_keyword_id) values (233,34);
insert into help_relation (help_topic_id,help_keyword_id) values (36,35);
insert into help_relation (help_topic_id,help_keyword_id) values (353,35);
insert into help_relation (help_topic_id,help_keyword_id) values (464,36);
insert into help_relation (help_topic_id,help_keyword_id) values (416,37);
insert into help_relation (help_topic_id,help_keyword_id) values (464,37);
insert into help_relation (help_topic_id,help_keyword_id) values (459,37);
insert into help_relation (help_topic_id,help_keyword_id) values (344,38);
insert into help_relation (help_topic_id,help_keyword_id) values (21,38);
insert into help_relation (help_topic_id,help_keyword_id) values (291,38);
insert into help_relation (help_topic_id,help_keyword_id) values (464,38);
insert into help_relation (help_topic_id,help_keyword_id) values (449,38);
insert into help_relation (help_topic_id,help_keyword_id) values (496,39);
insert into help_relation (help_topic_id,help_keyword_id) values (48,40);
insert into help_relation (help_topic_id,help_keyword_id) values (464,40);
insert into help_relation (help_topic_id,help_keyword_id) values (81,40);
insert into help_relation (help_topic_id,help_keyword_id) values (197,40);
insert into help_relation (help_topic_id,help_keyword_id) values (353,40);
insert into help_relation (help_topic_id,help_keyword_id) values (420,40);
insert into help_relation (help_topic_id,help_keyword_id) values (360,40);
insert into help_relation (help_topic_id,help_keyword_id) values (459,40);
insert into help_relation (help_topic_id,help_keyword_id) values (75,40);
insert into help_relation (help_topic_id,help_keyword_id) values (468,41);
insert into help_relation (help_topic_id,help_keyword_id) values (464,41);
insert into help_relation (help_topic_id,help_keyword_id) values (374,42);
insert into help_relation (help_topic_id,help_keyword_id) values (464,43);
insert into help_relation (help_topic_id,help_keyword_id) values (459,43);
insert into help_relation (help_topic_id,help_keyword_id) values (469,44);
insert into help_relation (help_topic_id,help_keyword_id) values (115,44);
insert into help_relation (help_topic_id,help_keyword_id) values (464,44);
insert into help_relation (help_topic_id,help_keyword_id) values (209,44);
insert into help_relation (help_topic_id,help_keyword_id) values (420,44);
insert into help_relation (help_topic_id,help_keyword_id) values (374,45);
insert into help_relation (help_topic_id,help_keyword_id) values (353,46);
insert into help_relation (help_topic_id,help_keyword_id) values (311,47);
insert into help_relation (help_topic_id,help_keyword_id) values (95,47);
insert into help_relation (help_topic_id,help_keyword_id) values (360,48);
insert into help_relation (help_topic_id,help_keyword_id) values (184,49);
insert into help_relation (help_topic_id,help_keyword_id) values (468,50);
insert into help_relation (help_topic_id,help_keyword_id) values (48,50);
insert into help_relation (help_topic_id,help_keyword_id) values (464,50);
insert into help_relation (help_topic_id,help_keyword_id) values (405,51);
insert into help_relation (help_topic_id,help_keyword_id) values (468,51);
insert into help_relation (help_topic_id,help_keyword_id) values (1,51);
insert into help_relation (help_topic_id,help_keyword_id) values (87,51);
insert into help_relation (help_topic_id,help_keyword_id) values (173,52);
insert into help_relation (help_topic_id,help_keyword_id) values (464,52);
insert into help_relation (help_topic_id,help_keyword_id) values (51,53);
insert into help_relation (help_topic_id,help_keyword_id) values (104,53);
insert into help_relation (help_topic_id,help_keyword_id) values (197,54);
insert into help_relation (help_topic_id,help_keyword_id) values (191,55);
insert into help_relation (help_topic_id,help_keyword_id) values (55,55);
insert into help_relation (help_topic_id,help_keyword_id) values (1,55);
insert into help_relation (help_topic_id,help_keyword_id) values (48,56);
insert into help_relation (help_topic_id,help_keyword_id) values (81,56);
insert into help_relation (help_topic_id,help_keyword_id) values (104,56);
insert into help_relation (help_topic_id,help_keyword_id) values (190,57);
insert into help_relation (help_topic_id,help_keyword_id) values (245,57);
insert into help_relation (help_topic_id,help_keyword_id) values (197,57);
insert into help_relation (help_topic_id,help_keyword_id) values (207,58);
insert into help_relation (help_topic_id,help_keyword_id) values (459,58);
insert into help_relation (help_topic_id,help_keyword_id) values (405,59);
insert into help_relation (help_topic_id,help_keyword_id) values (87,59);
insert into help_relation (help_topic_id,help_keyword_id) values (297,59);
insert into help_relation (help_topic_id,help_keyword_id) values (355,59);
insert into help_relation (help_topic_id,help_keyword_id) values (197,60);
insert into help_relation (help_topic_id,help_keyword_id) values (353,61);
insert into help_relation (help_topic_id,help_keyword_id) values (1,62);
insert into help_relation (help_topic_id,help_keyword_id) values (353,62);
insert into help_relation (help_topic_id,help_keyword_id) values (102,62);
insert into help_relation (help_topic_id,help_keyword_id) values (81,62);
insert into help_relation (help_topic_id,help_keyword_id) values (420,62);
insert into help_relation (help_topic_id,help_keyword_id) values (459,62);
insert into help_relation (help_topic_id,help_keyword_id) values (462,63);
insert into help_relation (help_topic_id,help_keyword_id) values (416,63);
insert into help_relation (help_topic_id,help_keyword_id) values (48,63);
insert into help_relation (help_topic_id,help_keyword_id) values (226,64);
insert into help_relation (help_topic_id,help_keyword_id) values (85,65);
insert into help_relation (help_topic_id,help_keyword_id) values (207,65);
insert into help_relation (help_topic_id,help_keyword_id) values (459,65);
insert into help_relation (help_topic_id,help_keyword_id) values (197,66);
insert into help_relation (help_topic_id,help_keyword_id) values (191,67);
insert into help_relation (help_topic_id,help_keyword_id) values (464,68);
insert into help_relation (help_topic_id,help_keyword_id) values (89,69);
insert into help_relation (help_topic_id,help_keyword_id) values (478,69);
insert into help_relation (help_topic_id,help_keyword_id) values (383,70);
insert into help_relation (help_topic_id,help_keyword_id) values (445,71);
insert into help_relation (help_topic_id,help_keyword_id) values (1,72);
insert into help_relation (help_topic_id,help_keyword_id) values (39,73);
insert into help_relation (help_topic_id,help_keyword_id) values (266,73);
insert into help_relation (help_topic_id,help_keyword_id) values (226,73);
insert into help_relation (help_topic_id,help_keyword_id) values (266,74);
insert into help_relation (help_topic_id,help_keyword_id) values (457,74);
insert into help_relation (help_topic_id,help_keyword_id) values (184,74);
insert into help_relation (help_topic_id,help_keyword_id) values (184,75);
insert into help_relation (help_topic_id,help_keyword_id) values (459,75);
insert into help_relation (help_topic_id,help_keyword_id) values (405,76);
insert into help_relation (help_topic_id,help_keyword_id) values (87,76);
insert into help_relation (help_topic_id,help_keyword_id) values (374,77);
insert into help_relation (help_topic_id,help_keyword_id) values (468,78);
insert into help_relation (help_topic_id,help_keyword_id) values (353,78);
insert into help_relation (help_topic_id,help_keyword_id) values (102,78);
insert into help_relation (help_topic_id,help_keyword_id) values (81,78);
insert into help_relation (help_topic_id,help_keyword_id) values (405,79);
insert into help_relation (help_topic_id,help_keyword_id) values (87,79);
insert into help_relation (help_topic_id,help_keyword_id) values (301,80);
insert into help_relation (help_topic_id,help_keyword_id) values (3,80);
insert into help_relation (help_topic_id,help_keyword_id) values (353,80);
insert into help_relation (help_topic_id,help_keyword_id) values (102,80);
insert into help_relation (help_topic_id,help_keyword_id) values (464,81);
insert into help_relation (help_topic_id,help_keyword_id) values (253,82);
insert into help_relation (help_topic_id,help_keyword_id) values (191,83);
insert into help_relation (help_topic_id,help_keyword_id) values (374,84);
insert into help_relation (help_topic_id,help_keyword_id) values (127,85);
insert into help_relation (help_topic_id,help_keyword_id) values (143,86);
insert into help_relation (help_topic_id,help_keyword_id) values (457,86);
insert into help_relation (help_topic_id,help_keyword_id) values (207,87);
insert into help_relation (help_topic_id,help_keyword_id) values (18,88);
insert into help_relation (help_topic_id,help_keyword_id) values (344,88);
insert into help_relation (help_topic_id,help_keyword_id) values (437,88);
insert into help_relation (help_topic_id,help_keyword_id) values (299,88);
insert into help_relation (help_topic_id,help_keyword_id) values (484,88);
insert into help_relation (help_topic_id,help_keyword_id) values (415,88);
insert into help_relation (help_topic_id,help_keyword_id) values (325,88);
insert into help_relation (help_topic_id,help_keyword_id) values (353,88);
insert into help_relation (help_topic_id,help_keyword_id) values (183,88);
insert into help_relation (help_topic_id,help_keyword_id) values (187,89);
insert into help_relation (help_topic_id,help_keyword_id) values (97,89);
insert into help_relation (help_topic_id,help_keyword_id) values (420,90);
insert into help_relation (help_topic_id,help_keyword_id) values (459,90);
insert into help_relation (help_topic_id,help_keyword_id) values (86,91);
insert into help_relation (help_topic_id,help_keyword_id) values (400,92);
insert into help_relation (help_topic_id,help_keyword_id) values (464,92);
insert into help_relation (help_topic_id,help_keyword_id) values (67,93);
insert into help_relation (help_topic_id,help_keyword_id) values (431,93);
insert into help_relation (help_topic_id,help_keyword_id) values (326,93);
insert into help_relation (help_topic_id,help_keyword_id) values (282,94);
insert into help_relation (help_topic_id,help_keyword_id) values (83,95);
insert into help_relation (help_topic_id,help_keyword_id) values (57,95);
insert into help_relation (help_topic_id,help_keyword_id) values (28,95);
insert into help_relation (help_topic_id,help_keyword_id) values (192,96);
insert into help_relation (help_topic_id,help_keyword_id) values (102,96);
insert into help_relation (help_topic_id,help_keyword_id) values (482,96);
insert into help_relation (help_topic_id,help_keyword_id) values (298,96);
insert into help_relation (help_topic_id,help_keyword_id) values (344,97);
insert into help_relation (help_topic_id,help_keyword_id) values (279,97);
insert into help_relation (help_topic_id,help_keyword_id) values (310,98);
insert into help_relation (help_topic_id,help_keyword_id) values (104,98);
insert into help_relation (help_topic_id,help_keyword_id) values (469,99);
insert into help_relation (help_topic_id,help_keyword_id) values (374,100);
insert into help_relation (help_topic_id,help_keyword_id) values (152,101);
insert into help_relation (help_topic_id,help_keyword_id) values (30,101);
insert into help_relation (help_topic_id,help_keyword_id) values (87,101);
insert into help_relation (help_topic_id,help_keyword_id) values (297,101);
insert into help_relation (help_topic_id,help_keyword_id) values (185,101);
insert into help_relation (help_topic_id,help_keyword_id) values (9,101);
insert into help_relation (help_topic_id,help_keyword_id) values (273,101);
insert into help_relation (help_topic_id,help_keyword_id) values (344,102);
insert into help_relation (help_topic_id,help_keyword_id) values (364,102);
insert into help_relation (help_topic_id,help_keyword_id) values (143,103);
insert into help_relation (help_topic_id,help_keyword_id) values (457,103);
insert into help_relation (help_topic_id,help_keyword_id) values (86,104);
insert into help_relation (help_topic_id,help_keyword_id) values (24,104);
insert into help_relation (help_topic_id,help_keyword_id) values (110,105);
insert into help_relation (help_topic_id,help_keyword_id) values (172,105);
insert into help_relation (help_topic_id,help_keyword_id) values (3,106);
insert into help_relation (help_topic_id,help_keyword_id) values (152,106);
insert into help_relation (help_topic_id,help_keyword_id) values (464,106);
insert into help_relation (help_topic_id,help_keyword_id) values (196,106);
insert into help_relation (help_topic_id,help_keyword_id) values (209,106);
insert into help_relation (help_topic_id,help_keyword_id) values (102,106);
insert into help_relation (help_topic_id,help_keyword_id) values (239,106);
insert into help_relation (help_topic_id,help_keyword_id) values (459,106);
insert into help_relation (help_topic_id,help_keyword_id) values (459,107);
insert into help_relation (help_topic_id,help_keyword_id) values (462,108);
insert into help_relation (help_topic_id,help_keyword_id) values (324,108);
insert into help_relation (help_topic_id,help_keyword_id) values (112,108);
insert into help_relation (help_topic_id,help_keyword_id) values (466,108);
insert into help_relation (help_topic_id,help_keyword_id) values (112,109);
insert into help_relation (help_topic_id,help_keyword_id) values (459,109);
insert into help_relation (help_topic_id,help_keyword_id) values (38,110);
insert into help_relation (help_topic_id,help_keyword_id) values (116,110);
insert into help_relation (help_topic_id,help_keyword_id) values (261,110);
insert into help_relation (help_topic_id,help_keyword_id) values (148,110);
insert into help_relation (help_topic_id,help_keyword_id) values (122,111);
insert into help_relation (help_topic_id,help_keyword_id) values (418,112);
insert into help_relation (help_topic_id,help_keyword_id) values (405,113);
insert into help_relation (help_topic_id,help_keyword_id) values (87,113);
insert into help_relation (help_topic_id,help_keyword_id) values (123,113);
insert into help_relation (help_topic_id,help_keyword_id) values (492,113);
insert into help_relation (help_topic_id,help_keyword_id) values (218,114);
insert into help_relation (help_topic_id,help_keyword_id) values (330,115);
insert into help_relation (help_topic_id,help_keyword_id) values (127,115);
insert into help_relation (help_topic_id,help_keyword_id) values (3,115);
insert into help_relation (help_topic_id,help_keyword_id) values (152,115);
insert into help_relation (help_topic_id,help_keyword_id) values (490,115);
insert into help_relation (help_topic_id,help_keyword_id) values (209,115);
insert into help_relation (help_topic_id,help_keyword_id) values (102,115);
insert into help_relation (help_topic_id,help_keyword_id) values (459,115);
insert into help_relation (help_topic_id,help_keyword_id) values (136,115);
insert into help_relation (help_topic_id,help_keyword_id) values (344,115);
insert into help_relation (help_topic_id,help_keyword_id) values (464,115);
insert into help_relation (help_topic_id,help_keyword_id) values (81,115);
insert into help_relation (help_topic_id,help_keyword_id) values (143,115);
insert into help_relation (help_topic_id,help_keyword_id) values (468,115);
insert into help_relation (help_topic_id,help_keyword_id) values (180,115);
insert into help_relation (help_topic_id,help_keyword_id) values (353,115);
insert into help_relation (help_topic_id,help_keyword_id) values (420,115);
insert into help_relation (help_topic_id,help_keyword_id) values (473,115);
insert into help_relation (help_topic_id,help_keyword_id) values (197,116);
insert into help_relation (help_topic_id,help_keyword_id) values (259,117);
insert into help_relation (help_topic_id,help_keyword_id) values (129,117);
insert into help_relation (help_topic_id,help_keyword_id) values (226,117);
insert into help_relation (help_topic_id,help_keyword_id) values (374,117);
insert into help_relation (help_topic_id,help_keyword_id) values (344,118);
insert into help_relation (help_topic_id,help_keyword_id) values (333,118);
insert into help_relation (help_topic_id,help_keyword_id) values (364,118);
insert into help_relation (help_topic_id,help_keyword_id) values (220,118);
insert into help_relation (help_topic_id,help_keyword_id) values (399,118);
insert into help_relation (help_topic_id,help_keyword_id) values (58,118);
insert into help_relation (help_topic_id,help_keyword_id) values (325,118);
insert into help_relation (help_topic_id,help_keyword_id) values (133,118);
insert into help_relation (help_topic_id,help_keyword_id) values (212,118);
insert into help_relation (help_topic_id,help_keyword_id) values (464,119);
insert into help_relation (help_topic_id,help_keyword_id) values (207,119);
insert into help_relation (help_topic_id,help_keyword_id) values (459,119);
insert into help_relation (help_topic_id,help_keyword_id) values (191,120);
insert into help_relation (help_topic_id,help_keyword_id) values (405,120);
insert into help_relation (help_topic_id,help_keyword_id) values (87,120);
insert into help_relation (help_topic_id,help_keyword_id) values (464,120);
insert into help_relation (help_topic_id,help_keyword_id) values (184,121);
insert into help_relation (help_topic_id,help_keyword_id) values (1,122);
insert into help_relation (help_topic_id,help_keyword_id) values (52,123);
insert into help_relation (help_topic_id,help_keyword_id) values (184,124);
insert into help_relation (help_topic_id,help_keyword_id) values (464,125);
insert into help_relation (help_topic_id,help_keyword_id) values (311,126);
insert into help_relation (help_topic_id,help_keyword_id) values (197,127);
insert into help_relation (help_topic_id,help_keyword_id) values (453,128);
insert into help_relation (help_topic_id,help_keyword_id) values (251,129);
insert into help_relation (help_topic_id,help_keyword_id) values (282,130);
insert into help_relation (help_topic_id,help_keyword_id) values (245,131);
insert into help_relation (help_topic_id,help_keyword_id) values (197,131);
insert into help_relation (help_topic_id,help_keyword_id) values (459,132);
insert into help_relation (help_topic_id,help_keyword_id) values (83,133);
insert into help_relation (help_topic_id,help_keyword_id) values (57,133);
insert into help_relation (help_topic_id,help_keyword_id) values (233,134);
insert into help_relation (help_topic_id,help_keyword_id) values (52,135);
insert into help_relation (help_topic_id,help_keyword_id) values (321,135);
insert into help_relation (help_topic_id,help_keyword_id) values (83,136);
insert into help_relation (help_topic_id,help_keyword_id) values (57,136);
insert into help_relation (help_topic_id,help_keyword_id) values (197,137);
insert into help_relation (help_topic_id,help_keyword_id) values (310,138);
insert into help_relation (help_topic_id,help_keyword_id) values (344,139);
insert into help_relation (help_topic_id,help_keyword_id) values (115,139);
insert into help_relation (help_topic_id,help_keyword_id) values (453,139);
insert into help_relation (help_topic_id,help_keyword_id) values (48,139);
insert into help_relation (help_topic_id,help_keyword_id) values (120,139);
insert into help_relation (help_topic_id,help_keyword_id) values (353,139);
insert into help_relation (help_topic_id,help_keyword_id) values (358,139);
insert into help_relation (help_topic_id,help_keyword_id) values (445,140);
insert into help_relation (help_topic_id,help_keyword_id) values (36,140);
insert into help_relation (help_topic_id,help_keyword_id) values (104,140);
insert into help_relation (help_topic_id,help_keyword_id) values (1,141);
insert into help_relation (help_topic_id,help_keyword_id) values (28,142);
insert into help_relation (help_topic_id,help_keyword_id) values (374,143);
insert into help_relation (help_topic_id,help_keyword_id) values (464,144);
insert into help_relation (help_topic_id,help_keyword_id) values (177,145);
insert into help_relation (help_topic_id,help_keyword_id) values (206,146);
insert into help_relation (help_topic_id,help_keyword_id) values (310,147);
insert into help_relation (help_topic_id,help_keyword_id) values (344,147);
insert into help_relation (help_topic_id,help_keyword_id) values (178,147);
insert into help_relation (help_topic_id,help_keyword_id) values (353,147);
insert into help_relation (help_topic_id,help_keyword_id) values (419,147);
insert into help_relation (help_topic_id,help_keyword_id) values (344,148);
insert into help_relation (help_topic_id,help_keyword_id) values (326,148);
insert into help_relation (help_topic_id,help_keyword_id) values (464,149);
insert into help_relation (help_topic_id,help_keyword_id) values (178,150);
insert into help_relation (help_topic_id,help_keyword_id) values (95,151);
insert into help_relation (help_topic_id,help_keyword_id) values (420,152);
insert into help_relation (help_topic_id,help_keyword_id) values (66,153);
insert into help_relation (help_topic_id,help_keyword_id) values (344,153);
insert into help_relation (help_topic_id,help_keyword_id) values (333,153);
insert into help_relation (help_topic_id,help_keyword_id) values (34,153);
insert into help_relation (help_topic_id,help_keyword_id) values (95,153);
insert into help_relation (help_topic_id,help_keyword_id) values (299,153);
insert into help_relation (help_topic_id,help_keyword_id) values (415,153);
insert into help_relation (help_topic_id,help_keyword_id) values (391,153);
insert into help_relation (help_topic_id,help_keyword_id) values (208,153);
insert into help_relation (help_topic_id,help_keyword_id) values (404,153);
insert into help_relation (help_topic_id,help_keyword_id) values (229,153);
insert into help_relation (help_topic_id,help_keyword_id) values (95,154);
insert into help_relation (help_topic_id,help_keyword_id) values (344,155);
insert into help_relation (help_topic_id,help_keyword_id) values (420,155);
insert into help_relation (help_topic_id,help_keyword_id) values (248,156);
insert into help_relation (help_topic_id,help_keyword_id) values (464,157);
insert into help_relation (help_topic_id,help_keyword_id) values (464,158);
insert into help_relation (help_topic_id,help_keyword_id) values (459,158);
insert into help_relation (help_topic_id,help_keyword_id) values (191,159);
insert into help_relation (help_topic_id,help_keyword_id) values (474,159);
insert into help_relation (help_topic_id,help_keyword_id) values (60,159);
insert into help_relation (help_topic_id,help_keyword_id) values (459,159);
insert into help_relation (help_topic_id,help_keyword_id) values (173,160);
insert into help_relation (help_topic_id,help_keyword_id) values (165,161);
insert into help_relation (help_topic_id,help_keyword_id) values (191,162);
insert into help_relation (help_topic_id,help_keyword_id) values (474,162);
insert into help_relation (help_topic_id,help_keyword_id) values (414,162);
insert into help_relation (help_topic_id,help_keyword_id) values (459,162);
insert into help_relation (help_topic_id,help_keyword_id) values (452,163);
insert into help_relation (help_topic_id,help_keyword_id) values (30,163);
insert into help_relation (help_topic_id,help_keyword_id) values (156,163);
insert into help_relation (help_topic_id,help_keyword_id) values (445,164);
insert into help_relation (help_topic_id,help_keyword_id) values (420,165);
insert into help_relation (help_topic_id,help_keyword_id) values (48,166);
insert into help_relation (help_topic_id,help_keyword_id) values (353,166);
insert into help_relation (help_topic_id,help_keyword_id) values (81,166);
insert into help_relation (help_topic_id,help_keyword_id) values (459,166);
insert into help_relation (help_topic_id,help_keyword_id) values (360,166);
insert into help_relation (help_topic_id,help_keyword_id) values (1,167);
insert into help_relation (help_topic_id,help_keyword_id) values (84,167);
insert into help_relation (help_topic_id,help_keyword_id) values (48,167);
insert into help_relation (help_topic_id,help_keyword_id) values (248,168);
insert into help_relation (help_topic_id,help_keyword_id) values (245,169);
insert into help_relation (help_topic_id,help_keyword_id) values (197,169);
insert into help_relation (help_topic_id,help_keyword_id) values (311,170);
insert into help_relation (help_topic_id,help_keyword_id) values (496,170);
insert into help_relation (help_topic_id,help_keyword_id) values (206,170);
insert into help_relation (help_topic_id,help_keyword_id) values (226,170);
insert into help_relation (help_topic_id,help_keyword_id) values (24,170);
insert into help_relation (help_topic_id,help_keyword_id) values (165,170);
insert into help_relation (help_topic_id,help_keyword_id) values (126,170);
insert into help_relation (help_topic_id,help_keyword_id) values (153,171);
insert into help_relation (help_topic_id,help_keyword_id) values (95,171);
insert into help_relation (help_topic_id,help_keyword_id) values (226,171);
insert into help_relation (help_topic_id,help_keyword_id) values (410,172);
insert into help_relation (help_topic_id,help_keyword_id) values (344,173);
insert into help_relation (help_topic_id,help_keyword_id) values (468,174);
insert into help_relation (help_topic_id,help_keyword_id) values (469,174);
insert into help_relation (help_topic_id,help_keyword_id) values (464,174);
insert into help_relation (help_topic_id,help_keyword_id) values (459,174);
insert into help_relation (help_topic_id,help_keyword_id) values (301,175);
insert into help_relation (help_topic_id,help_keyword_id) values (99,175);
insert into help_relation (help_topic_id,help_keyword_id) values (148,175);
insert into help_relation (help_topic_id,help_keyword_id) values (142,176);
insert into help_relation (help_topic_id,help_keyword_id) values (344,176);
insert into help_relation (help_topic_id,help_keyword_id) values (143,177);
insert into help_relation (help_topic_id,help_keyword_id) values (344,178);
insert into help_relation (help_topic_id,help_keyword_id) values (157,178);
insert into help_relation (help_topic_id,help_keyword_id) values (453,179);
insert into help_relation (help_topic_id,help_keyword_id) values (143,180);
insert into help_relation (help_topic_id,help_keyword_id) values (310,181);
insert into help_relation (help_topic_id,help_keyword_id) values (178,181);
insert into help_relation (help_topic_id,help_keyword_id) values (419,181);
insert into help_relation (help_topic_id,help_keyword_id) values (196,181);
insert into help_relation (help_topic_id,help_keyword_id) values (301,182);
insert into help_relation (help_topic_id,help_keyword_id) values (115,182);
insert into help_relation (help_topic_id,help_keyword_id) values (420,182);
insert into help_relation (help_topic_id,help_keyword_id) values (358,182);
insert into help_relation (help_topic_id,help_keyword_id) values (353,183);
insert into help_relation (help_topic_id,help_keyword_id) values (226,184);
insert into help_relation (help_topic_id,help_keyword_id) values (375,184);
insert into help_relation (help_topic_id,help_keyword_id) values (464,185);
insert into help_relation (help_topic_id,help_keyword_id) values (152,186);
insert into help_relation (help_topic_id,help_keyword_id) values (464,186);
insert into help_relation (help_topic_id,help_keyword_id) values (209,186);
insert into help_relation (help_topic_id,help_keyword_id) values (393,187);
insert into help_relation (help_topic_id,help_keyword_id) values (461,188);
insert into help_relation (help_topic_id,help_keyword_id) values (127,189);
insert into help_relation (help_topic_id,help_keyword_id) values (445,189);
insert into help_relation (help_topic_id,help_keyword_id) values (180,189);
insert into help_relation (help_topic_id,help_keyword_id) values (346,189);
insert into help_relation (help_topic_id,help_keyword_id) values (133,189);
insert into help_relation (help_topic_id,help_keyword_id) values (450,190);
insert into help_relation (help_topic_id,help_keyword_id) values (83,191);
insert into help_relation (help_topic_id,help_keyword_id) values (57,191);
insert into help_relation (help_topic_id,help_keyword_id) values (464,192);
insert into help_relation (help_topic_id,help_keyword_id) values (353,193);
insert into help_relation (help_topic_id,help_keyword_id) values (1,194);
insert into help_relation (help_topic_id,help_keyword_id) values (36,194);
insert into help_relation (help_topic_id,help_keyword_id) values (353,194);
insert into help_relation (help_topic_id,help_keyword_id) values (420,195);
insert into help_relation (help_topic_id,help_keyword_id) values (197,196);
insert into help_relation (help_topic_id,help_keyword_id) values (143,197);
insert into help_relation (help_topic_id,help_keyword_id) values (245,198);
insert into help_relation (help_topic_id,help_keyword_id) values (344,199);
insert into help_relation (help_topic_id,help_keyword_id) values (189,199);
insert into help_relation (help_topic_id,help_keyword_id) values (1,200);
insert into help_relation (help_topic_id,help_keyword_id) values (218,201);
insert into help_relation (help_topic_id,help_keyword_id) values (251,202);
insert into help_relation (help_topic_id,help_keyword_id) values (86,203);
insert into help_relation (help_topic_id,help_keyword_id) values (464,203);
insert into help_relation (help_topic_id,help_keyword_id) values (207,203);
insert into help_relation (help_topic_id,help_keyword_id) values (197,203);
insert into help_relation (help_topic_id,help_keyword_id) values (459,203);
insert into help_relation (help_topic_id,help_keyword_id) values (459,204);
insert into help_relation (help_topic_id,help_keyword_id) values (257,205);
insert into help_relation (help_topic_id,help_keyword_id) values (464,206);
insert into help_relation (help_topic_id,help_keyword_id) values (420,206);
insert into help_relation (help_topic_id,help_keyword_id) values (405,207);
insert into help_relation (help_topic_id,help_keyword_id) values (87,207);
insert into help_relation (help_topic_id,help_keyword_id) values (459,207);
insert into help_relation (help_topic_id,help_keyword_id) values (288,208);
insert into help_relation (help_topic_id,help_keyword_id) values (353,209);
insert into help_relation (help_topic_id,help_keyword_id) values (3,210);
insert into help_relation (help_topic_id,help_keyword_id) values (36,210);
insert into help_relation (help_topic_id,help_keyword_id) values (48,210);
insert into help_relation (help_topic_id,help_keyword_id) values (102,210);
insert into help_relation (help_topic_id,help_keyword_id) values (81,210);
insert into help_relation (help_topic_id,help_keyword_id) values (420,210);
insert into help_relation (help_topic_id,help_keyword_id) values (197,211);
insert into help_relation (help_topic_id,help_keyword_id) values (191,212);
insert into help_relation (help_topic_id,help_keyword_id) values (344,213);
insert into help_relation (help_topic_id,help_keyword_id) values (152,213);
insert into help_relation (help_topic_id,help_keyword_id) values (306,213);
insert into help_relation (help_topic_id,help_keyword_id) values (185,213);
insert into help_relation (help_topic_id,help_keyword_id) values (209,213);
insert into help_relation (help_topic_id,help_keyword_id) values (95,214);
insert into help_relation (help_topic_id,help_keyword_id) values (274,215);
insert into help_relation (help_topic_id,help_keyword_id) values (276,216);
insert into help_relation (help_topic_id,help_keyword_id) values (460,217);
insert into help_relation (help_topic_id,help_keyword_id) values (344,218);
insert into help_relation (help_topic_id,help_keyword_id) values (1,218);
insert into help_relation (help_topic_id,help_keyword_id) values (464,218);
insert into help_relation (help_topic_id,help_keyword_id) values (301,218);
insert into help_relation (help_topic_id,help_keyword_id) values (85,218);
insert into help_relation (help_topic_id,help_keyword_id) values (99,218);
insert into help_relation (help_topic_id,help_keyword_id) values (60,218);
insert into help_relation (help_topic_id,help_keyword_id) values (305,218);
insert into help_relation (help_topic_id,help_keyword_id) values (207,218);
insert into help_relation (help_topic_id,help_keyword_id) values (459,218);
insert into help_relation (help_topic_id,help_keyword_id) values (356,219);
insert into help_relation (help_topic_id,help_keyword_id) values (423,220);
insert into help_relation (help_topic_id,help_keyword_id) values (405,221);
insert into help_relation (help_topic_id,help_keyword_id) values (87,221);
insert into help_relation (help_topic_id,help_keyword_id) values (184,222);
insert into help_relation (help_topic_id,help_keyword_id) values (459,223);
insert into help_relation (help_topic_id,help_keyword_id) values (462,224);
insert into help_relation (help_topic_id,help_keyword_id) values (251,224);
insert into help_relation (help_topic_id,help_keyword_id) values (269,225);
insert into help_relation (help_topic_id,help_keyword_id) values (1,226);
insert into help_relation (help_topic_id,help_keyword_id) values (344,227);
insert into help_relation (help_topic_id,help_keyword_id) values (7,227);
insert into help_relation (help_topic_id,help_keyword_id) values (253,228);
insert into help_relation (help_topic_id,help_keyword_id) values (428,228);
insert into help_relation (help_topic_id,help_keyword_id) values (191,229);
insert into help_relation (help_topic_id,help_keyword_id) values (223,229);
insert into help_relation (help_topic_id,help_keyword_id) values (353,229);
insert into help_relation (help_topic_id,help_keyword_id) values (425,230);
insert into help_relation (help_topic_id,help_keyword_id) values (85,231);
insert into help_relation (help_topic_id,help_keyword_id) values (207,231);
insert into help_relation (help_topic_id,help_keyword_id) values (459,231);
insert into help_relation (help_topic_id,help_keyword_id) values (310,232);
insert into help_relation (help_topic_id,help_keyword_id) values (311,233);
insert into help_relation (help_topic_id,help_keyword_id) values (496,233);
insert into help_relation (help_topic_id,help_keyword_id) values (206,233);
insert into help_relation (help_topic_id,help_keyword_id) values (24,233);
insert into help_relation (help_topic_id,help_keyword_id) values (165,233);
insert into help_relation (help_topic_id,help_keyword_id) values (126,233);
insert into help_relation (help_topic_id,help_keyword_id) values (197,234);
insert into help_relation (help_topic_id,help_keyword_id) values (184,235);
insert into help_relation (help_topic_id,help_keyword_id) values (469,236);
insert into help_relation (help_topic_id,help_keyword_id) values (184,237);
insert into help_relation (help_topic_id,help_keyword_id) values (383,238);
insert into help_relation (help_topic_id,help_keyword_id) values (330,239);
insert into help_relation (help_topic_id,help_keyword_id) values (344,239);
insert into help_relation (help_topic_id,help_keyword_id) values (152,239);
insert into help_relation (help_topic_id,help_keyword_id) values (428,239);
insert into help_relation (help_topic_id,help_keyword_id) values (464,239);
insert into help_relation (help_topic_id,help_keyword_id) values (253,239);
insert into help_relation (help_topic_id,help_keyword_id) values (209,239);
insert into help_relation (help_topic_id,help_keyword_id) values (353,239);
insert into help_relation (help_topic_id,help_keyword_id) values (420,239);
insert into help_relation (help_topic_id,help_keyword_id) values (184,240);
insert into help_relation (help_topic_id,help_keyword_id) values (273,241);
insert into help_relation (help_topic_id,help_keyword_id) values (275,241);
insert into help_relation (help_topic_id,help_keyword_id) values (400,241);
insert into help_relation (help_topic_id,help_keyword_id) values (212,241);
insert into help_relation (help_topic_id,help_keyword_id) values (459,241);
insert into help_relation (help_topic_id,help_keyword_id) values (462,241);
insert into help_relation (help_topic_id,help_keyword_id) values (344,241);
insert into help_relation (help_topic_id,help_keyword_id) values (107,241);
insert into help_relation (help_topic_id,help_keyword_id) values (464,241);
insert into help_relation (help_topic_id,help_keyword_id) values (318,241);
insert into help_relation (help_topic_id,help_keyword_id) values (112,241);
insert into help_relation (help_topic_id,help_keyword_id) values (466,241);
insert into help_relation (help_topic_id,help_keyword_id) values (177,241);
insert into help_relation (help_topic_id,help_keyword_id) values (416,241);
insert into help_relation (help_topic_id,help_keyword_id) values (60,241);
insert into help_relation (help_topic_id,help_keyword_id) values (356,241);
insert into help_relation (help_topic_id,help_keyword_id) values (358,241);
insert into help_relation (help_topic_id,help_keyword_id) values (191,242);
insert into help_relation (help_topic_id,help_keyword_id) values (474,242);
insert into help_relation (help_topic_id,help_keyword_id) values (344,242);
insert into help_relation (help_topic_id,help_keyword_id) values (364,242);
insert into help_relation (help_topic_id,help_keyword_id) values (464,242);
insert into help_relation (help_topic_id,help_keyword_id) values (414,242);
insert into help_relation (help_topic_id,help_keyword_id) values (459,242);
insert into help_relation (help_topic_id,help_keyword_id) values (464,243);
insert into help_relation (help_topic_id,help_keyword_id) values (468,244);
insert into help_relation (help_topic_id,help_keyword_id) values (30,244);
insert into help_relation (help_topic_id,help_keyword_id) values (464,244);
insert into help_relation (help_topic_id,help_keyword_id) values (273,244);
insert into help_relation (help_topic_id,help_keyword_id) values (184,245);
insert into help_relation (help_topic_id,help_keyword_id) values (353,246);
insert into help_relation (help_topic_id,help_keyword_id) values (302,247);
insert into help_relation (help_topic_id,help_keyword_id) values (464,248);
insert into help_relation (help_topic_id,help_keyword_id) values (307,249);
insert into help_relation (help_topic_id,help_keyword_id) values (459,250);
insert into help_relation (help_topic_id,help_keyword_id) values (86,251);
insert into help_relation (help_topic_id,help_keyword_id) values (184,252);
insert into help_relation (help_topic_id,help_keyword_id) values (353,253);
insert into help_relation (help_topic_id,help_keyword_id) values (327,254);
insert into help_relation (help_topic_id,help_keyword_id) values (353,254);
insert into help_relation (help_topic_id,help_keyword_id) values (360,254);
insert into help_relation (help_topic_id,help_keyword_id) values (312,255);
insert into help_relation (help_topic_id,help_keyword_id) values (373,255);
insert into help_relation (help_topic_id,help_keyword_id) values (226,255);
insert into help_relation (help_topic_id,help_keyword_id) values (206,256);
insert into help_relation (help_topic_id,help_keyword_id) values (86,257);
insert into help_relation (help_topic_id,help_keyword_id) values (419,258);
insert into help_relation (help_topic_id,help_keyword_id) values (66,259);
insert into help_relation (help_topic_id,help_keyword_id) values (484,259);
insert into help_relation (help_topic_id,help_keyword_id) values (242,260);
insert into help_relation (help_topic_id,help_keyword_id) values (143,261);
insert into help_relation (help_topic_id,help_keyword_id) values (191,262);
insert into help_relation (help_topic_id,help_keyword_id) values (223,262);
insert into help_relation (help_topic_id,help_keyword_id) values (324,263);
insert into help_relation (help_topic_id,help_keyword_id) values (148,263);
insert into help_relation (help_topic_id,help_keyword_id) values (452,264);
insert into help_relation (help_topic_id,help_keyword_id) values (191,264);
insert into help_relation (help_topic_id,help_keyword_id) values (152,264);
insert into help_relation (help_topic_id,help_keyword_id) values (95,264);
insert into help_relation (help_topic_id,help_keyword_id) values (299,264);
insert into help_relation (help_topic_id,help_keyword_id) values (275,264);
insert into help_relation (help_topic_id,help_keyword_id) values (306,264);
insert into help_relation (help_topic_id,help_keyword_id) values (208,264);
insert into help_relation (help_topic_id,help_keyword_id) values (207,264);
insert into help_relation (help_topic_id,help_keyword_id) values (75,264);
insert into help_relation (help_topic_id,help_keyword_id) values (18,264);
insert into help_relation (help_topic_id,help_keyword_id) values (344,264);
insert into help_relation (help_topic_id,help_keyword_id) values (22,264);
insert into help_relation (help_topic_id,help_keyword_id) values (464,264);
insert into help_relation (help_topic_id,help_keyword_id) values (469,264);
insert into help_relation (help_topic_id,help_keyword_id) values (391,264);
insert into help_relation (help_topic_id,help_keyword_id) values (87,264);
insert into help_relation (help_topic_id,help_keyword_id) values (60,264);
insert into help_relation (help_topic_id,help_keyword_id) values (355,264);
insert into help_relation (help_topic_id,help_keyword_id) values (327,265);
insert into help_relation (help_topic_id,help_keyword_id) values (191,266);
insert into help_relation (help_topic_id,help_keyword_id) values (197,267);
insert into help_relation (help_topic_id,help_keyword_id) values (230,268);
insert into help_relation (help_topic_id,help_keyword_id) values (344,269);
insert into help_relation (help_topic_id,help_keyword_id) values (449,269);
insert into help_relation (help_topic_id,help_keyword_id) values (87,270);
insert into help_relation (help_topic_id,help_keyword_id) values (39,271);
insert into help_relation (help_topic_id,help_keyword_id) values (344,271);
insert into help_relation (help_topic_id,help_keyword_id) values (266,271);
insert into help_relation (help_topic_id,help_keyword_id) values (459,272);
insert into help_relation (help_topic_id,help_keyword_id) values (464,273);
insert into help_relation (help_topic_id,help_keyword_id) values (376,274);
insert into help_relation (help_topic_id,help_keyword_id) values (144,275);
insert into help_relation (help_topic_id,help_keyword_id) values (105,276);
insert into help_relation (help_topic_id,help_keyword_id) values (462,277);
insert into help_relation (help_topic_id,help_keyword_id) values (459,277);
insert into help_relation (help_topic_id,help_keyword_id) values (464,278);
insert into help_relation (help_topic_id,help_keyword_id) values (416,279);
insert into help_relation (help_topic_id,help_keyword_id) values (3,280);
insert into help_relation (help_topic_id,help_keyword_id) values (102,280);
insert into help_relation (help_topic_id,help_keyword_id) values (336,281);
insert into help_relation (help_topic_id,help_keyword_id) values (341,282);
insert into help_relation (help_topic_id,help_keyword_id) values (253,283);
insert into help_relation (help_topic_id,help_keyword_id) values (266,284);
insert into help_relation (help_topic_id,help_keyword_id) values (318,285);
insert into help_relation (help_topic_id,help_keyword_id) values (190,286);
insert into help_relation (help_topic_id,help_keyword_id) values (66,286);
insert into help_relation (help_topic_id,help_keyword_id) values (330,286);
insert into help_relation (help_topic_id,help_keyword_id) values (67,286);
insert into help_relation (help_topic_id,help_keyword_id) values (333,286);
insert into help_relation (help_topic_id,help_keyword_id) values (7,286);
insert into help_relation (help_topic_id,help_keyword_id) values (130,286);
insert into help_relation (help_topic_id,help_keyword_id) values (399,286);
insert into help_relation (help_topic_id,help_keyword_id) values (275,286);
insert into help_relation (help_topic_id,help_keyword_id) values (10,286);
insert into help_relation (help_topic_id,help_keyword_id) values (279,286);
insert into help_relation (help_topic_id,help_keyword_id) values (133,286);
insert into help_relation (help_topic_id,help_keyword_id) values (212,286);
insert into help_relation (help_topic_id,help_keyword_id) values (18,286);
insert into help_relation (help_topic_id,help_keyword_id) values (344,286);
insert into help_relation (help_topic_id,help_keyword_id) values (21,286);
insert into help_relation (help_topic_id,help_keyword_id) values (346,286);
insert into help_relation (help_topic_id,help_keyword_id) values (80,286);
insert into help_relation (help_topic_id,help_keyword_id) values (220,286);
insert into help_relation (help_topic_id,help_keyword_id) values (25,286);
insert into help_relation (help_topic_id,help_keyword_id) values (142,286);
insert into help_relation (help_topic_id,help_keyword_id) values (291,286);
insert into help_relation (help_topic_id,help_keyword_id) values (355,286);
insert into help_relation (help_topic_id,help_keyword_id) values (33,286);
insert into help_relation (help_topic_id,help_keyword_id) values (364,286);
insert into help_relation (help_topic_id,help_keyword_id) values (157,286);
insert into help_relation (help_topic_id,help_keyword_id) values (484,286);
insert into help_relation (help_topic_id,help_keyword_id) values (483,286);
insert into help_relation (help_topic_id,help_keyword_id) values (39,286);
insert into help_relation (help_topic_id,help_keyword_id) values (306,286);
insert into help_relation (help_topic_id,help_keyword_id) values (488,286);
insert into help_relation (help_topic_id,help_keyword_id) values (305,286);
insert into help_relation (help_topic_id,help_keyword_id) values (167,286);
insert into help_relation (help_topic_id,help_keyword_id) values (58,286);
insert into help_relation (help_topic_id,help_keyword_id) values (391,286);
insert into help_relation (help_topic_id,help_keyword_id) values (325,286);
insert into help_relation (help_topic_id,help_keyword_id) values (326,286);
insert into help_relation (help_topic_id,help_keyword_id) values (120,286);
insert into help_relation (help_topic_id,help_keyword_id) values (189,286);
insert into help_relation (help_topic_id,help_keyword_id) values (449,286);
insert into help_relation (help_topic_id,help_keyword_id) values (302,287);
insert into help_relation (help_topic_id,help_keyword_id) values (245,287);
insert into help_relation (help_topic_id,help_keyword_id) values (353,287);
insert into help_relation (help_topic_id,help_keyword_id) values (197,287);
insert into help_relation (help_topic_id,help_keyword_id) values (464,288);
insert into help_relation (help_topic_id,help_keyword_id) values (324,289);
insert into help_relation (help_topic_id,help_keyword_id) values (464,290);
insert into help_relation (help_topic_id,help_keyword_id) values (120,291);
insert into help_relation (help_topic_id,help_keyword_id) values (347,291);
insert into help_relation (help_topic_id,help_keyword_id) values (83,292);
insert into help_relation (help_topic_id,help_keyword_id) values (57,292);
insert into help_relation (help_topic_id,help_keyword_id) values (28,292);
insert into help_relation (help_topic_id,help_keyword_id) values (323,292);
insert into help_relation (help_topic_id,help_keyword_id) values (341,292);
insert into help_relation (help_topic_id,help_keyword_id) values (492,292);
insert into help_relation (help_topic_id,help_keyword_id) values (228,292);
insert into help_relation (help_topic_id,help_keyword_id) values (374,293);
insert into help_relation (help_topic_id,help_keyword_id) values (144,294);
insert into help_relation (help_topic_id,help_keyword_id) values (313,294);
insert into help_relation (help_topic_id,help_keyword_id) values (311,295);
insert into help_relation (help_topic_id,help_keyword_id) values (104,296);
insert into help_relation (help_topic_id,help_keyword_id) values (374,297);
insert into help_relation (help_topic_id,help_keyword_id) values (256,298);
insert into help_relation (help_topic_id,help_keyword_id) values (3,298);
insert into help_relation (help_topic_id,help_keyword_id) values (353,298);
insert into help_relation (help_topic_id,help_keyword_id) values (102,298);
insert into help_relation (help_topic_id,help_keyword_id) values (298,298);
insert into help_relation (help_topic_id,help_keyword_id) values (251,298);
insert into help_relation (help_topic_id,help_keyword_id) values (344,299);
insert into help_relation (help_topic_id,help_keyword_id) values (157,299);
insert into help_relation (help_topic_id,help_keyword_id) values (138,300);
insert into help_relation (help_topic_id,help_keyword_id) values (197,301);
insert into help_relation (help_topic_id,help_keyword_id) values (75,301);
insert into help_relation (help_topic_id,help_keyword_id) values (469,302);
insert into help_relation (help_topic_id,help_keyword_id) values (184,303);
insert into help_relation (help_topic_id,help_keyword_id) values (180,304);
insert into help_relation (help_topic_id,help_keyword_id) values (453,305);
insert into help_relation (help_topic_id,help_keyword_id) values (108,306);
insert into help_relation (help_topic_id,help_keyword_id) values (24,306);
insert into help_relation (help_topic_id,help_keyword_id) values (374,307);
insert into help_relation (help_topic_id,help_keyword_id) values (184,308);
insert into help_relation (help_topic_id,help_keyword_id) values (420,309);
insert into help_relation (help_topic_id,help_keyword_id) values (388,310);
insert into help_relation (help_topic_id,help_keyword_id) values (117,310);
insert into help_relation (help_topic_id,help_keyword_id) values (459,311);
insert into help_relation (help_topic_id,help_keyword_id) values (25,312);
insert into help_relation (help_topic_id,help_keyword_id) values (344,312);
insert into help_relation (help_topic_id,help_keyword_id) values (197,313);
insert into help_relation (help_topic_id,help_keyword_id) values (372,314);
insert into help_relation (help_topic_id,help_keyword_id) values (469,314);
insert into help_relation (help_topic_id,help_keyword_id) values (143,315);
insert into help_relation (help_topic_id,help_keyword_id) values (184,316);
insert into help_relation (help_topic_id,help_keyword_id) values (374,317);
insert into help_relation (help_topic_id,help_keyword_id) values (197,318);
insert into help_relation (help_topic_id,help_keyword_id) values (344,319);
insert into help_relation (help_topic_id,help_keyword_id) values (376,319);
insert into help_relation (help_topic_id,help_keyword_id) values (344,320);
insert into help_relation (help_topic_id,help_keyword_id) values (288,320);
insert into help_relation (help_topic_id,help_keyword_id) values (418,320);
insert into help_relation (help_topic_id,help_keyword_id) values (381,321);
insert into help_relation (help_topic_id,help_keyword_id) values (86,322);
insert into help_relation (help_topic_id,help_keyword_id) values (120,322);
insert into help_relation (help_topic_id,help_keyword_id) values (353,322);
insert into help_relation (help_topic_id,help_keyword_id) values (459,323);
insert into help_relation (help_topic_id,help_keyword_id) values (353,324);
insert into help_relation (help_topic_id,help_keyword_id) values (197,325);
insert into help_relation (help_topic_id,help_keyword_id) values (84,326);
insert into help_relation (help_topic_id,help_keyword_id) values (197,326);
insert into help_relation (help_topic_id,help_keyword_id) values (353,327);
insert into help_relation (help_topic_id,help_keyword_id) values (395,328);
insert into help_relation (help_topic_id,help_keyword_id) values (86,329);
insert into help_relation (help_topic_id,help_keyword_id) values (173,329);
insert into help_relation (help_topic_id,help_keyword_id) values (148,329);
insert into help_relation (help_topic_id,help_keyword_id) values (184,330);
insert into help_relation (help_topic_id,help_keyword_id) values (420,331);
insert into help_relation (help_topic_id,help_keyword_id) values (52,332);
insert into help_relation (help_topic_id,help_keyword_id) values (321,332);
insert into help_relation (help_topic_id,help_keyword_id) values (372,333);
insert into help_relation (help_topic_id,help_keyword_id) values (469,333);
insert into help_relation (help_topic_id,help_keyword_id) values (9,333);
insert into help_relation (help_topic_id,help_keyword_id) values (197,334);
insert into help_relation (help_topic_id,help_keyword_id) values (184,335);
insert into help_relation (help_topic_id,help_keyword_id) values (121,336);
insert into help_relation (help_topic_id,help_keyword_id) values (143,337);
insert into help_relation (help_topic_id,help_keyword_id) values (445,337);
insert into help_relation (help_topic_id,help_keyword_id) values (374,338);
insert into help_relation (help_topic_id,help_keyword_id) values (406,339);
insert into help_relation (help_topic_id,help_keyword_id) values (374,340);
insert into help_relation (help_topic_id,help_keyword_id) values (459,341);
insert into help_relation (help_topic_id,help_keyword_id) values (141,342);
insert into help_relation (help_topic_id,help_keyword_id) values (24,343);
insert into help_relation (help_topic_id,help_keyword_id) values (405,344);
insert into help_relation (help_topic_id,help_keyword_id) values (107,344);
insert into help_relation (help_topic_id,help_keyword_id) values (219,344);
insert into help_relation (help_topic_id,help_keyword_id) values (459,344);
insert into help_relation (help_topic_id,help_keyword_id) values (464,345);
insert into help_relation (help_topic_id,help_keyword_id) values (207,345);
insert into help_relation (help_topic_id,help_keyword_id) values (459,345);
insert into help_relation (help_topic_id,help_keyword_id) values (1,346);
insert into help_relation (help_topic_id,help_keyword_id) values (474,347);
insert into help_relation (help_topic_id,help_keyword_id) values (405,347);
insert into help_relation (help_topic_id,help_keyword_id) values (437,347);
insert into help_relation (help_topic_id,help_keyword_id) values (156,347);
insert into help_relation (help_topic_id,help_keyword_id) values (197,347);
insert into help_relation (help_topic_id,help_keyword_id) values (372,347);
insert into help_relation (help_topic_id,help_keyword_id) values (223,347);
insert into help_relation (help_topic_id,help_keyword_id) values (60,347);
insert into help_relation (help_topic_id,help_keyword_id) values (209,347);
insert into help_relation (help_topic_id,help_keyword_id) values (229,347);
insert into help_relation (help_topic_id,help_keyword_id) values (459,347);
insert into help_relation (help_topic_id,help_keyword_id) values (464,348);
insert into help_relation (help_topic_id,help_keyword_id) values (469,349);
insert into help_relation (help_topic_id,help_keyword_id) values (1,350);
insert into help_relation (help_topic_id,help_keyword_id) values (353,350);
insert into help_relation (help_topic_id,help_keyword_id) values (1,351);
insert into help_relation (help_topic_id,help_keyword_id) values (344,352);
insert into help_relation (help_topic_id,help_keyword_id) values (346,352);
insert into help_relation (help_topic_id,help_keyword_id) values (420,353);
insert into help_relation (help_topic_id,help_keyword_id) values (425,354);
insert into help_relation (help_topic_id,help_keyword_id) values (464,355);
insert into help_relation (help_topic_id,help_keyword_id) values (469,356);
insert into help_relation (help_topic_id,help_keyword_id) values (473,356);
insert into help_relation (help_topic_id,help_keyword_id) values (197,356);
insert into help_relation (help_topic_id,help_keyword_id) values (75,356);
insert into help_relation (help_topic_id,help_keyword_id) values (353,357);
insert into help_relation (help_topic_id,help_keyword_id) values (461,358);
insert into help_relation (help_topic_id,help_keyword_id) values (226,358);
insert into help_relation (help_topic_id,help_keyword_id) values (104,359);
insert into help_relation (help_topic_id,help_keyword_id) values (490,360);
insert into help_relation (help_topic_id,help_keyword_id) values (67,361);
insert into help_relation (help_topic_id,help_keyword_id) values (344,361);
insert into help_relation (help_topic_id,help_keyword_id) values (273,362);
insert into help_relation (help_topic_id,help_keyword_id) values (445,363);
insert into help_relation (help_topic_id,help_keyword_id) values (353,364);
insert into help_relation (help_topic_id,help_keyword_id) values (416,365);
insert into help_relation (help_topic_id,help_keyword_id) values (209,365);
insert into help_relation (help_topic_id,help_keyword_id) values (143,366);
insert into help_relation (help_topic_id,help_keyword_id) values (323,366);
insert into help_relation (help_topic_id,help_keyword_id) values (464,367);
insert into help_relation (help_topic_id,help_keyword_id) values (483,368);
insert into help_relation (help_topic_id,help_keyword_id) values (416,369);
insert into help_relation (help_topic_id,help_keyword_id) values (87,370);
insert into help_relation (help_topic_id,help_keyword_id) values (374,370);
insert into help_relation (help_topic_id,help_keyword_id) values (197,371);
insert into help_relation (help_topic_id,help_keyword_id) values (374,372);
insert into help_relation (help_topic_id,help_keyword_id) values (209,373);
insert into help_relation (help_topic_id,help_keyword_id) values (468,374);
insert into help_relation (help_topic_id,help_keyword_id) values (464,374);
insert into help_relation (help_topic_id,help_keyword_id) values (197,374);
insert into help_relation (help_topic_id,help_keyword_id) values (441,375);
insert into help_relation (help_topic_id,help_keyword_id) values (279,376);
insert into help_relation (help_topic_id,help_keyword_id) values (445,377);
insert into help_relation (help_topic_id,help_keyword_id) values (446,378);
insert into help_relation (help_topic_id,help_keyword_id) values (87,379);
insert into help_relation (help_topic_id,help_keyword_id) values (126,380);
insert into help_relation (help_topic_id,help_keyword_id) values (10,381);
insert into help_relation (help_topic_id,help_keyword_id) values (344,381);
insert into help_relation (help_topic_id,help_keyword_id) values (468,382);
insert into help_relation (help_topic_id,help_keyword_id) values (30,382);
insert into help_relation (help_topic_id,help_keyword_id) values (273,382);
insert into help_relation (help_topic_id,help_keyword_id) values (445,383);
insert into help_relation (help_topic_id,help_keyword_id) values (56,384);
insert into help_relation (help_topic_id,help_keyword_id) values (82,385);
insert into help_relation (help_topic_id,help_keyword_id) values (203,385);
insert into help_relation (help_topic_id,help_keyword_id) values (454,385);
insert into help_relation (help_topic_id,help_keyword_id) values (367,385);
insert into help_relation (help_topic_id,help_keyword_id) values (82,386);
insert into help_relation (help_topic_id,help_keyword_id) values (203,386);
insert into help_relation (help_topic_id,help_keyword_id) values (152,386);
insert into help_relation (help_topic_id,help_keyword_id) values (87,386);
insert into help_relation (help_topic_id,help_keyword_id) values (309,386);
insert into help_relation (help_topic_id,help_keyword_id) values (183,387);
insert into help_relation (help_topic_id,help_keyword_id) values (191,388);
insert into help_relation (help_topic_id,help_keyword_id) values (474,388);
insert into help_relation (help_topic_id,help_keyword_id) values (324,389);
insert into help_relation (help_topic_id,help_keyword_id) values (464,390);
insert into help_relation (help_topic_id,help_keyword_id) values (143,391);
insert into help_relation (help_topic_id,help_keyword_id) values (321,391);
insert into help_relation (help_topic_id,help_keyword_id) values (33,392);
insert into help_relation (help_topic_id,help_keyword_id) values (457,393);
insert into help_relation (help_topic_id,help_keyword_id) values (476,394);
insert into help_relation (help_topic_id,help_keyword_id) values (152,394);
insert into help_relation (help_topic_id,help_keyword_id) values (297,394);
insert into help_relation (help_topic_id,help_keyword_id) values (9,394);
insert into help_relation (help_topic_id,help_keyword_id) values (273,394);
insert into help_relation (help_topic_id,help_keyword_id) values (28,394);
insert into help_relation (help_topic_id,help_keyword_id) values (30,394);
insert into help_relation (help_topic_id,help_keyword_id) values (87,394);
insert into help_relation (help_topic_id,help_keyword_id) values (185,394);
insert into help_relation (help_topic_id,help_keyword_id) values (459,395);
insert into help_relation (help_topic_id,help_keyword_id) values (266,396);
insert into help_relation (help_topic_id,help_keyword_id) values (104,397);
insert into help_relation (help_topic_id,help_keyword_id) values (469,398);
insert into help_relation (help_topic_id,help_keyword_id) values (219,398);
insert into help_relation (help_topic_id,help_keyword_id) values (328,398);
insert into help_relation (help_topic_id,help_keyword_id) values (75,398);
insert into help_relation (help_topic_id,help_keyword_id) values (464,399);
insert into help_relation (help_topic_id,help_keyword_id) values (310,400);
insert into help_relation (help_topic_id,help_keyword_id) values (344,401);
insert into help_relation (help_topic_id,help_keyword_id) values (305,401);
insert into help_relation (help_topic_id,help_keyword_id) values (459,401);
insert into help_relation (help_topic_id,help_keyword_id) values (48,402);
insert into help_relation (help_topic_id,help_keyword_id) values (120,402);
insert into help_relation (help_topic_id,help_keyword_id) values (353,402);
insert into help_relation (help_topic_id,help_keyword_id) values (81,402);
insert into help_relation (help_topic_id,help_keyword_id) values (104,402);
insert into help_relation (help_topic_id,help_keyword_id) values (468,403);
insert into help_relation (help_topic_id,help_keyword_id) values (60,403);
insert into help_relation (help_topic_id,help_keyword_id) values (102,403);
insert into help_relation (help_topic_id,help_keyword_id) values (464,403);
insert into help_relation (help_topic_id,help_keyword_id) values (459,403);
insert into help_relation (help_topic_id,help_keyword_id) values (464,404);
insert into help_relation (help_topic_id,help_keyword_id) values (228,405);
insert into help_relation (help_topic_id,help_keyword_id) values (353,406);
insert into help_relation (help_topic_id,help_keyword_id) values (3,407);
insert into help_relation (help_topic_id,help_keyword_id) values (102,407);
insert into help_relation (help_topic_id,help_keyword_id) values (482,407);
insert into help_relation (help_topic_id,help_keyword_id) values (466,408);
insert into help_relation (help_topic_id,help_keyword_id) values (459,408);
insert into help_relation (help_topic_id,help_keyword_id) values (464,409);
insert into help_relation (help_topic_id,help_keyword_id) values (459,409);
insert into help_relation (help_topic_id,help_keyword_id) values (464,410);
insert into help_relation (help_topic_id,help_keyword_id) values (239,410);
insert into help_relation (help_topic_id,help_keyword_id) values (468,411);
insert into help_relation (help_topic_id,help_keyword_id) values (464,411);
insert into help_relation (help_topic_id,help_keyword_id) values (36,412);
insert into help_relation (help_topic_id,help_keyword_id) values (191,413);
insert into help_relation (help_topic_id,help_keyword_id) values (474,413);
insert into help_relation (help_topic_id,help_keyword_id) values (127,414);
insert into help_relation (help_topic_id,help_keyword_id) values (445,414);
insert into help_relation (help_topic_id,help_keyword_id) values (346,414);
insert into help_relation (help_topic_id,help_keyword_id) values (133,414);
insert into help_relation (help_topic_id,help_keyword_id) values (344,415);
insert into help_relation (help_topic_id,help_keyword_id) values (469,415);
insert into help_relation (help_topic_id,help_keyword_id) values (152,415);
insert into help_relation (help_topic_id,help_keyword_id) values (306,415);
insert into help_relation (help_topic_id,help_keyword_id) values (185,415);
insert into help_relation (help_topic_id,help_keyword_id) values (209,415);
insert into help_relation (help_topic_id,help_keyword_id) values (82,416);
insert into help_relation (help_topic_id,help_keyword_id) values (468,416);
insert into help_relation (help_topic_id,help_keyword_id) values (367,416);
insert into help_relation (help_topic_id,help_keyword_id) values (479,417);
insert into help_relation (help_topic_id,help_keyword_id) values (462,418);
insert into help_relation (help_topic_id,help_keyword_id) values (420,419);
insert into help_relation (help_topic_id,help_keyword_id) values (38,420);
insert into help_relation (help_topic_id,help_keyword_id) values (142,420);
insert into help_relation (help_topic_id,help_keyword_id) values (405,420);
insert into help_relation (help_topic_id,help_keyword_id) values (87,420);
insert into help_relation (help_topic_id,help_keyword_id) values (220,420);
insert into help_relation (help_topic_id,help_keyword_id) values (52,420);
insert into help_relation (help_topic_id,help_keyword_id) values (321,420);
insert into help_relation (help_topic_id,help_keyword_id) values (253,421);
insert into help_relation (help_topic_id,help_keyword_id) values (353,422);
insert into help_relation (help_topic_id,help_keyword_id) values (360,422);
insert into help_relation (help_topic_id,help_keyword_id) values (487,423);
insert into help_relation (help_topic_id,help_keyword_id) values (420,424);
insert into help_relation (help_topic_id,help_keyword_id) values (405,425);
insert into help_relation (help_topic_id,help_keyword_id) values (87,425);
insert into help_relation (help_topic_id,help_keyword_id) values (459,425);
insert into help_relation (help_topic_id,help_keyword_id) values (464,426);
insert into help_relation (help_topic_id,help_keyword_id) values (209,426);
insert into help_relation (help_topic_id,help_keyword_id) values (492,427);
insert into help_relation (help_topic_id,help_keyword_id) values (197,428);
insert into help_relation (help_topic_id,help_keyword_id) values (462,429);
insert into help_relation (help_topic_id,help_keyword_id) values (324,429);
insert into help_relation (help_topic_id,help_keyword_id) values (36,429);
insert into help_relation (help_topic_id,help_keyword_id) values (112,429);
insert into help_relation (help_topic_id,help_keyword_id) values (420,429);
insert into help_relation (help_topic_id,help_keyword_id) values (466,429);
insert into help_relation (help_topic_id,help_keyword_id) values (0,430);
insert into help_relation (help_topic_id,help_keyword_id) values (94,430);
insert into help_relation (help_topic_id,help_keyword_id) values (382,430);
insert into help_relation (help_topic_id,help_keyword_id) values (285,430);
insert into help_relation (help_topic_id,help_keyword_id) values (431,430);
insert into help_relation (help_topic_id,help_keyword_id) values (302,430);
insert into help_relation (help_topic_id,help_keyword_id) values (353,430);
insert into help_relation (help_topic_id,help_keyword_id) values (360,430);
insert into help_relation (help_topic_id,help_keyword_id) values (493,431);
insert into help_relation (help_topic_id,help_keyword_id) values (184,432);
insert into help_relation (help_topic_id,help_keyword_id) values (197,433);
insert into help_relation (help_topic_id,help_keyword_id) values (130,434);
insert into help_relation (help_topic_id,help_keyword_id) values (344,434);
insert into help_relation (help_topic_id,help_keyword_id) values (291,434);
insert into help_relation (help_topic_id,help_keyword_id) values (36,434);
insert into help_relation (help_topic_id,help_keyword_id) values (491,435);
insert into help_relation (help_topic_id,help_keyword_id) values (27,436);
insert into help_relation (help_topic_id,help_keyword_id) values (344,437);
insert into help_relation (help_topic_id,help_keyword_id) values (22,437);
insert into help_relation (help_topic_id,help_keyword_id) values (260,437);
insert into help_relation (help_topic_id,help_keyword_id) values (344,438);
insert into help_relation (help_topic_id,help_keyword_id) values (488,438);
insert into help_relation (help_topic_id,help_keyword_id) values (197,439);
insert into help_relation (help_topic_id,help_keyword_id) values (353,440);
insert into help_relation (help_topic_id,help_keyword_id) values (102,440);
insert into help_relation (help_topic_id,help_keyword_id) values (207,441);
insert into help_relation (help_topic_id,help_keyword_id) values (464,442);
insert into help_relation (help_topic_id,help_keyword_id) values (104,442);
insert into help_relation (help_topic_id,help_keyword_id) values (459,442);
insert into help_relation (help_topic_id,help_keyword_id) values (459,443);
insert into help_relation (help_topic_id,help_keyword_id) values (191,444);
insert into help_relation (help_topic_id,help_keyword_id) values (474,444);
insert into help_relation (help_topic_id,help_keyword_id) values (344,445);
insert into help_relation (help_topic_id,help_keyword_id) values (39,446);
insert into help_relation (help_topic_id,help_keyword_id) values (115,446);
insert into help_relation (help_topic_id,help_keyword_id) values (266,446);
insert into help_relation (help_topic_id,help_keyword_id) values (58,446);
insert into help_relation (help_topic_id,help_keyword_id) values (184,446);
insert into help_relation (help_topic_id,help_keyword_id) values (261,446);
insert into help_relation (help_topic_id,help_keyword_id) values (358,446);
insert into help_relation (help_topic_id,help_keyword_id) values (206,447);
insert into help_relation (help_topic_id,help_keyword_id) values (464,447);
insert into help_relation (help_topic_id,help_keyword_id) values (198,448);
insert into help_relation (help_topic_id,help_keyword_id) values (464,449);

