/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.base;

import info.aduna.iteration.Iteration;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.URL;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BooleanQuery;
import org.openrdf.query.GraphQuery;
import org.openrdf.query.MalformedQueryException;
import org.openrdf.query.Query;
import org.openrdf.query.QueryLanguage;
import org.openrdf.query.TupleQuery;
import org.openrdf.repository.DelegatingRepositoryConnection;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryConnection;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.RepositoryResult;
import org.openrdf.repository.base.RepositoryConnectionBase;
import org.openrdf.rio.RDFFormat;
import org.openrdf.rio.RDFHandler;
import org.openrdf.rio.RDFHandlerException;
import org.openrdf.rio.RDFParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RepositoryConnectionWrapper
extends RepositoryConnectionBase
implements DelegatingRepositoryConnection {
    private RepositoryConnection delegate;

    public RepositoryConnectionWrapper(Repository repository) {
        super(repository);
    }

    public RepositoryConnectionWrapper(Repository repository, RepositoryConnection delegate) {
        this(repository);
        this.setDelegate(delegate);
    }

    @Override
    public RepositoryConnection getDelegate() throws RepositoryException {
        return this.delegate;
    }

    @Override
    public void setDelegate(RepositoryConnection delegate) {
        this.delegate = delegate;
    }

    protected boolean isDelegatingAdd() throws RepositoryException {
        return true;
    }

    protected boolean isDelegatingRead() throws RepositoryException {
        return true;
    }

    protected boolean isDelegatingRemove() throws RepositoryException {
        return true;
    }

    @Override
    public void add(File file, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (this.isDelegatingAdd()) {
            this.getDelegate().add(file, baseURI, dataFormat, contexts);
        } else {
            super.add(file, baseURI, dataFormat, contexts);
        }
    }

    @Override
    public void add(InputStream in, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (this.isDelegatingAdd()) {
            this.getDelegate().add(in, baseURI, dataFormat, contexts);
        } else {
            super.add(in, baseURI, dataFormat, contexts);
        }
    }

    @Override
    public void add(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingAdd()) {
            this.getDelegate().add(statements, contexts);
        } else {
            super.add(statements, contexts);
        }
    }

    @Override
    public <E extends Exception> void add(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        if (this.isDelegatingAdd()) {
            this.getDelegate().add(statementIter, contexts);
        } else {
            super.add(statementIter, contexts);
        }
    }

    @Override
    public void add(Reader reader, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (this.isDelegatingAdd()) {
            this.getDelegate().add(reader, baseURI, dataFormat, contexts);
        } else {
            super.add(reader, baseURI, dataFormat, contexts);
        }
    }

    @Override
    public void add(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingAdd()) {
            this.getDelegate().add(subject, predicate, object, contexts);
        } else {
            super.add(subject, predicate, object, contexts);
        }
    }

    @Override
    public void add(Statement st, Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingAdd()) {
            this.getDelegate().add(st, contexts);
        } else {
            super.add(st, contexts);
        }
    }

    @Override
    public void add(URL url, String baseURI, RDFFormat dataFormat, Resource ... contexts) throws IOException, RDFParseException, RepositoryException {
        if (this.isDelegatingAdd()) {
            this.getDelegate().add(url, baseURI, dataFormat, contexts);
        } else {
            super.add(url, baseURI, dataFormat, contexts);
        }
    }

    @Override
    public void clear(Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingRemove()) {
            this.getDelegate().clear(contexts);
        } else {
            super.clear(contexts);
        }
    }

    @Override
    public void close() throws RepositoryException {
        this.getDelegate().close();
        super.close();
    }

    @Override
    public void commit() throws RepositoryException {
        this.getDelegate().commit();
    }

    @Override
    public void exportStatements(Resource subj, URI pred, Value obj, boolean includeInferred, RDFHandler handler, Resource ... contexts) throws RepositoryException, RDFHandlerException {
        if (this.isDelegatingRead()) {
            this.getDelegate().exportStatements(subj, pred, obj, includeInferred, handler, contexts);
        } else {
            this.exportStatements(this.getStatements(subj, pred, obj, includeInferred, contexts), handler);
        }
    }

    @Override
    public RepositoryResult<Resource> getContextIDs() throws RepositoryException {
        return this.getDelegate().getContextIDs();
    }

    @Override
    public String getNamespace(String prefix) throws RepositoryException {
        return this.getDelegate().getNamespace(prefix);
    }

    @Override
    public RepositoryResult<Namespace> getNamespaces() throws RepositoryException {
        return this.getDelegate().getNamespaces();
    }

    @Override
    public RepositoryResult<Statement> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        return this.getDelegate().getStatements(subj, pred, obj, includeInferred, contexts);
    }

    @Override
    public boolean hasStatement(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingRead()) {
            return this.getDelegate().hasStatement(subj, pred, obj, includeInferred, contexts);
        }
        return super.hasStatement(subj, pred, obj, includeInferred, contexts);
    }

    @Override
    public boolean hasStatement(Statement st, boolean includeInferred, Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingRead()) {
            return this.getDelegate().hasStatement(st, includeInferred, contexts);
        }
        return super.hasStatement(st, includeInferred, contexts);
    }

    @Override
    public boolean isAutoCommit() throws RepositoryException {
        return this.getDelegate().isAutoCommit();
    }

    @Override
    public boolean isEmpty() throws RepositoryException {
        if (this.isDelegatingRead()) {
            return this.getDelegate().isEmpty();
        }
        return super.isEmpty();
    }

    @Override
    public boolean isOpen() throws RepositoryException {
        return this.getDelegate().isOpen();
    }

    @Override
    public GraphQuery prepareGraphQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.getDelegate().prepareGraphQuery(ql, query, baseURI);
    }

    @Override
    public Query prepareQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.getDelegate().prepareQuery(ql, query, baseURI);
    }

    @Override
    public TupleQuery prepareTupleQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.getDelegate().prepareTupleQuery(ql, query, baseURI);
    }

    @Override
    public BooleanQuery prepareBooleanQuery(QueryLanguage ql, String query, String baseURI) throws MalformedQueryException, RepositoryException {
        return this.getDelegate().prepareBooleanQuery(ql, query, baseURI);
    }

    @Override
    public void remove(Iterable<? extends Statement> statements, Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingRemove()) {
            this.getDelegate().remove(statements, contexts);
        } else {
            super.remove(statements, contexts);
        }
    }

    @Override
    public <E extends Exception> void remove(Iteration<? extends Statement, E> statementIter, Resource ... contexts) throws RepositoryException, E {
        if (this.isDelegatingRemove()) {
            this.getDelegate().remove(statementIter, contexts);
        } else {
            super.remove(statementIter, contexts);
        }
    }

    @Override
    public void remove(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingRemove()) {
            this.getDelegate().remove(subject, predicate, object, contexts);
        } else {
            super.remove(subject, predicate, object, contexts);
        }
    }

    @Override
    public void remove(Statement st, Resource ... contexts) throws RepositoryException {
        if (this.isDelegatingRemove()) {
            this.getDelegate().remove(st, contexts);
        } else {
            super.remove(st, contexts);
        }
    }

    @Override
    public void removeNamespace(String prefix) throws RepositoryException {
        this.getDelegate().removeNamespace(prefix);
    }

    @Override
    public void clearNamespaces() throws RepositoryException {
        this.getDelegate().clearNamespaces();
    }

    @Override
    public void rollback() throws RepositoryException {
        this.getDelegate().rollback();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws RepositoryException {
        super.setAutoCommit(autoCommit);
        this.getDelegate().setAutoCommit(autoCommit);
    }

    @Override
    public void setNamespace(String prefix, String name) throws RepositoryException {
        this.getDelegate().setNamespace(prefix, name);
    }

    @Override
    public long size(Resource ... contexts) throws RepositoryException {
        return this.getDelegate().size(contexts);
    }

    @Override
    protected void addWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        super.add(subject, predicate, object, contexts);
    }

    @Override
    protected void removeWithoutCommit(Resource subject, URI predicate, Value object, Resource ... contexts) throws RepositoryException {
        super.remove(subject, predicate, object, contexts);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void exportStatements(RepositoryResult<Statement> stIter, RDFHandler handler) throws RepositoryException, RDFHandlerException {
        try {
            handler.startRDF();
            RepositoryResult<Namespace> nsIter = this.getNamespaces();
            try {
                while (nsIter.hasNext()) {
                    Namespace ns = (Namespace)nsIter.next();
                    handler.handleNamespace(ns.getPrefix(), ns.getName());
                }
            }
            finally {
                nsIter.close();
            }
            while (stIter.hasNext()) {
                handler.handleStatement((Statement)stIter.next());
            }
            handler.endRDF();
        }
        finally {
            stIter.close();
        }
    }
}

