/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sail.helpers;

import info.aduna.concurrent.locks.ExclusiveLockManager;
import info.aduna.concurrent.locks.Lock;
import info.aduna.concurrent.locks.ReadWriteLockManager;
import info.aduna.concurrent.locks.WritePrefReadWriteLockManager;
import info.aduna.iteration.CloseableIteration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.query.BindingSet;
import org.openrdf.query.Dataset;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.sail.SailConnection;
import org.openrdf.sail.SailConnectionListener;
import org.openrdf.sail.SailException;
import org.openrdf.sail.helpers.SailBase;
import org.openrdf.sail.helpers.SailBaseIteration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SailConnectionBase
implements SailConnection {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final SailBase sailBase;
    private boolean isOpen;
    private boolean txnActive;
    private final ReadWriteLockManager connectionLockManager = new WritePrefReadWriteLockManager();
    private final ExclusiveLockManager txnLockManager = new ExclusiveLockManager();
    private List<SailBaseIteration> activeIterations = Collections.synchronizedList(new LinkedList());
    private List<SailConnectionListener> listeners;

    public SailConnectionBase(SailBase sailBase) {
        this.sailBase = sailBase;
        this.isOpen = true;
        this.txnActive = false;
        this.listeners = new ArrayList<SailConnectionListener>(0);
    }

    @Override
    public final boolean isOpen() throws SailException {
        return this.isOpen;
    }

    protected void verifyIsOpen() throws SailException {
        if (!this.isOpen) {
            throw new IllegalStateException("Connection has been closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws SailException {
        block19: {
            Lock conLock = this.getExclusiveConnectionLock();
            try {
                if (!this.isOpen) break block19;
                try {
                    while (true) {
                        SailBaseIteration ci = null;
                        List<SailBaseIteration> list = this.activeIterations;
                        synchronized (list) {
                            if (this.activeIterations.isEmpty()) {
                                break;
                            }
                            ci = this.activeIterations.remove(0);
                        }
                        try {
                            ci.forceClose();
                        }
                        catch (SailException e) {
                            throw e;
                        }
                        catch (Exception e) {
                            throw new SailException(e);
                        }
                    }
                    assert (this.activeIterations.isEmpty());
                    if (this.txnActive) {
                        this.logger.warn("Rolling back transaction due to connection close", new Throwable());
                        try {
                            this.rollbackInternal();
                        }
                        finally {
                            this.txnActive = false;
                        }
                    }
                    this.closeInternal();
                }
                finally {
                    this.isOpen = false;
                    this.sailBase.connectionClosed(this);
                }
            }
            finally {
                conLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluate(TupleExpr tupleExpr, Dataset dataset, BindingSet bindings, boolean includeInferred) throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends BindingSet, QueryEvaluationException> closeableIteration = this.registerIteration(this.evaluateInternal(tupleExpr, dataset, bindings, includeInferred));
            return closeableIteration;
        }
        finally {
            conLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends Resource, SailException> getContextIDs() throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends Resource, SailException> closeableIteration = this.registerIteration(this.getContextIDsInternal());
            return closeableIteration;
        }
        finally {
            conLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends Statement, SailException> getStatements(Resource subj, URI pred, Value obj, boolean includeInferred, Resource ... contexts) throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends Statement, SailException> closeableIteration = this.registerIteration(this.getStatementsInternal(subj, pred, obj, includeInferred, contexts));
            return closeableIteration;
        }
        finally {
            conLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long size(Resource ... contexts) throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            this.verifyIsOpen();
            long l = this.sizeInternal(contexts);
            return l;
        }
        finally {
            conLock.release();
        }
    }

    protected final boolean transactionActive() {
        return this.txnActive;
    }

    protected void autoStartTransaction() throws SailException {
        if (!this.txnActive) {
            this.startTransactionInternal();
            this.txnActive = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void commit() throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            this.verifyIsOpen();
            Lock txnLock = this.getTransactionLock();
            try {
                if (this.txnActive) {
                    this.commitInternal();
                    this.txnActive = false;
                }
            }
            finally {
                txnLock.release();
            }
        }
        finally {
            conLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void rollback() throws SailException {
        block9: {
            Lock conLock = this.getSharedConnectionLock();
            try {
                this.verifyIsOpen();
                Lock txnLock = this.getTransactionLock();
                try {
                    if (!this.txnActive) break block9;
                    try {
                        this.rollbackInternal();
                    }
                    finally {
                        this.txnActive = false;
                    }
                }
                finally {
                    txnLock.release();
                }
            }
            finally {
                conLock.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void addStatement(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            this.verifyIsOpen();
            Lock txnLock = this.getTransactionLock();
            try {
                this.autoStartTransaction();
                this.addStatementInternal(subj, pred, obj, contexts);
            }
            finally {
                txnLock.release();
            }
        }
        finally {
            conLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeStatements(Resource subj, URI pred, Value obj, Resource ... contexts) throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            this.verifyIsOpen();
            Lock txnLock = this.getTransactionLock();
            try {
                this.autoStartTransaction();
                this.removeStatementsInternal(subj, pred, obj, contexts);
            }
            finally {
                txnLock.release();
            }
        }
        finally {
            conLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clear(Resource ... contexts) throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            this.verifyIsOpen();
            Lock txnLock = this.getTransactionLock();
            try {
                this.autoStartTransaction();
                this.clearInternal(contexts);
            }
            finally {
                txnLock.release();
            }
        }
        finally {
            conLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final CloseableIteration<? extends Namespace, SailException> getNamespaces() throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            this.verifyIsOpen();
            CloseableIteration<? extends Namespace, SailException> closeableIteration = this.registerIteration(this.getNamespacesInternal());
            return closeableIteration;
        }
        finally {
            conLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final String getNamespace(String prefix) throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            this.verifyIsOpen();
            String string = this.getNamespaceInternal(prefix);
            return string;
        }
        finally {
            conLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setNamespace(String prefix, String name) throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            this.verifyIsOpen();
            Lock txnLock = this.getTransactionLock();
            try {
                this.autoStartTransaction();
                this.setNamespaceInternal(prefix, name);
            }
            finally {
                txnLock.release();
            }
        }
        finally {
            conLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void removeNamespace(String prefix) throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            this.verifyIsOpen();
            Lock txnLock = this.getTransactionLock();
            try {
                this.autoStartTransaction();
                this.removeNamespaceInternal(prefix);
            }
            finally {
                txnLock.release();
            }
        }
        finally {
            conLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void clearNamespaces() throws SailException {
        Lock conLock = this.getSharedConnectionLock();
        try {
            this.verifyIsOpen();
            Lock txnLock = this.getTransactionLock();
            try {
                this.autoStartTransaction();
                this.clearNamespacesInternal();
            }
            finally {
                txnLock.release();
            }
        }
        finally {
            conLock.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addConnectionListener(SailConnectionListener listener) {
        List<SailConnectionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.add(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeConnectionListener(SailConnectionListener listener) {
        List<SailConnectionListener> list = this.listeners;
        synchronized (list) {
            this.listeners.remove(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean hasConnectionListeners() {
        List<SailConnectionListener> list = this.listeners;
        synchronized (list) {
            return !this.listeners.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStatementAdded(Statement st) {
        List<SailConnectionListener> list = this.listeners;
        synchronized (list) {
            for (SailConnectionListener listener : this.listeners) {
                listener.statementAdded(st);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyStatementRemoved(Statement st) {
        List<SailConnectionListener> list = this.listeners;
        synchronized (list) {
            for (SailConnectionListener listener : this.listeners) {
                listener.statementRemoved(st);
            }
        }
    }

    protected Lock getSharedConnectionLock() throws SailException {
        try {
            return this.connectionLockManager.getReadLock();
        }
        catch (InterruptedException e) {
            throw new SailException(e);
        }
    }

    protected Lock getExclusiveConnectionLock() throws SailException {
        try {
            return this.connectionLockManager.getWriteLock();
        }
        catch (InterruptedException e) {
            throw new SailException(e);
        }
    }

    protected Lock getTransactionLock() throws SailException {
        try {
            return this.txnLockManager.getExclusiveLock();
        }
        catch (InterruptedException e) {
            throw new SailException(e);
        }
    }

    protected <T, E extends Exception> CloseableIteration<T, E> registerIteration(CloseableIteration<T, E> iter) {
        SailBaseIteration<T, E> result = new SailBaseIteration<T, E>(iter, this);
        this.activeIterations.add(result);
        return result;
    }

    protected void iterationClosed(SailBaseIteration iter) {
        this.activeIterations.remove(iter);
    }

    protected abstract void closeInternal() throws SailException;

    protected abstract CloseableIteration<? extends BindingSet, QueryEvaluationException> evaluateInternal(TupleExpr var1, Dataset var2, BindingSet var3, boolean var4) throws SailException;

    protected abstract CloseableIteration<? extends Resource, SailException> getContextIDsInternal() throws SailException;

    protected abstract CloseableIteration<? extends Statement, SailException> getStatementsInternal(Resource var1, URI var2, Value var3, boolean var4, Resource ... var5) throws SailException;

    protected abstract long sizeInternal(Resource ... var1) throws SailException;

    protected abstract void startTransactionInternal() throws SailException;

    protected abstract void commitInternal() throws SailException;

    protected abstract void rollbackInternal() throws SailException;

    protected abstract void addStatementInternal(Resource var1, URI var2, Value var3, Resource ... var4) throws SailException;

    protected abstract void removeStatementsInternal(Resource var1, URI var2, Value var3, Resource ... var4) throws SailException;

    protected abstract void clearInternal(Resource ... var1) throws SailException;

    protected abstract CloseableIteration<? extends Namespace, SailException> getNamespacesInternal() throws SailException;

    protected abstract String getNamespaceInternal(String var1) throws SailException;

    protected abstract void setNamespaceInternal(String var1, String var2) throws SailException;

    protected abstract void removeNamespaceInternal(String var1) throws SailException;

    protected abstract void clearNamespacesInternal() throws SailException;
}

