/* 
 *
 * Copyright (C) 2006-2008 Sebastian Trueg <trueg@k3b.org>
 *
 * This file is part of the K3b project.
 * Copyright (C) 1998-2008 Sebastian Trueg <trueg@k3b.org>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * See the file "COPYING" for the exact licensing terms.
 */

#ifndef _K3B_THEMED_HEADER_H_
#define _K3B_THEMED_HEADER_H_

#include <QFrame>

#include "k3bthememanager.h"

class K3bTitleLabel;
class QLabel;

class K3bThemedHeader : public QFrame
{
    Q_OBJECT

public:
    K3bThemedHeader( QWidget* parent = 0 );
    K3bThemedHeader( const QString& title, const QString& subtitle, QWidget* parent = 0 );
    ~K3bThemedHeader(); 

public Q_SLOTS:
    void setTitle( const QString& title, const QString& subtitle = QString() );
    void setSubTitle( const QString& subtitle );
    void setAlignment( int );
    void setLeftPixmap( K3bTheme::PixmapType );
    void setRightPixmap( K3bTheme::PixmapType );

private Q_SLOTS:
    void slotThemeChanged();

private:
    void init();

    K3bTitleLabel* m_titleLabel;
    QLabel* m_leftLabel;
    QLabel* m_rightLabel;
    K3bTheme::PixmapType m_leftPix;
    K3bTheme::PixmapType m_rightPix;
};

#endif
